/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.net.http.CharArrayBuffers;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import org.apache.http.HeaderElement;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.http.message.ParserCursor;
import org.apache.http.util.CharArrayBuffer;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Headers
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOGTAG = "Http";
    public static int CONN_CLOSE = 1;
    public static int CONN_KEEP_ALIVE = 2;
    public static int NO_CONN_TYPE = 0;
    public static long NO_TRANSFER_ENCODING = 0L;
    public static long NO_CONTENT_LENGTH = -1L;
    public static String TRANSFER_ENCODING = "transfer-encoding";
    public static String CONTENT_LEN = "content-length";
    public static String CONTENT_TYPE = "content-type";
    public static String CONTENT_ENCODING = "content-encoding";
    public static String CONN_DIRECTIVE = "connection";
    public static String LOCATION = "location";
    public static String PROXY_CONNECTION = "proxy-connection";
    public static String WWW_AUTHENTICATE = "www-authenticate";
    public static String PROXY_AUTHENTICATE = "proxy-authenticate";
    public static String CONTENT_DISPOSITION = "content-disposition";
    public static String ACCEPT_RANGES = "accept-ranges";
    public static String EXPIRES = "expires";
    public static String CACHE_CONTROL = "cache-control";
    public static String LAST_MODIFIED = "last-modified";
    public static String ETAG = "etag";
    public static String SET_COOKIE = "set-cookie";
    public static String PRAGMA = "pragma";
    public static String REFRESH = "refresh";
    public static String X_PERMITTED_CROSS_DOMAIN_POLICIES = "x-permitted-cross-domain-policies";
    private static int HASH_TRANSFER_ENCODING = 1274458357;
    private static int HASH_CONTENT_LEN = -1132779846;
    private static int HASH_CONTENT_TYPE = 785670158;
    private static int HASH_CONTENT_ENCODING = 2095084583;
    private static int HASH_CONN_DIRECTIVE = -775651618;
    private static int HASH_LOCATION = 1901043637;
    private static int HASH_PROXY_CONNECTION = 285929373;
    private static int HASH_WWW_AUTHENTICATE = -243037365;
    private static int HASH_PROXY_AUTHENTICATE = -301767724;
    private static int HASH_CONTENT_DISPOSITION = -1267267485;
    private static int HASH_ACCEPT_RANGES = 1397189435;
    private static int HASH_EXPIRES = -1309235404;
    private static int HASH_CACHE_CONTROL = -208775662;
    private static int HASH_LAST_MODIFIED = 150043680;
    private static int HASH_ETAG = 3123477;
    private static int HASH_SET_COOKIE = 1237214767;
    private static int HASH_PRAGMA = -980228804;
    private static int HASH_REFRESH = 1085444827;
    private static int HASH_X_PERMITTED_CROSS_DOMAIN_POLICIES = -1345594014;
    private static int IDX_TRANSFER_ENCODING = 0;
    private static int IDX_CONTENT_LEN = 1;
    private static int IDX_CONTENT_TYPE = 2;
    private static int IDX_CONTENT_ENCODING = 3;
    private static int IDX_CONN_DIRECTIVE = 4;
    private static int IDX_LOCATION = 5;
    private static int IDX_PROXY_CONNECTION = 6;
    private static int IDX_WWW_AUTHENTICATE = 7;
    private static int IDX_PROXY_AUTHENTICATE = 8;
    private static int IDX_CONTENT_DISPOSITION = 9;
    private static int IDX_ACCEPT_RANGES = 10;
    private static int IDX_EXPIRES = 11;
    private static int IDX_CACHE_CONTROL = 12;
    private static int IDX_LAST_MODIFIED = 13;
    private static int IDX_ETAG = 14;
    private static int IDX_SET_COOKIE = 15;
    private static int IDX_PRAGMA = 16;
    private static int IDX_REFRESH = 17;
    private static int IDX_X_PERMITTED_CROSS_DOMAIN_POLICIES = 18;
    private static int HEADER_COUNT = 19;
    private long transferEncoding;
    private long contentLength;
    private int connectionType;
    private ArrayList<String> cookies;
    private String[] mHeaders;
    private static String[] sHeaderNames;
    private ArrayList<String> mExtraHeaderNames;
    private ArrayList<String> mExtraHeaderValues;

    private void $$robo$$android_net_http_Headers$__constructor__() {
        this.cookies = new ArrayList(2);
        this.mHeaders = new String[19];
        this.mExtraHeaderNames = new ArrayList(4);
        this.mExtraHeaderValues = new ArrayList(4);
        this.transferEncoding = 0L;
        this.contentLength = -1L;
        this.connectionType = 0;
    }

    private final void $$robo$$android_net_http_Headers$parseHeader(CharArrayBuffer buffer) {
        int pos = CharArrayBuffers.setLowercaseIndexOf(buffer, 58);
        if (pos == -1) {
            return;
        }
        String name = buffer.substringTrimmed(0, pos);
        if (name.length() == 0) {
            return;
        }
        String val = buffer.substringTrimmed(++pos, buffer.length());
        switch (name.hashCode()) {
            case 1274458357: {
                if (!name.equals("transfer-encoding")) break;
                this.mHeaders[0] = val;
                HeaderElement[] encodings = BasicHeaderValueParser.DEFAULT.parseElements(buffer, new ParserCursor(pos, buffer.length()));
                int len = encodings.length;
                if ("identity".equalsIgnoreCase(val)) {
                    this.transferEncoding = -1L;
                    break;
                }
                if (len > 0 && "chunked".equalsIgnoreCase(encodings[len - 1].getName())) {
                    this.transferEncoding = -2L;
                    break;
                }
                this.transferEncoding = -1L;
                break;
            }
            case -1132779846: {
                if (!name.equals("content-length")) break;
                this.mHeaders[1] = val;
                try {
                    this.contentLength = Long.parseLong(val);
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case 785670158: {
                if (!name.equals("content-type")) break;
                this.mHeaders[2] = val;
                break;
            }
            case 2095084583: {
                if (!name.equals("content-encoding")) break;
                this.mHeaders[3] = val;
                break;
            }
            case -775651618: {
                if (!name.equals("connection")) break;
                this.mHeaders[4] = val;
                this.setConnectionType(buffer, pos);
                break;
            }
            case 1901043637: {
                if (!name.equals("location")) break;
                this.mHeaders[5] = val;
                break;
            }
            case 285929373: {
                if (!name.equals("proxy-connection")) break;
                this.mHeaders[6] = val;
                this.setConnectionType(buffer, pos);
                break;
            }
            case -243037365: {
                if (!name.equals("www-authenticate")) break;
                this.mHeaders[7] = val;
                break;
            }
            case -301767724: {
                if (!name.equals("proxy-authenticate")) break;
                this.mHeaders[8] = val;
                break;
            }
            case -1267267485: {
                if (!name.equals("content-disposition")) break;
                this.mHeaders[9] = val;
                break;
            }
            case 1397189435: {
                if (!name.equals("accept-ranges")) break;
                this.mHeaders[10] = val;
                break;
            }
            case -1309235404: {
                if (!name.equals("expires")) break;
                this.mHeaders[11] = val;
                break;
            }
            case -208775662: {
                if (!name.equals("cache-control")) break;
                if (this.mHeaders[12] != null && this.mHeaders[12].length() > 0) {
                    this.mHeaders[12] = this.mHeaders[12] + ',' + val;
                    break;
                }
                this.mHeaders[12] = val;
                break;
            }
            case 150043680: {
                if (!name.equals("last-modified")) break;
                this.mHeaders[13] = val;
                break;
            }
            case 3123477: {
                if (!name.equals("etag")) break;
                this.mHeaders[14] = val;
                break;
            }
            case 1237214767: {
                if (!name.equals("set-cookie")) break;
                this.mHeaders[15] = val;
                this.cookies.add(val);
                break;
            }
            case -980228804: {
                if (!name.equals("pragma")) break;
                this.mHeaders[16] = val;
                break;
            }
            case 1085444827: {
                if (!name.equals("refresh")) break;
                this.mHeaders[17] = val;
                break;
            }
            case -1345594014: {
                if (!name.equals("x-permitted-cross-domain-policies")) break;
                this.mHeaders[18] = val;
                break;
            }
            default: {
                this.mExtraHeaderNames.add(name);
                this.mExtraHeaderValues.add(val);
            }
        }
    }

    private final long $$robo$$android_net_http_Headers$getTransferEncoding() {
        return this.transferEncoding;
    }

    private final long $$robo$$android_net_http_Headers$getContentLength() {
        return this.contentLength;
    }

    private final int $$robo$$android_net_http_Headers$getConnectionType() {
        return this.connectionType;
    }

    private final String $$robo$$android_net_http_Headers$getContentType() {
        return this.mHeaders[2];
    }

    private final String $$robo$$android_net_http_Headers$getContentEncoding() {
        return this.mHeaders[3];
    }

    private final String $$robo$$android_net_http_Headers$getLocation() {
        return this.mHeaders[5];
    }

    private final String $$robo$$android_net_http_Headers$getWwwAuthenticate() {
        return this.mHeaders[7];
    }

    private final String $$robo$$android_net_http_Headers$getProxyAuthenticate() {
        return this.mHeaders[8];
    }

    private final String $$robo$$android_net_http_Headers$getContentDisposition() {
        return this.mHeaders[9];
    }

    private final String $$robo$$android_net_http_Headers$getAcceptRanges() {
        return this.mHeaders[10];
    }

    private final String $$robo$$android_net_http_Headers$getExpires() {
        return this.mHeaders[11];
    }

    private final String $$robo$$android_net_http_Headers$getCacheControl() {
        return this.mHeaders[12];
    }

    private final String $$robo$$android_net_http_Headers$getLastModified() {
        return this.mHeaders[13];
    }

    private final String $$robo$$android_net_http_Headers$getEtag() {
        return this.mHeaders[14];
    }

    private final ArrayList<String> $$robo$$android_net_http_Headers$getSetCookie() {
        return this.cookies;
    }

    private final String $$robo$$android_net_http_Headers$getPragma() {
        return this.mHeaders[16];
    }

    private final String $$robo$$android_net_http_Headers$getRefresh() {
        return this.mHeaders[17];
    }

    private final String $$robo$$android_net_http_Headers$getXPermittedCrossDomainPolicies() {
        return this.mHeaders[18];
    }

    private final void $$robo$$android_net_http_Headers$setContentLength(long value) {
        this.contentLength = value;
    }

    private final void $$robo$$android_net_http_Headers$setContentType(String value) {
        this.mHeaders[2] = value;
    }

    private final void $$robo$$android_net_http_Headers$setContentEncoding(String value) {
        this.mHeaders[3] = value;
    }

    private final void $$robo$$android_net_http_Headers$setLocation(String value) {
        this.mHeaders[5] = value;
    }

    private final void $$robo$$android_net_http_Headers$setWwwAuthenticate(String value) {
        this.mHeaders[7] = value;
    }

    private final void $$robo$$android_net_http_Headers$setProxyAuthenticate(String value) {
        this.mHeaders[8] = value;
    }

    private final void $$robo$$android_net_http_Headers$setContentDisposition(String value) {
        this.mHeaders[9] = value;
    }

    private final void $$robo$$android_net_http_Headers$setAcceptRanges(String value) {
        this.mHeaders[10] = value;
    }

    private final void $$robo$$android_net_http_Headers$setExpires(String value) {
        this.mHeaders[11] = value;
    }

    private final void $$robo$$android_net_http_Headers$setCacheControl(String value) {
        this.mHeaders[12] = value;
    }

    private final void $$robo$$android_net_http_Headers$setLastModified(String value) {
        this.mHeaders[13] = value;
    }

    private final void $$robo$$android_net_http_Headers$setEtag(String value) {
        this.mHeaders[14] = value;
    }

    private final void $$robo$$android_net_http_Headers$setXPermittedCrossDomainPolicies(String value) {
        this.mHeaders[18] = value;
    }

    private final void $$robo$$android_net_http_Headers$getHeaders(HeaderCallback hcb) {
        for (int i = 0; i < 19; ++i) {
            String h = this.mHeaders[i];
            if (h == null) continue;
            hcb.header(sHeaderNames[i], h);
        }
        int extraLen = this.mExtraHeaderNames.size();
        for (int i = 0; i < extraLen; ++i) {
            hcb.header(this.mExtraHeaderNames.get(i), this.mExtraHeaderValues.get(i));
        }
    }

    private final void $$robo$$android_net_http_Headers$setConnectionType(CharArrayBuffer buffer, int pos) {
        if (CharArrayBuffers.containsIgnoreCaseTrimmed(buffer, pos, "Close")) {
            this.connectionType = 1;
        } else if (CharArrayBuffers.containsIgnoreCaseTrimmed(buffer, pos, "Keep-Alive")) {
            this.connectionType = 2;
        }
    }

    static void __staticInitializer__() {
        sHeaderNames = new String[]{"transfer-encoding", "content-length", "content-type", "content-encoding", "connection", "location", "proxy-connection", "www-authenticate", "proxy-authenticate", "content-disposition", "accept-ranges", "expires", "cache-control", "last-modified", "etag", "set-cookie", "pragma", "refresh", "x-permitted-cross-domain-policies"};
    }

    private void __constructor__() {
        this.$$robo$$android_net_http_Headers$__constructor__();
    }

    public Headers() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_http_Headers$__constructor__(), 0, this);
    }

    public void parseHeader(CharArrayBuffer charArrayBuffer) {
        InvokeDynamicSupport.bootstrap("parseHeader", $$robo$$android_net_http_Headers$parseHeader(org.apache.http.util.CharArrayBuffer ), 0, this, charArrayBuffer);
    }

    public long getTransferEncoding() {
        return (long)InvokeDynamicSupport.bootstrap("getTransferEncoding", $$robo$$android_net_http_Headers$getTransferEncoding(), 0, this);
    }

    public long getContentLength() {
        return (long)InvokeDynamicSupport.bootstrap("getContentLength", $$robo$$android_net_http_Headers$getContentLength(), 0, this);
    }

    public int getConnectionType() {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionType", $$robo$$android_net_http_Headers$getConnectionType(), 0, this);
    }

    public String getContentType() {
        return InvokeDynamicSupport.bootstrap("getContentType", $$robo$$android_net_http_Headers$getContentType(), 0, this);
    }

    public String getContentEncoding() {
        return InvokeDynamicSupport.bootstrap("getContentEncoding", $$robo$$android_net_http_Headers$getContentEncoding(), 0, this);
    }

    public String getLocation() {
        return InvokeDynamicSupport.bootstrap("getLocation", $$robo$$android_net_http_Headers$getLocation(), 0, this);
    }

    public String getWwwAuthenticate() {
        return InvokeDynamicSupport.bootstrap("getWwwAuthenticate", $$robo$$android_net_http_Headers$getWwwAuthenticate(), 0, this);
    }

    public String getProxyAuthenticate() {
        return InvokeDynamicSupport.bootstrap("getProxyAuthenticate", $$robo$$android_net_http_Headers$getProxyAuthenticate(), 0, this);
    }

    public String getContentDisposition() {
        return InvokeDynamicSupport.bootstrap("getContentDisposition", $$robo$$android_net_http_Headers$getContentDisposition(), 0, this);
    }

    public String getAcceptRanges() {
        return InvokeDynamicSupport.bootstrap("getAcceptRanges", $$robo$$android_net_http_Headers$getAcceptRanges(), 0, this);
    }

    public String getExpires() {
        return InvokeDynamicSupport.bootstrap("getExpires", $$robo$$android_net_http_Headers$getExpires(), 0, this);
    }

    public String getCacheControl() {
        return InvokeDynamicSupport.bootstrap("getCacheControl", $$robo$$android_net_http_Headers$getCacheControl(), 0, this);
    }

    public String getLastModified() {
        return InvokeDynamicSupport.bootstrap("getLastModified", $$robo$$android_net_http_Headers$getLastModified(), 0, this);
    }

    public String getEtag() {
        return InvokeDynamicSupport.bootstrap("getEtag", $$robo$$android_net_http_Headers$getEtag(), 0, this);
    }

    public ArrayList<String> getSetCookie() {
        return InvokeDynamicSupport.bootstrap("getSetCookie", $$robo$$android_net_http_Headers$getSetCookie(), 0, this);
    }

    public String getPragma() {
        return InvokeDynamicSupport.bootstrap("getPragma", $$robo$$android_net_http_Headers$getPragma(), 0, this);
    }

    public String getRefresh() {
        return InvokeDynamicSupport.bootstrap("getRefresh", $$robo$$android_net_http_Headers$getRefresh(), 0, this);
    }

    public String getXPermittedCrossDomainPolicies() {
        return InvokeDynamicSupport.bootstrap("getXPermittedCrossDomainPolicies", $$robo$$android_net_http_Headers$getXPermittedCrossDomainPolicies(), 0, this);
    }

    public void setContentLength(long l) {
        InvokeDynamicSupport.bootstrap("setContentLength", $$robo$$android_net_http_Headers$setContentLength(long ), 0, this, l);
    }

    public void setContentType(String string2) {
        InvokeDynamicSupport.bootstrap("setContentType", $$robo$$android_net_http_Headers$setContentType(java.lang.String ), 0, this, string2);
    }

    public void setContentEncoding(String string2) {
        InvokeDynamicSupport.bootstrap("setContentEncoding", $$robo$$android_net_http_Headers$setContentEncoding(java.lang.String ), 0, this, string2);
    }

    public void setLocation(String string2) {
        InvokeDynamicSupport.bootstrap("setLocation", $$robo$$android_net_http_Headers$setLocation(java.lang.String ), 0, this, string2);
    }

    public void setWwwAuthenticate(String string2) {
        InvokeDynamicSupport.bootstrap("setWwwAuthenticate", $$robo$$android_net_http_Headers$setWwwAuthenticate(java.lang.String ), 0, this, string2);
    }

    public void setProxyAuthenticate(String string2) {
        InvokeDynamicSupport.bootstrap("setProxyAuthenticate", $$robo$$android_net_http_Headers$setProxyAuthenticate(java.lang.String ), 0, this, string2);
    }

    public void setContentDisposition(String string2) {
        InvokeDynamicSupport.bootstrap("setContentDisposition", $$robo$$android_net_http_Headers$setContentDisposition(java.lang.String ), 0, this, string2);
    }

    public void setAcceptRanges(String string2) {
        InvokeDynamicSupport.bootstrap("setAcceptRanges", $$robo$$android_net_http_Headers$setAcceptRanges(java.lang.String ), 0, this, string2);
    }

    public void setExpires(String string2) {
        InvokeDynamicSupport.bootstrap("setExpires", $$robo$$android_net_http_Headers$setExpires(java.lang.String ), 0, this, string2);
    }

    public void setCacheControl(String string2) {
        InvokeDynamicSupport.bootstrap("setCacheControl", $$robo$$android_net_http_Headers$setCacheControl(java.lang.String ), 0, this, string2);
    }

    public void setLastModified(String string2) {
        InvokeDynamicSupport.bootstrap("setLastModified", $$robo$$android_net_http_Headers$setLastModified(java.lang.String ), 0, this, string2);
    }

    public void setEtag(String string2) {
        InvokeDynamicSupport.bootstrap("setEtag", $$robo$$android_net_http_Headers$setEtag(java.lang.String ), 0, this, string2);
    }

    public void setXPermittedCrossDomainPolicies(String string2) {
        InvokeDynamicSupport.bootstrap("setXPermittedCrossDomainPolicies", $$robo$$android_net_http_Headers$setXPermittedCrossDomainPolicies(java.lang.String ), 0, this, string2);
    }

    public void getHeaders(HeaderCallback headerCallback) {
        InvokeDynamicSupport.bootstrap("getHeaders", $$robo$$android_net_http_Headers$getHeaders(android.net.http.Headers$HeaderCallback ), 0, this, headerCallback);
    }

    private void setConnectionType(CharArrayBuffer charArrayBuffer, int n) {
        InvokeDynamicSupport.bootstrap("setConnectionType", $$robo$$android_net_http_Headers$setConnectionType(org.apache.http.util.CharArrayBuffer int ), 0, this, charArrayBuffer, n);
    }

    static {
        RobolectricInternals.classInitializing(Headers.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Headers)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface HeaderCallback
    extends InstrumentedInterface {
        public void header(String var1, String var2);
    }
}

