/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class HttpAuthHeader
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String BASIC_TOKEN = "Basic";
    public static String DIGEST_TOKEN = "Digest";
    private static String REALM_TOKEN = "realm";
    private static String NONCE_TOKEN = "nonce";
    private static String STALE_TOKEN = "stale";
    private static String OPAQUE_TOKEN = "opaque";
    private static String QOP_TOKEN = "qop";
    private static String ALGORITHM_TOKEN = "algorithm";
    private int mScheme;
    public static int UNKNOWN = 0;
    public static int BASIC = 1;
    public static int DIGEST = 2;
    private boolean mStale;
    private String mRealm;
    private String mNonce;
    private String mOpaque;
    private String mQop;
    private String mAlgorithm;
    private boolean mIsProxy;
    private String mUsername;
    private String mPassword;

    private void $$robo$$android_net_http_HttpAuthHeader$__constructor__(String header) {
        if (header != null) {
            this.parseHeader(header);
        }
    }

    private final boolean $$robo$$android_net_http_HttpAuthHeader$isProxy() {
        return this.mIsProxy;
    }

    private final void $$robo$$android_net_http_HttpAuthHeader$setProxy() {
        this.mIsProxy = true;
    }

    private final String $$robo$$android_net_http_HttpAuthHeader$getUsername() {
        return this.mUsername;
    }

    private final void $$robo$$android_net_http_HttpAuthHeader$setUsername(String username) {
        this.mUsername = username;
    }

    private final String $$robo$$android_net_http_HttpAuthHeader$getPassword() {
        return this.mPassword;
    }

    private final void $$robo$$android_net_http_HttpAuthHeader$setPassword(String password) {
        this.mPassword = password;
    }

    private final boolean $$robo$$android_net_http_HttpAuthHeader$isBasic() {
        return this.mScheme == 1;
    }

    private final boolean $$robo$$android_net_http_HttpAuthHeader$isDigest() {
        return this.mScheme == 2;
    }

    private final int $$robo$$android_net_http_HttpAuthHeader$getScheme() {
        return this.mScheme;
    }

    private final boolean $$robo$$android_net_http_HttpAuthHeader$getStale() {
        return this.mStale;
    }

    private final String $$robo$$android_net_http_HttpAuthHeader$getRealm() {
        return this.mRealm;
    }

    private final String $$robo$$android_net_http_HttpAuthHeader$getNonce() {
        return this.mNonce;
    }

    private final String $$robo$$android_net_http_HttpAuthHeader$getOpaque() {
        return this.mOpaque;
    }

    private final String $$robo$$android_net_http_HttpAuthHeader$getQop() {
        return this.mQop;
    }

    private final String $$robo$$android_net_http_HttpAuthHeader$getAlgorithm() {
        return this.mAlgorithm;
    }

    private final boolean $$robo$$android_net_http_HttpAuthHeader$isSupportedScheme() {
        if (this.mRealm != null) {
            if (this.mScheme == 1) {
                return true;
            }
            if (this.mScheme == 2) {
                return this.mAlgorithm.equals("md5") && (this.mQop == null || this.mQop.equals("auth"));
            }
        }
        return false;
    }

    private final void $$robo$$android_net_http_HttpAuthHeader$parseHeader(String header) {
        String parameters;
        if (header != null && (parameters = this.parseScheme(header)) != null && this.mScheme != 0) {
            this.parseParameters(parameters);
        }
    }

    private final String $$robo$$android_net_http_HttpAuthHeader$parseScheme(String header) {
        int i;
        if (header != null && (i = header.indexOf(32)) >= 0) {
            String scheme = header.substring(0, i).trim();
            if (scheme.equalsIgnoreCase("Digest")) {
                this.mScheme = 2;
                this.mAlgorithm = "md5";
            } else if (scheme.equalsIgnoreCase("Basic")) {
                this.mScheme = 1;
            }
            return header.substring(i + 1);
        }
        return null;
    }

    private final void $$robo$$android_net_http_HttpAuthHeader$parseParameters(String parameters) {
        if (parameters != null) {
            int i;
            do {
                if ((i = parameters.indexOf(44)) < 0) {
                    this.parseParameter(parameters);
                    continue;
                }
                this.parseParameter(parameters.substring(0, i));
                parameters = parameters.substring(i + 1);
            } while (i >= 0);
        }
    }

    private final void $$robo$$android_net_http_HttpAuthHeader$parseParameter(String parameter) {
        int i;
        if (parameter != null && (i = parameter.indexOf(61)) >= 0) {
            String token = parameter.substring(0, i).trim();
            String value = HttpAuthHeader.trimDoubleQuotesIfAny(parameter.substring(i + 1).trim());
            if (token.equalsIgnoreCase("realm")) {
                this.mRealm = value;
            } else if (this.mScheme == 2) {
                this.parseParameter(token, value);
            }
        }
    }

    private final void $$robo$$android_net_http_HttpAuthHeader$parseParameter(String token, String value) {
        if (token != null && value != null) {
            if (token.equalsIgnoreCase("nonce")) {
                this.mNonce = value;
                return;
            }
            if (token.equalsIgnoreCase("stale")) {
                this.parseStale(value);
                return;
            }
            if (token.equalsIgnoreCase("opaque")) {
                this.mOpaque = value;
                return;
            }
            if (token.equalsIgnoreCase("qop")) {
                this.mQop = value.toLowerCase(Locale.ROOT);
                return;
            }
            if (token.equalsIgnoreCase("algorithm")) {
                this.mAlgorithm = value.toLowerCase(Locale.ROOT);
                return;
            }
        }
    }

    private final void $$robo$$android_net_http_HttpAuthHeader$parseStale(String value) {
        if (value != null && value.equalsIgnoreCase("true")) {
            this.mStale = true;
        }
    }

    private static final String $$robo$$android_net_http_HttpAuthHeader$trimDoubleQuotesIfAny(String value) {
        int len;
        if (value != null && (len = value.length()) > 2 && value.charAt(0) == '\"' && value.charAt(len - 1) == '\"') {
            return value.substring(1, len - 1);
        }
        return value;
    }

    private void __constructor__(String string2) {
        this.$$robo$$android_net_http_HttpAuthHeader$__constructor__(string2);
    }

    public HttpAuthHeader(String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_http_HttpAuthHeader$__constructor__(java.lang.String ), 0, this, string2);
    }

    public boolean isProxy() {
        return (boolean)InvokeDynamicSupport.bootstrap("isProxy", $$robo$$android_net_http_HttpAuthHeader$isProxy(), 0, this);
    }

    public void setProxy() {
        InvokeDynamicSupport.bootstrap("setProxy", $$robo$$android_net_http_HttpAuthHeader$setProxy(), 0, this);
    }

    public String getUsername() {
        return InvokeDynamicSupport.bootstrap("getUsername", $$robo$$android_net_http_HttpAuthHeader$getUsername(), 0, this);
    }

    public void setUsername(String string2) {
        InvokeDynamicSupport.bootstrap("setUsername", $$robo$$android_net_http_HttpAuthHeader$setUsername(java.lang.String ), 0, this, string2);
    }

    public String getPassword() {
        return InvokeDynamicSupport.bootstrap("getPassword", $$robo$$android_net_http_HttpAuthHeader$getPassword(), 0, this);
    }

    public void setPassword(String string2) {
        InvokeDynamicSupport.bootstrap("setPassword", $$robo$$android_net_http_HttpAuthHeader$setPassword(java.lang.String ), 0, this, string2);
    }

    public boolean isBasic() {
        return (boolean)InvokeDynamicSupport.bootstrap("isBasic", $$robo$$android_net_http_HttpAuthHeader$isBasic(), 0, this);
    }

    public boolean isDigest() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDigest", $$robo$$android_net_http_HttpAuthHeader$isDigest(), 0, this);
    }

    public int getScheme() {
        return (int)InvokeDynamicSupport.bootstrap("getScheme", $$robo$$android_net_http_HttpAuthHeader$getScheme(), 0, this);
    }

    public boolean getStale() {
        return (boolean)InvokeDynamicSupport.bootstrap("getStale", $$robo$$android_net_http_HttpAuthHeader$getStale(), 0, this);
    }

    public String getRealm() {
        return InvokeDynamicSupport.bootstrap("getRealm", $$robo$$android_net_http_HttpAuthHeader$getRealm(), 0, this);
    }

    public String getNonce() {
        return InvokeDynamicSupport.bootstrap("getNonce", $$robo$$android_net_http_HttpAuthHeader$getNonce(), 0, this);
    }

    public String getOpaque() {
        return InvokeDynamicSupport.bootstrap("getOpaque", $$robo$$android_net_http_HttpAuthHeader$getOpaque(), 0, this);
    }

    public String getQop() {
        return InvokeDynamicSupport.bootstrap("getQop", $$robo$$android_net_http_HttpAuthHeader$getQop(), 0, this);
    }

    public String getAlgorithm() {
        return InvokeDynamicSupport.bootstrap("getAlgorithm", $$robo$$android_net_http_HttpAuthHeader$getAlgorithm(), 0, this);
    }

    public boolean isSupportedScheme() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSupportedScheme", $$robo$$android_net_http_HttpAuthHeader$isSupportedScheme(), 0, this);
    }

    private void parseHeader(String string2) {
        InvokeDynamicSupport.bootstrap("parseHeader", $$robo$$android_net_http_HttpAuthHeader$parseHeader(java.lang.String ), 0, this, string2);
    }

    private String parseScheme(String string2) {
        return InvokeDynamicSupport.bootstrap("parseScheme", $$robo$$android_net_http_HttpAuthHeader$parseScheme(java.lang.String ), 0, this, string2);
    }

    private void parseParameters(String string2) {
        InvokeDynamicSupport.bootstrap("parseParameters", $$robo$$android_net_http_HttpAuthHeader$parseParameters(java.lang.String ), 0, this, string2);
    }

    private void parseParameter(String string2) {
        InvokeDynamicSupport.bootstrap("parseParameter", $$robo$$android_net_http_HttpAuthHeader$parseParameter(java.lang.String ), 0, this, string2);
    }

    private void parseParameter(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("parseParameter", $$robo$$android_net_http_HttpAuthHeader$parseParameter(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    private void parseStale(String string2) {
        InvokeDynamicSupport.bootstrap("parseStale", $$robo$$android_net_http_HttpAuthHeader$parseStale(java.lang.String ), 0, this, string2);
    }

    private static String trimDoubleQuotesIfAny(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("trimDoubleQuotesIfAny", $$robo$$android_net_http_HttpAuthHeader$trimDoubleQuotesIfAny(java.lang.String ), 0, (String)string2);
    }

    public /* synthetic */ HttpAuthHeader() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HttpAuthHeader)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

