/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.content.Context;
import android.net.http.AndroidHttpClientConnection;
import android.net.http.CertificateChainValidator;
import android.net.http.Connection;
import android.net.http.Headers;
import android.net.http.Request;
import android.net.http.RequestFeeder;
import android.net.http.SSLConnectionClosedByUserException;
import android.net.http.SslCertificate;
import android.net.http.SslError;
import android.util.Log;
import com.android.org.conscrypt.FileClientSessionCache;
import com.android.org.conscrypt.OpenSSLContextImpl;
import com.android.org.conscrypt.SSLClientSessionCache;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.cert.X509Certificate;
import java.util.Locale;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.ParseException;
import org.apache.http.ProtocolVersion;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class HttpsConnection
extends Connection
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static SSLSocketFactory mSslSocketFactory;
    private Object mSuspendLock;
    private boolean mSuspended;
    private boolean mAborted;
    private HttpHost mProxyHost;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_net_http_HttpsConnection$initializeEngine(File sessionDir) {
        try {
            SSLClientSessionCache cache = null;
            if (sessionDir != null) {
                Log.d("HttpsConnection", "Caching SSL sessions in " + sessionDir + ".");
                cache = FileClientSessionCache.usingDirectory(sessionDir);
            }
            OpenSSLContextImpl sslContext = new OpenSSLContextImpl();
            TrustManager[] trustManagers = new TrustManager[]{new X509TrustManager(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_net_http_HttpsConnection_1$__constructor__() {
                }

                private final X509Certificate[] $$robo$$android_net_http_HttpsConnection_1$getAcceptedIssuers() {
                    return null;
                }

                private final void $$robo$$android_net_http_HttpsConnection_1$checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                private final void $$robo$$android_net_http_HttpsConnection_1$checkServerTrusted(X509Certificate[] certs, String authType) {
                }

                private void __constructor__() {
                    this.$$robo$$android_net_http_HttpsConnection_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_http_HttpsConnection_1$__constructor__(), 0, this);
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return InvokeDynamicSupport.bootstrap("getAcceptedIssuers", $$robo$$android_net_http_HttpsConnection_1$getAcceptedIssuers(), 0, this);
                }

                @Override
                public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string2) {
                    InvokeDynamicSupport.bootstrap("checkClientTrusted", $$robo$$android_net_http_HttpsConnection_1$checkClientTrusted(java.security.cert.X509Certificate[] java.lang.String ), 0, this, x509CertificateArray, string2);
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string2) {
                    InvokeDynamicSupport.bootstrap("checkServerTrusted", $$robo$$android_net_http_HttpsConnection_1$checkServerTrusted(java.security.cert.X509Certificate[] java.lang.String ), 0, this, x509CertificateArray, string2);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            }};
            sslContext.engineInit(null, trustManagers, null);
            sslContext.engineGetClientSessionContext().setPersistentCache(cache);
            Class<HttpsConnection> clazz = HttpsConnection.class;
            synchronized (HttpsConnection.class) {
                mSslSocketFactory = sslContext.engineGetSocketFactory();
                // ** MonitorExit[var4_6] (shouldn't be in output)
            }
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        {
            return;
        }
    }

    private static final synchronized SSLSocketFactory $$robo$$android_net_http_HttpsConnection$getSocketFactory() {
        return mSslSocketFactory;
    }

    private void $$robo$$android_net_http_HttpsConnection$__constructor__(Context context, HttpHost host, HttpHost proxy, RequestFeeder requestFeeder) {
        this.mSuspendLock = new Object();
        this.mSuspended = false;
        this.mAborted = false;
        this.mProxyHost = proxy;
    }

    private final void $$robo$$android_net_http_HttpsConnection$setCertificate(SslCertificate certificate) {
        this.mCertificate = certificate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AndroidHttpClientConnection $$robo$$android_net_http_HttpsConnection$openConnection(Request req) throws IOException {
        Object statusLine;
        BasicHttpParams params;
        Socket sslSock = null;
        if (this.mProxyHost != null) {
            AndroidHttpClientConnection proxyConnection = null;
            Socket proxySock = null;
            try {
                proxySock = new Socket(this.mProxyHost.getHostName(), this.mProxyHost.getPort());
                proxySock.setSoTimeout(60000);
                proxyConnection = new AndroidHttpClientConnection();
                params = new BasicHttpParams();
                HttpConnectionParams.setSocketBufferSize(params, 8192);
                proxyConnection.bind(proxySock, params);
            }
            catch (IOException e) {
                String errorMessage;
                if (proxyConnection != null) {
                    proxyConnection.close();
                }
                if ((errorMessage = e.getMessage()) == null) {
                    errorMessage = "failed to establish a connection to the proxy";
                }
                throw new IOException(errorMessage);
            }
            statusLine = null;
            int statusCode = 0;
            Headers headers = new Headers();
            try {
                BasicHttpRequest proxyReq = new BasicHttpRequest("CONNECT", this.mHost.toHostString());
                for (Header h : req.mHttpRequest.getAllHeaders()) {
                    String headerName = h.getName().toLowerCase(Locale.ROOT);
                    if (!headerName.startsWith("proxy") && !headerName.equals("keep-alive") && !headerName.equals("host")) continue;
                    proxyReq.addHeader(h);
                }
                proxyConnection.sendRequestHeader(proxyReq);
                proxyConnection.flush();
                while ((statusCode = (statusLine = proxyConnection.parseResponseHeader(headers)).getStatusCode()) < 200) {
                }
            }
            catch (ParseException e) {
                String errorMessage = e.getMessage();
                if (errorMessage == null) {
                    errorMessage = "failed to send a CONNECT request";
                }
                throw new IOException(errorMessage);
            }
            catch (HttpException e) {
                String errorMessage = e.getMessage();
                if (errorMessage == null) {
                    errorMessage = "failed to send a CONNECT request";
                }
                throw new IOException(errorMessage);
            }
            catch (IOException e) {
                String errorMessage = e.getMessage();
                if (errorMessage == null) {
                    errorMessage = "failed to send a CONNECT request";
                }
                throw new IOException(errorMessage);
            }
            if (statusCode == 200) {
                try {
                    sslSock = (SSLSocket)HttpsConnection.getSocketFactory().createSocket(proxySock, this.mHost.getHostName(), this.mHost.getPort(), true);
                }
                catch (IOException e) {
                    String errorMessage;
                    if (sslSock != null) {
                        sslSock.close();
                    }
                    if ((errorMessage = e.getMessage()) == null) {
                        errorMessage = "failed to create an SSL socket";
                    }
                    throw new IOException(errorMessage);
                }
            }
            ProtocolVersion version = statusLine.getProtocolVersion();
            req.mEventHandler.status(version.getMajor(), version.getMinor(), statusCode, statusLine.getReasonPhrase());
            req.mEventHandler.headers(headers);
            req.mEventHandler.endData();
            proxyConnection.close();
            return null;
        }
        try {
            sslSock = (SSLSocket)HttpsConnection.getSocketFactory().createSocket(this.mHost.getHostName(), this.mHost.getPort());
            sslSock.setSoTimeout(60000);
        }
        catch (IOException e) {
            String errorMessage;
            if (sslSock != null) {
                sslSock.close();
            }
            if ((errorMessage = e.getMessage()) == null) {
                errorMessage = "failed to create an SSL socket";
            }
            throw new IOException(errorMessage);
        }
        SslError error = CertificateChainValidator.getInstance().doHandshakeAndValidateServerCertificates(this, (SSLSocket)sslSock, this.mHost.getHostName());
        if (error != null) {
            Object errorMessage = this.mSuspendLock;
            synchronized (errorMessage) {
                this.mSuspended = true;
            }
            boolean canHandle = req.getEventHandler().handleSslErrorRequest(error);
            if (!canHandle) {
                throw new IOException("failed to handle " + error);
            }
            statusLine = this.mSuspendLock;
            synchronized (statusLine) {
                if (this.mSuspended) {
                    try {
                        this.mSuspendLock.wait(600000L);
                        if (this.mSuspended) {
                            this.mSuspended = false;
                            this.mAborted = true;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.mAborted) {
                    sslSock.close();
                    throw new SSLConnectionClosedByUserException("connection closed by the user");
                }
            }
        }
        AndroidHttpClientConnection conn = new AndroidHttpClientConnection();
        params = new BasicHttpParams();
        params.setIntParameter("http.socket.buffer-size", 8192);
        conn.bind(sslSock, params);
        return conn;
    }

    private final void $$robo$$android_net_http_HttpsConnection$closeConnection() {
        if (this.mSuspended) {
            this.restartConnection(false);
        }
        try {
            if (this.mHttpClientConnection != null && this.mHttpClientConnection.isOpen()) {
                this.mHttpClientConnection.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_http_HttpsConnection$restartConnection(boolean proceed) {
        Object object = this.mSuspendLock;
        synchronized (object) {
            if (this.mSuspended) {
                this.mSuspended = false;
                this.mAborted = !proceed;
                this.mSuspendLock.notify();
            }
        }
    }

    private final String $$robo$$android_net_http_HttpsConnection$getScheme() {
        return "https";
    }

    static void __staticInitializer__() {
        mSslSocketFactory = null;
        HttpsConnection.initializeEngine(null);
    }

    public static void initializeEngine(File file) {
        InvokeDynamicSupport.bootstrapStatic("initializeEngine", $$robo$$android_net_http_HttpsConnection$initializeEngine(java.io.File ), 0, (File)file);
    }

    private static synchronized SSLSocketFactory getSocketFactory() {
        return InvokeDynamicSupport.bootstrapStatic("getSocketFactory", $$robo$$android_net_http_HttpsConnection$getSocketFactory(), 0);
    }

    private void __constructor__(Context context, HttpHost httpHost, HttpHost httpHost2, RequestFeeder requestFeeder) {
        this.$$robo$$android_net_http_HttpsConnection$__constructor__(context, httpHost, httpHost2, requestFeeder);
    }

    HttpsConnection(Context context, HttpHost httpHost, HttpHost httpHost2, RequestFeeder requestFeeder) {
        super(context, httpHost, requestFeeder);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_http_HttpsConnection$__constructor__(android.content.Context org.apache.http.HttpHost org.apache.http.HttpHost android.net.http.RequestFeeder ), 0, this, context, httpHost, httpHost2, requestFeeder);
    }

    void setCertificate(SslCertificate sslCertificate) {
        InvokeDynamicSupport.bootstrap("setCertificate", $$robo$$android_net_http_HttpsConnection$setCertificate(android.net.http.SslCertificate ), 0, this, sslCertificate);
    }

    @Override
    AndroidHttpClientConnection openConnection(Request request) throws IOException {
        return InvokeDynamicSupport.bootstrap("openConnection", $$robo$$android_net_http_HttpsConnection$openConnection(android.net.http.Request ), 0, this, request);
    }

    @Override
    void closeConnection() {
        InvokeDynamicSupport.bootstrap("closeConnection", $$robo$$android_net_http_HttpsConnection$closeConnection(), 0, this);
    }

    void restartConnection(boolean bl) {
        InvokeDynamicSupport.bootstrap("restartConnection", $$robo$$android_net_http_HttpsConnection$restartConnection(boolean ), 0, this, bl);
    }

    @Override
    String getScheme() {
        return InvokeDynamicSupport.bootstrap("getScheme", $$robo$$android_net_http_HttpsConnection$getScheme(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(HttpsConnection.class);
    }

    public /* synthetic */ HttpsConnection() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HttpsConnection)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

