/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.net.http.Connection;
import android.os.Process;
import android.os.SystemClock;
import org.apache.http.HttpHost;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class IdleCache
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int IDLE_CACHE_MAX = 8;
    private static int EMPTY_CHECK_MAX = 5;
    private static int TIMEOUT = 6000;
    private static int CHECK_INTERVAL = 2000;
    private Entry[] mEntries;
    private int mCount;
    private IdleReaper mThread;
    private int mCached;
    private int mReused;

    private void $$robo$$android_net_http_IdleCache$__constructor__() {
        this.mEntries = new Entry[8];
        this.mCount = 0;
        this.mThread = null;
        this.mCached = 0;
        this.mReused = 0;
        for (int i = 0; i < 8; ++i) {
            this.mEntries[i] = new Entry(this);
        }
    }

    private final synchronized boolean $$robo$$android_net_http_IdleCache$cacheConnection(HttpHost host, Connection connection) {
        boolean ret = false;
        if (this.mCount < 8) {
            long time = SystemClock.uptimeMillis();
            for (int i = 0; i < 8; ++i) {
                Entry entry = this.mEntries[i];
                if (entry.mHost != null) continue;
                entry.mHost = host;
                entry.mConnection = connection;
                entry.mTimeout = time + 6000L;
                ++this.mCount;
                ret = true;
                if (this.mThread != null) break;
                this.mThread = new IdleReaper(this);
                this.mThread.start();
                break;
            }
        }
        return ret;
    }

    private final synchronized Connection $$robo$$android_net_http_IdleCache$getConnection(HttpHost host) {
        Connection ret = null;
        if (this.mCount > 0) {
            for (int i = 0; i < 8; ++i) {
                Entry entry = this.mEntries[i];
                HttpHost eHost = entry.mHost;
                if (eHost == null || !eHost.equals(host)) continue;
                ret = entry.mConnection;
                entry.mHost = null;
                entry.mConnection = null;
                --this.mCount;
                break;
            }
        }
        return ret;
    }

    private final synchronized void $$robo$$android_net_http_IdleCache$clear() {
        for (int i = 0; this.mCount > 0 && i < 8; ++i) {
            Entry entry = this.mEntries[i];
            if (entry.mHost == null) continue;
            entry.mHost = null;
            entry.mConnection.closeConnection();
            entry.mConnection = null;
            --this.mCount;
        }
    }

    private final synchronized void $$robo$$android_net_http_IdleCache$clearIdle() {
        if (this.mCount > 0) {
            long time = SystemClock.uptimeMillis();
            for (int i = 0; i < 8; ++i) {
                Entry entry = this.mEntries[i];
                if (entry.mHost == null || time <= entry.mTimeout) continue;
                entry.mHost = null;
                entry.mConnection.closeConnection();
                entry.mConnection = null;
                --this.mCount;
            }
        }
    }

    private void __constructor__() {
        this.$$robo$$android_net_http_IdleCache$__constructor__();
    }

    IdleCache() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_http_IdleCache$__constructor__(), 0, this);
    }

    synchronized boolean cacheConnection(HttpHost httpHost, Connection connection) {
        return (boolean)InvokeDynamicSupport.bootstrap("cacheConnection", $$robo$$android_net_http_IdleCache$cacheConnection(org.apache.http.HttpHost android.net.http.Connection ), 0, this, httpHost, connection);
    }

    synchronized Connection getConnection(HttpHost httpHost) {
        return InvokeDynamicSupport.bootstrap("getConnection", $$robo$$android_net_http_IdleCache$getConnection(org.apache.http.HttpHost ), 0, this, httpHost);
    }

    synchronized void clear() {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$android_net_http_IdleCache$clear(), 0, this);
    }

    private synchronized void clearIdle() {
        InvokeDynamicSupport.bootstrap("clearIdle", $$robo$$android_net_http_IdleCache$clearIdle(), 0, this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IdleCache)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class IdleReaper
    extends Thread
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ IdleCache this$0;

        private void $$robo$$android_net_http_IdleCache_IdleReaper$__constructor__(IdleCache idleCache) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_net_http_IdleCache_IdleReaper$run() {
            int check = 0;
            this.setName("IdleReaper");
            Process.setThreadPriority(10);
            IdleCache idleCache = this.this$0;
            synchronized (idleCache) {
                while (check < 5) {
                    try {
                        this.this$0.wait(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.this$0.mCount == 0) {
                        ++check;
                        continue;
                    }
                    check = 0;
                    this.this$0.clearIdle();
                }
                this.this$0.mThread = null;
            }
        }

        private /* synthetic */ void $$robo$$android_net_http_IdleCache_IdleReaper$__constructor__(IdleCache x0, 1 x1) {
        }

        private void __constructor__(IdleCache idleCache) {
            this.$$robo$$android_net_http_IdleCache_IdleReaper$__constructor__(idleCache);
        }

        private IdleReaper(IdleCache idleCache) {
            this.this$0 = idleCache;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_http_IdleCache_IdleReaper$__constructor__(android.net.http.IdleCache ), 0, this, idleCache);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_net_http_IdleCache_IdleReaper$run(), 0, this);
        }

        private /* synthetic */ void __constructor__(IdleCache idleCache, 1 var2_2) {
            this.$$robo$$android_net_http_IdleCache_IdleReaper$__constructor__(idleCache, var2_2);
        }

        public /* synthetic */ IdleReaper() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IdleReaper)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class Entry
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        HttpHost mHost;
        Connection mConnection;
        long mTimeout;
        /* synthetic */ IdleCache this$0;

        private void $$robo$$android_net_http_IdleCache_Entry$__constructor__(IdleCache idleCache) {
        }

        private void __constructor__(IdleCache idleCache) {
            this.$$robo$$android_net_http_IdleCache_Entry$__constructor__(idleCache);
        }

        Entry(IdleCache idleCache) {
            this.this$0 = idleCache;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_http_IdleCache_Entry$__constructor__(android.net.http.IdleCache ), 0, this, idleCache);
        }

        public /* synthetic */ Entry() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Entry)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

