/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.net.http.AndroidHttpClientConnection;
import android.net.http.Connection;
import android.net.http.EventHandler;
import android.net.http.Headers;
import android.net.http.HttpLog;
import android.net.http.HttpsConnection;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.ParseException;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.protocol.RequestContent;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Request
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    EventHandler mEventHandler;
    private Connection mConnection;
    BasicHttpRequest mHttpRequest;
    String mPath;
    HttpHost mHost;
    HttpHost mProxyHost;
    volatile boolean mCancelled;
    int mFailCount;
    private int mReceivedBytes;
    private InputStream mBodyProvider;
    private int mBodyLength;
    private static String HOST_HEADER = "Host";
    private static String ACCEPT_ENCODING_HEADER = "Accept-Encoding";
    private static String CONTENT_LENGTH_HEADER = "content-length";
    private Object mClientResource;
    private boolean mLoadingPaused;
    private static RequestContent requestContentProcessor;

    private void $$robo$$android_net_http_Request$__constructor__(String method, HttpHost host, HttpHost proxyHost, String path, InputStream bodyProvider, int bodyLength, EventHandler eventHandler, Map<String, String> headers) {
        this.mCancelled = false;
        this.mFailCount = 0;
        this.mReceivedBytes = 0;
        this.mClientResource = new Object();
        this.mLoadingPaused = false;
        this.mEventHandler = eventHandler;
        this.mHost = host;
        this.mProxyHost = proxyHost;
        this.mPath = path;
        this.mBodyProvider = bodyProvider;
        this.mBodyLength = bodyLength;
        if (bodyProvider == null && !"POST".equalsIgnoreCase(method)) {
            this.mHttpRequest = new BasicHttpRequest(method, this.getUri());
        } else {
            this.mHttpRequest = new BasicHttpEntityEnclosingRequest(method, this.getUri());
            if (bodyProvider != null) {
                this.setBodyProvider(bodyProvider, bodyLength);
            }
        }
        this.addHeader("Host", this.getHostPort());
        this.addHeader("Accept-Encoding", "gzip");
        this.addHeaders(headers);
    }

    private final synchronized void $$robo$$android_net_http_Request$setLoadingPaused(boolean pause) {
        this.mLoadingPaused = pause;
        if (!this.mLoadingPaused) {
            this.notify();
        }
    }

    private final void $$robo$$android_net_http_Request$setConnection(Connection connection) {
        this.mConnection = connection;
    }

    private final EventHandler $$robo$$android_net_http_Request$getEventHandler() {
        return this.mEventHandler;
    }

    private final void $$robo$$android_net_http_Request$addHeader(String name, String value) {
        if (name == null) {
            String damage = "Null http header name";
            HttpLog.e(damage);
            throw new NullPointerException(damage);
        }
        if (value == null || value.length() == 0) {
            String damage = "Null or empty value for header \"" + name + "\"";
            HttpLog.e(damage);
            throw new RuntimeException(damage);
        }
        this.mHttpRequest.addHeader(name, value);
    }

    private final void $$robo$$android_net_http_Request$addHeaders(Map<String, String> headers) {
        if (headers == null) {
            return;
        }
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.addHeader(entry.getKey(), entry.getValue());
        }
    }

    private final void $$robo$$android_net_http_Request$sendRequest(AndroidHttpClientConnection httpClientConnection) throws HttpException, IOException {
        if (this.mCancelled) {
            return;
        }
        requestContentProcessor.process(this.mHttpRequest, this.mConnection.getHttpContext());
        httpClientConnection.sendRequestHeader(this.mHttpRequest);
        if (this.mHttpRequest instanceof HttpEntityEnclosingRequest) {
            httpClientConnection.sendRequestEntity((HttpEntityEnclosingRequest)((Object)this.mHttpRequest));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_http_Request$readResponse(AndroidHttpClientConnection httpClientConnection) throws IOException, ParseException {
        if (this.mCancelled) {
            return;
        }
        StatusLine statusLine = null;
        boolean hasBody = false;
        httpClientConnection.flush();
        int statusCode = 0;
        Headers header = new Headers();
        while ((statusCode = (statusLine = httpClientConnection.parseResponseHeader(header)).getStatusCode()) < 200) {
        }
        ProtocolVersion v = statusLine.getProtocolVersion();
        this.mEventHandler.status(v.getMajor(), v.getMinor(), statusCode, statusLine.getReasonPhrase());
        this.mEventHandler.headers(header);
        HttpEntity entity = null;
        hasBody = Request.canResponseHaveBody(this.mHttpRequest, statusCode);
        if (hasBody) {
            entity = httpClientConnection.receiveResponseEntity(header);
        }
        boolean supportPartialContent = "bytes".equalsIgnoreCase(header.getAcceptRanges());
        if (entity != null) {
            InputStream is = entity.getContent();
            Header contentEncoding = entity.getContentEncoding();
            InputStream nis = null;
            byte[] buf = null;
            int count = 0;
            try {
                nis = contentEncoding != null && contentEncoding.getValue().equals("gzip") ? new GZIPInputStream(is) : is;
                buf = this.mConnection.getBuf();
                int len = 0;
                int lowWater = buf.length / 2;
                while (len != -1) {
                    Request request = this;
                    synchronized (request) {
                        while (this.mLoadingPaused) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException e) {
                                HttpLog.e("Interrupted exception whilst network thread paused at WebCore's request. " + e.getMessage());
                            }
                        }
                    }
                    len = nis.read(buf, count, buf.length - count);
                    if (len != -1) {
                        count += len;
                        if (supportPartialContent) {
                            this.mReceivedBytes += len;
                        }
                    }
                    if (len != -1 && count < lowWater) continue;
                    this.mEventHandler.data(buf, count);
                    count = 0;
                }
            }
            catch (EOFException e) {
                if (count > 0) {
                    this.mEventHandler.data(buf, count);
                }
            }
            catch (IOException e) {
                if (statusCode == 200 || statusCode == 206) {
                    if (supportPartialContent && count > 0) {
                        this.mEventHandler.data(buf, count);
                    }
                    throw e;
                }
            }
            finally {
                if (nis != null) {
                    nis.close();
                }
            }
        }
        this.mConnection.setCanPersist(entity, statusLine.getProtocolVersion(), header.getConnectionType());
        this.mEventHandler.endData();
        this.complete();
    }

    private final synchronized void $$robo$$android_net_http_Request$cancel() {
        this.mLoadingPaused = false;
        this.notify();
        this.mCancelled = true;
        if (this.mConnection != null) {
            this.mConnection.cancel();
        }
    }

    private final String $$robo$$android_net_http_Request$getHostPort() {
        String myScheme = this.mHost.getSchemeName();
        int myPort = this.mHost.getPort();
        if (myPort != 80 && myScheme.equals("http") || myPort != 443 && myScheme.equals("https")) {
            return this.mHost.toHostString();
        }
        return this.mHost.getHostName();
    }

    private final String $$robo$$android_net_http_Request$getUri() {
        if (this.mProxyHost == null || this.mHost.getSchemeName().equals("https")) {
            return this.mPath;
        }
        return this.mHost.getSchemeName() + "://" + this.getHostPort() + this.mPath;
    }

    private final String $$robo$$android_net_http_Request$toString() {
        return this.mPath;
    }

    private final void $$robo$$android_net_http_Request$reset() {
        this.mHttpRequest.removeHeaders("content-length");
        if (this.mBodyProvider != null) {
            try {
                this.mBodyProvider.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.setBodyProvider(this.mBodyProvider, this.mBodyLength);
        }
        if (this.mReceivedBytes > 0) {
            this.mFailCount = 0;
            HttpLog.v("*** Request.reset() to range:" + this.mReceivedBytes);
            this.mHttpRequest.setHeader("Range", "bytes=" + this.mReceivedBytes + "-");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_http_Request$waitUntilComplete() {
        Object object = this.mClientResource;
        synchronized (object) {
            try {
                this.mClientResource.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_http_Request$complete() {
        Object object = this.mClientResource;
        synchronized (object) {
            this.mClientResource.notifyAll();
        }
    }

    private static final boolean $$robo$$android_net_http_Request$canResponseHaveBody(HttpRequest request, int status) {
        if ("HEAD".equalsIgnoreCase(request.getRequestLine().getMethod())) {
            return false;
        }
        return status >= 200 && status != 204 && status != 304;
    }

    private final void $$robo$$android_net_http_Request$setBodyProvider(InputStream bodyProvider, int bodyLength) {
        if (!bodyProvider.markSupported()) {
            throw new IllegalArgumentException("bodyProvider must support mark()");
        }
        bodyProvider.mark(Integer.MAX_VALUE);
        ((BasicHttpEntityEnclosingRequest)this.mHttpRequest).setEntity(new InputStreamEntity(bodyProvider, bodyLength));
    }

    private final void $$robo$$android_net_http_Request$handleSslErrorResponse(boolean proceed) {
        HttpsConnection connection = (HttpsConnection)this.mConnection;
        if (connection != null) {
            connection.restartConnection(proceed);
        }
    }

    private final void $$robo$$android_net_http_Request$error(int errorId, int resourceId) {
        this.mEventHandler.error(errorId, this.mConnection.mContext.getText(resourceId).toString());
    }

    static void __staticInitializer__() {
        requestContentProcessor = new RequestContent();
    }

    private void __constructor__(String string2, HttpHost httpHost, HttpHost httpHost2, String string3, InputStream inputStream, int n, EventHandler eventHandler, Map<String, String> map) {
        this.$$robo$$android_net_http_Request$__constructor__(string2, httpHost, httpHost2, string3, inputStream, n, eventHandler, map);
    }

    Request(String string2, HttpHost httpHost, HttpHost httpHost2, String string3, InputStream inputStream, int n, EventHandler eventHandler, Map<String, String> map) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_http_Request$__constructor__(java.lang.String org.apache.http.HttpHost org.apache.http.HttpHost java.lang.String java.io.InputStream int android.net.http.EventHandler java.util.Map<java.lang.String, java.lang.String> ), 0, this, string2, httpHost, httpHost2, string3, inputStream, n, eventHandler, map);
    }

    synchronized void setLoadingPaused(boolean bl) {
        InvokeDynamicSupport.bootstrap("setLoadingPaused", $$robo$$android_net_http_Request$setLoadingPaused(boolean ), 0, this, bl);
    }

    void setConnection(Connection connection) {
        InvokeDynamicSupport.bootstrap("setConnection", $$robo$$android_net_http_Request$setConnection(android.net.http.Connection ), 0, this, connection);
    }

    EventHandler getEventHandler() {
        return InvokeDynamicSupport.bootstrap("getEventHandler", $$robo$$android_net_http_Request$getEventHandler(), 0, this);
    }

    void addHeader(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("addHeader", $$robo$$android_net_http_Request$addHeader(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    void addHeaders(Map<String, String> map) {
        InvokeDynamicSupport.bootstrap("addHeaders", $$robo$$android_net_http_Request$addHeaders(java.util.Map<java.lang.String, java.lang.String> ), 0, this, map);
    }

    void sendRequest(AndroidHttpClientConnection androidHttpClientConnection) throws HttpException, IOException {
        InvokeDynamicSupport.bootstrap("sendRequest", $$robo$$android_net_http_Request$sendRequest(android.net.http.AndroidHttpClientConnection ), 0, this, androidHttpClientConnection);
    }

    void readResponse(AndroidHttpClientConnection androidHttpClientConnection) throws IOException, ParseException {
        InvokeDynamicSupport.bootstrap("readResponse", $$robo$$android_net_http_Request$readResponse(android.net.http.AndroidHttpClientConnection ), 0, this, androidHttpClientConnection);
    }

    synchronized void cancel() {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_net_http_Request$cancel(), 0, this);
    }

    String getHostPort() {
        return InvokeDynamicSupport.bootstrap("getHostPort", $$robo$$android_net_http_Request$getHostPort(), 0, this);
    }

    String getUri() {
        return InvokeDynamicSupport.bootstrap("getUri", $$robo$$android_net_http_Request$getUri(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_http_Request$toString(), 0, this);
    }

    void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_net_http_Request$reset(), 0, this);
    }

    void waitUntilComplete() {
        InvokeDynamicSupport.bootstrap("waitUntilComplete", $$robo$$android_net_http_Request$waitUntilComplete(), 0, this);
    }

    void complete() {
        InvokeDynamicSupport.bootstrap("complete", $$robo$$android_net_http_Request$complete(), 0, this);
    }

    private static boolean canResponseHaveBody(HttpRequest httpRequest, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("canResponseHaveBody", $$robo$$android_net_http_Request$canResponseHaveBody(org.apache.http.HttpRequest int ), 0, (HttpRequest)httpRequest, (int)n);
    }

    private void setBodyProvider(InputStream inputStream, int n) {
        InvokeDynamicSupport.bootstrap("setBodyProvider", $$robo$$android_net_http_Request$setBodyProvider(java.io.InputStream int ), 0, this, inputStream, n);
    }

    public void handleSslErrorResponse(boolean bl) {
        InvokeDynamicSupport.bootstrap("handleSslErrorResponse", $$robo$$android_net_http_Request$handleSslErrorResponse(boolean ), 0, this, bl);
    }

    void error(int n, int n2) {
        InvokeDynamicSupport.bootstrap("error", $$robo$$android_net_http_Request$error(int int ), 0, this, n, n2);
    }

    static {
        RobolectricInternals.classInitializing(Request.class);
    }

    public /* synthetic */ Request() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Request)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

