/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.net.ParseException;
import android.net.WebAddress;
import android.net.http.Connection;
import android.net.http.EventHandler;
import android.net.http.Request;
import android.net.http.RequestQueue;
import android.webkit.CookieManager;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import junit.framework.Assert;
import org.apache.commons.codec.binary.Base64;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RequestHandle
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private String mUrl;
    private WebAddress mUri;
    private String mMethod;
    private Map<String, String> mHeaders;
    private RequestQueue mRequestQueue;
    private Request mRequest;
    private InputStream mBodyProvider;
    private int mBodyLength;
    private int mRedirectCount;
    private Connection mConnection;
    private static String AUTHORIZATION_HEADER = "Authorization";
    private static String PROXY_AUTHORIZATION_HEADER = "Proxy-Authorization";
    public static int MAX_REDIRECT_COUNT = 16;

    private void $$robo$$android_net_http_RequestHandle$__constructor__(RequestQueue requestQueue, String url, WebAddress uri, String method, Map<String, String> headers, InputStream bodyProvider, int bodyLength, Request request) {
        this.mRedirectCount = 0;
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        this.mHeaders = headers;
        this.mBodyProvider = bodyProvider;
        this.mBodyLength = bodyLength;
        this.mMethod = method == null ? "GET" : method;
        this.mUrl = url;
        this.mUri = uri;
        this.mRequestQueue = requestQueue;
        this.mRequest = request;
    }

    private void $$robo$$android_net_http_RequestHandle$__constructor__(RequestQueue requestQueue, String url, WebAddress uri, String method, Map<String, String> headers, InputStream bodyProvider, int bodyLength, Request request, Connection conn) {
        this.mConnection = conn;
    }

    private final void $$robo$$android_net_http_RequestHandle$cancel() {
        if (this.mRequest != null) {
            this.mRequest.cancel();
        }
    }

    private final void $$robo$$android_net_http_RequestHandle$pauseRequest(boolean pause) {
        if (this.mRequest != null) {
            this.mRequest.setLoadingPaused(pause);
        }
    }

    private final void $$robo$$android_net_http_RequestHandle$handleSslErrorResponse(boolean proceed) {
        if (this.mRequest != null) {
            this.mRequest.handleSslErrorResponse(proceed);
        }
    }

    private final boolean $$robo$$android_net_http_RequestHandle$isRedirectMax() {
        return this.mRedirectCount >= 16;
    }

    private final int $$robo$$android_net_http_RequestHandle$getRedirectCount() {
        return this.mRedirectCount;
    }

    private final void $$robo$$android_net_http_RequestHandle$setRedirectCount(int count) {
        this.mRedirectCount = count;
    }

    /*
     * Unable to fully structure code
     */
    private final boolean $$robo$$android_net_http_RequestHandle$setupRedirect(String redirectTo, int statusCode, Map<String, String> cacheHeaders) {
        this.mHeaders.remove("Authorization");
        this.mHeaders.remove("Proxy-Authorization");
        if (++this.mRedirectCount == 16) {
            this.mRequest.error(-9, 17039574);
            return false;
        }
        if (this.mUrl.startsWith("https:") && redirectTo.startsWith("http:")) {
            this.mHeaders.remove("Referer");
        }
        this.mUrl = redirectTo;
        try {
            this.mUri = new WebAddress(this.mUrl);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        this.mHeaders.remove("Cookie");
        cookie = CookieManager.getInstance().getCookie(this.mUri);
        if (cookie != null && cookie.length() > 0) {
            this.mHeaders.put("Cookie", cookie);
        }
        if ((statusCode == 302 || statusCode == 303) && this.mMethod.equals("POST")) {
            this.mMethod = "GET";
        }
        if (statusCode == 307) {
            try {
                if (this.mBodyProvider == null) ** GOTO lbl35
                this.mBodyProvider.reset();
            }
            catch (IOException ex) {
                return false;
            }
        } else {
            this.mHeaders.remove("Content-Type");
            this.mBodyProvider = null;
        }
lbl35:
        // 3 sources

        this.mHeaders.putAll(cacheHeaders);
        this.createAndQueueNewRequest();
        return true;
    }

    private final void $$robo$$android_net_http_RequestHandle$setupBasicAuthResponse(boolean isProxy, String username, String password) {
        String response = RequestHandle.computeBasicAuthResponse(username, password);
        this.mHeaders.put(RequestHandle.authorizationHeader(isProxy), "Basic " + response);
        this.setupAuthResponse();
    }

    private final void $$robo$$android_net_http_RequestHandle$setupDigestAuthResponse(boolean isProxy, String username, String password, String realm, String nonce, String QOP, String algorithm, String opaque) {
        String response = this.computeDigestAuthResponse(username, password, realm, nonce, QOP, algorithm, opaque);
        this.mHeaders.put(RequestHandle.authorizationHeader(isProxy), "Digest " + response);
        this.setupAuthResponse();
    }

    private final void $$robo$$android_net_http_RequestHandle$setupAuthResponse() {
        try {
            if (this.mBodyProvider != null) {
                this.mBodyProvider.reset();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.createAndQueueNewRequest();
    }

    private final String $$robo$$android_net_http_RequestHandle$getMethod() {
        return this.mMethod;
    }

    private static final String $$robo$$android_net_http_RequestHandle$computeBasicAuthResponse(String username, String password) {
        Assert.assertNotNull((Object)username);
        Assert.assertNotNull((Object)password);
        return new String(Base64.encodeBase64((username + ':' + password).getBytes()));
    }

    private final void $$robo$$android_net_http_RequestHandle$waitUntilComplete() {
        this.mRequest.waitUntilComplete();
    }

    private final void $$robo$$android_net_http_RequestHandle$processRequest() {
        if (this.mConnection != null) {
            this.mConnection.processRequests(this.mRequest);
        }
    }

    private final String $$robo$$android_net_http_RequestHandle$computeDigestAuthResponse(String username, String password, String realm, String nonce, String QOP, String algorithm, String opaque) {
        Assert.assertNotNull((Object)username);
        Assert.assertNotNull((Object)password);
        Assert.assertNotNull((Object)realm);
        String A1 = username + ":" + realm + ":" + password;
        String A2 = this.mMethod + ":" + this.mUrl;
        String nc = "00000001";
        String cnonce = this.computeCnonce();
        String digest = this.computeDigest(A1, A2, nonce, QOP, nc, cnonce);
        String response = "";
        response = response + "username=" + this.doubleQuote(username) + ", ";
        response = response + "realm=" + this.doubleQuote(realm) + ", ";
        response = response + "nonce=" + this.doubleQuote(nonce) + ", ";
        response = response + "uri=" + this.doubleQuote(this.mUrl) + ", ";
        response = response + "response=" + this.doubleQuote(digest);
        if (opaque != null) {
            response = response + ", opaque=" + this.doubleQuote(opaque);
        }
        if (algorithm != null) {
            response = response + ", algorithm=" + algorithm;
        }
        if (QOP != null) {
            response = response + ", qop=" + QOP + ", nc=" + nc + ", cnonce=" + this.doubleQuote(cnonce);
        }
        return response;
    }

    private static final String $$robo$$android_net_http_RequestHandle$authorizationHeader(boolean isProxy) {
        if (!isProxy) {
            return "Authorization";
        }
        return "Proxy-Authorization";
    }

    private final String $$robo$$android_net_http_RequestHandle$computeDigest(String A1, String A2, String nonce, String QOP, String nc, String cnonce) {
        if (QOP == null) {
            return this.KD(this.H(A1), nonce + ":" + this.H(A2));
        }
        if (QOP.equalsIgnoreCase("auth")) {
            return this.KD(this.H(A1), nonce + ":" + nc + ":" + cnonce + ":" + QOP + ":" + this.H(A2));
        }
        return null;
    }

    private final String $$robo$$android_net_http_RequestHandle$KD(String secret, String data) {
        return this.H(secret + ":" + data);
    }

    private final String $$robo$$android_net_http_RequestHandle$H(String param) {
        if (param != null) {
            try {
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                byte[] d = md5.digest(param.getBytes());
                if (d != null) {
                    return this.bufferToHex(d);
                }
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private final String $$robo$$android_net_http_RequestHandle$bufferToHex(byte[] buffer) {
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        if (buffer != null) {
            int length = buffer.length;
            if (length > 0) {
                StringBuilder hex = new StringBuilder(2 * length);
                for (int i = 0; i < length; ++i) {
                    byte l = (byte)(buffer[i] & 0xF);
                    byte h = (byte)((buffer[i] & 0xF0) >> 4);
                    hex.append(hexChars[h]);
                    hex.append(hexChars[l]);
                }
                return hex.toString();
            }
            return "";
        }
        return null;
    }

    private final String $$robo$$android_net_http_RequestHandle$computeCnonce() {
        Random rand = new Random();
        int nextInt = rand.nextInt();
        nextInt = nextInt == Integer.MIN_VALUE ? Integer.MAX_VALUE : Math.abs(nextInt);
        return Integer.toString(nextInt, 16);
    }

    private final String $$robo$$android_net_http_RequestHandle$doubleQuote(String param) {
        if (param != null) {
            return "\"" + param + "\"";
        }
        return null;
    }

    private final void $$robo$$android_net_http_RequestHandle$createAndQueueNewRequest() {
        if (this.mConnection != null) {
            RequestHandle newHandle = this.mRequestQueue.queueSynchronousRequest(this.mUrl, this.mUri, this.mMethod, this.mHeaders, this.mRequest.mEventHandler, this.mBodyProvider, this.mBodyLength);
            this.mRequest = newHandle.mRequest;
            this.mConnection = newHandle.mConnection;
            newHandle.processRequest();
            return;
        }
        this.mRequest = this.mRequestQueue.queueRequest((String)this.mUrl, (WebAddress)this.mUri, (String)this.mMethod, this.mHeaders, (EventHandler)this.mRequest.mEventHandler, (InputStream)this.mBodyProvider, (int)this.mBodyLength).mRequest;
    }

    private void __constructor__(RequestQueue requestQueue, String string2, WebAddress webAddress, String string3, Map<String, String> map, InputStream inputStream, int n, Request request) {
        this.$$robo$$android_net_http_RequestHandle$__constructor__(requestQueue, string2, webAddress, string3, map, inputStream, n, request);
    }

    public RequestHandle(RequestQueue requestQueue, String string2, WebAddress webAddress, String string3, Map<String, String> map, InputStream inputStream, int n, Request request) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_http_RequestHandle$__constructor__(android.net.http.RequestQueue java.lang.String android.net.WebAddress java.lang.String java.util.Map<java.lang.String, java.lang.String> java.io.InputStream int android.net.http.Request ), 0, this, requestQueue, string2, webAddress, string3, map, inputStream, n, request);
    }

    private void __constructor__(RequestQueue requestQueue, String string2, WebAddress webAddress, String string3, Map<String, String> map, InputStream inputStream, int n, Request request, Connection connection) {
        this.$$robo$$android_net_http_RequestHandle$__constructor__(requestQueue, string2, webAddress, string3, map, inputStream, n, request, connection);
    }

    public RequestHandle(RequestQueue requestQueue, String string2, WebAddress webAddress, String string3, Map<String, String> map, InputStream inputStream, int n, Request request, Connection connection) {
        this(requestQueue, string2, webAddress, string3, map, inputStream, n, request);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_http_RequestHandle$__constructor__(android.net.http.RequestQueue java.lang.String android.net.WebAddress java.lang.String java.util.Map<java.lang.String, java.lang.String> java.io.InputStream int android.net.http.Request android.net.http.Connection ), 0, this, requestQueue, string2, webAddress, string3, map, inputStream, n, request, connection);
    }

    public void cancel() {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_net_http_RequestHandle$cancel(), 0, this);
    }

    public void pauseRequest(boolean bl) {
        InvokeDynamicSupport.bootstrap("pauseRequest", $$robo$$android_net_http_RequestHandle$pauseRequest(boolean ), 0, this, bl);
    }

    public void handleSslErrorResponse(boolean bl) {
        InvokeDynamicSupport.bootstrap("handleSslErrorResponse", $$robo$$android_net_http_RequestHandle$handleSslErrorResponse(boolean ), 0, this, bl);
    }

    public boolean isRedirectMax() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRedirectMax", $$robo$$android_net_http_RequestHandle$isRedirectMax(), 0, this);
    }

    public int getRedirectCount() {
        return (int)InvokeDynamicSupport.bootstrap("getRedirectCount", $$robo$$android_net_http_RequestHandle$getRedirectCount(), 0, this);
    }

    public void setRedirectCount(int n) {
        InvokeDynamicSupport.bootstrap("setRedirectCount", $$robo$$android_net_http_RequestHandle$setRedirectCount(int ), 0, this, n);
    }

    public boolean setupRedirect(String string2, int n, Map<String, String> map) {
        return (boolean)InvokeDynamicSupport.bootstrap("setupRedirect", $$robo$$android_net_http_RequestHandle$setupRedirect(java.lang.String int java.util.Map<java.lang.String, java.lang.String> ), 0, this, string2, n, map);
    }

    public void setupBasicAuthResponse(boolean bl, String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setupBasicAuthResponse", $$robo$$android_net_http_RequestHandle$setupBasicAuthResponse(boolean java.lang.String java.lang.String ), 0, this, bl, string2, string3);
    }

    public void setupDigestAuthResponse(boolean bl, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        InvokeDynamicSupport.bootstrap("setupDigestAuthResponse", $$robo$$android_net_http_RequestHandle$setupDigestAuthResponse(boolean java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String ), 0, this, bl, string2, string3, string4, string5, string6, string7, string8);
    }

    private void setupAuthResponse() {
        InvokeDynamicSupport.bootstrap("setupAuthResponse", $$robo$$android_net_http_RequestHandle$setupAuthResponse(), 0, this);
    }

    public String getMethod() {
        return InvokeDynamicSupport.bootstrap("getMethod", $$robo$$android_net_http_RequestHandle$getMethod(), 0, this);
    }

    public static String computeBasicAuthResponse(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("computeBasicAuthResponse", $$robo$$android_net_http_RequestHandle$computeBasicAuthResponse(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public void waitUntilComplete() {
        InvokeDynamicSupport.bootstrap("waitUntilComplete", $$robo$$android_net_http_RequestHandle$waitUntilComplete(), 0, this);
    }

    public void processRequest() {
        InvokeDynamicSupport.bootstrap("processRequest", $$robo$$android_net_http_RequestHandle$processRequest(), 0, this);
    }

    private String computeDigestAuthResponse(String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        return InvokeDynamicSupport.bootstrap("computeDigestAuthResponse", $$robo$$android_net_http_RequestHandle$computeDigestAuthResponse(java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String ), 0, this, string2, string3, string4, string5, string6, string7, string8);
    }

    public static String authorizationHeader(boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("authorizationHeader", $$robo$$android_net_http_RequestHandle$authorizationHeader(boolean ), 0, (boolean)bl);
    }

    private String computeDigest(String string2, String string3, String string4, String string5, String string6, String string7) {
        return InvokeDynamicSupport.bootstrap("computeDigest", $$robo$$android_net_http_RequestHandle$computeDigest(java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String ), 0, this, string2, string3, string4, string5, string6, string7);
    }

    private String KD(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("KD", $$robo$$android_net_http_RequestHandle$KD(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    private String H(String string2) {
        return InvokeDynamicSupport.bootstrap("H", $$robo$$android_net_http_RequestHandle$H(java.lang.String ), 0, this, string2);
    }

    private String bufferToHex(byte[] byArray) {
        return InvokeDynamicSupport.bootstrap("bufferToHex", $$robo$$android_net_http_RequestHandle$bufferToHex(byte[] ), 0, this, byArray);
    }

    private String computeCnonce() {
        return InvokeDynamicSupport.bootstrap("computeCnonce", $$robo$$android_net_http_RequestHandle$computeCnonce(), 0, this);
    }

    private String doubleQuote(String string2) {
        return InvokeDynamicSupport.bootstrap("doubleQuote", $$robo$$android_net_http_RequestHandle$doubleQuote(java.lang.String ), 0, this, string2);
    }

    private void createAndQueueNewRequest() {
        InvokeDynamicSupport.bootstrap("createAndQueueNewRequest", $$robo$$android_net_http_RequestHandle$createAndQueueNewRequest(), 0, this);
    }

    public /* synthetic */ RequestHandle() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RequestHandle)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

