/*
 * Decompiled with CFR 0.152.
 */
package android.net.http;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Proxy;
import android.net.WebAddress;
import android.net.http.Connection;
import android.net.http.ConnectionThread;
import android.net.http.EventHandler;
import android.net.http.HttpLog;
import android.net.http.IdleCache;
import android.net.http.LoggingEventHandler;
import android.net.http.Request;
import android.net.http.RequestFeeder;
import android.net.http.RequestHandle;
import android.util.Log;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import org.apache.http.HttpHost;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RequestQueue
implements RequestFeeder,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private LinkedHashMap<HttpHost, LinkedList<Request>> mPending;
    private Context mContext;
    private ActivePool mActivePool;
    private ConnectivityManager mConnectivityManager;
    private HttpHost mProxyHost;
    private BroadcastReceiver mProxyChangeReceiver;
    private static int CONNECTION_COUNT = 4;

    private void $$robo$$android_net_http_RequestQueue$__constructor__(Context context) {
    }

    private void $$robo$$android_net_http_RequestQueue$__constructor__(Context context, int connectionCount) {
        this.mProxyHost = null;
        this.mContext = context;
        this.mPending = new LinkedHashMap(32);
        this.mActivePool = new ActivePool(this, connectionCount);
        this.mActivePool.startup();
        this.mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
    }

    private final synchronized void $$robo$$android_net_http_RequestQueue$enablePlatformNotifications() {
        if (this.mProxyChangeReceiver == null) {
            this.mProxyChangeReceiver = new ShadowedObject(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ RequestQueue this$0;

                private void $$robo$$android_net_http_RequestQueue_1$__constructor__(RequestQueue requestQueue) {
                }

                private final void $$robo$$android_net_http_RequestQueue_1$onReceive(Context ctx, Intent intent) {
                    this.this$0.setProxyConfig();
                }

                private void __constructor__(RequestQueue requestQueue) {
                    this.$$robo$$android_net_http_RequestQueue_1$__constructor__(requestQueue);
                }
                {
                    this.this$0 = requestQueue;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_http_RequestQueue_1$__constructor__(android.net.http.RequestQueue ), 0, this, requestQueue);
                }

                @Override
                public void onReceive(Context context, Intent intent) {
                    InvokeDynamicSupport.bootstrap("onReceive", $$robo$$android_net_http_RequestQueue_1$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mContext.registerReceiver(this.mProxyChangeReceiver, new IntentFilter("android.intent.action.PROXY_CHANGE"));
        }
        this.setProxyConfig();
    }

    private final synchronized void $$robo$$android_net_http_RequestQueue$disablePlatformNotifications() {
        if (this.mProxyChangeReceiver != null) {
            this.mContext.unregisterReceiver(this.mProxyChangeReceiver);
            this.mProxyChangeReceiver = null;
        }
    }

    private final synchronized void $$robo$$android_net_http_RequestQueue$setProxyConfig() {
        NetworkInfo info = this.mConnectivityManager.getActiveNetworkInfo();
        if (info != null && info.getType() == 1) {
            this.mProxyHost = null;
        } else {
            String host = Proxy.getHost(this.mContext);
            if (host == null) {
                this.mProxyHost = null;
            } else {
                this.mActivePool.disablePersistence();
                this.mProxyHost = new HttpHost(host, Proxy.getPort(this.mContext), "http");
            }
        }
    }

    private final HttpHost $$robo$$android_net_http_RequestQueue$getProxyHost() {
        return this.mProxyHost;
    }

    private final RequestHandle $$robo$$android_net_http_RequestQueue$queueRequest(String url, String method, Map<String, String> headers, EventHandler eventHandler, InputStream bodyProvider, int bodyLength) {
        WebAddress uri = new WebAddress(url);
        return this.queueRequest(url, uri, method, headers, eventHandler, bodyProvider, bodyLength);
    }

    private final RequestHandle $$robo$$android_net_http_RequestQueue$queueRequest(String url, WebAddress uri, String method, Map<String, String> headers, EventHandler eventHandler, InputStream bodyProvider, int bodyLength) {
        if (eventHandler == null) {
            eventHandler = new LoggingEventHandler();
        }
        HttpHost httpHost = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
        Request req = new Request(method, httpHost, this.mProxyHost, uri.getPath(), bodyProvider, bodyLength, eventHandler, headers);
        this.queueRequest(req, false);
        this.mActivePool.mTotalRequest++;
        this.mActivePool.startConnectionThread();
        return new RequestHandle(this, url, uri, method, headers, bodyProvider, bodyLength, req);
    }

    private final RequestHandle $$robo$$android_net_http_RequestQueue$queueSynchronousRequest(String url, WebAddress uri, String method, Map<String, String> headers, EventHandler eventHandler, InputStream bodyProvider, int bodyLength) {
        HttpHost host = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
        Request req = new Request(method, host, this.mProxyHost, uri.getPath(), bodyProvider, bodyLength, eventHandler, headers);
        host = this.determineHost(host);
        Connection conn = Connection.getConnection(this.mContext, host, this.mProxyHost, new SyncFeeder());
        return new RequestHandle(this, url, uri, method, headers, bodyProvider, bodyLength, req, conn);
    }

    private final HttpHost $$robo$$android_net_http_RequestQueue$determineHost(HttpHost host) {
        return this.mProxyHost == null || "https".equals(host.getSchemeName()) ? host : this.mProxyHost;
    }

    private final synchronized boolean $$robo$$android_net_http_RequestQueue$requestsPending() {
        return !this.mPending.isEmpty();
    }

    private final synchronized void $$robo$$android_net_http_RequestQueue$dump() {
        HttpLog.v("dump()");
        StringBuilder dump = new StringBuilder();
        int count = 0;
        if (!this.mPending.isEmpty()) {
            Iterator iter = this.mPending.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String hostName = ((HttpHost)entry.getKey()).getHostName();
                StringBuilder line = new StringBuilder("p" + count++ + " " + hostName + " ");
                LinkedList reqList = (LinkedList)entry.getValue();
                ListIterator reqIter = reqList.listIterator(0);
                while (iter.hasNext()) {
                    Request request = (Request)((Object)iter.next());
                    line.append(request + " ");
                }
                dump.append((CharSequence)line);
                dump.append("\n");
            }
        }
        HttpLog.v(dump.toString());
    }

    private final synchronized Request $$robo$$android_net_http_RequestQueue$getRequest() {
        Request ret = null;
        if (!this.mPending.isEmpty()) {
            ret = this.removeFirst(this.mPending);
        }
        return ret;
    }

    private final synchronized Request $$robo$$android_net_http_RequestQueue$getRequest(HttpHost host) {
        Request ret = null;
        if (this.mPending.containsKey(host)) {
            LinkedList<Request> reqList = this.mPending.get(host);
            ret = reqList.removeFirst();
            if (reqList.isEmpty()) {
                this.mPending.remove(host);
            }
        }
        return ret;
    }

    private final synchronized boolean $$robo$$android_net_http_RequestQueue$haveRequest(HttpHost host) {
        return this.mPending.containsKey(host);
    }

    private final void $$robo$$android_net_http_RequestQueue$requeueRequest(Request request) {
        this.queueRequest(request, true);
    }

    private final void $$robo$$android_net_http_RequestQueue$shutdown() {
        this.mActivePool.shutdown();
    }

    private final synchronized void $$robo$$android_net_http_RequestQueue$queueRequest(Request request, boolean head) {
        LinkedList<Object> reqList;
        HttpHost host;
        HttpHost httpHost = host = request.mProxyHost == null ? request.mHost : request.mProxyHost;
        if (this.mPending.containsKey(host)) {
            reqList = this.mPending.get(host);
        } else {
            reqList = new LinkedList();
            this.mPending.put(host, reqList);
        }
        if (head) {
            reqList.addFirst(request);
        } else {
            reqList.add(request);
        }
    }

    private final void $$robo$$android_net_http_RequestQueue$startTiming() {
        this.mActivePool.startTiming();
    }

    private final void $$robo$$android_net_http_RequestQueue$stopTiming() {
        this.mActivePool.stopTiming();
    }

    private final Request $$robo$$android_net_http_RequestQueue$removeFirst(LinkedHashMap<HttpHost, LinkedList<Request>> requestQueue) {
        Request ret = null;
        Iterator iter = requestQueue.entrySet().iterator();
        if (iter.hasNext()) {
            Map.Entry entry = iter.next();
            LinkedList reqList = (LinkedList)entry.getValue();
            ret = (Request)reqList.removeFirst();
            if (reqList.isEmpty()) {
                requestQueue.remove(entry.getKey());
            }
        }
        return ret;
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_net_http_RequestQueue$__constructor__(context);
    }

    public RequestQueue(Context context) {
        this(context, 4);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_http_RequestQueue$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, int n) {
        this.$$robo$$android_net_http_RequestQueue$__constructor__(context, n);
    }

    public RequestQueue(Context context, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_http_RequestQueue$__constructor__(android.content.Context int ), 0, this, context, n);
    }

    public synchronized void enablePlatformNotifications() {
        InvokeDynamicSupport.bootstrap("enablePlatformNotifications", $$robo$$android_net_http_RequestQueue$enablePlatformNotifications(), 0, this);
    }

    public synchronized void disablePlatformNotifications() {
        InvokeDynamicSupport.bootstrap("disablePlatformNotifications", $$robo$$android_net_http_RequestQueue$disablePlatformNotifications(), 0, this);
    }

    private synchronized void setProxyConfig() {
        InvokeDynamicSupport.bootstrap("setProxyConfig", $$robo$$android_net_http_RequestQueue$setProxyConfig(), 0, this);
    }

    public HttpHost getProxyHost() {
        return InvokeDynamicSupport.bootstrap("getProxyHost", $$robo$$android_net_http_RequestQueue$getProxyHost(), 0, this);
    }

    public RequestHandle queueRequest(String string2, String string3, Map<String, String> map, EventHandler eventHandler, InputStream inputStream, int n) {
        return InvokeDynamicSupport.bootstrap("queueRequest", $$robo$$android_net_http_RequestQueue$queueRequest(java.lang.String java.lang.String java.util.Map<java.lang.String, java.lang.String> android.net.http.EventHandler java.io.InputStream int ), 0, this, string2, string3, map, eventHandler, inputStream, n);
    }

    public RequestHandle queueRequest(String string2, WebAddress webAddress, String string3, Map<String, String> map, EventHandler eventHandler, InputStream inputStream, int n) {
        return InvokeDynamicSupport.bootstrap("queueRequest", $$robo$$android_net_http_RequestQueue$queueRequest(java.lang.String android.net.WebAddress java.lang.String java.util.Map<java.lang.String, java.lang.String> android.net.http.EventHandler java.io.InputStream int ), 0, this, string2, webAddress, string3, map, eventHandler, inputStream, n);
    }

    public RequestHandle queueSynchronousRequest(String string2, WebAddress webAddress, String string3, Map<String, String> map, EventHandler eventHandler, InputStream inputStream, int n) {
        return InvokeDynamicSupport.bootstrap("queueSynchronousRequest", $$robo$$android_net_http_RequestQueue$queueSynchronousRequest(java.lang.String android.net.WebAddress java.lang.String java.util.Map<java.lang.String, java.lang.String> android.net.http.EventHandler java.io.InputStream int ), 0, this, string2, webAddress, string3, map, eventHandler, inputStream, n);
    }

    private HttpHost determineHost(HttpHost httpHost) {
        return InvokeDynamicSupport.bootstrap("determineHost", $$robo$$android_net_http_RequestQueue$determineHost(org.apache.http.HttpHost ), 0, this, httpHost);
    }

    synchronized boolean requestsPending() {
        return (boolean)InvokeDynamicSupport.bootstrap("requestsPending", $$robo$$android_net_http_RequestQueue$requestsPending(), 0, this);
    }

    synchronized void dump() {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_net_http_RequestQueue$dump(), 0, this);
    }

    @Override
    public synchronized Request getRequest() {
        return InvokeDynamicSupport.bootstrap("getRequest", $$robo$$android_net_http_RequestQueue$getRequest(), 0, this);
    }

    @Override
    public synchronized Request getRequest(HttpHost httpHost) {
        return InvokeDynamicSupport.bootstrap("getRequest", $$robo$$android_net_http_RequestQueue$getRequest(org.apache.http.HttpHost ), 0, this, httpHost);
    }

    @Override
    public synchronized boolean haveRequest(HttpHost httpHost) {
        return (boolean)InvokeDynamicSupport.bootstrap("haveRequest", $$robo$$android_net_http_RequestQueue$haveRequest(org.apache.http.HttpHost ), 0, this, httpHost);
    }

    @Override
    public void requeueRequest(Request request) {
        InvokeDynamicSupport.bootstrap("requeueRequest", $$robo$$android_net_http_RequestQueue$requeueRequest(android.net.http.Request ), 0, this, request);
    }

    public void shutdown() {
        InvokeDynamicSupport.bootstrap("shutdown", $$robo$$android_net_http_RequestQueue$shutdown(), 0, this);
    }

    protected synchronized void queueRequest(Request request, boolean bl) {
        InvokeDynamicSupport.bootstrap("queueRequest", $$robo$$android_net_http_RequestQueue$queueRequest(android.net.http.Request boolean ), 0, this, request, bl);
    }

    public void startTiming() {
        InvokeDynamicSupport.bootstrap("startTiming", $$robo$$android_net_http_RequestQueue$startTiming(), 0, this);
    }

    public void stopTiming() {
        InvokeDynamicSupport.bootstrap("stopTiming", $$robo$$android_net_http_RequestQueue$stopTiming(), 0, this);
    }

    private Request removeFirst(LinkedHashMap<HttpHost, LinkedList<Request>> linkedHashMap) {
        return InvokeDynamicSupport.bootstrap("removeFirst", $$robo$$android_net_http_RequestQueue$removeFirst(java.util.LinkedHashMap<org.apache.http.HttpHost, java.util.LinkedList<android.net.http.Request>> ), 0, this, linkedHashMap);
    }

    public /* synthetic */ RequestQueue() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RequestQueue)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    static interface ConnectionManager
    extends InstrumentedInterface {
        public HttpHost getProxyHost();

        public Connection getConnection(Context var1, HttpHost var2);

        public boolean recycleConnection(Connection var1);
    }

    private static class SyncFeeder
    implements RequestFeeder,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Request mRequest;

        private void $$robo$$android_net_http_RequestQueue_SyncFeeder$__constructor__() {
        }

        private final Request $$robo$$android_net_http_RequestQueue_SyncFeeder$getRequest() {
            Request r = this.mRequest;
            this.mRequest = null;
            return r;
        }

        private final Request $$robo$$android_net_http_RequestQueue_SyncFeeder$getRequest(HttpHost host) {
            return this.getRequest();
        }

        private final boolean $$robo$$android_net_http_RequestQueue_SyncFeeder$haveRequest(HttpHost host) {
            return this.mRequest != null;
        }

        private final void $$robo$$android_net_http_RequestQueue_SyncFeeder$requeueRequest(Request r) {
            this.mRequest = r;
        }

        private void __constructor__() {
            this.$$robo$$android_net_http_RequestQueue_SyncFeeder$__constructor__();
        }

        SyncFeeder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_http_RequestQueue_SyncFeeder$__constructor__(), 0, this);
        }

        @Override
        public Request getRequest() {
            return InvokeDynamicSupport.bootstrap("getRequest", $$robo$$android_net_http_RequestQueue_SyncFeeder$getRequest(), 0, this);
        }

        @Override
        public Request getRequest(HttpHost httpHost) {
            return InvokeDynamicSupport.bootstrap("getRequest", $$robo$$android_net_http_RequestQueue_SyncFeeder$getRequest(org.apache.http.HttpHost ), 0, this, httpHost);
        }

        @Override
        public boolean haveRequest(HttpHost httpHost) {
            return (boolean)InvokeDynamicSupport.bootstrap("haveRequest", $$robo$$android_net_http_RequestQueue_SyncFeeder$haveRequest(org.apache.http.HttpHost ), 0, this, httpHost);
        }

        @Override
        public void requeueRequest(Request request) {
            InvokeDynamicSupport.bootstrap("requeueRequest", $$robo$$android_net_http_RequestQueue_SyncFeeder$requeueRequest(android.net.http.Request ), 0, this, request);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SyncFeeder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class ActivePool
    implements ConnectionManager,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        ConnectionThread[] mThreads;
        IdleCache mIdleCache;
        private int mTotalRequest;
        private int mTotalConnection;
        private int mConnectionCount;
        /* synthetic */ RequestQueue this$0;

        private void $$robo$$android_net_http_RequestQueue_ActivePool$__constructor__(RequestQueue requestQueue, int connectionCount) {
            this.mIdleCache = new IdleCache();
            this.mConnectionCount = connectionCount;
            this.mThreads = new ConnectionThread[this.mConnectionCount];
            for (int i = 0; i < this.mConnectionCount; ++i) {
                this.mThreads[i] = new ConnectionThread(requestQueue.mContext, i, this, requestQueue);
            }
        }

        private final void $$robo$$android_net_http_RequestQueue_ActivePool$startup() {
            for (int i = 0; i < this.mConnectionCount; ++i) {
                this.mThreads[i].start();
            }
        }

        private final void $$robo$$android_net_http_RequestQueue_ActivePool$shutdown() {
            for (int i = 0; i < this.mConnectionCount; ++i) {
                this.mThreads[i].requestStop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_net_http_RequestQueue_ActivePool$startConnectionThread() {
            RequestQueue requestQueue = this.this$0;
            synchronized (requestQueue) {
                this.this$0.notify();
            }
        }

        private final void $$robo$$android_net_http_RequestQueue_ActivePool$startTiming() {
            for (int i = 0; i < this.mConnectionCount; ++i) {
                ConnectionThread rt = this.mThreads[i];
                rt.mCurrentThreadTime = -1L;
                rt.mTotalThreadTime = 0L;
            }
            this.mTotalRequest = 0;
            this.mTotalConnection = 0;
        }

        private final void $$robo$$android_net_http_RequestQueue_ActivePool$stopTiming() {
            int totalTime = 0;
            for (int i = 0; i < this.mConnectionCount; ++i) {
                ConnectionThread rt = this.mThreads[i];
                if (rt.mCurrentThreadTime != -1L) {
                    totalTime = (int)((long)totalTime + rt.mTotalThreadTime);
                }
                rt.mCurrentThreadTime = 0L;
            }
            Log.d("Http", "Http thread used " + totalTime + " ms " + " for " + this.mTotalRequest + " requests and " + this.mTotalConnection + " new connections");
        }

        private final void $$robo$$android_net_http_RequestQueue_ActivePool$logState() {
            StringBuilder dump = new StringBuilder();
            for (int i = 0; i < this.mConnectionCount; ++i) {
                dump.append(this.mThreads[i] + "\n");
            }
            HttpLog.v(dump.toString());
        }

        private final HttpHost $$robo$$android_net_http_RequestQueue_ActivePool$getProxyHost() {
            return this.this$0.mProxyHost;
        }

        private final void $$robo$$android_net_http_RequestQueue_ActivePool$disablePersistence() {
            for (int i = 0; i < this.mConnectionCount; ++i) {
                Connection connection = this.mThreads[i].mConnection;
                if (connection == null) continue;
                connection.setCanPersist(false);
            }
            this.mIdleCache.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final ConnectionThread $$robo$$android_net_http_RequestQueue_ActivePool$getThread(HttpHost host) {
            RequestQueue requestQueue = this.this$0;
            synchronized (requestQueue) {
                for (int i = 0; i < this.mThreads.length; ++i) {
                    ConnectionThread ct = this.mThreads[i];
                    Connection connection = ct.mConnection;
                    if (connection == null || !connection.mHost.equals(host)) continue;
                    return ct;
                }
            }
            return null;
        }

        private final Connection $$robo$$android_net_http_RequestQueue_ActivePool$getConnection(Context context, HttpHost host) {
            Connection con = this.mIdleCache.getConnection(host = this.this$0.determineHost(host));
            if (con == null) {
                ++this.mTotalConnection;
                con = Connection.getConnection(this.this$0.mContext, host, this.this$0.mProxyHost, this.this$0);
            }
            return con;
        }

        private final boolean $$robo$$android_net_http_RequestQueue_ActivePool$recycleConnection(Connection connection) {
            return this.mIdleCache.cacheConnection(connection.getHost(), connection);
        }

        private void __constructor__(RequestQueue requestQueue, int n) {
            this.$$robo$$android_net_http_RequestQueue_ActivePool$__constructor__(requestQueue, n);
        }

        ActivePool(RequestQueue requestQueue, int n) {
            this.this$0 = requestQueue;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_http_RequestQueue_ActivePool$__constructor__(android.net.http.RequestQueue int ), 0, this, requestQueue, n);
        }

        void startup() {
            InvokeDynamicSupport.bootstrap("startup", $$robo$$android_net_http_RequestQueue_ActivePool$startup(), 0, this);
        }

        void shutdown() {
            InvokeDynamicSupport.bootstrap("shutdown", $$robo$$android_net_http_RequestQueue_ActivePool$shutdown(), 0, this);
        }

        void startConnectionThread() {
            InvokeDynamicSupport.bootstrap("startConnectionThread", $$robo$$android_net_http_RequestQueue_ActivePool$startConnectionThread(), 0, this);
        }

        public void startTiming() {
            InvokeDynamicSupport.bootstrap("startTiming", $$robo$$android_net_http_RequestQueue_ActivePool$startTiming(), 0, this);
        }

        public void stopTiming() {
            InvokeDynamicSupport.bootstrap("stopTiming", $$robo$$android_net_http_RequestQueue_ActivePool$stopTiming(), 0, this);
        }

        void logState() {
            InvokeDynamicSupport.bootstrap("logState", $$robo$$android_net_http_RequestQueue_ActivePool$logState(), 0, this);
        }

        @Override
        public HttpHost getProxyHost() {
            return InvokeDynamicSupport.bootstrap("getProxyHost", $$robo$$android_net_http_RequestQueue_ActivePool$getProxyHost(), 0, this);
        }

        void disablePersistence() {
            InvokeDynamicSupport.bootstrap("disablePersistence", $$robo$$android_net_http_RequestQueue_ActivePool$disablePersistence(), 0, this);
        }

        ConnectionThread getThread(HttpHost httpHost) {
            return InvokeDynamicSupport.bootstrap("getThread", $$robo$$android_net_http_RequestQueue_ActivePool$getThread(org.apache.http.HttpHost ), 0, this, httpHost);
        }

        @Override
        public Connection getConnection(Context context, HttpHost httpHost) {
            return InvokeDynamicSupport.bootstrap("getConnection", $$robo$$android_net_http_RequestQueue_ActivePool$getConnection(android.content.Context org.apache.http.HttpHost ), 0, this, context, httpHost);
        }

        @Override
        public boolean recycleConnection(Connection connection) {
            return (boolean)InvokeDynamicSupport.bootstrap("recycleConnection", $$robo$$android_net_http_RequestQueue_ActivePool$recycleConnection(android.net.http.Connection ), 0, this, connection);
        }

        public /* synthetic */ ActivePool() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActivePool)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

