/*
 * Decompiled with CFR 0.152.
 */
package android.net.nsd;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class NsdServiceInfo
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "NsdServiceInfo";
    private String mServiceName;
    private String mServiceType;
    private ArrayMap<String, byte[]> mTxtRecord;
    private InetAddress mHost;
    private int mPort;
    public static Parcelable.Creator<NsdServiceInfo> CREATOR;

    private void $$robo$$android_net_nsd_NsdServiceInfo$__constructor__() {
        this.mTxtRecord = new ArrayMap();
    }

    private void $$robo$$android_net_nsd_NsdServiceInfo$__constructor__(String sn, String rt) {
        this.mTxtRecord = new ArrayMap();
        this.mServiceName = sn;
        this.mServiceType = rt;
    }

    private final String $$robo$$android_net_nsd_NsdServiceInfo$getServiceName() {
        return this.mServiceName;
    }

    private final void $$robo$$android_net_nsd_NsdServiceInfo$setServiceName(String s) {
        this.mServiceName = s;
    }

    private final String $$robo$$android_net_nsd_NsdServiceInfo$getServiceType() {
        return this.mServiceType;
    }

    private final void $$robo$$android_net_nsd_NsdServiceInfo$setServiceType(String s) {
        this.mServiceType = s;
    }

    private final InetAddress $$robo$$android_net_nsd_NsdServiceInfo$getHost() {
        return this.mHost;
    }

    private final void $$robo$$android_net_nsd_NsdServiceInfo$setHost(InetAddress s) {
        this.mHost = s;
    }

    private final int $$robo$$android_net_nsd_NsdServiceInfo$getPort() {
        return this.mPort;
    }

    private final void $$robo$$android_net_nsd_NsdServiceInfo$setPort(int p) {
        this.mPort = p;
    }

    private final void $$robo$$android_net_nsd_NsdServiceInfo$setAttribute(String key, byte[] value) {
        int txtRecordSize;
        int futureSize;
        for (int i = 0; i < key.length(); ++i) {
            char character = key.charAt(i);
            if (character < ' ' || character > '~') {
                throw new IllegalArgumentException("Key strings must be printable US-ASCII");
            }
            if (character != '=') continue;
            throw new IllegalArgumentException("Key strings must not include '='");
        }
        if (key.length() + (value == null ? 0 : value.length) >= 255) {
            throw new IllegalArgumentException("Key length + value length must be < 255 bytes");
        }
        if (key.length() > 9) {
            Log.w("NsdServiceInfo", "Key lengths > 9 are discouraged: " + key);
        }
        if ((futureSize = (txtRecordSize = this.getTxtRecordSize()) + key.length() + (value == null ? 0 : value.length) + 2) > 1300) {
            throw new IllegalArgumentException("Total length of attributes must be < 1300 bytes");
        }
        if (futureSize > 400) {
            Log.w("NsdServiceInfo", "Total length of all attributes exceeds 400 bytes; truncation may occur");
        }
        this.mTxtRecord.put(key, value);
    }

    private final void $$robo$$android_net_nsd_NsdServiceInfo$setAttribute(String key, String value) {
        try {
            this.setAttribute(key, value == null ? (byte[])null : value.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Value must be UTF-8");
        }
    }

    private final void $$robo$$android_net_nsd_NsdServiceInfo$removeAttribute(String key) {
        this.mTxtRecord.remove(key);
    }

    private final Map<String, byte[]> $$robo$$android_net_nsd_NsdServiceInfo$getAttributes() {
        return Collections.unmodifiableMap(this.mTxtRecord);
    }

    private final int $$robo$$android_net_nsd_NsdServiceInfo$getTxtRecordSize() {
        int txtRecordSize = 0;
        for (Map.Entry<String, byte[]> entry : this.mTxtRecord.entrySet()) {
            txtRecordSize += 2;
            txtRecordSize += entry.getKey().length();
            byte[] value = entry.getValue();
            txtRecordSize += value == null ? 0 : value.length;
        }
        return txtRecordSize;
    }

    private final byte[] $$robo$$android_net_nsd_NsdServiceInfo$getTxtRecord() {
        int txtRecordSize = this.getTxtRecordSize();
        if (txtRecordSize == 0) {
            return null;
        }
        byte[] txtRecord = new byte[txtRecordSize];
        int ptr = 0;
        for (Map.Entry<String, byte[]> entry : this.mTxtRecord.entrySet()) {
            String key = entry.getKey();
            byte[] value = entry.getValue();
            txtRecord[ptr++] = (byte)(key.length() + (value == null ? 0 : value.length) + 1);
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])key.getBytes(StandardCharsets.US_ASCII), (int)0, (byte[])txtRecord, (int)ptr, (int)key.length());
            ptr += key.length();
            txtRecord[ptr++] = 61;
            if (value == null) continue;
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])value, (int)0, (byte[])txtRecord, (int)ptr, (int)value.length);
            ptr += value.length;
        }
        return txtRecord;
    }

    private final String $$robo$$android_net_nsd_NsdServiceInfo$toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("name: ").append(this.mServiceName).append(", type: ").append(this.mServiceType).append(", host: ").append(this.mHost).append(", port: ").append(this.mPort);
        byte[] txtRecord = this.getTxtRecord();
        if (txtRecord != null) {
            sb.append(", txtRecord: ").append(new String(txtRecord, StandardCharsets.UTF_8));
        }
        return sb.toString();
    }

    private final int $$robo$$android_net_nsd_NsdServiceInfo$describeContents() {
        return 0;
    }

    private final void $$robo$$android_net_nsd_NsdServiceInfo$writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mServiceName);
        dest.writeString(this.mServiceType);
        if (this.mHost != null) {
            dest.writeInt(1);
            dest.writeByteArray(this.mHost.getAddress());
        } else {
            dest.writeInt(0);
        }
        dest.writeInt(this.mPort);
        dest.writeInt(this.mTxtRecord.size());
        for (String key : this.mTxtRecord.keySet()) {
            byte[] value = this.mTxtRecord.get(key);
            if (value != null) {
                dest.writeInt(1);
                dest.writeInt(value.length);
                dest.writeByteArray(value);
            } else {
                dest.writeInt(0);
            }
            dest.writeString(key);
        }
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<NsdServiceInfo>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_nsd_NsdServiceInfo_1$__constructor__() {
            }

            private final NsdServiceInfo $$robo$$android_net_nsd_NsdServiceInfo_1$createFromParcel(Parcel in) {
                NsdServiceInfo info = new NsdServiceInfo();
                info.mServiceName = in.readString();
                info.mServiceType = in.readString();
                if (in.readInt() == 1) {
                    try {
                        info.mHost = InetAddress.getByAddress(in.createByteArray());
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                }
                info.mPort = in.readInt();
                int recordCount = in.readInt();
                for (int i = 0; i < recordCount; ++i) {
                    byte[] valueArray = null;
                    if (in.readInt() == 1) {
                        int valueLength = in.readInt();
                        valueArray = new byte[valueLength];
                        in.readByteArray(valueArray);
                    }
                    info.mTxtRecord.put(in.readString(), valueArray);
                }
                return info;
            }

            private final NsdServiceInfo[] $$robo$$android_net_nsd_NsdServiceInfo_1$newArray(int size) {
                return new NsdServiceInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_nsd_NsdServiceInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_nsd_NsdServiceInfo_1$__constructor__(), 0, this);
            }

            @Override
            public NsdServiceInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_nsd_NsdServiceInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public NsdServiceInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_nsd_NsdServiceInfo_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_net_nsd_NsdServiceInfo$__constructor__();
    }

    public NsdServiceInfo() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_nsd_NsdServiceInfo$__constructor__(), 0, this);
    }

    private void __constructor__(String string2, String string3) {
        this.$$robo$$android_net_nsd_NsdServiceInfo$__constructor__(string2, string3);
    }

    public NsdServiceInfo(String string2, String string3) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_nsd_NsdServiceInfo$__constructor__(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public String getServiceName() {
        return InvokeDynamicSupport.bootstrap("getServiceName", $$robo$$android_net_nsd_NsdServiceInfo$getServiceName(), 0, this);
    }

    public void setServiceName(String string2) {
        InvokeDynamicSupport.bootstrap("setServiceName", $$robo$$android_net_nsd_NsdServiceInfo$setServiceName(java.lang.String ), 0, this, string2);
    }

    public String getServiceType() {
        return InvokeDynamicSupport.bootstrap("getServiceType", $$robo$$android_net_nsd_NsdServiceInfo$getServiceType(), 0, this);
    }

    public void setServiceType(String string2) {
        InvokeDynamicSupport.bootstrap("setServiceType", $$robo$$android_net_nsd_NsdServiceInfo$setServiceType(java.lang.String ), 0, this, string2);
    }

    public InetAddress getHost() {
        return InvokeDynamicSupport.bootstrap("getHost", $$robo$$android_net_nsd_NsdServiceInfo$getHost(), 0, this);
    }

    public void setHost(InetAddress inetAddress) {
        InvokeDynamicSupport.bootstrap("setHost", $$robo$$android_net_nsd_NsdServiceInfo$setHost(java.net.InetAddress ), 0, this, inetAddress);
    }

    public int getPort() {
        return (int)InvokeDynamicSupport.bootstrap("getPort", $$robo$$android_net_nsd_NsdServiceInfo$getPort(), 0, this);
    }

    public void setPort(int n) {
        InvokeDynamicSupport.bootstrap("setPort", $$robo$$android_net_nsd_NsdServiceInfo$setPort(int ), 0, this, n);
    }

    public void setAttribute(String string2, byte[] byArray) {
        InvokeDynamicSupport.bootstrap("setAttribute", $$robo$$android_net_nsd_NsdServiceInfo$setAttribute(java.lang.String byte[] ), 0, this, string2, byArray);
    }

    public void setAttribute(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setAttribute", $$robo$$android_net_nsd_NsdServiceInfo$setAttribute(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public void removeAttribute(String string2) {
        InvokeDynamicSupport.bootstrap("removeAttribute", $$robo$$android_net_nsd_NsdServiceInfo$removeAttribute(java.lang.String ), 0, this, string2);
    }

    public Map<String, byte[]> getAttributes() {
        return InvokeDynamicSupport.bootstrap("getAttributes", $$robo$$android_net_nsd_NsdServiceInfo$getAttributes(), 0, this);
    }

    private int getTxtRecordSize() {
        return (int)InvokeDynamicSupport.bootstrap("getTxtRecordSize", $$robo$$android_net_nsd_NsdServiceInfo$getTxtRecordSize(), 0, this);
    }

    public byte[] getTxtRecord() {
        return InvokeDynamicSupport.bootstrap("getTxtRecord", $$robo$$android_net_nsd_NsdServiceInfo$getTxtRecord(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_nsd_NsdServiceInfo$toString(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_nsd_NsdServiceInfo$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_nsd_NsdServiceInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    static {
        RobolectricInternals.classInitializing(NsdServiceInfo.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NsdServiceInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

