/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.Collection;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class BatchedScanSettings
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "BatchedScanSettings";
    public static int UNSPECIFIED = Integer.MAX_VALUE;
    public static int MIN_SCANS_PER_BATCH = 2;
    public static int MAX_SCANS_PER_BATCH = 20;
    public static int DEFAULT_SCANS_PER_BATCH = 20;
    public static int MIN_AP_PER_SCAN = 2;
    public static int MAX_AP_PER_SCAN = 16;
    public static int DEFAULT_AP_PER_SCAN = 16;
    public static int MIN_INTERVAL_SEC = 10;
    public static int MAX_INTERVAL_SEC = 500;
    public static int DEFAULT_INTERVAL_SEC = 30;
    public static int MIN_AP_FOR_DISTANCE = 0;
    public static int MAX_AP_FOR_DISTANCE = 16;
    public static int DEFAULT_AP_FOR_DISTANCE = 0;
    public static int MAX_WIFI_CHANNEL = 196;
    public int maxScansPerBatch;
    public int maxApPerScan;
    public Collection<String> channelSet;
    public int scanIntervalSec;
    public int maxApForDistance;
    public static Parcelable.Creator<BatchedScanSettings> CREATOR;

    private void $$robo$$android_net_wifi_BatchedScanSettings$__constructor__() {
        this.clear();
    }

    private final void $$robo$$android_net_wifi_BatchedScanSettings$clear() {
        this.maxScansPerBatch = Integer.MAX_VALUE;
        this.maxApPerScan = Integer.MAX_VALUE;
        this.channelSet = null;
        this.scanIntervalSec = Integer.MAX_VALUE;
        this.maxApForDistance = Integer.MAX_VALUE;
    }

    private void $$robo$$android_net_wifi_BatchedScanSettings$__constructor__(BatchedScanSettings source) {
        this.maxScansPerBatch = source.maxScansPerBatch;
        this.maxApPerScan = source.maxApPerScan;
        if (source.channelSet != null) {
            this.channelSet = new ArrayList<String>(source.channelSet);
        }
        this.scanIntervalSec = source.scanIntervalSec;
        this.maxApForDistance = source.maxApForDistance;
    }

    private final boolean $$robo$$android_net_wifi_BatchedScanSettings$channelSetIsValid() {
        if (this.channelSet == null || this.channelSet.isEmpty()) {
            return true;
        }
        for (String channel : this.channelSet) {
            try {
                int i = Integer.parseInt(channel);
                if (i > 0 && i <= 196) {
                    continue;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (channel.equals("A") || channel.equals("B")) continue;
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_net_wifi_BatchedScanSettings$isInvalid() {
        if (this.maxScansPerBatch != Integer.MAX_VALUE && (this.maxScansPerBatch < 2 || this.maxScansPerBatch > 20)) {
            return true;
        }
        if (this.maxApPerScan != Integer.MAX_VALUE && (this.maxApPerScan < 2 || this.maxApPerScan > 16)) {
            return true;
        }
        if (!this.channelSetIsValid()) {
            return true;
        }
        if (this.scanIntervalSec != Integer.MAX_VALUE && (this.scanIntervalSec < 10 || this.scanIntervalSec > 500)) {
            return true;
        }
        return this.maxApForDistance != Integer.MAX_VALUE && (this.maxApForDistance < 0 || this.maxApForDistance > 16);
    }

    private final void $$robo$$android_net_wifi_BatchedScanSettings$constrain() {
        if (this.scanIntervalSec == Integer.MAX_VALUE) {
            this.scanIntervalSec = 30;
        } else if (this.scanIntervalSec < 10) {
            this.scanIntervalSec = 10;
        } else if (this.scanIntervalSec > 500) {
            this.scanIntervalSec = 500;
        }
        if (this.maxScansPerBatch == Integer.MAX_VALUE) {
            this.maxScansPerBatch = 20;
        } else if (this.maxScansPerBatch < 2) {
            this.maxScansPerBatch = 2;
        } else if (this.maxScansPerBatch > 20) {
            this.maxScansPerBatch = 20;
        }
        if (this.maxApPerScan == Integer.MAX_VALUE) {
            this.maxApPerScan = 16;
        } else if (this.maxApPerScan < 2) {
            this.maxApPerScan = 2;
        } else if (this.maxApPerScan > 16) {
            this.maxApPerScan = 16;
        }
        if (this.maxApForDistance == Integer.MAX_VALUE) {
            this.maxApForDistance = 0;
        } else if (this.maxApForDistance < 0) {
            this.maxApForDistance = 0;
        } else if (this.maxApForDistance > 16) {
            this.maxApForDistance = 16;
        }
    }

    private final boolean $$robo$$android_net_wifi_BatchedScanSettings$equals(Object obj) {
        if (!(obj instanceof BatchedScanSettings)) {
            return false;
        }
        BatchedScanSettings o = (BatchedScanSettings)obj;
        if (this.maxScansPerBatch != o.maxScansPerBatch || this.maxApPerScan != o.maxApPerScan || this.scanIntervalSec != o.scanIntervalSec || this.maxApForDistance != o.maxApForDistance) {
            return false;
        }
        if (this.channelSet == null) {
            return o.channelSet == null;
        }
        return this.channelSet.equals(o.channelSet);
    }

    private final int $$robo$$android_net_wifi_BatchedScanSettings$hashCode() {
        return this.maxScansPerBatch + this.maxApPerScan * 3 + this.scanIntervalSec * 5 + this.maxApForDistance * 7 + this.channelSet.hashCode() * 11;
    }

    private final String $$robo$$android_net_wifi_BatchedScanSettings$toString() {
        StringBuffer sb = new StringBuffer();
        String none = "<none>";
        sb.append("BatchScanSettings [maxScansPerBatch: ").append(this.maxScansPerBatch == Integer.MAX_VALUE ? none : Integer.valueOf(this.maxScansPerBatch)).append(", maxApPerScan: ").append(this.maxApPerScan == Integer.MAX_VALUE ? none : Integer.valueOf(this.maxApPerScan)).append(", scanIntervalSec: ").append(this.scanIntervalSec == Integer.MAX_VALUE ? none : Integer.valueOf(this.scanIntervalSec)).append(", maxApForDistance: ").append(this.maxApForDistance == Integer.MAX_VALUE ? none : Integer.valueOf(this.maxApForDistance)).append(", channelSet: ");
        if (this.channelSet == null) {
            sb.append("ALL");
        } else {
            sb.append("<");
            for (String channel : this.channelSet) {
                sb.append(" " + channel);
            }
            sb.append(">");
        }
        sb.append("]");
        return sb.toString();
    }

    private final int $$robo$$android_net_wifi_BatchedScanSettings$describeContents() {
        return 0;
    }

    private final void $$robo$$android_net_wifi_BatchedScanSettings$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.maxScansPerBatch);
        dest.writeInt(this.maxApPerScan);
        dest.writeInt(this.scanIntervalSec);
        dest.writeInt(this.maxApForDistance);
        dest.writeInt(this.channelSet == null ? 0 : this.channelSet.size());
        if (this.channelSet != null) {
            for (String channel : this.channelSet) {
                dest.writeString(channel);
            }
        }
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<BatchedScanSettings>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_wifi_BatchedScanSettings_1$__constructor__() {
            }

            private final BatchedScanSettings $$robo$$android_net_wifi_BatchedScanSettings_1$createFromParcel(Parcel in) {
                BatchedScanSettings settings = new BatchedScanSettings();
                settings.maxScansPerBatch = in.readInt();
                settings.maxApPerScan = in.readInt();
                settings.scanIntervalSec = in.readInt();
                settings.maxApForDistance = in.readInt();
                int channelCount = in.readInt();
                if (channelCount > 0) {
                    settings.channelSet = new ArrayList<String>(channelCount);
                    while (channelCount-- > 0) {
                        settings.channelSet.add(in.readString());
                    }
                }
                return settings;
            }

            private final BatchedScanSettings[] $$robo$$android_net_wifi_BatchedScanSettings_1$newArray(int size) {
                return new BatchedScanSettings[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_wifi_BatchedScanSettings_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_BatchedScanSettings_1$__constructor__(), 0, this);
            }

            @Override
            public BatchedScanSettings createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_BatchedScanSettings_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public BatchedScanSettings[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_BatchedScanSettings_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_net_wifi_BatchedScanSettings$__constructor__();
    }

    public BatchedScanSettings() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_BatchedScanSettings$__constructor__(), 0, this);
    }

    public void clear() {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$android_net_wifi_BatchedScanSettings$clear(), 0, this);
    }

    private void __constructor__(BatchedScanSettings batchedScanSettings) {
        this.$$robo$$android_net_wifi_BatchedScanSettings$__constructor__(batchedScanSettings);
    }

    public BatchedScanSettings(BatchedScanSettings batchedScanSettings) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_BatchedScanSettings$__constructor__(android.net.wifi.BatchedScanSettings ), 0, this, batchedScanSettings);
    }

    private boolean channelSetIsValid() {
        return (boolean)InvokeDynamicSupport.bootstrap("channelSetIsValid", $$robo$$android_net_wifi_BatchedScanSettings$channelSetIsValid(), 0, this);
    }

    public boolean isInvalid() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInvalid", $$robo$$android_net_wifi_BatchedScanSettings$isInvalid(), 0, this);
    }

    public void constrain() {
        InvokeDynamicSupport.bootstrap("constrain", $$robo$$android_net_wifi_BatchedScanSettings$constrain(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_net_wifi_BatchedScanSettings$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_net_wifi_BatchedScanSettings$hashCode(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_wifi_BatchedScanSettings$toString(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_BatchedScanSettings$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_BatchedScanSettings$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    static {
        RobolectricInternals.classInitializing(BatchedScanSettings.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BatchedScanSettings)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

