/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.DhcpInfo;
import android.net.wifi.BatchedScanResult;
import android.net.wifi.BatchedScanSettings;
import android.net.wifi.ScanResult;
import android.net.wifi.ScanSettings;
import android.net.wifi.WifiActivityEnergyInfo;
import android.net.wifi.WifiChannel;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiConnectionStatistics;
import android.net.wifi.WifiInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Messenger;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.WorkSource;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public interface IWifiManager
extends IInterface,
InstrumentedInterface {
    public int getSupportedFeatures() throws RemoteException;

    public WifiActivityEnergyInfo reportActivityInfo() throws RemoteException;

    public List<WifiConfiguration> getConfiguredNetworks() throws RemoteException;

    public List<WifiConfiguration> getPrivilegedConfiguredNetworks() throws RemoteException;

    public int addOrUpdateNetwork(WifiConfiguration var1) throws RemoteException;

    public boolean removeNetwork(int var1) throws RemoteException;

    public boolean enableNetwork(int var1, boolean var2) throws RemoteException;

    public boolean disableNetwork(int var1) throws RemoteException;

    public boolean pingSupplicant() throws RemoteException;

    public List<WifiChannel> getChannelList() throws RemoteException;

    public void startScan(ScanSettings var1, WorkSource var2) throws RemoteException;

    public List<ScanResult> getScanResults(String var1) throws RemoteException;

    public void disconnect() throws RemoteException;

    public void reconnect() throws RemoteException;

    public void reassociate() throws RemoteException;

    public WifiInfo getConnectionInfo() throws RemoteException;

    public boolean setWifiEnabled(boolean var1) throws RemoteException;

    public int getWifiEnabledState() throws RemoteException;

    public void setCountryCode(String var1, boolean var2) throws RemoteException;

    public void setFrequencyBand(int var1, boolean var2) throws RemoteException;

    public int getFrequencyBand() throws RemoteException;

    public boolean isDualBandSupported() throws RemoteException;

    public boolean saveConfiguration() throws RemoteException;

    public DhcpInfo getDhcpInfo() throws RemoteException;

    public boolean isScanAlwaysAvailable() throws RemoteException;

    public boolean acquireWifiLock(IBinder var1, int var2, String var3, WorkSource var4) throws RemoteException;

    public void updateWifiLockWorkSource(IBinder var1, WorkSource var2) throws RemoteException;

    public boolean releaseWifiLock(IBinder var1) throws RemoteException;

    public void initializeMulticastFiltering() throws RemoteException;

    public boolean isMulticastEnabled() throws RemoteException;

    public void acquireMulticastLock(IBinder var1, String var2) throws RemoteException;

    public void releaseMulticastLock() throws RemoteException;

    public void setWifiApEnabled(WifiConfiguration var1, boolean var2) throws RemoteException;

    public int getWifiApEnabledState() throws RemoteException;

    public WifiConfiguration getWifiApConfiguration() throws RemoteException;

    public void setWifiApConfiguration(WifiConfiguration var1) throws RemoteException;

    public void startWifi() throws RemoteException;

    public void stopWifi() throws RemoteException;

    public void addToBlacklist(String var1) throws RemoteException;

    public void clearBlacklist() throws RemoteException;

    public Messenger getWifiServiceMessenger() throws RemoteException;

    public String getConfigFile() throws RemoteException;

    public void enableTdls(String var1, boolean var2) throws RemoteException;

    public void enableTdlsWithMacAddress(String var1, boolean var2) throws RemoteException;

    public boolean requestBatchedScan(BatchedScanSettings var1, IBinder var2, WorkSource var3) throws RemoteException;

    public void stopBatchedScan(BatchedScanSettings var1) throws RemoteException;

    public List<BatchedScanResult> getBatchedScanResults(String var1) throws RemoteException;

    public boolean isBatchedScanSupported() throws RemoteException;

    public void pollBatchedScan() throws RemoteException;

    public String getWpsNfcConfigurationToken(int var1) throws RemoteException;

    public void enableVerboseLogging(int var1) throws RemoteException;

    public int getVerboseLoggingLevel() throws RemoteException;

    public int getAggressiveHandover() throws RemoteException;

    public void enableAggressiveHandover(int var1) throws RemoteException;

    public int getAllowScansWithTraffic() throws RemoteException;

    public void setAllowScansWithTraffic(int var1) throws RemoteException;

    public WifiConnectionStatistics getConnectionStatistics() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWifiManager,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String DESCRIPTOR = "android.net.wifi.IWifiManager";
        static int TRANSACTION_getSupportedFeatures = 1;
        static int TRANSACTION_reportActivityInfo = 2;
        static int TRANSACTION_getConfiguredNetworks = 3;
        static int TRANSACTION_getPrivilegedConfiguredNetworks = 4;
        static int TRANSACTION_addOrUpdateNetwork = 5;
        static int TRANSACTION_removeNetwork = 6;
        static int TRANSACTION_enableNetwork = 7;
        static int TRANSACTION_disableNetwork = 8;
        static int TRANSACTION_pingSupplicant = 9;
        static int TRANSACTION_getChannelList = 10;
        static int TRANSACTION_startScan = 11;
        static int TRANSACTION_getScanResults = 12;
        static int TRANSACTION_disconnect = 13;
        static int TRANSACTION_reconnect = 14;
        static int TRANSACTION_reassociate = 15;
        static int TRANSACTION_getConnectionInfo = 16;
        static int TRANSACTION_setWifiEnabled = 17;
        static int TRANSACTION_getWifiEnabledState = 18;
        static int TRANSACTION_setCountryCode = 19;
        static int TRANSACTION_setFrequencyBand = 20;
        static int TRANSACTION_getFrequencyBand = 21;
        static int TRANSACTION_isDualBandSupported = 22;
        static int TRANSACTION_saveConfiguration = 23;
        static int TRANSACTION_getDhcpInfo = 24;
        static int TRANSACTION_isScanAlwaysAvailable = 25;
        static int TRANSACTION_acquireWifiLock = 26;
        static int TRANSACTION_updateWifiLockWorkSource = 27;
        static int TRANSACTION_releaseWifiLock = 28;
        static int TRANSACTION_initializeMulticastFiltering = 29;
        static int TRANSACTION_isMulticastEnabled = 30;
        static int TRANSACTION_acquireMulticastLock = 31;
        static int TRANSACTION_releaseMulticastLock = 32;
        static int TRANSACTION_setWifiApEnabled = 33;
        static int TRANSACTION_getWifiApEnabledState = 34;
        static int TRANSACTION_getWifiApConfiguration = 35;
        static int TRANSACTION_setWifiApConfiguration = 36;
        static int TRANSACTION_startWifi = 37;
        static int TRANSACTION_stopWifi = 38;
        static int TRANSACTION_addToBlacklist = 39;
        static int TRANSACTION_clearBlacklist = 40;
        static int TRANSACTION_getWifiServiceMessenger = 41;
        static int TRANSACTION_getConfigFile = 42;
        static int TRANSACTION_enableTdls = 43;
        static int TRANSACTION_enableTdlsWithMacAddress = 44;
        static int TRANSACTION_requestBatchedScan = 45;
        static int TRANSACTION_stopBatchedScan = 46;
        static int TRANSACTION_getBatchedScanResults = 47;
        static int TRANSACTION_isBatchedScanSupported = 48;
        static int TRANSACTION_pollBatchedScan = 49;
        static int TRANSACTION_getWpsNfcConfigurationToken = 50;
        static int TRANSACTION_enableVerboseLogging = 51;
        static int TRANSACTION_getVerboseLoggingLevel = 52;
        static int TRANSACTION_getAggressiveHandover = 53;
        static int TRANSACTION_enableAggressiveHandover = 54;
        static int TRANSACTION_getAllowScansWithTraffic = 55;
        static int TRANSACTION_setAllowScansWithTraffic = 56;
        static int TRANSACTION_getConnectionStatistics = 57;

        private void $$robo$$android_net_wifi_IWifiManager_Stub$__constructor__() {
            this.attachInterface(this, "android.net.wifi.IWifiManager");
        }

        private static final IWifiManager $$robo$$android_net_wifi_IWifiManager_Stub$asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface("android.net.wifi.IWifiManager");
            if (iin != null && iin instanceof IWifiManager) {
                return (IWifiManager)iin;
            }
            return new Proxy(obj);
        }

        private final IBinder $$robo$$android_net_wifi_IWifiManager_Stub$asBinder() {
            return this;
        }

        private final boolean $$robo$$android_net_wifi_IWifiManager_Stub$onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString("android.net.wifi.IWifiManager");
                    return true;
                }
                case 1: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    int _result = this.getSupportedFeatures();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 2: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    WifiActivityEnergyInfo _result = this.reportActivityInfo();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 3: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    List _result = this.getConfiguredNetworks();
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 4: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    List _result = this.getPrivilegedConfiguredNetworks();
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 5: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    WifiConfiguration _arg0 = 0 != data.readInt() ? WifiConfiguration.CREATOR.createFromParcel(data) : null;
                    int _result = this.addOrUpdateNetwork(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 6: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    int _arg0 = data.readInt();
                    boolean _result = this.removeNetwork(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 7: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    boolean _result = this.enableNetwork(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 8: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    int _arg0 = data.readInt();
                    boolean _result = this.disableNetwork(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 9: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    boolean _result = this.pingSupplicant();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 10: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    List _result = this.getChannelList();
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 11: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    ScanSettings _arg0 = 0 != data.readInt() ? ScanSettings.CREATOR.createFromParcel(data) : null;
                    WorkSource _arg1 = 0 != data.readInt() ? WorkSource.CREATOR.createFromParcel(data) : null;
                    this.startScan(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 12: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    String _arg0 = data.readString();
                    List _result = this.getScanResults(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 13: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    this.disconnect();
                    reply.writeNoException();
                    return true;
                }
                case 14: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    this.reconnect();
                    reply.writeNoException();
                    return true;
                }
                case 15: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    this.reassociate();
                    reply.writeNoException();
                    return true;
                }
                case 16: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    WifiInfo _result = this.getConnectionInfo();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 17: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    boolean _arg0 = 0 != data.readInt();
                    boolean _result = this.setWifiEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 18: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    int _result = this.getWifiEnabledState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 19: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    this.setCountryCode(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 20: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    this.setFrequencyBand(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 21: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    int _result = this.getFrequencyBand();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 22: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    boolean _result = this.isDualBandSupported();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 23: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    boolean _result = this.saveConfiguration();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 24: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    DhcpInfo _result = this.getDhcpInfo();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 25: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    boolean _result = this.isScanAlwaysAvailable();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 26: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    WorkSource _arg3 = 0 != data.readInt() ? WorkSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.acquireWifiLock(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 27: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    IBinder _arg0 = data.readStrongBinder();
                    WorkSource _arg1 = 0 != data.readInt() ? WorkSource.CREATOR.createFromParcel(data) : null;
                    this.updateWifiLockWorkSource(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 28: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _result = this.releaseWifiLock(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 29: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    this.initializeMulticastFiltering();
                    reply.writeNoException();
                    return true;
                }
                case 30: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    boolean _result = this.isMulticastEnabled();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 31: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    this.acquireMulticastLock(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 32: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    this.releaseMulticastLock();
                    reply.writeNoException();
                    return true;
                }
                case 33: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    WifiConfiguration _arg0 = 0 != data.readInt() ? WifiConfiguration.CREATOR.createFromParcel(data) : null;
                    boolean _arg1 = 0 != data.readInt();
                    this.setWifiApEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 34: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    int _result = this.getWifiApEnabledState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 35: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    WifiConfiguration _result = this.getWifiApConfiguration();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 36: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    WifiConfiguration _arg0 = 0 != data.readInt() ? WifiConfiguration.CREATOR.createFromParcel(data) : null;
                    this.setWifiApConfiguration(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 37: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    this.startWifi();
                    reply.writeNoException();
                    return true;
                }
                case 38: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    this.stopWifi();
                    reply.writeNoException();
                    return true;
                }
                case 39: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    String _arg0 = data.readString();
                    this.addToBlacklist(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 40: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    this.clearBlacklist();
                    reply.writeNoException();
                    return true;
                }
                case 41: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    Messenger _result = this.getWifiServiceMessenger();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 42: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    String _result = this.getConfigFile();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 43: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    this.enableTdls(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 44: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    this.enableTdlsWithMacAddress(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 45: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    BatchedScanSettings _arg0 = 0 != data.readInt() ? BatchedScanSettings.CREATOR.createFromParcel(data) : null;
                    IBinder _arg1 = data.readStrongBinder();
                    WorkSource _arg2 = 0 != data.readInt() ? WorkSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.requestBatchedScan(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 46: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    BatchedScanSettings _arg0 = 0 != data.readInt() ? BatchedScanSettings.CREATOR.createFromParcel(data) : null;
                    this.stopBatchedScan(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 47: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    String _arg0 = data.readString();
                    List _result = this.getBatchedScanResults(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 48: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    boolean _result = this.isBatchedScanSupported();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 49: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    this.pollBatchedScan();
                    reply.writeNoException();
                    return true;
                }
                case 50: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    int _arg0 = data.readInt();
                    String _result = this.getWpsNfcConfigurationToken(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 51: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    int _arg0 = data.readInt();
                    this.enableVerboseLogging(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 52: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    int _result = this.getVerboseLoggingLevel();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 53: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    int _result = this.getAggressiveHandover();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 54: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    int _arg0 = data.readInt();
                    this.enableAggressiveHandover(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 55: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    int _result = this.getAllowScansWithTraffic();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 56: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    int _arg0 = data.readInt();
                    this.setAllowScansWithTraffic(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 57: {
                    data.enforceInterface("android.net.wifi.IWifiManager");
                    WifiConnectionStatistics _result = this.getConnectionStatistics();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_IWifiManager_Stub$__constructor__();
        }

        public Stub() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_IWifiManager_Stub$__constructor__(), 0, this);
        }

        public static IWifiManager asInterface(IBinder iBinder) {
            return InvokeDynamicSupport.bootstrapStatic("asInterface", $$robo$$android_net_wifi_IWifiManager_Stub$asInterface(android.os.IBinder ), 0, (IBinder)iBinder);
        }

        @Override
        public IBinder asBinder() {
            return InvokeDynamicSupport.bootstrap("asBinder", $$robo$$android_net_wifi_IWifiManager_Stub$asBinder(), 0, this);
        }

        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            return (boolean)InvokeDynamicSupport.bootstrap("onTransact", $$robo$$android_net_wifi_IWifiManager_Stub$onTransact(int android.os.Parcel android.os.Parcel int ), 0, this, n, parcel, parcel2, n2);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Stub)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private static class Proxy
        implements IWifiManager,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private IBinder mRemote;

            private void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$__constructor__(IBinder remote) {
                this.mRemote = remote;
            }

            private final IBinder $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$asBinder() {
                return this.mRemote;
            }

            private final String $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getInterfaceDescriptor() {
                return "android.net.wifi.IWifiManager";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getSupportedFeatures() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final WifiActivityEnergyInfo $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$reportActivityInfo() throws RemoteException {
                WifiActivityEnergyInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? WifiActivityEnergyInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final List<WifiConfiguration> $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getConfiguredNetworks() throws RemoteException {
                ArrayList<WifiConfiguration> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(WifiConfiguration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final List<WifiConfiguration> $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getPrivilegedConfiguredNetworks() throws RemoteException {
                ArrayList<WifiConfiguration> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(WifiConfiguration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$addOrUpdateNetwork(WifiConfiguration config) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    if (config != null) {
                        _data.writeInt(1);
                        config.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$removeNetwork(int netId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeInt(netId);
                    this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$enableNetwork(int netId, boolean disableOthers) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeInt(netId);
                    _data.writeInt(disableOthers ? 1 : 0);
                    this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$disableNetwork(int netId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeInt(netId);
                    this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$pingSupplicant() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final List<WifiChannel> $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getChannelList() throws RemoteException {
                ArrayList<WifiChannel> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(WifiChannel.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$startScan(ScanSettings requested, WorkSource ws) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    if (requested != null) {
                        _data.writeInt(1);
                        requested.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (ws != null) {
                        _data.writeInt(1);
                        ws.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final List<ScanResult> $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getScanResults(String callingPackage) throws RemoteException {
                ArrayList<ScanResult> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeString(callingPackage);
                    this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(ScanResult.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$disconnect() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$reconnect() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$reassociate() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final WifiInfo $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getConnectionInfo() throws RemoteException {
                WifiInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? WifiInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$setWifiEnabled(boolean enable) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeInt(enable ? 1 : 0);
                    this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getWifiEnabledState() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$setCountryCode(String country, boolean persist) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeString(country);
                    _data.writeInt(persist ? 1 : 0);
                    this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$setFrequencyBand(int band, boolean persist) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeInt(band);
                    _data.writeInt(persist ? 1 : 0);
                    this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getFrequencyBand() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$isDualBandSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$saveConfiguration() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final DhcpInfo $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getDhcpInfo() throws RemoteException {
                DhcpInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? DhcpInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$isScanAlwaysAvailable() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$acquireWifiLock(IBinder lock, int lockType, String tag, WorkSource ws) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeStrongBinder(lock);
                    _data.writeInt(lockType);
                    _data.writeString(tag);
                    if (ws != null) {
                        _data.writeInt(1);
                        ws.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$updateWifiLockWorkSource(IBinder lock, WorkSource ws) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeStrongBinder(lock);
                    if (ws != null) {
                        _data.writeInt(1);
                        ws.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$releaseWifiLock(IBinder lock) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeStrongBinder(lock);
                    this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$initializeMulticastFiltering() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$isMulticastEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$acquireMulticastLock(IBinder binder, String tag) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeStrongBinder(binder);
                    _data.writeString(tag);
                    this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$releaseMulticastLock() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$setWifiApEnabled(WifiConfiguration wifiConfig, boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    if (wifiConfig != null) {
                        _data.writeInt(1);
                        wifiConfig.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(enable ? 1 : 0);
                    this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getWifiApEnabledState() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final WifiConfiguration $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getWifiApConfiguration() throws RemoteException {
                WifiConfiguration _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? WifiConfiguration.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$setWifiApConfiguration(WifiConfiguration wifiConfig) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    if (wifiConfig != null) {
                        _data.writeInt(1);
                        wifiConfig.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$startWifi() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$stopWifi() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$addToBlacklist(String bssid) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeString(bssid);
                    this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$clearBlacklist() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final Messenger $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getWifiServiceMessenger() throws RemoteException {
                Messenger _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? Messenger.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final String $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getConfigFile() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$enableTdls(String remoteIPAddress, boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeString(remoteIPAddress);
                    _data.writeInt(enable ? 1 : 0);
                    this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$enableTdlsWithMacAddress(String remoteMacAddress, boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeString(remoteMacAddress);
                    _data.writeInt(enable ? 1 : 0);
                    this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$requestBatchedScan(BatchedScanSettings requested, IBinder binder, WorkSource ws) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    if (requested != null) {
                        _data.writeInt(1);
                        requested.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(binder);
                    if (ws != null) {
                        _data.writeInt(1);
                        ws.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$stopBatchedScan(BatchedScanSettings requested) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    if (requested != null) {
                        _data.writeInt(1);
                        requested.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final List<BatchedScanResult> $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getBatchedScanResults(String callingPackage) throws RemoteException {
                ArrayList<BatchedScanResult> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeString(callingPackage);
                    this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(BatchedScanResult.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$isBatchedScanSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$pollBatchedScan() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final String $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getWpsNfcConfigurationToken(int netId) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeInt(netId);
                    this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$enableVerboseLogging(int verbose) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeInt(verbose);
                    this.mRemote.transact(51, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getVerboseLoggingLevel() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(52, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getAggressiveHandover() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(53, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$enableAggressiveHandover(int enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeInt(enabled);
                    this.mRemote.transact(54, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getAllowScansWithTraffic() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(55, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$setAllowScansWithTraffic(int enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    _data.writeInt(enabled);
                    this.mRemote.transact(56, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final WifiConnectionStatistics $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getConnectionStatistics() throws RemoteException {
                WifiConnectionStatistics _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("android.net.wifi.IWifiManager");
                    this.mRemote.transact(57, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? WifiConnectionStatistics.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            private void __constructor__(IBinder iBinder) {
                this.$$robo$$android_net_wifi_IWifiManager_Stub_Proxy$__constructor__(iBinder);
            }

            Proxy(IBinder iBinder) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$__constructor__(android.os.IBinder ), 0, this, iBinder);
            }

            @Override
            public IBinder asBinder() {
                return InvokeDynamicSupport.bootstrap("asBinder", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$asBinder(), 0, this);
            }

            public String getInterfaceDescriptor() {
                return InvokeDynamicSupport.bootstrap("getInterfaceDescriptor", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getInterfaceDescriptor(), 0, this);
            }

            @Override
            public int getSupportedFeatures() throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("getSupportedFeatures", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getSupportedFeatures(), 0, this);
            }

            @Override
            public WifiActivityEnergyInfo reportActivityInfo() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("reportActivityInfo", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$reportActivityInfo(), 0, this);
            }

            @Override
            public List<WifiConfiguration> getConfiguredNetworks() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getConfiguredNetworks", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getConfiguredNetworks(), 0, this);
            }

            @Override
            public List<WifiConfiguration> getPrivilegedConfiguredNetworks() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getPrivilegedConfiguredNetworks", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getPrivilegedConfiguredNetworks(), 0, this);
            }

            @Override
            public int addOrUpdateNetwork(WifiConfiguration wifiConfiguration) throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("addOrUpdateNetwork", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$addOrUpdateNetwork(android.net.wifi.WifiConfiguration ), 0, this, wifiConfiguration);
            }

            @Override
            public boolean removeNetwork(int n) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("removeNetwork", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$removeNetwork(int ), 0, this, n);
            }

            @Override
            public boolean enableNetwork(int n, boolean bl) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("enableNetwork", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$enableNetwork(int boolean ), 0, this, n, bl);
            }

            @Override
            public boolean disableNetwork(int n) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("disableNetwork", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$disableNetwork(int ), 0, this, n);
            }

            @Override
            public boolean pingSupplicant() throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("pingSupplicant", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$pingSupplicant(), 0, this);
            }

            @Override
            public List<WifiChannel> getChannelList() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getChannelList", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getChannelList(), 0, this);
            }

            @Override
            public void startScan(ScanSettings scanSettings, WorkSource workSource) throws RemoteException {
                InvokeDynamicSupport.bootstrap("startScan", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$startScan(android.net.wifi.ScanSettings android.os.WorkSource ), 0, this, scanSettings, workSource);
            }

            @Override
            public List<ScanResult> getScanResults(String string2) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getScanResults", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getScanResults(java.lang.String ), 0, this, string2);
            }

            @Override
            public void disconnect() throws RemoteException {
                InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$disconnect(), 0, this);
            }

            @Override
            public void reconnect() throws RemoteException {
                InvokeDynamicSupport.bootstrap("reconnect", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$reconnect(), 0, this);
            }

            @Override
            public void reassociate() throws RemoteException {
                InvokeDynamicSupport.bootstrap("reassociate", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$reassociate(), 0, this);
            }

            @Override
            public WifiInfo getConnectionInfo() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getConnectionInfo", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getConnectionInfo(), 0, this);
            }

            @Override
            public boolean setWifiEnabled(boolean bl) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("setWifiEnabled", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$setWifiEnabled(boolean ), 0, this, bl);
            }

            @Override
            public int getWifiEnabledState() throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("getWifiEnabledState", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getWifiEnabledState(), 0, this);
            }

            @Override
            public void setCountryCode(String string2, boolean bl) throws RemoteException {
                InvokeDynamicSupport.bootstrap("setCountryCode", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$setCountryCode(java.lang.String boolean ), 0, this, string2, bl);
            }

            @Override
            public void setFrequencyBand(int n, boolean bl) throws RemoteException {
                InvokeDynamicSupport.bootstrap("setFrequencyBand", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$setFrequencyBand(int boolean ), 0, this, n, bl);
            }

            @Override
            public int getFrequencyBand() throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("getFrequencyBand", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getFrequencyBand(), 0, this);
            }

            @Override
            public boolean isDualBandSupported() throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("isDualBandSupported", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$isDualBandSupported(), 0, this);
            }

            @Override
            public boolean saveConfiguration() throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("saveConfiguration", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$saveConfiguration(), 0, this);
            }

            @Override
            public DhcpInfo getDhcpInfo() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getDhcpInfo", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getDhcpInfo(), 0, this);
            }

            @Override
            public boolean isScanAlwaysAvailable() throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("isScanAlwaysAvailable", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$isScanAlwaysAvailable(), 0, this);
            }

            @Override
            public boolean acquireWifiLock(IBinder iBinder, int n, String string2, WorkSource workSource) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("acquireWifiLock", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$acquireWifiLock(android.os.IBinder int java.lang.String android.os.WorkSource ), 0, this, iBinder, n, string2, workSource);
            }

            @Override
            public void updateWifiLockWorkSource(IBinder iBinder, WorkSource workSource) throws RemoteException {
                InvokeDynamicSupport.bootstrap("updateWifiLockWorkSource", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$updateWifiLockWorkSource(android.os.IBinder android.os.WorkSource ), 0, this, iBinder, workSource);
            }

            @Override
            public boolean releaseWifiLock(IBinder iBinder) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("releaseWifiLock", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$releaseWifiLock(android.os.IBinder ), 0, this, iBinder);
            }

            @Override
            public void initializeMulticastFiltering() throws RemoteException {
                InvokeDynamicSupport.bootstrap("initializeMulticastFiltering", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$initializeMulticastFiltering(), 0, this);
            }

            @Override
            public boolean isMulticastEnabled() throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("isMulticastEnabled", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$isMulticastEnabled(), 0, this);
            }

            @Override
            public void acquireMulticastLock(IBinder iBinder, String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("acquireMulticastLock", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$acquireMulticastLock(android.os.IBinder java.lang.String ), 0, this, iBinder, string2);
            }

            @Override
            public void releaseMulticastLock() throws RemoteException {
                InvokeDynamicSupport.bootstrap("releaseMulticastLock", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$releaseMulticastLock(), 0, this);
            }

            @Override
            public void setWifiApEnabled(WifiConfiguration wifiConfiguration, boolean bl) throws RemoteException {
                InvokeDynamicSupport.bootstrap("setWifiApEnabled", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$setWifiApEnabled(android.net.wifi.WifiConfiguration boolean ), 0, this, wifiConfiguration, bl);
            }

            @Override
            public int getWifiApEnabledState() throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("getWifiApEnabledState", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getWifiApEnabledState(), 0, this);
            }

            @Override
            public WifiConfiguration getWifiApConfiguration() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getWifiApConfiguration", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getWifiApConfiguration(), 0, this);
            }

            @Override
            public void setWifiApConfiguration(WifiConfiguration wifiConfiguration) throws RemoteException {
                InvokeDynamicSupport.bootstrap("setWifiApConfiguration", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$setWifiApConfiguration(android.net.wifi.WifiConfiguration ), 0, this, wifiConfiguration);
            }

            @Override
            public void startWifi() throws RemoteException {
                InvokeDynamicSupport.bootstrap("startWifi", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$startWifi(), 0, this);
            }

            @Override
            public void stopWifi() throws RemoteException {
                InvokeDynamicSupport.bootstrap("stopWifi", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$stopWifi(), 0, this);
            }

            @Override
            public void addToBlacklist(String string2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("addToBlacklist", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$addToBlacklist(java.lang.String ), 0, this, string2);
            }

            @Override
            public void clearBlacklist() throws RemoteException {
                InvokeDynamicSupport.bootstrap("clearBlacklist", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$clearBlacklist(), 0, this);
            }

            @Override
            public Messenger getWifiServiceMessenger() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getWifiServiceMessenger", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getWifiServiceMessenger(), 0, this);
            }

            @Override
            public String getConfigFile() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getConfigFile", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getConfigFile(), 0, this);
            }

            @Override
            public void enableTdls(String string2, boolean bl) throws RemoteException {
                InvokeDynamicSupport.bootstrap("enableTdls", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$enableTdls(java.lang.String boolean ), 0, this, string2, bl);
            }

            @Override
            public void enableTdlsWithMacAddress(String string2, boolean bl) throws RemoteException {
                InvokeDynamicSupport.bootstrap("enableTdlsWithMacAddress", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$enableTdlsWithMacAddress(java.lang.String boolean ), 0, this, string2, bl);
            }

            @Override
            public boolean requestBatchedScan(BatchedScanSettings batchedScanSettings, IBinder iBinder, WorkSource workSource) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("requestBatchedScan", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$requestBatchedScan(android.net.wifi.BatchedScanSettings android.os.IBinder android.os.WorkSource ), 0, this, batchedScanSettings, iBinder, workSource);
            }

            @Override
            public void stopBatchedScan(BatchedScanSettings batchedScanSettings) throws RemoteException {
                InvokeDynamicSupport.bootstrap("stopBatchedScan", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$stopBatchedScan(android.net.wifi.BatchedScanSettings ), 0, this, batchedScanSettings);
            }

            @Override
            public List<BatchedScanResult> getBatchedScanResults(String string2) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getBatchedScanResults", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getBatchedScanResults(java.lang.String ), 0, this, string2);
            }

            @Override
            public boolean isBatchedScanSupported() throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("isBatchedScanSupported", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$isBatchedScanSupported(), 0, this);
            }

            @Override
            public void pollBatchedScan() throws RemoteException {
                InvokeDynamicSupport.bootstrap("pollBatchedScan", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$pollBatchedScan(), 0, this);
            }

            @Override
            public String getWpsNfcConfigurationToken(int n) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getWpsNfcConfigurationToken", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getWpsNfcConfigurationToken(int ), 0, this, n);
            }

            @Override
            public void enableVerboseLogging(int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("enableVerboseLogging", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$enableVerboseLogging(int ), 0, this, n);
            }

            @Override
            public int getVerboseLoggingLevel() throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("getVerboseLoggingLevel", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getVerboseLoggingLevel(), 0, this);
            }

            @Override
            public int getAggressiveHandover() throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("getAggressiveHandover", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getAggressiveHandover(), 0, this);
            }

            @Override
            public void enableAggressiveHandover(int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("enableAggressiveHandover", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$enableAggressiveHandover(int ), 0, this, n);
            }

            @Override
            public int getAllowScansWithTraffic() throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("getAllowScansWithTraffic", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getAllowScansWithTraffic(), 0, this);
            }

            @Override
            public void setAllowScansWithTraffic(int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("setAllowScansWithTraffic", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$setAllowScansWithTraffic(int ), 0, this, n);
            }

            @Override
            public WifiConnectionStatistics getConnectionStatistics() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getConnectionStatistics", $$robo$$android_net_wifi_IWifiManager_Stub_Proxy$getConnectionStatistics(), 0, this);
            }

            public /* synthetic */ Proxy() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Proxy)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }
}

