/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.content.Context;
import android.net.wifi.IRttManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.util.AsyncChannel;
import java.util.concurrent.CountDownLatch;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RttManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DBG = true;
    private static String TAG = "RttManager";
    public static int RTT_TYPE_UNSPECIFIED = 0;
    public static int RTT_TYPE_ONE_SIDED = 1;
    public static int RTT_TYPE_11_V = 2;
    public static int RTT_TYPE_11_MC = 4;
    public static int RTT_PEER_TYPE_UNSPECIFIED = 0;
    public static int RTT_PEER_TYPE_AP = 1;
    public static int RTT_PEER_TYPE_STA = 2;
    public static int RTT_CHANNEL_WIDTH_20 = 0;
    public static int RTT_CHANNEL_WIDTH_40 = 1;
    public static int RTT_CHANNEL_WIDTH_80 = 2;
    public static int RTT_CHANNEL_WIDTH_160 = 3;
    public static int RTT_CHANNEL_WIDTH_80P80 = 4;
    public static int RTT_CHANNEL_WIDTH_5 = 5;
    public static int RTT_CHANNEL_WIDTH_10 = 6;
    public static int RTT_CHANNEL_WIDTH_UNSPECIFIED = -1;
    public static int RTT_STATUS_SUCCESS = 0;
    public static int RTT_STATUS_FAILURE = 1;
    public static int RTT_STATUS_FAIL_NO_RSP = 2;
    public static int RTT_STATUS_FAIL_REJECTED = 3;
    public static int RTT_STATUS_FAIL_NOT_SCHEDULED_YET = 4;
    public static int RTT_STATUS_FAIL_TM_TIMEOUT = 5;
    public static int RTT_STATUS_FAIL_AP_ON_DIFF_CHANNEL = 6;
    public static int RTT_STATUS_FAIL_NO_CAPABILITY = 7;
    public static int RTT_STATUS_ABORTED = 8;
    public static int REASON_UNSPECIFIED = -1;
    public static int REASON_NOT_AVAILABLE = -2;
    public static int REASON_INVALID_LISTENER = -3;
    public static int REASON_INVALID_REQUEST = -4;
    public static String DESCRIPTION_KEY = "android.net.wifi.RttManager.Description";
    public static int BASE = 160256;
    public static int CMD_OP_START_RANGING = 160256;
    public static int CMD_OP_STOP_RANGING = 160257;
    public static int CMD_OP_FAILED = 160258;
    public static int CMD_OP_SUCCEEDED = 160259;
    public static int CMD_OP_ABORTED = 160260;
    private Context mContext;
    private IRttManager mService;
    private static int INVALID_KEY = 0;
    private static int sListenerKey;
    private static SparseArray sListenerMap;
    private static Object sListenerMapLock;
    private static AsyncChannel sAsyncChannel;
    private static CountDownLatch sConnected;
    private static Object sThreadRefLock;
    private static int sThreadRefCount;
    private static HandlerThread sHandlerThread;

    private final Capabilities $$robo$$android_net_wifi_RttManager$getCapabilities() {
        return new Capabilities(this);
    }

    private final void $$robo$$android_net_wifi_RttManager$startRanging(RttParams[] params, RttListener listener) {
        this.validateChannel();
        ParcelableRttParams parcelableParams = new ParcelableRttParams(params);
        sAsyncChannel.sendMessage(160256, 0, RttManager.putListener(listener), parcelableParams);
    }

    private final void $$robo$$android_net_wifi_RttManager$stopRanging(RttListener listener) {
        this.validateChannel();
        sAsyncChannel.sendMessage(160257, 0, RttManager.removeListener(listener));
    }

    private void $$robo$$android_net_wifi_RttManager$__constructor__(Context context, IRttManager service) {
        this.mContext = context;
        this.mService = service;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_wifi_RttManager$init() {
        Object object = sThreadRefLock;
        synchronized (object) {
            if (++sThreadRefCount == 1) {
                Messenger messenger = null;
                try {
                    Log.d("RttManager", "Get the messenger from " + this.mService);
                    messenger = this.mService.getMessenger();
                }
                catch (RemoteException remoteException) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (messenger == null) {
                    sAsyncChannel = null;
                    return;
                }
                sHandlerThread = new HandlerThread("WifiScanner");
                sAsyncChannel = new AsyncChannel();
                sConnected = new CountDownLatch(1);
                sHandlerThread.start();
                ServiceHandler handler = new ServiceHandler(sHandlerThread.getLooper());
                sAsyncChannel.connect(this.mContext, (Handler)handler, messenger);
                try {
                    sConnected.await();
                }
                catch (InterruptedException e) {
                    Log.e("RttManager", "interrupted wait at init");
                }
            }
        }
    }

    private final void $$robo$$android_net_wifi_RttManager$validateChannel() {
        if (sAsyncChannel == null) {
            throw new IllegalStateException("No permission to access and change wifi or a bad initialization");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int $$robo$$android_net_wifi_RttManager$putListener(Object listener) {
        int key;
        if (listener == null) {
            return 0;
        }
        Object object = sListenerMapLock;
        synchronized (object) {
            do {
                ++sListenerKey;
            } while (key == 0);
            sListenerMap.put(key, listener);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object $$robo$$android_net_wifi_RttManager$getListener(int key) {
        if (key == 0) {
            return null;
        }
        Object object = sListenerMapLock;
        synchronized (object) {
            Object listener = sListenerMap.get(key);
            return listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int $$robo$$android_net_wifi_RttManager$getListenerKey(Object listener) {
        if (listener == null) {
            return 0;
        }
        Object object = sListenerMapLock;
        synchronized (object) {
            int index = sListenerMap.indexOfValue(listener);
            if (index == -1) {
                return 0;
            }
            return sListenerMap.keyAt(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object $$robo$$android_net_wifi_RttManager$removeListener(int key) {
        if (key == 0) {
            return null;
        }
        Object object = sListenerMapLock;
        synchronized (object) {
            Object listener = sListenerMap.get(key);
            sListenerMap.remove(key);
            return listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int $$robo$$android_net_wifi_RttManager$removeListener(Object listener) {
        int key = RttManager.getListenerKey(listener);
        if (key == 0) {
            return key;
        }
        Object object = sListenerMapLock;
        synchronized (object) {
            sListenerMap.remove(key);
            return key;
        }
    }

    static void __staticInitializer__() {
        sListenerKey = 1;
        sListenerMap = new SparseArray();
        sListenerMapLock = new Object();
        sThreadRefLock = new Object();
    }

    public Capabilities getCapabilities() {
        return InvokeDynamicSupport.bootstrap("getCapabilities", $$robo$$android_net_wifi_RttManager$getCapabilities(), 0, this);
    }

    public void startRanging(RttParams[] rttParamsArray, RttListener rttListener) {
        InvokeDynamicSupport.bootstrap("startRanging", $$robo$$android_net_wifi_RttManager$startRanging(android.net.wifi.RttManager$RttParams[] android.net.wifi.RttManager$RttListener ), 0, this, rttParamsArray, rttListener);
    }

    public void stopRanging(RttListener rttListener) {
        InvokeDynamicSupport.bootstrap("stopRanging", $$robo$$android_net_wifi_RttManager$stopRanging(android.net.wifi.RttManager$RttListener ), 0, this, rttListener);
    }

    private void __constructor__(Context context, IRttManager iRttManager) {
        this.$$robo$$android_net_wifi_RttManager$__constructor__(context, iRttManager);
    }

    public RttManager(Context context, IRttManager iRttManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager$__constructor__(android.content.Context android.net.wifi.IRttManager ), 0, this, context, iRttManager);
    }

    private void init() {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_net_wifi_RttManager$init(), 0, this);
    }

    private void validateChannel() {
        InvokeDynamicSupport.bootstrap("validateChannel", $$robo$$android_net_wifi_RttManager$validateChannel(), 0, this);
    }

    private static int putListener(Object object) {
        return (int)InvokeDynamicSupport.bootstrapStatic("putListener", $$robo$$android_net_wifi_RttManager$putListener(java.lang.Object ), 0, (Object)object);
    }

    private static Object getListener(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getListener", $$robo$$android_net_wifi_RttManager$getListener(int ), 0, (int)n);
    }

    private static int getListenerKey(Object object) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getListenerKey", $$robo$$android_net_wifi_RttManager$getListenerKey(java.lang.Object ), 0, (Object)object);
    }

    private static Object removeListener(int n) {
        return InvokeDynamicSupport.bootstrapStatic("removeListener", $$robo$$android_net_wifi_RttManager$removeListener(int ), 0, (int)n);
    }

    private static int removeListener(Object object) {
        return (int)InvokeDynamicSupport.bootstrapStatic("removeListener", $$robo$$android_net_wifi_RttManager$removeListener(java.lang.Object ), 0, (Object)object);
    }

    static {
        RobolectricInternals.classInitializing(RttManager.class);
    }

    public /* synthetic */ RttManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RttManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class ServiceHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_net_wifi_RttManager_ServiceHandler$__constructor__(Looper looper) {
        }

        private final void $$robo$$android_net_wifi_RttManager_ServiceHandler$handleMessage(Message msg) {
            switch (msg.what) {
                case 69632: {
                    if (msg.arg1 == 0) {
                        sAsyncChannel.sendMessage(69633);
                    } else {
                        Log.e("RttManager", "Failed to set up channel connection");
                        sAsyncChannel = null;
                    }
                    sConnected.countDown();
                    return;
                }
                case 69634: {
                    return;
                }
                case 69636: {
                    Log.e("RttManager", "Channel connection lost");
                    sAsyncChannel = null;
                    this.getLooper().quit();
                    return;
                }
            }
            Object listener = RttManager.getListener(msg.arg2);
            if (listener == null) {
                Log.d("RttManager", "invalid listener key = " + msg.arg2);
                return;
            }
            Log.d("RttManager", "listener key = " + msg.arg2);
            switch (msg.what) {
                case 160259: {
                    this.reportSuccess(listener, msg);
                    RttManager.removeListener(msg.arg2);
                    break;
                }
                case 160258: {
                    this.reportFailure(listener, msg);
                    RttManager.removeListener(msg.arg2);
                    break;
                }
                case 160260: {
                    ((RttListener)listener).onAborted();
                    RttManager.removeListener(msg.arg2);
                    break;
                }
                default: {
                    Log.d("RttManager", "Ignoring message " + msg.what);
                    return;
                }
            }
        }

        private final void $$robo$$android_net_wifi_RttManager_ServiceHandler$reportSuccess(Object listener, Message msg) {
            RttListener rttListener = (RttListener)listener;
            ParcelableRttResults parcelableResults = (ParcelableRttResults)msg.obj;
            ((RttListener)listener).onSuccess(parcelableResults.mResults);
        }

        private final void $$robo$$android_net_wifi_RttManager_ServiceHandler$reportFailure(Object listener, Message msg) {
            RttListener rttListener = (RttListener)listener;
            Bundle bundle = (Bundle)msg.obj;
            ((RttListener)listener).onFailure(msg.arg1, bundle.getString("android.net.wifi.RttManager.Description"));
        }

        private void __constructor__(Looper looper) {
            this.$$robo$$android_net_wifi_RttManager_ServiceHandler$__constructor__(looper);
        }

        ServiceHandler(Looper looper) {
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_ServiceHandler$__constructor__(android.os.Looper ), 0, this, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_net_wifi_RttManager_ServiceHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        void reportSuccess(Object object, Message message) {
            InvokeDynamicSupport.bootstrap("reportSuccess", $$robo$$android_net_wifi_RttManager_ServiceHandler$reportSuccess(java.lang.Object android.os.Message ), 0, this, object, message);
        }

        void reportFailure(Object object, Message message) {
            InvokeDynamicSupport.bootstrap("reportFailure", $$robo$$android_net_wifi_RttManager_ServiceHandler$reportFailure(java.lang.Object android.os.Message ), 0, this, object, message);
        }

        public /* synthetic */ ServiceHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ServiceHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface RttListener
    extends InstrumentedInterface {
        public void onSuccess(RttResult[] var1);

        public void onFailure(int var1, String var2);

        public void onAborted();
    }

    public static class ParcelableRttResults
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public RttResult[] mResults;
        public static Parcelable.Creator<ParcelableRttResults> CREATOR;

        private void $$robo$$android_net_wifi_RttManager_ParcelableRttResults$__constructor__(RttResult[] results) {
            this.mResults = results;
        }

        private final int $$robo$$android_net_wifi_RttManager_ParcelableRttResults$describeContents() {
            return 0;
        }

        private final void $$robo$$android_net_wifi_RttManager_ParcelableRttResults$writeToParcel(Parcel dest, int flags) {
            if (this.mResults != null) {
                dest.writeInt(this.mResults.length);
                for (RttResult result : this.mResults) {
                    dest.writeString(result.bssid);
                    dest.writeInt(result.status);
                    dest.writeInt(result.requestType);
                    dest.writeLong(result.ts);
                    dest.writeInt(result.rssi);
                    dest.writeInt(result.rssi_spread);
                    dest.writeInt(result.tx_rate);
                    dest.writeLong(result.rtt_ns);
                    dest.writeLong(result.rtt_sd_ns);
                    dest.writeLong(result.rtt_spread_ns);
                    dest.writeInt(result.distance_cm);
                    dest.writeInt(result.distance_sd_cm);
                    dest.writeInt(result.distance_spread_cm);
                }
            } else {
                dest.writeInt(0);
            }
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<ParcelableRttResults>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_net_wifi_RttManager_ParcelableRttResults_1$__constructor__() {
                }

                private final ParcelableRttResults $$robo$$android_net_wifi_RttManager_ParcelableRttResults_1$createFromParcel(Parcel in) {
                    int num = in.readInt();
                    if (num == 0) {
                        return new ParcelableRttResults(null);
                    }
                    RttResult[] results = new RttResult[num];
                    for (int i = 0; i < num; ++i) {
                        results[i] = new RttResult();
                        results[i].bssid = in.readString();
                        results[i].status = in.readInt();
                        results[i].requestType = in.readInt();
                        results[i].ts = in.readLong();
                        results[i].rssi = in.readInt();
                        results[i].rssi_spread = in.readInt();
                        results[i].tx_rate = in.readInt();
                        results[i].rtt_ns = in.readLong();
                        results[i].rtt_sd_ns = in.readLong();
                        results[i].rtt_spread_ns = in.readLong();
                        results[i].distance_cm = in.readInt();
                        results[i].distance_sd_cm = in.readInt();
                        results[i].distance_spread_cm = in.readInt();
                    }
                    ParcelableRttResults parcelableResults = new ParcelableRttResults(results);
                    return parcelableResults;
                }

                private final ParcelableRttResults[] $$robo$$android_net_wifi_RttManager_ParcelableRttResults_1$newArray(int size) {
                    return new ParcelableRttResults[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_net_wifi_RttManager_ParcelableRttResults_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_ParcelableRttResults_1$__constructor__(), 0, this);
                }

                @Override
                public ParcelableRttResults createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_RttManager_ParcelableRttResults_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public ParcelableRttResults[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_RttManager_ParcelableRttResults_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(RttResult[] rttResultArray) {
            this.$$robo$$android_net_wifi_RttManager_ParcelableRttResults$__constructor__(rttResultArray);
        }

        public ParcelableRttResults(RttResult[] rttResultArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_ParcelableRttResults$__constructor__(android.net.wifi.RttManager$RttResult[] ), 0, this, rttResultArray);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_RttManager_ParcelableRttResults$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_RttManager_ParcelableRttResults$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        static {
            RobolectricInternals.classInitializing(ParcelableRttResults.class);
        }

        public /* synthetic */ ParcelableRttResults() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParcelableRttResults)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class RttResult
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String bssid;
        public int status;
        public int requestType;
        public long ts;
        public int rssi;
        public int rssi_spread;
        public int tx_rate;
        public long rtt_ns;
        public long rtt_sd_ns;
        public long rtt_spread_ns;
        public int distance_cm;
        public int distance_sd_cm;
        public int distance_spread_cm;

        private void $$robo$$android_net_wifi_RttManager_RttResult$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_RttManager_RttResult$__constructor__();
        }

        public RttResult() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_RttResult$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RttResult)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ParcelableRttParams
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public RttParams[] mParams;
        public static Parcelable.Creator<ParcelableRttParams> CREATOR;

        private void $$robo$$android_net_wifi_RttManager_ParcelableRttParams$__constructor__(RttParams[] params) {
            this.mParams = params;
        }

        private final int $$robo$$android_net_wifi_RttManager_ParcelableRttParams$describeContents() {
            return 0;
        }

        private final void $$robo$$android_net_wifi_RttManager_ParcelableRttParams$writeToParcel(Parcel dest, int flags) {
            if (this.mParams != null) {
                dest.writeInt(this.mParams.length);
                for (RttParams params : this.mParams) {
                    dest.writeInt(params.deviceType);
                    dest.writeInt(params.requestType);
                    dest.writeString(params.bssid);
                    dest.writeInt(params.frequency);
                    dest.writeInt(params.channelWidth);
                    dest.writeInt(params.num_samples);
                    dest.writeInt(params.num_retries);
                }
            } else {
                dest.writeInt(0);
            }
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<ParcelableRttParams>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_net_wifi_RttManager_ParcelableRttParams_1$__constructor__() {
                }

                private final ParcelableRttParams $$robo$$android_net_wifi_RttManager_ParcelableRttParams_1$createFromParcel(Parcel in) {
                    int num = in.readInt();
                    if (num == 0) {
                        return new ParcelableRttParams(null);
                    }
                    RttParams[] params = new RttParams[num];
                    for (int i = 0; i < num; ++i) {
                        params[i] = new RttParams();
                        params[i].deviceType = in.readInt();
                        params[i].requestType = in.readInt();
                        params[i].bssid = in.readString();
                        params[i].frequency = in.readInt();
                        params[i].channelWidth = in.readInt();
                        params[i].num_samples = in.readInt();
                        params[i].num_retries = in.readInt();
                    }
                    ParcelableRttParams parcelableParams = new ParcelableRttParams(params);
                    return parcelableParams;
                }

                private final ParcelableRttParams[] $$robo$$android_net_wifi_RttManager_ParcelableRttParams_1$newArray(int size) {
                    return new ParcelableRttParams[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_net_wifi_RttManager_ParcelableRttParams_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_ParcelableRttParams_1$__constructor__(), 0, this);
                }

                @Override
                public ParcelableRttParams createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_RttManager_ParcelableRttParams_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public ParcelableRttParams[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_RttManager_ParcelableRttParams_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(RttParams[] rttParamsArray) {
            this.$$robo$$android_net_wifi_RttManager_ParcelableRttParams$__constructor__(rttParamsArray);
        }

        ParcelableRttParams(RttParams[] rttParamsArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_ParcelableRttParams$__constructor__(android.net.wifi.RttManager$RttParams[] ), 0, this, rttParamsArray);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_RttManager_ParcelableRttParams$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_RttManager_ParcelableRttParams$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        static {
            RobolectricInternals.classInitializing(ParcelableRttParams.class);
        }

        public /* synthetic */ ParcelableRttParams() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParcelableRttParams)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class RttParams
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int deviceType;
        public int requestType;
        public String bssid;
        public int frequency;
        public int channelWidth;
        public int num_samples;
        public int num_retries;

        private void $$robo$$android_net_wifi_RttManager_RttParams$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_RttManager_RttParams$__constructor__();
        }

        public RttParams() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_RttParams$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RttParams)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class Capabilities
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int supportedType;
        public int supportedPeerType;
        /* synthetic */ RttManager this$0;

        private void $$robo$$android_net_wifi_RttManager_Capabilities$__constructor__(RttManager rttManager) {
        }

        private void __constructor__(RttManager rttManager) {
            this.$$robo$$android_net_wifi_RttManager_Capabilities$__constructor__(rttManager);
        }

        public Capabilities(RttManager rttManager) {
            this.this$0 = rttManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_RttManager_Capabilities$__constructor__(android.net.wifi.RttManager ), 0, this, rttManager);
        }

        public /* synthetic */ Capabilities() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Capabilities)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

