/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.wifi.WifiSsid;
import android.os.Parcel;
import android.os.Parcelable;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ScanResult
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public String SSID;
    public WifiSsid wifiSsid;
    public String BSSID;
    public String capabilities;
    public int level;
    public int frequency;
    public long timestamp;
    public long seen;
    public int isAutoJoinCandidate;
    public static int ENABLED = 0;
    public static int AUTO_ROAM_DISABLED = 16;
    public static int AUTO_JOIN_DISABLED = 32;
    public static int AUTHENTICATION_ERROR = 128;
    public int autoJoinStatus;
    public int numIpConfigFailures;
    public long blackListTimestamp;
    public boolean untrusted;
    public int numConnection;
    public int numUsage;
    public int distanceCm;
    public int distanceSdCm;
    public static int UNSPECIFIED = -1;
    public InformationElement[] informationElements;
    public static Parcelable.Creator<ScanResult> CREATOR;

    private final void $$robo$$android_net_wifi_ScanResult$averageRssi(int previousRssi, long previousSeen, int maxAge) {
        if (this.seen == 0L) {
            this.seen = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        }
        long age = this.seen - previousSeen;
        if (previousSeen > 0L && age > 0L && age < (long)(maxAge / 2)) {
            double alpha = 0.5 - (double)age / (double)maxAge;
            this.level = (int)((double)this.level * (1.0 - alpha) + (double)previousRssi * alpha);
        }
    }

    private final void $$robo$$android_net_wifi_ScanResult$setAutoJoinStatus(int status) {
        if (status < 0) {
            status = 0;
        }
        if (status == 0) {
            this.blackListTimestamp = 0L;
        } else if (status > this.autoJoinStatus) {
            this.blackListTimestamp = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        }
        this.autoJoinStatus = status;
    }

    private final boolean $$robo$$android_net_wifi_ScanResult$is24GHz() {
        return ScanResult.is24GHz(this.frequency);
    }

    private static final boolean $$robo$$android_net_wifi_ScanResult$is24GHz(int freq) {
        return freq > 2400 && freq < 2500;
    }

    private final boolean $$robo$$android_net_wifi_ScanResult$is5GHz() {
        return ScanResult.is5GHz(this.frequency);
    }

    private static final boolean $$robo$$android_net_wifi_ScanResult$is5GHz(int freq) {
        return freq > 4900 && freq < 5900;
    }

    private void $$robo$$android_net_wifi_ScanResult$__constructor__(WifiSsid wifiSsid, String BSSID, String caps, int level, int frequency, long tsf) {
        this.wifiSsid = wifiSsid;
        this.SSID = wifiSsid != null ? wifiSsid.toString() : "<unknown ssid>";
        this.BSSID = BSSID;
        this.capabilities = caps;
        this.level = level;
        this.frequency = frequency;
        this.timestamp = tsf;
        this.distanceCm = -1;
        this.distanceSdCm = -1;
    }

    private void $$robo$$android_net_wifi_ScanResult$__constructor__(WifiSsid wifiSsid, String BSSID, String caps, int level, int frequency, long tsf, int distCm, int distSdCm) {
        this.wifiSsid = wifiSsid;
        this.SSID = wifiSsid != null ? wifiSsid.toString() : "<unknown ssid>";
        this.BSSID = BSSID;
        this.capabilities = caps;
        this.level = level;
        this.frequency = frequency;
        this.timestamp = tsf;
        this.distanceCm = distCm;
        this.distanceSdCm = distSdCm;
    }

    private void $$robo$$android_net_wifi_ScanResult$__constructor__(ScanResult source) {
        if (source != null) {
            this.wifiSsid = source.wifiSsid;
            this.SSID = source.SSID;
            this.BSSID = source.BSSID;
            this.capabilities = source.capabilities;
            this.level = source.level;
            this.frequency = source.frequency;
            this.timestamp = source.timestamp;
            this.distanceCm = source.distanceCm;
            this.distanceSdCm = source.distanceSdCm;
            this.seen = source.seen;
            this.autoJoinStatus = source.autoJoinStatus;
            this.untrusted = source.untrusted;
            this.numConnection = source.numConnection;
            this.numUsage = source.numUsage;
            this.numIpConfigFailures = source.numIpConfigFailures;
            this.isAutoJoinCandidate = source.isAutoJoinCandidate;
        }
    }

    private void $$robo$$android_net_wifi_ScanResult$__constructor__() {
    }

    private final String $$robo$$android_net_wifi_ScanResult$toString() {
        StringBuffer sb = new StringBuffer();
        String none = "<none>";
        sb.append("SSID: ").append(this.wifiSsid == null ? "<unknown ssid>" : this.wifiSsid).append(", BSSID: ").append(this.BSSID == null ? none : this.BSSID).append(", capabilities: ").append(this.capabilities == null ? none : this.capabilities).append(", level: ").append(this.level).append(", frequency: ").append(this.frequency).append(", timestamp: ").append(this.timestamp);
        sb.append(", distance: ").append(this.distanceCm != -1 ? Integer.valueOf(this.distanceCm) : "?").append("(cm)");
        sb.append(", distanceSd: ").append(this.distanceSdCm != -1 ? Integer.valueOf(this.distanceSdCm) : "?").append("(cm)");
        if (this.autoJoinStatus != 0) {
            sb.append(", status: ").append(this.autoJoinStatus);
        }
        return sb.toString();
    }

    private final int $$robo$$android_net_wifi_ScanResult$describeContents() {
        return 0;
    }

    private final void $$robo$$android_net_wifi_ScanResult$writeToParcel(Parcel dest, int flags) {
        if (this.wifiSsid != null) {
            dest.writeInt(1);
            this.wifiSsid.writeToParcel(dest, flags);
        } else {
            dest.writeInt(0);
        }
        dest.writeString(this.BSSID);
        dest.writeString(this.capabilities);
        dest.writeInt(this.level);
        dest.writeInt(this.frequency);
        dest.writeLong(this.timestamp);
        dest.writeInt(this.distanceCm);
        dest.writeInt(this.distanceSdCm);
        dest.writeLong(this.seen);
        dest.writeInt(this.autoJoinStatus);
        dest.writeInt(this.untrusted ? 1 : 0);
        dest.writeInt(this.numConnection);
        dest.writeInt(this.numUsage);
        dest.writeInt(this.numIpConfigFailures);
        dest.writeInt(this.isAutoJoinCandidate);
        if (this.informationElements != null) {
            dest.writeInt(this.informationElements.length);
            for (int i = 0; i < this.informationElements.length; ++i) {
                dest.writeInt(this.informationElements[i].id);
                dest.writeInt(this.informationElements[i].bytes.length);
                dest.writeByteArray(this.informationElements[i].bytes);
            }
        } else {
            dest.writeInt(0);
        }
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<ScanResult>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_wifi_ScanResult_1$__constructor__() {
            }

            private final ScanResult $$robo$$android_net_wifi_ScanResult_1$createFromParcel(Parcel in) {
                WifiSsid wifiSsid = null;
                if (in.readInt() == 1) {
                    wifiSsid = WifiSsid.CREATOR.createFromParcel(in);
                }
                ScanResult sr = new ScanResult(wifiSsid, in.readString(), in.readString(), in.readInt(), in.readInt(), in.readLong(), in.readInt(), in.readInt());
                sr.seen = in.readLong();
                sr.autoJoinStatus = in.readInt();
                sr.untrusted = in.readInt() != 0;
                sr.numConnection = in.readInt();
                sr.numUsage = in.readInt();
                sr.numIpConfigFailures = in.readInt();
                sr.isAutoJoinCandidate = in.readInt();
                int n = in.readInt();
                if (n != 0) {
                    sr.informationElements = new InformationElement[n];
                    for (int i = 0; i < n; ++i) {
                        sr.informationElements[i] = new InformationElement();
                        sr.informationElements[i].id = in.readInt();
                        int len = in.readInt();
                        sr.informationElements[i].bytes = new byte[len];
                        in.readByteArray(sr.informationElements[i].bytes);
                    }
                }
                return sr;
            }

            private final ScanResult[] $$robo$$android_net_wifi_ScanResult_1$newArray(int size) {
                return new ScanResult[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_wifi_ScanResult_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_ScanResult_1$__constructor__(), 0, this);
            }

            @Override
            public ScanResult createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_ScanResult_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public ScanResult[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_ScanResult_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public void averageRssi(int n, long l, int n2) {
        InvokeDynamicSupport.bootstrap("averageRssi", $$robo$$android_net_wifi_ScanResult$averageRssi(int long int ), 0, this, n, l, n2);
    }

    public void setAutoJoinStatus(int n) {
        InvokeDynamicSupport.bootstrap("setAutoJoinStatus", $$robo$$android_net_wifi_ScanResult$setAutoJoinStatus(int ), 0, this, n);
    }

    public boolean is24GHz() {
        return (boolean)InvokeDynamicSupport.bootstrap("is24GHz", $$robo$$android_net_wifi_ScanResult$is24GHz(), 0, this);
    }

    public static boolean is24GHz(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("is24GHz", $$robo$$android_net_wifi_ScanResult$is24GHz(int ), 0, (int)n);
    }

    public boolean is5GHz() {
        return (boolean)InvokeDynamicSupport.bootstrap("is5GHz", $$robo$$android_net_wifi_ScanResult$is5GHz(), 0, this);
    }

    public static boolean is5GHz(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("is5GHz", $$robo$$android_net_wifi_ScanResult$is5GHz(int ), 0, (int)n);
    }

    private void __constructor__(WifiSsid wifiSsid, String string2, String string3, int n, int n2, long l) {
        this.$$robo$$android_net_wifi_ScanResult$__constructor__(wifiSsid, string2, string3, n, n2, l);
    }

    public ScanResult(WifiSsid wifiSsid, String string2, String string3, int n, int n2, long l) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_ScanResult$__constructor__(android.net.wifi.WifiSsid java.lang.String java.lang.String int int long ), 0, this, wifiSsid, string2, string3, n, n2, l);
    }

    private void __constructor__(WifiSsid wifiSsid, String string2, String string3, int n, int n2, long l, int n3, int n4) {
        this.$$robo$$android_net_wifi_ScanResult$__constructor__(wifiSsid, string2, string3, n, n2, l, n3, n4);
    }

    public ScanResult(WifiSsid wifiSsid, String string2, String string3, int n, int n2, long l, int n3, int n4) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_ScanResult$__constructor__(android.net.wifi.WifiSsid java.lang.String java.lang.String int int long int int ), 0, this, wifiSsid, string2, string3, n, n2, l, n3, n4);
    }

    private void __constructor__(ScanResult scanResult) {
        this.$$robo$$android_net_wifi_ScanResult$__constructor__(scanResult);
    }

    public ScanResult(ScanResult scanResult) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_ScanResult$__constructor__(android.net.wifi.ScanResult ), 0, this, scanResult);
    }

    private void __constructor__() {
        this.$$robo$$android_net_wifi_ScanResult$__constructor__();
    }

    public ScanResult() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_ScanResult$__constructor__(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_wifi_ScanResult$toString(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_ScanResult$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_ScanResult$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    static {
        RobolectricInternals.classInitializing(ScanResult.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ScanResult)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class InformationElement
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int id;
        public byte[] bytes;

        private void $$robo$$android_net_wifi_ScanResult_InformationElement$__constructor__() {
        }

        private void $$robo$$android_net_wifi_ScanResult_InformationElement$__constructor__(InformationElement rhs) {
            this.id = rhs.id;
            this.bytes = (byte[])rhs.bytes.clone();
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_ScanResult_InformationElement$__constructor__();
        }

        public InformationElement() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_ScanResult_InformationElement$__constructor__(), 0, this);
        }

        private void __constructor__(InformationElement informationElement) {
            this.$$robo$$android_net_wifi_ScanResult_InformationElement$__constructor__(informationElement);
        }

        public InformationElement(InformationElement informationElement) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_ScanResult_InformationElement$__constructor__(android.net.wifi.ScanResult$InformationElement ), 0, this, informationElement);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InformationElement)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

