/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.IpConfiguration;
import android.net.ProxyInfo;
import android.net.StaticIpConfiguration;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiEnterpriseConfig;
import android.net.wifi.WifiSsid;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WifiConfiguration
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "WifiConfiguration";
    public static String ssidVarName = "ssid";
    public static String bssidVarName = "bssid";
    public static String pskVarName = "psk";
    public static String[] wepKeyVarNames;
    public static String wepTxKeyIdxVarName = "wep_tx_keyidx";
    public static String priorityVarName = "priority";
    public static String hiddenSSIDVarName = "scan_ssid";
    public static String pmfVarName = "ieee80211w";
    public static String updateIdentiferVarName = "update_identifier";
    public static int INVALID_NETWORK_ID = -1;
    public static int DISABLED_UNKNOWN_REASON = 0;
    public static int DISABLED_DNS_FAILURE = 1;
    public static int DISABLED_DHCP_FAILURE = 2;
    public static int DISABLED_AUTH_FAILURE = 3;
    public static int DISABLED_ASSOCIATION_REJECT = 4;
    public static int DISABLED_BY_WIFI_MANAGER = 5;
    public int networkId;
    public int status;
    public boolean dirty;
    public int disableReason;
    public String SSID;
    public String BSSID;
    public String FQDN;
    public String naiRealm;
    public String preSharedKey;
    public String[] wepKeys;
    public int wepTxKeyIndex;
    public int priority;
    public boolean hiddenSSID;
    public boolean requirePMF;
    public String updateIdentifier;
    public BitSet allowedKeyManagement;
    public BitSet allowedProtocols;
    public BitSet allowedAuthAlgorithms;
    public BitSet allowedPairwiseCiphers;
    public BitSet allowedGroupCiphers;
    public WifiEnterpriseConfig enterpriseConfig;
    private IpConfiguration mIpConfiguration;
    public String dhcpServer;
    public String defaultGwMacAddress;
    public String lastFailure;
    public boolean noInternetAccess;
    public int creatorUid;
    public int lastConnectUid;
    public int lastUpdateUid;
    public String autoJoinBSSID;
    public HashMap<String, ScanResult> scanResultCache;
    public static int INVALID_RSSI;
    public static int UNWANTED_BLACKLIST_SOFT_RSSI_24;
    public static int UNWANTED_BLACKLIST_SOFT_RSSI_5;
    public static int GOOD_RSSI_24;
    public static int LOW_RSSI_24;
    public static int BAD_RSSI_24;
    public static int GOOD_RSSI_5;
    public static int LOW_RSSI_5;
    public static int BAD_RSSI_5;
    public static int UNWANTED_BLACKLIST_SOFT_BUMP;
    public static int UNWANTED_BLACKLIST_HARD_BUMP;
    public static int UNBLACKLIST_THRESHOLD_24_SOFT;
    public static int UNBLACKLIST_THRESHOLD_24_HARD;
    public static int UNBLACKLIST_THRESHOLD_5_SOFT;
    public static int UNBLACKLIST_THRESHOLD_5_HARD;
    public static int INITIAL_AUTO_JOIN_ATTEMPT_MIN_24;
    public static int INITIAL_AUTO_JOIN_ATTEMPT_MIN_5;
    public static int A_BAND_PREFERENCE_RSSI_THRESHOLD;
    public static int G_BAND_PREFERENCE_RSSI_THRESHOLD;
    public static int HOME_NETWORK_RSSI_BOOST;
    public static int MAX_INITIAL_AUTO_JOIN_RSSI_BOOST;
    public Visibility visibility;
    public static int AUTO_JOIN_ENABLED = 0;
    public static int AUTO_JOIN_TEMPORARY_DISABLED = 1;
    public static int AUTO_JOIN_TEMPORARY_DISABLED_LINK_ERRORS = 32;
    public static int AUTO_JOIN_TEMPORARY_DISABLED_AT_SUPPLICANT = 64;
    public static int AUTO_JOIN_DISABLED_ON_AUTH_FAILURE = 128;
    public static int AUTO_JOIN_DISABLED_NO_CREDENTIALS = 160;
    public static int AUTO_JOIN_DISABLED_USER_ACTION = 161;
    public static int AUTO_JOIN_DELETED = 200;
    public int autoJoinStatus;
    public int numConnectionFailures;
    public int numIpConfigFailures;
    public int numAuthFailures;
    public long blackListTimestamp;
    public long lastConnected;
    public long lastConnectionFailure;
    public long lastDisconnected;
    public boolean selfAdded;
    public boolean didSelfAdd;
    public String peerWifiConfiguration;
    public boolean ephemeral;
    public boolean autoJoinBailedDueToLowRssi;
    public int autoJoinUseAggressiveJoinAttemptThreshold;
    public int numScorerOverride;
    public int numScorerOverrideAndSwitchedNetwork;
    public int numAssociation;
    public int numUserTriggeredWifiDisableLowRSSI;
    public int numUserTriggeredWifiDisableBadRSSI;
    public int numUserTriggeredWifiDisableNotHighRSSI;
    public int numTicksAtLowRSSI;
    public int numTicksAtBadRSSI;
    public int numTicksAtNotHighRSSI;
    public int numUserTriggeredJoinAttempts;
    public HashMap<String, Integer> connectChoices;
    public HashMap<String, Integer> linkedConfigurations;
    String mCachedConfigKey;
    public static Parcelable.Creator<WifiConfiguration> CREATOR;

    private final Visibility $$robo$$android_net_wifi_WifiConfiguration$setVisibility(long age) {
        if (this.scanResultCache == null) {
            this.visibility = null;
            return null;
        }
        Visibility status = new Visibility(this);
        CallSite now_ms = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        for (ScanResult result : this.scanResultCache.values()) {
            if (result.seen == 0L) continue;
            if (result.is5GHz()) {
                ++status.num5;
            } else if (result.is24GHz()) {
                ++status.num24;
            }
            if (now_ms - result.seen > age) continue;
            if (result.is5GHz()) {
                if (result.level <= status.rssi5) continue;
                status.rssi5 = result.level;
                status.age5 = result.seen;
                status.BSSID5 = result.BSSID;
                continue;
            }
            if (!result.is24GHz() || result.level <= status.rssi24) continue;
            status.rssi24 = result.level;
            status.age24 = result.seen;
            status.BSSID24 = result.BSSID;
        }
        this.visibility = status;
        return status;
    }

    private void $$robo$$android_net_wifi_WifiConfiguration$__constructor__() {
        this.networkId = -1;
        this.SSID = null;
        this.BSSID = null;
        this.FQDN = null;
        this.naiRealm = null;
        this.priority = 0;
        this.hiddenSSID = false;
        this.disableReason = 0;
        this.allowedKeyManagement = new BitSet();
        this.allowedProtocols = new BitSet();
        this.allowedAuthAlgorithms = new BitSet();
        this.allowedPairwiseCiphers = new BitSet();
        this.allowedGroupCiphers = new BitSet();
        this.wepKeys = new String[4];
        for (int i = 0; i < this.wepKeys.length; ++i) {
            this.wepKeys[i] = null;
        }
        this.enterpriseConfig = new WifiEnterpriseConfig();
        this.autoJoinStatus = 0;
        this.selfAdded = false;
        this.didSelfAdd = false;
        this.ephemeral = false;
        this.noInternetAccess = false;
        this.mIpConfiguration = new IpConfiguration();
    }

    private final boolean $$robo$$android_net_wifi_WifiConfiguration$isValid() {
        if (this.allowedKeyManagement == null) {
            return false;
        }
        if (this.allowedKeyManagement.cardinality() > 1) {
            if (this.allowedKeyManagement.cardinality() != 2) {
                return false;
            }
            if (!this.allowedKeyManagement.get(2)) {
                return false;
            }
            if (!this.allowedKeyManagement.get(3) && !this.allowedKeyManagement.get(1)) {
                return false;
            }
        }
        return true;
    }

    private final boolean $$robo$$android_net_wifi_WifiConfiguration$isLinked(WifiConfiguration config) {
        return config.linkedConfigurations != null && this.linkedConfigurations != null && config.linkedConfigurations.get(this.configKey()) != null && this.linkedConfigurations.get(config.configKey()) != null;
    }

    private final ScanResult $$robo$$android_net_wifi_WifiConfiguration$lastSeen() {
        ScanResult mostRecent = null;
        if (this.scanResultCache == null) {
            return null;
        }
        for (ScanResult result : this.scanResultCache.values()) {
            if (mostRecent == null) {
                if (result.seen == 0L) continue;
                mostRecent = result;
                continue;
            }
            if (result.seen <= mostRecent.seen) continue;
            mostRecent = result;
        }
        return mostRecent;
    }

    private final void $$robo$$android_net_wifi_WifiConfiguration$setAutoJoinStatus(int status) {
        if (status < 0) {
            status = 0;
        }
        if (status == 0) {
            this.blackListTimestamp = 0L;
        } else if (status > this.autoJoinStatus) {
            this.blackListTimestamp = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        }
        if (status != this.autoJoinStatus) {
            this.autoJoinStatus = status;
            this.dirty = true;
        }
    }

    private final ArrayList<ScanResult> $$robo$$android_net_wifi_WifiConfiguration$sortScanResults() {
        ArrayList<ScanResult> list = new ArrayList<ScanResult>(this.scanResultCache.values());
        if (list.size() != 0) {
            Collections.sort(list, new Comparator(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ WifiConfiguration this$0;

                private void $$robo$$android_net_wifi_WifiConfiguration_1$__constructor__(WifiConfiguration wifiConfiguration) {
                }

                private final int $$robo$$android_net_wifi_WifiConfiguration_1$compare(Object o1, Object o2) {
                    ScanResult a = (ScanResult)o1;
                    ScanResult b = (ScanResult)o2;
                    if (a.numIpConfigFailures > b.numIpConfigFailures) {
                        return 1;
                    }
                    if (a.numIpConfigFailures < b.numIpConfigFailures) {
                        return -1;
                    }
                    if (a.seen > b.seen) {
                        return -1;
                    }
                    if (a.seen < b.seen) {
                        return 1;
                    }
                    if (a.level > b.level) {
                        return -1;
                    }
                    if (a.level < b.level) {
                        return 1;
                    }
                    return a.BSSID.compareTo(b.BSSID);
                }

                private void __constructor__(WifiConfiguration wifiConfiguration) {
                    this.$$robo$$android_net_wifi_WifiConfiguration_1$__constructor__(wifiConfiguration);
                }
                {
                    this.this$0 = wifiConfiguration;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiConfiguration_1$__constructor__(android.net.wifi.WifiConfiguration ), 0, this, wifiConfiguration);
                }

                public int compare(Object object, Object object2) {
                    return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$android_net_wifi_WifiConfiguration_1$compare(java.lang.Object java.lang.Object ), 0, this, object, object2);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
        return list;
    }

    private final String $$robo$$android_net_wifi_WifiConfiguration$toString() {
        reference var4_4;
        StringBuilder sbuf = new StringBuilder();
        if (this.status == 0) {
            sbuf.append("* ");
        } else if (this.status == 1) {
            sbuf.append("- DSBLE ");
        }
        sbuf.append("ID: ").append(this.networkId).append(" SSID: ").append(this.SSID).append(" BSSID: ").append(this.BSSID).append(" FQDN: ").append(this.FQDN).append(" REALM: ").append(this.naiRealm).append(" PRIO: ").append(this.priority).append('\n');
        if (this.numConnectionFailures > 0) {
            sbuf.append(" numConnectFailures ").append(this.numConnectionFailures).append("\n");
        }
        if (this.numIpConfigFailures > 0) {
            sbuf.append(" numIpConfigFailures ").append(this.numIpConfigFailures).append("\n");
        }
        if (this.numAuthFailures > 0) {
            sbuf.append(" numAuthFailures ").append(this.numAuthFailures).append("\n");
        }
        if (this.autoJoinStatus > 0) {
            sbuf.append(" autoJoinStatus ").append(this.autoJoinStatus).append("\n");
        }
        if (this.disableReason > 0) {
            sbuf.append(" disableReason ").append(this.disableReason).append("\n");
        }
        if (this.numAssociation > 0) {
            sbuf.append(" numAssociation ").append(this.numAssociation).append("\n");
        }
        if (this.didSelfAdd) {
            sbuf.append(" didSelfAdd");
        }
        if (this.selfAdded) {
            sbuf.append(" selfAdded");
        }
        if (this.noInternetAccess) {
            sbuf.append(" noInternetAccess");
        }
        if (this.didSelfAdd || this.selfAdded || this.noInternetAccess) {
            sbuf.append("\n");
        }
        sbuf.append(" KeyMgmt:");
        for (int k = 0; k < this.allowedKeyManagement.size(); ++k) {
            if (!this.allowedKeyManagement.get(k)) continue;
            sbuf.append(" ");
            if (k < KeyMgmt.strings.length) {
                sbuf.append(KeyMgmt.strings[k]);
                continue;
            }
            sbuf.append("??");
        }
        sbuf.append(" Protocols:");
        for (int p = 0; p < this.allowedProtocols.size(); ++p) {
            if (!this.allowedProtocols.get(p)) continue;
            sbuf.append(" ");
            if (p < Protocol.strings.length) {
                sbuf.append(Protocol.strings[p]);
                continue;
            }
            sbuf.append("??");
        }
        sbuf.append('\n');
        sbuf.append(" AuthAlgorithms:");
        for (int a = 0; a < this.allowedAuthAlgorithms.size(); ++a) {
            if (!this.allowedAuthAlgorithms.get(a)) continue;
            sbuf.append(" ");
            if (a < AuthAlgorithm.strings.length) {
                sbuf.append(AuthAlgorithm.strings[a]);
                continue;
            }
            sbuf.append("??");
        }
        sbuf.append('\n');
        sbuf.append(" PairwiseCiphers:");
        for (int pc = 0; pc < this.allowedPairwiseCiphers.size(); ++pc) {
            if (!this.allowedPairwiseCiphers.get(pc)) continue;
            sbuf.append(" ");
            if (pc < PairwiseCipher.strings.length) {
                sbuf.append(PairwiseCipher.strings[pc]);
                continue;
            }
            sbuf.append("??");
        }
        sbuf.append('\n');
        sbuf.append(" GroupCiphers:");
        for (int gc = 0; gc < this.allowedGroupCiphers.size(); ++gc) {
            if (!this.allowedGroupCiphers.get(gc)) continue;
            sbuf.append(" ");
            if (gc < GroupCipher.strings.length) {
                sbuf.append(GroupCipher.strings[gc]);
                continue;
            }
            sbuf.append("??");
        }
        sbuf.append('\n').append(" PSK: ");
        if (this.preSharedKey != null) {
            sbuf.append('*');
        }
        sbuf.append("\nEnterprise config:\n");
        sbuf.append(this.enterpriseConfig);
        sbuf.append("IP config:\n");
        sbuf.append(this.mIpConfiguration.toString());
        if (this.creatorUid != 0) {
            sbuf.append(" uid=" + Integer.toString(this.creatorUid));
        }
        if (this.autoJoinBSSID != null) {
            sbuf.append(" autoJoinBSSID=" + this.autoJoinBSSID);
        }
        CallSite now_ms = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        if (this.blackListTimestamp != 0L) {
            sbuf.append('\n');
            var4_4 = now_ms - this.blackListTimestamp;
            if (var4_4 <= 0L) {
                sbuf.append(" blackListed since <incorrect>");
            } else {
                sbuf.append(" blackListed: ").append(Long.toString((long)(var4_4 / 1000L))).append("sec");
            }
        }
        if (this.lastConnected != 0L) {
            sbuf.append('\n');
            var4_4 = now_ms - this.lastConnected;
            if (var4_4 <= 0L) {
                sbuf.append("lastConnected since <incorrect>");
            } else {
                sbuf.append("lastConnected: ").append(Long.toString((long)(var4_4 / 1000L))).append("sec");
            }
        }
        if (this.lastConnectionFailure != 0L) {
            sbuf.append('\n');
            var4_4 = now_ms - this.lastConnectionFailure;
            if (var4_4 <= 0L) {
                sbuf.append("lastConnectionFailure since <incorrect>");
            } else {
                sbuf.append("lastConnectionFailure: ").append(Long.toString((long)(var4_4 / 1000L)));
                sbuf.append("sec");
            }
        }
        sbuf.append('\n');
        if (this.linkedConfigurations != null) {
            for (String key : this.linkedConfigurations.keySet()) {
                sbuf.append(" linked: ").append(key);
                sbuf.append('\n');
            }
        }
        if (this.connectChoices != null) {
            for (String key : this.connectChoices.keySet()) {
                Integer choice = this.connectChoices.get(key);
                if (choice == null) continue;
                sbuf.append(" choice: ").append(key);
                sbuf.append(" = ").append(choice);
                sbuf.append('\n');
            }
        }
        if (this.scanResultCache != null) {
            sbuf.append("Scan Cache:  ").append('\n');
            ArrayList<ScanResult> arrayList = this.sortScanResults();
            if (arrayList.size() > 0) {
                for (ScanResult result : arrayList) {
                    reference var7_11 = now_ms - result.seen;
                    Object ageSec = 0L;
                    Object ageMin = 0L;
                    Object ageHour = 0L;
                    Object ageMilli = 0L;
                    Object ageDay = 0L;
                    if (now_ms > result.seen && result.seen > 0L) {
                        ageMilli = var7_11 % 1000L;
                        ageSec = var7_11 / 1000L % 60L;
                        ageMin = var7_11 / 60000L % 60L;
                        ageHour = var7_11 / 3600000L % 24L;
                        ageDay = var7_11 / 86400000L;
                    }
                    sbuf.append("{").append(result.BSSID).append(",").append(result.frequency);
                    sbuf.append(",").append(String.format("%3d", result.level));
                    if (result.autoJoinStatus > 0) {
                        sbuf.append(",st=").append(result.autoJoinStatus);
                    }
                    if (ageSec > 0L || ageMilli > 0L) {
                        sbuf.append(String.format(",%4d.%02d.%02d.%02d.%03dms", ageDay, ageHour, ageMin, ageSec, ageMilli));
                    }
                    if (result.numIpConfigFailures > 0) {
                        sbuf.append(",ipfail=");
                        sbuf.append(result.numIpConfigFailures);
                    }
                    sbuf.append("} ");
                }
                sbuf.append('\n');
            }
        }
        sbuf.append("triggeredLow: ").append(this.numUserTriggeredWifiDisableLowRSSI);
        sbuf.append(" triggeredBad: ").append(this.numUserTriggeredWifiDisableBadRSSI);
        sbuf.append(" triggeredNotHigh: ").append(this.numUserTriggeredWifiDisableNotHighRSSI);
        sbuf.append('\n');
        sbuf.append("ticksLow: ").append(this.numTicksAtLowRSSI);
        sbuf.append(" ticksBad: ").append(this.numTicksAtBadRSSI);
        sbuf.append(" ticksNotHigh: ").append(this.numTicksAtNotHighRSSI);
        sbuf.append('\n');
        sbuf.append("triggeredJoin: ").append(this.numUserTriggeredJoinAttempts);
        sbuf.append('\n');
        sbuf.append("autoJoinBailedDueToLowRssi: ").append(this.autoJoinBailedDueToLowRssi);
        sbuf.append('\n');
        sbuf.append("autoJoinUseAggressiveJoinAttemptThreshold: ");
        sbuf.append(this.autoJoinUseAggressiveJoinAttemptThreshold);
        sbuf.append('\n');
        return sbuf.toString();
    }

    private final String $$robo$$android_net_wifi_WifiConfiguration$getPrintableSsid() {
        if (this.SSID == null) {
            return "";
        }
        int length = this.SSID.length();
        if (length > 2 && this.SSID.charAt(0) == '\"' && this.SSID.charAt(length - 1) == '\"') {
            return this.SSID.substring(1, length - 1);
        }
        if (length > 3 && this.SSID.charAt(0) == 'P' && this.SSID.charAt(1) == '\"' && this.SSID.charAt(length - 1) == '\"') {
            WifiSsid wifiSsid = WifiSsid.createFromAsciiEncoded(this.SSID.substring(2, length - 1));
            return wifiSsid.toString();
        }
        return this.SSID;
    }

    private final String $$robo$$android_net_wifi_WifiConfiguration$getKeyIdForCredentials(WifiConfiguration current) {
        String keyMgmt = null;
        try {
            if (TextUtils.isEmpty(this.SSID)) {
                this.SSID = current.SSID;
            }
            if (this.allowedKeyManagement.cardinality() == 0) {
                this.allowedKeyManagement = current.allowedKeyManagement;
            }
            if (this.allowedKeyManagement.get(2)) {
                keyMgmt = KeyMgmt.strings[2];
            }
            if (this.allowedKeyManagement.get(3)) {
                keyMgmt = keyMgmt + KeyMgmt.strings[3];
            }
            if (TextUtils.isEmpty(keyMgmt)) {
                throw new IllegalStateException("Not an EAP network");
            }
            return this.trimStringForKeyId(this.SSID) + "_" + keyMgmt + "_" + this.trimStringForKeyId(this.enterpriseConfig.getKeyId(current != null ? current.enterpriseConfig : null));
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("Invalid config details");
        }
    }

    private final String $$robo$$android_net_wifi_WifiConfiguration$trimStringForKeyId(String string2) {
        return string2.replace("\"", "").replace(" ", "");
    }

    private static final BitSet $$robo$$android_net_wifi_WifiConfiguration$readBitSet(Parcel src) {
        int cardinality = src.readInt();
        BitSet set = new BitSet();
        for (int i = 0; i < cardinality; ++i) {
            set.set(src.readInt());
        }
        return set;
    }

    private static final void $$robo$$android_net_wifi_WifiConfiguration$writeBitSet(Parcel dest, BitSet set) {
        int nextSetBit = -1;
        dest.writeInt(set.cardinality());
        while ((nextSetBit = set.nextSetBit(nextSetBit + 1)) != -1) {
            dest.writeInt(nextSetBit);
        }
    }

    private final int $$robo$$android_net_wifi_WifiConfiguration$getAuthType() {
        if (!this.isValid()) {
            throw new IllegalStateException("Invalid configuration");
        }
        if (this.allowedKeyManagement.get(1)) {
            return 1;
        }
        if (this.allowedKeyManagement.get(4)) {
            return 4;
        }
        if (this.allowedKeyManagement.get(2)) {
            return 2;
        }
        if (this.allowedKeyManagement.get(3)) {
            return 3;
        }
        return 0;
    }

    private final String $$robo$$android_net_wifi_WifiConfiguration$configKey(boolean allowCached) {
        String key;
        if (allowCached && this.mCachedConfigKey != null) {
            key = this.mCachedConfigKey;
        } else {
            key = this.allowedKeyManagement.get(1) ? this.SSID + KeyMgmt.strings[1] : (this.allowedKeyManagement.get(2) || this.allowedKeyManagement.get(3) ? this.SSID + KeyMgmt.strings[2] : (this.wepKeys[0] != null ? this.SSID + "WEP" : this.SSID + KeyMgmt.strings[0]));
            this.mCachedConfigKey = key;
        }
        return key;
    }

    private final String $$robo$$android_net_wifi_WifiConfiguration$configKey() {
        return this.configKey(false);
    }

    private static final String $$robo$$android_net_wifi_WifiConfiguration$configKey(ScanResult result) {
        String key = "\"" + result.SSID + "\"";
        if (result.capabilities.contains("WEP")) {
            key = key + "-WEP";
        }
        if (result.capabilities.contains("PSK")) {
            key = key + "-" + KeyMgmt.strings[1];
        }
        if (result.capabilities.contains("EAP")) {
            key = key + "-" + KeyMgmt.strings[2];
        }
        return key;
    }

    private final IpConfiguration $$robo$$android_net_wifi_WifiConfiguration$getIpConfiguration() {
        return this.mIpConfiguration;
    }

    private final void $$robo$$android_net_wifi_WifiConfiguration$setIpConfiguration(IpConfiguration ipConfiguration) {
        this.mIpConfiguration = ipConfiguration;
    }

    private final StaticIpConfiguration $$robo$$android_net_wifi_WifiConfiguration$getStaticIpConfiguration() {
        return this.mIpConfiguration.getStaticIpConfiguration();
    }

    private final void $$robo$$android_net_wifi_WifiConfiguration$setStaticIpConfiguration(StaticIpConfiguration staticIpConfiguration) {
        this.mIpConfiguration.setStaticIpConfiguration(staticIpConfiguration);
    }

    private final IpConfiguration.IpAssignment $$robo$$android_net_wifi_WifiConfiguration$getIpAssignment() {
        return this.mIpConfiguration.ipAssignment;
    }

    private final void $$robo$$android_net_wifi_WifiConfiguration$setIpAssignment(IpConfiguration.IpAssignment ipAssignment) {
        this.mIpConfiguration.ipAssignment = ipAssignment;
    }

    private final IpConfiguration.ProxySettings $$robo$$android_net_wifi_WifiConfiguration$getProxySettings() {
        return this.mIpConfiguration.proxySettings;
    }

    private final void $$robo$$android_net_wifi_WifiConfiguration$setProxySettings(IpConfiguration.ProxySettings proxySettings) {
        this.mIpConfiguration.proxySettings = proxySettings;
    }

    private final ProxyInfo $$robo$$android_net_wifi_WifiConfiguration$getHttpProxy() {
        return this.mIpConfiguration.httpProxy;
    }

    private final void $$robo$$android_net_wifi_WifiConfiguration$setHttpProxy(ProxyInfo httpProxy) {
        this.mIpConfiguration.httpProxy = httpProxy;
    }

    private final void $$robo$$android_net_wifi_WifiConfiguration$setProxy(IpConfiguration.ProxySettings settings, ProxyInfo proxy) {
        this.mIpConfiguration.proxySettings = settings;
        this.mIpConfiguration.httpProxy = proxy;
    }

    private final int $$robo$$android_net_wifi_WifiConfiguration$describeContents() {
        return 0;
    }

    private void $$robo$$android_net_wifi_WifiConfiguration$__constructor__(WifiConfiguration source) {
        if (source != null) {
            this.networkId = source.networkId;
            this.status = source.status;
            this.disableReason = source.disableReason;
            this.disableReason = source.disableReason;
            this.SSID = source.SSID;
            this.BSSID = source.BSSID;
            this.FQDN = source.FQDN;
            this.naiRealm = source.naiRealm;
            this.preSharedKey = source.preSharedKey;
            this.wepKeys = new String[4];
            for (int i = 0; i < this.wepKeys.length; ++i) {
                this.wepKeys[i] = source.wepKeys[i];
            }
            this.wepTxKeyIndex = source.wepTxKeyIndex;
            this.priority = source.priority;
            this.hiddenSSID = source.hiddenSSID;
            this.allowedKeyManagement = (BitSet)source.allowedKeyManagement.clone();
            this.allowedProtocols = (BitSet)source.allowedProtocols.clone();
            this.allowedAuthAlgorithms = (BitSet)source.allowedAuthAlgorithms.clone();
            this.allowedPairwiseCiphers = (BitSet)source.allowedPairwiseCiphers.clone();
            this.allowedGroupCiphers = (BitSet)source.allowedGroupCiphers.clone();
            this.enterpriseConfig = new WifiEnterpriseConfig(source.enterpriseConfig);
            this.defaultGwMacAddress = source.defaultGwMacAddress;
            this.mIpConfiguration = new IpConfiguration(source.mIpConfiguration);
            if (source.scanResultCache != null && source.scanResultCache.size() > 0) {
                this.scanResultCache = new HashMap();
                this.scanResultCache.putAll(source.scanResultCache);
            }
            if (source.connectChoices != null && source.connectChoices.size() > 0) {
                this.connectChoices = new HashMap();
                this.connectChoices.putAll(source.connectChoices);
            }
            if (source.linkedConfigurations != null && source.linkedConfigurations.size() > 0) {
                this.linkedConfigurations = new HashMap();
                this.linkedConfigurations.putAll(source.linkedConfigurations);
            }
            this.mCachedConfigKey = null;
            this.autoJoinStatus = source.autoJoinStatus;
            this.selfAdded = source.selfAdded;
            this.noInternetAccess = source.noInternetAccess;
            if (source.visibility != null) {
                this.visibility = new Visibility(this, source.visibility);
            }
            this.lastFailure = source.lastFailure;
            this.didSelfAdd = source.didSelfAdd;
            this.lastConnectUid = source.lastConnectUid;
            this.lastUpdateUid = source.lastUpdateUid;
            this.creatorUid = source.creatorUid;
            this.peerWifiConfiguration = source.peerWifiConfiguration;
            this.blackListTimestamp = source.blackListTimestamp;
            this.lastConnected = source.lastConnected;
            this.lastDisconnected = source.lastDisconnected;
            this.lastConnectionFailure = source.lastConnectionFailure;
            this.numConnectionFailures = source.numConnectionFailures;
            this.numIpConfigFailures = source.numIpConfigFailures;
            this.numAuthFailures = source.numAuthFailures;
            this.numScorerOverride = source.numScorerOverride;
            this.numScorerOverrideAndSwitchedNetwork = source.numScorerOverrideAndSwitchedNetwork;
            this.numAssociation = source.numAssociation;
            this.numUserTriggeredWifiDisableLowRSSI = source.numUserTriggeredWifiDisableLowRSSI;
            this.numUserTriggeredWifiDisableBadRSSI = source.numUserTriggeredWifiDisableBadRSSI;
            this.numUserTriggeredWifiDisableNotHighRSSI = source.numUserTriggeredWifiDisableNotHighRSSI;
            this.numTicksAtLowRSSI = source.numTicksAtLowRSSI;
            this.numTicksAtBadRSSI = source.numTicksAtBadRSSI;
            this.numTicksAtNotHighRSSI = source.numTicksAtNotHighRSSI;
            this.numUserTriggeredJoinAttempts = source.numUserTriggeredJoinAttempts;
            this.autoJoinBSSID = source.autoJoinBSSID;
            this.autoJoinUseAggressiveJoinAttemptThreshold = source.autoJoinUseAggressiveJoinAttemptThreshold;
            this.autoJoinBailedDueToLowRssi = source.autoJoinBailedDueToLowRssi;
            this.dirty = source.dirty;
        }
    }

    private final void $$robo$$android_net_wifi_WifiConfiguration$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.networkId);
        dest.writeInt(this.status);
        dest.writeInt(this.disableReason);
        dest.writeString(this.SSID);
        dest.writeString(this.BSSID);
        dest.writeString(this.autoJoinBSSID);
        dest.writeString(this.FQDN);
        dest.writeString(this.naiRealm);
        dest.writeString(this.preSharedKey);
        for (String wepKey : this.wepKeys) {
            dest.writeString(wepKey);
        }
        dest.writeInt(this.wepTxKeyIndex);
        dest.writeInt(this.priority);
        dest.writeInt(this.hiddenSSID ? 1 : 0);
        dest.writeInt(this.requirePMF ? 1 : 0);
        dest.writeString(this.updateIdentifier);
        WifiConfiguration.writeBitSet(dest, this.allowedKeyManagement);
        WifiConfiguration.writeBitSet(dest, this.allowedProtocols);
        WifiConfiguration.writeBitSet(dest, this.allowedAuthAlgorithms);
        WifiConfiguration.writeBitSet(dest, this.allowedPairwiseCiphers);
        WifiConfiguration.writeBitSet(dest, this.allowedGroupCiphers);
        dest.writeParcelable(this.enterpriseConfig, flags);
        dest.writeParcelable(this.mIpConfiguration, flags);
        dest.writeString(this.dhcpServer);
        dest.writeString(this.defaultGwMacAddress);
        dest.writeInt(this.autoJoinStatus);
        dest.writeInt(this.selfAdded ? 1 : 0);
        dest.writeInt(this.didSelfAdd ? 1 : 0);
        dest.writeInt(this.noInternetAccess ? 1 : 0);
        dest.writeInt(this.creatorUid);
        dest.writeInt(this.lastConnectUid);
        dest.writeInt(this.lastUpdateUid);
        dest.writeLong(this.blackListTimestamp);
        dest.writeLong(this.lastConnectionFailure);
        dest.writeInt(this.numConnectionFailures);
        dest.writeInt(this.numIpConfigFailures);
        dest.writeInt(this.numAuthFailures);
        dest.writeInt(this.numScorerOverride);
        dest.writeInt(this.numScorerOverrideAndSwitchedNetwork);
        dest.writeInt(this.numAssociation);
        dest.writeInt(this.numUserTriggeredWifiDisableLowRSSI);
        dest.writeInt(this.numUserTriggeredWifiDisableBadRSSI);
        dest.writeInt(this.numUserTriggeredWifiDisableNotHighRSSI);
        dest.writeInt(this.numTicksAtLowRSSI);
        dest.writeInt(this.numTicksAtBadRSSI);
        dest.writeInt(this.numTicksAtNotHighRSSI);
        dest.writeInt(this.numUserTriggeredJoinAttempts);
        dest.writeInt(this.autoJoinUseAggressiveJoinAttemptThreshold);
        dest.writeInt(this.autoJoinBailedDueToLowRssi ? 1 : 0);
    }

    static void __staticInitializer__() {
        wepKeyVarNames = new String[]{"wep_key0", "wep_key1", "wep_key2", "wep_key3"};
        INVALID_RSSI = -127;
        UNWANTED_BLACKLIST_SOFT_RSSI_24 = -80;
        UNWANTED_BLACKLIST_SOFT_RSSI_5 = -70;
        GOOD_RSSI_24 = -65;
        LOW_RSSI_24 = -77;
        BAD_RSSI_24 = -87;
        GOOD_RSSI_5 = -60;
        LOW_RSSI_5 = -72;
        BAD_RSSI_5 = -82;
        UNWANTED_BLACKLIST_SOFT_BUMP = 4;
        UNWANTED_BLACKLIST_HARD_BUMP = 8;
        UNBLACKLIST_THRESHOLD_24_SOFT = -77;
        UNBLACKLIST_THRESHOLD_24_HARD = -68;
        UNBLACKLIST_THRESHOLD_5_SOFT = -63;
        UNBLACKLIST_THRESHOLD_5_HARD = -56;
        INITIAL_AUTO_JOIN_ATTEMPT_MIN_24 = -80;
        INITIAL_AUTO_JOIN_ATTEMPT_MIN_5 = -70;
        A_BAND_PREFERENCE_RSSI_THRESHOLD = -65;
        G_BAND_PREFERENCE_RSSI_THRESHOLD = -75;
        HOME_NETWORK_RSSI_BOOST = 5;
        MAX_INITIAL_AUTO_JOIN_RSSI_BOOST = 8;
        CREATOR = new Parcelable.Creator<WifiConfiguration>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_wifi_WifiConfiguration_2$__constructor__() {
            }

            private final WifiConfiguration $$robo$$android_net_wifi_WifiConfiguration_2$createFromParcel(Parcel in) {
                WifiConfiguration config = new WifiConfiguration();
                config.networkId = in.readInt();
                config.status = in.readInt();
                config.disableReason = in.readInt();
                config.SSID = in.readString();
                config.BSSID = in.readString();
                config.autoJoinBSSID = in.readString();
                config.FQDN = in.readString();
                config.naiRealm = in.readString();
                config.preSharedKey = in.readString();
                for (int i = 0; i < config.wepKeys.length; ++i) {
                    config.wepKeys[i] = in.readString();
                }
                config.wepTxKeyIndex = in.readInt();
                config.priority = in.readInt();
                config.hiddenSSID = in.readInt() != 0;
                config.requirePMF = in.readInt() != 0;
                config.updateIdentifier = in.readString();
                config.allowedKeyManagement = WifiConfiguration.readBitSet(in);
                config.allowedProtocols = WifiConfiguration.readBitSet(in);
                config.allowedAuthAlgorithms = WifiConfiguration.readBitSet(in);
                config.allowedPairwiseCiphers = WifiConfiguration.readBitSet(in);
                config.allowedGroupCiphers = WifiConfiguration.readBitSet(in);
                config.enterpriseConfig = (WifiEnterpriseConfig)in.readParcelable(null);
                config.mIpConfiguration = (IpConfiguration)in.readParcelable(null);
                config.dhcpServer = in.readString();
                config.defaultGwMacAddress = in.readString();
                config.autoJoinStatus = in.readInt();
                config.selfAdded = in.readInt() != 0;
                config.didSelfAdd = in.readInt() != 0;
                config.noInternetAccess = in.readInt() != 0;
                config.creatorUid = in.readInt();
                config.lastConnectUid = in.readInt();
                config.lastUpdateUid = in.readInt();
                config.blackListTimestamp = in.readLong();
                config.lastConnectionFailure = in.readLong();
                config.numConnectionFailures = in.readInt();
                config.numIpConfigFailures = in.readInt();
                config.numAuthFailures = in.readInt();
                config.numScorerOverride = in.readInt();
                config.numScorerOverrideAndSwitchedNetwork = in.readInt();
                config.numAssociation = in.readInt();
                config.numUserTriggeredWifiDisableLowRSSI = in.readInt();
                config.numUserTriggeredWifiDisableBadRSSI = in.readInt();
                config.numUserTriggeredWifiDisableNotHighRSSI = in.readInt();
                config.numTicksAtLowRSSI = in.readInt();
                config.numTicksAtBadRSSI = in.readInt();
                config.numTicksAtNotHighRSSI = in.readInt();
                config.numUserTriggeredJoinAttempts = in.readInt();
                config.autoJoinUseAggressiveJoinAttemptThreshold = in.readInt();
                config.autoJoinBailedDueToLowRssi = in.readInt() != 0;
                return config;
            }

            private final WifiConfiguration[] $$robo$$android_net_wifi_WifiConfiguration_2$newArray(int size) {
                return new WifiConfiguration[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_wifi_WifiConfiguration_2$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiConfiguration_2$__constructor__(), 0, this);
            }

            @Override
            public WifiConfiguration createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_WifiConfiguration_2$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public WifiConfiguration[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_WifiConfiguration_2$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public Visibility setVisibility(long l) {
        return InvokeDynamicSupport.bootstrap("setVisibility", $$robo$$android_net_wifi_WifiConfiguration$setVisibility(long ), 0, this, l);
    }

    private void __constructor__() {
        this.$$robo$$android_net_wifi_WifiConfiguration$__constructor__();
    }

    public WifiConfiguration() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiConfiguration$__constructor__(), 0, this);
    }

    public boolean isValid() {
        return (boolean)InvokeDynamicSupport.bootstrap("isValid", $$robo$$android_net_wifi_WifiConfiguration$isValid(), 0, this);
    }

    public boolean isLinked(WifiConfiguration wifiConfiguration) {
        return (boolean)InvokeDynamicSupport.bootstrap("isLinked", $$robo$$android_net_wifi_WifiConfiguration$isLinked(android.net.wifi.WifiConfiguration ), 0, this, wifiConfiguration);
    }

    public ScanResult lastSeen() {
        return InvokeDynamicSupport.bootstrap("lastSeen", $$robo$$android_net_wifi_WifiConfiguration$lastSeen(), 0, this);
    }

    public void setAutoJoinStatus(int n) {
        InvokeDynamicSupport.bootstrap("setAutoJoinStatus", $$robo$$android_net_wifi_WifiConfiguration$setAutoJoinStatus(int ), 0, this, n);
    }

    private ArrayList<ScanResult> sortScanResults() {
        return InvokeDynamicSupport.bootstrap("sortScanResults", $$robo$$android_net_wifi_WifiConfiguration$sortScanResults(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_wifi_WifiConfiguration$toString(), 0, this);
    }

    public String getPrintableSsid() {
        return InvokeDynamicSupport.bootstrap("getPrintableSsid", $$robo$$android_net_wifi_WifiConfiguration$getPrintableSsid(), 0, this);
    }

    public String getKeyIdForCredentials(WifiConfiguration wifiConfiguration) {
        return InvokeDynamicSupport.bootstrap("getKeyIdForCredentials", $$robo$$android_net_wifi_WifiConfiguration$getKeyIdForCredentials(android.net.wifi.WifiConfiguration ), 0, this, wifiConfiguration);
    }

    private String trimStringForKeyId(String string2) {
        return InvokeDynamicSupport.bootstrap("trimStringForKeyId", $$robo$$android_net_wifi_WifiConfiguration$trimStringForKeyId(java.lang.String ), 0, this, string2);
    }

    private static BitSet readBitSet(Parcel parcel) {
        return InvokeDynamicSupport.bootstrapStatic("readBitSet", $$robo$$android_net_wifi_WifiConfiguration$readBitSet(android.os.Parcel ), 0, (Parcel)parcel);
    }

    private static void writeBitSet(Parcel parcel, BitSet bitSet) {
        InvokeDynamicSupport.bootstrapStatic("writeBitSet", $$robo$$android_net_wifi_WifiConfiguration$writeBitSet(android.os.Parcel java.util.BitSet ), 0, (Parcel)parcel, (BitSet)bitSet);
    }

    public int getAuthType() {
        return (int)InvokeDynamicSupport.bootstrap("getAuthType", $$robo$$android_net_wifi_WifiConfiguration$getAuthType(), 0, this);
    }

    public String configKey(boolean bl) {
        return InvokeDynamicSupport.bootstrap("configKey", $$robo$$android_net_wifi_WifiConfiguration$configKey(boolean ), 0, this, bl);
    }

    public String configKey() {
        return InvokeDynamicSupport.bootstrap("configKey", $$robo$$android_net_wifi_WifiConfiguration$configKey(), 0, this);
    }

    public static String configKey(ScanResult scanResult) {
        return InvokeDynamicSupport.bootstrapStatic("configKey", $$robo$$android_net_wifi_WifiConfiguration$configKey(android.net.wifi.ScanResult ), 0, (ScanResult)scanResult);
    }

    public IpConfiguration getIpConfiguration() {
        return InvokeDynamicSupport.bootstrap("getIpConfiguration", $$robo$$android_net_wifi_WifiConfiguration$getIpConfiguration(), 0, this);
    }

    public void setIpConfiguration(IpConfiguration ipConfiguration) {
        InvokeDynamicSupport.bootstrap("setIpConfiguration", $$robo$$android_net_wifi_WifiConfiguration$setIpConfiguration(android.net.IpConfiguration ), 0, this, ipConfiguration);
    }

    public StaticIpConfiguration getStaticIpConfiguration() {
        return InvokeDynamicSupport.bootstrap("getStaticIpConfiguration", $$robo$$android_net_wifi_WifiConfiguration$getStaticIpConfiguration(), 0, this);
    }

    public void setStaticIpConfiguration(StaticIpConfiguration staticIpConfiguration) {
        InvokeDynamicSupport.bootstrap("setStaticIpConfiguration", $$robo$$android_net_wifi_WifiConfiguration$setStaticIpConfiguration(android.net.StaticIpConfiguration ), 0, this, staticIpConfiguration);
    }

    public IpConfiguration.IpAssignment getIpAssignment() {
        return InvokeDynamicSupport.bootstrap("getIpAssignment", $$robo$$android_net_wifi_WifiConfiguration$getIpAssignment(), 0, this);
    }

    public void setIpAssignment(IpConfiguration.IpAssignment ipAssignment) {
        InvokeDynamicSupport.bootstrap("setIpAssignment", $$robo$$android_net_wifi_WifiConfiguration$setIpAssignment(android.net.IpConfiguration$IpAssignment ), 0, this, ipAssignment);
    }

    public IpConfiguration.ProxySettings getProxySettings() {
        return InvokeDynamicSupport.bootstrap("getProxySettings", $$robo$$android_net_wifi_WifiConfiguration$getProxySettings(), 0, this);
    }

    public void setProxySettings(IpConfiguration.ProxySettings proxySettings) {
        InvokeDynamicSupport.bootstrap("setProxySettings", $$robo$$android_net_wifi_WifiConfiguration$setProxySettings(android.net.IpConfiguration$ProxySettings ), 0, this, proxySettings);
    }

    public ProxyInfo getHttpProxy() {
        return InvokeDynamicSupport.bootstrap("getHttpProxy", $$robo$$android_net_wifi_WifiConfiguration$getHttpProxy(), 0, this);
    }

    public void setHttpProxy(ProxyInfo proxyInfo) {
        InvokeDynamicSupport.bootstrap("setHttpProxy", $$robo$$android_net_wifi_WifiConfiguration$setHttpProxy(android.net.ProxyInfo ), 0, this, proxyInfo);
    }

    public void setProxy(IpConfiguration.ProxySettings proxySettings, ProxyInfo proxyInfo) {
        InvokeDynamicSupport.bootstrap("setProxy", $$robo$$android_net_wifi_WifiConfiguration$setProxy(android.net.IpConfiguration$ProxySettings android.net.ProxyInfo ), 0, this, proxySettings, proxyInfo);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_WifiConfiguration$describeContents(), 0, this);
    }

    private void __constructor__(WifiConfiguration wifiConfiguration) {
        this.$$robo$$android_net_wifi_WifiConfiguration$__constructor__(wifiConfiguration);
    }

    public WifiConfiguration(WifiConfiguration wifiConfiguration) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiConfiguration$__constructor__(android.net.wifi.WifiConfiguration ), 0, this, wifiConfiguration);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_WifiConfiguration$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    static {
        RobolectricInternals.classInitializing(WifiConfiguration.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WifiConfiguration)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public final class Visibility
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int rssi5;
        public int rssi24;
        public int num5;
        public int num24;
        public long age5;
        public long age24;
        public String BSSID24;
        public String BSSID5;
        /* synthetic */ WifiConfiguration this$0;

        private void $$robo$$android_net_wifi_WifiConfiguration_Visibility$__constructor__(WifiConfiguration wifiConfiguration) {
            this.rssi5 = INVALID_RSSI;
            this.rssi24 = INVALID_RSSI;
        }

        private void $$robo$$android_net_wifi_WifiConfiguration_Visibility$__constructor__(WifiConfiguration wifiConfiguration, Visibility source) {
            this.rssi5 = source.rssi5;
            this.rssi24 = source.rssi24;
            this.age24 = source.age24;
            this.age5 = source.age5;
            this.num24 = source.num24;
            this.num5 = source.num5;
            this.BSSID5 = source.BSSID5;
            this.BSSID24 = source.BSSID24;
        }

        private final String $$robo$$android_net_wifi_WifiConfiguration_Visibility$toString() {
            StringBuilder sbuf = new StringBuilder();
            sbuf.append("[");
            if (this.rssi24 > INVALID_RSSI) {
                sbuf.append(Integer.toString(this.rssi24));
                sbuf.append(",");
                sbuf.append(Integer.toString(this.num24));
                if (this.BSSID24 != null) {
                    sbuf.append(",").append(this.BSSID24);
                }
            } else {
                sbuf.append("*");
            }
            sbuf.append(" - ");
            if (this.rssi5 > INVALID_RSSI) {
                sbuf.append(Integer.toString(this.rssi5));
                sbuf.append(",");
                sbuf.append(Integer.toString(this.num5));
                if (this.BSSID5 != null) {
                    sbuf.append(",").append(this.BSSID5);
                }
            }
            sbuf.append("]");
            return sbuf.toString();
        }

        private void __constructor__(WifiConfiguration wifiConfiguration) {
            this.$$robo$$android_net_wifi_WifiConfiguration_Visibility$__constructor__(wifiConfiguration);
        }

        public Visibility(WifiConfiguration wifiConfiguration) {
            this.this$0 = wifiConfiguration;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiConfiguration_Visibility$__constructor__(android.net.wifi.WifiConfiguration ), 0, this, wifiConfiguration);
        }

        private void __constructor__(WifiConfiguration wifiConfiguration, Visibility visibility) {
            this.$$robo$$android_net_wifi_WifiConfiguration_Visibility$__constructor__(wifiConfiguration, visibility);
        }

        public Visibility(WifiConfiguration wifiConfiguration, Visibility visibility) {
            this.this$0 = wifiConfiguration;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiConfiguration_Visibility$__constructor__(android.net.wifi.WifiConfiguration android.net.wifi.WifiConfiguration$Visibility ), 0, this, wifiConfiguration, visibility);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_wifi_WifiConfiguration_Visibility$toString(), 0, this);
        }

        public /* synthetic */ Visibility() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Visibility)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Status
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int CURRENT = 0;
        public static int DISABLED = 1;
        public static int ENABLED = 2;
        public static String[] strings;

        private void $$robo$$android_net_wifi_WifiConfiguration_Status$__constructor__() {
        }

        static void __staticInitializer__() {
            strings = new String[]{"current", "disabled", "enabled"};
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_WifiConfiguration_Status$__constructor__();
        }

        private Status() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiConfiguration_Status$__constructor__(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(Status.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Status)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class GroupCipher
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int WEP40 = 0;
        public static int WEP104 = 1;
        public static int TKIP = 2;
        public static int CCMP = 3;
        public static String varName = "group";
        public static String[] strings;

        private void $$robo$$android_net_wifi_WifiConfiguration_GroupCipher$__constructor__() {
        }

        static void __staticInitializer__() {
            strings = new String[]{"WEP40", "WEP104", "TKIP", "CCMP"};
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_WifiConfiguration_GroupCipher$__constructor__();
        }

        private GroupCipher() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiConfiguration_GroupCipher$__constructor__(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(GroupCipher.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GroupCipher)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class PairwiseCipher
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int NONE = 0;
        public static int TKIP = 1;
        public static int CCMP = 2;
        public static String varName = "pairwise";
        public static String[] strings;

        private void $$robo$$android_net_wifi_WifiConfiguration_PairwiseCipher$__constructor__() {
        }

        static void __staticInitializer__() {
            strings = new String[]{"NONE", "TKIP", "CCMP"};
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_WifiConfiguration_PairwiseCipher$__constructor__();
        }

        private PairwiseCipher() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiConfiguration_PairwiseCipher$__constructor__(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(PairwiseCipher.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PairwiseCipher)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class AuthAlgorithm
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int OPEN = 0;
        public static int SHARED = 1;
        public static int LEAP = 2;
        public static String varName = "auth_alg";
        public static String[] strings;

        private void $$robo$$android_net_wifi_WifiConfiguration_AuthAlgorithm$__constructor__() {
        }

        static void __staticInitializer__() {
            strings = new String[]{"OPEN", "SHARED", "LEAP"};
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_WifiConfiguration_AuthAlgorithm$__constructor__();
        }

        private AuthAlgorithm() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiConfiguration_AuthAlgorithm$__constructor__(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(AuthAlgorithm.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AuthAlgorithm)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Protocol
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int WPA = 0;
        public static int RSN = 1;
        public static String varName = "proto";
        public static String[] strings;

        private void $$robo$$android_net_wifi_WifiConfiguration_Protocol$__constructor__() {
        }

        static void __staticInitializer__() {
            strings = new String[]{"WPA", "RSN"};
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_WifiConfiguration_Protocol$__constructor__();
        }

        private Protocol() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiConfiguration_Protocol$__constructor__(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(Protocol.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Protocol)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class KeyMgmt
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int NONE = 0;
        public static int WPA_PSK = 1;
        public static int WPA_EAP = 2;
        public static int IEEE8021X = 3;
        public static int WPA2_PSK = 4;
        public static String varName = "key_mgmt";
        public static String[] strings;

        private void $$robo$$android_net_wifi_WifiConfiguration_KeyMgmt$__constructor__() {
        }

        static void __staticInitializer__() {
            strings = new String[]{"NONE", "WPA_PSK", "WPA_EAP", "IEEE8021X", "WPA2_PSK"};
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_WifiConfiguration_KeyMgmt$__constructor__();
        }

        private KeyMgmt() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiConfiguration_KeyMgmt$__constructor__(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(KeyMgmt.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeyMgmt)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

