/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.io.ByteArrayInputStream;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WifiEnterpriseConfig
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String EMPTY_VALUE = "NULL";
    public static String EAP_KEY = "eap";
    public static String PHASE2_KEY = "phase2";
    public static String IDENTITY_KEY = "identity";
    public static String ANON_IDENTITY_KEY = "anonymous_identity";
    public static String PASSWORD_KEY = "password";
    public static String SUBJECT_MATCH_KEY = "subject_match";
    public static String OPP_KEY_CACHING = "proactive_key_caching";
    public static String ENGINE_ID_KEYSTORE = "keystore";
    public static String KEYSTORE_URI = "keystore://";
    public static String ENGINE_ENABLE = "1";
    public static String ENGINE_DISABLE = "0";
    public static String CA_CERT_PREFIX = "keystore://CACERT_";
    public static String CLIENT_CERT_PREFIX = "keystore://USRCERT_";
    public static String CLIENT_CERT_KEY = "client_cert";
    public static String CA_CERT_KEY = "ca_cert";
    public static String ENGINE_KEY = "engine";
    public static String ENGINE_ID_KEY = "engine_id";
    public static String PRIVATE_KEY_ID_KEY = "key_id";
    private HashMap<String, String> mFields;
    private X509Certificate mCaCert;
    private PrivateKey mClientPrivateKey;
    private X509Certificate mClientCertificate;
    public static Parcelable.Creator<WifiEnterpriseConfig> CREATOR;

    private void $$robo$$android_net_wifi_WifiEnterpriseConfig$__constructor__() {
        this.mFields = new HashMap();
    }

    private void $$robo$$android_net_wifi_WifiEnterpriseConfig$__constructor__(WifiEnterpriseConfig source) {
        this.mFields = new HashMap();
        for (String key : source.mFields.keySet()) {
            this.mFields.put(key, source.mFields.get(key));
        }
    }

    private final int $$robo$$android_net_wifi_WifiEnterpriseConfig$describeContents() {
        return 0;
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mFields.size());
        for (Map.Entry<String, String> entry : this.mFields.entrySet()) {
            dest.writeString(entry.getKey());
            dest.writeString(entry.getValue());
        }
        this.writeCertificate(dest, this.mCaCert);
        if (this.mClientPrivateKey != null) {
            String algorithm = this.mClientPrivateKey.getAlgorithm();
            byte[] userKeyBytes = this.mClientPrivateKey.getEncoded();
            dest.writeInt(userKeyBytes.length);
            dest.writeByteArray(userKeyBytes);
            dest.writeString(algorithm);
        } else {
            dest.writeInt(0);
        }
        this.writeCertificate(dest, this.mClientCertificate);
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$writeCertificate(Parcel dest, X509Certificate cert) {
        if (cert != null) {
            try {
                byte[] certBytes = cert.getEncoded();
                dest.writeInt(certBytes.length);
                dest.writeByteArray(certBytes);
            }
            catch (CertificateEncodingException e) {
                dest.writeInt(0);
            }
        } else {
            dest.writeInt(0);
        }
    }

    private final HashMap<String, String> $$robo$$android_net_wifi_WifiEnterpriseConfig$getFields() {
        return this.mFields;
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$setEapMethod(int eapMethod) {
        switch (eapMethod) {
            case 1: {
                this.setPhase2Method(0);
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.mFields.put("eap", Eap.strings[eapMethod]);
                this.mFields.put("proactive_key_caching", "1");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown EAP method");
            }
        }
    }

    private final int $$robo$$android_net_wifi_WifiEnterpriseConfig$getEapMethod() {
        String eapMethod = this.mFields.get("eap");
        return this.getStringIndex(Eap.strings, eapMethod, -1);
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$setPhase2Method(int phase2Method) {
        switch (phase2Method) {
            case 0: {
                this.mFields.put("phase2", "NULL");
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.mFields.put("phase2", this.convertToQuotedString("auth=" + Phase2.strings[phase2Method]));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Phase 2 method");
            }
        }
    }

    private final int $$robo$$android_net_wifi_WifiEnterpriseConfig$getPhase2Method() {
        String phase2Method = this.removeDoubleQuotes(this.mFields.get("phase2"));
        if (phase2Method.startsWith("auth=")) {
            phase2Method = phase2Method.substring("auth=".length());
        }
        return this.getStringIndex(Phase2.strings, phase2Method, 0);
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$setIdentity(String identity) {
        this.setFieldValue("identity", identity, "");
    }

    private final String $$robo$$android_net_wifi_WifiEnterpriseConfig$getIdentity() {
        return this.getFieldValue("identity", "");
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$setAnonymousIdentity(String anonymousIdentity) {
        this.setFieldValue("anonymous_identity", anonymousIdentity, "");
    }

    private final String $$robo$$android_net_wifi_WifiEnterpriseConfig$getAnonymousIdentity() {
        return this.getFieldValue("anonymous_identity", "");
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$setPassword(String password) {
        this.setFieldValue("password", password, "");
    }

    private final String $$robo$$android_net_wifi_WifiEnterpriseConfig$getPassword() {
        return this.getFieldValue("password", "");
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$setCaCertificateAlias(String alias) {
        this.setFieldValue("ca_cert", alias, "keystore://CACERT_");
    }

    private final String $$robo$$android_net_wifi_WifiEnterpriseConfig$getCaCertificateAlias() {
        return this.getFieldValue("ca_cert", "keystore://CACERT_");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$setCaCertificate(X509Certificate cert) {
        if (cert != null) {
            if (cert.getBasicConstraints() < 0) throw new IllegalArgumentException("Not a CA certificate");
            this.mCaCert = cert;
            return;
        } else {
            this.mCaCert = null;
        }
    }

    private final X509Certificate $$robo$$android_net_wifi_WifiEnterpriseConfig$getCaCertificate() {
        return this.mCaCert;
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$resetCaCertificate() {
        this.mCaCert = null;
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$setClientCertificateAlias(String alias) {
        this.setFieldValue("client_cert", alias, "keystore://USRCERT_");
        this.setFieldValue("key_id", alias, "USRPKEY_");
        if (TextUtils.isEmpty(alias)) {
            this.mFields.put("engine", "0");
            this.mFields.put("engine_id", "NULL");
        } else {
            this.mFields.put("engine", "1");
            this.mFields.put("engine_id", this.convertToQuotedString("keystore"));
        }
    }

    private final String $$robo$$android_net_wifi_WifiEnterpriseConfig$getClientCertificateAlias() {
        return this.getFieldValue("client_cert", "keystore://USRCERT_");
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$setClientKeyEntry(PrivateKey privateKey, X509Certificate clientCertificate) {
        if (clientCertificate != null) {
            if (clientCertificate.getBasicConstraints() != -1) {
                throw new IllegalArgumentException("Cannot be a CA certificate");
            }
            if (privateKey == null) {
                throw new IllegalArgumentException("Client cert without a private key");
            }
            if (privateKey.getEncoded() == null) {
                throw new IllegalArgumentException("Private key cannot be encoded");
            }
        }
        this.mClientPrivateKey = privateKey;
        this.mClientCertificate = clientCertificate;
    }

    private final X509Certificate $$robo$$android_net_wifi_WifiEnterpriseConfig$getClientCertificate() {
        return this.mClientCertificate;
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$resetClientKeyEntry() {
        this.mClientPrivateKey = null;
        this.mClientCertificate = null;
    }

    private final PrivateKey $$robo$$android_net_wifi_WifiEnterpriseConfig$getClientPrivateKey() {
        return this.mClientPrivateKey;
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$setSubjectMatch(String subjectMatch) {
        this.setFieldValue("subject_match", subjectMatch, "");
    }

    private final String $$robo$$android_net_wifi_WifiEnterpriseConfig$getSubjectMatch() {
        return this.getFieldValue("subject_match", "");
    }

    private final String $$robo$$android_net_wifi_WifiEnterpriseConfig$getKeyId(WifiEnterpriseConfig current) {
        String eap = this.mFields.get("eap");
        String phase2 = this.mFields.get("phase2");
        if (TextUtils.isEmpty(eap)) {
            eap = current.mFields.get("eap");
        }
        if (TextUtils.isEmpty(phase2)) {
            phase2 = current.mFields.get("phase2");
        }
        return eap + "_" + phase2;
    }

    private final String $$robo$$android_net_wifi_WifiEnterpriseConfig$removeDoubleQuotes(String string2) {
        if (TextUtils.isEmpty(string2)) {
            return "";
        }
        int length = string2.length();
        if (length > 1 && string2.charAt(0) == '\"' && string2.charAt(length - 1) == '\"') {
            return string2.substring(1, length - 1);
        }
        return string2;
    }

    private final String $$robo$$android_net_wifi_WifiEnterpriseConfig$convertToQuotedString(String string2) {
        return "\"" + string2 + "\"";
    }

    private final int $$robo$$android_net_wifi_WifiEnterpriseConfig$getStringIndex(String[] arr, String toBeFound, int defaultIndex) {
        if (TextUtils.isEmpty(toBeFound)) {
            return defaultIndex;
        }
        for (int i = 0; i < arr.length; ++i) {
            if (!toBeFound.equals(arr[i])) continue;
            return i;
        }
        return defaultIndex;
    }

    private final String $$robo$$android_net_wifi_WifiEnterpriseConfig$getFieldValue(String key, String prefix) {
        String value = this.mFields.get(key);
        if (TextUtils.isEmpty(value) || "NULL".equals(value)) {
            return "";
        }
        if ((value = this.removeDoubleQuotes(value)).startsWith(prefix)) {
            return value.substring(prefix.length());
        }
        return value;
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$setFieldValue(String key, String value, String prefix) {
        if (TextUtils.isEmpty(value)) {
            this.mFields.put(key, "NULL");
        } else {
            this.mFields.put(key, this.convertToQuotedString(prefix + value));
        }
    }

    private final void $$robo$$android_net_wifi_WifiEnterpriseConfig$setFieldValue(String key, String value) {
        if (TextUtils.isEmpty(value)) {
            this.mFields.put(key, "NULL");
        } else {
            this.mFields.put(key, this.convertToQuotedString(value));
        }
    }

    private final String $$robo$$android_net_wifi_WifiEnterpriseConfig$toString() {
        StringBuffer sb = new StringBuffer();
        for (String key : this.mFields.keySet()) {
            sb.append(key).append(" ").append(this.mFields.get(key)).append("\n");
        }
        return sb.toString();
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<WifiEnterpriseConfig>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_wifi_WifiEnterpriseConfig_1$__constructor__() {
            }

            private final WifiEnterpriseConfig $$robo$$android_net_wifi_WifiEnterpriseConfig_1$createFromParcel(Parcel in) {
                WifiEnterpriseConfig enterpriseConfig = new WifiEnterpriseConfig();
                int count = in.readInt();
                for (int i = 0; i < count; ++i) {
                    String key = in.readString();
                    String value = in.readString();
                    enterpriseConfig.mFields.put(key, value);
                }
                enterpriseConfig.mCaCert = this.readCertificate(in);
                PrivateKey userKey = null;
                int len = in.readInt();
                if (len > 0) {
                    try {
                        byte[] bytes = new byte[len];
                        in.readByteArray(bytes);
                        String algorithm = in.readString();
                        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
                        userKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(bytes));
                    }
                    catch (NoSuchAlgorithmException e) {
                        userKey = null;
                    }
                    catch (InvalidKeySpecException e) {
                        userKey = null;
                    }
                }
                enterpriseConfig.mClientPrivateKey = userKey;
                enterpriseConfig.mClientCertificate = this.readCertificate(in);
                return enterpriseConfig;
            }

            private final X509Certificate $$robo$$android_net_wifi_WifiEnterpriseConfig_1$readCertificate(Parcel in) {
                X509Certificate cert = null;
                int len = in.readInt();
                if (len > 0) {
                    try {
                        byte[] bytes = new byte[len];
                        in.readByteArray(bytes);
                        CertificateFactory cFactory = CertificateFactory.getInstance("X.509");
                        cert = (X509Certificate)cFactory.generateCertificate(new ByteArrayInputStream(bytes));
                    }
                    catch (CertificateException e) {
                        cert = null;
                    }
                }
                return cert;
            }

            private final WifiEnterpriseConfig[] $$robo$$android_net_wifi_WifiEnterpriseConfig_1$newArray(int size) {
                return new WifiEnterpriseConfig[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_wifi_WifiEnterpriseConfig_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiEnterpriseConfig_1$__constructor__(), 0, this);
            }

            @Override
            public WifiEnterpriseConfig createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_WifiEnterpriseConfig_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            private X509Certificate readCertificate(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("readCertificate", $$robo$$android_net_wifi_WifiEnterpriseConfig_1$readCertificate(android.os.Parcel ), 0, this, parcel);
            }

            public WifiEnterpriseConfig[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_WifiEnterpriseConfig_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_net_wifi_WifiEnterpriseConfig$__constructor__();
    }

    public WifiEnterpriseConfig() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiEnterpriseConfig$__constructor__(), 0, this);
    }

    private void __constructor__(WifiEnterpriseConfig wifiEnterpriseConfig) {
        this.$$robo$$android_net_wifi_WifiEnterpriseConfig$__constructor__(wifiEnterpriseConfig);
    }

    public WifiEnterpriseConfig(WifiEnterpriseConfig wifiEnterpriseConfig) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiEnterpriseConfig$__constructor__(android.net.wifi.WifiEnterpriseConfig ), 0, this, wifiEnterpriseConfig);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_WifiEnterpriseConfig$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_WifiEnterpriseConfig$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    private void writeCertificate(Parcel parcel, X509Certificate x509Certificate) {
        InvokeDynamicSupport.bootstrap("writeCertificate", $$robo$$android_net_wifi_WifiEnterpriseConfig$writeCertificate(android.os.Parcel java.security.cert.X509Certificate ), 0, this, parcel, x509Certificate);
    }

    public HashMap<String, String> getFields() {
        return InvokeDynamicSupport.bootstrap("getFields", $$robo$$android_net_wifi_WifiEnterpriseConfig$getFields(), 0, this);
    }

    public void setEapMethod(int n) {
        InvokeDynamicSupport.bootstrap("setEapMethod", $$robo$$android_net_wifi_WifiEnterpriseConfig$setEapMethod(int ), 0, this, n);
    }

    public int getEapMethod() {
        return (int)InvokeDynamicSupport.bootstrap("getEapMethod", $$robo$$android_net_wifi_WifiEnterpriseConfig$getEapMethod(), 0, this);
    }

    public void setPhase2Method(int n) {
        InvokeDynamicSupport.bootstrap("setPhase2Method", $$robo$$android_net_wifi_WifiEnterpriseConfig$setPhase2Method(int ), 0, this, n);
    }

    public int getPhase2Method() {
        return (int)InvokeDynamicSupport.bootstrap("getPhase2Method", $$robo$$android_net_wifi_WifiEnterpriseConfig$getPhase2Method(), 0, this);
    }

    public void setIdentity(String string2) {
        InvokeDynamicSupport.bootstrap("setIdentity", $$robo$$android_net_wifi_WifiEnterpriseConfig$setIdentity(java.lang.String ), 0, this, string2);
    }

    public String getIdentity() {
        return InvokeDynamicSupport.bootstrap("getIdentity", $$robo$$android_net_wifi_WifiEnterpriseConfig$getIdentity(), 0, this);
    }

    public void setAnonymousIdentity(String string2) {
        InvokeDynamicSupport.bootstrap("setAnonymousIdentity", $$robo$$android_net_wifi_WifiEnterpriseConfig$setAnonymousIdentity(java.lang.String ), 0, this, string2);
    }

    public String getAnonymousIdentity() {
        return InvokeDynamicSupport.bootstrap("getAnonymousIdentity", $$robo$$android_net_wifi_WifiEnterpriseConfig$getAnonymousIdentity(), 0, this);
    }

    public void setPassword(String string2) {
        InvokeDynamicSupport.bootstrap("setPassword", $$robo$$android_net_wifi_WifiEnterpriseConfig$setPassword(java.lang.String ), 0, this, string2);
    }

    public String getPassword() {
        return InvokeDynamicSupport.bootstrap("getPassword", $$robo$$android_net_wifi_WifiEnterpriseConfig$getPassword(), 0, this);
    }

    public void setCaCertificateAlias(String string2) {
        InvokeDynamicSupport.bootstrap("setCaCertificateAlias", $$robo$$android_net_wifi_WifiEnterpriseConfig$setCaCertificateAlias(java.lang.String ), 0, this, string2);
    }

    public String getCaCertificateAlias() {
        return InvokeDynamicSupport.bootstrap("getCaCertificateAlias", $$robo$$android_net_wifi_WifiEnterpriseConfig$getCaCertificateAlias(), 0, this);
    }

    public void setCaCertificate(X509Certificate x509Certificate) {
        InvokeDynamicSupport.bootstrap("setCaCertificate", $$robo$$android_net_wifi_WifiEnterpriseConfig$setCaCertificate(java.security.cert.X509Certificate ), 0, this, x509Certificate);
    }

    public X509Certificate getCaCertificate() {
        return InvokeDynamicSupport.bootstrap("getCaCertificate", $$robo$$android_net_wifi_WifiEnterpriseConfig$getCaCertificate(), 0, this);
    }

    public void resetCaCertificate() {
        InvokeDynamicSupport.bootstrap("resetCaCertificate", $$robo$$android_net_wifi_WifiEnterpriseConfig$resetCaCertificate(), 0, this);
    }

    public void setClientCertificateAlias(String string2) {
        InvokeDynamicSupport.bootstrap("setClientCertificateAlias", $$robo$$android_net_wifi_WifiEnterpriseConfig$setClientCertificateAlias(java.lang.String ), 0, this, string2);
    }

    public String getClientCertificateAlias() {
        return InvokeDynamicSupport.bootstrap("getClientCertificateAlias", $$robo$$android_net_wifi_WifiEnterpriseConfig$getClientCertificateAlias(), 0, this);
    }

    public void setClientKeyEntry(PrivateKey privateKey, X509Certificate x509Certificate) {
        InvokeDynamicSupport.bootstrap("setClientKeyEntry", $$robo$$android_net_wifi_WifiEnterpriseConfig$setClientKeyEntry(java.security.PrivateKey java.security.cert.X509Certificate ), 0, this, privateKey, x509Certificate);
    }

    public X509Certificate getClientCertificate() {
        return InvokeDynamicSupport.bootstrap("getClientCertificate", $$robo$$android_net_wifi_WifiEnterpriseConfig$getClientCertificate(), 0, this);
    }

    public void resetClientKeyEntry() {
        InvokeDynamicSupport.bootstrap("resetClientKeyEntry", $$robo$$android_net_wifi_WifiEnterpriseConfig$resetClientKeyEntry(), 0, this);
    }

    public PrivateKey getClientPrivateKey() {
        return InvokeDynamicSupport.bootstrap("getClientPrivateKey", $$robo$$android_net_wifi_WifiEnterpriseConfig$getClientPrivateKey(), 0, this);
    }

    public void setSubjectMatch(String string2) {
        InvokeDynamicSupport.bootstrap("setSubjectMatch", $$robo$$android_net_wifi_WifiEnterpriseConfig$setSubjectMatch(java.lang.String ), 0, this, string2);
    }

    public String getSubjectMatch() {
        return InvokeDynamicSupport.bootstrap("getSubjectMatch", $$robo$$android_net_wifi_WifiEnterpriseConfig$getSubjectMatch(), 0, this);
    }

    String getKeyId(WifiEnterpriseConfig wifiEnterpriseConfig) {
        return InvokeDynamicSupport.bootstrap("getKeyId", $$robo$$android_net_wifi_WifiEnterpriseConfig$getKeyId(android.net.wifi.WifiEnterpriseConfig ), 0, this, wifiEnterpriseConfig);
    }

    private String removeDoubleQuotes(String string2) {
        return InvokeDynamicSupport.bootstrap("removeDoubleQuotes", $$robo$$android_net_wifi_WifiEnterpriseConfig$removeDoubleQuotes(java.lang.String ), 0, this, string2);
    }

    private String convertToQuotedString(String string2) {
        return InvokeDynamicSupport.bootstrap("convertToQuotedString", $$robo$$android_net_wifi_WifiEnterpriseConfig$convertToQuotedString(java.lang.String ), 0, this, string2);
    }

    private int getStringIndex(String[] stringArray, String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getStringIndex", $$robo$$android_net_wifi_WifiEnterpriseConfig$getStringIndex(java.lang.String[] java.lang.String int ), 0, this, stringArray, string2, n);
    }

    public String getFieldValue(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("getFieldValue", $$robo$$android_net_wifi_WifiEnterpriseConfig$getFieldValue(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public void setFieldValue(String string2, String string3, String string4) {
        InvokeDynamicSupport.bootstrap("setFieldValue", $$robo$$android_net_wifi_WifiEnterpriseConfig$setFieldValue(java.lang.String java.lang.String java.lang.String ), 0, this, string2, string3, string4);
    }

    public void setFieldValue(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setFieldValue", $$robo$$android_net_wifi_WifiEnterpriseConfig$setFieldValue(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_wifi_WifiEnterpriseConfig$toString(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(WifiEnterpriseConfig.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WifiEnterpriseConfig)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Phase2
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int NONE = 0;
        public static int PAP = 1;
        public static int MSCHAP = 2;
        public static int MSCHAPV2 = 3;
        public static int GTC = 4;
        private static String PREFIX = "auth=";
        public static String[] strings;

        private void $$robo$$android_net_wifi_WifiEnterpriseConfig_Phase2$__constructor__() {
        }

        static void __staticInitializer__() {
            strings = new String[]{"NULL", "PAP", "MSCHAP", "MSCHAPV2", "GTC"};
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_WifiEnterpriseConfig_Phase2$__constructor__();
        }

        private Phase2() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiEnterpriseConfig_Phase2$__constructor__(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(Phase2.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Phase2)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Eap
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int NONE = -1;
        public static int PEAP = 0;
        public static int TLS = 1;
        public static int TTLS = 2;
        public static int PWD = 3;
        public static int SIM = 4;
        public static int AKA = 5;
        public static String[] strings;

        private void $$robo$$android_net_wifi_WifiEnterpriseConfig_Eap$__constructor__() {
        }

        static void __staticInitializer__() {
            strings = new String[]{"PEAP", "TLS", "TTLS", "PWD", "SIM", "AKA"};
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_WifiEnterpriseConfig_Eap$__constructor__();
        }

        private Eap() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiEnterpriseConfig_Eap$__constructor__(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(Eap.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Eap)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

