/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.content.Context;
import android.net.wifi.IWifiScanner;
import android.net.wifi.ScanResult;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.util.AsyncChannel;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WifiScanner
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int WIFI_BAND_UNSPECIFIED = 0;
    public static int WIFI_BAND_24_GHZ = 1;
    public static int WIFI_BAND_5_GHZ = 2;
    public static int WIFI_BAND_5_GHZ_DFS_ONLY = 4;
    public static int WIFI_BAND_5_GHZ_WITH_DFS = 6;
    public static int WIFI_BAND_BOTH = 3;
    public static int WIFI_BAND_BOTH_WITH_DFS = 7;
    public static int MIN_SCAN_PERIOD_MS = 1000;
    public static int MAX_SCAN_PERIOD_MS = 1024000;
    public static int REASON_SUCCEEDED = 0;
    public static int REASON_UNSPECIFIED = -1;
    public static int REASON_INVALID_LISTENER = -2;
    public static int REASON_INVALID_REQUEST = -3;
    public static int REASON_NOT_AUTHORIZED = -4;
    public static String GET_AVAILABLE_CHANNELS_EXTRA = "Channels";
    public static int REPORT_EVENT_AFTER_BUFFER_FULL = 0;
    public static int REPORT_EVENT_AFTER_EACH_SCAN = 1;
    public static int REPORT_EVENT_FULL_SCAN_RESULT = 2;
    private static String TAG = "WifiScanner";
    private static boolean DBG = true;
    private static int BASE = 159744;
    public static int CMD_SCAN = 159744;
    public static int CMD_START_BACKGROUND_SCAN = 159746;
    public static int CMD_STOP_BACKGROUND_SCAN = 159747;
    public static int CMD_GET_SCAN_RESULTS = 159748;
    public static int CMD_SCAN_RESULT = 159749;
    public static int CMD_SET_HOTLIST = 159750;
    public static int CMD_RESET_HOTLIST = 159751;
    public static int CMD_AP_FOUND = 159753;
    public static int CMD_AP_LOST = 159754;
    public static int CMD_START_TRACKING_CHANGE = 159755;
    public static int CMD_STOP_TRACKING_CHANGE = 159756;
    public static int CMD_CONFIGURE_WIFI_CHANGE = 159757;
    public static int CMD_WIFI_CHANGE_DETECTED = 159759;
    public static int CMD_WIFI_CHANGES_STABILIZED = 159760;
    public static int CMD_OP_SUCCEEDED = 159761;
    public static int CMD_OP_FAILED = 159762;
    public static int CMD_PERIOD_CHANGED = 159763;
    public static int CMD_FULL_SCAN_RESULT = 159764;
    private Context mContext;
    private IWifiScanner mService;
    private static int INVALID_KEY = 0;
    private static int sListenerKey;
    private static SparseArray sListenerMap;
    private static Object sListenerMapLock;
    private static AsyncChannel sAsyncChannel;
    private static CountDownLatch sConnected;
    private static Object sThreadRefLock;
    private static int sThreadRefCount;
    private static HandlerThread sHandlerThread;

    private final List<Integer> $$robo$$android_net_wifi_WifiScanner$getAvailableChannels(int band) {
        try {
            Bundle bundle = this.mService.getAvailableChannels(band);
            return bundle.getIntegerArrayList("Channels");
        }
        catch (RemoteException e) {
            return null;
        }
    }

    private final void $$robo$$android_net_wifi_WifiScanner$startBackgroundScan(ScanSettings settings, ScanListener listener) {
        this.validateChannel();
        sAsyncChannel.sendMessage(159746, 0, WifiScanner.putListener(listener), settings);
    }

    private final void $$robo$$android_net_wifi_WifiScanner$stopBackgroundScan(ScanListener listener) {
        this.validateChannel();
        sAsyncChannel.sendMessage(159747, 0, WifiScanner.removeListener(listener));
    }

    private final ScanResult[] $$robo$$android_net_wifi_WifiScanner$getScanResults() {
        this.validateChannel();
        Message reply = sAsyncChannel.sendMessageSynchronously(159748, 0);
        ScanResult[] results = (ScanResult[])reply.obj;
        return results;
    }

    private final void $$robo$$android_net_wifi_WifiScanner$configureWifiChange(int rssiSampleSize, int lostApSampleSize, int unchangedSampleSize, int minApsBreachingThreshold, int periodInMs, BssidInfo[] bssidInfos) {
        this.validateChannel();
        WifiChangeSettings settings = new WifiChangeSettings();
        settings.rssiSampleSize = rssiSampleSize;
        settings.lostApSampleSize = lostApSampleSize;
        settings.unchangedSampleSize = unchangedSampleSize;
        settings.minApsBreachingThreshold = minApsBreachingThreshold;
        settings.periodInMs = periodInMs;
        settings.bssidInfos = bssidInfos;
        this.configureWifiChange(settings);
    }

    private final void $$robo$$android_net_wifi_WifiScanner$startTrackingWifiChange(WifiChangeListener listener) {
        this.validateChannel();
        sAsyncChannel.sendMessage(159755, 0, WifiScanner.putListener(listener));
    }

    private final void $$robo$$android_net_wifi_WifiScanner$stopTrackingWifiChange(WifiChangeListener listener) {
        this.validateChannel();
        sAsyncChannel.sendMessage(159756, 0, WifiScanner.removeListener(listener));
    }

    private final void $$robo$$android_net_wifi_WifiScanner$configureWifiChange(WifiChangeSettings settings) {
        this.validateChannel();
        sAsyncChannel.sendMessage(159757, 0, 0, settings);
    }

    private final void $$robo$$android_net_wifi_WifiScanner$startTrackingBssids(BssidInfo[] bssidInfos, int apLostThreshold, BssidListener listener) {
        this.validateChannel();
        HotlistSettings settings = new HotlistSettings();
        settings.bssidInfos = bssidInfos;
        sAsyncChannel.sendMessage(159750, 0, WifiScanner.putListener(listener), settings);
    }

    private final void $$robo$$android_net_wifi_WifiScanner$stopTrackingBssids(BssidListener listener) {
        this.validateChannel();
        sAsyncChannel.sendMessage(159751, 0, WifiScanner.removeListener(listener));
    }

    private void $$robo$$android_net_wifi_WifiScanner$__constructor__(Context context, IWifiScanner service) {
        this.mContext = context;
        this.mService = service;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_wifi_WifiScanner$init() {
        Object object = sThreadRefLock;
        synchronized (object) {
            if (++sThreadRefCount == 1) {
                Messenger messenger = null;
                try {
                    messenger = this.mService.getMessenger();
                }
                catch (RemoteException remoteException) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (messenger == null) {
                    sAsyncChannel = null;
                    return;
                }
                sHandlerThread = new HandlerThread("WifiScanner");
                sAsyncChannel = new AsyncChannel();
                sConnected = new CountDownLatch(1);
                sHandlerThread.start();
                ServiceHandler handler = new ServiceHandler(sHandlerThread.getLooper());
                sAsyncChannel.connect(this.mContext, (Handler)handler, messenger);
                try {
                    sConnected.await();
                }
                catch (InterruptedException e) {
                    Log.e("WifiScanner", "interrupted wait at init");
                }
            }
        }
    }

    private final void $$robo$$android_net_wifi_WifiScanner$validateChannel() {
        if (sAsyncChannel == null) {
            throw new IllegalStateException("No permission to access and change wifi or a bad initialization");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int $$robo$$android_net_wifi_WifiScanner$putListener(Object listener) {
        int key;
        if (listener == null) {
            return 0;
        }
        Object object = sListenerMapLock;
        synchronized (object) {
            do {
                ++sListenerKey;
            } while (key == 0);
            sListenerMap.put(key, listener);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object $$robo$$android_net_wifi_WifiScanner$getListener(int key) {
        if (key == 0) {
            return null;
        }
        Object object = sListenerMapLock;
        synchronized (object) {
            Object listener = sListenerMap.get(key);
            return listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int $$robo$$android_net_wifi_WifiScanner$getListenerKey(Object listener) {
        if (listener == null) {
            return 0;
        }
        Object object = sListenerMapLock;
        synchronized (object) {
            int index = sListenerMap.indexOfValue(listener);
            if (index == -1) {
                return 0;
            }
            return sListenerMap.keyAt(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object $$robo$$android_net_wifi_WifiScanner$removeListener(int key) {
        if (key == 0) {
            return null;
        }
        Object object = sListenerMapLock;
        synchronized (object) {
            Object listener = sListenerMap.get(key);
            sListenerMap.remove(key);
            return listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int $$robo$$android_net_wifi_WifiScanner$removeListener(Object listener) {
        int key = WifiScanner.getListenerKey(listener);
        if (key == 0) {
            return key;
        }
        Object object = sListenerMapLock;
        synchronized (object) {
            sListenerMap.remove(key);
            return key;
        }
    }

    static void __staticInitializer__() {
        sListenerKey = 1;
        sListenerMap = new SparseArray();
        sListenerMapLock = new Object();
        sThreadRefLock = new Object();
    }

    public List<Integer> getAvailableChannels(int n) {
        return InvokeDynamicSupport.bootstrap("getAvailableChannels", $$robo$$android_net_wifi_WifiScanner$getAvailableChannels(int ), 0, this, n);
    }

    public void startBackgroundScan(ScanSettings scanSettings, ScanListener scanListener) {
        InvokeDynamicSupport.bootstrap("startBackgroundScan", $$robo$$android_net_wifi_WifiScanner$startBackgroundScan(android.net.wifi.WifiScanner$ScanSettings android.net.wifi.WifiScanner$ScanListener ), 0, this, scanSettings, scanListener);
    }

    public void stopBackgroundScan(ScanListener scanListener) {
        InvokeDynamicSupport.bootstrap("stopBackgroundScan", $$robo$$android_net_wifi_WifiScanner$stopBackgroundScan(android.net.wifi.WifiScanner$ScanListener ), 0, this, scanListener);
    }

    public ScanResult[] getScanResults() {
        return InvokeDynamicSupport.bootstrap("getScanResults", $$robo$$android_net_wifi_WifiScanner$getScanResults(), 0, this);
    }

    public void configureWifiChange(int n, int n2, int n3, int n4, int n5, BssidInfo[] bssidInfoArray) {
        InvokeDynamicSupport.bootstrap("configureWifiChange", $$robo$$android_net_wifi_WifiScanner$configureWifiChange(int int int int int android.net.wifi.WifiScanner$BssidInfo[] ), 0, this, n, n2, n3, n4, n5, bssidInfoArray);
    }

    public void startTrackingWifiChange(WifiChangeListener wifiChangeListener) {
        InvokeDynamicSupport.bootstrap("startTrackingWifiChange", $$robo$$android_net_wifi_WifiScanner$startTrackingWifiChange(android.net.wifi.WifiScanner$WifiChangeListener ), 0, this, wifiChangeListener);
    }

    public void stopTrackingWifiChange(WifiChangeListener wifiChangeListener) {
        InvokeDynamicSupport.bootstrap("stopTrackingWifiChange", $$robo$$android_net_wifi_WifiScanner$stopTrackingWifiChange(android.net.wifi.WifiScanner$WifiChangeListener ), 0, this, wifiChangeListener);
    }

    public void configureWifiChange(WifiChangeSettings wifiChangeSettings) {
        InvokeDynamicSupport.bootstrap("configureWifiChange", $$robo$$android_net_wifi_WifiScanner$configureWifiChange(android.net.wifi.WifiScanner$WifiChangeSettings ), 0, this, wifiChangeSettings);
    }

    public void startTrackingBssids(BssidInfo[] bssidInfoArray, int n, BssidListener bssidListener) {
        InvokeDynamicSupport.bootstrap("startTrackingBssids", $$robo$$android_net_wifi_WifiScanner$startTrackingBssids(android.net.wifi.WifiScanner$BssidInfo[] int android.net.wifi.WifiScanner$BssidListener ), 0, this, bssidInfoArray, n, bssidListener);
    }

    public void stopTrackingBssids(BssidListener bssidListener) {
        InvokeDynamicSupport.bootstrap("stopTrackingBssids", $$robo$$android_net_wifi_WifiScanner$stopTrackingBssids(android.net.wifi.WifiScanner$BssidListener ), 0, this, bssidListener);
    }

    private void __constructor__(Context context, IWifiScanner iWifiScanner) {
        this.$$robo$$android_net_wifi_WifiScanner$__constructor__(context, iWifiScanner);
    }

    public WifiScanner(Context context, IWifiScanner iWifiScanner) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner$__constructor__(android.content.Context android.net.wifi.IWifiScanner ), 0, this, context, iWifiScanner);
    }

    private void init() {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_net_wifi_WifiScanner$init(), 0, this);
    }

    private void validateChannel() {
        InvokeDynamicSupport.bootstrap("validateChannel", $$robo$$android_net_wifi_WifiScanner$validateChannel(), 0, this);
    }

    private static int putListener(Object object) {
        return (int)InvokeDynamicSupport.bootstrapStatic("putListener", $$robo$$android_net_wifi_WifiScanner$putListener(java.lang.Object ), 0, (Object)object);
    }

    private static Object getListener(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getListener", $$robo$$android_net_wifi_WifiScanner$getListener(int ), 0, (int)n);
    }

    private static int getListenerKey(Object object) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getListenerKey", $$robo$$android_net_wifi_WifiScanner$getListenerKey(java.lang.Object ), 0, (Object)object);
    }

    private static Object removeListener(int n) {
        return InvokeDynamicSupport.bootstrapStatic("removeListener", $$robo$$android_net_wifi_WifiScanner$removeListener(int ), 0, (int)n);
    }

    private static int removeListener(Object object) {
        return (int)InvokeDynamicSupport.bootstrapStatic("removeListener", $$robo$$android_net_wifi_WifiScanner$removeListener(java.lang.Object ), 0, (Object)object);
    }

    static {
        RobolectricInternals.classInitializing(WifiScanner.class);
    }

    public /* synthetic */ WifiScanner() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WifiScanner)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class ServiceHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_net_wifi_WifiScanner_ServiceHandler$__constructor__(Looper looper) {
        }

        private final void $$robo$$android_net_wifi_WifiScanner_ServiceHandler$handleMessage(Message msg) {
            switch (msg.what) {
                case 69632: {
                    if (msg.arg1 == 0) {
                        sAsyncChannel.sendMessage(69633);
                    } else {
                        Log.e("WifiScanner", "Failed to set up channel connection");
                        sAsyncChannel = null;
                    }
                    sConnected.countDown();
                    return;
                }
                case 69634: {
                    return;
                }
                case 69636: {
                    Log.e("WifiScanner", "Channel connection lost");
                    sAsyncChannel = null;
                    this.getLooper().quit();
                    return;
                }
            }
            Object listener = WifiScanner.getListener(msg.arg2);
            if (listener == null) {
                Log.d("WifiScanner", "invalid listener key = " + msg.arg2);
                return;
            }
            Log.d("WifiScanner", "listener key = " + msg.arg2);
            switch (msg.what) {
                case 159761: {
                    ((ActionListener)listener).onSuccess();
                    break;
                }
                case 159762: {
                    OperationResult result = (OperationResult)msg.obj;
                    ((ActionListener)listener).onFailure(result.reason, result.description);
                    WifiScanner.removeListener(msg.arg2);
                    break;
                }
                case 159749: {
                    ((ScanListener)listener).onResults(((ParcelableScanResults)msg.obj).getResults());
                    return;
                }
                case 159764: {
                    ScanResult result = (ScanResult)msg.obj;
                    ((ScanListener)listener).onFullResult(result);
                    return;
                }
                case 159763: {
                    ((ScanListener)listener).onPeriodChanged(msg.arg1);
                    return;
                }
                case 159753: {
                    ((BssidListener)listener).onFound(((ParcelableScanResults)msg.obj).getResults());
                    return;
                }
                case 159759: {
                    ((WifiChangeListener)listener).onChanging(((ParcelableScanResults)msg.obj).getResults());
                    return;
                }
                case 159760: {
                    ((WifiChangeListener)listener).onQuiescence(((ParcelableScanResults)msg.obj).getResults());
                    return;
                }
                default: {
                    Log.d("WifiScanner", "Ignoring message " + msg.what);
                    return;
                }
            }
        }

        private void __constructor__(Looper looper) {
            this.$$robo$$android_net_wifi_WifiScanner_ServiceHandler$__constructor__(looper);
        }

        ServiceHandler(Looper looper) {
            super(looper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner_ServiceHandler$__constructor__(android.os.Looper ), 0, this, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_net_wifi_WifiScanner_ServiceHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ ServiceHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ServiceHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class OperationResult
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int reason;
        public String description;
        public static Parcelable.Creator<OperationResult> CREATOR;

        private void $$robo$$android_net_wifi_WifiScanner_OperationResult$__constructor__(int reason, String description) {
            this.reason = reason;
            this.description = description;
        }

        private final int $$robo$$android_net_wifi_WifiScanner_OperationResult$describeContents() {
            return 0;
        }

        private final void $$robo$$android_net_wifi_WifiScanner_OperationResult$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.reason);
            dest.writeString(this.description);
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<OperationResult>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_net_wifi_WifiScanner_OperationResult_1$__constructor__() {
                }

                private final OperationResult $$robo$$android_net_wifi_WifiScanner_OperationResult_1$createFromParcel(Parcel in) {
                    int reason = in.readInt();
                    String description = in.readString();
                    return new OperationResult(reason, description);
                }

                private final OperationResult[] $$robo$$android_net_wifi_WifiScanner_OperationResult_1$newArray(int size) {
                    return new OperationResult[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_net_wifi_WifiScanner_OperationResult_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner_OperationResult_1$__constructor__(), 0, this);
                }

                @Override
                public OperationResult createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_WifiScanner_OperationResult_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public OperationResult[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_WifiScanner_OperationResult_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(int n, String string2) {
            this.$$robo$$android_net_wifi_WifiScanner_OperationResult$__constructor__(n, string2);
        }

        public OperationResult(int n, String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner_OperationResult$__constructor__(int java.lang.String ), 0, this, n, string2);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_WifiScanner_OperationResult$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_WifiScanner_OperationResult$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        static {
            RobolectricInternals.classInitializing(OperationResult.class);
        }

        public /* synthetic */ OperationResult() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OperationResult)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class HotlistSettings
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public BssidInfo[] bssidInfos;
        public int apLostThreshold;
        public static Parcelable.Creator<HotlistSettings> CREATOR;

        private void $$robo$$android_net_wifi_WifiScanner_HotlistSettings$__constructor__() {
        }

        private final int $$robo$$android_net_wifi_WifiScanner_HotlistSettings$describeContents() {
            return 0;
        }

        private final void $$robo$$android_net_wifi_WifiScanner_HotlistSettings$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.apLostThreshold);
            if (this.bssidInfos != null) {
                dest.writeInt(this.bssidInfos.length);
                for (int i = 0; i < this.bssidInfos.length; ++i) {
                    BssidInfo info = this.bssidInfos[i];
                    dest.writeString(info.bssid);
                    dest.writeInt(info.low);
                    dest.writeInt(info.high);
                    dest.writeInt(info.frequencyHint);
                }
            } else {
                dest.writeInt(0);
            }
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<HotlistSettings>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_net_wifi_WifiScanner_HotlistSettings_1$__constructor__() {
                }

                private final HotlistSettings $$robo$$android_net_wifi_WifiScanner_HotlistSettings_1$createFromParcel(Parcel in) {
                    HotlistSettings settings = new HotlistSettings();
                    settings.apLostThreshold = in.readInt();
                    int n = in.readInt();
                    settings.bssidInfos = new BssidInfo[n];
                    for (int i = 0; i < n; ++i) {
                        BssidInfo info = new BssidInfo();
                        info.bssid = in.readString();
                        info.low = in.readInt();
                        info.high = in.readInt();
                        info.frequencyHint = in.readInt();
                        settings.bssidInfos[i] = info;
                    }
                    return settings;
                }

                private final HotlistSettings[] $$robo$$android_net_wifi_WifiScanner_HotlistSettings_1$newArray(int size) {
                    return new HotlistSettings[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_net_wifi_WifiScanner_HotlistSettings_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner_HotlistSettings_1$__constructor__(), 0, this);
                }

                @Override
                public HotlistSettings createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_WifiScanner_HotlistSettings_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public HotlistSettings[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_WifiScanner_HotlistSettings_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_WifiScanner_HotlistSettings$__constructor__();
        }

        public HotlistSettings() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner_HotlistSettings$__constructor__(), 0, this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_WifiScanner_HotlistSettings$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_WifiScanner_HotlistSettings$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        static {
            RobolectricInternals.classInitializing(HotlistSettings.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HotlistSettings)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface BssidListener
    extends ActionListener,
    InstrumentedInterface {
        public void onFound(ScanResult[] var1);
    }

    public static interface WifiChangeListener
    extends ActionListener,
    InstrumentedInterface {
        public void onChanging(ScanResult[] var1);

        public void onQuiescence(ScanResult[] var1);
    }

    public static class WifiChangeSettings
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int rssiSampleSize;
        public int lostApSampleSize;
        public int unchangedSampleSize;
        public int minApsBreachingThreshold;
        public int periodInMs;
        public BssidInfo[] bssidInfos;
        public static Parcelable.Creator<WifiChangeSettings> CREATOR;

        private void $$robo$$android_net_wifi_WifiScanner_WifiChangeSettings$__constructor__() {
        }

        private final int $$robo$$android_net_wifi_WifiScanner_WifiChangeSettings$describeContents() {
            return 0;
        }

        private final void $$robo$$android_net_wifi_WifiScanner_WifiChangeSettings$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.rssiSampleSize);
            dest.writeInt(this.lostApSampleSize);
            dest.writeInt(this.unchangedSampleSize);
            dest.writeInt(this.minApsBreachingThreshold);
            dest.writeInt(this.periodInMs);
            if (this.bssidInfos != null) {
                dest.writeInt(this.bssidInfos.length);
                for (int i = 0; i < this.bssidInfos.length; ++i) {
                    BssidInfo info = this.bssidInfos[i];
                    dest.writeString(info.bssid);
                    dest.writeInt(info.low);
                    dest.writeInt(info.high);
                    dest.writeInt(info.frequencyHint);
                }
            } else {
                dest.writeInt(0);
            }
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<WifiChangeSettings>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_net_wifi_WifiScanner_WifiChangeSettings_1$__constructor__() {
                }

                private final WifiChangeSettings $$robo$$android_net_wifi_WifiScanner_WifiChangeSettings_1$createFromParcel(Parcel in) {
                    WifiChangeSettings settings = new WifiChangeSettings();
                    settings.rssiSampleSize = in.readInt();
                    settings.lostApSampleSize = in.readInt();
                    settings.unchangedSampleSize = in.readInt();
                    settings.minApsBreachingThreshold = in.readInt();
                    settings.periodInMs = in.readInt();
                    int len = in.readInt();
                    settings.bssidInfos = new BssidInfo[len];
                    for (int i = 0; i < len; ++i) {
                        BssidInfo info = new BssidInfo();
                        info.bssid = in.readString();
                        info.low = in.readInt();
                        info.high = in.readInt();
                        info.frequencyHint = in.readInt();
                        settings.bssidInfos[i] = info;
                    }
                    return settings;
                }

                private final WifiChangeSettings[] $$robo$$android_net_wifi_WifiScanner_WifiChangeSettings_1$newArray(int size) {
                    return new WifiChangeSettings[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_net_wifi_WifiScanner_WifiChangeSettings_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner_WifiChangeSettings_1$__constructor__(), 0, this);
                }

                @Override
                public WifiChangeSettings createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_WifiScanner_WifiChangeSettings_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public WifiChangeSettings[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_WifiScanner_WifiChangeSettings_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_WifiScanner_WifiChangeSettings$__constructor__();
        }

        public WifiChangeSettings() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner_WifiChangeSettings$__constructor__(), 0, this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_WifiScanner_WifiChangeSettings$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_WifiScanner_WifiChangeSettings$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        static {
            RobolectricInternals.classInitializing(WifiChangeSettings.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WifiChangeSettings)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class BssidInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String bssid;
        public int low;
        public int high;
        public int frequencyHint;

        private void $$robo$$android_net_wifi_WifiScanner_BssidInfo$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_WifiScanner_BssidInfo$__constructor__();
        }

        public BssidInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner_BssidInfo$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BssidInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface ScanListener
    extends ActionListener,
    InstrumentedInterface {
        public void onPeriodChanged(int var1);

        public void onResults(ScanResult[] var1);

        public void onFullResult(ScanResult var1);
    }

    public static class ParcelableScanResults
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public ScanResult[] mResults;
        public static Parcelable.Creator<ParcelableScanResults> CREATOR;

        private void $$robo$$android_net_wifi_WifiScanner_ParcelableScanResults$__constructor__(ScanResult[] results) {
            this.mResults = results;
        }

        private final ScanResult[] $$robo$$android_net_wifi_WifiScanner_ParcelableScanResults$getResults() {
            return this.mResults;
        }

        private final int $$robo$$android_net_wifi_WifiScanner_ParcelableScanResults$describeContents() {
            return 0;
        }

        private final void $$robo$$android_net_wifi_WifiScanner_ParcelableScanResults$writeToParcel(Parcel dest, int flags) {
            if (this.mResults != null) {
                dest.writeInt(this.mResults.length);
                for (int i = 0; i < this.mResults.length; ++i) {
                    ScanResult result = this.mResults[i];
                    result.writeToParcel(dest, flags);
                }
            } else {
                dest.writeInt(0);
            }
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<ParcelableScanResults>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_net_wifi_WifiScanner_ParcelableScanResults_1$__constructor__() {
                }

                private final ParcelableScanResults $$robo$$android_net_wifi_WifiScanner_ParcelableScanResults_1$createFromParcel(Parcel in) {
                    int n = in.readInt();
                    ScanResult[] results = new ScanResult[n];
                    for (int i = 0; i < n; ++i) {
                        results[i] = ScanResult.CREATOR.createFromParcel(in);
                    }
                    return new ParcelableScanResults(results);
                }

                private final ParcelableScanResults[] $$robo$$android_net_wifi_WifiScanner_ParcelableScanResults_1$newArray(int size) {
                    return new ParcelableScanResults[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_net_wifi_WifiScanner_ParcelableScanResults_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner_ParcelableScanResults_1$__constructor__(), 0, this);
                }

                @Override
                public ParcelableScanResults createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_WifiScanner_ParcelableScanResults_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public ParcelableScanResults[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_WifiScanner_ParcelableScanResults_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(ScanResult[] scanResultArray) {
            this.$$robo$$android_net_wifi_WifiScanner_ParcelableScanResults$__constructor__(scanResultArray);
        }

        public ParcelableScanResults(ScanResult[] scanResultArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner_ParcelableScanResults$__constructor__(android.net.wifi.ScanResult[] ), 0, this, scanResultArray);
        }

        public ScanResult[] getResults() {
            return InvokeDynamicSupport.bootstrap("getResults", $$robo$$android_net_wifi_WifiScanner_ParcelableScanResults$getResults(), 0, this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_WifiScanner_ParcelableScanResults$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_WifiScanner_ParcelableScanResults$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        static {
            RobolectricInternals.classInitializing(ParcelableScanResults.class);
        }

        public /* synthetic */ ParcelableScanResults() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParcelableScanResults)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ScanSettings
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int band;
        public ChannelSpec[] channels;
        public int periodInMs;
        public int reportEvents;
        public int numBssidsPerScan;
        public static Parcelable.Creator<ScanSettings> CREATOR;

        private void $$robo$$android_net_wifi_WifiScanner_ScanSettings$__constructor__() {
        }

        private final int $$robo$$android_net_wifi_WifiScanner_ScanSettings$describeContents() {
            return 0;
        }

        private final void $$robo$$android_net_wifi_WifiScanner_ScanSettings$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.band);
            dest.writeInt(this.periodInMs);
            dest.writeInt(this.reportEvents);
            dest.writeInt(this.numBssidsPerScan);
            if (this.channels != null) {
                dest.writeInt(this.channels.length);
                for (int i = 0; i < this.channels.length; ++i) {
                    dest.writeInt(this.channels[i].frequency);
                    dest.writeInt(this.channels[i].dwellTimeMS);
                    dest.writeInt(this.channels[i].passive ? 1 : 0);
                }
            } else {
                dest.writeInt(0);
            }
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<ScanSettings>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_net_wifi_WifiScanner_ScanSettings_1$__constructor__() {
                }

                private final ScanSettings $$robo$$android_net_wifi_WifiScanner_ScanSettings_1$createFromParcel(Parcel in) {
                    ScanSettings settings = new ScanSettings();
                    settings.band = in.readInt();
                    settings.periodInMs = in.readInt();
                    settings.reportEvents = in.readInt();
                    settings.numBssidsPerScan = in.readInt();
                    int num_channels = in.readInt();
                    settings.channels = new ChannelSpec[num_channels];
                    for (int i = 0; i < num_channels; ++i) {
                        int frequency = in.readInt();
                        ChannelSpec spec = new ChannelSpec(frequency);
                        spec.dwellTimeMS = in.readInt();
                        spec.passive = in.readInt() == 1;
                        settings.channels[i] = spec;
                    }
                    return settings;
                }

                private final ScanSettings[] $$robo$$android_net_wifi_WifiScanner_ScanSettings_1$newArray(int size) {
                    return new ScanSettings[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_net_wifi_WifiScanner_ScanSettings_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner_ScanSettings_1$__constructor__(), 0, this);
                }

                @Override
                public ScanSettings createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_WifiScanner_ScanSettings_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public ScanSettings[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_WifiScanner_ScanSettings_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_WifiScanner_ScanSettings$__constructor__();
        }

        public ScanSettings() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner_ScanSettings$__constructor__(), 0, this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_WifiScanner_ScanSettings$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_WifiScanner_ScanSettings$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        static {
            RobolectricInternals.classInitializing(ScanSettings.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ScanSettings)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ChannelSpec
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int frequency;
        public boolean passive;
        public int dwellTimeMS;

        private void $$robo$$android_net_wifi_WifiScanner_ChannelSpec$__constructor__(int frequency) {
            this.frequency = frequency;
            this.passive = false;
            this.dwellTimeMS = 0;
        }

        private void __constructor__(int n) {
            this.$$robo$$android_net_wifi_WifiScanner_ChannelSpec$__constructor__(n);
        }

        public ChannelSpec(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiScanner_ChannelSpec$__constructor__(int ), 0, this, n);
        }

        public /* synthetic */ ChannelSpec() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ChannelSpec)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface ActionListener
    extends InstrumentedInterface {
        public void onSuccess();

        public void onFailure(int var1, String var2);
    }
}

