/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p;

import android.net.wifi.p2p.WifiP2pGroup;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.LruCache;
import java.util.Collection;
import java.util.Map;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WifiP2pGroupList
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int CREDENTIAL_MAX_NUM = 32;
    private LruCache<Integer, WifiP2pGroup> mGroups;
    private GroupDeleteListener mListener;
    private boolean isClearCalled;
    public static Parcelable.Creator<WifiP2pGroupList> CREATOR;

    private void $$robo$$android_net_wifi_p2p_WifiP2pGroupList$__constructor__() {
    }

    private void $$robo$$android_net_wifi_p2p_WifiP2pGroupList$__constructor__(WifiP2pGroupList source, GroupDeleteListener listener) {
        this.isClearCalled = false;
        this.mListener = listener;
        this.mGroups = new LruCache<Integer, WifiP2pGroup>(this, 32){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ WifiP2pGroupList this$0;

            private void $$robo$$android_net_wifi_p2p_WifiP2pGroupList_1$__constructor__(WifiP2pGroupList wifiP2pGroupList, int x0) {
            }

            private final void $$robo$$android_net_wifi_p2p_WifiP2pGroupList_1$entryRemoved(boolean evicted, Integer netId, WifiP2pGroup oldValue, WifiP2pGroup newValue) {
                if (this.this$0.mListener != null && !this.this$0.isClearCalled) {
                    this.this$0.mListener.onDeleteGroup(oldValue.getNetworkId());
                }
            }

            private void __constructor__(WifiP2pGroupList wifiP2pGroupList, int n) {
                this.$$robo$$android_net_wifi_p2p_WifiP2pGroupList_1$__constructor__(wifiP2pGroupList, n);
            }
            {
                this.this$0 = wifiP2pGroupList;
                super(n);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_p2p_WifiP2pGroupList_1$__constructor__(android.net.wifi.p2p.WifiP2pGroupList int ), 0, this, wifiP2pGroupList, n);
            }

            @Override
            protected void entryRemoved(boolean bl, Integer n, WifiP2pGroup wifiP2pGroup, WifiP2pGroup wifiP2pGroup2) {
                InvokeDynamicSupport.bootstrap("entryRemoved", $$robo$$android_net_wifi_p2p_WifiP2pGroupList_1$entryRemoved(boolean java.lang.Integer android.net.wifi.p2p.WifiP2pGroup android.net.wifi.p2p.WifiP2pGroup ), 0, this, bl, n, wifiP2pGroup, wifiP2pGroup2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        if (source != null) {
            for (Map.Entry<Integer, WifiP2pGroup> item : source.mGroups.snapshot().entrySet()) {
                this.mGroups.put(item.getKey(), item.getValue());
            }
        }
    }

    private final Collection<WifiP2pGroup> $$robo$$android_net_wifi_p2p_WifiP2pGroupList$getGroupList() {
        return this.mGroups.snapshot().values();
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pGroupList$add(WifiP2pGroup group) {
        this.mGroups.put(group.getNetworkId(), group);
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pGroupList$remove(int netId) {
        this.mGroups.remove(netId);
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pGroupList$remove(String deviceAddress) {
        this.remove(this.getNetworkId(deviceAddress));
    }

    private final boolean $$robo$$android_net_wifi_p2p_WifiP2pGroupList$clear() {
        if (this.mGroups.size() == 0) {
            return false;
        }
        this.isClearCalled = true;
        this.mGroups.evictAll();
        this.isClearCalled = false;
        return true;
    }

    private final int $$robo$$android_net_wifi_p2p_WifiP2pGroupList$getNetworkId(String deviceAddress) {
        if (deviceAddress == null) {
            return -1;
        }
        Collection<WifiP2pGroup> groups = this.mGroups.snapshot().values();
        for (WifiP2pGroup grp : groups) {
            if (!deviceAddress.equalsIgnoreCase(grp.getOwner().deviceAddress)) continue;
            this.mGroups.get(grp.getNetworkId());
            return grp.getNetworkId();
        }
        return -1;
    }

    private final int $$robo$$android_net_wifi_p2p_WifiP2pGroupList$getNetworkId(String deviceAddress, String ssid) {
        if (deviceAddress == null || ssid == null) {
            return -1;
        }
        Collection<WifiP2pGroup> groups = this.mGroups.snapshot().values();
        for (WifiP2pGroup grp : groups) {
            if (!deviceAddress.equalsIgnoreCase(grp.getOwner().deviceAddress) || !ssid.equals(grp.getNetworkName())) continue;
            this.mGroups.get(grp.getNetworkId());
            return grp.getNetworkId();
        }
        return -1;
    }

    private final String $$robo$$android_net_wifi_p2p_WifiP2pGroupList$getOwnerAddr(int netId) {
        WifiP2pGroup grp = this.mGroups.get(netId);
        if (grp != null) {
            return grp.getOwner().deviceAddress;
        }
        return null;
    }

    private final boolean $$robo$$android_net_wifi_p2p_WifiP2pGroupList$contains(int netId) {
        Collection<WifiP2pGroup> groups = this.mGroups.snapshot().values();
        for (WifiP2pGroup grp : groups) {
            if (netId != grp.getNetworkId()) continue;
            return true;
        }
        return false;
    }

    private final String $$robo$$android_net_wifi_p2p_WifiP2pGroupList$toString() {
        StringBuffer sbuf = new StringBuffer();
        Collection<WifiP2pGroup> groups = this.mGroups.snapshot().values();
        for (WifiP2pGroup grp : groups) {
            sbuf.append(grp).append("\n");
        }
        return sbuf.toString();
    }

    private final int $$robo$$android_net_wifi_p2p_WifiP2pGroupList$describeContents() {
        return 0;
    }

    private final void $$robo$$android_net_wifi_p2p_WifiP2pGroupList$writeToParcel(Parcel dest, int flags) {
        Collection<WifiP2pGroup> groups = this.mGroups.snapshot().values();
        dest.writeInt(groups.size());
        for (WifiP2pGroup group : groups) {
            dest.writeParcelable(group, flags);
        }
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<WifiP2pGroupList>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_wifi_p2p_WifiP2pGroupList_2$__constructor__() {
            }

            private final WifiP2pGroupList $$robo$$android_net_wifi_p2p_WifiP2pGroupList_2$createFromParcel(Parcel in) {
                WifiP2pGroupList grpList = new WifiP2pGroupList();
                int deviceCount = in.readInt();
                for (int i = 0; i < deviceCount; ++i) {
                    grpList.add((WifiP2pGroup)in.readParcelable(null));
                }
                return grpList;
            }

            private final WifiP2pGroupList[] $$robo$$android_net_wifi_p2p_WifiP2pGroupList_2$newArray(int size) {
                return new WifiP2pGroupList[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_wifi_p2p_WifiP2pGroupList_2$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_p2p_WifiP2pGroupList_2$__constructor__(), 0, this);
            }

            @Override
            public WifiP2pGroupList createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_p2p_WifiP2pGroupList_2$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public WifiP2pGroupList[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_p2p_WifiP2pGroupList_2$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_net_wifi_p2p_WifiP2pGroupList$__constructor__();
    }

    public WifiP2pGroupList() {
        this(null, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_p2p_WifiP2pGroupList$__constructor__(), 0, this);
    }

    private void __constructor__(WifiP2pGroupList wifiP2pGroupList, GroupDeleteListener groupDeleteListener) {
        this.$$robo$$android_net_wifi_p2p_WifiP2pGroupList$__constructor__(wifiP2pGroupList, groupDeleteListener);
    }

    public WifiP2pGroupList(WifiP2pGroupList wifiP2pGroupList, GroupDeleteListener groupDeleteListener) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_p2p_WifiP2pGroupList$__constructor__(android.net.wifi.p2p.WifiP2pGroupList android.net.wifi.p2p.WifiP2pGroupList$GroupDeleteListener ), 0, this, wifiP2pGroupList, groupDeleteListener);
    }

    public Collection<WifiP2pGroup> getGroupList() {
        return InvokeDynamicSupport.bootstrap("getGroupList", $$robo$$android_net_wifi_p2p_WifiP2pGroupList$getGroupList(), 0, this);
    }

    public void add(WifiP2pGroup wifiP2pGroup) {
        InvokeDynamicSupport.bootstrap("add", $$robo$$android_net_wifi_p2p_WifiP2pGroupList$add(android.net.wifi.p2p.WifiP2pGroup ), 0, this, wifiP2pGroup);
    }

    public void remove(int n) {
        InvokeDynamicSupport.bootstrap("remove", $$robo$$android_net_wifi_p2p_WifiP2pGroupList$remove(int ), 0, this, n);
    }

    void remove(String string2) {
        InvokeDynamicSupport.bootstrap("remove", $$robo$$android_net_wifi_p2p_WifiP2pGroupList$remove(java.lang.String ), 0, this, string2);
    }

    public boolean clear() {
        return (boolean)InvokeDynamicSupport.bootstrap("clear", $$robo$$android_net_wifi_p2p_WifiP2pGroupList$clear(), 0, this);
    }

    public int getNetworkId(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getNetworkId", $$robo$$android_net_wifi_p2p_WifiP2pGroupList$getNetworkId(java.lang.String ), 0, this, string2);
    }

    public int getNetworkId(String string2, String string3) {
        return (int)InvokeDynamicSupport.bootstrap("getNetworkId", $$robo$$android_net_wifi_p2p_WifiP2pGroupList$getNetworkId(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public String getOwnerAddr(int n) {
        return InvokeDynamicSupport.bootstrap("getOwnerAddr", $$robo$$android_net_wifi_p2p_WifiP2pGroupList$getOwnerAddr(int ), 0, this, n);
    }

    public boolean contains(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("contains", $$robo$$android_net_wifi_p2p_WifiP2pGroupList$contains(int ), 0, this, n);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_wifi_p2p_WifiP2pGroupList$toString(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_p2p_WifiP2pGroupList$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_p2p_WifiP2pGroupList$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    static {
        RobolectricInternals.classInitializing(WifiP2pGroupList.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WifiP2pGroupList)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface GroupDeleteListener
    extends InstrumentedInterface {
        public void onDeleteGroup(int var1);
    }
}

