/*
 * Decompiled with CFR 0.152.
 */
package android.opengl;

import android.content.Context;
import android.opengl.EGLLogWrapper;
import android.opengl.GLDebugHelper;
import android.os.SystemProperties;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL;
import javax.microedition.khronos.opengles.GL10;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class GLSurfaceView
extends SurfaceView
implements SurfaceHolder.Callback,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "GLSurfaceView";
    private static boolean LOG_ATTACH_DETACH = false;
    private static boolean LOG_THREADS = false;
    private static boolean LOG_PAUSE_RESUME = false;
    private static boolean LOG_SURFACE = false;
    private static boolean LOG_RENDERER = false;
    private static boolean LOG_RENDERER_DRAW_FRAME = false;
    private static boolean LOG_EGL = false;
    public static int RENDERMODE_WHEN_DIRTY = 0;
    public static int RENDERMODE_CONTINUOUSLY = 1;
    public static int DEBUG_CHECK_GL_ERROR = 1;
    public static int DEBUG_LOG_GL_CALLS = 2;
    private static GLThreadManager sGLThreadManager;
    private WeakReference<GLSurfaceView> mThisWeakRef;
    private GLThread mGLThread;
    private Renderer mRenderer;
    private boolean mDetached;
    private EGLConfigChooser mEGLConfigChooser;
    private EGLContextFactory mEGLContextFactory;
    private EGLWindowSurfaceFactory mEGLWindowSurfaceFactory;
    private GLWrapper mGLWrapper;
    private int mDebugFlags;
    private int mEGLContextClientVersion;
    private boolean mPreserveEGLContextOnPause;

    private void $$robo$$android_opengl_GLSurfaceView$__constructor__(Context context) {
        this.mThisWeakRef = new WeakReference<GLSurfaceView>(this);
        this.init();
    }

    private void $$robo$$android_opengl_GLSurfaceView$__constructor__(Context context, AttributeSet attrs) {
        this.mThisWeakRef = new WeakReference<GLSurfaceView>(this);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_opengl_GLSurfaceView$finalize() throws Throwable {
        try {
            if (this.mGLThread != null) {
                this.mGLThread.requestExitAndWait();
            }
        }
        finally {
            super.finalize();
        }
    }

    private final void $$robo$$android_opengl_GLSurfaceView$init() {
        SurfaceHolder holder = this.getHolder();
        holder.addCallback(this);
    }

    private final void $$robo$$android_opengl_GLSurfaceView$setGLWrapper(GLWrapper glWrapper) {
        this.mGLWrapper = glWrapper;
    }

    private final void $$robo$$android_opengl_GLSurfaceView$setDebugFlags(int debugFlags) {
        this.mDebugFlags = debugFlags;
    }

    private final int $$robo$$android_opengl_GLSurfaceView$getDebugFlags() {
        return this.mDebugFlags;
    }

    private final void $$robo$$android_opengl_GLSurfaceView$setPreserveEGLContextOnPause(boolean preserveOnPause) {
        this.mPreserveEGLContextOnPause = preserveOnPause;
    }

    private final boolean $$robo$$android_opengl_GLSurfaceView$getPreserveEGLContextOnPause() {
        return this.mPreserveEGLContextOnPause;
    }

    private final void $$robo$$android_opengl_GLSurfaceView$setRenderer(Renderer renderer) {
        this.checkRenderThreadState();
        if (this.mEGLConfigChooser == null) {
            this.mEGLConfigChooser = new SimpleEGLConfigChooser(this, true);
        }
        if (this.mEGLContextFactory == null) {
            this.mEGLContextFactory = new DefaultContextFactory(this);
        }
        if (this.mEGLWindowSurfaceFactory == null) {
            this.mEGLWindowSurfaceFactory = new DefaultWindowSurfaceFactory();
        }
        this.mRenderer = renderer;
        this.mGLThread = new GLThread(this.mThisWeakRef);
        this.mGLThread.start();
    }

    private final void $$robo$$android_opengl_GLSurfaceView$setEGLContextFactory(EGLContextFactory factory) {
        this.checkRenderThreadState();
        this.mEGLContextFactory = factory;
    }

    private final void $$robo$$android_opengl_GLSurfaceView$setEGLWindowSurfaceFactory(EGLWindowSurfaceFactory factory) {
        this.checkRenderThreadState();
        this.mEGLWindowSurfaceFactory = factory;
    }

    private final void $$robo$$android_opengl_GLSurfaceView$setEGLConfigChooser(EGLConfigChooser configChooser) {
        this.checkRenderThreadState();
        this.mEGLConfigChooser = configChooser;
    }

    private final void $$robo$$android_opengl_GLSurfaceView$setEGLConfigChooser(boolean needDepth) {
        this.setEGLConfigChooser(new SimpleEGLConfigChooser(this, needDepth));
    }

    private final void $$robo$$android_opengl_GLSurfaceView$setEGLConfigChooser(int redSize, int greenSize, int blueSize, int alphaSize, int depthSize, int stencilSize) {
        this.setEGLConfigChooser(new ComponentSizeChooser(this, redSize, greenSize, blueSize, alphaSize, depthSize, stencilSize));
    }

    private final void $$robo$$android_opengl_GLSurfaceView$setEGLContextClientVersion(int version) {
        this.checkRenderThreadState();
        this.mEGLContextClientVersion = version;
    }

    private final void $$robo$$android_opengl_GLSurfaceView$setRenderMode(int renderMode) {
        this.mGLThread.setRenderMode(renderMode);
    }

    private final int $$robo$$android_opengl_GLSurfaceView$getRenderMode() {
        return this.mGLThread.getRenderMode();
    }

    private final void $$robo$$android_opengl_GLSurfaceView$requestRender() {
        this.mGLThread.requestRender();
    }

    private final void $$robo$$android_opengl_GLSurfaceView$surfaceCreated(SurfaceHolder holder) {
        this.mGLThread.surfaceCreated();
    }

    private final void $$robo$$android_opengl_GLSurfaceView$surfaceDestroyed(SurfaceHolder holder) {
        this.mGLThread.surfaceDestroyed();
    }

    private final void $$robo$$android_opengl_GLSurfaceView$surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
        this.mGLThread.onWindowResize(w, h);
    }

    private final void $$robo$$android_opengl_GLSurfaceView$onPause() {
        this.mGLThread.onPause();
    }

    private final void $$robo$$android_opengl_GLSurfaceView$onResume() {
        this.mGLThread.onResume();
    }

    private final void $$robo$$android_opengl_GLSurfaceView$queueEvent(Runnable r) {
        this.mGLThread.queueEvent(r);
    }

    private final void $$robo$$android_opengl_GLSurfaceView$onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mDetached && this.mRenderer != null) {
            int renderMode = 1;
            if (this.mGLThread != null) {
                renderMode = this.mGLThread.getRenderMode();
            }
            this.mGLThread = new GLThread(this.mThisWeakRef);
            if (renderMode != 1) {
                this.mGLThread.setRenderMode(renderMode);
            }
            this.mGLThread.start();
        }
        this.mDetached = false;
    }

    private final void $$robo$$android_opengl_GLSurfaceView$onDetachedFromWindow() {
        if (this.mGLThread != null) {
            this.mGLThread.requestExitAndWait();
        }
        this.mDetached = true;
        super.onDetachedFromWindow();
    }

    private final void $$robo$$android_opengl_GLSurfaceView$checkRenderThreadState() {
        if (this.mGLThread != null) {
            throw new IllegalStateException("setRenderer has already been called for this instance.");
        }
    }

    static /* synthetic */ boolean access$900(GLSurfaceView x0) {
        return x0.mPreserveEGLContextOnPause;
    }

    static /* synthetic */ Renderer access$1000(GLSurfaceView x0) {
        return x0.mRenderer;
    }

    static void __staticInitializer__() {
        sGLThreadManager = new GLThreadManager();
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_opengl_GLSurfaceView$__constructor__(context);
    }

    public GLSurfaceView(Context context) {
        super(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_opengl_GLSurfaceView$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_opengl_GLSurfaceView$__constructor__(context, attributeSet);
    }

    public GLSurfaceView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_opengl_GLSurfaceView$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_opengl_GLSurfaceView$finalize(), 0, this);
    }

    private void init() {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_opengl_GLSurfaceView$init(), 0, this);
    }

    public void setGLWrapper(GLWrapper gLWrapper) {
        InvokeDynamicSupport.bootstrap("setGLWrapper", $$robo$$android_opengl_GLSurfaceView$setGLWrapper(android.opengl.GLSurfaceView$GLWrapper ), 0, this, gLWrapper);
    }

    public void setDebugFlags(int n) {
        InvokeDynamicSupport.bootstrap("setDebugFlags", $$robo$$android_opengl_GLSurfaceView$setDebugFlags(int ), 0, this, n);
    }

    public int getDebugFlags() {
        return (int)InvokeDynamicSupport.bootstrap("getDebugFlags", $$robo$$android_opengl_GLSurfaceView$getDebugFlags(), 0, this);
    }

    public void setPreserveEGLContextOnPause(boolean bl) {
        InvokeDynamicSupport.bootstrap("setPreserveEGLContextOnPause", $$robo$$android_opengl_GLSurfaceView$setPreserveEGLContextOnPause(boolean ), 0, this, bl);
    }

    public boolean getPreserveEGLContextOnPause() {
        return (boolean)InvokeDynamicSupport.bootstrap("getPreserveEGLContextOnPause", $$robo$$android_opengl_GLSurfaceView$getPreserveEGLContextOnPause(), 0, this);
    }

    public void setRenderer(Renderer renderer) {
        InvokeDynamicSupport.bootstrap("setRenderer", $$robo$$android_opengl_GLSurfaceView$setRenderer(android.opengl.GLSurfaceView$Renderer ), 0, this, renderer);
    }

    public void setEGLContextFactory(EGLContextFactory eGLContextFactory) {
        InvokeDynamicSupport.bootstrap("setEGLContextFactory", $$robo$$android_opengl_GLSurfaceView$setEGLContextFactory(android.opengl.GLSurfaceView$EGLContextFactory ), 0, this, eGLContextFactory);
    }

    public void setEGLWindowSurfaceFactory(EGLWindowSurfaceFactory eGLWindowSurfaceFactory) {
        InvokeDynamicSupport.bootstrap("setEGLWindowSurfaceFactory", $$robo$$android_opengl_GLSurfaceView$setEGLWindowSurfaceFactory(android.opengl.GLSurfaceView$EGLWindowSurfaceFactory ), 0, this, eGLWindowSurfaceFactory);
    }

    public void setEGLConfigChooser(EGLConfigChooser eGLConfigChooser) {
        InvokeDynamicSupport.bootstrap("setEGLConfigChooser", $$robo$$android_opengl_GLSurfaceView$setEGLConfigChooser(android.opengl.GLSurfaceView$EGLConfigChooser ), 0, this, eGLConfigChooser);
    }

    public void setEGLConfigChooser(boolean bl) {
        InvokeDynamicSupport.bootstrap("setEGLConfigChooser", $$robo$$android_opengl_GLSurfaceView$setEGLConfigChooser(boolean ), 0, this, bl);
    }

    public void setEGLConfigChooser(int n, int n2, int n3, int n4, int n5, int n6) {
        InvokeDynamicSupport.bootstrap("setEGLConfigChooser", $$robo$$android_opengl_GLSurfaceView$setEGLConfigChooser(int int int int int int ), 0, this, n, n2, n3, n4, n5, n6);
    }

    public void setEGLContextClientVersion(int n) {
        InvokeDynamicSupport.bootstrap("setEGLContextClientVersion", $$robo$$android_opengl_GLSurfaceView$setEGLContextClientVersion(int ), 0, this, n);
    }

    public void setRenderMode(int n) {
        InvokeDynamicSupport.bootstrap("setRenderMode", $$robo$$android_opengl_GLSurfaceView$setRenderMode(int ), 0, this, n);
    }

    public int getRenderMode() {
        return (int)InvokeDynamicSupport.bootstrap("getRenderMode", $$robo$$android_opengl_GLSurfaceView$getRenderMode(), 0, this);
    }

    public void requestRender() {
        InvokeDynamicSupport.bootstrap("requestRender", $$robo$$android_opengl_GLSurfaceView$requestRender(), 0, this);
    }

    @Override
    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        InvokeDynamicSupport.bootstrap("surfaceCreated", $$robo$$android_opengl_GLSurfaceView$surfaceCreated(android.view.SurfaceHolder ), 0, this, surfaceHolder);
    }

    @Override
    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        InvokeDynamicSupport.bootstrap("surfaceDestroyed", $$robo$$android_opengl_GLSurfaceView$surfaceDestroyed(android.view.SurfaceHolder ), 0, this, surfaceHolder);
    }

    @Override
    public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("surfaceChanged", $$robo$$android_opengl_GLSurfaceView$surfaceChanged(android.view.SurfaceHolder int int int ), 0, this, surfaceHolder, n, n2, n3);
    }

    public void onPause() {
        InvokeDynamicSupport.bootstrap("onPause", $$robo$$android_opengl_GLSurfaceView$onPause(), 0, this);
    }

    public void onResume() {
        InvokeDynamicSupport.bootstrap("onResume", $$robo$$android_opengl_GLSurfaceView$onResume(), 0, this);
    }

    public void queueEvent(Runnable runnable) {
        InvokeDynamicSupport.bootstrap("queueEvent", $$robo$$android_opengl_GLSurfaceView$queueEvent(java.lang.Runnable ), 0, this, runnable);
    }

    @Override
    protected void onAttachedToWindow() {
        InvokeDynamicSupport.bootstrap("onAttachedToWindow", $$robo$$android_opengl_GLSurfaceView$onAttachedToWindow(), 0, this);
    }

    @Override
    protected void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$android_opengl_GLSurfaceView$onDetachedFromWindow(), 0, this);
    }

    private void checkRenderThreadState() {
        InvokeDynamicSupport.bootstrap("checkRenderThreadState", $$robo$$android_opengl_GLSurfaceView$checkRenderThreadState(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(GLSurfaceView.class);
    }

    public /* synthetic */ GLSurfaceView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GLSurfaceView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class GLThreadManager
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String TAG;
        private boolean mGLESVersionCheckComplete;
        private int mGLESVersion;
        private boolean mGLESDriverCheckComplete;
        private boolean mMultipleGLESContextsAllowed;
        private boolean mLimitedGLESContexts;
        private static int kGLES_20 = 131072;
        private static String kMSM7K_RENDERER_PREFIX = "Q3Dimension MSM7500 ";
        private GLThread mEglOwner;

        private void $$robo$$android_opengl_GLSurfaceView_GLThreadManager$__constructor__() {
        }

        private final synchronized void $$robo$$android_opengl_GLSurfaceView_GLThreadManager$threadExiting(GLThread thread) {
            thread.mExited = true;
            if (this.mEglOwner == thread) {
                this.mEglOwner = null;
            }
            this.notifyAll();
        }

        private final boolean $$robo$$android_opengl_GLSurfaceView_GLThreadManager$tryAcquireEglContextLocked(GLThread thread) {
            if (this.mEglOwner == thread || this.mEglOwner == null) {
                this.mEglOwner = thread;
                this.notifyAll();
                return true;
            }
            this.checkGLESVersion();
            if (this.mMultipleGLESContextsAllowed) {
                return true;
            }
            if (this.mEglOwner != null) {
                this.mEglOwner.requestReleaseEglContextLocked();
            }
            return false;
        }

        private final void $$robo$$android_opengl_GLSurfaceView_GLThreadManager$releaseEglContextLocked(GLThread thread) {
            if (this.mEglOwner == thread) {
                this.mEglOwner = null;
            }
            this.notifyAll();
        }

        private final synchronized boolean $$robo$$android_opengl_GLSurfaceView_GLThreadManager$shouldReleaseEGLContextWhenPausing() {
            return this.mLimitedGLESContexts;
        }

        private final synchronized boolean $$robo$$android_opengl_GLSurfaceView_GLThreadManager$shouldTerminateEGLWhenPausing() {
            this.checkGLESVersion();
            return !this.mMultipleGLESContextsAllowed;
        }

        private final synchronized void $$robo$$android_opengl_GLSurfaceView_GLThreadManager$checkGLDriver(GL10 gl) {
            if (!this.mGLESDriverCheckComplete) {
                this.checkGLESVersion();
                String renderer = gl.glGetString(7937);
                if (this.mGLESVersion < 131072) {
                    this.mMultipleGLESContextsAllowed = !renderer.startsWith("Q3Dimension MSM7500 ");
                    this.notifyAll();
                }
                this.mLimitedGLESContexts = !this.mMultipleGLESContextsAllowed;
                this.mGLESDriverCheckComplete = true;
            }
        }

        private final void $$robo$$android_opengl_GLSurfaceView_GLThreadManager$checkGLESVersion() {
            if (!this.mGLESVersionCheckComplete) {
                this.mGLESVersion = SystemProperties.getInt("ro.opengles.version", 0);
                if (this.mGLESVersion >= 131072) {
                    this.mMultipleGLESContextsAllowed = true;
                }
                this.mGLESVersionCheckComplete = true;
            }
        }

        private /* synthetic */ void $$robo$$android_opengl_GLSurfaceView_GLThreadManager$__constructor__(1 x0) {
        }

        static void __staticInitializer__() {
            TAG = "GLThreadManager";
        }

        private void __constructor__() {
            this.$$robo$$android_opengl_GLSurfaceView_GLThreadManager$__constructor__();
        }

        private GLThreadManager() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_opengl_GLSurfaceView_GLThreadManager$__constructor__(), 0, this);
        }

        public synchronized void threadExiting(GLThread gLThread) {
            InvokeDynamicSupport.bootstrap("threadExiting", $$robo$$android_opengl_GLSurfaceView_GLThreadManager$threadExiting(android.opengl.GLSurfaceView$GLThread ), 0, this, gLThread);
        }

        public boolean tryAcquireEglContextLocked(GLThread gLThread) {
            return (boolean)InvokeDynamicSupport.bootstrap("tryAcquireEglContextLocked", $$robo$$android_opengl_GLSurfaceView_GLThreadManager$tryAcquireEglContextLocked(android.opengl.GLSurfaceView$GLThread ), 0, this, gLThread);
        }

        public void releaseEglContextLocked(GLThread gLThread) {
            InvokeDynamicSupport.bootstrap("releaseEglContextLocked", $$robo$$android_opengl_GLSurfaceView_GLThreadManager$releaseEglContextLocked(android.opengl.GLSurfaceView$GLThread ), 0, this, gLThread);
        }

        public synchronized boolean shouldReleaseEGLContextWhenPausing() {
            return (boolean)InvokeDynamicSupport.bootstrap("shouldReleaseEGLContextWhenPausing", $$robo$$android_opengl_GLSurfaceView_GLThreadManager$shouldReleaseEGLContextWhenPausing(), 0, this);
        }

        public synchronized boolean shouldTerminateEGLWhenPausing() {
            return (boolean)InvokeDynamicSupport.bootstrap("shouldTerminateEGLWhenPausing", $$robo$$android_opengl_GLSurfaceView_GLThreadManager$shouldTerminateEGLWhenPausing(), 0, this);
        }

        public synchronized void checkGLDriver(GL10 gL10) {
            InvokeDynamicSupport.bootstrap("checkGLDriver", $$robo$$android_opengl_GLSurfaceView_GLThreadManager$checkGLDriver(javax.microedition.khronos.opengles.GL10 ), 0, this, gL10);
        }

        private void checkGLESVersion() {
            InvokeDynamicSupport.bootstrap("checkGLESVersion", $$robo$$android_opengl_GLSurfaceView_GLThreadManager$checkGLESVersion(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_opengl_GLSurfaceView_GLThreadManager$__constructor__(var1_1);
        }

        static {
            RobolectricInternals.classInitializing(GLThreadManager.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GLThreadManager)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class LogWriter
    extends Writer
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private StringBuilder mBuilder;

        private void $$robo$$android_opengl_GLSurfaceView_LogWriter$__constructor__() {
            this.mBuilder = new StringBuilder();
        }

        private final void $$robo$$android_opengl_GLSurfaceView_LogWriter$close() {
            this.flushBuilder();
        }

        private final void $$robo$$android_opengl_GLSurfaceView_LogWriter$flush() {
            this.flushBuilder();
        }

        private final void $$robo$$android_opengl_GLSurfaceView_LogWriter$write(char[] buf, int offset, int count) {
            for (int i = 0; i < count; ++i) {
                char c = buf[offset + i];
                if (c == '\n') {
                    this.flushBuilder();
                    continue;
                }
                this.mBuilder.append(c);
            }
        }

        private final void $$robo$$android_opengl_GLSurfaceView_LogWriter$flushBuilder() {
            if (this.mBuilder.length() > 0) {
                Log.v("GLSurfaceView", this.mBuilder.toString());
                this.mBuilder.delete(0, this.mBuilder.length());
            }
        }

        private void __constructor__() {
            this.$$robo$$android_opengl_GLSurfaceView_LogWriter$__constructor__();
        }

        LogWriter() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_opengl_GLSurfaceView_LogWriter$__constructor__(), 0, this);
        }

        @Override
        public void close() {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_opengl_GLSurfaceView_LogWriter$close(), 0, this);
        }

        @Override
        public void flush() {
            InvokeDynamicSupport.bootstrap("flush", $$robo$$android_opengl_GLSurfaceView_LogWriter$flush(), 0, this);
        }

        @Override
        public void write(char[] cArray, int n, int n2) {
            InvokeDynamicSupport.bootstrap("write", $$robo$$android_opengl_GLSurfaceView_LogWriter$write(char[] int int ), 0, this, cArray, n, n2);
        }

        private void flushBuilder() {
            InvokeDynamicSupport.bootstrap("flushBuilder", $$robo$$android_opengl_GLSurfaceView_LogWriter$flushBuilder(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LogWriter)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class GLThread
    extends Thread
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private boolean mShouldExit;
        private boolean mExited;
        private boolean mRequestPaused;
        private boolean mPaused;
        private boolean mHasSurface;
        private boolean mSurfaceIsBad;
        private boolean mWaitingForSurface;
        private boolean mHaveEglContext;
        private boolean mHaveEglSurface;
        private boolean mFinishedCreatingEglSurface;
        private boolean mShouldReleaseEglContext;
        private int mWidth;
        private int mHeight;
        private int mRenderMode;
        private boolean mRequestRender;
        private boolean mRenderComplete;
        private ArrayList<Runnable> mEventQueue;
        private boolean mSizeChanged;
        private EglHelper mEglHelper;
        private WeakReference<GLSurfaceView> mGLSurfaceViewWeakRef;

        private void $$robo$$android_opengl_GLSurfaceView_GLThread$__constructor__(WeakReference<GLSurfaceView> glSurfaceViewWeakRef) {
            this.mEventQueue = new ArrayList();
            this.mSizeChanged = true;
            this.mWidth = 0;
            this.mHeight = 0;
            this.mRequestRender = true;
            this.mRenderMode = 1;
            this.mGLSurfaceViewWeakRef = glSurfaceViewWeakRef;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_opengl_GLSurfaceView_GLThread$run() {
            this.setName("GLThread " + this.getId());
            try {
                this.guardedRun();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                sGLThreadManager.threadExiting(this);
            }
        }

        private final void $$robo$$android_opengl_GLSurfaceView_GLThread$stopEglSurfaceLocked() {
            if (this.mHaveEglSurface) {
                this.mHaveEglSurface = false;
                this.mEglHelper.destroySurface();
            }
        }

        private final void $$robo$$android_opengl_GLSurfaceView_GLThread$stopEglContextLocked() {
            if (this.mHaveEglContext) {
                this.mEglHelper.finish();
                this.mHaveEglContext = false;
                sGLThreadManager.releaseEglContextLocked(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final void $$robo$$android_opengl_GLSurfaceView_GLThread$guardedRun() throws InterruptedException {
            this.mEglHelper = new EglHelper(this.mGLSurfaceViewWeakRef);
            this.mHaveEglContext = false;
            this.mHaveEglSurface = false;
            try {
                gl = null;
                createEglContext = false;
                createEglSurface = false;
                createGlInterface = false;
                lostEglContext = false;
                sizeChanged = false;
                wantRenderNotification = false;
                doRenderNotification = false;
                askedToReleaseEglContext = false;
                w = 0;
                h = 0;
                event = null;
                while (true) {
                    var13_13 = GLSurfaceView.access$800();
                    synchronized (var13_13) {
                        while (true) {
                            if (this.mShouldExit) {
                                return;
                            }
                            if (!this.mEventQueue.isEmpty()) {
                                event = this.mEventQueue.remove(0);
                                break;
                            }
                            pausing = false;
                            if (this.mPaused != this.mRequestPaused) {
                                pausing = this.mRequestPaused;
                                this.mPaused = this.mRequestPaused;
                                GLSurfaceView.access$800().notifyAll();
                            }
                            if (this.mShouldReleaseEglContext) {
                                this.stopEglSurfaceLocked();
                                this.stopEglContextLocked();
                                this.mShouldReleaseEglContext = false;
                                askedToReleaseEglContext = true;
                            }
                            if (lostEglContext) {
                                this.stopEglSurfaceLocked();
                                this.stopEglContextLocked();
                                lostEglContext = false;
                            }
                            if (pausing && this.mHaveEglSurface) {
                                this.stopEglSurfaceLocked();
                            }
                            if (pausing && this.mHaveEglContext) {
                                view = (GLSurfaceView)this.mGLSurfaceViewWeakRef.get();
                                v0 = preserveEglContextOnPause = view == null ? false : GLSurfaceView.access$900(view);
                                if (!preserveEglContextOnPause || GLSurfaceView.access$800().shouldReleaseEGLContextWhenPausing()) {
                                    this.stopEglContextLocked();
                                }
                            }
                            if (pausing && GLSurfaceView.access$800().shouldTerminateEGLWhenPausing()) {
                                this.mEglHelper.finish();
                            }
                            if (!this.mHasSurface && !this.mWaitingForSurface) {
                                if (this.mHaveEglSurface) {
                                    this.stopEglSurfaceLocked();
                                }
                                this.mWaitingForSurface = true;
                                this.mSurfaceIsBad = false;
                                GLSurfaceView.access$800().notifyAll();
                            }
                            if (this.mHasSurface && this.mWaitingForSurface) {
                                this.mWaitingForSurface = false;
                                GLSurfaceView.access$800().notifyAll();
                            }
                            if (doRenderNotification) {
                                wantRenderNotification = false;
                                doRenderNotification = false;
                                this.mRenderComplete = true;
                                GLSurfaceView.access$800().notifyAll();
                            }
                            if (this.readyToDraw()) {
                                if (!this.mHaveEglContext) {
                                    if (askedToReleaseEglContext) {
                                        askedToReleaseEglContext = false;
                                    } else if (GLSurfaceView.access$800().tryAcquireEglContextLocked(this)) {
                                        try {
                                            this.mEglHelper.start();
                                        }
                                        catch (RuntimeException t) {
                                            GLSurfaceView.access$800().releaseEglContextLocked(this);
                                            throw t;
                                        }
                                        this.mHaveEglContext = true;
                                        createEglContext = true;
                                        GLSurfaceView.access$800().notifyAll();
                                    }
                                }
                                if (this.mHaveEglContext && !this.mHaveEglSurface) {
                                    this.mHaveEglSurface = true;
                                    createEglSurface = true;
                                    createGlInterface = true;
                                    sizeChanged = true;
                                }
                                if (this.mHaveEglSurface) {
                                    if (this.mSizeChanged) {
                                        sizeChanged = true;
                                        w = this.mWidth;
                                        h = this.mHeight;
                                        wantRenderNotification = true;
                                        createEglSurface = true;
                                        this.mSizeChanged = false;
                                    }
                                    this.mRequestRender = false;
                                    GLSurfaceView.access$800().notifyAll();
                                    break;
                                }
                            }
                            GLSurfaceView.access$800().wait();
                        }
                        ** if (event == null) goto lbl100
                    }
lbl-1000:
                    // 1 sources

                    {
                        event.run();
                        event = null;
                        continue;
                    }
lbl100:
                    // 1 sources

                    if (createEglSurface) {
                        if (this.mEglHelper.createSurface()) {
                            var13_13 = GLSurfaceView.access$800();
                            synchronized (var13_13) {
                                this.mFinishedCreatingEglSurface = true;
                                GLSurfaceView.access$800().notifyAll();
                            }
                            createEglSurface = false;
                        } else {
                            var13_13 = GLSurfaceView.access$800();
                            synchronized (var13_13) {
                                this.mFinishedCreatingEglSurface = true;
                                this.mSurfaceIsBad = true;
                                GLSurfaceView.access$800().notifyAll();
                                continue;
                            }
                        }
                    }
                    if (createGlInterface) {
                        gl = (GL10)this.mEglHelper.createGL();
                        GLSurfaceView.access$800().checkGLDriver(gl);
                        createGlInterface = false;
                    }
                    if (createEglContext) {
                        view = (GLSurfaceView)this.mGLSurfaceViewWeakRef.get();
                        if (view != null) {
                            GLSurfaceView.access$1000(view).onSurfaceCreated(gl, this.mEglHelper.mEglConfig);
                        }
                        createEglContext = false;
                    }
                    if (sizeChanged) {
                        view = (GLSurfaceView)this.mGLSurfaceViewWeakRef.get();
                        if (view != null) {
                            GLSurfaceView.access$1000(view).onSurfaceChanged(gl, w, h);
                        }
                        sizeChanged = false;
                    }
                    if ((view = (GLSurfaceView)this.mGLSurfaceViewWeakRef.get()) != null) {
                        GLSurfaceView.access$1000(view).onDrawFrame(gl);
                    }
                    swapError = this.mEglHelper.swap();
                    switch (swapError) {
                        case 12288: {
                            break;
                        }
                        case 12302: {
                            lostEglContext = true;
                            break;
                        }
                        default: {
                            EglHelper.logEglErrorAsWarning("GLThread", "eglSwapBuffers", swapError);
                            var14_17 = GLSurfaceView.access$800();
                            synchronized (var14_17) {
                                this.mSurfaceIsBad = true;
                                GLSurfaceView.access$800().notifyAll();
                                break;
                            }
                        }
                    }
                    if (!wantRenderNotification) continue;
                    doRenderNotification = true;
                }
            }
            finally {
                var14_15 = GLSurfaceView.access$800();
                synchronized (var14_15) {
                    this.stopEglSurfaceLocked();
                    this.stopEglContextLocked();
                }
            }
        }

        private final boolean $$robo$$android_opengl_GLSurfaceView_GLThread$ableToDraw() {
            return this.mHaveEglContext && this.mHaveEglSurface && this.readyToDraw();
        }

        private final boolean $$robo$$android_opengl_GLSurfaceView_GLThread$readyToDraw() {
            return !this.mPaused && this.mHasSurface && !this.mSurfaceIsBad && this.mWidth > 0 && this.mHeight > 0 && (this.mRequestRender || this.mRenderMode == 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_opengl_GLSurfaceView_GLThread$setRenderMode(int renderMode) {
            if (0 > renderMode || renderMode > 1) {
                throw new IllegalArgumentException("renderMode");
            }
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRenderMode = renderMode;
                sGLThreadManager.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final int $$robo$$android_opengl_GLSurfaceView_GLThread$getRenderMode() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                return this.mRenderMode;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_opengl_GLSurfaceView_GLThread$requestRender() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRequestRender = true;
                sGLThreadManager.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_opengl_GLSurfaceView_GLThread$surfaceCreated() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mHasSurface = true;
                this.mFinishedCreatingEglSurface = false;
                sGLThreadManager.notifyAll();
                while (this.mWaitingForSurface && !this.mFinishedCreatingEglSurface && !this.mExited) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_opengl_GLSurfaceView_GLThread$surfaceDestroyed() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mHasSurface = false;
                sGLThreadManager.notifyAll();
                while (!this.mWaitingForSurface && !this.mExited) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_opengl_GLSurfaceView_GLThread$onPause() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRequestPaused = true;
                sGLThreadManager.notifyAll();
                while (!this.mExited && !this.mPaused) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_opengl_GLSurfaceView_GLThread$onResume() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mRequestPaused = false;
                this.mRequestRender = true;
                this.mRenderComplete = false;
                sGLThreadManager.notifyAll();
                while (!this.mExited && this.mPaused && !this.mRenderComplete) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_opengl_GLSurfaceView_GLThread$onWindowResize(int w, int h) {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mWidth = w;
                this.mHeight = h;
                this.mSizeChanged = true;
                this.mRequestRender = true;
                this.mRenderComplete = false;
                sGLThreadManager.notifyAll();
                while (!this.mExited && !this.mPaused && !this.mRenderComplete && this.ableToDraw()) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_opengl_GLSurfaceView_GLThread$requestExitAndWait() {
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mShouldExit = true;
                sGLThreadManager.notifyAll();
                while (!this.mExited) {
                    try {
                        sGLThreadManager.wait();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        private final void $$robo$$android_opengl_GLSurfaceView_GLThread$requestReleaseEglContextLocked() {
            this.mShouldReleaseEglContext = true;
            sGLThreadManager.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_opengl_GLSurfaceView_GLThread$queueEvent(Runnable r) {
            if (r == null) {
                throw new IllegalArgumentException("r must not be null");
            }
            GLThreadManager gLThreadManager = sGLThreadManager;
            synchronized (gLThreadManager) {
                this.mEventQueue.add(r);
                sGLThreadManager.notifyAll();
            }
        }

        private void __constructor__(WeakReference<GLSurfaceView> weakReference) {
            this.$$robo$$android_opengl_GLSurfaceView_GLThread$__constructor__(weakReference);
        }

        GLThread(WeakReference<GLSurfaceView> weakReference) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_opengl_GLSurfaceView_GLThread$__constructor__(java.lang.ref.WeakReference<android.opengl.GLSurfaceView> ), 0, this, weakReference);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_opengl_GLSurfaceView_GLThread$run(), 0, this);
        }

        private void stopEglSurfaceLocked() {
            InvokeDynamicSupport.bootstrap("stopEglSurfaceLocked", $$robo$$android_opengl_GLSurfaceView_GLThread$stopEglSurfaceLocked(), 0, this);
        }

        private void stopEglContextLocked() {
            InvokeDynamicSupport.bootstrap("stopEglContextLocked", $$robo$$android_opengl_GLSurfaceView_GLThread$stopEglContextLocked(), 0, this);
        }

        private void guardedRun() throws InterruptedException {
            InvokeDynamicSupport.bootstrap("guardedRun", $$robo$$android_opengl_GLSurfaceView_GLThread$guardedRun(), 0, this);
        }

        public boolean ableToDraw() {
            return (boolean)InvokeDynamicSupport.bootstrap("ableToDraw", $$robo$$android_opengl_GLSurfaceView_GLThread$ableToDraw(), 0, this);
        }

        private boolean readyToDraw() {
            return (boolean)InvokeDynamicSupport.bootstrap("readyToDraw", $$robo$$android_opengl_GLSurfaceView_GLThread$readyToDraw(), 0, this);
        }

        public void setRenderMode(int n) {
            InvokeDynamicSupport.bootstrap("setRenderMode", $$robo$$android_opengl_GLSurfaceView_GLThread$setRenderMode(int ), 0, this, n);
        }

        public int getRenderMode() {
            return (int)InvokeDynamicSupport.bootstrap("getRenderMode", $$robo$$android_opengl_GLSurfaceView_GLThread$getRenderMode(), 0, this);
        }

        public void requestRender() {
            InvokeDynamicSupport.bootstrap("requestRender", $$robo$$android_opengl_GLSurfaceView_GLThread$requestRender(), 0, this);
        }

        public void surfaceCreated() {
            InvokeDynamicSupport.bootstrap("surfaceCreated", $$robo$$android_opengl_GLSurfaceView_GLThread$surfaceCreated(), 0, this);
        }

        public void surfaceDestroyed() {
            InvokeDynamicSupport.bootstrap("surfaceDestroyed", $$robo$$android_opengl_GLSurfaceView_GLThread$surfaceDestroyed(), 0, this);
        }

        public void onPause() {
            InvokeDynamicSupport.bootstrap("onPause", $$robo$$android_opengl_GLSurfaceView_GLThread$onPause(), 0, this);
        }

        public void onResume() {
            InvokeDynamicSupport.bootstrap("onResume", $$robo$$android_opengl_GLSurfaceView_GLThread$onResume(), 0, this);
        }

        public void onWindowResize(int n, int n2) {
            InvokeDynamicSupport.bootstrap("onWindowResize", $$robo$$android_opengl_GLSurfaceView_GLThread$onWindowResize(int int ), 0, this, n, n2);
        }

        public void requestExitAndWait() {
            InvokeDynamicSupport.bootstrap("requestExitAndWait", $$robo$$android_opengl_GLSurfaceView_GLThread$requestExitAndWait(), 0, this);
        }

        public void requestReleaseEglContextLocked() {
            InvokeDynamicSupport.bootstrap("requestReleaseEglContextLocked", $$robo$$android_opengl_GLSurfaceView_GLThread$requestReleaseEglContextLocked(), 0, this);
        }

        public void queueEvent(Runnable runnable) {
            InvokeDynamicSupport.bootstrap("queueEvent", $$robo$$android_opengl_GLSurfaceView_GLThread$queueEvent(java.lang.Runnable ), 0, this, runnable);
        }

        public /* synthetic */ GLThread() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GLThread)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class EglHelper
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private WeakReference<GLSurfaceView> mGLSurfaceViewWeakRef;
        EGL10 mEgl;
        EGLDisplay mEglDisplay;
        EGLSurface mEglSurface;
        EGLConfig mEglConfig;
        EGLContext mEglContext;

        private void $$robo$$android_opengl_GLSurfaceView_EglHelper$__constructor__(WeakReference<GLSurfaceView> glSurfaceViewWeakRef) {
            this.mGLSurfaceViewWeakRef = glSurfaceViewWeakRef;
        }

        private final void $$robo$$android_opengl_GLSurfaceView_EglHelper$start() {
            this.mEgl = (EGL10)EGLContext.getEGL();
            this.mEglDisplay = this.mEgl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
            if (this.mEglDisplay == EGL10.EGL_NO_DISPLAY) {
                throw new RuntimeException("eglGetDisplay failed");
            }
            int[] version = new int[2];
            if (!this.mEgl.eglInitialize(this.mEglDisplay, version)) {
                throw new RuntimeException("eglInitialize failed");
            }
            GLSurfaceView view = (GLSurfaceView)this.mGLSurfaceViewWeakRef.get();
            if (view == null) {
                this.mEglConfig = null;
                this.mEglContext = null;
            } else {
                this.mEglConfig = view.mEGLConfigChooser.chooseConfig(this.mEgl, this.mEglDisplay);
                this.mEglContext = view.mEGLContextFactory.createContext(this.mEgl, this.mEglDisplay, this.mEglConfig);
            }
            if (this.mEglContext == null || this.mEglContext == EGL10.EGL_NO_CONTEXT) {
                this.mEglContext = null;
                this.throwEglException("createContext");
            }
            this.mEglSurface = null;
        }

        private final boolean $$robo$$android_opengl_GLSurfaceView_EglHelper$createSurface() {
            if (this.mEgl == null) {
                throw new RuntimeException("egl not initialized");
            }
            if (this.mEglDisplay == null) {
                throw new RuntimeException("eglDisplay not initialized");
            }
            if (this.mEglConfig == null) {
                throw new RuntimeException("mEglConfig not initialized");
            }
            this.destroySurfaceImp();
            GLSurfaceView view = (GLSurfaceView)this.mGLSurfaceViewWeakRef.get();
            this.mEglSurface = view != null ? view.mEGLWindowSurfaceFactory.createWindowSurface(this.mEgl, this.mEglDisplay, this.mEglConfig, view.getHolder()) : null;
            if (this.mEglSurface == null || this.mEglSurface == EGL10.EGL_NO_SURFACE) {
                int error = this.mEgl.eglGetError();
                if (error == 12299) {
                    Log.e("EglHelper", "createWindowSurface returned EGL_BAD_NATIVE_WINDOW.");
                }
                return false;
            }
            if (!this.mEgl.eglMakeCurrent(this.mEglDisplay, this.mEglSurface, this.mEglSurface, this.mEglContext)) {
                EglHelper.logEglErrorAsWarning("EGLHelper", "eglMakeCurrent", this.mEgl.eglGetError());
                return false;
            }
            return true;
        }

        private final GL $$robo$$android_opengl_GLSurfaceView_EglHelper$createGL() {
            GL gl = this.mEglContext.getGL();
            GLSurfaceView view = (GLSurfaceView)this.mGLSurfaceViewWeakRef.get();
            if (view != null) {
                if (view.mGLWrapper != null) {
                    gl = view.mGLWrapper.wrap(gl);
                }
                if ((view.mDebugFlags & 3) != 0) {
                    int configFlags = 0;
                    LogWriter log = null;
                    if ((view.mDebugFlags & 1) != 0) {
                        configFlags |= 1;
                    }
                    if ((view.mDebugFlags & 2) != 0) {
                        log = new LogWriter();
                    }
                    gl = GLDebugHelper.wrap(gl, configFlags, (Writer)log);
                }
            }
            return gl;
        }

        private final int $$robo$$android_opengl_GLSurfaceView_EglHelper$swap() {
            if (!this.mEgl.eglSwapBuffers(this.mEglDisplay, this.mEglSurface)) {
                return this.mEgl.eglGetError();
            }
            return 12288;
        }

        private final void $$robo$$android_opengl_GLSurfaceView_EglHelper$destroySurface() {
            this.destroySurfaceImp();
        }

        private final void $$robo$$android_opengl_GLSurfaceView_EglHelper$destroySurfaceImp() {
            if (this.mEglSurface != null && this.mEglSurface != EGL10.EGL_NO_SURFACE) {
                this.mEgl.eglMakeCurrent(this.mEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
                GLSurfaceView view = (GLSurfaceView)this.mGLSurfaceViewWeakRef.get();
                if (view != null) {
                    view.mEGLWindowSurfaceFactory.destroySurface(this.mEgl, this.mEglDisplay, this.mEglSurface);
                }
                this.mEglSurface = null;
            }
        }

        private final void $$robo$$android_opengl_GLSurfaceView_EglHelper$finish() {
            if (this.mEglContext != null) {
                GLSurfaceView view = (GLSurfaceView)this.mGLSurfaceViewWeakRef.get();
                if (view != null) {
                    view.mEGLContextFactory.destroyContext(this.mEgl, this.mEglDisplay, this.mEglContext);
                }
                this.mEglContext = null;
            }
            if (this.mEglDisplay != null) {
                this.mEgl.eglTerminate(this.mEglDisplay);
                this.mEglDisplay = null;
            }
        }

        private final void $$robo$$android_opengl_GLSurfaceView_EglHelper$throwEglException(String function) {
            EglHelper.throwEglException(function, this.mEgl.eglGetError());
        }

        private static final void $$robo$$android_opengl_GLSurfaceView_EglHelper$throwEglException(String function, int error) {
            String message = EglHelper.formatEglError(function, error);
            throw new RuntimeException(message);
        }

        private static final void $$robo$$android_opengl_GLSurfaceView_EglHelper$logEglErrorAsWarning(String tag, String function, int error) {
            Log.w(tag, EglHelper.formatEglError(function, error));
        }

        private static final String $$robo$$android_opengl_GLSurfaceView_EglHelper$formatEglError(String function, int error) {
            return function + " failed: " + EGLLogWrapper.getErrorString(error);
        }

        private void __constructor__(WeakReference<GLSurfaceView> weakReference) {
            this.$$robo$$android_opengl_GLSurfaceView_EglHelper$__constructor__(weakReference);
        }

        public EglHelper(WeakReference<GLSurfaceView> weakReference) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_opengl_GLSurfaceView_EglHelper$__constructor__(java.lang.ref.WeakReference<android.opengl.GLSurfaceView> ), 0, this, weakReference);
        }

        public void start() {
            InvokeDynamicSupport.bootstrap("start", $$robo$$android_opengl_GLSurfaceView_EglHelper$start(), 0, this);
        }

        public boolean createSurface() {
            return (boolean)InvokeDynamicSupport.bootstrap("createSurface", $$robo$$android_opengl_GLSurfaceView_EglHelper$createSurface(), 0, this);
        }

        GL createGL() {
            return InvokeDynamicSupport.bootstrap("createGL", $$robo$$android_opengl_GLSurfaceView_EglHelper$createGL(), 0, this);
        }

        public int swap() {
            return (int)InvokeDynamicSupport.bootstrap("swap", $$robo$$android_opengl_GLSurfaceView_EglHelper$swap(), 0, this);
        }

        public void destroySurface() {
            InvokeDynamicSupport.bootstrap("destroySurface", $$robo$$android_opengl_GLSurfaceView_EglHelper$destroySurface(), 0, this);
        }

        private void destroySurfaceImp() {
            InvokeDynamicSupport.bootstrap("destroySurfaceImp", $$robo$$android_opengl_GLSurfaceView_EglHelper$destroySurfaceImp(), 0, this);
        }

        public void finish() {
            InvokeDynamicSupport.bootstrap("finish", $$robo$$android_opengl_GLSurfaceView_EglHelper$finish(), 0, this);
        }

        private void throwEglException(String string2) {
            InvokeDynamicSupport.bootstrap("throwEglException", $$robo$$android_opengl_GLSurfaceView_EglHelper$throwEglException(java.lang.String ), 0, this, string2);
        }

        public static void throwEglException(String string2, int n) {
            InvokeDynamicSupport.bootstrapStatic("throwEglException", $$robo$$android_opengl_GLSurfaceView_EglHelper$throwEglException(java.lang.String int ), 0, (String)string2, (int)n);
        }

        public static void logEglErrorAsWarning(String string2, String string3, int n) {
            InvokeDynamicSupport.bootstrapStatic("logEglErrorAsWarning", $$robo$$android_opengl_GLSurfaceView_EglHelper$logEglErrorAsWarning(java.lang.String java.lang.String int ), 0, (String)string2, (String)string3, (int)n);
        }

        public static String formatEglError(String string2, int n) {
            return InvokeDynamicSupport.bootstrapStatic("formatEglError", $$robo$$android_opengl_GLSurfaceView_EglHelper$formatEglError(java.lang.String int ), 0, (String)string2, (int)n);
        }

        public /* synthetic */ EglHelper() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EglHelper)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class SimpleEGLConfigChooser
    extends ComponentSizeChooser
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ GLSurfaceView this$0;

        private void $$robo$$android_opengl_GLSurfaceView_SimpleEGLConfigChooser$__constructor__(GLSurfaceView gLSurfaceView, boolean withDepthBuffer) {
        }

        private void __constructor__(GLSurfaceView gLSurfaceView, boolean bl) {
            this.$$robo$$android_opengl_GLSurfaceView_SimpleEGLConfigChooser$__constructor__(gLSurfaceView, bl);
        }

        public SimpleEGLConfigChooser(GLSurfaceView gLSurfaceView, boolean bl) {
            this.this$0 = gLSurfaceView;
            super(gLSurfaceView, 8, 8, 8, 0, bl ? 16 : 0, 0);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_opengl_GLSurfaceView_SimpleEGLConfigChooser$__constructor__(android.opengl.GLSurfaceView boolean ), 0, this, gLSurfaceView, bl);
        }

        public /* synthetic */ SimpleEGLConfigChooser() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SimpleEGLConfigChooser)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ComponentSizeChooser
    extends BaseConfigChooser
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int[] mValue;
        protected int mRedSize;
        protected int mGreenSize;
        protected int mBlueSize;
        protected int mAlphaSize;
        protected int mDepthSize;
        protected int mStencilSize;
        /* synthetic */ GLSurfaceView this$0;

        private void $$robo$$android_opengl_GLSurfaceView_ComponentSizeChooser$__constructor__(GLSurfaceView gLSurfaceView, int redSize, int greenSize, int blueSize, int alphaSize, int depthSize, int stencilSize) {
            this.mValue = new int[1];
            this.mRedSize = redSize;
            this.mGreenSize = greenSize;
            this.mBlueSize = blueSize;
            this.mAlphaSize = alphaSize;
            this.mDepthSize = depthSize;
            this.mStencilSize = stencilSize;
        }

        private final EGLConfig $$robo$$android_opengl_GLSurfaceView_ComponentSizeChooser$chooseConfig(EGL10 egl, EGLDisplay display, EGLConfig[] configs) {
            for (EGLConfig config : configs) {
                int d = this.findConfigAttrib(egl, display, config, 12325, 0);
                int s = this.findConfigAttrib(egl, display, config, 12326, 0);
                if (d < this.mDepthSize || s < this.mStencilSize) continue;
                int r = this.findConfigAttrib(egl, display, config, 12324, 0);
                int g = this.findConfigAttrib(egl, display, config, 12323, 0);
                int b = this.findConfigAttrib(egl, display, config, 12322, 0);
                int a = this.findConfigAttrib(egl, display, config, 12321, 0);
                if (r != this.mRedSize || g != this.mGreenSize || b != this.mBlueSize || a != this.mAlphaSize) continue;
                return config;
            }
            return null;
        }

        private final int $$robo$$android_opengl_GLSurfaceView_ComponentSizeChooser$findConfigAttrib(EGL10 egl, EGLDisplay display, EGLConfig config, int attribute, int defaultValue) {
            if (egl.eglGetConfigAttrib(display, config, attribute, this.mValue)) {
                return this.mValue[0];
            }
            return defaultValue;
        }

        private void __constructor__(GLSurfaceView gLSurfaceView, int n, int n2, int n3, int n4, int n5, int n6) {
            this.$$robo$$android_opengl_GLSurfaceView_ComponentSizeChooser$__constructor__(gLSurfaceView, n, n2, n3, n4, n5, n6);
        }

        public ComponentSizeChooser(GLSurfaceView gLSurfaceView, int n, int n2, int n3, int n4, int n5, int n6) {
            this.this$0 = gLSurfaceView;
            super(gLSurfaceView, new int[]{12324, n, 12323, n2, 12322, n3, 12321, n4, 12325, n5, 12326, n6, 12344});
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_opengl_GLSurfaceView_ComponentSizeChooser$__constructor__(android.opengl.GLSurfaceView int int int int int int ), 0, this, gLSurfaceView, n, n2, n3, n4, n5, n6);
        }

        @Override
        public EGLConfig chooseConfig(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig[] eGLConfigArray) {
            return InvokeDynamicSupport.bootstrap("chooseConfig", $$robo$$android_opengl_GLSurfaceView_ComponentSizeChooser$chooseConfig(javax.microedition.khronos.egl.EGL10 javax.microedition.khronos.egl.EGLDisplay javax.microedition.khronos.egl.EGLConfig[] ), 0, this, eGL10, eGLDisplay, eGLConfigArray);
        }

        private int findConfigAttrib(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig, int n, int n2) {
            return (int)InvokeDynamicSupport.bootstrap("findConfigAttrib", $$robo$$android_opengl_GLSurfaceView_ComponentSizeChooser$findConfigAttrib(javax.microedition.khronos.egl.EGL10 javax.microedition.khronos.egl.EGLDisplay javax.microedition.khronos.egl.EGLConfig int int ), 0, this, eGL10, eGLDisplay, eGLConfig, n, n2);
        }

        public /* synthetic */ ComponentSizeChooser() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ComponentSizeChooser)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private abstract class BaseConfigChooser
    implements EGLConfigChooser,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        protected int[] mConfigSpec;
        /* synthetic */ GLSurfaceView this$0;

        private void $$robo$$android_opengl_GLSurfaceView_BaseConfigChooser$__constructor__(GLSurfaceView gLSurfaceView, int[] configSpec) {
            this.mConfigSpec = this.filterConfigSpec(configSpec);
        }

        private final EGLConfig $$robo$$android_opengl_GLSurfaceView_BaseConfigChooser$chooseConfig(EGL10 egl, EGLDisplay display) {
            int[] num_config = new int[1];
            if (!egl.eglChooseConfig(display, this.mConfigSpec, null, 0, num_config)) {
                throw new IllegalArgumentException("eglChooseConfig failed");
            }
            int numConfigs = num_config[0];
            if (numConfigs <= 0) {
                throw new IllegalArgumentException("No configs match configSpec");
            }
            EGLConfig[] configs = new EGLConfig[numConfigs];
            if (!egl.eglChooseConfig(display, this.mConfigSpec, configs, numConfigs, num_config)) {
                throw new IllegalArgumentException("eglChooseConfig#2 failed");
            }
            EGLConfig config = this.chooseConfig(egl, display, configs);
            if (config == null) {
                throw new IllegalArgumentException("No config chosen");
            }
            return config;
        }

        abstract EGLConfig chooseConfig(EGL10 var1, EGLDisplay var2, EGLConfig[] var3);

        private final int[] $$robo$$android_opengl_GLSurfaceView_BaseConfigChooser$filterConfigSpec(int[] configSpec) {
            if (this.this$0.mEGLContextClientVersion != 2 && this.this$0.mEGLContextClientVersion != 3) {
                return configSpec;
            }
            int len = configSpec.length;
            int[] newConfigSpec = new int[len + 2];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])configSpec, (int)0, (int[])newConfigSpec, (int)0, (int)(len - 1));
            newConfigSpec[len - 1] = 12352;
            newConfigSpec[len] = this.this$0.mEGLContextClientVersion == 2 ? 4 : 64;
            newConfigSpec[len + 1] = 12344;
            return newConfigSpec;
        }

        private void __constructor__(GLSurfaceView gLSurfaceView, int[] nArray) {
            this.$$robo$$android_opengl_GLSurfaceView_BaseConfigChooser$__constructor__(gLSurfaceView, nArray);
        }

        public BaseConfigChooser(GLSurfaceView gLSurfaceView, int[] nArray) {
            this.this$0 = gLSurfaceView;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_opengl_GLSurfaceView_BaseConfigChooser$__constructor__(android.opengl.GLSurfaceView int[] ), 0, this, gLSurfaceView, nArray);
        }

        @Override
        public EGLConfig chooseConfig(EGL10 eGL10, EGLDisplay eGLDisplay) {
            return InvokeDynamicSupport.bootstrap("chooseConfig", $$robo$$android_opengl_GLSurfaceView_BaseConfigChooser$chooseConfig(javax.microedition.khronos.egl.EGL10 javax.microedition.khronos.egl.EGLDisplay ), 0, this, eGL10, eGLDisplay);
        }

        private int[] filterConfigSpec(int[] nArray) {
            return InvokeDynamicSupport.bootstrap("filterConfigSpec", $$robo$$android_opengl_GLSurfaceView_BaseConfigChooser$filterConfigSpec(int[] ), 0, this, nArray);
        }

        public /* synthetic */ BaseConfigChooser() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BaseConfigChooser)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface EGLConfigChooser
    extends InstrumentedInterface {
        public EGLConfig chooseConfig(EGL10 var1, EGLDisplay var2);
    }

    private static class DefaultWindowSurfaceFactory
    implements EGLWindowSurfaceFactory,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_opengl_GLSurfaceView_DefaultWindowSurfaceFactory$__constructor__() {
        }

        private final EGLSurface $$robo$$android_opengl_GLSurfaceView_DefaultWindowSurfaceFactory$createWindowSurface(EGL10 egl, EGLDisplay display, EGLConfig config, Object nativeWindow) {
            EGLSurface result = null;
            try {
                result = egl.eglCreateWindowSurface(display, config, nativeWindow, null);
            }
            catch (IllegalArgumentException e) {
                Log.e("GLSurfaceView", "eglCreateWindowSurface", e);
            }
            return result;
        }

        private final void $$robo$$android_opengl_GLSurfaceView_DefaultWindowSurfaceFactory$destroySurface(EGL10 egl, EGLDisplay display, EGLSurface surface) {
            egl.eglDestroySurface(display, surface);
        }

        private /* synthetic */ void $$robo$$android_opengl_GLSurfaceView_DefaultWindowSurfaceFactory$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_opengl_GLSurfaceView_DefaultWindowSurfaceFactory$__constructor__();
        }

        private DefaultWindowSurfaceFactory() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_opengl_GLSurfaceView_DefaultWindowSurfaceFactory$__constructor__(), 0, this);
        }

        @Override
        public EGLSurface createWindowSurface(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig, Object object) {
            return InvokeDynamicSupport.bootstrap("createWindowSurface", $$robo$$android_opengl_GLSurfaceView_DefaultWindowSurfaceFactory$createWindowSurface(javax.microedition.khronos.egl.EGL10 javax.microedition.khronos.egl.EGLDisplay javax.microedition.khronos.egl.EGLConfig java.lang.Object ), 0, this, eGL10, eGLDisplay, eGLConfig, object);
        }

        @Override
        public void destroySurface(EGL10 eGL10, EGLDisplay eGLDisplay, EGLSurface eGLSurface) {
            InvokeDynamicSupport.bootstrap("destroySurface", $$robo$$android_opengl_GLSurfaceView_DefaultWindowSurfaceFactory$destroySurface(javax.microedition.khronos.egl.EGL10 javax.microedition.khronos.egl.EGLDisplay javax.microedition.khronos.egl.EGLSurface ), 0, this, eGL10, eGLDisplay, eGLSurface);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_opengl_GLSurfaceView_DefaultWindowSurfaceFactory$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DefaultWindowSurfaceFactory)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface EGLWindowSurfaceFactory
    extends InstrumentedInterface {
        public EGLSurface createWindowSurface(EGL10 var1, EGLDisplay var2, EGLConfig var3, Object var4);

        public void destroySurface(EGL10 var1, EGLDisplay var2, EGLSurface var3);
    }

    private class DefaultContextFactory
    implements EGLContextFactory,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int EGL_CONTEXT_CLIENT_VERSION;
        /* synthetic */ GLSurfaceView this$0;

        private void $$robo$$android_opengl_GLSurfaceView_DefaultContextFactory$__constructor__(GLSurfaceView gLSurfaceView) {
            this.EGL_CONTEXT_CLIENT_VERSION = 12440;
        }

        private final EGLContext $$robo$$android_opengl_GLSurfaceView_DefaultContextFactory$createContext(EGL10 egl, EGLDisplay display, EGLConfig config) {
            int[] attrib_list = new int[]{this.EGL_CONTEXT_CLIENT_VERSION, this.this$0.mEGLContextClientVersion, 12344};
            return egl.eglCreateContext(display, config, EGL10.EGL_NO_CONTEXT, (int[])(this.this$0.mEGLContextClientVersion != 0 ? attrib_list : null));
        }

        private final void $$robo$$android_opengl_GLSurfaceView_DefaultContextFactory$destroyContext(EGL10 egl, EGLDisplay display, EGLContext context) {
            if (!egl.eglDestroyContext(display, context)) {
                Log.e("DefaultContextFactory", "display:" + display + " context: " + context);
                EglHelper.throwEglException("eglDestroyContex", egl.eglGetError());
            }
        }

        private /* synthetic */ void $$robo$$android_opengl_GLSurfaceView_DefaultContextFactory$__constructor__(GLSurfaceView x0, 1 x1) {
        }

        private void __constructor__(GLSurfaceView gLSurfaceView) {
            this.$$robo$$android_opengl_GLSurfaceView_DefaultContextFactory$__constructor__(gLSurfaceView);
        }

        private DefaultContextFactory(GLSurfaceView gLSurfaceView) {
            this.this$0 = gLSurfaceView;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_opengl_GLSurfaceView_DefaultContextFactory$__constructor__(android.opengl.GLSurfaceView ), 0, this, gLSurfaceView);
        }

        @Override
        public EGLContext createContext(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig) {
            return InvokeDynamicSupport.bootstrap("createContext", $$robo$$android_opengl_GLSurfaceView_DefaultContextFactory$createContext(javax.microedition.khronos.egl.EGL10 javax.microedition.khronos.egl.EGLDisplay javax.microedition.khronos.egl.EGLConfig ), 0, this, eGL10, eGLDisplay, eGLConfig);
        }

        @Override
        public void destroyContext(EGL10 eGL10, EGLDisplay eGLDisplay, EGLContext eGLContext) {
            InvokeDynamicSupport.bootstrap("destroyContext", $$robo$$android_opengl_GLSurfaceView_DefaultContextFactory$destroyContext(javax.microedition.khronos.egl.EGL10 javax.microedition.khronos.egl.EGLDisplay javax.microedition.khronos.egl.EGLContext ), 0, this, eGL10, eGLDisplay, eGLContext);
        }

        private /* synthetic */ void __constructor__(GLSurfaceView gLSurfaceView, 1 var2_2) {
            this.$$robo$$android_opengl_GLSurfaceView_DefaultContextFactory$__constructor__(gLSurfaceView, var2_2);
        }

        public /* synthetic */ DefaultContextFactory() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DefaultContextFactory)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface EGLContextFactory
    extends InstrumentedInterface {
        public EGLContext createContext(EGL10 var1, EGLDisplay var2, EGLConfig var3);

        public void destroyContext(EGL10 var1, EGLDisplay var2, EGLContext var3);
    }

    public static interface Renderer
    extends InstrumentedInterface {
        public void onSurfaceCreated(GL10 var1, EGLConfig var2);

        public void onSurfaceChanged(GL10 var1, int var2, int var3);

        public void onDrawFrame(GL10 var1);
    }

    public static interface GLWrapper
    extends InstrumentedInterface {
        public GL wrap(GL var1);
    }
}

