/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Environment;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import com.android.internal.util.FastPrintWriter;
import com.android.internal.util.TypedProperties;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.bytecode.OpcodeInfo;
import dalvik.system.VMDebug;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import org.apache.harmony.dalvik.ddmc.Chunk;
import org.apache.harmony.dalvik.ddmc.ChunkHandler;
import org.apache.harmony.dalvik.ddmc.DdmServer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Debug
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "Debug";
    public static int TRACE_COUNT_ALLOCS = 1;
    public static int SHOW_FULL_DETAIL = 1;
    public static int SHOW_CLASSLOADER = 2;
    public static int SHOW_INITIALIZED = 4;
    private static volatile boolean mWaiting;
    private static int MIN_DEBUGGER_IDLE = 1300;
    private static int SPIN_DELAY = 200;
    private static String DEFAULT_TRACE_PATH_PREFIX;
    private static String DEFAULT_TRACE_BODY = "dmtrace";
    private static String DEFAULT_TRACE_EXTENSION = ".trace";
    private static String DEFAULT_TRACE_FILE_PATH;
    private static String SYSFS_QEMU_TRACE_STATE = "/sys/qemu_trace/state";
    public static int MEMINFO_TOTAL = 0;
    public static int MEMINFO_FREE = 1;
    public static int MEMINFO_BUFFERS = 2;
    public static int MEMINFO_CACHED = 3;
    public static int MEMINFO_SHMEM = 4;
    public static int MEMINFO_SLAB = 5;
    public static int MEMINFO_SWAP_TOTAL = 6;
    public static int MEMINFO_SWAP_FREE = 7;
    public static int MEMINFO_ZRAM_TOTAL = 8;
    public static int MEMINFO_COUNT = 9;
    private static TypedProperties debugProperties;

    private void $$robo$$android_os_Debug$__constructor__() {
    }

    private static final void $$robo$$android_os_Debug$waitForDebugger() {
        block9: {
            long delta;
            if (!VMDebug.isDebuggingEnabled()) {
                return;
            }
            if (Debug.isDebuggerConnected()) {
                return;
            }
            System.out.println("Sending WAIT chunk");
            byte[] data = new byte[]{0};
            Chunk waitChunk = new Chunk(ChunkHandler.type("WAIT"), data, 0, 1);
            DdmServer.sendChunk(waitChunk);
            mWaiting = true;
            while (!Debug.isDebuggerConnected()) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
            mWaiting = false;
            System.out.println("Debugger has connected");
            while (true) {
                if ((delta = VMDebug.lastDebuggerActivity()) < 0L) {
                    System.out.println("debugger detached?");
                    break block9;
                }
                if (delta >= 1300L) break;
                System.out.println("waiting for debugger to settle...");
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
            System.out.println("debugger has settled (" + delta + ")");
        }
    }

    private static final boolean $$robo$$android_os_Debug$waitingForDebugger() {
        return mWaiting;
    }

    private static final boolean $$robo$$android_os_Debug$isDebuggerConnected() {
        return VMDebug.isDebuggerConnected();
    }

    private static final String[] $$robo$$android_os_Debug$getVmFeatureList() {
        return VMDebug.getVmFeatureList();
    }

    @Deprecated
    private static final void $$robo$$android_os_Debug$changeDebugPort(int port) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_os_Debug$startNativeTracing() {
        try (PrintWriter outStream = null;){
            FileOutputStream fos = new FileOutputStream("/sys/qemu_trace/state");
            outStream = new FastPrintWriter(fos);
            outStream.println("1");
        }
        VMDebug.startEmulatorTracing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_os_Debug$stopNativeTracing() {
        VMDebug.stopEmulatorTracing();
        try (PrintWriter outStream = null;){
            FileOutputStream fos = new FileOutputStream("/sys/qemu_trace/state");
            outStream = new FastPrintWriter(fos);
            outStream.println("0");
        }
    }

    private static final void $$robo$$android_os_Debug$enableEmulatorTraceOutput() {
        VMDebug.startEmulatorTracing();
    }

    private static final void $$robo$$android_os_Debug$startMethodTracing() {
        VMDebug.startMethodTracing(DEFAULT_TRACE_FILE_PATH, 0, 0, false, 0);
    }

    private static final void $$robo$$android_os_Debug$startMethodTracing(String traceName) {
        Debug.startMethodTracing(traceName, 0, 0);
    }

    private static final void $$robo$$android_os_Debug$startMethodTracing(String traceName, int bufferSize) {
        Debug.startMethodTracing(traceName, bufferSize, 0);
    }

    private static final void $$robo$$android_os_Debug$startMethodTracing(String traceName, int bufferSize, int flags) {
        VMDebug.startMethodTracing(Debug.fixTraceName(traceName), bufferSize, flags, false, 0);
    }

    private static final void $$robo$$android_os_Debug$startMethodTracingSampling(String traceName, int bufferSize, int intervalUs) {
        VMDebug.startMethodTracing(Debug.fixTraceName(traceName), bufferSize, 0, true, intervalUs);
    }

    private static final String $$robo$$android_os_Debug$fixTraceName(String traceName) {
        if (traceName == null) {
            traceName = DEFAULT_TRACE_FILE_PATH;
        }
        if (traceName.charAt(0) != '/') {
            traceName = DEFAULT_TRACE_PATH_PREFIX + traceName;
        }
        if (!traceName.endsWith(".trace")) {
            traceName = traceName + ".trace";
        }
        return traceName;
    }

    private static final void $$robo$$android_os_Debug$startMethodTracing(String traceName, FileDescriptor fd, int bufferSize, int flags) {
        VMDebug.startMethodTracing(traceName, fd, bufferSize, flags, false, 0);
    }

    private static final void $$robo$$android_os_Debug$startMethodTracingDdms(int bufferSize, int flags, boolean samplingEnabled, int intervalUs) {
        VMDebug.startMethodTracingDdms(bufferSize, flags, samplingEnabled, intervalUs);
    }

    private static final int $$robo$$android_os_Debug$getMethodTracingMode() {
        return VMDebug.getMethodTracingMode();
    }

    private static final void $$robo$$android_os_Debug$stopMethodTracing() {
        VMDebug.stopMethodTracing();
    }

    private static final long $$robo$$android_os_Debug$threadCpuTimeNanos() {
        return VMDebug.threadCpuTimeNanos();
    }

    @Deprecated
    private static final void $$robo$$android_os_Debug$startAllocCounting() {
        VMDebug.startAllocCounting();
    }

    @Deprecated
    private static final void $$robo$$android_os_Debug$stopAllocCounting() {
        VMDebug.stopAllocCounting();
    }

    private static final int $$robo$$android_os_Debug$getGlobalAllocCount() {
        return VMDebug.getAllocCount(1);
    }

    private static final void $$robo$$android_os_Debug$resetGlobalAllocCount() {
        VMDebug.resetAllocCount(1);
    }

    private static final int $$robo$$android_os_Debug$getGlobalAllocSize() {
        return VMDebug.getAllocCount(2);
    }

    private static final void $$robo$$android_os_Debug$resetGlobalAllocSize() {
        VMDebug.resetAllocCount(2);
    }

    private static final int $$robo$$android_os_Debug$getGlobalFreedCount() {
        return VMDebug.getAllocCount(4);
    }

    private static final void $$robo$$android_os_Debug$resetGlobalFreedCount() {
        VMDebug.resetAllocCount(4);
    }

    private static final int $$robo$$android_os_Debug$getGlobalFreedSize() {
        return VMDebug.getAllocCount(8);
    }

    private static final void $$robo$$android_os_Debug$resetGlobalFreedSize() {
        VMDebug.resetAllocCount(8);
    }

    private static final int $$robo$$android_os_Debug$getGlobalGcInvocationCount() {
        return VMDebug.getAllocCount(16);
    }

    private static final void $$robo$$android_os_Debug$resetGlobalGcInvocationCount() {
        VMDebug.resetAllocCount(16);
    }

    private static final int $$robo$$android_os_Debug$getGlobalClassInitCount() {
        return VMDebug.getAllocCount(32);
    }

    private static final void $$robo$$android_os_Debug$resetGlobalClassInitCount() {
        VMDebug.resetAllocCount(32);
    }

    private static final int $$robo$$android_os_Debug$getGlobalClassInitTime() {
        return VMDebug.getAllocCount(64);
    }

    private static final void $$robo$$android_os_Debug$resetGlobalClassInitTime() {
        VMDebug.resetAllocCount(64);
    }

    @Deprecated
    private static final int $$robo$$android_os_Debug$getGlobalExternalAllocCount() {
        return 0;
    }

    @Deprecated
    private static final void $$robo$$android_os_Debug$resetGlobalExternalAllocSize() {
    }

    @Deprecated
    private static final void $$robo$$android_os_Debug$resetGlobalExternalAllocCount() {
    }

    @Deprecated
    private static final int $$robo$$android_os_Debug$getGlobalExternalAllocSize() {
        return 0;
    }

    @Deprecated
    private static final int $$robo$$android_os_Debug$getGlobalExternalFreedCount() {
        return 0;
    }

    @Deprecated
    private static final void $$robo$$android_os_Debug$resetGlobalExternalFreedCount() {
    }

    @Deprecated
    private static final int $$robo$$android_os_Debug$getGlobalExternalFreedSize() {
        return 0;
    }

    @Deprecated
    private static final void $$robo$$android_os_Debug$resetGlobalExternalFreedSize() {
    }

    private static final int $$robo$$android_os_Debug$getThreadAllocCount() {
        return VMDebug.getAllocCount(65536);
    }

    private static final void $$robo$$android_os_Debug$resetThreadAllocCount() {
        VMDebug.resetAllocCount(65536);
    }

    private static final int $$robo$$android_os_Debug$getThreadAllocSize() {
        return VMDebug.getAllocCount(131072);
    }

    private static final void $$robo$$android_os_Debug$resetThreadAllocSize() {
        VMDebug.resetAllocCount(131072);
    }

    @Deprecated
    private static final int $$robo$$android_os_Debug$getThreadExternalAllocCount() {
        return 0;
    }

    @Deprecated
    private static final void $$robo$$android_os_Debug$resetThreadExternalAllocCount() {
    }

    @Deprecated
    private static final int $$robo$$android_os_Debug$getThreadExternalAllocSize() {
        return 0;
    }

    @Deprecated
    private static final void $$robo$$android_os_Debug$resetThreadExternalAllocSize() {
    }

    private static final int $$robo$$android_os_Debug$getThreadGcInvocationCount() {
        return VMDebug.getAllocCount(0x100000);
    }

    private static final void $$robo$$android_os_Debug$resetThreadGcInvocationCount() {
        VMDebug.resetAllocCount(0x100000);
    }

    private static final void $$robo$$android_os_Debug$resetAllCounts() {
        VMDebug.resetAllocCount(-1);
    }

    private static final long $$robo$$android_os_Debug$getNativeHeapSize() {
        return 0L;
    }

    private static final long $$robo$$android_os_Debug$getNativeHeapAllocatedSize() {
        return 0L;
    }

    private static final long $$robo$$android_os_Debug$getNativeHeapFreeSize() {
        return 0L;
    }

    private static final void $$robo$$android_os_Debug$getMemoryInfo(MemoryInfo memoryInfo) {
    }

    private static final void $$robo$$android_os_Debug$getMemoryInfo(int n, MemoryInfo memoryInfo) {
    }

    private static final long $$robo$$android_os_Debug$getPss() {
        return 0L;
    }

    private static final long $$robo$$android_os_Debug$getPss(int n, long[] lArray) {
        return 0L;
    }

    private static final void $$robo$$android_os_Debug$getMemInfo(long[] lArray) {
    }

    @Deprecated
    private static final int $$robo$$android_os_Debug$setAllocationLimit(int limit) {
        return -1;
    }

    @Deprecated
    private static final int $$robo$$android_os_Debug$setGlobalAllocationLimit(int limit) {
        return -1;
    }

    private static final void $$robo$$android_os_Debug$printLoadedClasses(int flags) {
        VMDebug.printLoadedClasses(flags);
    }

    private static final int $$robo$$android_os_Debug$getLoadedClassCount() {
        return VMDebug.getLoadedClassCount();
    }

    private static final void $$robo$$android_os_Debug$dumpHprofData(String fileName) throws IOException {
        VMDebug.dumpHprofData(fileName);
    }

    private static final void $$robo$$android_os_Debug$dumpHprofData(String fileName, FileDescriptor fd) throws IOException {
        VMDebug.dumpHprofData(fileName, fd);
    }

    private static final void $$robo$$android_os_Debug$dumpHprofDataDdms() {
        VMDebug.dumpHprofDataDdms();
    }

    private static final void $$robo$$android_os_Debug$dumpNativeHeap(FileDescriptor fileDescriptor) {
    }

    private static final long $$robo$$android_os_Debug$countInstancesOfClass(Class cls) {
        return VMDebug.countInstancesOfClass(cls, true);
    }

    private static final int $$robo$$android_os_Debug$getBinderSentTransactions() {
        return 0;
    }

    private static final int $$robo$$android_os_Debug$getBinderReceivedTransactions() {
        return 0;
    }

    private static final int $$robo$$android_os_Debug$getBinderLocalObjectCount() {
        return 0;
    }

    private static final int $$robo$$android_os_Debug$getBinderProxyObjectCount() {
        return 0;
    }

    private static final int $$robo$$android_os_Debug$getBinderDeathObjectCount() {
        return 0;
    }

    private static final boolean $$robo$$android_os_Debug$cacheRegisterMap(String classAndMethodDesc) {
        return VMDebug.cacheRegisterMap(classAndMethodDesc);
    }

    private static final void $$robo$$android_os_Debug$dumpReferenceTables() {
        VMDebug.dumpReferenceTables();
    }

    private static final boolean $$robo$$android_os_Debug$fieldTypeMatches(Field field, Class<?> cl) {
        Field primitiveTypeField;
        Class<?> fieldClass = field.getType();
        if (fieldClass == cl) {
            return true;
        }
        try {
            primitiveTypeField = cl.getField("TYPE");
        }
        catch (NoSuchFieldException ex) {
            return false;
        }
        try {
            return fieldClass == (Class)primitiveTypeField.get(null);
        }
        catch (IllegalAccessException ex) {
            return false;
        }
    }

    private static final void $$robo$$android_os_Debug$modifyFieldIfSet(Field field, TypedProperties properties, String propertyName) {
        Object value;
        if (field.getType() == String.class) {
            int stringInfo = properties.getStringInfo(propertyName);
            switch (stringInfo) {
                case 1: {
                    break;
                }
                case 0: {
                    try {
                        field.set(null, null);
                    }
                    catch (IllegalAccessException ex) {
                        throw new IllegalArgumentException("Cannot set field for " + propertyName, ex);
                    }
                    return;
                }
                case -1: {
                    return;
                }
                case -2: {
                    throw new IllegalArgumentException("Type of " + propertyName + " " + " does not match field type (" + field.getType() + ")");
                }
                default: {
                    throw new IllegalStateException("Unexpected getStringInfo(" + propertyName + ") return value " + stringInfo);
                }
            }
        }
        if ((value = properties.get(propertyName)) != null) {
            if (!Debug.fieldTypeMatches(field, value.getClass())) {
                throw new IllegalArgumentException("Type of " + propertyName + " (" + value.getClass() + ") " + " does not match field type (" + field.getType() + ")");
            }
            try {
                field.set(null, value);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalArgumentException("Cannot set field for " + propertyName, ex);
            }
        }
    }

    private static final void $$robo$$android_os_Debug$setFieldsOn(Class<?> cl) {
        Debug.setFieldsOn(cl, false);
    }

    private static final void $$robo$$android_os_Debug$setFieldsOn(Class<?> cl, boolean partial) {
        Log.wtf("Debug", "setFieldsOn(" + (cl == null ? "null" : cl.getName()) + ") called in non-DEBUG build");
    }

    private static final boolean $$robo$$android_os_Debug$dumpService(String name, FileDescriptor fd, String[] args) {
        IBinder service = ServiceManager.getService(name);
        if (service == null) {
            Log.e("Debug", "Can't find service to dump: " + name);
            return false;
        }
        try {
            service.dump(fd, args);
            return true;
        }
        catch (RemoteException e) {
            Log.e("Debug", "Can't dump service: " + name, e);
            return false;
        }
    }

    private static final void $$robo$$android_os_Debug$dumpNativeBacktraceToFile(int n, String string2) {
    }

    private static final String $$robo$$android_os_Debug$getCaller(StackTraceElement[] callStack, int depth) {
        if (4 + depth >= callStack.length) {
            return "<bottom of call stack>";
        }
        StackTraceElement caller = callStack[4 + depth];
        return caller.getClassName() + "." + caller.getMethodName() + ":" + caller.getLineNumber();
    }

    private static final String $$robo$$android_os_Debug$getCallers(int depth) {
        StackTraceElement[] callStack = Thread.currentThread().getStackTrace();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            sb.append(Debug.getCaller(callStack, i)).append(" ");
        }
        return sb.toString();
    }

    private static final String $$robo$$android_os_Debug$getCallers(int start, int depth) {
        StackTraceElement[] callStack = Thread.currentThread().getStackTrace();
        StringBuffer sb = new StringBuffer();
        depth += start;
        for (int i = start; i < depth; ++i) {
            sb.append(Debug.getCaller(callStack, i)).append(" ");
        }
        return sb.toString();
    }

    private static final String $$robo$$android_os_Debug$getCallers(int depth, String linePrefix) {
        StackTraceElement[] callStack = Thread.currentThread().getStackTrace();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            sb.append(linePrefix).append(Debug.getCaller(callStack, i)).append("\n");
        }
        return sb.toString();
    }

    private static final String $$robo$$android_os_Debug$getCaller() {
        return Debug.getCaller(Thread.currentThread().getStackTrace(), 0);
    }

    static void __staticInitializer__() {
        mWaiting = false;
        DEFAULT_TRACE_PATH_PREFIX = Environment.getLegacyExternalStorageDirectory().getPath() + "/";
        DEFAULT_TRACE_FILE_PATH = DEFAULT_TRACE_PATH_PREFIX + "dmtrace" + ".trace";
        debugProperties = null;
    }

    private void __constructor__() {
        this.$$robo$$android_os_Debug$__constructor__();
    }

    private Debug() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_Debug$__constructor__(), 0, this);
    }

    public static void waitForDebugger() {
        InvokeDynamicSupport.bootstrapStatic("waitForDebugger", $$robo$$android_os_Debug$waitForDebugger(), 0);
    }

    public static boolean waitingForDebugger() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("waitingForDebugger", $$robo$$android_os_Debug$waitingForDebugger(), 0);
    }

    public static boolean isDebuggerConnected() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isDebuggerConnected", $$robo$$android_os_Debug$isDebuggerConnected(), 0);
    }

    public static String[] getVmFeatureList() {
        return InvokeDynamicSupport.bootstrapStatic("getVmFeatureList", $$robo$$android_os_Debug$getVmFeatureList(), 0);
    }

    @Deprecated
    public static void changeDebugPort(int n) {
        InvokeDynamicSupport.bootstrapStatic("changeDebugPort", $$robo$$android_os_Debug$changeDebugPort(int ), 0, (int)n);
    }

    public static void startNativeTracing() {
        InvokeDynamicSupport.bootstrapStatic("startNativeTracing", $$robo$$android_os_Debug$startNativeTracing(), 0);
    }

    public static void stopNativeTracing() {
        InvokeDynamicSupport.bootstrapStatic("stopNativeTracing", $$robo$$android_os_Debug$stopNativeTracing(), 0);
    }

    public static void enableEmulatorTraceOutput() {
        InvokeDynamicSupport.bootstrapStatic("enableEmulatorTraceOutput", $$robo$$android_os_Debug$enableEmulatorTraceOutput(), 0);
    }

    public static void startMethodTracing() {
        InvokeDynamicSupport.bootstrapStatic("startMethodTracing", $$robo$$android_os_Debug$startMethodTracing(), 0);
    }

    public static void startMethodTracing(String string2) {
        InvokeDynamicSupport.bootstrapStatic("startMethodTracing", $$robo$$android_os_Debug$startMethodTracing(java.lang.String ), 0, (String)string2);
    }

    public static void startMethodTracing(String string2, int n) {
        InvokeDynamicSupport.bootstrapStatic("startMethodTracing", $$robo$$android_os_Debug$startMethodTracing(java.lang.String int ), 0, (String)string2, (int)n);
    }

    public static void startMethodTracing(String string2, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("startMethodTracing", $$robo$$android_os_Debug$startMethodTracing(java.lang.String int int ), 0, (String)string2, (int)n, (int)n2);
    }

    public static void startMethodTracingSampling(String string2, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("startMethodTracingSampling", $$robo$$android_os_Debug$startMethodTracingSampling(java.lang.String int int ), 0, (String)string2, (int)n, (int)n2);
    }

    private static String fixTraceName(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("fixTraceName", $$robo$$android_os_Debug$fixTraceName(java.lang.String ), 0, (String)string2);
    }

    public static void startMethodTracing(String string2, FileDescriptor fileDescriptor, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("startMethodTracing", $$robo$$android_os_Debug$startMethodTracing(java.lang.String java.io.FileDescriptor int int ), 0, (String)string2, (FileDescriptor)fileDescriptor, (int)n, (int)n2);
    }

    public static void startMethodTracingDdms(int n, int n2, boolean bl, int n3) {
        InvokeDynamicSupport.bootstrapStatic("startMethodTracingDdms", $$robo$$android_os_Debug$startMethodTracingDdms(int int boolean int ), 0, (int)n, (int)n2, (boolean)bl, (int)n3);
    }

    public static int getMethodTracingMode() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getMethodTracingMode", $$robo$$android_os_Debug$getMethodTracingMode(), 0);
    }

    public static void stopMethodTracing() {
        InvokeDynamicSupport.bootstrapStatic("stopMethodTracing", $$robo$$android_os_Debug$stopMethodTracing(), 0);
    }

    public static long threadCpuTimeNanos() {
        return (long)InvokeDynamicSupport.bootstrapStatic("threadCpuTimeNanos", $$robo$$android_os_Debug$threadCpuTimeNanos(), 0);
    }

    @Deprecated
    public static void startAllocCounting() {
        InvokeDynamicSupport.bootstrapStatic("startAllocCounting", $$robo$$android_os_Debug$startAllocCounting(), 0);
    }

    @Deprecated
    public static void stopAllocCounting() {
        InvokeDynamicSupport.bootstrapStatic("stopAllocCounting", $$robo$$android_os_Debug$stopAllocCounting(), 0);
    }

    public static int getGlobalAllocCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getGlobalAllocCount", $$robo$$android_os_Debug$getGlobalAllocCount(), 0);
    }

    public static void resetGlobalAllocCount() {
        InvokeDynamicSupport.bootstrapStatic("resetGlobalAllocCount", $$robo$$android_os_Debug$resetGlobalAllocCount(), 0);
    }

    public static int getGlobalAllocSize() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getGlobalAllocSize", $$robo$$android_os_Debug$getGlobalAllocSize(), 0);
    }

    public static void resetGlobalAllocSize() {
        InvokeDynamicSupport.bootstrapStatic("resetGlobalAllocSize", $$robo$$android_os_Debug$resetGlobalAllocSize(), 0);
    }

    public static int getGlobalFreedCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getGlobalFreedCount", $$robo$$android_os_Debug$getGlobalFreedCount(), 0);
    }

    public static void resetGlobalFreedCount() {
        InvokeDynamicSupport.bootstrapStatic("resetGlobalFreedCount", $$robo$$android_os_Debug$resetGlobalFreedCount(), 0);
    }

    public static int getGlobalFreedSize() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getGlobalFreedSize", $$robo$$android_os_Debug$getGlobalFreedSize(), 0);
    }

    public static void resetGlobalFreedSize() {
        InvokeDynamicSupport.bootstrapStatic("resetGlobalFreedSize", $$robo$$android_os_Debug$resetGlobalFreedSize(), 0);
    }

    public static int getGlobalGcInvocationCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getGlobalGcInvocationCount", $$robo$$android_os_Debug$getGlobalGcInvocationCount(), 0);
    }

    public static void resetGlobalGcInvocationCount() {
        InvokeDynamicSupport.bootstrapStatic("resetGlobalGcInvocationCount", $$robo$$android_os_Debug$resetGlobalGcInvocationCount(), 0);
    }

    public static int getGlobalClassInitCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getGlobalClassInitCount", $$robo$$android_os_Debug$getGlobalClassInitCount(), 0);
    }

    public static void resetGlobalClassInitCount() {
        InvokeDynamicSupport.bootstrapStatic("resetGlobalClassInitCount", $$robo$$android_os_Debug$resetGlobalClassInitCount(), 0);
    }

    public static int getGlobalClassInitTime() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getGlobalClassInitTime", $$robo$$android_os_Debug$getGlobalClassInitTime(), 0);
    }

    public static void resetGlobalClassInitTime() {
        InvokeDynamicSupport.bootstrapStatic("resetGlobalClassInitTime", $$robo$$android_os_Debug$resetGlobalClassInitTime(), 0);
    }

    @Deprecated
    public static int getGlobalExternalAllocCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getGlobalExternalAllocCount", $$robo$$android_os_Debug$getGlobalExternalAllocCount(), 0);
    }

    @Deprecated
    public static void resetGlobalExternalAllocSize() {
        InvokeDynamicSupport.bootstrapStatic("resetGlobalExternalAllocSize", $$robo$$android_os_Debug$resetGlobalExternalAllocSize(), 0);
    }

    @Deprecated
    public static void resetGlobalExternalAllocCount() {
        InvokeDynamicSupport.bootstrapStatic("resetGlobalExternalAllocCount", $$robo$$android_os_Debug$resetGlobalExternalAllocCount(), 0);
    }

    @Deprecated
    public static int getGlobalExternalAllocSize() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getGlobalExternalAllocSize", $$robo$$android_os_Debug$getGlobalExternalAllocSize(), 0);
    }

    @Deprecated
    public static int getGlobalExternalFreedCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getGlobalExternalFreedCount", $$robo$$android_os_Debug$getGlobalExternalFreedCount(), 0);
    }

    @Deprecated
    public static void resetGlobalExternalFreedCount() {
        InvokeDynamicSupport.bootstrapStatic("resetGlobalExternalFreedCount", $$robo$$android_os_Debug$resetGlobalExternalFreedCount(), 0);
    }

    @Deprecated
    public static int getGlobalExternalFreedSize() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getGlobalExternalFreedSize", $$robo$$android_os_Debug$getGlobalExternalFreedSize(), 0);
    }

    @Deprecated
    public static void resetGlobalExternalFreedSize() {
        InvokeDynamicSupport.bootstrapStatic("resetGlobalExternalFreedSize", $$robo$$android_os_Debug$resetGlobalExternalFreedSize(), 0);
    }

    public static int getThreadAllocCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getThreadAllocCount", $$robo$$android_os_Debug$getThreadAllocCount(), 0);
    }

    public static void resetThreadAllocCount() {
        InvokeDynamicSupport.bootstrapStatic("resetThreadAllocCount", $$robo$$android_os_Debug$resetThreadAllocCount(), 0);
    }

    public static int getThreadAllocSize() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getThreadAllocSize", $$robo$$android_os_Debug$getThreadAllocSize(), 0);
    }

    public static void resetThreadAllocSize() {
        InvokeDynamicSupport.bootstrapStatic("resetThreadAllocSize", $$robo$$android_os_Debug$resetThreadAllocSize(), 0);
    }

    @Deprecated
    public static int getThreadExternalAllocCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getThreadExternalAllocCount", $$robo$$android_os_Debug$getThreadExternalAllocCount(), 0);
    }

    @Deprecated
    public static void resetThreadExternalAllocCount() {
        InvokeDynamicSupport.bootstrapStatic("resetThreadExternalAllocCount", $$robo$$android_os_Debug$resetThreadExternalAllocCount(), 0);
    }

    @Deprecated
    public static int getThreadExternalAllocSize() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getThreadExternalAllocSize", $$robo$$android_os_Debug$getThreadExternalAllocSize(), 0);
    }

    @Deprecated
    public static void resetThreadExternalAllocSize() {
        InvokeDynamicSupport.bootstrapStatic("resetThreadExternalAllocSize", $$robo$$android_os_Debug$resetThreadExternalAllocSize(), 0);
    }

    public static int getThreadGcInvocationCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getThreadGcInvocationCount", $$robo$$android_os_Debug$getThreadGcInvocationCount(), 0);
    }

    public static void resetThreadGcInvocationCount() {
        InvokeDynamicSupport.bootstrapStatic("resetThreadGcInvocationCount", $$robo$$android_os_Debug$resetThreadGcInvocationCount(), 0);
    }

    public static void resetAllCounts() {
        InvokeDynamicSupport.bootstrapStatic("resetAllCounts", $$robo$$android_os_Debug$resetAllCounts(), 0);
    }

    private static final native /* synthetic */ long $$robo$$getNativeHeapSize$nativeBinding();

    public static long getNativeHeapSize() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getNativeHeapSize", $$robo$$android_os_Debug$getNativeHeapSize(), 1);
    }

    private static final native /* synthetic */ long $$robo$$getNativeHeapAllocatedSize$nativeBinding();

    public static long getNativeHeapAllocatedSize() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getNativeHeapAllocatedSize", $$robo$$android_os_Debug$getNativeHeapAllocatedSize(), 1);
    }

    private static final native /* synthetic */ long $$robo$$getNativeHeapFreeSize$nativeBinding();

    public static long getNativeHeapFreeSize() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getNativeHeapFreeSize", $$robo$$android_os_Debug$getNativeHeapFreeSize(), 1);
    }

    private static final native /* synthetic */ void $$robo$$getMemoryInfo$nativeBinding(MemoryInfo var0);

    public static void getMemoryInfo(MemoryInfo memoryInfo) {
        InvokeDynamicSupport.bootstrapStatic("getMemoryInfo", $$robo$$android_os_Debug$getMemoryInfo(android.os.Debug$MemoryInfo ), 1, (MemoryInfo)memoryInfo);
    }

    private static final native /* synthetic */ void $$robo$$getMemoryInfo$nativeBinding(int var0, MemoryInfo var1);

    public static void getMemoryInfo(int n, MemoryInfo memoryInfo) {
        InvokeDynamicSupport.bootstrapStatic("getMemoryInfo", $$robo$$android_os_Debug$getMemoryInfo(int android.os.Debug$MemoryInfo ), 1, (int)n, (MemoryInfo)memoryInfo);
    }

    private static final native /* synthetic */ long $$robo$$getPss$nativeBinding();

    public static long getPss() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getPss", $$robo$$android_os_Debug$getPss(), 1);
    }

    private static final native /* synthetic */ long $$robo$$getPss$nativeBinding(int var0, long[] var1);

    public static long getPss(int n, long[] lArray) {
        return (long)InvokeDynamicSupport.bootstrapStatic("getPss", $$robo$$android_os_Debug$getPss(int long[] ), 1, (int)n, (long[])lArray);
    }

    private static final native /* synthetic */ void $$robo$$getMemInfo$nativeBinding(long[] var0);

    public static void getMemInfo(long[] lArray) {
        InvokeDynamicSupport.bootstrapStatic("getMemInfo", $$robo$$android_os_Debug$getMemInfo(long[] ), 1, (long[])lArray);
    }

    @Deprecated
    public static int setAllocationLimit(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("setAllocationLimit", $$robo$$android_os_Debug$setAllocationLimit(int ), 0, (int)n);
    }

    @Deprecated
    public static int setGlobalAllocationLimit(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("setGlobalAllocationLimit", $$robo$$android_os_Debug$setGlobalAllocationLimit(int ), 0, (int)n);
    }

    public static void printLoadedClasses(int n) {
        InvokeDynamicSupport.bootstrapStatic("printLoadedClasses", $$robo$$android_os_Debug$printLoadedClasses(int ), 0, (int)n);
    }

    public static int getLoadedClassCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getLoadedClassCount", $$robo$$android_os_Debug$getLoadedClassCount(), 0);
    }

    public static void dumpHprofData(String string2) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("dumpHprofData", $$robo$$android_os_Debug$dumpHprofData(java.lang.String ), 0, (String)string2);
    }

    public static void dumpHprofData(String string2, FileDescriptor fileDescriptor) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("dumpHprofData", $$robo$$android_os_Debug$dumpHprofData(java.lang.String java.io.FileDescriptor ), 0, (String)string2, (FileDescriptor)fileDescriptor);
    }

    public static void dumpHprofDataDdms() {
        InvokeDynamicSupport.bootstrapStatic("dumpHprofDataDdms", $$robo$$android_os_Debug$dumpHprofDataDdms(), 0);
    }

    private static final native /* synthetic */ void $$robo$$dumpNativeHeap$nativeBinding(FileDescriptor var0);

    public static void dumpNativeHeap(FileDescriptor fileDescriptor) {
        InvokeDynamicSupport.bootstrapStatic("dumpNativeHeap", $$robo$$android_os_Debug$dumpNativeHeap(java.io.FileDescriptor ), 1, (FileDescriptor)fileDescriptor);
    }

    public static long countInstancesOfClass(Class clazz) {
        return (long)InvokeDynamicSupport.bootstrapStatic("countInstancesOfClass", $$robo$$android_os_Debug$countInstancesOfClass(java.lang.Class ), 0, (Class)clazz);
    }

    private static final native /* synthetic */ int $$robo$$getBinderSentTransactions$nativeBinding();

    public static int getBinderSentTransactions() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getBinderSentTransactions", $$robo$$android_os_Debug$getBinderSentTransactions(), 1);
    }

    private static final native /* synthetic */ int $$robo$$getBinderReceivedTransactions$nativeBinding();

    public static int getBinderReceivedTransactions() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getBinderReceivedTransactions", $$robo$$android_os_Debug$getBinderReceivedTransactions(), 1);
    }

    private static final native /* synthetic */ int $$robo$$getBinderLocalObjectCount$nativeBinding();

    public static int getBinderLocalObjectCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getBinderLocalObjectCount", $$robo$$android_os_Debug$getBinderLocalObjectCount(), 1);
    }

    private static final native /* synthetic */ int $$robo$$getBinderProxyObjectCount$nativeBinding();

    public static int getBinderProxyObjectCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getBinderProxyObjectCount", $$robo$$android_os_Debug$getBinderProxyObjectCount(), 1);
    }

    private static final native /* synthetic */ int $$robo$$getBinderDeathObjectCount$nativeBinding();

    public static int getBinderDeathObjectCount() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getBinderDeathObjectCount", $$robo$$android_os_Debug$getBinderDeathObjectCount(), 1);
    }

    public static boolean cacheRegisterMap(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("cacheRegisterMap", $$robo$$android_os_Debug$cacheRegisterMap(java.lang.String ), 0, (String)string2);
    }

    public static void dumpReferenceTables() {
        InvokeDynamicSupport.bootstrapStatic("dumpReferenceTables", $$robo$$android_os_Debug$dumpReferenceTables(), 0);
    }

    private static boolean fieldTypeMatches(Field field, Class<?> clazz) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("fieldTypeMatches", $$robo$$android_os_Debug$fieldTypeMatches(java.lang.reflect.Field java.lang.Class<?> ), 0, (Field)field, clazz);
    }

    private static void modifyFieldIfSet(Field field, TypedProperties typedProperties, String string2) {
        InvokeDynamicSupport.bootstrapStatic("modifyFieldIfSet", $$robo$$android_os_Debug$modifyFieldIfSet(java.lang.reflect.Field com.android.internal.util.TypedProperties java.lang.String ), 0, (Field)field, (TypedProperties)typedProperties, (String)string2);
    }

    public static void setFieldsOn(Class<?> clazz) {
        InvokeDynamicSupport.bootstrapStatic("setFieldsOn", $$robo$$android_os_Debug$setFieldsOn(java.lang.Class<?> ), 0, clazz);
    }

    public static void setFieldsOn(Class<?> clazz, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("setFieldsOn", $$robo$$android_os_Debug$setFieldsOn(java.lang.Class<?> boolean ), 0, clazz, (boolean)bl);
    }

    public static boolean dumpService(String string2, FileDescriptor fileDescriptor, String[] stringArray) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("dumpService", $$robo$$android_os_Debug$dumpService(java.lang.String java.io.FileDescriptor java.lang.String[] ), 0, (String)string2, (FileDescriptor)fileDescriptor, (String[])stringArray);
    }

    private static final native /* synthetic */ void $$robo$$dumpNativeBacktraceToFile$nativeBinding(int var0, String var1);

    public static void dumpNativeBacktraceToFile(int n, String string2) {
        InvokeDynamicSupport.bootstrapStatic("dumpNativeBacktraceToFile", $$robo$$android_os_Debug$dumpNativeBacktraceToFile(int java.lang.String ), 1, (int)n, (String)string2);
    }

    private static String getCaller(StackTraceElement[] stackTraceElementArray, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getCaller", $$robo$$android_os_Debug$getCaller(java.lang.StackTraceElement[] int ), 0, (StackTraceElement[])stackTraceElementArray, (int)n);
    }

    public static String getCallers(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getCallers", $$robo$$android_os_Debug$getCallers(int ), 0, (int)n);
    }

    public static String getCallers(int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("getCallers", $$robo$$android_os_Debug$getCallers(int int ), 0, (int)n, (int)n2);
    }

    public static String getCallers(int n, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getCallers", $$robo$$android_os_Debug$getCallers(int java.lang.String ), 0, (int)n, (String)string2);
    }

    public static String getCaller() {
        return InvokeDynamicSupport.bootstrapStatic("getCaller", $$robo$$android_os_Debug$getCaller(), 0);
    }

    static {
        RobolectricInternals.classInitializing(Debug.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Debug)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface DebugProperty {
    }

    public static class InstructionCount
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int NUM_INSTR;
        private int[] mCounts;

        private void $$robo$$android_os_Debug_InstructionCount$__constructor__() {
            this.mCounts = new int[NUM_INSTR];
        }

        private final boolean $$robo$$android_os_Debug_InstructionCount$resetAndStart() {
            try {
                VMDebug.startInstructionCounting();
                VMDebug.resetInstructionCount();
            }
            catch (UnsupportedOperationException uoe) {
                return false;
            }
            return true;
        }

        private final boolean $$robo$$android_os_Debug_InstructionCount$collect() {
            try {
                VMDebug.stopInstructionCounting();
                VMDebug.getInstructionCount(this.mCounts);
            }
            catch (UnsupportedOperationException uoe) {
                return false;
            }
            return true;
        }

        private final int $$robo$$android_os_Debug_InstructionCount$globalTotal() {
            int count = 0;
            for (int i = 0; i < NUM_INSTR; ++i) {
                count += this.mCounts[i];
            }
            return count;
        }

        private final int $$robo$$android_os_Debug_InstructionCount$globalMethodInvocations() {
            int count = 0;
            for (int i = 0; i < NUM_INSTR; ++i) {
                if (!OpcodeInfo.isInvoke(i)) continue;
                count += this.mCounts[i];
            }
            return count;
        }

        static void __staticInitializer__() {
            NUM_INSTR = OpcodeInfo.MAXIMUM_PACKED_VALUE + 1;
        }

        private void __constructor__() {
            this.$$robo$$android_os_Debug_InstructionCount$__constructor__();
        }

        public InstructionCount() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_Debug_InstructionCount$__constructor__(), 0, this);
        }

        public boolean resetAndStart() {
            return (boolean)InvokeDynamicSupport.bootstrap("resetAndStart", $$robo$$android_os_Debug_InstructionCount$resetAndStart(), 0, this);
        }

        public boolean collect() {
            return (boolean)InvokeDynamicSupport.bootstrap("collect", $$robo$$android_os_Debug_InstructionCount$collect(), 0, this);
        }

        public int globalTotal() {
            return (int)InvokeDynamicSupport.bootstrap("globalTotal", $$robo$$android_os_Debug_InstructionCount$globalTotal(), 0, this);
        }

        public int globalMethodInvocations() {
            return (int)InvokeDynamicSupport.bootstrap("globalMethodInvocations", $$robo$$android_os_Debug_InstructionCount$globalMethodInvocations(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(InstructionCount.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InstructionCount)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class MemoryInfo
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int dalvikPss;
        public int dalvikSwappablePss;
        public int dalvikPrivateDirty;
        public int dalvikSharedDirty;
        public int dalvikPrivateClean;
        public int dalvikSharedClean;
        public int dalvikSwappedOut;
        public int nativePss;
        public int nativeSwappablePss;
        public int nativePrivateDirty;
        public int nativeSharedDirty;
        public int nativePrivateClean;
        public int nativeSharedClean;
        public int nativeSwappedOut;
        public int otherPss;
        public int otherSwappablePss;
        public int otherPrivateDirty;
        public int otherSharedDirty;
        public int otherPrivateClean;
        public int otherSharedClean;
        public int otherSwappedOut;
        public static int NUM_OTHER_STATS = 16;
        public static int NUM_DVK_STATS = 5;
        public static int NUM_CATEGORIES = 7;
        public static int offsetPss = 0;
        public static int offsetSwappablePss = 1;
        public static int offsetPrivateDirty = 2;
        public static int offsetSharedDirty = 3;
        public static int offsetPrivateClean = 4;
        public static int offsetSharedClean = 5;
        public static int offsetSwappedOut = 6;
        private int[] otherStats;
        public static Parcelable.Creator<MemoryInfo> CREATOR;

        private void $$robo$$android_os_Debug_MemoryInfo$__constructor__() {
            this.otherStats = new int[147];
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getTotalPss() {
            return this.dalvikPss + this.nativePss + this.otherPss;
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getTotalUss() {
            return this.dalvikPrivateClean + this.dalvikPrivateDirty + this.nativePrivateClean + this.nativePrivateDirty + this.otherPrivateClean + this.otherPrivateDirty;
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getTotalSwappablePss() {
            return this.dalvikSwappablePss + this.nativeSwappablePss + this.otherSwappablePss;
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getTotalPrivateDirty() {
            return this.dalvikPrivateDirty + this.nativePrivateDirty + this.otherPrivateDirty;
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getTotalSharedDirty() {
            return this.dalvikSharedDirty + this.nativeSharedDirty + this.otherSharedDirty;
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getTotalPrivateClean() {
            return this.dalvikPrivateClean + this.nativePrivateClean + this.otherPrivateClean;
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getTotalSharedClean() {
            return this.dalvikSharedClean + this.nativeSharedClean + this.otherSharedClean;
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getTotalSwappedOut() {
            return this.dalvikSwappedOut + this.nativeSwappedOut + this.otherSwappedOut;
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getOtherPss(int which) {
            return this.otherStats[which * 7 + 0];
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getOtherSwappablePss(int which) {
            return this.otherStats[which * 7 + 1];
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getOtherPrivateDirty(int which) {
            return this.otherStats[which * 7 + 2];
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getOtherSharedDirty(int which) {
            return this.otherStats[which * 7 + 3];
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getOtherPrivateClean(int which) {
            return this.otherStats[which * 7 + 4];
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getOtherSharedClean(int which) {
            return this.otherStats[which * 7 + 5];
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$getOtherSwappedOut(int which) {
            return this.otherStats[which * 7 + 6];
        }

        private static final String $$robo$$android_os_Debug_MemoryInfo$getOtherLabel(int which) {
            switch (which) {
                case 0: {
                    return "Dalvik Other";
                }
                case 1: {
                    return "Stack";
                }
                case 2: {
                    return "Cursor";
                }
                case 3: {
                    return "Ashmem";
                }
                case 4: {
                    return "Other dev";
                }
                case 5: {
                    return ".so mmap";
                }
                case 6: {
                    return ".jar mmap";
                }
                case 7: {
                    return ".apk mmap";
                }
                case 8: {
                    return ".ttf mmap";
                }
                case 9: {
                    return ".dex mmap";
                }
                case 10: {
                    return "code mmap";
                }
                case 11: {
                    return "image mmap";
                }
                case 12: {
                    return "Other mmap";
                }
                case 13: {
                    return "Graphics";
                }
                case 14: {
                    return "GL";
                }
                case 15: {
                    return "Memtrack";
                }
                case 16: {
                    return ".Heap";
                }
                case 17: {
                    return ".LOS";
                }
                case 18: {
                    return ".LinearAlloc";
                }
                case 19: {
                    return ".GC";
                }
                case 20: {
                    return ".JITCache";
                }
            }
            return "????";
        }

        private final int $$robo$$android_os_Debug_MemoryInfo$describeContents() {
            return 0;
        }

        private final void $$robo$$android_os_Debug_MemoryInfo$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.dalvikPss);
            dest.writeInt(this.dalvikSwappablePss);
            dest.writeInt(this.dalvikPrivateDirty);
            dest.writeInt(this.dalvikSharedDirty);
            dest.writeInt(this.dalvikPrivateClean);
            dest.writeInt(this.dalvikSharedClean);
            dest.writeInt(this.dalvikSwappedOut);
            dest.writeInt(this.nativePss);
            dest.writeInt(this.nativeSwappablePss);
            dest.writeInt(this.nativePrivateDirty);
            dest.writeInt(this.nativeSharedDirty);
            dest.writeInt(this.nativePrivateClean);
            dest.writeInt(this.nativeSharedClean);
            dest.writeInt(this.nativeSwappedOut);
            dest.writeInt(this.otherPss);
            dest.writeInt(this.otherSwappablePss);
            dest.writeInt(this.otherPrivateDirty);
            dest.writeInt(this.otherSharedDirty);
            dest.writeInt(this.otherPrivateClean);
            dest.writeInt(this.otherSharedClean);
            dest.writeInt(this.otherSwappedOut);
            dest.writeIntArray(this.otherStats);
        }

        private final void $$robo$$android_os_Debug_MemoryInfo$readFromParcel(Parcel source) {
            this.dalvikPss = source.readInt();
            this.dalvikSwappablePss = source.readInt();
            this.dalvikPrivateDirty = source.readInt();
            this.dalvikSharedDirty = source.readInt();
            this.dalvikPrivateClean = source.readInt();
            this.dalvikSharedClean = source.readInt();
            this.dalvikSwappedOut = source.readInt();
            this.nativePss = source.readInt();
            this.nativeSwappablePss = source.readInt();
            this.nativePrivateDirty = source.readInt();
            this.nativeSharedDirty = source.readInt();
            this.nativePrivateClean = source.readInt();
            this.nativeSharedClean = source.readInt();
            this.nativeSwappedOut = source.readInt();
            this.otherPss = source.readInt();
            this.otherSwappablePss = source.readInt();
            this.otherPrivateDirty = source.readInt();
            this.otherSharedDirty = source.readInt();
            this.otherPrivateClean = source.readInt();
            this.otherSharedClean = source.readInt();
            this.otherSwappedOut = source.readInt();
            this.otherStats = source.createIntArray();
        }

        private void $$robo$$android_os_Debug_MemoryInfo$__constructor__(Parcel source) {
            this.otherStats = new int[147];
            this.readFromParcel(source);
        }

        private /* synthetic */ void $$robo$$android_os_Debug_MemoryInfo$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<MemoryInfo>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_os_Debug_MemoryInfo_1$__constructor__() {
                }

                private final MemoryInfo $$robo$$android_os_Debug_MemoryInfo_1$createFromParcel(Parcel source) {
                    return new MemoryInfo(source);
                }

                private final MemoryInfo[] $$robo$$android_os_Debug_MemoryInfo_1$newArray(int size) {
                    return new MemoryInfo[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_os_Debug_MemoryInfo_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_Debug_MemoryInfo_1$__constructor__(), 0, this);
                }

                @Override
                public MemoryInfo createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_os_Debug_MemoryInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public MemoryInfo[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_os_Debug_MemoryInfo_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_os_Debug_MemoryInfo$__constructor__();
        }

        public MemoryInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_Debug_MemoryInfo$__constructor__(), 0, this);
        }

        public int getTotalPss() {
            return (int)InvokeDynamicSupport.bootstrap("getTotalPss", $$robo$$android_os_Debug_MemoryInfo$getTotalPss(), 0, this);
        }

        public int getTotalUss() {
            return (int)InvokeDynamicSupport.bootstrap("getTotalUss", $$robo$$android_os_Debug_MemoryInfo$getTotalUss(), 0, this);
        }

        public int getTotalSwappablePss() {
            return (int)InvokeDynamicSupport.bootstrap("getTotalSwappablePss", $$robo$$android_os_Debug_MemoryInfo$getTotalSwappablePss(), 0, this);
        }

        public int getTotalPrivateDirty() {
            return (int)InvokeDynamicSupport.bootstrap("getTotalPrivateDirty", $$robo$$android_os_Debug_MemoryInfo$getTotalPrivateDirty(), 0, this);
        }

        public int getTotalSharedDirty() {
            return (int)InvokeDynamicSupport.bootstrap("getTotalSharedDirty", $$robo$$android_os_Debug_MemoryInfo$getTotalSharedDirty(), 0, this);
        }

        public int getTotalPrivateClean() {
            return (int)InvokeDynamicSupport.bootstrap("getTotalPrivateClean", $$robo$$android_os_Debug_MemoryInfo$getTotalPrivateClean(), 0, this);
        }

        public int getTotalSharedClean() {
            return (int)InvokeDynamicSupport.bootstrap("getTotalSharedClean", $$robo$$android_os_Debug_MemoryInfo$getTotalSharedClean(), 0, this);
        }

        public int getTotalSwappedOut() {
            return (int)InvokeDynamicSupport.bootstrap("getTotalSwappedOut", $$robo$$android_os_Debug_MemoryInfo$getTotalSwappedOut(), 0, this);
        }

        public int getOtherPss(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getOtherPss", $$robo$$android_os_Debug_MemoryInfo$getOtherPss(int ), 0, this, n);
        }

        public int getOtherSwappablePss(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getOtherSwappablePss", $$robo$$android_os_Debug_MemoryInfo$getOtherSwappablePss(int ), 0, this, n);
        }

        public int getOtherPrivateDirty(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getOtherPrivateDirty", $$robo$$android_os_Debug_MemoryInfo$getOtherPrivateDirty(int ), 0, this, n);
        }

        public int getOtherSharedDirty(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getOtherSharedDirty", $$robo$$android_os_Debug_MemoryInfo$getOtherSharedDirty(int ), 0, this, n);
        }

        public int getOtherPrivateClean(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getOtherPrivateClean", $$robo$$android_os_Debug_MemoryInfo$getOtherPrivateClean(int ), 0, this, n);
        }

        public int getOtherSharedClean(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getOtherSharedClean", $$robo$$android_os_Debug_MemoryInfo$getOtherSharedClean(int ), 0, this, n);
        }

        public int getOtherSwappedOut(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getOtherSwappedOut", $$robo$$android_os_Debug_MemoryInfo$getOtherSwappedOut(int ), 0, this, n);
        }

        public static String getOtherLabel(int n) {
            return InvokeDynamicSupport.bootstrapStatic("getOtherLabel", $$robo$$android_os_Debug_MemoryInfo$getOtherLabel(int ), 0, (int)n);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_os_Debug_MemoryInfo$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_os_Debug_MemoryInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        public void readFromParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$android_os_Debug_MemoryInfo$readFromParcel(android.os.Parcel ), 0, this, parcel);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_os_Debug_MemoryInfo$__constructor__(parcel);
        }

        private MemoryInfo(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_Debug_MemoryInfo$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_os_Debug_MemoryInfo$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(MemoryInfo.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MemoryInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

