/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.FileUtils;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.storage.IMountService;
import android.os.storage.StorageVolume;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Environment
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "Environment";
    private static String ENV_EXTERNAL_STORAGE = "EXTERNAL_STORAGE";
    private static String ENV_EMULATED_STORAGE_SOURCE = "EMULATED_STORAGE_SOURCE";
    private static String ENV_EMULATED_STORAGE_TARGET = "EMULATED_STORAGE_TARGET";
    private static String ENV_MEDIA_STORAGE = "MEDIA_STORAGE";
    private static String ENV_SECONDARY_STORAGE = "SECONDARY_STORAGE";
    private static String ENV_ANDROID_ROOT = "ANDROID_ROOT";
    private static String ENV_OEM_ROOT = "OEM_ROOT";
    private static String ENV_VENDOR_ROOT = "VENDOR_ROOT";
    public static String DIR_ANDROID = "Android";
    private static String DIR_DATA = "data";
    private static String DIR_MEDIA = "media";
    private static String DIR_OBB = "obb";
    private static String DIR_FILES = "files";
    private static String DIR_CACHE = "cache";
    @Deprecated
    public static String DIRECTORY_ANDROID = "Android";
    private static File DIR_ANDROID_ROOT;
    private static File DIR_OEM_ROOT;
    private static File DIR_VENDOR_ROOT;
    private static File DIR_MEDIA_STORAGE;
    private static String CANONCIAL_EMULATED_STORAGE_TARGET;
    private static String SYSTEM_PROPERTY_EFS_ENABLED = "persist.security.efs.enabled";
    private static UserEnvironment sCurrentUser;
    private static boolean sUserRequired;
    private static File DATA_DIRECTORY;
    private static File SECURE_DATA_DIRECTORY;
    private static File DOWNLOAD_CACHE_DIRECTORY;
    public static String DIRECTORY_MUSIC;
    public static String DIRECTORY_PODCASTS;
    public static String DIRECTORY_RINGTONES;
    public static String DIRECTORY_ALARMS;
    public static String DIRECTORY_NOTIFICATIONS;
    public static String DIRECTORY_PICTURES;
    public static String DIRECTORY_MOVIES;
    public static String DIRECTORY_DOWNLOADS;
    public static String DIRECTORY_DCIM;
    public static String DIRECTORY_DOCUMENTS;
    public static String MEDIA_UNKNOWN = "unknown";
    public static String MEDIA_REMOVED = "removed";
    public static String MEDIA_UNMOUNTED = "unmounted";
    public static String MEDIA_CHECKING = "checking";
    public static String MEDIA_NOFS = "nofs";
    public static String MEDIA_MOUNTED = "mounted";
    public static String MEDIA_MOUNTED_READ_ONLY = "mounted_ro";
    public static String MEDIA_SHARED = "shared";
    public static String MEDIA_BAD_REMOVAL = "bad_removal";
    public static String MEDIA_UNMOUNTABLE = "unmountable";

    private void $$robo$$android_os_Environment$__constructor__() {
    }

    private static final void $$robo$$android_os_Environment$initForCurrentUser() {
        int userId = UserHandle.myUserId();
        sCurrentUser = new UserEnvironment(userId);
    }

    private static final File $$robo$$android_os_Environment$getRootDirectory() {
        return DIR_ANDROID_ROOT;
    }

    private static final File $$robo$$android_os_Environment$getOemDirectory() {
        return DIR_OEM_ROOT;
    }

    private static final File $$robo$$android_os_Environment$getVendorDirectory() {
        return DIR_VENDOR_ROOT;
    }

    private static final File $$robo$$android_os_Environment$getSystemSecureDirectory() {
        if (Environment.isEncryptedFilesystemEnabled()) {
            return new File(SECURE_DATA_DIRECTORY, "system");
        }
        return new File(DATA_DIRECTORY, "system");
    }

    private static final File $$robo$$android_os_Environment$getSecureDataDirectory() {
        if (Environment.isEncryptedFilesystemEnabled()) {
            return SECURE_DATA_DIRECTORY;
        }
        return DATA_DIRECTORY;
    }

    private static final File $$robo$$android_os_Environment$getMediaStorageDirectory() {
        Environment.throwIfUserRequired();
        return sCurrentUser.getMediaDir();
    }

    private static final File $$robo$$android_os_Environment$getUserSystemDirectory(int userId) {
        return new File(new File(Environment.getSystemSecureDirectory(), "users"), Integer.toString(userId));
    }

    private static final File $$robo$$android_os_Environment$getUserConfigDirectory(int userId) {
        return new File(new File(new File(Environment.getDataDirectory(), "misc"), "user"), Integer.toString(userId));
    }

    private static final boolean $$robo$$android_os_Environment$isEncryptedFilesystemEnabled() {
        return SystemProperties.getBoolean("persist.security.efs.enabled", false);
    }

    private static final File $$robo$$android_os_Environment$getDataDirectory() {
        return DATA_DIRECTORY;
    }

    private static final File $$robo$$android_os_Environment$getExternalStorageDirectory() {
        Environment.throwIfUserRequired();
        return sCurrentUser.getExternalDirsForApp()[0];
    }

    private static final File $$robo$$android_os_Environment$getLegacyExternalStorageDirectory() {
        return new File(System.getenv("EXTERNAL_STORAGE"));
    }

    private static final File $$robo$$android_os_Environment$getLegacyExternalStorageObbDirectory() {
        return Environment.buildPath(Environment.getLegacyExternalStorageDirectory(), "Android", "obb");
    }

    private static final File $$robo$$android_os_Environment$getEmulatedStorageSource(int userId) {
        return new File(System.getenv("EMULATED_STORAGE_SOURCE"), String.valueOf(userId));
    }

    private static final File $$robo$$android_os_Environment$getEmulatedStorageObbSource() {
        return new File(System.getenv("EMULATED_STORAGE_SOURCE"), "obb");
    }

    private static final File $$robo$$android_os_Environment$getExternalStoragePublicDirectory(String type) {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStoragePublicDirs(type)[0];
    }

    private static final File[] $$robo$$android_os_Environment$buildExternalStorageAndroidDataDirs() {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStorageAndroidDataDirs();
    }

    private static final File[] $$robo$$android_os_Environment$buildExternalStorageAppDataDirs(String packageName) {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStorageAppDataDirs(packageName);
    }

    private static final File[] $$robo$$android_os_Environment$buildExternalStorageAppMediaDirs(String packageName) {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStorageAppMediaDirs(packageName);
    }

    private static final File[] $$robo$$android_os_Environment$buildExternalStorageAppObbDirs(String packageName) {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStorageAppObbDirs(packageName);
    }

    private static final File[] $$robo$$android_os_Environment$buildExternalStorageAppFilesDirs(String packageName) {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStorageAppFilesDirs(packageName);
    }

    private static final File[] $$robo$$android_os_Environment$buildExternalStorageAppCacheDirs(String packageName) {
        Environment.throwIfUserRequired();
        return sCurrentUser.buildExternalStorageAppCacheDirs(packageName);
    }

    private static final File $$robo$$android_os_Environment$getDownloadCacheDirectory() {
        return DOWNLOAD_CACHE_DIRECTORY;
    }

    private static final String $$robo$$android_os_Environment$getExternalStorageState() {
        File externalDir = sCurrentUser.getExternalDirsForApp()[0];
        return Environment.getExternalStorageState(externalDir);
    }

    @Deprecated
    private static final String $$robo$$android_os_Environment$getStorageState(File path) {
        return Environment.getExternalStorageState(path);
    }

    private static final String $$robo$$android_os_Environment$getExternalStorageState(File path) {
        StorageVolume volume = Environment.getStorageVolume(path);
        if (volume != null) {
            IMountService mountService = IMountService.Stub.asInterface(ServiceManager.getService("mount"));
            try {
                return mountService.getVolumeState(volume.getPath());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return "unknown";
    }

    private static final boolean $$robo$$android_os_Environment$isExternalStorageRemovable() {
        if (Environment.isStorageDisabled()) {
            return false;
        }
        File externalDir = sCurrentUser.getExternalDirsForApp()[0];
        return Environment.isExternalStorageRemovable(externalDir);
    }

    private static final boolean $$robo$$android_os_Environment$isExternalStorageRemovable(File path) {
        StorageVolume volume = Environment.getStorageVolume(path);
        if (volume != null) {
            return volume.isRemovable();
        }
        throw new IllegalArgumentException("Failed to find storage device at " + path);
    }

    private static final boolean $$robo$$android_os_Environment$isExternalStorageEmulated() {
        if (Environment.isStorageDisabled()) {
            return false;
        }
        File externalDir = sCurrentUser.getExternalDirsForApp()[0];
        return Environment.isExternalStorageEmulated(externalDir);
    }

    private static final boolean $$robo$$android_os_Environment$isExternalStorageEmulated(File path) {
        StorageVolume volume = Environment.getStorageVolume(path);
        if (volume != null) {
            return volume.isEmulated();
        }
        throw new IllegalArgumentException("Failed to find storage device at " + path);
    }

    private static final File $$robo$$android_os_Environment$getDirectory(String variableName, String defaultPath) {
        String path = System.getenv(variableName);
        return path == null ? new File(defaultPath) : new File(path);
    }

    private static final String $$robo$$android_os_Environment$getCanonicalPathOrNull(String variableName) {
        String path = System.getenv(variableName);
        if (path == null) {
            return null;
        }
        try {
            return new File(path).getCanonicalPath();
        }
        catch (IOException e) {
            Log.w("Environment", "Unable to resolve canonical path for " + path);
            return null;
        }
    }

    private static final void $$robo$$android_os_Environment$setUserRequired(boolean userRequired) {
        sUserRequired = userRequired;
    }

    private static final void $$robo$$android_os_Environment$throwIfUserRequired() {
        if (sUserRequired) {
            Log.wtf("Environment", "Path requests must specify a user by using UserEnvironment", new Throwable());
        }
    }

    private static final File[] $$robo$$android_os_Environment$buildPaths(File[] base, String ... segments) {
        File[] result = new File[base.length];
        for (int i = 0; i < base.length; ++i) {
            result[i] = Environment.buildPath(base[i], segments);
        }
        return result;
    }

    private static final File $$robo$$android_os_Environment$buildPath(File base, String ... segments) {
        File cur = base;
        for (String segment : segments) {
            cur = cur == null ? new File(segment) : new File(cur, segment);
        }
        return cur;
    }

    private static final boolean $$robo$$android_os_Environment$isStorageDisabled() {
        return SystemProperties.getBoolean("config.disable_storage", false);
    }

    private static final StorageVolume $$robo$$android_os_Environment$getStorageVolume(File path) {
        try {
            path = path.getCanonicalFile();
        }
        catch (IOException e) {
            return null;
        }
        try {
            StorageVolume[] volumes;
            IMountService mountService = IMountService.Stub.asInterface(ServiceManager.getService("mount"));
            for (StorageVolume volume : volumes = mountService.getVolumeList()) {
                if (!FileUtils.contains(volume.getPathFile(), path)) continue;
                return volume;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return null;
    }

    private static final File $$robo$$android_os_Environment$maybeTranslateEmulatedPathToInternal(File path) {
        if (!Environment.isExternalStorageEmulated() || CANONCIAL_EMULATED_STORAGE_TARGET == null) {
            return path;
        }
        try {
            File internalPath;
            String rawPath = path.getCanonicalPath();
            if (rawPath.startsWith(CANONCIAL_EMULATED_STORAGE_TARGET) && (internalPath = new File(DIR_MEDIA_STORAGE, rawPath.substring(CANONCIAL_EMULATED_STORAGE_TARGET.length()))).exists()) {
                return internalPath;
            }
        }
        catch (IOException e) {
            Log.w("Environment", "Failed to resolve canonical path for " + path);
        }
        return path;
    }

    static void __staticInitializer__() {
        DIR_ANDROID_ROOT = Environment.getDirectory("ANDROID_ROOT", "/system");
        DIR_OEM_ROOT = Environment.getDirectory("OEM_ROOT", "/oem");
        DIR_VENDOR_ROOT = Environment.getDirectory("VENDOR_ROOT", "/vendor");
        DIR_MEDIA_STORAGE = Environment.getDirectory("MEDIA_STORAGE", "/data/media");
        CANONCIAL_EMULATED_STORAGE_TARGET = Environment.getCanonicalPathOrNull("EMULATED_STORAGE_TARGET");
        Environment.initForCurrentUser();
        DATA_DIRECTORY = Environment.getDirectory("ANDROID_DATA", "/data");
        SECURE_DATA_DIRECTORY = Environment.getDirectory("ANDROID_SECURE_DATA", "/data/secure");
        DOWNLOAD_CACHE_DIRECTORY = Environment.getDirectory("DOWNLOAD_CACHE", "/cache");
        DIRECTORY_MUSIC = "Music";
        DIRECTORY_PODCASTS = "Podcasts";
        DIRECTORY_RINGTONES = "Ringtones";
        DIRECTORY_ALARMS = "Alarms";
        DIRECTORY_NOTIFICATIONS = "Notifications";
        DIRECTORY_PICTURES = "Pictures";
        DIRECTORY_MOVIES = "Movies";
        DIRECTORY_DOWNLOADS = "Download";
        DIRECTORY_DCIM = "DCIM";
        DIRECTORY_DOCUMENTS = "Documents";
    }

    private void __constructor__() {
        this.$$robo$$android_os_Environment$__constructor__();
    }

    public Environment() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_Environment$__constructor__(), 0, this);
    }

    public static void initForCurrentUser() {
        InvokeDynamicSupport.bootstrapStatic("initForCurrentUser", $$robo$$android_os_Environment$initForCurrentUser(), 0);
    }

    public static File getRootDirectory() {
        return InvokeDynamicSupport.bootstrapStatic("getRootDirectory", $$robo$$android_os_Environment$getRootDirectory(), 0);
    }

    public static File getOemDirectory() {
        return InvokeDynamicSupport.bootstrapStatic("getOemDirectory", $$robo$$android_os_Environment$getOemDirectory(), 0);
    }

    public static File getVendorDirectory() {
        return InvokeDynamicSupport.bootstrapStatic("getVendorDirectory", $$robo$$android_os_Environment$getVendorDirectory(), 0);
    }

    public static File getSystemSecureDirectory() {
        return InvokeDynamicSupport.bootstrapStatic("getSystemSecureDirectory", $$robo$$android_os_Environment$getSystemSecureDirectory(), 0);
    }

    public static File getSecureDataDirectory() {
        return InvokeDynamicSupport.bootstrapStatic("getSecureDataDirectory", $$robo$$android_os_Environment$getSecureDataDirectory(), 0);
    }

    public static File getMediaStorageDirectory() {
        return InvokeDynamicSupport.bootstrapStatic("getMediaStorageDirectory", $$robo$$android_os_Environment$getMediaStorageDirectory(), 0);
    }

    public static File getUserSystemDirectory(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getUserSystemDirectory", $$robo$$android_os_Environment$getUserSystemDirectory(int ), 0, (int)n);
    }

    public static File getUserConfigDirectory(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getUserConfigDirectory", $$robo$$android_os_Environment$getUserConfigDirectory(int ), 0, (int)n);
    }

    public static boolean isEncryptedFilesystemEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isEncryptedFilesystemEnabled", $$robo$$android_os_Environment$isEncryptedFilesystemEnabled(), 0);
    }

    public static File getDataDirectory() {
        return InvokeDynamicSupport.bootstrapStatic("getDataDirectory", $$robo$$android_os_Environment$getDataDirectory(), 0);
    }

    public static File getExternalStorageDirectory() {
        return InvokeDynamicSupport.bootstrapStatic("getExternalStorageDirectory", $$robo$$android_os_Environment$getExternalStorageDirectory(), 0);
    }

    public static File getLegacyExternalStorageDirectory() {
        return InvokeDynamicSupport.bootstrapStatic("getLegacyExternalStorageDirectory", $$robo$$android_os_Environment$getLegacyExternalStorageDirectory(), 0);
    }

    public static File getLegacyExternalStorageObbDirectory() {
        return InvokeDynamicSupport.bootstrapStatic("getLegacyExternalStorageObbDirectory", $$robo$$android_os_Environment$getLegacyExternalStorageObbDirectory(), 0);
    }

    public static File getEmulatedStorageSource(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getEmulatedStorageSource", $$robo$$android_os_Environment$getEmulatedStorageSource(int ), 0, (int)n);
    }

    public static File getEmulatedStorageObbSource() {
        return InvokeDynamicSupport.bootstrapStatic("getEmulatedStorageObbSource", $$robo$$android_os_Environment$getEmulatedStorageObbSource(), 0);
    }

    public static File getExternalStoragePublicDirectory(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getExternalStoragePublicDirectory", $$robo$$android_os_Environment$getExternalStoragePublicDirectory(java.lang.String ), 0, (String)string2);
    }

    public static File[] buildExternalStorageAndroidDataDirs() {
        return InvokeDynamicSupport.bootstrapStatic("buildExternalStorageAndroidDataDirs", $$robo$$android_os_Environment$buildExternalStorageAndroidDataDirs(), 0);
    }

    public static File[] buildExternalStorageAppDataDirs(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("buildExternalStorageAppDataDirs", $$robo$$android_os_Environment$buildExternalStorageAppDataDirs(java.lang.String ), 0, (String)string2);
    }

    public static File[] buildExternalStorageAppMediaDirs(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("buildExternalStorageAppMediaDirs", $$robo$$android_os_Environment$buildExternalStorageAppMediaDirs(java.lang.String ), 0, (String)string2);
    }

    public static File[] buildExternalStorageAppObbDirs(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("buildExternalStorageAppObbDirs", $$robo$$android_os_Environment$buildExternalStorageAppObbDirs(java.lang.String ), 0, (String)string2);
    }

    public static File[] buildExternalStorageAppFilesDirs(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("buildExternalStorageAppFilesDirs", $$robo$$android_os_Environment$buildExternalStorageAppFilesDirs(java.lang.String ), 0, (String)string2);
    }

    public static File[] buildExternalStorageAppCacheDirs(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("buildExternalStorageAppCacheDirs", $$robo$$android_os_Environment$buildExternalStorageAppCacheDirs(java.lang.String ), 0, (String)string2);
    }

    public static File getDownloadCacheDirectory() {
        return InvokeDynamicSupport.bootstrapStatic("getDownloadCacheDirectory", $$robo$$android_os_Environment$getDownloadCacheDirectory(), 0);
    }

    public static String getExternalStorageState() {
        return InvokeDynamicSupport.bootstrapStatic("getExternalStorageState", $$robo$$android_os_Environment$getExternalStorageState(), 0);
    }

    @Deprecated
    public static String getStorageState(File file) {
        return InvokeDynamicSupport.bootstrapStatic("getStorageState", $$robo$$android_os_Environment$getStorageState(java.io.File ), 0, (File)file);
    }

    public static String getExternalStorageState(File file) {
        return InvokeDynamicSupport.bootstrapStatic("getExternalStorageState", $$robo$$android_os_Environment$getExternalStorageState(java.io.File ), 0, (File)file);
    }

    public static boolean isExternalStorageRemovable() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isExternalStorageRemovable", $$robo$$android_os_Environment$isExternalStorageRemovable(), 0);
    }

    public static boolean isExternalStorageRemovable(File file) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isExternalStorageRemovable", $$robo$$android_os_Environment$isExternalStorageRemovable(java.io.File ), 0, (File)file);
    }

    public static boolean isExternalStorageEmulated() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isExternalStorageEmulated", $$robo$$android_os_Environment$isExternalStorageEmulated(), 0);
    }

    public static boolean isExternalStorageEmulated(File file) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isExternalStorageEmulated", $$robo$$android_os_Environment$isExternalStorageEmulated(java.io.File ), 0, (File)file);
    }

    static File getDirectory(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("getDirectory", $$robo$$android_os_Environment$getDirectory(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    private static String getCanonicalPathOrNull(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getCanonicalPathOrNull", $$robo$$android_os_Environment$getCanonicalPathOrNull(java.lang.String ), 0, (String)string2);
    }

    public static void setUserRequired(boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("setUserRequired", $$robo$$android_os_Environment$setUserRequired(boolean ), 0, (boolean)bl);
    }

    private static void throwIfUserRequired() {
        InvokeDynamicSupport.bootstrapStatic("throwIfUserRequired", $$robo$$android_os_Environment$throwIfUserRequired(), 0);
    }

    public static File[] buildPaths(File[] fileArray, String ... stringArray) {
        return InvokeDynamicSupport.bootstrapStatic("buildPaths", $$robo$$android_os_Environment$buildPaths(java.io.File[] java.lang.String[] ), 0, (File[])fileArray, (String[])stringArray);
    }

    public static File buildPath(File file, String ... stringArray) {
        return InvokeDynamicSupport.bootstrapStatic("buildPath", $$robo$$android_os_Environment$buildPath(java.io.File java.lang.String[] ), 0, (File)file, (String[])stringArray);
    }

    private static boolean isStorageDisabled() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isStorageDisabled", $$robo$$android_os_Environment$isStorageDisabled(), 0);
    }

    private static StorageVolume getStorageVolume(File file) {
        return InvokeDynamicSupport.bootstrapStatic("getStorageVolume", $$robo$$android_os_Environment$getStorageVolume(java.io.File ), 0, (File)file);
    }

    public static File maybeTranslateEmulatedPathToInternal(File file) {
        return InvokeDynamicSupport.bootstrapStatic("maybeTranslateEmulatedPathToInternal", $$robo$$android_os_Environment$maybeTranslateEmulatedPathToInternal(java.io.File ), 0, (File)file);
    }

    static {
        RobolectricInternals.classInitializing(Environment.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Environment)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class UserEnvironment
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private File[] mExternalDirsForVold;
        private File[] mExternalDirsForApp;
        private File mEmulatedDirForDirect;

        private void $$robo$$android_os_Environment_UserEnvironment$__constructor__(int userId) {
            String rawExternalStorage = System.getenv("EXTERNAL_STORAGE");
            String rawEmulatedSource = System.getenv("EMULATED_STORAGE_SOURCE");
            String rawEmulatedTarget = System.getenv("EMULATED_STORAGE_TARGET");
            String rawMediaStorage = System.getenv("MEDIA_STORAGE");
            if (TextUtils.isEmpty(rawMediaStorage)) {
                rawMediaStorage = "/data/media";
            }
            ArrayList<File> externalForVold = Lists.newArrayList();
            ArrayList<File> externalForApp = Lists.newArrayList();
            if (!TextUtils.isEmpty(rawEmulatedTarget)) {
                String rawUserId = Integer.toString(userId);
                File emulatedSourceBase = new File(rawEmulatedSource);
                File emulatedTargetBase = new File(rawEmulatedTarget);
                File mediaBase = new File(rawMediaStorage);
                externalForVold.add(Environment.buildPath(emulatedSourceBase, rawUserId));
                externalForApp.add(Environment.buildPath(emulatedTargetBase, rawUserId));
                this.mEmulatedDirForDirect = Environment.buildPath(mediaBase, rawUserId);
            } else {
                if (TextUtils.isEmpty(rawExternalStorage)) {
                    Log.w("Environment", "EXTERNAL_STORAGE undefined; falling back to default");
                    rawExternalStorage = "/storage/sdcard0";
                }
                externalForVold.add(new File(rawExternalStorage));
                externalForApp.add(new File(rawExternalStorage));
                this.mEmulatedDirForDirect = new File(rawMediaStorage);
            }
            String rawSecondaryStorage = System.getenv("SECONDARY_STORAGE");
            if (!TextUtils.isEmpty(rawSecondaryStorage) && userId == 0) {
                for (String secondaryPath : rawSecondaryStorage.split(":")) {
                    externalForVold.add(new File(secondaryPath));
                    externalForApp.add(new File(secondaryPath));
                }
            }
            this.mExternalDirsForVold = externalForVold.toArray(new File[externalForVold.size()]);
            this.mExternalDirsForApp = externalForApp.toArray(new File[externalForApp.size()]);
        }

        @Deprecated
        private final File $$robo$$android_os_Environment_UserEnvironment$getExternalStorageDirectory() {
            return this.mExternalDirsForApp[0];
        }

        @Deprecated
        private final File $$robo$$android_os_Environment_UserEnvironment$getExternalStoragePublicDirectory(String type) {
            return this.buildExternalStoragePublicDirs(type)[0];
        }

        private final File[] $$robo$$android_os_Environment_UserEnvironment$getExternalDirsForVold() {
            return this.mExternalDirsForVold;
        }

        private final File[] $$robo$$android_os_Environment_UserEnvironment$getExternalDirsForApp() {
            return this.mExternalDirsForApp;
        }

        private final File $$robo$$android_os_Environment_UserEnvironment$getMediaDir() {
            return this.mEmulatedDirForDirect;
        }

        private final File[] $$robo$$android_os_Environment_UserEnvironment$buildExternalStoragePublicDirs(String type) {
            return Environment.buildPaths(this.mExternalDirsForApp, type);
        }

        private final File[] $$robo$$android_os_Environment_UserEnvironment$buildExternalStorageAndroidDataDirs() {
            return Environment.buildPaths(this.mExternalDirsForApp, "Android", "data");
        }

        private final File[] $$robo$$android_os_Environment_UserEnvironment$buildExternalStorageAndroidObbDirs() {
            return Environment.buildPaths(this.mExternalDirsForApp, "Android", "obb");
        }

        private final File[] $$robo$$android_os_Environment_UserEnvironment$buildExternalStorageAppDataDirs(String packageName) {
            return Environment.buildPaths(this.mExternalDirsForApp, "Android", "data", packageName);
        }

        private final File[] $$robo$$android_os_Environment_UserEnvironment$buildExternalStorageAppDataDirsForVold(String packageName) {
            return Environment.buildPaths(this.mExternalDirsForVold, "Android", "data", packageName);
        }

        private final File[] $$robo$$android_os_Environment_UserEnvironment$buildExternalStorageAppMediaDirs(String packageName) {
            return Environment.buildPaths(this.mExternalDirsForApp, "Android", "media", packageName);
        }

        private final File[] $$robo$$android_os_Environment_UserEnvironment$buildExternalStorageAppMediaDirsForVold(String packageName) {
            return Environment.buildPaths(this.mExternalDirsForVold, "Android", "media", packageName);
        }

        private final File[] $$robo$$android_os_Environment_UserEnvironment$buildExternalStorageAppObbDirs(String packageName) {
            return Environment.buildPaths(this.mExternalDirsForApp, "Android", "obb", packageName);
        }

        private final File[] $$robo$$android_os_Environment_UserEnvironment$buildExternalStorageAppObbDirsForVold(String packageName) {
            return Environment.buildPaths(this.mExternalDirsForVold, "Android", "obb", packageName);
        }

        private final File[] $$robo$$android_os_Environment_UserEnvironment$buildExternalStorageAppFilesDirs(String packageName) {
            return Environment.buildPaths(this.mExternalDirsForApp, "Android", "data", packageName, "files");
        }

        private final File[] $$robo$$android_os_Environment_UserEnvironment$buildExternalStorageAppCacheDirs(String packageName) {
            return Environment.buildPaths(this.mExternalDirsForApp, "Android", "data", packageName, "cache");
        }

        private void __constructor__(int n) {
            this.$$robo$$android_os_Environment_UserEnvironment$__constructor__(n);
        }

        public UserEnvironment(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_Environment_UserEnvironment$__constructor__(int ), 0, this, n);
        }

        @Deprecated
        public File getExternalStorageDirectory() {
            return InvokeDynamicSupport.bootstrap("getExternalStorageDirectory", $$robo$$android_os_Environment_UserEnvironment$getExternalStorageDirectory(), 0, this);
        }

        @Deprecated
        public File getExternalStoragePublicDirectory(String string2) {
            return InvokeDynamicSupport.bootstrap("getExternalStoragePublicDirectory", $$robo$$android_os_Environment_UserEnvironment$getExternalStoragePublicDirectory(java.lang.String ), 0, this, string2);
        }

        public File[] getExternalDirsForVold() {
            return InvokeDynamicSupport.bootstrap("getExternalDirsForVold", $$robo$$android_os_Environment_UserEnvironment$getExternalDirsForVold(), 0, this);
        }

        public File[] getExternalDirsForApp() {
            return InvokeDynamicSupport.bootstrap("getExternalDirsForApp", $$robo$$android_os_Environment_UserEnvironment$getExternalDirsForApp(), 0, this);
        }

        public File getMediaDir() {
            return InvokeDynamicSupport.bootstrap("getMediaDir", $$robo$$android_os_Environment_UserEnvironment$getMediaDir(), 0, this);
        }

        public File[] buildExternalStoragePublicDirs(String string2) {
            return InvokeDynamicSupport.bootstrap("buildExternalStoragePublicDirs", $$robo$$android_os_Environment_UserEnvironment$buildExternalStoragePublicDirs(java.lang.String ), 0, this, string2);
        }

        public File[] buildExternalStorageAndroidDataDirs() {
            return InvokeDynamicSupport.bootstrap("buildExternalStorageAndroidDataDirs", $$robo$$android_os_Environment_UserEnvironment$buildExternalStorageAndroidDataDirs(), 0, this);
        }

        public File[] buildExternalStorageAndroidObbDirs() {
            return InvokeDynamicSupport.bootstrap("buildExternalStorageAndroidObbDirs", $$robo$$android_os_Environment_UserEnvironment$buildExternalStorageAndroidObbDirs(), 0, this);
        }

        public File[] buildExternalStorageAppDataDirs(String string2) {
            return InvokeDynamicSupport.bootstrap("buildExternalStorageAppDataDirs", $$robo$$android_os_Environment_UserEnvironment$buildExternalStorageAppDataDirs(java.lang.String ), 0, this, string2);
        }

        public File[] buildExternalStorageAppDataDirsForVold(String string2) {
            return InvokeDynamicSupport.bootstrap("buildExternalStorageAppDataDirsForVold", $$robo$$android_os_Environment_UserEnvironment$buildExternalStorageAppDataDirsForVold(java.lang.String ), 0, this, string2);
        }

        public File[] buildExternalStorageAppMediaDirs(String string2) {
            return InvokeDynamicSupport.bootstrap("buildExternalStorageAppMediaDirs", $$robo$$android_os_Environment_UserEnvironment$buildExternalStorageAppMediaDirs(java.lang.String ), 0, this, string2);
        }

        public File[] buildExternalStorageAppMediaDirsForVold(String string2) {
            return InvokeDynamicSupport.bootstrap("buildExternalStorageAppMediaDirsForVold", $$robo$$android_os_Environment_UserEnvironment$buildExternalStorageAppMediaDirsForVold(java.lang.String ), 0, this, string2);
        }

        public File[] buildExternalStorageAppObbDirs(String string2) {
            return InvokeDynamicSupport.bootstrap("buildExternalStorageAppObbDirs", $$robo$$android_os_Environment_UserEnvironment$buildExternalStorageAppObbDirs(java.lang.String ), 0, this, string2);
        }

        public File[] buildExternalStorageAppObbDirsForVold(String string2) {
            return InvokeDynamicSupport.bootstrap("buildExternalStorageAppObbDirsForVold", $$robo$$android_os_Environment_UserEnvironment$buildExternalStorageAppObbDirsForVold(java.lang.String ), 0, this, string2);
        }

        public File[] buildExternalStorageAppFilesDirs(String string2) {
            return InvokeDynamicSupport.bootstrap("buildExternalStorageAppFilesDirs", $$robo$$android_os_Environment_UserEnvironment$buildExternalStorageAppFilesDirs(java.lang.String ), 0, this, string2);
        }

        public File[] buildExternalStorageAppCacheDirs(String string2) {
            return InvokeDynamicSupport.bootstrap("buildExternalStorageAppCacheDirs", $$robo$$android_os_Environment_UserEnvironment$buildExternalStorageAppCacheDirs(java.lang.String ), 0, this, string2);
        }

        public /* synthetic */ UserEnvironment() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UserEnvironment)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

