/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.Message;
import android.os.MessageQueue;
import android.os.SystemClock;
import android.util.Log;
import android.util.Printer;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Looper
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "Looper";
    static ThreadLocal<Looper> sThreadLocal;
    private static Looper sMainLooper;
    MessageQueue mQueue;
    Thread mThread;
    private Printer mLogging;

    private static final void $$robo$$android_os_Looper$prepare() {
        Looper.prepare(true);
    }

    private static final void $$robo$$android_os_Looper$prepare(boolean quitAllowed) {
        if (sThreadLocal.get() != null) {
            throw new RuntimeException("Only one Looper may be created per thread");
        }
        sThreadLocal.set(new Looper(quitAllowed));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_os_Looper$prepareMainLooper() {
        Looper.prepare(false);
        Class<Looper> clazz = Looper.class;
        synchronized (Looper.class) {
            if (sMainLooper != null) {
                throw new IllegalStateException("The main Looper has already been prepared.");
            }
            sMainLooper = Looper.myLooper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Looper $$robo$$android_os_Looper$getMainLooper() {
        Class<Looper> clazz = Looper.class;
        synchronized (Looper.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return sMainLooper;
        }
    }

    private static final void $$robo$$android_os_Looper$loop() {
        Looper me = Looper.myLooper();
        if (me == null) {
            throw new RuntimeException("No Looper; Looper.prepare() wasn't called on this thread.");
        }
        MessageQueue queue = me.mQueue;
        Binder.clearCallingIdentity();
        long ident = Binder.clearCallingIdentity();
        Message msg;
        while ((msg = queue.next()) != null) {
            long newIdent;
            Printer logging = me.mLogging;
            if (logging != null) {
                logging.println(">>>>> Dispatching to " + msg.target + " " + msg.callback + ": " + msg.what);
            }
            msg.target.dispatchMessage(msg);
            if (logging != null) {
                logging.println("<<<<< Finished to " + msg.target + " " + msg.callback);
            }
            if (ident != (newIdent = Binder.clearCallingIdentity())) {
                Log.wtf("Looper", "Thread identity changed from 0x" + Long.toHexString(ident) + " to 0x" + Long.toHexString(newIdent) + " while dispatching to " + msg.target.getClass().getName() + " " + msg.callback + " what=" + msg.what);
            }
            msg.recycleUnchecked();
        }
        return;
    }

    private static final Looper $$robo$$android_os_Looper$myLooper() {
        return sThreadLocal.get();
    }

    private final void $$robo$$android_os_Looper$setMessageLogging(Printer printer) {
        this.mLogging = printer;
    }

    private static final MessageQueue $$robo$$android_os_Looper$myQueue() {
        return Looper.myLooper().mQueue;
    }

    private void $$robo$$android_os_Looper$__constructor__(boolean quitAllowed) {
        this.mQueue = new MessageQueue(quitAllowed);
        this.mThread = Thread.currentThread();
    }

    private final boolean $$robo$$android_os_Looper$isCurrentThread() {
        return Thread.currentThread() == this.mThread;
    }

    private final void $$robo$$android_os_Looper$quit() {
        this.mQueue.quit(false);
    }

    private final void $$robo$$android_os_Looper$quitSafely() {
        this.mQueue.quit(true);
    }

    private final int $$robo$$android_os_Looper$postSyncBarrier() {
        return this.mQueue.enqueueSyncBarrier(SystemClock.uptimeMillis());
    }

    private final void $$robo$$android_os_Looper$removeSyncBarrier(int token) {
        this.mQueue.removeSyncBarrier(token);
    }

    private final Thread $$robo$$android_os_Looper$getThread() {
        return this.mThread;
    }

    private final MessageQueue $$robo$$android_os_Looper$getQueue() {
        return this.mQueue;
    }

    private final boolean $$robo$$android_os_Looper$isIdling() {
        return this.mQueue.isIdling();
    }

    private final void $$robo$$android_os_Looper$dump(Printer pw, String prefix) {
        pw.println(prefix + this.toString());
        this.mQueue.dump(pw, prefix + "  ");
    }

    private final String $$robo$$android_os_Looper$toString() {
        return "Looper (" + this.mThread.getName() + ", tid " + this.mThread.getId() + ") {" + Integer.toHexString(System.identityHashCode(this)) + "}";
    }

    static void __staticInitializer__() {
        sThreadLocal = new ThreadLocal();
    }

    public static void prepare() {
        InvokeDynamicSupport.bootstrapStatic("prepare", $$robo$$android_os_Looper$prepare(), 0);
    }

    private static void prepare(boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("prepare", $$robo$$android_os_Looper$prepare(boolean ), 0, (boolean)bl);
    }

    public static void prepareMainLooper() {
        InvokeDynamicSupport.bootstrapStatic("prepareMainLooper", $$robo$$android_os_Looper$prepareMainLooper(), 0);
    }

    public static Looper getMainLooper() {
        return InvokeDynamicSupport.bootstrapStatic("getMainLooper", $$robo$$android_os_Looper$getMainLooper(), 0);
    }

    public static void loop() {
        InvokeDynamicSupport.bootstrapStatic("loop", $$robo$$android_os_Looper$loop(), 0);
    }

    public static Looper myLooper() {
        return InvokeDynamicSupport.bootstrapStatic("myLooper", $$robo$$android_os_Looper$myLooper(), 0);
    }

    public void setMessageLogging(Printer printer) {
        InvokeDynamicSupport.bootstrap("setMessageLogging", $$robo$$android_os_Looper$setMessageLogging(android.util.Printer ), 0, this, printer);
    }

    public static MessageQueue myQueue() {
        return InvokeDynamicSupport.bootstrapStatic("myQueue", $$robo$$android_os_Looper$myQueue(), 0);
    }

    private void __constructor__(boolean bl) {
        this.$$robo$$android_os_Looper$__constructor__(bl);
    }

    private Looper(boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_Looper$__constructor__(boolean ), 0, this, bl);
    }

    public boolean isCurrentThread() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCurrentThread", $$robo$$android_os_Looper$isCurrentThread(), 0, this);
    }

    public void quit() {
        InvokeDynamicSupport.bootstrap("quit", $$robo$$android_os_Looper$quit(), 0, this);
    }

    public void quitSafely() {
        InvokeDynamicSupport.bootstrap("quitSafely", $$robo$$android_os_Looper$quitSafely(), 0, this);
    }

    public int postSyncBarrier() {
        return (int)InvokeDynamicSupport.bootstrap("postSyncBarrier", $$robo$$android_os_Looper$postSyncBarrier(), 0, this);
    }

    public void removeSyncBarrier(int n) {
        InvokeDynamicSupport.bootstrap("removeSyncBarrier", $$robo$$android_os_Looper$removeSyncBarrier(int ), 0, this, n);
    }

    public Thread getThread() {
        return InvokeDynamicSupport.bootstrap("getThread", $$robo$$android_os_Looper$getThread(), 0, this);
    }

    public MessageQueue getQueue() {
        return InvokeDynamicSupport.bootstrap("getQueue", $$robo$$android_os_Looper$getQueue(), 0, this);
    }

    public boolean isIdling() {
        return (boolean)InvokeDynamicSupport.bootstrap("isIdling", $$robo$$android_os_Looper$isIdling(), 0, this);
    }

    public void dump(Printer printer, String string2) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_os_Looper$dump(android.util.Printer java.lang.String ), 0, this, printer, string2);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_os_Looper$toString(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(Looper.class);
    }

    public /* synthetic */ Looper() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Looper)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

