/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import android.util.Printer;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MessageQueue
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private boolean mQuitAllowed;
    private long mPtr;
    Message mMessages;
    private ArrayList<IdleHandler> mIdleHandlers;
    private IdleHandler[] mPendingIdleHandlers;
    private boolean mQuitting;
    private boolean mBlocked;
    private int mNextBarrierToken;

    private static final long $$robo$$android_os_MessageQueue$nativeInit() {
        return 0L;
    }

    private static final void $$robo$$android_os_MessageQueue$nativeDestroy(long l) {
    }

    private static final void $$robo$$android_os_MessageQueue$nativePollOnce(long l, int n) {
    }

    private static final void $$robo$$android_os_MessageQueue$nativeWake(long l) {
    }

    private static final boolean $$robo$$android_os_MessageQueue$nativeIsIdling(long l) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_os_MessageQueue$addIdleHandler(IdleHandler handler) {
        if (handler == null) {
            throw new NullPointerException("Can't add a null IdleHandler");
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.mIdleHandlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_os_MessageQueue$removeIdleHandler(IdleHandler handler) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.mIdleHandlers.remove(handler);
        }
    }

    private void $$robo$$android_os_MessageQueue$__constructor__(boolean quitAllowed) {
        this.mIdleHandlers = new ArrayList();
        this.mQuitAllowed = quitAllowed;
        this.mPtr = MessageQueue.nativeInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_os_MessageQueue$finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    private final void $$robo$$android_os_MessageQueue$dispose() {
        if (this.mPtr != 0L) {
            MessageQueue.nativeDestroy(this.mPtr);
            this.mPtr = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Message $$robo$$android_os_MessageQueue$next() {
        long ptr = this.mPtr;
        if (ptr == 0L) {
            return null;
        }
        int pendingIdleHandlerCount = -1;
        int nextPollTimeoutMillis = 0;
        while (true) {
            if (nextPollTimeoutMillis != 0) {
                Binder.flushPendingCommands();
            }
            MessageQueue.nativePollOnce(ptr, nextPollTimeoutMillis);
            MessageQueue messageQueue = this;
            synchronized (messageQueue) {
                long now;
                block21: {
                    now = SystemClock.uptimeMillis();
                    Message prevMsg = null;
                    Message msg = this.mMessages;
                    if (msg != null && msg.target == null) {
                        do {
                            prevMsg = msg;
                        } while ((msg = msg.next) != null && !msg.isAsynchronous());
                    }
                    if (msg != null) {
                        if (now < msg.when) {
                            nextPollTimeoutMillis = (int)Math.min(msg.when - now, Integer.MAX_VALUE);
                            break block21;
                        } else {
                            this.mBlocked = false;
                            if (prevMsg != null) {
                                prevMsg.next = msg.next;
                            } else {
                                this.mMessages = msg.next;
                            }
                            msg.next = null;
                            return msg;
                        }
                    }
                    nextPollTimeoutMillis = -1;
                }
                if (this.mQuitting) {
                    this.dispose();
                    return null;
                }
                if (pendingIdleHandlerCount < 0 && (this.mMessages == null || now < this.mMessages.when)) {
                    pendingIdleHandlerCount = this.mIdleHandlers.size();
                }
                if (pendingIdleHandlerCount <= 0) {
                    this.mBlocked = true;
                    continue;
                }
                if (this.mPendingIdleHandlers == null) {
                    this.mPendingIdleHandlers = new IdleHandler[Math.max(pendingIdleHandlerCount, 4)];
                }
                this.mPendingIdleHandlers = this.mIdleHandlers.toArray(this.mPendingIdleHandlers);
            }
            for (int i = 0; i < pendingIdleHandlerCount; ++i) {
                IdleHandler idler = this.mPendingIdleHandlers[i];
                this.mPendingIdleHandlers[i] = null;
                boolean keep = false;
                try {
                    keep = idler.queueIdle();
                }
                catch (Throwable t) {
                    Log.wtf("MessageQueue", "IdleHandler threw exception", t);
                }
                if (keep) continue;
                MessageQueue messageQueue2 = this;
                synchronized (messageQueue2) {
                    this.mIdleHandlers.remove(idler);
                    continue;
                }
            }
            pendingIdleHandlerCount = 0;
            nextPollTimeoutMillis = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_os_MessageQueue$quit(boolean safe) {
        if (!this.mQuitAllowed) {
            throw new IllegalStateException("Main thread not allowed to quit.");
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            if (this.mQuitting) {
                return;
            }
            this.mQuitting = true;
            if (safe) {
                this.removeAllFutureMessagesLocked();
            } else {
                this.removeAllMessagesLocked();
            }
            MessageQueue.nativeWake(this.mPtr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_os_MessageQueue$enqueueSyncBarrier(long when) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            int token = this.mNextBarrierToken++;
            Message msg = Message.obtain();
            msg.markInUse();
            msg.when = when;
            msg.arg1 = token;
            Message prev = null;
            Message p = this.mMessages;
            if (when != 0L) {
                while (p != null && p.when <= when) {
                    prev = p;
                    p = p.next;
                }
            }
            if (prev != null) {
                msg.next = p;
                prev.next = msg;
            } else {
                msg.next = p;
                this.mMessages = msg;
            }
            return token;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_os_MessageQueue$removeSyncBarrier(int token) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            boolean needWake;
            Message prev = null;
            Message p = this.mMessages;
            while (p != null && (p.target != null || p.arg1 != token)) {
                prev = p;
                p = p.next;
            }
            if (p == null) {
                throw new IllegalStateException("The specified message queue synchronization  barrier token has not been posted or has already been removed.");
            }
            if (prev != null) {
                prev.next = p.next;
                needWake = false;
            } else {
                this.mMessages = p.next;
                needWake = this.mMessages == null || this.mMessages.target != null;
            }
            p.recycleUnchecked();
            if (needWake && !this.mQuitting) {
                MessageQueue.nativeWake(this.mPtr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_os_MessageQueue$enqueueMessage(Message msg, long when) {
        if (msg.target == null) {
            throw new IllegalArgumentException("Message must have a target.");
        }
        if (msg.isInUse()) {
            throw new IllegalStateException(msg + " This message is already in use.");
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            boolean needWake;
            if (this.mQuitting) {
                IllegalStateException e = new IllegalStateException(msg.target + " sending message to a Handler on a dead thread");
                Log.w("MessageQueue", e.getMessage(), e);
                msg.recycle();
                return false;
            }
            msg.markInUse();
            msg.when = when;
            Message p = this.mMessages;
            if (p == null || when == 0L || when < p.when) {
                msg.next = p;
                this.mMessages = msg;
                needWake = this.mBlocked;
            } else {
                needWake = this.mBlocked && p.target == null && msg.isAsynchronous();
                while (true) {
                    Message prev = p;
                    p = p.next;
                    if (p == null || when < p.when) break;
                    if (!needWake || !p.isAsynchronous()) continue;
                    needWake = false;
                }
                msg.next = p;
                prev.next = msg;
            }
            if (needWake) {
                MessageQueue.nativeWake(this.mPtr);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_os_MessageQueue$hasMessages(Handler h, int what, Object object) {
        if (h == null) {
            return false;
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message p = this.mMessages;
            while (p != null) {
                if (p.target == h && p.what == what && (object == null || p.obj == object)) {
                    return true;
                }
                p = p.next;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_os_MessageQueue$hasMessages(Handler h, Runnable r, Object object) {
        if (h == null) {
            return false;
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message p = this.mMessages;
            while (p != null) {
                if (p.target == h && p.callback == r && (object == null || p.obj == object)) {
                    return true;
                }
                p = p.next;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_os_MessageQueue$isIdling() {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            return this.isIdlingLocked();
        }
    }

    private final boolean $$robo$$android_os_MessageQueue$isIdlingLocked() {
        return !this.mQuitting && MessageQueue.nativeIsIdling(this.mPtr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_os_MessageQueue$removeMessages(Handler h, int what, Object object) {
        if (h == null) {
            return;
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n;
            Message p = this.mMessages;
            while (p != null && p.target == h && p.what == what && (object == null || p.obj == object)) {
                this.mMessages = n = p.next;
                p.recycleUnchecked();
                p = n;
            }
            while (p != null) {
                n = p.next;
                if (n != null && n.target == h && n.what == what && (object == null || n.obj == object)) {
                    Message nn = n.next;
                    n.recycleUnchecked();
                    p.next = nn;
                    continue;
                }
                p = n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_os_MessageQueue$removeMessages(Handler h, Runnable r, Object object) {
        if (h == null || r == null) {
            return;
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n;
            Message p = this.mMessages;
            while (p != null && p.target == h && p.callback == r && (object == null || p.obj == object)) {
                this.mMessages = n = p.next;
                p.recycleUnchecked();
                p = n;
            }
            while (p != null) {
                n = p.next;
                if (n != null && n.target == h && n.callback == r && (object == null || n.obj == object)) {
                    Message nn = n.next;
                    n.recycleUnchecked();
                    p.next = nn;
                    continue;
                }
                p = n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_os_MessageQueue$removeCallbacksAndMessages(Handler h, Object object) {
        if (h == null) {
            return;
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n;
            Message p = this.mMessages;
            while (p != null && p.target == h && (object == null || p.obj == object)) {
                this.mMessages = n = p.next;
                p.recycleUnchecked();
                p = n;
            }
            while (p != null) {
                n = p.next;
                if (n != null && n.target == h && (object == null || n.obj == object)) {
                    Message nn = n.next;
                    n.recycleUnchecked();
                    p.next = nn;
                    continue;
                }
                p = n;
            }
        }
    }

    private final void $$robo$$android_os_MessageQueue$removeAllMessagesLocked() {
        Message p = this.mMessages;
        while (p != null) {
            Message n = p.next;
            p.recycleUnchecked();
            p = n;
        }
        this.mMessages = null;
    }

    private final void $$robo$$android_os_MessageQueue$removeAllFutureMessagesLocked() {
        long now = SystemClock.uptimeMillis();
        Message p = this.mMessages;
        if (p != null) {
            if (p.when > now) {
                this.removeAllMessagesLocked();
            } else {
                Message n;
                while (true) {
                    if ((n = p.next) == null) {
                        return;
                    }
                    if (n.when > now) break;
                    p = n;
                }
                p.next = null;
                do {
                    p = n;
                    n = p.next;
                    p.recycleUnchecked();
                } while (n != null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_os_MessageQueue$dump(Printer pw, String prefix) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            long now = SystemClock.uptimeMillis();
            int n = 0;
            Message msg = this.mMessages;
            while (msg != null) {
                pw.println(prefix + "Message " + n + ": " + msg.toString(now));
                ++n;
                msg = msg.next;
            }
            pw.println(prefix + "(Total messages: " + n + ", idling=" + this.isIdlingLocked() + ", quitting=" + this.mQuitting + ")");
        }
    }

    private static final native /* synthetic */ long $$robo$$nativeInit$nativeBinding();

    private static long nativeInit() {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeInit", $$robo$$android_os_MessageQueue$nativeInit(), 1);
    }

    private static final native /* synthetic */ void $$robo$$nativeDestroy$nativeBinding(long var0);

    private static void nativeDestroy(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeDestroy", $$robo$$android_os_MessageQueue$nativeDestroy(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nativePollOnce$nativeBinding(long var0, int var2);

    private static void nativePollOnce(long l, int n) {
        InvokeDynamicSupport.bootstrapStatic("nativePollOnce", $$robo$$android_os_MessageQueue$nativePollOnce(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$nativeWake$nativeBinding(long var0);

    private static void nativeWake(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeWake", $$robo$$android_os_MessageQueue$nativeWake(long ), 1, (long)l);
    }

    private static final native /* synthetic */ boolean $$robo$$nativeIsIdling$nativeBinding(long var0);

    private static boolean nativeIsIdling(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeIsIdling", $$robo$$android_os_MessageQueue$nativeIsIdling(long ), 1, (long)l);
    }

    public void addIdleHandler(IdleHandler idleHandler) {
        InvokeDynamicSupport.bootstrap("addIdleHandler", $$robo$$android_os_MessageQueue$addIdleHandler(android.os.MessageQueue$IdleHandler ), 0, this, idleHandler);
    }

    public void removeIdleHandler(IdleHandler idleHandler) {
        InvokeDynamicSupport.bootstrap("removeIdleHandler", $$robo$$android_os_MessageQueue$removeIdleHandler(android.os.MessageQueue$IdleHandler ), 0, this, idleHandler);
    }

    private void __constructor__(boolean bl) {
        this.$$robo$$android_os_MessageQueue$__constructor__(bl);
    }

    MessageQueue(boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_MessageQueue$__constructor__(boolean ), 0, this, bl);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_os_MessageQueue$finalize(), 0, this);
    }

    private void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$android_os_MessageQueue$dispose(), 0, this);
    }

    Message next() {
        return InvokeDynamicSupport.bootstrap("next", $$robo$$android_os_MessageQueue$next(), 0, this);
    }

    void quit(boolean bl) {
        InvokeDynamicSupport.bootstrap("quit", $$robo$$android_os_MessageQueue$quit(boolean ), 0, this, bl);
    }

    int enqueueSyncBarrier(long l) {
        return (int)InvokeDynamicSupport.bootstrap("enqueueSyncBarrier", $$robo$$android_os_MessageQueue$enqueueSyncBarrier(long ), 0, this, l);
    }

    void removeSyncBarrier(int n) {
        InvokeDynamicSupport.bootstrap("removeSyncBarrier", $$robo$$android_os_MessageQueue$removeSyncBarrier(int ), 0, this, n);
    }

    boolean enqueueMessage(Message message, long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("enqueueMessage", $$robo$$android_os_MessageQueue$enqueueMessage(android.os.Message long ), 0, this, message, l);
    }

    boolean hasMessages(Handler handler, int n, Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasMessages", $$robo$$android_os_MessageQueue$hasMessages(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    boolean hasMessages(Handler handler, Runnable runnable, Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasMessages", $$robo$$android_os_MessageQueue$hasMessages(android.os.Handler java.lang.Runnable java.lang.Object ), 0, this, handler, runnable, object);
    }

    boolean isIdling() {
        return (boolean)InvokeDynamicSupport.bootstrap("isIdling", $$robo$$android_os_MessageQueue$isIdling(), 0, this);
    }

    private boolean isIdlingLocked() {
        return (boolean)InvokeDynamicSupport.bootstrap("isIdlingLocked", $$robo$$android_os_MessageQueue$isIdlingLocked(), 0, this);
    }

    void removeMessages(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("removeMessages", $$robo$$android_os_MessageQueue$removeMessages(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    void removeMessages(Handler handler, Runnable runnable, Object object) {
        InvokeDynamicSupport.bootstrap("removeMessages", $$robo$$android_os_MessageQueue$removeMessages(android.os.Handler java.lang.Runnable java.lang.Object ), 0, this, handler, runnable, object);
    }

    void removeCallbacksAndMessages(Handler handler, Object object) {
        InvokeDynamicSupport.bootstrap("removeCallbacksAndMessages", $$robo$$android_os_MessageQueue$removeCallbacksAndMessages(android.os.Handler java.lang.Object ), 0, this, handler, object);
    }

    private void removeAllMessagesLocked() {
        InvokeDynamicSupport.bootstrap("removeAllMessagesLocked", $$robo$$android_os_MessageQueue$removeAllMessagesLocked(), 0, this);
    }

    private void removeAllFutureMessagesLocked() {
        InvokeDynamicSupport.bootstrap("removeAllFutureMessagesLocked", $$robo$$android_os_MessageQueue$removeAllFutureMessagesLocked(), 0, this);
    }

    void dump(Printer printer, String string2) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_os_MessageQueue$dump(android.util.Printer java.lang.String ), 0, this, printer, string2);
    }

    public /* synthetic */ MessageQueue() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MessageQueue)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface IdleHandler
    extends InstrumentedInterface {
        public boolean queueIdle();
    }
}

