/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.content.Context;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.IPowerManager;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.os.Trace;
import android.os.WorkSource;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class PowerManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "PowerManager";
    public static int PARTIAL_WAKE_LOCK = 1;
    @Deprecated
    public static int SCREEN_DIM_WAKE_LOCK = 6;
    @Deprecated
    public static int SCREEN_BRIGHT_WAKE_LOCK = 10;
    @Deprecated
    public static int FULL_WAKE_LOCK = 26;
    public static int PROXIMITY_SCREEN_OFF_WAKE_LOCK = 32;
    public static int DOZE_WAKE_LOCK = 64;
    public static int WAKE_LOCK_LEVEL_MASK = 65535;
    public static int ACQUIRE_CAUSES_WAKEUP = 0x10000000;
    public static int ON_AFTER_RELEASE = 0x20000000;
    public static int UNIMPORTANT_FOR_LOGGING = 0x40000000;
    public static int RELEASE_FLAG_WAIT_FOR_NO_PROXIMITY = 1;
    public static int BRIGHTNESS_ON = 255;
    public static int BRIGHTNESS_OFF = 0;
    public static int BRIGHTNESS_DEFAULT = -1;
    public static int USER_ACTIVITY_EVENT_OTHER = 0;
    public static int USER_ACTIVITY_EVENT_BUTTON = 1;
    public static int USER_ACTIVITY_EVENT_TOUCH = 2;
    public static int USER_ACTIVITY_FLAG_NO_CHANGE_LIGHTS = 1;
    public static int USER_ACTIVITY_FLAG_INDIRECT = 2;
    public static int GO_TO_SLEEP_REASON_APPLICATION = 0;
    public static int GO_TO_SLEEP_REASON_DEVICE_ADMIN = 1;
    public static int GO_TO_SLEEP_REASON_TIMEOUT = 2;
    public static int GO_TO_SLEEP_REASON_LID_SWITCH = 3;
    public static int GO_TO_SLEEP_REASON_POWER_BUTTON = 4;
    public static int GO_TO_SLEEP_REASON_HDMI = 5;
    public static int GO_TO_SLEEP_FLAG_NO_DOZE = 1;
    public static String REBOOT_RECOVERY = "recovery";
    Context mContext;
    IPowerManager mService;
    Handler mHandler;
    public static String ACTION_POWER_SAVE_MODE_CHANGED = "android.os.action.POWER_SAVE_MODE_CHANGED";
    public static String ACTION_POWER_SAVE_MODE_CHANGING = "android.os.action.POWER_SAVE_MODE_CHANGING";
    public static String EXTRA_POWER_SAVE_MODE = "mode";

    private void $$robo$$android_os_PowerManager$__constructor__(Context context, IPowerManager service, Handler handler) {
        this.mContext = context;
        this.mService = service;
        this.mHandler = handler;
    }

    private final int $$robo$$android_os_PowerManager$getMinimumScreenBrightnessSetting() {
        return this.mContext.getResources().getInteger(17694795);
    }

    private final int $$robo$$android_os_PowerManager$getMaximumScreenBrightnessSetting() {
        return this.mContext.getResources().getInteger(17694796);
    }

    private final int $$robo$$android_os_PowerManager$getDefaultScreenBrightnessSetting() {
        return this.mContext.getResources().getInteger(17694797);
    }

    private static final boolean $$robo$$android_os_PowerManager$useTwilightAdjustmentFeature() {
        return SystemProperties.getBoolean("persist.power.usetwilightadj", false);
    }

    private final WakeLock $$robo$$android_os_PowerManager$newWakeLock(int levelAndFlags, String tag) {
        PowerManager.validateWakeLockParameters(levelAndFlags, tag);
        return new WakeLock(this, levelAndFlags, tag, this.mContext.getOpPackageName());
    }

    private static final void $$robo$$android_os_PowerManager$validateWakeLockParameters(int levelAndFlags, String tag) {
        switch (levelAndFlags & 0xFFFF) {
            case 1: 
            case 6: 
            case 10: 
            case 26: 
            case 32: 
            case 64: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Must specify a valid wake lock level.");
            }
        }
        if (tag == null) {
            throw new IllegalArgumentException("The tag must not be null.");
        }
    }

    @Deprecated
    private final void $$robo$$android_os_PowerManager$userActivity(long when, boolean noChangeLights) {
        this.userActivity(when, 0, noChangeLights ? 1 : 0);
    }

    private final void $$robo$$android_os_PowerManager$userActivity(long when, int event, int flags) {
        try {
            this.mService.userActivity(when, event, flags);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_os_PowerManager$goToSleep(long time) {
        this.goToSleep(time, 0, 0);
    }

    private final void $$robo$$android_os_PowerManager$goToSleep(long time, int reason, int flags) {
        try {
            this.mService.goToSleep(time, reason, flags);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_os_PowerManager$wakeUp(long time) {
        try {
            this.mService.wakeUp(time);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_os_PowerManager$nap(long time) {
        try {
            this.mService.nap(time);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_os_PowerManager$setBacklightBrightness(int brightness) {
        try {
            this.mService.setTemporaryScreenBrightnessSettingOverride(brightness);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final boolean $$robo$$android_os_PowerManager$isWakeLockLevelSupported(int level) {
        try {
            return this.mService.isWakeLockLevelSupported(level);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Deprecated
    private final boolean $$robo$$android_os_PowerManager$isScreenOn() {
        return this.isInteractive();
    }

    private final boolean $$robo$$android_os_PowerManager$isInteractive() {
        try {
            return this.mService.isInteractive();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private final void $$robo$$android_os_PowerManager$reboot(String reason) {
        try {
            this.mService.reboot(false, reason, true);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final boolean $$robo$$android_os_PowerManager$isPowerSaveMode() {
        try {
            return this.mService.isPowerSaveMode();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private final boolean $$robo$$android_os_PowerManager$setPowerSaveMode(boolean mode) {
        try {
            return this.mService.setPowerSaveMode(mode);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private void __constructor__(Context context, IPowerManager iPowerManager, Handler handler) {
        this.$$robo$$android_os_PowerManager$__constructor__(context, iPowerManager, handler);
    }

    public PowerManager(Context context, IPowerManager iPowerManager, Handler handler) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_PowerManager$__constructor__(android.content.Context android.os.IPowerManager android.os.Handler ), 0, this, context, iPowerManager, handler);
    }

    public int getMinimumScreenBrightnessSetting() {
        return (int)InvokeDynamicSupport.bootstrap("getMinimumScreenBrightnessSetting", $$robo$$android_os_PowerManager$getMinimumScreenBrightnessSetting(), 0, this);
    }

    public int getMaximumScreenBrightnessSetting() {
        return (int)InvokeDynamicSupport.bootstrap("getMaximumScreenBrightnessSetting", $$robo$$android_os_PowerManager$getMaximumScreenBrightnessSetting(), 0, this);
    }

    public int getDefaultScreenBrightnessSetting() {
        return (int)InvokeDynamicSupport.bootstrap("getDefaultScreenBrightnessSetting", $$robo$$android_os_PowerManager$getDefaultScreenBrightnessSetting(), 0, this);
    }

    public static boolean useTwilightAdjustmentFeature() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("useTwilightAdjustmentFeature", $$robo$$android_os_PowerManager$useTwilightAdjustmentFeature(), 0);
    }

    public WakeLock newWakeLock(int n, String string2) {
        return InvokeDynamicSupport.bootstrap("newWakeLock", $$robo$$android_os_PowerManager$newWakeLock(int java.lang.String ), 0, this, n, string2);
    }

    public static void validateWakeLockParameters(int n, String string2) {
        InvokeDynamicSupport.bootstrapStatic("validateWakeLockParameters", $$robo$$android_os_PowerManager$validateWakeLockParameters(int java.lang.String ), 0, (int)n, (String)string2);
    }

    @Deprecated
    public void userActivity(long l, boolean bl) {
        InvokeDynamicSupport.bootstrap("userActivity", $$robo$$android_os_PowerManager$userActivity(long boolean ), 0, this, l, bl);
    }

    public void userActivity(long l, int n, int n2) {
        InvokeDynamicSupport.bootstrap("userActivity", $$robo$$android_os_PowerManager$userActivity(long int int ), 0, this, l, n, n2);
    }

    public void goToSleep(long l) {
        InvokeDynamicSupport.bootstrap("goToSleep", $$robo$$android_os_PowerManager$goToSleep(long ), 0, this, l);
    }

    public void goToSleep(long l, int n, int n2) {
        InvokeDynamicSupport.bootstrap("goToSleep", $$robo$$android_os_PowerManager$goToSleep(long int int ), 0, this, l, n, n2);
    }

    public void wakeUp(long l) {
        InvokeDynamicSupport.bootstrap("wakeUp", $$robo$$android_os_PowerManager$wakeUp(long ), 0, this, l);
    }

    public void nap(long l) {
        InvokeDynamicSupport.bootstrap("nap", $$robo$$android_os_PowerManager$nap(long ), 0, this, l);
    }

    public void setBacklightBrightness(int n) {
        InvokeDynamicSupport.bootstrap("setBacklightBrightness", $$robo$$android_os_PowerManager$setBacklightBrightness(int ), 0, this, n);
    }

    public boolean isWakeLockLevelSupported(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isWakeLockLevelSupported", $$robo$$android_os_PowerManager$isWakeLockLevelSupported(int ), 0, this, n);
    }

    @Deprecated
    public boolean isScreenOn() {
        return (boolean)InvokeDynamicSupport.bootstrap("isScreenOn", $$robo$$android_os_PowerManager$isScreenOn(), 0, this);
    }

    public boolean isInteractive() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInteractive", $$robo$$android_os_PowerManager$isInteractive(), 0, this);
    }

    public void reboot(String string2) {
        InvokeDynamicSupport.bootstrap("reboot", $$robo$$android_os_PowerManager$reboot(java.lang.String ), 0, this, string2);
    }

    public boolean isPowerSaveMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPowerSaveMode", $$robo$$android_os_PowerManager$isPowerSaveMode(), 0, this);
    }

    public boolean setPowerSaveMode(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setPowerSaveMode", $$robo$$android_os_PowerManager$setPowerSaveMode(boolean ), 0, this, bl);
    }

    public /* synthetic */ PowerManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PowerManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public final class WakeLock
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mFlags;
        private String mTag;
        private String mPackageName;
        private IBinder mToken;
        private int mCount;
        private boolean mRefCounted;
        private boolean mHeld;
        private WorkSource mWorkSource;
        private String mHistoryTag;
        private String mTraceName;
        private Runnable mReleaser;
        /* synthetic */ PowerManager this$0;

        private void $$robo$$android_os_PowerManager_WakeLock$__constructor__(PowerManager powerManager, int flags, String tag, String packageName) {
            this.mRefCounted = true;
            this.mReleaser = new Runnable(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ WakeLock this$1;

                private void $$robo$$android_os_PowerManager_WakeLock_1$__constructor__(WakeLock wakeLock) {
                }

                private final void $$robo$$android_os_PowerManager_WakeLock_1$run() {
                    this.this$1.release();
                }

                private void __constructor__(WakeLock wakeLock) {
                    this.$$robo$$android_os_PowerManager_WakeLock_1$__constructor__(wakeLock);
                }
                {
                    this.this$1 = wakeLock;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_PowerManager_WakeLock_1$__constructor__(android.os.PowerManager$WakeLock ), 0, this, wakeLock);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_os_PowerManager_WakeLock_1$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mFlags = flags;
            this.mTag = tag;
            this.mPackageName = packageName;
            this.mToken = new Binder();
            this.mTraceName = "WakeLock (" + this.mTag + ")";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_os_PowerManager_WakeLock$finalize() throws Throwable {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                if (this.mHeld) {
                    Log.wtf("PowerManager", "WakeLock finalized while still held: " + this.mTag);
                    Trace.asyncTraceEnd(131072L, this.mTraceName, 0);
                    try {
                        this.this$0.mService.releaseWakeLock(this.mToken, 0);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_os_PowerManager_WakeLock$setReferenceCounted(boolean value) {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                this.mRefCounted = value;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_os_PowerManager_WakeLock$acquire() {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                this.acquireLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_os_PowerManager_WakeLock$acquire(long timeout) {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                this.acquireLocked();
                this.this$0.mHandler.postDelayed(this.mReleaser, timeout);
            }
        }

        private final void $$robo$$android_os_PowerManager_WakeLock$acquireLocked() {
            if (!this.mRefCounted || this.mCount++ == 0) {
                this.this$0.mHandler.removeCallbacks(this.mReleaser);
                Trace.asyncTraceBegin(131072L, this.mTraceName, 0);
                try {
                    this.this$0.mService.acquireWakeLock(this.mToken, this.mFlags, this.mTag, this.mPackageName, this.mWorkSource, this.mHistoryTag);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                this.mHeld = true;
            }
        }

        private final void $$robo$$android_os_PowerManager_WakeLock$release() {
            this.release(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_os_PowerManager_WakeLock$release(int flags) {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                if (!this.mRefCounted || --this.mCount == 0) {
                    this.this$0.mHandler.removeCallbacks(this.mReleaser);
                    if (this.mHeld) {
                        Trace.asyncTraceEnd(131072L, this.mTraceName, 0);
                        try {
                            this.this$0.mService.releaseWakeLock(this.mToken, flags);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                        this.mHeld = false;
                    }
                }
                if (this.mCount < 0) {
                    throw new RuntimeException("WakeLock under-locked " + this.mTag);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean $$robo$$android_os_PowerManager_WakeLock$isHeld() {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                return this.mHeld;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_os_PowerManager_WakeLock$setWorkSource(WorkSource ws) {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                boolean changed;
                if (ws != null && ws.size() == 0) {
                    ws = null;
                }
                if (ws == null) {
                    changed = this.mWorkSource != null;
                    this.mWorkSource = null;
                } else if (this.mWorkSource == null) {
                    changed = true;
                    this.mWorkSource = new WorkSource(ws);
                } else {
                    changed = this.mWorkSource.diff(ws);
                    if (changed) {
                        this.mWorkSource.set(ws);
                    }
                }
                if (changed && this.mHeld) {
                    try {
                        this.this$0.mService.updateWakeLockWorkSource(this.mToken, this.mWorkSource, this.mHistoryTag);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
        }

        private final void $$robo$$android_os_PowerManager_WakeLock$setTag(String tag) {
            this.mTag = tag;
        }

        private final void $$robo$$android_os_PowerManager_WakeLock$setHistoryTag(String tag) {
            this.mHistoryTag = tag;
        }

        private final void $$robo$$android_os_PowerManager_WakeLock$setUnimportantForLogging(boolean state) {
            this.mFlags = state ? (this.mFlags |= 0x40000000) : (this.mFlags &= 0xBFFFFFFF);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final String $$robo$$android_os_PowerManager_WakeLock$toString() {
            IBinder iBinder = this.mToken;
            synchronized (iBinder) {
                return "WakeLock{" + Integer.toHexString(System.identityHashCode(this)) + " held=" + this.mHeld + ", refCount=" + this.mCount + "}";
            }
        }

        private void __constructor__(PowerManager powerManager, int n, String string2, String string3) {
            this.$$robo$$android_os_PowerManager_WakeLock$__constructor__(powerManager, n, string2, string3);
        }

        WakeLock(PowerManager powerManager, int n, String string2, String string3) {
            this.this$0 = powerManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_PowerManager_WakeLock$__constructor__(android.os.PowerManager int java.lang.String java.lang.String ), 0, this, powerManager, n, string2, string3);
        }

        protected void finalize() throws Throwable {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_os_PowerManager_WakeLock$finalize(), 0, this);
        }

        public void setReferenceCounted(boolean bl) {
            InvokeDynamicSupport.bootstrap("setReferenceCounted", $$robo$$android_os_PowerManager_WakeLock$setReferenceCounted(boolean ), 0, this, bl);
        }

        public void acquire() {
            InvokeDynamicSupport.bootstrap("acquire", $$robo$$android_os_PowerManager_WakeLock$acquire(), 0, this);
        }

        public void acquire(long l) {
            InvokeDynamicSupport.bootstrap("acquire", $$robo$$android_os_PowerManager_WakeLock$acquire(long ), 0, this, l);
        }

        private void acquireLocked() {
            InvokeDynamicSupport.bootstrap("acquireLocked", $$robo$$android_os_PowerManager_WakeLock$acquireLocked(), 0, this);
        }

        public void release() {
            InvokeDynamicSupport.bootstrap("release", $$robo$$android_os_PowerManager_WakeLock$release(), 0, this);
        }

        public void release(int n) {
            InvokeDynamicSupport.bootstrap("release", $$robo$$android_os_PowerManager_WakeLock$release(int ), 0, this, n);
        }

        public boolean isHeld() {
            return (boolean)InvokeDynamicSupport.bootstrap("isHeld", $$robo$$android_os_PowerManager_WakeLock$isHeld(), 0, this);
        }

        public void setWorkSource(WorkSource workSource) {
            InvokeDynamicSupport.bootstrap("setWorkSource", $$robo$$android_os_PowerManager_WakeLock$setWorkSource(android.os.WorkSource ), 0, this, workSource);
        }

        public void setTag(String string2) {
            InvokeDynamicSupport.bootstrap("setTag", $$robo$$android_os_PowerManager_WakeLock$setTag(java.lang.String ), 0, this, string2);
        }

        public void setHistoryTag(String string2) {
            InvokeDynamicSupport.bootstrap("setHistoryTag", $$robo$$android_os_PowerManager_WakeLock$setHistoryTag(java.lang.String ), 0, this, string2);
        }

        public void setUnimportantForLogging(boolean bl) {
            InvokeDynamicSupport.bootstrap("setUnimportantForLogging", $$robo$$android_os_PowerManager_WakeLock$setUnimportantForLogging(boolean ), 0, this, bl);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_os_PowerManager_WakeLock$toString(), 0, this);
        }

        public /* synthetic */ WakeLock() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WakeLock)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

