/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.UserHandle;
import android.os.ZygoteStartFailedEx;
import android.system.Os;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Process
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "Process";
    public static String ZYGOTE_SOCKET = "zygote";
    public static String SECONDARY_ZYGOTE_SOCKET = "zygote_secondary";
    public static int ROOT_UID = 0;
    public static int SYSTEM_UID = 1000;
    public static int PHONE_UID = 1001;
    public static int SHELL_UID = 2000;
    public static int LOG_UID = 1007;
    public static int WIFI_UID = 1010;
    public static int MEDIA_UID = 1013;
    public static int DRM_UID = 1019;
    public static int VPN_UID = 1016;
    public static int NFC_UID = 1027;
    public static int BLUETOOTH_UID = 1002;
    public static int MEDIA_RW_GID = 1023;
    public static int PACKAGE_INFO_GID = 1032;
    public static int SHARED_RELRO_UID = 1037;
    public static int FIRST_APPLICATION_UID = 10000;
    public static int LAST_APPLICATION_UID = 19999;
    public static int FIRST_ISOLATED_UID = 99000;
    public static int LAST_ISOLATED_UID = 99999;
    public static int SHARED_USER_GID = 9997;
    public static int FIRST_SHARED_APPLICATION_GID = 50000;
    public static int LAST_SHARED_APPLICATION_GID = 59999;
    public static int THREAD_PRIORITY_DEFAULT = 0;
    public static int THREAD_PRIORITY_LOWEST = 19;
    public static int THREAD_PRIORITY_BACKGROUND = 10;
    public static int THREAD_PRIORITY_FOREGROUND = -2;
    public static int THREAD_PRIORITY_DISPLAY = -4;
    public static int THREAD_PRIORITY_URGENT_DISPLAY = -8;
    public static int THREAD_PRIORITY_AUDIO = -16;
    public static int THREAD_PRIORITY_URGENT_AUDIO = -19;
    public static int THREAD_PRIORITY_MORE_FAVORABLE = -1;
    public static int THREAD_PRIORITY_LESS_FAVORABLE = 1;
    public static int SCHED_OTHER = 0;
    public static int SCHED_FIFO = 1;
    public static int SCHED_RR = 2;
    public static int SCHED_BATCH = 3;
    public static int SCHED_IDLE = 5;
    public static int THREAD_GROUP_DEFAULT = -1;
    public static int THREAD_GROUP_BG_NONINTERACTIVE = 0;
    private static int THREAD_GROUP_FOREGROUND = 1;
    public static int THREAD_GROUP_SYSTEM = 2;
    public static int THREAD_GROUP_AUDIO_APP = 3;
    public static int THREAD_GROUP_AUDIO_SYS = 4;
    public static int SIGNAL_QUIT = 3;
    public static int SIGNAL_KILL = 9;
    public static int SIGNAL_USR1 = 10;
    static ZygoteState primaryZygoteState;
    static ZygoteState secondaryZygoteState;
    static int ZYGOTE_RETRY_MILLIS = 500;
    public static int PROC_TERM_MASK = 255;
    public static int PROC_ZERO_TERM = 0;
    public static int PROC_SPACE_TERM = 32;
    public static int PROC_TAB_TERM = 9;
    public static int PROC_COMBINE = 256;
    public static int PROC_PARENS = 512;
    public static int PROC_QUOTES = 1024;
    public static int PROC_OUT_STRING = 4096;
    public static int PROC_OUT_LONG = 8192;
    public static int PROC_OUT_FLOAT = 16384;

    private void $$robo$$android_os_Process$__constructor__() {
    }

    private static final ProcessStartResult $$robo$$android_os_Process$start(String processClass, String niceName, int uid, int gid, int[] gids, int debugFlags, int mountExternal, int targetSdkVersion, String seInfo, String abi, String instructionSet, String appDataDir, String[] zygoteArgs) {
        try {
            return Process.startViaZygote(processClass, niceName, uid, gid, gids, debugFlags, mountExternal, targetSdkVersion, seInfo, abi, instructionSet, appDataDir, zygoteArgs);
        }
        catch (ZygoteStartFailedEx ex) {
            Log.e("Process", "Starting VM process through Zygote failed");
            throw new RuntimeException("Starting VM process through Zygote failed", ex);
        }
    }

    private static final String $$robo$$android_os_Process$getAbiList(BufferedWriter writer, DataInputStream inputStream) throws IOException {
        writer.write("1");
        writer.newLine();
        writer.write("--query-abi-list");
        writer.newLine();
        writer.flush();
        int numBytes = inputStream.readInt();
        byte[] bytes = new byte[numBytes];
        inputStream.readFully(bytes);
        return new String(bytes, StandardCharsets.US_ASCII);
    }

    private static final ProcessStartResult $$robo$$android_os_Process$zygoteSendArgsAndGetResult(ZygoteState zygoteState, ArrayList<String> args) throws ZygoteStartFailedEx {
        try {
            BufferedWriter writer = zygoteState.writer;
            DataInputStream inputStream = zygoteState.inputStream;
            writer.write(Integer.toString(args.size()));
            writer.newLine();
            int sz = args.size();
            for (int i = 0; i < sz; ++i) {
                String arg = args.get(i);
                if (arg.indexOf(10) >= 0) {
                    throw new ZygoteStartFailedEx("embedded newlines not allowed");
                }
                writer.write(arg);
                writer.newLine();
            }
            writer.flush();
            ProcessStartResult result = new ProcessStartResult();
            result.pid = inputStream.readInt();
            if (result.pid < 0) {
                throw new ZygoteStartFailedEx("fork() failed");
            }
            result.usingWrapper = inputStream.readBoolean();
            return result;
        }
        catch (IOException ex) {
            zygoteState.close();
            throw new ZygoteStartFailedEx(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ProcessStartResult $$robo$$android_os_Process$startViaZygote(String processClass, String niceName, int uid, int gid, int[] gids, int debugFlags, int mountExternal, int targetSdkVersion, String seInfo, String abi, String instructionSet, String appDataDir, String[] extraArgs) throws ZygoteStartFailedEx {
        Class<Process> clazz = Process.class;
        synchronized (Process.class) {
            ArrayList<String> argsForZygote = new ArrayList<String>();
            argsForZygote.add("--runtime-init");
            argsForZygote.add("--setuid=" + uid);
            argsForZygote.add("--setgid=" + gid);
            if ((debugFlags & 0x10) != 0) {
                argsForZygote.add("--enable-jni-logging");
            }
            if ((debugFlags & 8) != 0) {
                argsForZygote.add("--enable-safemode");
            }
            if ((debugFlags & 1) != 0) {
                argsForZygote.add("--enable-debugger");
            }
            if ((debugFlags & 2) != 0) {
                argsForZygote.add("--enable-checkjni");
            }
            if ((debugFlags & 4) != 0) {
                argsForZygote.add("--enable-assert");
            }
            if (mountExternal == 2) {
                argsForZygote.add("--mount-external-multiuser");
            } else if (mountExternal == 3) {
                argsForZygote.add("--mount-external-multiuser-all");
            }
            argsForZygote.add("--target-sdk-version=" + targetSdkVersion);
            if (gids != null && gids.length > 0) {
                StringBuilder sb = new StringBuilder();
                sb.append("--setgroups=");
                int sz = gids.length;
                for (int i = 0; i < sz; ++i) {
                    if (i != 0) {
                        sb.append(',');
                    }
                    sb.append(gids[i]);
                }
                argsForZygote.add(sb.toString());
            }
            if (niceName != null) {
                argsForZygote.add("--nice-name=" + niceName);
            }
            if (seInfo != null) {
                argsForZygote.add("--seinfo=" + seInfo);
            }
            if (instructionSet != null) {
                argsForZygote.add("--instruction-set=" + instructionSet);
            }
            if (appDataDir != null) {
                argsForZygote.add("--app-data-dir=" + appDataDir);
            }
            argsForZygote.add(processClass);
            if (extraArgs != null) {
                for (String arg : extraArgs) {
                    argsForZygote.add(arg);
                }
            }
            // ** MonitorExit[var13_13] (shouldn't be in output)
            return Process.zygoteSendArgsAndGetResult(Process.openZygoteSocketIfNeeded(abi), argsForZygote);
        }
    }

    private static final ZygoteState $$robo$$android_os_Process$openZygoteSocketIfNeeded(String abi) throws ZygoteStartFailedEx {
        if (primaryZygoteState == null || primaryZygoteState.isClosed()) {
            try {
                primaryZygoteState = ZygoteState.connect("zygote");
            }
            catch (IOException ioe) {
                throw new ZygoteStartFailedEx("Error connecting to primary zygote", ioe);
            }
        }
        if (primaryZygoteState.matches(abi)) {
            return primaryZygoteState;
        }
        if (secondaryZygoteState == null || secondaryZygoteState.isClosed()) {
            try {
                secondaryZygoteState = ZygoteState.connect("zygote_secondary");
            }
            catch (IOException ioe) {
                throw new ZygoteStartFailedEx("Error connecting to secondary zygote", ioe);
            }
        }
        if (secondaryZygoteState.matches(abi)) {
            return secondaryZygoteState;
        }
        throw new ZygoteStartFailedEx("Unsupported zygote ABI: " + abi);
    }

    private static final long $$robo$$android_os_Process$getElapsedCpuTime() {
        return 0L;
    }

    private static final int $$robo$$android_os_Process$myPid() {
        return Os.getpid();
    }

    private static final int $$robo$$android_os_Process$myPpid() {
        return Os.getppid();
    }

    private static final int $$robo$$android_os_Process$myTid() {
        return Os.gettid();
    }

    private static final int $$robo$$android_os_Process$myUid() {
        return Os.getuid();
    }

    private static final UserHandle $$robo$$android_os_Process$myUserHandle() {
        return new UserHandle(UserHandle.getUserId(Process.myUid()));
    }

    private static final boolean $$robo$$android_os_Process$isIsolated() {
        int uid = UserHandle.getAppId(Process.myUid());
        return uid >= 99000 && uid <= 99999;
    }

    private static final int $$robo$$android_os_Process$getUidForName(String string2) {
        return 0;
    }

    private static final int $$robo$$android_os_Process$getGidForName(String string2) {
        return 0;
    }

    private static final int $$robo$$android_os_Process$getUidForPid(int pid) {
        String[] procStatusLabels = new String[]{"Uid:"};
        long[] procStatusValues = new long[]{-1L};
        Process.readProcLines("/proc/" + pid + "/status", procStatusLabels, procStatusValues);
        return (int)procStatusValues[0];
    }

    private static final int $$robo$$android_os_Process$getParentPid(int pid) {
        String[] procStatusLabels = new String[]{"PPid:"};
        long[] procStatusValues = new long[]{-1L};
        Process.readProcLines("/proc/" + pid + "/status", procStatusLabels, procStatusValues);
        return (int)procStatusValues[0];
    }

    private static final int $$robo$$android_os_Process$getThreadGroupLeader(int tid) {
        String[] procStatusLabels = new String[]{"Tgid:"};
        long[] procStatusValues = new long[]{-1L};
        Process.readProcLines("/proc/" + tid + "/status", procStatusLabels, procStatusValues);
        return (int)procStatusValues[0];
    }

    private static final void $$robo$$android_os_Process$setThreadPriority(int n, int n2) throws IllegalArgumentException, SecurityException {
    }

    private static final void $$robo$$android_os_Process$setCanSelfBackground(boolean bl) {
    }

    private static final void $$robo$$android_os_Process$setThreadGroup(int n, int n2) throws IllegalArgumentException, SecurityException {
    }

    private static final void $$robo$$android_os_Process$setProcessGroup(int n, int n2) throws IllegalArgumentException, SecurityException {
    }

    private static final int $$robo$$android_os_Process$getProcessGroup(int n) throws IllegalArgumentException, SecurityException {
        return 0;
    }

    private static final void $$robo$$android_os_Process$setThreadPriority(int n) throws IllegalArgumentException, SecurityException {
    }

    private static final int $$robo$$android_os_Process$getThreadPriority(int n) throws IllegalArgumentException {
        return 0;
    }

    private static final void $$robo$$android_os_Process$setThreadScheduler(int n, int n2, int n3) throws IllegalArgumentException {
    }

    @Deprecated
    private static final boolean $$robo$$android_os_Process$supportsProcesses() {
        return true;
    }

    private static final boolean $$robo$$android_os_Process$setSwappiness(int n, boolean bl) {
        return false;
    }

    private static final void $$robo$$android_os_Process$setArgV0(String string2) {
    }

    private static final void $$robo$$android_os_Process$killProcess(int pid) {
        Process.sendSignal(pid, 9);
    }

    private static final int $$robo$$android_os_Process$setUid(int n) {
        return 0;
    }

    private static final int $$robo$$android_os_Process$setGid(int n) {
        return 0;
    }

    private static final void $$robo$$android_os_Process$sendSignal(int n, int n2) {
    }

    private static final void $$robo$$android_os_Process$killProcessQuiet(int pid) {
        Process.sendSignalQuiet(pid, 9);
    }

    private static final void $$robo$$android_os_Process$sendSignalQuiet(int n, int n2) {
    }

    private static final long $$robo$$android_os_Process$getFreeMemory() {
        return 0L;
    }

    private static final long $$robo$$android_os_Process$getTotalMemory() {
        return 0L;
    }

    private static final void $$robo$$android_os_Process$readProcLines(String string2, String[] stringArray, long[] lArray) {
    }

    private static final int[] $$robo$$android_os_Process$getPids(String string2, int[] nArray) {
        return null;
    }

    private static final boolean $$robo$$android_os_Process$readProcFile(String string2, int[] nArray, String[] stringArray, long[] lArray, float[] fArray) {
        return false;
    }

    private static final boolean $$robo$$android_os_Process$parseProcLine(byte[] byArray, int n, int n2, int[] nArray, String[] stringArray, long[] lArray, float[] fArray) {
        return false;
    }

    private static final int[] $$robo$$android_os_Process$getPidsForCommands(String[] stringArray) {
        return null;
    }

    private static final long $$robo$$android_os_Process$getPss(int n) {
        return 0L;
    }

    private static final int $$robo$$android_os_Process$killProcessGroup(int n, int n2) {
        return 0;
    }

    private static final void $$robo$$android_os_Process$removeAllProcessGroups() {
    }

    private void __constructor__() {
        this.$$robo$$android_os_Process$__constructor__();
    }

    public Process() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_Process$__constructor__(), 0, this);
    }

    public static ProcessStartResult start(String string2, String string3, int n, int n2, int[] nArray, int n3, int n4, int n5, String string4, String string5, String string6, String string7, String[] stringArray) {
        return InvokeDynamicSupport.bootstrapStatic("start", $$robo$$android_os_Process$start(java.lang.String java.lang.String int int int[] int int int java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String[] ), 0, (String)string2, (String)string3, (int)n, (int)n2, (int[])nArray, (int)n3, (int)n4, (int)n5, (String)string4, (String)string5, (String)string6, (String)string7, (String[])stringArray);
    }

    private static String getAbiList(BufferedWriter bufferedWriter, DataInputStream dataInputStream) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("getAbiList", $$robo$$android_os_Process$getAbiList(java.io.BufferedWriter java.io.DataInputStream ), 0, (BufferedWriter)bufferedWriter, (DataInputStream)dataInputStream);
    }

    private static ProcessStartResult zygoteSendArgsAndGetResult(ZygoteState zygoteState, ArrayList<String> arrayList) throws ZygoteStartFailedEx {
        return InvokeDynamicSupport.bootstrapStatic("zygoteSendArgsAndGetResult", $$robo$$android_os_Process$zygoteSendArgsAndGetResult(android.os.Process$ZygoteState java.util.ArrayList<java.lang.String> ), 0, (ZygoteState)zygoteState, arrayList);
    }

    private static ProcessStartResult startViaZygote(String string2, String string3, int n, int n2, int[] nArray, int n3, int n4, int n5, String string4, String string5, String string6, String string7, String[] stringArray) throws ZygoteStartFailedEx {
        return InvokeDynamicSupport.bootstrapStatic("startViaZygote", $$robo$$android_os_Process$startViaZygote(java.lang.String java.lang.String int int int[] int int int java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String[] ), 0, (String)string2, (String)string3, (int)n, (int)n2, (int[])nArray, (int)n3, (int)n4, (int)n5, (String)string4, (String)string5, (String)string6, (String)string7, (String[])stringArray);
    }

    private static ZygoteState openZygoteSocketIfNeeded(String string2) throws ZygoteStartFailedEx {
        return InvokeDynamicSupport.bootstrapStatic("openZygoteSocketIfNeeded", $$robo$$android_os_Process$openZygoteSocketIfNeeded(java.lang.String ), 0, (String)string2);
    }

    private static final native /* synthetic */ long $$robo$$getElapsedCpuTime$nativeBinding();

    public static long getElapsedCpuTime() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getElapsedCpuTime", $$robo$$android_os_Process$getElapsedCpuTime(), 1);
    }

    public static int myPid() {
        return (int)InvokeDynamicSupport.bootstrapStatic("myPid", $$robo$$android_os_Process$myPid(), 0);
    }

    public static int myPpid() {
        return (int)InvokeDynamicSupport.bootstrapStatic("myPpid", $$robo$$android_os_Process$myPpid(), 0);
    }

    public static int myTid() {
        return (int)InvokeDynamicSupport.bootstrapStatic("myTid", $$robo$$android_os_Process$myTid(), 0);
    }

    public static int myUid() {
        return (int)InvokeDynamicSupport.bootstrapStatic("myUid", $$robo$$android_os_Process$myUid(), 0);
    }

    public static UserHandle myUserHandle() {
        return InvokeDynamicSupport.bootstrapStatic("myUserHandle", $$robo$$android_os_Process$myUserHandle(), 0);
    }

    public static boolean isIsolated() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isIsolated", $$robo$$android_os_Process$isIsolated(), 0);
    }

    private static final native /* synthetic */ int $$robo$$getUidForName$nativeBinding(String var0);

    public static int getUidForName(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getUidForName", $$robo$$android_os_Process$getUidForName(java.lang.String ), 1, (String)string2);
    }

    private static final native /* synthetic */ int $$robo$$getGidForName$nativeBinding(String var0);

    public static int getGidForName(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getGidForName", $$robo$$android_os_Process$getGidForName(java.lang.String ), 1, (String)string2);
    }

    public static int getUidForPid(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getUidForPid", $$robo$$android_os_Process$getUidForPid(int ), 0, (int)n);
    }

    public static int getParentPid(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getParentPid", $$robo$$android_os_Process$getParentPid(int ), 0, (int)n);
    }

    public static int getThreadGroupLeader(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getThreadGroupLeader", $$robo$$android_os_Process$getThreadGroupLeader(int ), 0, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$setThreadPriority$nativeBinding(int var0, int var1) throws IllegalArgumentException, SecurityException;

    public static void setThreadPriority(int n, int n2) throws IllegalArgumentException, SecurityException {
        InvokeDynamicSupport.bootstrapStatic("setThreadPriority", $$robo$$android_os_Process$setThreadPriority(int int ), 1, (int)n, (int)n2);
    }

    private static final native /* synthetic */ void $$robo$$setCanSelfBackground$nativeBinding(boolean var0);

    public static void setCanSelfBackground(boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("setCanSelfBackground", $$robo$$android_os_Process$setCanSelfBackground(boolean ), 1, (boolean)bl);
    }

    private static final native /* synthetic */ void $$robo$$setThreadGroup$nativeBinding(int var0, int var1) throws IllegalArgumentException, SecurityException;

    public static void setThreadGroup(int n, int n2) throws IllegalArgumentException, SecurityException {
        InvokeDynamicSupport.bootstrapStatic("setThreadGroup", $$robo$$android_os_Process$setThreadGroup(int int ), 1, (int)n, (int)n2);
    }

    private static final native /* synthetic */ void $$robo$$setProcessGroup$nativeBinding(int var0, int var1) throws IllegalArgumentException, SecurityException;

    public static void setProcessGroup(int n, int n2) throws IllegalArgumentException, SecurityException {
        InvokeDynamicSupport.bootstrapStatic("setProcessGroup", $$robo$$android_os_Process$setProcessGroup(int int ), 1, (int)n, (int)n2);
    }

    private static final native /* synthetic */ int $$robo$$getProcessGroup$nativeBinding(int var0) throws IllegalArgumentException, SecurityException;

    public static int getProcessGroup(int n) throws IllegalArgumentException, SecurityException {
        return (int)InvokeDynamicSupport.bootstrapStatic("getProcessGroup", $$robo$$android_os_Process$getProcessGroup(int ), 1, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$setThreadPriority$nativeBinding(int var0) throws IllegalArgumentException, SecurityException;

    public static void setThreadPriority(int n) throws IllegalArgumentException, SecurityException {
        InvokeDynamicSupport.bootstrapStatic("setThreadPriority", $$robo$$android_os_Process$setThreadPriority(int ), 1, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$getThreadPriority$nativeBinding(int var0) throws IllegalArgumentException;

    public static int getThreadPriority(int n) throws IllegalArgumentException {
        return (int)InvokeDynamicSupport.bootstrapStatic("getThreadPriority", $$robo$$android_os_Process$getThreadPriority(int ), 1, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$setThreadScheduler$nativeBinding(int var0, int var1, int var2) throws IllegalArgumentException;

    public static void setThreadScheduler(int n, int n2, int n3) throws IllegalArgumentException {
        InvokeDynamicSupport.bootstrapStatic("setThreadScheduler", $$robo$$android_os_Process$setThreadScheduler(int int int ), 1, (int)n, (int)n2, (int)n3);
    }

    @Deprecated
    public static boolean supportsProcesses() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("supportsProcesses", $$robo$$android_os_Process$supportsProcesses(), 0);
    }

    private static final native /* synthetic */ boolean $$robo$$setSwappiness$nativeBinding(int var0, boolean var1);

    public static boolean setSwappiness(int n, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("setSwappiness", $$robo$$android_os_Process$setSwappiness(int boolean ), 1, (int)n, (boolean)bl);
    }

    private static final native /* synthetic */ void $$robo$$setArgV0$nativeBinding(String var0);

    public static void setArgV0(String string2) {
        InvokeDynamicSupport.bootstrapStatic("setArgV0", $$robo$$android_os_Process$setArgV0(java.lang.String ), 1, (String)string2);
    }

    public static void killProcess(int n) {
        InvokeDynamicSupport.bootstrapStatic("killProcess", $$robo$$android_os_Process$killProcess(int ), 0, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$setUid$nativeBinding(int var0);

    public static int setUid(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("setUid", $$robo$$android_os_Process$setUid(int ), 1, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$setGid$nativeBinding(int var0);

    public static int setGid(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("setGid", $$robo$$android_os_Process$setGid(int ), 1, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$sendSignal$nativeBinding(int var0, int var1);

    public static void sendSignal(int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("sendSignal", $$robo$$android_os_Process$sendSignal(int int ), 1, (int)n, (int)n2);
    }

    public static void killProcessQuiet(int n) {
        InvokeDynamicSupport.bootstrapStatic("killProcessQuiet", $$robo$$android_os_Process$killProcessQuiet(int ), 0, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$sendSignalQuiet$nativeBinding(int var0, int var1);

    public static void sendSignalQuiet(int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("sendSignalQuiet", $$robo$$android_os_Process$sendSignalQuiet(int int ), 1, (int)n, (int)n2);
    }

    private static final native /* synthetic */ long $$robo$$getFreeMemory$nativeBinding();

    public static long getFreeMemory() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getFreeMemory", $$robo$$android_os_Process$getFreeMemory(), 1);
    }

    private static final native /* synthetic */ long $$robo$$getTotalMemory$nativeBinding();

    public static long getTotalMemory() {
        return (long)InvokeDynamicSupport.bootstrapStatic("getTotalMemory", $$robo$$android_os_Process$getTotalMemory(), 1);
    }

    private static final native /* synthetic */ void $$robo$$readProcLines$nativeBinding(String var0, String[] var1, long[] var2);

    public static void readProcLines(String string2, String[] stringArray, long[] lArray) {
        InvokeDynamicSupport.bootstrapStatic("readProcLines", $$robo$$android_os_Process$readProcLines(java.lang.String java.lang.String[] long[] ), 1, (String)string2, (String[])stringArray, (long[])lArray);
    }

    private static final native /* synthetic */ int[] $$robo$$getPids$nativeBinding(String var0, int[] var1);

    public static int[] getPids(String string2, int[] nArray) {
        return InvokeDynamicSupport.bootstrapStatic("getPids", $$robo$$android_os_Process$getPids(java.lang.String int[] ), 1, (String)string2, (int[])nArray);
    }

    private static final native /* synthetic */ boolean $$robo$$readProcFile$nativeBinding(String var0, int[] var1, String[] var2, long[] var3, float[] var4);

    public static boolean readProcFile(String string2, int[] nArray, String[] stringArray, long[] lArray, float[] fArray) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("readProcFile", $$robo$$android_os_Process$readProcFile(java.lang.String int[] java.lang.String[] long[] float[] ), 1, (String)string2, (int[])nArray, (String[])stringArray, (long[])lArray, (float[])fArray);
    }

    private static final native /* synthetic */ boolean $$robo$$parseProcLine$nativeBinding(byte[] var0, int var1, int var2, int[] var3, String[] var4, long[] var5, float[] var6);

    public static boolean parseProcLine(byte[] byArray, int n, int n2, int[] nArray, String[] stringArray, long[] lArray, float[] fArray) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("parseProcLine", $$robo$$android_os_Process$parseProcLine(byte[] int int int[] java.lang.String[] long[] float[] ), 1, (byte[])byArray, (int)n, (int)n2, (int[])nArray, (String[])stringArray, (long[])lArray, (float[])fArray);
    }

    private static final native /* synthetic */ int[] $$robo$$getPidsForCommands$nativeBinding(String[] var0);

    public static int[] getPidsForCommands(String[] stringArray) {
        return InvokeDynamicSupport.bootstrapStatic("getPidsForCommands", $$robo$$android_os_Process$getPidsForCommands(java.lang.String[] ), 1, (String[])stringArray);
    }

    private static final native /* synthetic */ long $$robo$$getPss$nativeBinding(int var0);

    public static long getPss(int n) {
        return (long)InvokeDynamicSupport.bootstrapStatic("getPss", $$robo$$android_os_Process$getPss(int ), 1, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$killProcessGroup$nativeBinding(int var0, int var1);

    public static int killProcessGroup(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("killProcessGroup", $$robo$$android_os_Process$killProcessGroup(int int ), 1, (int)n, (int)n2);
    }

    private static final native /* synthetic */ void $$robo$$removeAllProcessGroups$nativeBinding();

    public static void removeAllProcessGroups() {
        InvokeDynamicSupport.bootstrapStatic("removeAllProcessGroups", $$robo$$android_os_Process$removeAllProcessGroups(), 1);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Process)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ProcessStartResult
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int pid;
        public boolean usingWrapper;

        private void $$robo$$android_os_Process_ProcessStartResult$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_os_Process_ProcessStartResult$__constructor__();
        }

        public ProcessStartResult() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_Process_ProcessStartResult$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProcessStartResult)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ZygoteState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        LocalSocket socket;
        DataInputStream inputStream;
        BufferedWriter writer;
        List<String> abiList;
        boolean mClosed;

        private void $$robo$$android_os_Process_ZygoteState$__constructor__(LocalSocket socket, DataInputStream inputStream, BufferedWriter writer, List<String> abiList) {
            this.socket = socket;
            this.inputStream = inputStream;
            this.writer = writer;
            this.abiList = abiList;
        }

        private static final ZygoteState $$robo$$android_os_Process_ZygoteState$connect(String socketAddress) throws IOException {
            DataInputStream zygoteInputStream = null;
            BufferedWriter zygoteWriter = null;
            LocalSocket zygoteSocket = new LocalSocket();
            try {
                zygoteSocket.connect(new LocalSocketAddress(socketAddress, LocalSocketAddress.Namespace.RESERVED));
                zygoteInputStream = new DataInputStream(zygoteSocket.getInputStream());
                zygoteWriter = new BufferedWriter(new OutputStreamWriter(zygoteSocket.getOutputStream()), 256);
            }
            catch (IOException ex) {
                try {
                    zygoteSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw ex;
            }
            String abiListString = Process.getAbiList(zygoteWriter, zygoteInputStream);
            Log.i("Zygote", "Process: zygote socket opened, supported ABIS: " + abiListString);
            return new ZygoteState(zygoteSocket, zygoteInputStream, zygoteWriter, Arrays.asList(abiListString.split(",")));
        }

        private final boolean $$robo$$android_os_Process_ZygoteState$matches(String abi) {
            return this.abiList.contains(abi);
        }

        private final void $$robo$$android_os_Process_ZygoteState$close() {
            try {
                this.socket.close();
            }
            catch (IOException ex) {
                Log.e("Process", "I/O exception on routine close", ex);
            }
            this.mClosed = true;
        }

        private final boolean $$robo$$android_os_Process_ZygoteState$isClosed() {
            return this.mClosed;
        }

        private void __constructor__(LocalSocket localSocket, DataInputStream dataInputStream, BufferedWriter bufferedWriter, List<String> list) {
            this.$$robo$$android_os_Process_ZygoteState$__constructor__(localSocket, dataInputStream, bufferedWriter, list);
        }

        private ZygoteState(LocalSocket localSocket, DataInputStream dataInputStream, BufferedWriter bufferedWriter, List<String> list) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_Process_ZygoteState$__constructor__(android.net.LocalSocket java.io.DataInputStream java.io.BufferedWriter java.util.List<java.lang.String> ), 0, this, localSocket, dataInputStream, bufferedWriter, list);
        }

        public static ZygoteState connect(String string2) throws IOException {
            return InvokeDynamicSupport.bootstrapStatic("connect", $$robo$$android_os_Process_ZygoteState$connect(java.lang.String ), 0, (String)string2);
        }

        boolean matches(String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("matches", $$robo$$android_os_Process_ZygoteState$matches(java.lang.String ), 0, this, string2);
        }

        public void close() {
            InvokeDynamicSupport.bootstrap("close", $$robo$$android_os_Process_ZygoteState$close(), 0, this);
        }

        boolean isClosed() {
            return (boolean)InvokeDynamicSupport.bootstrap("isClosed", $$robo$$android_os_Process_ZygoteState$isClosed(), 0, this);
        }

        public /* synthetic */ ZygoteState() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ZygoteState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

