/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.content.Context;
import android.content.pm.UserInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.IUserManager;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.provider.Settings;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class UserManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    private IUserManager mService;
    private Context mContext;
    public static String DISALLOW_MODIFY_ACCOUNTS = "no_modify_accounts";
    public static String DISALLOW_CONFIG_WIFI = "no_config_wifi";
    public static String DISALLOW_INSTALL_APPS = "no_install_apps";
    public static String DISALLOW_UNINSTALL_APPS = "no_uninstall_apps";
    public static String DISALLOW_SHARE_LOCATION = "no_share_location";
    public static String DISALLOW_INSTALL_UNKNOWN_SOURCES = "no_install_unknown_sources";
    public static String DISALLOW_CONFIG_BLUETOOTH = "no_config_bluetooth";
    public static String DISALLOW_USB_FILE_TRANSFER = "no_usb_file_transfer";
    public static String DISALLOW_CONFIG_CREDENTIALS = "no_config_credentials";
    public static String DISALLOW_REMOVE_USER = "no_remove_user";
    public static String DISALLOW_DEBUGGING_FEATURES = "no_debugging_features";
    public static String DISALLOW_CONFIG_VPN = "no_config_vpn";
    public static String DISALLOW_CONFIG_TETHERING = "no_config_tethering";
    public static String DISALLOW_FACTORY_RESET = "no_factory_reset";
    public static String DISALLOW_ADD_USER = "no_add_user";
    public static String ENSURE_VERIFY_APPS = "ensure_verify_apps";
    public static String DISALLOW_CONFIG_CELL_BROADCASTS = "no_config_cell_broadcasts";
    public static String DISALLOW_CONFIG_MOBILE_NETWORKS = "no_config_mobile_networks";
    public static String DISALLOW_APPS_CONTROL = "no_control_apps";
    public static String DISALLOW_MOUNT_PHYSICAL_MEDIA = "no_physical_media";
    public static String DISALLOW_UNMUTE_MICROPHONE = "no_unmute_microphone";
    public static String DISALLOW_ADJUST_VOLUME = "no_adjust_volume";
    public static String DISALLOW_OUTGOING_CALLS = "no_outgoing_calls";
    public static String DISALLOW_SMS = "no_sms";
    public static String DISALLOW_CREATE_WINDOWS = "no_create_windows";
    public static String DISALLOW_CROSS_PROFILE_COPY_PASTE = "no_cross_profile_copy_paste";
    public static String DISALLOW_OUTGOING_BEAM = "no_outgoing_beam";
    public static int PIN_VERIFICATION_FAILED_INCORRECT = -3;
    public static int PIN_VERIFICATION_FAILED_NOT_SET = -2;
    public static int PIN_VERIFICATION_SUCCESS = -1;
    private static UserManager sInstance;

    private static final synchronized UserManager $$robo$$android_os_UserManager$get(Context context) {
        if (sInstance == null) {
            sInstance = (UserManager)context.getSystemService("user");
        }
        return sInstance;
    }

    private void $$robo$$android_os_UserManager$__constructor__(Context context, IUserManager service) {
        this.mService = service;
        this.mContext = context;
    }

    private static final boolean $$robo$$android_os_UserManager$supportsMultipleUsers() {
        return UserManager.getMaxSupportedUsers() > 1 && SystemProperties.getBoolean("fw.show_multiuserui", Resources.getSystem().getBoolean(17956957));
    }

    private final int $$robo$$android_os_UserManager$getUserHandle() {
        return UserHandle.myUserId();
    }

    private final String $$robo$$android_os_UserManager$getUserName() {
        try {
            return this.mService.getUserInfo((int)this.getUserHandle()).name;
        }
        catch (RemoteException re) {
            Log.w(TAG, "Could not get user name", re);
            return "";
        }
    }

    private final boolean $$robo$$android_os_UserManager$isUserAGoat() {
        return this.mContext.getPackageManager().isPackageAvailable("com.coffeestainstudios.goatsimulator");
    }

    private final boolean $$robo$$android_os_UserManager$isLinkedUser() {
        try {
            return this.mService.isRestricted();
        }
        catch (RemoteException re) {
            Log.w(TAG, "Could not check if user is limited ", re);
            return false;
        }
    }

    private final boolean $$robo$$android_os_UserManager$isGuestUser() {
        UserInfo user = this.getUserInfo(UserHandle.myUserId());
        return user != null ? user.isGuest() : false;
    }

    private final boolean $$robo$$android_os_UserManager$isManagedProfile() {
        UserInfo user = this.getUserInfo(UserHandle.myUserId());
        return user != null ? user.isManagedProfile() : false;
    }

    private final boolean $$robo$$android_os_UserManager$isUserRunning(UserHandle user) {
        try {
            return ActivityManagerNative.getDefault().isUserRunning(user.getIdentifier(), false);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private final boolean $$robo$$android_os_UserManager$isUserRunningOrStopping(UserHandle user) {
        try {
            return ActivityManagerNative.getDefault().isUserRunning(user.getIdentifier(), true);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    private final UserInfo $$robo$$android_os_UserManager$getUserInfo(int userHandle) {
        try {
            return this.mService.getUserInfo(userHandle);
        }
        catch (RemoteException re) {
            Log.w(TAG, "Could not get user info", re);
            return null;
        }
    }

    private final Bundle $$robo$$android_os_UserManager$getUserRestrictions() {
        return this.getUserRestrictions(Process.myUserHandle());
    }

    private final Bundle $$robo$$android_os_UserManager$getUserRestrictions(UserHandle userHandle) {
        try {
            return this.mService.getUserRestrictions(userHandle.getIdentifier());
        }
        catch (RemoteException re) {
            Log.w(TAG, "Could not get user restrictions", re);
            return Bundle.EMPTY;
        }
    }

    @Deprecated
    private final void $$robo$$android_os_UserManager$setUserRestrictions(Bundle restrictions) {
        this.setUserRestrictions(restrictions, Process.myUserHandle());
    }

    @Deprecated
    private final void $$robo$$android_os_UserManager$setUserRestrictions(Bundle restrictions, UserHandle userHandle) {
        try {
            this.mService.setUserRestrictions(restrictions, userHandle.getIdentifier());
        }
        catch (RemoteException re) {
            Log.w(TAG, "Could not set user restrictions", re);
        }
    }

    @Deprecated
    private final void $$robo$$android_os_UserManager$setUserRestriction(String key, boolean value) {
        Bundle bundle = this.getUserRestrictions();
        bundle.putBoolean(key, value);
        this.setUserRestrictions(bundle);
    }

    @Deprecated
    private final void $$robo$$android_os_UserManager$setUserRestriction(String key, boolean value, UserHandle userHandle) {
        Bundle bundle = this.getUserRestrictions(userHandle);
        bundle.putBoolean(key, value);
        this.setUserRestrictions(bundle, userHandle);
    }

    private final boolean $$robo$$android_os_UserManager$hasUserRestriction(String restrictionKey) {
        return this.hasUserRestriction(restrictionKey, Process.myUserHandle());
    }

    private final boolean $$robo$$android_os_UserManager$hasUserRestriction(String restrictionKey, UserHandle userHandle) {
        try {
            return this.mService.hasUserRestriction(restrictionKey, userHandle.getIdentifier());
        }
        catch (RemoteException re) {
            Log.w(TAG, "Could not check user restrictions", re);
            return false;
        }
    }

    private final long $$robo$$android_os_UserManager$getSerialNumberForUser(UserHandle user) {
        return this.getUserSerialNumber(user.getIdentifier());
    }

    private final UserHandle $$robo$$android_os_UserManager$getUserForSerialNumber(long serialNumber) {
        int ident = this.getUserHandle((int)serialNumber);
        return ident >= 0 ? new UserHandle(ident) : null;
    }

    private final UserInfo $$robo$$android_os_UserManager$createUser(String name, int flags) {
        try {
            return this.mService.createUser(name, flags);
        }
        catch (RemoteException re) {
            Log.w(TAG, "Could not create a user", re);
            return null;
        }
    }

    private final UserInfo $$robo$$android_os_UserManager$createGuest(Context context, String name) {
        UserInfo guest = this.createUser(name, 4);
        if (guest != null) {
            Settings.Secure.putStringForUser(context.getContentResolver(), "skip_first_use_hints", "1", guest.id);
            try {
                Bundle guestRestrictions = this.mService.getDefaultGuestRestrictions();
                guestRestrictions.putBoolean("no_sms", true);
                guestRestrictions.putBoolean("no_install_unknown_sources", true);
                this.mService.setUserRestrictions(guestRestrictions, guest.id);
            }
            catch (RemoteException re) {
                Log.w(TAG, "Could not update guest restrictions");
            }
        }
        return guest;
    }

    private final UserInfo $$robo$$android_os_UserManager$createSecondaryUser(String name, int flags) {
        try {
            UserInfo user = this.mService.createUser(name, flags);
            if (user == null) {
                return null;
            }
            Bundle userRestrictions = this.mService.getUserRestrictions(user.id);
            UserManager.addDefaultUserRestrictions(userRestrictions);
            this.mService.setUserRestrictions(userRestrictions, user.id);
            return user;
        }
        catch (RemoteException re) {
            Log.w(TAG, "Could not create a user", re);
            return null;
        }
    }

    private static final void $$robo$$android_os_UserManager$addDefaultUserRestrictions(Bundle restrictions) {
        restrictions.putBoolean("no_outgoing_calls", true);
        restrictions.putBoolean("no_sms", true);
    }

    private final UserInfo $$robo$$android_os_UserManager$createProfileForUser(String name, int flags, int userHandle) {
        try {
            return this.mService.createProfileForUser(name, flags, userHandle);
        }
        catch (RemoteException re) {
            Log.w(TAG, "Could not create a user", re);
            return null;
        }
    }

    private final boolean $$robo$$android_os_UserManager$markGuestForDeletion(int userHandle) {
        try {
            return this.mService.markGuestForDeletion(userHandle);
        }
        catch (RemoteException re) {
            Log.w(TAG, "Could not mark guest for deletion", re);
            return false;
        }
    }

    private final void $$robo$$android_os_UserManager$setUserEnabled(int userHandle) {
        try {
            this.mService.setUserEnabled(userHandle);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Could not enable the profile", e);
        }
    }

    private final int $$robo$$android_os_UserManager$getUserCount() {
        List<UserInfo> users = this.getUsers();
        return users != null ? users.size() : 1;
    }

    private final List<UserInfo> $$robo$$android_os_UserManager$getUsers() {
        try {
            return this.mService.getUsers(false);
        }
        catch (RemoteException re) {
            Log.w(TAG, "Could not get user list", re);
            return null;
        }
    }

    private final boolean $$robo$$android_os_UserManager$canAddMoreUsers() {
        List<UserInfo> users = this.getUsers(true);
        int totalUserCount = users.size();
        int aliveUserCount = 0;
        for (int i = 0; i < totalUserCount; ++i) {
            UserInfo user = users.get(i);
            if (user.isGuest()) continue;
            ++aliveUserCount;
        }
        return aliveUserCount < UserManager.getMaxSupportedUsers();
    }

    private final List<UserInfo> $$robo$$android_os_UserManager$getProfiles(int userHandle) {
        try {
            return this.mService.getProfiles(userHandle, false);
        }
        catch (RemoteException re) {
            Log.w(TAG, "Could not get user list", re);
            return null;
        }
    }

    private final List<UserHandle> $$robo$$android_os_UserManager$getUserProfiles() {
        ArrayList<UserHandle> profiles = new ArrayList<UserHandle>();
        List<Object> users = new ArrayList();
        try {
            users = this.mService.getProfiles(UserHandle.myUserId(), true);
        }
        catch (RemoteException re) {
            Log.w(TAG, "Could not get user list", re);
            return null;
        }
        for (UserInfo userInfo : users) {
            UserHandle userHandle = new UserHandle(userInfo.id);
            profiles.add(userHandle);
        }
        return profiles;
    }

    private final UserInfo $$robo$$android_os_UserManager$getProfileParent(int userHandle) {
        try {
            return this.mService.getProfileParent(userHandle);
        }
        catch (RemoteException re) {
            Log.w(TAG, "Could not get profile parent", re);
            return null;
        }
    }

    private final Drawable $$robo$$android_os_UserManager$getBadgedIconForUser(Drawable icon, UserHandle user) {
        return this.mContext.getPackageManager().getUserBadgedIcon(icon, user);
    }

    private final Drawable $$robo$$android_os_UserManager$getBadgedDrawableForUser(Drawable badgedDrawable, UserHandle user, Rect badgeLocation, int badgeDensity) {
        return this.mContext.getPackageManager().getUserBadgedDrawableForDensity(badgedDrawable, user, badgeLocation, badgeDensity);
    }

    private final CharSequence $$robo$$android_os_UserManager$getBadgedLabelForUser(CharSequence label, UserHandle user) {
        return this.mContext.getPackageManager().getUserBadgedLabel(label, user);
    }

    private final List<UserInfo> $$robo$$android_os_UserManager$getUsers(boolean excludeDying) {
        try {
            return this.mService.getUsers(excludeDying);
        }
        catch (RemoteException re) {
            Log.w(TAG, "Could not get user list", re);
            return null;
        }
    }

    private final boolean $$robo$$android_os_UserManager$removeUser(int userHandle) {
        try {
            return this.mService.removeUser(userHandle);
        }
        catch (RemoteException re) {
            Log.w(TAG, "Could not remove user ", re);
            return false;
        }
    }

    private final void $$robo$$android_os_UserManager$setUserName(int userHandle, String name) {
        try {
            this.mService.setUserName(userHandle, name);
        }
        catch (RemoteException re) {
            Log.w(TAG, "Could not set the user name ", re);
        }
    }

    private final void $$robo$$android_os_UserManager$setUserIcon(int userHandle, Bitmap icon) {
        try {
            this.mService.setUserIcon(userHandle, icon);
        }
        catch (RemoteException re) {
            Log.w(TAG, "Could not set the user icon ", re);
        }
    }

    private final Bitmap $$robo$$android_os_UserManager$getUserIcon(int userHandle) {
        try {
            return this.mService.getUserIcon(userHandle);
        }
        catch (RemoteException re) {
            Log.w(TAG, "Could not get the user icon ", re);
            return null;
        }
    }

    private static final int $$robo$$android_os_UserManager$getMaxSupportedUsers() {
        if (Build.ID.startsWith("JVP")) {
            return 1;
        }
        if (ActivityManager.isLowRamDeviceStatic()) {
            return 1;
        }
        return SystemProperties.getInt("fw.max_users", Resources.getSystem().getInteger(17694830));
    }

    private final boolean $$robo$$android_os_UserManager$isUserSwitcherEnabled() {
        List<UserInfo> users = this.getUsers(true);
        if (users == null) {
            return false;
        }
        int switchableUserCount = 0;
        for (UserInfo user : users) {
            if (!user.supportsSwitchTo()) continue;
            ++switchableUserCount;
        }
        boolean guestEnabled = Settings.Global.getInt(this.mContext.getContentResolver(), "guest_user_enabled", 0) == 1;
        return switchableUserCount > 1 || guestEnabled;
    }

    private final int $$robo$$android_os_UserManager$getUserSerialNumber(int userHandle) {
        try {
            return this.mService.getUserSerialNumber(userHandle);
        }
        catch (RemoteException re) {
            Log.w(TAG, "Could not get serial number for user " + userHandle);
            return -1;
        }
    }

    private final int $$robo$$android_os_UserManager$getUserHandle(int userSerialNumber) {
        try {
            return this.mService.getUserHandle(userSerialNumber);
        }
        catch (RemoteException re) {
            Log.w(TAG, "Could not get userHandle for user " + userSerialNumber);
            return -1;
        }
    }

    private final Bundle $$robo$$android_os_UserManager$getApplicationRestrictions(String packageName) {
        try {
            return this.mService.getApplicationRestrictions(packageName);
        }
        catch (RemoteException re) {
            Log.w(TAG, "Could not get application restrictions for package " + packageName);
            return null;
        }
    }

    private final Bundle $$robo$$android_os_UserManager$getApplicationRestrictions(String packageName, UserHandle user) {
        try {
            return this.mService.getApplicationRestrictionsForUser(packageName, user.getIdentifier());
        }
        catch (RemoteException re) {
            Log.w(TAG, "Could not get application restrictions for user " + user.getIdentifier());
            return null;
        }
    }

    private final void $$robo$$android_os_UserManager$setApplicationRestrictions(String packageName, Bundle restrictions, UserHandle user) {
        try {
            this.mService.setApplicationRestrictions(packageName, restrictions, user.getIdentifier());
        }
        catch (RemoteException re) {
            Log.w(TAG, "Could not set application restrictions for user " + user.getIdentifier());
        }
    }

    private final boolean $$robo$$android_os_UserManager$setRestrictionsChallenge(String newPin) {
        try {
            return this.mService.setRestrictionsChallenge(newPin);
        }
        catch (RemoteException re) {
            Log.w(TAG, "Could not change restrictions pin");
            return false;
        }
    }

    private final int $$robo$$android_os_UserManager$checkRestrictionsChallenge(String pin) {
        try {
            return this.mService.checkRestrictionsChallenge(pin);
        }
        catch (RemoteException re) {
            Log.w(TAG, "Could not check restrictions pin");
            return -3;
        }
    }

    private final boolean $$robo$$android_os_UserManager$hasRestrictionsChallenge() {
        try {
            return this.mService.hasRestrictionsChallenge();
        }
        catch (RemoteException re) {
            Log.w(TAG, "Could not change restrictions pin");
            return false;
        }
    }

    private final void $$robo$$android_os_UserManager$removeRestrictions() {
        try {
            this.mService.removeRestrictions();
        }
        catch (RemoteException re) {
            Log.w(TAG, "Could not change restrictions pin");
        }
    }

    private final void $$robo$$android_os_UserManager$setDefaultGuestRestrictions(Bundle restrictions) {
        try {
            this.mService.setDefaultGuestRestrictions(restrictions);
        }
        catch (RemoteException re) {
            Log.w(TAG, "Could not set guest restrictions");
        }
    }

    private final Bundle $$robo$$android_os_UserManager$getDefaultGuestRestrictions() {
        try {
            return this.mService.getDefaultGuestRestrictions();
        }
        catch (RemoteException re) {
            Log.w(TAG, "Could not set guest restrictions");
            return new Bundle();
        }
    }

    static void __staticInitializer__() {
        TAG = "UserManager";
        sInstance = null;
    }

    public static synchronized UserManager get(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("get", $$robo$$android_os_UserManager$get(android.content.Context ), 0, (Context)context);
    }

    private void __constructor__(Context context, IUserManager iUserManager) {
        this.$$robo$$android_os_UserManager$__constructor__(context, iUserManager);
    }

    public UserManager(Context context, IUserManager iUserManager) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_UserManager$__constructor__(android.content.Context android.os.IUserManager ), 0, this, context, iUserManager);
    }

    public static boolean supportsMultipleUsers() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("supportsMultipleUsers", $$robo$$android_os_UserManager$supportsMultipleUsers(), 0);
    }

    public int getUserHandle() {
        return (int)InvokeDynamicSupport.bootstrap("getUserHandle", $$robo$$android_os_UserManager$getUserHandle(), 0, this);
    }

    public String getUserName() {
        return InvokeDynamicSupport.bootstrap("getUserName", $$robo$$android_os_UserManager$getUserName(), 0, this);
    }

    public boolean isUserAGoat() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUserAGoat", $$robo$$android_os_UserManager$isUserAGoat(), 0, this);
    }

    public boolean isLinkedUser() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLinkedUser", $$robo$$android_os_UserManager$isLinkedUser(), 0, this);
    }

    public boolean isGuestUser() {
        return (boolean)InvokeDynamicSupport.bootstrap("isGuestUser", $$robo$$android_os_UserManager$isGuestUser(), 0, this);
    }

    public boolean isManagedProfile() {
        return (boolean)InvokeDynamicSupport.bootstrap("isManagedProfile", $$robo$$android_os_UserManager$isManagedProfile(), 0, this);
    }

    public boolean isUserRunning(UserHandle userHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("isUserRunning", $$robo$$android_os_UserManager$isUserRunning(android.os.UserHandle ), 0, this, userHandle);
    }

    public boolean isUserRunningOrStopping(UserHandle userHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("isUserRunningOrStopping", $$robo$$android_os_UserManager$isUserRunningOrStopping(android.os.UserHandle ), 0, this, userHandle);
    }

    public UserInfo getUserInfo(int n) {
        return InvokeDynamicSupport.bootstrap("getUserInfo", $$robo$$android_os_UserManager$getUserInfo(int ), 0, this, n);
    }

    public Bundle getUserRestrictions() {
        return InvokeDynamicSupport.bootstrap("getUserRestrictions", $$robo$$android_os_UserManager$getUserRestrictions(), 0, this);
    }

    public Bundle getUserRestrictions(UserHandle userHandle) {
        return InvokeDynamicSupport.bootstrap("getUserRestrictions", $$robo$$android_os_UserManager$getUserRestrictions(android.os.UserHandle ), 0, this, userHandle);
    }

    @Deprecated
    public void setUserRestrictions(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("setUserRestrictions", $$robo$$android_os_UserManager$setUserRestrictions(android.os.Bundle ), 0, this, bundle);
    }

    @Deprecated
    public void setUserRestrictions(Bundle bundle, UserHandle userHandle) {
        InvokeDynamicSupport.bootstrap("setUserRestrictions", $$robo$$android_os_UserManager$setUserRestrictions(android.os.Bundle android.os.UserHandle ), 0, this, bundle, userHandle);
    }

    @Deprecated
    public void setUserRestriction(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("setUserRestriction", $$robo$$android_os_UserManager$setUserRestriction(java.lang.String boolean ), 0, this, string2, bl);
    }

    @Deprecated
    public void setUserRestriction(String string2, boolean bl, UserHandle userHandle) {
        InvokeDynamicSupport.bootstrap("setUserRestriction", $$robo$$android_os_UserManager$setUserRestriction(java.lang.String boolean android.os.UserHandle ), 0, this, string2, bl, userHandle);
    }

    public boolean hasUserRestriction(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasUserRestriction", $$robo$$android_os_UserManager$hasUserRestriction(java.lang.String ), 0, this, string2);
    }

    public boolean hasUserRestriction(String string2, UserHandle userHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasUserRestriction", $$robo$$android_os_UserManager$hasUserRestriction(java.lang.String android.os.UserHandle ), 0, this, string2, userHandle);
    }

    public long getSerialNumberForUser(UserHandle userHandle) {
        return (long)InvokeDynamicSupport.bootstrap("getSerialNumberForUser", $$robo$$android_os_UserManager$getSerialNumberForUser(android.os.UserHandle ), 0, this, userHandle);
    }

    public UserHandle getUserForSerialNumber(long l) {
        return InvokeDynamicSupport.bootstrap("getUserForSerialNumber", $$robo$$android_os_UserManager$getUserForSerialNumber(long ), 0, this, l);
    }

    public UserInfo createUser(String string2, int n) {
        return InvokeDynamicSupport.bootstrap("createUser", $$robo$$android_os_UserManager$createUser(java.lang.String int ), 0, this, string2, n);
    }

    public UserInfo createGuest(Context context, String string2) {
        return InvokeDynamicSupport.bootstrap("createGuest", $$robo$$android_os_UserManager$createGuest(android.content.Context java.lang.String ), 0, this, context, string2);
    }

    public UserInfo createSecondaryUser(String string2, int n) {
        return InvokeDynamicSupport.bootstrap("createSecondaryUser", $$robo$$android_os_UserManager$createSecondaryUser(java.lang.String int ), 0, this, string2, n);
    }

    private static void addDefaultUserRestrictions(Bundle bundle) {
        InvokeDynamicSupport.bootstrapStatic("addDefaultUserRestrictions", $$robo$$android_os_UserManager$addDefaultUserRestrictions(android.os.Bundle ), 0, (Bundle)bundle);
    }

    public UserInfo createProfileForUser(String string2, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("createProfileForUser", $$robo$$android_os_UserManager$createProfileForUser(java.lang.String int int ), 0, this, string2, n, n2);
    }

    public boolean markGuestForDeletion(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("markGuestForDeletion", $$robo$$android_os_UserManager$markGuestForDeletion(int ), 0, this, n);
    }

    public void setUserEnabled(int n) {
        InvokeDynamicSupport.bootstrap("setUserEnabled", $$robo$$android_os_UserManager$setUserEnabled(int ), 0, this, n);
    }

    public int getUserCount() {
        return (int)InvokeDynamicSupport.bootstrap("getUserCount", $$robo$$android_os_UserManager$getUserCount(), 0, this);
    }

    public List<UserInfo> getUsers() {
        return InvokeDynamicSupport.bootstrap("getUsers", $$robo$$android_os_UserManager$getUsers(), 0, this);
    }

    public boolean canAddMoreUsers() {
        return (boolean)InvokeDynamicSupport.bootstrap("canAddMoreUsers", $$robo$$android_os_UserManager$canAddMoreUsers(), 0, this);
    }

    public List<UserInfo> getProfiles(int n) {
        return InvokeDynamicSupport.bootstrap("getProfiles", $$robo$$android_os_UserManager$getProfiles(int ), 0, this, n);
    }

    public List<UserHandle> getUserProfiles() {
        return InvokeDynamicSupport.bootstrap("getUserProfiles", $$robo$$android_os_UserManager$getUserProfiles(), 0, this);
    }

    public UserInfo getProfileParent(int n) {
        return InvokeDynamicSupport.bootstrap("getProfileParent", $$robo$$android_os_UserManager$getProfileParent(int ), 0, this, n);
    }

    public Drawable getBadgedIconForUser(Drawable drawable2, UserHandle userHandle) {
        return InvokeDynamicSupport.bootstrap("getBadgedIconForUser", $$robo$$android_os_UserManager$getBadgedIconForUser(android.graphics.drawable.Drawable android.os.UserHandle ), 0, this, drawable2, userHandle);
    }

    public Drawable getBadgedDrawableForUser(Drawable drawable2, UserHandle userHandle, Rect rect, int n) {
        return InvokeDynamicSupport.bootstrap("getBadgedDrawableForUser", $$robo$$android_os_UserManager$getBadgedDrawableForUser(android.graphics.drawable.Drawable android.os.UserHandle android.graphics.Rect int ), 0, this, drawable2, userHandle, rect, n);
    }

    public CharSequence getBadgedLabelForUser(CharSequence charSequence, UserHandle userHandle) {
        return InvokeDynamicSupport.bootstrap("getBadgedLabelForUser", $$robo$$android_os_UserManager$getBadgedLabelForUser(java.lang.CharSequence android.os.UserHandle ), 0, this, charSequence, userHandle);
    }

    public List<UserInfo> getUsers(boolean bl) {
        return InvokeDynamicSupport.bootstrap("getUsers", $$robo$$android_os_UserManager$getUsers(boolean ), 0, this, bl);
    }

    public boolean removeUser(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeUser", $$robo$$android_os_UserManager$removeUser(int ), 0, this, n);
    }

    public void setUserName(int n, String string2) {
        InvokeDynamicSupport.bootstrap("setUserName", $$robo$$android_os_UserManager$setUserName(int java.lang.String ), 0, this, n, string2);
    }

    public void setUserIcon(int n, Bitmap bitmap) {
        InvokeDynamicSupport.bootstrap("setUserIcon", $$robo$$android_os_UserManager$setUserIcon(int android.graphics.Bitmap ), 0, this, n, bitmap);
    }

    public Bitmap getUserIcon(int n) {
        return InvokeDynamicSupport.bootstrap("getUserIcon", $$robo$$android_os_UserManager$getUserIcon(int ), 0, this, n);
    }

    public static int getMaxSupportedUsers() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getMaxSupportedUsers", $$robo$$android_os_UserManager$getMaxSupportedUsers(), 0);
    }

    public boolean isUserSwitcherEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUserSwitcherEnabled", $$robo$$android_os_UserManager$isUserSwitcherEnabled(), 0, this);
    }

    public int getUserSerialNumber(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getUserSerialNumber", $$robo$$android_os_UserManager$getUserSerialNumber(int ), 0, this, n);
    }

    public int getUserHandle(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getUserHandle", $$robo$$android_os_UserManager$getUserHandle(int ), 0, this, n);
    }

    public Bundle getApplicationRestrictions(String string2) {
        return InvokeDynamicSupport.bootstrap("getApplicationRestrictions", $$robo$$android_os_UserManager$getApplicationRestrictions(java.lang.String ), 0, this, string2);
    }

    public Bundle getApplicationRestrictions(String string2, UserHandle userHandle) {
        return InvokeDynamicSupport.bootstrap("getApplicationRestrictions", $$robo$$android_os_UserManager$getApplicationRestrictions(java.lang.String android.os.UserHandle ), 0, this, string2, userHandle);
    }

    public void setApplicationRestrictions(String string2, Bundle bundle, UserHandle userHandle) {
        InvokeDynamicSupport.bootstrap("setApplicationRestrictions", $$robo$$android_os_UserManager$setApplicationRestrictions(java.lang.String android.os.Bundle android.os.UserHandle ), 0, this, string2, bundle, userHandle);
    }

    public boolean setRestrictionsChallenge(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setRestrictionsChallenge", $$robo$$android_os_UserManager$setRestrictionsChallenge(java.lang.String ), 0, this, string2);
    }

    public int checkRestrictionsChallenge(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("checkRestrictionsChallenge", $$robo$$android_os_UserManager$checkRestrictionsChallenge(java.lang.String ), 0, this, string2);
    }

    public boolean hasRestrictionsChallenge() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasRestrictionsChallenge", $$robo$$android_os_UserManager$hasRestrictionsChallenge(), 0, this);
    }

    public void removeRestrictions() {
        InvokeDynamicSupport.bootstrap("removeRestrictions", $$robo$$android_os_UserManager$removeRestrictions(), 0, this);
    }

    public void setDefaultGuestRestrictions(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("setDefaultGuestRestrictions", $$robo$$android_os_UserManager$setDefaultGuestRestrictions(android.os.Bundle ), 0, this, bundle);
    }

    public Bundle getDefaultGuestRestrictions() {
        return InvokeDynamicSupport.bootstrap("getDefaultGuestRestrictions", $$robo$$android_os_UserManager$getDefaultGuestRestrictions(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(UserManager.class);
    }

    public /* synthetic */ UserManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UserManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

