/*
 * Decompiled with CFR 0.152.
 */
package android.os.storage;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.storage.IMountServiceListener;
import android.os.storage.IMountShutdownObserver;
import android.os.storage.IObbActionListener;
import android.os.storage.StorageVolume;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public interface IMountService
extends IInterface,
InstrumentedInterface {
    public static final int ENCRYPTION_STATE_NONE = 1;
    public static final int ENCRYPTION_STATE_OK = 0;
    public static final int ENCRYPTION_STATE_ERROR_UNKNOWN = -1;
    public static final int ENCRYPTION_STATE_ERROR_INCOMPLETE = -2;
    public static final int ENCRYPTION_STATE_ERROR_INCONSISTENT = -3;
    public static final int ENCRYPTION_STATE_ERROR_CORRUPT = -4;

    public int createSecureContainer(String var1, int var2, String var3, String var4, int var5, boolean var6) throws RemoteException;

    public int destroySecureContainer(String var1, boolean var2) throws RemoteException;

    public int finalizeSecureContainer(String var1) throws RemoteException;

    public void finishMediaUpdate() throws RemoteException;

    public int formatVolume(String var1) throws RemoteException;

    public String getMountedObbPath(String var1) throws RemoteException;

    public String[] getSecureContainerList() throws RemoteException;

    public String getSecureContainerPath(String var1) throws RemoteException;

    public int[] getStorageUsers(String var1) throws RemoteException;

    public String getVolumeState(String var1) throws RemoteException;

    public boolean isObbMounted(String var1) throws RemoteException;

    public boolean isSecureContainerMounted(String var1) throws RemoteException;

    public boolean isUsbMassStorageConnected() throws RemoteException;

    public boolean isUsbMassStorageEnabled() throws RemoteException;

    public void mountObb(String var1, String var2, String var3, IObbActionListener var4, int var5) throws RemoteException;

    public int mountSecureContainer(String var1, String var2, int var3, boolean var4) throws RemoteException;

    public int mountVolume(String var1) throws RemoteException;

    public void registerListener(IMountServiceListener var1) throws RemoteException;

    public int renameSecureContainer(String var1, String var2) throws RemoteException;

    public void setUsbMassStorageEnabled(boolean var1) throws RemoteException;

    public void shutdown(IMountShutdownObserver var1) throws RemoteException;

    public void unmountObb(String var1, boolean var2, IObbActionListener var3, int var4) throws RemoteException;

    public int unmountSecureContainer(String var1, boolean var2) throws RemoteException;

    public void unmountVolume(String var1, boolean var2, boolean var3) throws RemoteException;

    public void unregisterListener(IMountServiceListener var1) throws RemoteException;

    public boolean isExternalStorageEmulated() throws RemoteException;

    public int getEncryptionState() throws RemoteException;

    public int decryptStorage(String var1) throws RemoteException;

    public int encryptStorage(int var1, String var2) throws RemoteException;

    public int changeEncryptionPassword(int var1, String var2) throws RemoteException;

    public int verifyEncryptionPassword(String var1) throws RemoteException;

    public StorageVolume[] getVolumeList() throws RemoteException;

    public String getSecureContainerFilesystemPath(String var1) throws RemoteException;

    public int fixPermissionsSecureContainer(String var1, int var2, String var3) throws RemoteException;

    public int mkdirs(String var1, String var2) throws RemoteException;

    public int getPasswordType() throws RemoteException;

    public String getPassword() throws RemoteException;

    public void clearPassword() throws RemoteException;

    public void setField(String var1, String var2) throws RemoteException;

    public String getField(String var1) throws RemoteException;

    public int resizeSecureContainer(String var1, int var2, String var3) throws RemoteException;

    public long lastMaintenance() throws RemoteException;

    public void runMaintenance() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMountService,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String DESCRIPTOR = "IMountService";
        static int TRANSACTION_registerListener = 1;
        static int TRANSACTION_unregisterListener = 2;
        static int TRANSACTION_isUsbMassStorageConnected = 3;
        static int TRANSACTION_setUsbMassStorageEnabled = 4;
        static int TRANSACTION_isUsbMassStorageEnabled = 5;
        static int TRANSACTION_mountVolume = 6;
        static int TRANSACTION_unmountVolume = 7;
        static int TRANSACTION_formatVolume = 8;
        static int TRANSACTION_getStorageUsers = 9;
        static int TRANSACTION_getVolumeState = 10;
        static int TRANSACTION_createSecureContainer = 11;
        static int TRANSACTION_finalizeSecureContainer = 12;
        static int TRANSACTION_destroySecureContainer = 13;
        static int TRANSACTION_mountSecureContainer = 14;
        static int TRANSACTION_unmountSecureContainer = 15;
        static int TRANSACTION_isSecureContainerMounted = 16;
        static int TRANSACTION_renameSecureContainer = 17;
        static int TRANSACTION_getSecureContainerPath = 18;
        static int TRANSACTION_getSecureContainerList = 19;
        static int TRANSACTION_shutdown = 20;
        static int TRANSACTION_finishMediaUpdate = 21;
        static int TRANSACTION_mountObb = 22;
        static int TRANSACTION_unmountObb = 23;
        static int TRANSACTION_isObbMounted = 24;
        static int TRANSACTION_getMountedObbPath = 25;
        static int TRANSACTION_isExternalStorageEmulated = 26;
        static int TRANSACTION_decryptStorage = 27;
        static int TRANSACTION_encryptStorage = 28;
        static int TRANSACTION_changeEncryptionPassword = 29;
        static int TRANSACTION_getVolumeList = 30;
        static int TRANSACTION_getSecureContainerFilesystemPath = 31;
        static int TRANSACTION_getEncryptionState = 32;
        static int TRANSACTION_verifyEncryptionPassword = 33;
        static int TRANSACTION_fixPermissionsSecureContainer = 34;
        static int TRANSACTION_mkdirs = 35;
        static int TRANSACTION_getPasswordType = 36;
        static int TRANSACTION_getPassword = 37;
        static int TRANSACTION_clearPassword = 38;
        static int TRANSACTION_setField = 39;
        static int TRANSACTION_getField = 40;
        static int TRANSACTION_resizeSecureContainer = 41;
        static int TRANSACTION_lastMaintenance = 42;
        static int TRANSACTION_runMaintenance = 43;

        private static final IMountService $$robo$$android_os_storage_IMountService_Stub$asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface("IMountService");
            if (iin != null && iin instanceof IMountService) {
                return (IMountService)iin;
            }
            return new Proxy(obj);
        }

        private void $$robo$$android_os_storage_IMountService_Stub$__constructor__() {
            this.attachInterface(this, "IMountService");
        }

        private final IBinder $$robo$$android_os_storage_IMountService_Stub$asBinder() {
            return this;
        }

        private final boolean $$robo$$android_os_storage_IMountService_Stub$onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString("IMountService");
                    return true;
                }
                case 1: {
                    data.enforceInterface("IMountService");
                    IMountServiceListener listener = IMountServiceListener.Stub.asInterface(data.readStrongBinder());
                    this.registerListener(listener);
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface("IMountService");
                    IMountServiceListener listener = IMountServiceListener.Stub.asInterface(data.readStrongBinder());
                    this.unregisterListener(listener);
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface("IMountService");
                    boolean result = this.isUsbMassStorageConnected();
                    reply.writeNoException();
                    reply.writeInt(result ? 1 : 0);
                    return true;
                }
                case 4: {
                    data.enforceInterface("IMountService");
                    boolean enable = 0 != data.readInt();
                    this.setUsbMassStorageEnabled(enable);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface("IMountService");
                    boolean result = this.isUsbMassStorageEnabled();
                    reply.writeNoException();
                    reply.writeInt(result ? 1 : 0);
                    return true;
                }
                case 6: {
                    data.enforceInterface("IMountService");
                    String mountPoint = data.readString();
                    int resultCode = this.mountVolume(mountPoint);
                    reply.writeNoException();
                    reply.writeInt(resultCode);
                    return true;
                }
                case 7: {
                    data.enforceInterface("IMountService");
                    String mountPoint = data.readString();
                    boolean force = 0 != data.readInt();
                    boolean removeEncrypt = 0 != data.readInt();
                    this.unmountVolume(mountPoint, force, removeEncrypt);
                    reply.writeNoException();
                    return true;
                }
                case 8: {
                    data.enforceInterface("IMountService");
                    String mountPoint = data.readString();
                    int result = this.formatVolume(mountPoint);
                    reply.writeNoException();
                    reply.writeInt(result);
                    return true;
                }
                case 9: {
                    data.enforceInterface("IMountService");
                    String path = data.readString();
                    int[] pids = this.getStorageUsers(path);
                    reply.writeNoException();
                    reply.writeIntArray(pids);
                    return true;
                }
                case 10: {
                    data.enforceInterface("IMountService");
                    String mountPoint = data.readString();
                    String state = this.getVolumeState(mountPoint);
                    reply.writeNoException();
                    reply.writeString(state);
                    return true;
                }
                case 11: {
                    data.enforceInterface("IMountService");
                    String id2 = data.readString();
                    int sizeMb = data.readInt();
                    String fstype = data.readString();
                    String key = data.readString();
                    int ownerUid = data.readInt();
                    boolean external = 0 != data.readInt();
                    int resultCode = this.createSecureContainer(id2, sizeMb, fstype, key, ownerUid, external);
                    reply.writeNoException();
                    reply.writeInt(resultCode);
                    return true;
                }
                case 12: {
                    data.enforceInterface("IMountService");
                    String id3 = data.readString();
                    int resultCode = this.finalizeSecureContainer(id3);
                    reply.writeNoException();
                    reply.writeInt(resultCode);
                    return true;
                }
                case 13: {
                    data.enforceInterface("IMountService");
                    String id4 = data.readString();
                    boolean force = 0 != data.readInt();
                    int resultCode = this.destroySecureContainer(id4, force);
                    reply.writeNoException();
                    reply.writeInt(resultCode);
                    return true;
                }
                case 14: {
                    data.enforceInterface("IMountService");
                    String id5 = data.readString();
                    String key = data.readString();
                    int ownerUid = data.readInt();
                    boolean readOnly = data.readInt() != 0;
                    int resultCode = this.mountSecureContainer(id5, key, ownerUid, readOnly);
                    reply.writeNoException();
                    reply.writeInt(resultCode);
                    return true;
                }
                case 15: {
                    data.enforceInterface("IMountService");
                    String id6 = data.readString();
                    boolean force = 0 != data.readInt();
                    int resultCode = this.unmountSecureContainer(id6, force);
                    reply.writeNoException();
                    reply.writeInt(resultCode);
                    return true;
                }
                case 16: {
                    data.enforceInterface("IMountService");
                    String id7 = data.readString();
                    boolean status = this.isSecureContainerMounted(id7);
                    reply.writeNoException();
                    reply.writeInt(status ? 1 : 0);
                    return true;
                }
                case 17: {
                    data.enforceInterface("IMountService");
                    String oldId = data.readString();
                    String newId = data.readString();
                    int resultCode = this.renameSecureContainer(oldId, newId);
                    reply.writeNoException();
                    reply.writeInt(resultCode);
                    return true;
                }
                case 18: {
                    data.enforceInterface("IMountService");
                    String id8 = data.readString();
                    String path = this.getSecureContainerPath(id8);
                    reply.writeNoException();
                    reply.writeString(path);
                    return true;
                }
                case 19: {
                    data.enforceInterface("IMountService");
                    String[] ids = this.getSecureContainerList();
                    reply.writeNoException();
                    reply.writeStringArray(ids);
                    return true;
                }
                case 20: {
                    data.enforceInterface("IMountService");
                    IMountShutdownObserver observer = IMountShutdownObserver.Stub.asInterface(data.readStrongBinder());
                    this.shutdown(observer);
                    reply.writeNoException();
                    return true;
                }
                case 21: {
                    data.enforceInterface("IMountService");
                    this.finishMediaUpdate();
                    reply.writeNoException();
                    return true;
                }
                case 22: {
                    data.enforceInterface("IMountService");
                    String rawPath = data.readString();
                    String canonicalPath = data.readString();
                    String key = data.readString();
                    IObbActionListener observer = IObbActionListener.Stub.asInterface(data.readStrongBinder());
                    int nonce = data.readInt();
                    this.mountObb(rawPath, canonicalPath, key, observer, nonce);
                    reply.writeNoException();
                    return true;
                }
                case 23: {
                    data.enforceInterface("IMountService");
                    String filename = data.readString();
                    boolean force = 0 != data.readInt();
                    IObbActionListener observer = IObbActionListener.Stub.asInterface(data.readStrongBinder());
                    int nonce = data.readInt();
                    this.unmountObb(filename, force, observer, nonce);
                    reply.writeNoException();
                    return true;
                }
                case 24: {
                    data.enforceInterface("IMountService");
                    String filename = data.readString();
                    boolean status = this.isObbMounted(filename);
                    reply.writeNoException();
                    reply.writeInt(status ? 1 : 0);
                    return true;
                }
                case 25: {
                    data.enforceInterface("IMountService");
                    String filename = data.readString();
                    String mountedPath = this.getMountedObbPath(filename);
                    reply.writeNoException();
                    reply.writeString(mountedPath);
                    return true;
                }
                case 26: {
                    data.enforceInterface("IMountService");
                    boolean emulated = this.isExternalStorageEmulated();
                    reply.writeNoException();
                    reply.writeInt(emulated ? 1 : 0);
                    return true;
                }
                case 27: {
                    data.enforceInterface("IMountService");
                    String password = data.readString();
                    int result = this.decryptStorage(password);
                    reply.writeNoException();
                    reply.writeInt(result);
                    return true;
                }
                case 28: {
                    data.enforceInterface("IMountService");
                    int type = data.readInt();
                    String password = data.readString();
                    int result = this.encryptStorage(type, password);
                    reply.writeNoException();
                    reply.writeInt(result);
                    return true;
                }
                case 29: {
                    data.enforceInterface("IMountService");
                    int type = data.readInt();
                    String password = data.readString();
                    int result = this.changeEncryptionPassword(type, password);
                    reply.writeNoException();
                    reply.writeInt(result);
                    return true;
                }
                case 30: {
                    data.enforceInterface("IMountService");
                    Parcelable[] result = this.getVolumeList();
                    reply.writeNoException();
                    reply.writeTypedArray(result, 1);
                    return true;
                }
                case 31: {
                    data.enforceInterface("IMountService");
                    String id9 = data.readString();
                    String path = this.getSecureContainerFilesystemPath(id9);
                    reply.writeNoException();
                    reply.writeString(path);
                    return true;
                }
                case 32: {
                    data.enforceInterface("IMountService");
                    int result = this.getEncryptionState();
                    reply.writeNoException();
                    reply.writeInt(result);
                    return true;
                }
                case 34: {
                    data.enforceInterface("IMountService");
                    String id10 = data.readString();
                    int gid = data.readInt();
                    String filename = data.readString();
                    int resultCode = this.fixPermissionsSecureContainer(id10, gid, filename);
                    reply.writeNoException();
                    reply.writeInt(resultCode);
                    return true;
                }
                case 35: {
                    data.enforceInterface("IMountService");
                    String callingPkg = data.readString();
                    String path = data.readString();
                    int result = this.mkdirs(callingPkg, path);
                    reply.writeNoException();
                    reply.writeInt(result);
                    return true;
                }
                case 36: {
                    data.enforceInterface("IMountService");
                    int result = this.getPasswordType();
                    reply.writeNoException();
                    reply.writeInt(result);
                    return true;
                }
                case 37: {
                    data.enforceInterface("IMountService");
                    String result = this.getPassword();
                    reply.writeNoException();
                    reply.writeString(result);
                    return true;
                }
                case 38: {
                    data.enforceInterface("IMountService");
                    this.clearPassword();
                    reply.writeNoException();
                    return true;
                }
                case 39: {
                    data.enforceInterface("IMountService");
                    String field = data.readString();
                    String contents = data.readString();
                    this.setField(field, contents);
                    reply.writeNoException();
                    return true;
                }
                case 40: {
                    data.enforceInterface("IMountService");
                    String field = data.readString();
                    String contents = this.getField(field);
                    reply.writeNoException();
                    reply.writeString(contents);
                    return true;
                }
                case 41: {
                    data.enforceInterface("IMountService");
                    String id11 = data.readString();
                    int sizeMb = data.readInt();
                    String key = data.readString();
                    int resultCode = this.resizeSecureContainer(id11, sizeMb, key);
                    reply.writeNoException();
                    reply.writeInt(resultCode);
                    return true;
                }
                case 42: {
                    data.enforceInterface("IMountService");
                    long lastMaintenance = this.lastMaintenance();
                    reply.writeNoException();
                    reply.writeLong(lastMaintenance);
                    return true;
                }
                case 43: {
                    data.enforceInterface("IMountService");
                    this.runMaintenance();
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static IMountService asInterface(IBinder iBinder) {
            return InvokeDynamicSupport.bootstrapStatic("asInterface", $$robo$$android_os_storage_IMountService_Stub$asInterface(android.os.IBinder ), 0, (IBinder)iBinder);
        }

        private void __constructor__() {
            this.$$robo$$android_os_storage_IMountService_Stub$__constructor__();
        }

        public Stub() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_storage_IMountService_Stub$__constructor__(), 0, this);
        }

        @Override
        public IBinder asBinder() {
            return InvokeDynamicSupport.bootstrap("asBinder", $$robo$$android_os_storage_IMountService_Stub$asBinder(), 0, this);
        }

        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            return (boolean)InvokeDynamicSupport.bootstrap("onTransact", $$robo$$android_os_storage_IMountService_Stub$onTransact(int android.os.Parcel android.os.Parcel int ), 0, this, n, parcel, parcel2, n2);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Stub)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private static class Proxy
        implements IMountService,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            private IBinder mRemote;

            private void $$robo$$android_os_storage_IMountService_Stub_Proxy$__constructor__(IBinder remote) {
                this.mRemote = remote;
            }

            private final IBinder $$robo$$android_os_storage_IMountService_Stub_Proxy$asBinder() {
                return this.mRemote;
            }

            private final String $$robo$$android_os_storage_IMountService_Stub_Proxy$getInterfaceDescriptor() {
                return "IMountService";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IMountService_Stub_Proxy$registerListener(IMountServiceListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IMountService_Stub_Proxy$unregisterListener(IMountServiceListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_os_storage_IMountService_Stub_Proxy$isUsbMassStorageConnected() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IMountService_Stub_Proxy$setUsbMassStorageEnabled(boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    _data.writeInt(enable ? 1 : 0);
                    this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_os_storage_IMountService_Stub_Proxy$isUsbMassStorageEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_os_storage_IMountService_Stub_Proxy$mountVolume(String mountPoint) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    _data.writeString(mountPoint);
                    this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IMountService_Stub_Proxy$unmountVolume(String mountPoint, boolean force, boolean removeEncryption) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    _data.writeString(mountPoint);
                    _data.writeInt(force ? 1 : 0);
                    _data.writeInt(removeEncryption ? 1 : 0);
                    this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_os_storage_IMountService_Stub_Proxy$formatVolume(String mountPoint) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    _data.writeString(mountPoint);
                    this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int[] $$robo$$android_os_storage_IMountService_Stub_Proxy$getStorageUsers(String path) throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    _data.writeString(path);
                    this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final String $$robo$$android_os_storage_IMountService_Stub_Proxy$getVolumeState(String mountPoint) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    _data.writeString(mountPoint);
                    this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_os_storage_IMountService_Stub_Proxy$createSecureContainer(String id2, int sizeMb, String fstype, String key, int ownerUid, boolean external) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    _data.writeString(id2);
                    _data.writeInt(sizeMb);
                    _data.writeString(fstype);
                    _data.writeString(key);
                    _data.writeInt(ownerUid);
                    _data.writeInt(external ? 1 : 0);
                    this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_os_storage_IMountService_Stub_Proxy$destroySecureContainer(String id2, boolean force) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    _data.writeString(id2);
                    _data.writeInt(force ? 1 : 0);
                    this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_os_storage_IMountService_Stub_Proxy$finalizeSecureContainer(String id2) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    _data.writeString(id2);
                    this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_os_storage_IMountService_Stub_Proxy$mountSecureContainer(String id2, String key, int ownerUid, boolean readOnly) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    _data.writeString(id2);
                    _data.writeString(key);
                    _data.writeInt(ownerUid);
                    _data.writeInt(readOnly ? 1 : 0);
                    this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_os_storage_IMountService_Stub_Proxy$unmountSecureContainer(String id2, boolean force) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    _data.writeString(id2);
                    _data.writeInt(force ? 1 : 0);
                    this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_os_storage_IMountService_Stub_Proxy$isSecureContainerMounted(String id2) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    _data.writeString(id2);
                    this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_os_storage_IMountService_Stub_Proxy$renameSecureContainer(String oldId, String newId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    _data.writeString(oldId);
                    _data.writeString(newId);
                    this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final String $$robo$$android_os_storage_IMountService_Stub_Proxy$getSecureContainerPath(String id2) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    _data.writeString(id2);
                    this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final String[] $$robo$$android_os_storage_IMountService_Stub_Proxy$getSecureContainerList() throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IMountService_Stub_Proxy$shutdown(IMountShutdownObserver observer) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    _data.writeStrongBinder(observer != null ? observer.asBinder() : null);
                    this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IMountService_Stub_Proxy$finishMediaUpdate() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IMountService_Stub_Proxy$mountObb(String rawPath, String canonicalPath, String key, IObbActionListener token, int nonce) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    _data.writeString(rawPath);
                    _data.writeString(canonicalPath);
                    _data.writeString(key);
                    _data.writeStrongBinder(token != null ? token.asBinder() : null);
                    _data.writeInt(nonce);
                    this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IMountService_Stub_Proxy$unmountObb(String rawPath, boolean force, IObbActionListener token, int nonce) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    _data.writeString(rawPath);
                    _data.writeInt(force ? 1 : 0);
                    _data.writeStrongBinder(token != null ? token.asBinder() : null);
                    _data.writeInt(nonce);
                    this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_os_storage_IMountService_Stub_Proxy$isObbMounted(String rawPath) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    _data.writeString(rawPath);
                    this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final String $$robo$$android_os_storage_IMountService_Stub_Proxy$getMountedObbPath(String rawPath) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    _data.writeString(rawPath);
                    this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final boolean $$robo$$android_os_storage_IMountService_Stub_Proxy$isExternalStorageEmulated() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_os_storage_IMountService_Stub_Proxy$getEncryptionState() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_os_storage_IMountService_Stub_Proxy$decryptStorage(String password) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    _data.writeString(password);
                    this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_os_storage_IMountService_Stub_Proxy$encryptStorage(int type, String password) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    _data.writeInt(type);
                    _data.writeString(password);
                    this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_os_storage_IMountService_Stub_Proxy$changeEncryptionPassword(int type, String password) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    _data.writeInt(type);
                    _data.writeString(password);
                    this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_os_storage_IMountService_Stub_Proxy$verifyEncryptionPassword(String password) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    _data.writeString(password);
                    this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_os_storage_IMountService_Stub_Proxy$getPasswordType() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final String $$robo$$android_os_storage_IMountService_Stub_Proxy$getPassword() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IMountService_Stub_Proxy$clearPassword() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    this.mRemote.transact(38, _data, _reply, 1);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IMountService_Stub_Proxy$setField(String field, String data) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    _data.writeString(field);
                    _data.writeString(data);
                    this.mRemote.transact(39, _data, _reply, 1);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final String $$robo$$android_os_storage_IMountService_Stub_Proxy$getField(String field) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    _data.writeString(field);
                    this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final StorageVolume[] $$robo$$android_os_storage_IMountService_Stub_Proxy$getVolumeList() throws RemoteException {
                StorageVolume[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(StorageVolume.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final String $$robo$$android_os_storage_IMountService_Stub_Proxy$getSecureContainerFilesystemPath(String id2) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    _data.writeString(id2);
                    this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_os_storage_IMountService_Stub_Proxy$fixPermissionsSecureContainer(String id2, int gid, String filename) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    _data.writeString(id2);
                    _data.writeInt(gid);
                    _data.writeString(filename);
                    this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_os_storage_IMountService_Stub_Proxy$mkdirs(String callingPkg, String path) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    _data.writeString(callingPkg);
                    _data.writeString(path);
                    this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final int $$robo$$android_os_storage_IMountService_Stub_Proxy$resizeSecureContainer(String id2, int sizeMb, String key) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    _data.writeString(id2);
                    _data.writeInt(sizeMb);
                    _data.writeString(key);
                    this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final long $$robo$$android_os_storage_IMountService_Stub_Proxy$lastMaintenance() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_os_storage_IMountService_Stub_Proxy$runMaintenance() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken("IMountService");
                    this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            private void __constructor__(IBinder iBinder) {
                this.$$robo$$android_os_storage_IMountService_Stub_Proxy$__constructor__(iBinder);
            }

            Proxy(IBinder iBinder) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_storage_IMountService_Stub_Proxy$__constructor__(android.os.IBinder ), 0, this, iBinder);
            }

            @Override
            public IBinder asBinder() {
                return InvokeDynamicSupport.bootstrap("asBinder", $$robo$$android_os_storage_IMountService_Stub_Proxy$asBinder(), 0, this);
            }

            public String getInterfaceDescriptor() {
                return InvokeDynamicSupport.bootstrap("getInterfaceDescriptor", $$robo$$android_os_storage_IMountService_Stub_Proxy$getInterfaceDescriptor(), 0, this);
            }

            @Override
            public void registerListener(IMountServiceListener iMountServiceListener) throws RemoteException {
                InvokeDynamicSupport.bootstrap("registerListener", $$robo$$android_os_storage_IMountService_Stub_Proxy$registerListener(android.os.storage.IMountServiceListener ), 0, this, iMountServiceListener);
            }

            @Override
            public void unregisterListener(IMountServiceListener iMountServiceListener) throws RemoteException {
                InvokeDynamicSupport.bootstrap("unregisterListener", $$robo$$android_os_storage_IMountService_Stub_Proxy$unregisterListener(android.os.storage.IMountServiceListener ), 0, this, iMountServiceListener);
            }

            @Override
            public boolean isUsbMassStorageConnected() throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("isUsbMassStorageConnected", $$robo$$android_os_storage_IMountService_Stub_Proxy$isUsbMassStorageConnected(), 0, this);
            }

            @Override
            public void setUsbMassStorageEnabled(boolean bl) throws RemoteException {
                InvokeDynamicSupport.bootstrap("setUsbMassStorageEnabled", $$robo$$android_os_storage_IMountService_Stub_Proxy$setUsbMassStorageEnabled(boolean ), 0, this, bl);
            }

            @Override
            public boolean isUsbMassStorageEnabled() throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("isUsbMassStorageEnabled", $$robo$$android_os_storage_IMountService_Stub_Proxy$isUsbMassStorageEnabled(), 0, this);
            }

            @Override
            public int mountVolume(String string2) throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("mountVolume", $$robo$$android_os_storage_IMountService_Stub_Proxy$mountVolume(java.lang.String ), 0, this, string2);
            }

            @Override
            public void unmountVolume(String string2, boolean bl, boolean bl2) throws RemoteException {
                InvokeDynamicSupport.bootstrap("unmountVolume", $$robo$$android_os_storage_IMountService_Stub_Proxy$unmountVolume(java.lang.String boolean boolean ), 0, this, string2, bl, bl2);
            }

            @Override
            public int formatVolume(String string2) throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("formatVolume", $$robo$$android_os_storage_IMountService_Stub_Proxy$formatVolume(java.lang.String ), 0, this, string2);
            }

            @Override
            public int[] getStorageUsers(String string2) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getStorageUsers", $$robo$$android_os_storage_IMountService_Stub_Proxy$getStorageUsers(java.lang.String ), 0, this, string2);
            }

            @Override
            public String getVolumeState(String string2) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getVolumeState", $$robo$$android_os_storage_IMountService_Stub_Proxy$getVolumeState(java.lang.String ), 0, this, string2);
            }

            @Override
            public int createSecureContainer(String string2, int n, String string3, String string4, int n2, boolean bl) throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("createSecureContainer", $$robo$$android_os_storage_IMountService_Stub_Proxy$createSecureContainer(java.lang.String int java.lang.String java.lang.String int boolean ), 0, this, string2, n, string3, string4, n2, bl);
            }

            @Override
            public int destroySecureContainer(String string2, boolean bl) throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("destroySecureContainer", $$robo$$android_os_storage_IMountService_Stub_Proxy$destroySecureContainer(java.lang.String boolean ), 0, this, string2, bl);
            }

            @Override
            public int finalizeSecureContainer(String string2) throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("finalizeSecureContainer", $$robo$$android_os_storage_IMountService_Stub_Proxy$finalizeSecureContainer(java.lang.String ), 0, this, string2);
            }

            @Override
            public int mountSecureContainer(String string2, String string3, int n, boolean bl) throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("mountSecureContainer", $$robo$$android_os_storage_IMountService_Stub_Proxy$mountSecureContainer(java.lang.String java.lang.String int boolean ), 0, this, string2, string3, n, bl);
            }

            @Override
            public int unmountSecureContainer(String string2, boolean bl) throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("unmountSecureContainer", $$robo$$android_os_storage_IMountService_Stub_Proxy$unmountSecureContainer(java.lang.String boolean ), 0, this, string2, bl);
            }

            @Override
            public boolean isSecureContainerMounted(String string2) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("isSecureContainerMounted", $$robo$$android_os_storage_IMountService_Stub_Proxy$isSecureContainerMounted(java.lang.String ), 0, this, string2);
            }

            @Override
            public int renameSecureContainer(String string2, String string3) throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("renameSecureContainer", $$robo$$android_os_storage_IMountService_Stub_Proxy$renameSecureContainer(java.lang.String java.lang.String ), 0, this, string2, string3);
            }

            @Override
            public String getSecureContainerPath(String string2) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getSecureContainerPath", $$robo$$android_os_storage_IMountService_Stub_Proxy$getSecureContainerPath(java.lang.String ), 0, this, string2);
            }

            @Override
            public String[] getSecureContainerList() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getSecureContainerList", $$robo$$android_os_storage_IMountService_Stub_Proxy$getSecureContainerList(), 0, this);
            }

            @Override
            public void shutdown(IMountShutdownObserver iMountShutdownObserver) throws RemoteException {
                InvokeDynamicSupport.bootstrap("shutdown", $$robo$$android_os_storage_IMountService_Stub_Proxy$shutdown(android.os.storage.IMountShutdownObserver ), 0, this, iMountShutdownObserver);
            }

            @Override
            public void finishMediaUpdate() throws RemoteException {
                InvokeDynamicSupport.bootstrap("finishMediaUpdate", $$robo$$android_os_storage_IMountService_Stub_Proxy$finishMediaUpdate(), 0, this);
            }

            @Override
            public void mountObb(String string2, String string3, String string4, IObbActionListener iObbActionListener, int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("mountObb", $$robo$$android_os_storage_IMountService_Stub_Proxy$mountObb(java.lang.String java.lang.String java.lang.String android.os.storage.IObbActionListener int ), 0, this, string2, string3, string4, iObbActionListener, n);
            }

            @Override
            public void unmountObb(String string2, boolean bl, IObbActionListener iObbActionListener, int n) throws RemoteException {
                InvokeDynamicSupport.bootstrap("unmountObb", $$robo$$android_os_storage_IMountService_Stub_Proxy$unmountObb(java.lang.String boolean android.os.storage.IObbActionListener int ), 0, this, string2, bl, iObbActionListener, n);
            }

            @Override
            public boolean isObbMounted(String string2) throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("isObbMounted", $$robo$$android_os_storage_IMountService_Stub_Proxy$isObbMounted(java.lang.String ), 0, this, string2);
            }

            @Override
            public String getMountedObbPath(String string2) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getMountedObbPath", $$robo$$android_os_storage_IMountService_Stub_Proxy$getMountedObbPath(java.lang.String ), 0, this, string2);
            }

            @Override
            public boolean isExternalStorageEmulated() throws RemoteException {
                return (boolean)InvokeDynamicSupport.bootstrap("isExternalStorageEmulated", $$robo$$android_os_storage_IMountService_Stub_Proxy$isExternalStorageEmulated(), 0, this);
            }

            @Override
            public int getEncryptionState() throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("getEncryptionState", $$robo$$android_os_storage_IMountService_Stub_Proxy$getEncryptionState(), 0, this);
            }

            @Override
            public int decryptStorage(String string2) throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("decryptStorage", $$robo$$android_os_storage_IMountService_Stub_Proxy$decryptStorage(java.lang.String ), 0, this, string2);
            }

            @Override
            public int encryptStorage(int n, String string2) throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("encryptStorage", $$robo$$android_os_storage_IMountService_Stub_Proxy$encryptStorage(int java.lang.String ), 0, this, n, string2);
            }

            @Override
            public int changeEncryptionPassword(int n, String string2) throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("changeEncryptionPassword", $$robo$$android_os_storage_IMountService_Stub_Proxy$changeEncryptionPassword(int java.lang.String ), 0, this, n, string2);
            }

            @Override
            public int verifyEncryptionPassword(String string2) throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("verifyEncryptionPassword", $$robo$$android_os_storage_IMountService_Stub_Proxy$verifyEncryptionPassword(java.lang.String ), 0, this, string2);
            }

            @Override
            public int getPasswordType() throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("getPasswordType", $$robo$$android_os_storage_IMountService_Stub_Proxy$getPasswordType(), 0, this);
            }

            @Override
            public String getPassword() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getPassword", $$robo$$android_os_storage_IMountService_Stub_Proxy$getPassword(), 0, this);
            }

            @Override
            public void clearPassword() throws RemoteException {
                InvokeDynamicSupport.bootstrap("clearPassword", $$robo$$android_os_storage_IMountService_Stub_Proxy$clearPassword(), 0, this);
            }

            @Override
            public void setField(String string2, String string3) throws RemoteException {
                InvokeDynamicSupport.bootstrap("setField", $$robo$$android_os_storage_IMountService_Stub_Proxy$setField(java.lang.String java.lang.String ), 0, this, string2, string3);
            }

            @Override
            public String getField(String string2) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getField", $$robo$$android_os_storage_IMountService_Stub_Proxy$getField(java.lang.String ), 0, this, string2);
            }

            @Override
            public StorageVolume[] getVolumeList() throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getVolumeList", $$robo$$android_os_storage_IMountService_Stub_Proxy$getVolumeList(), 0, this);
            }

            @Override
            public String getSecureContainerFilesystemPath(String string2) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("getSecureContainerFilesystemPath", $$robo$$android_os_storage_IMountService_Stub_Proxy$getSecureContainerFilesystemPath(java.lang.String ), 0, this, string2);
            }

            @Override
            public int fixPermissionsSecureContainer(String string2, int n, String string3) throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("fixPermissionsSecureContainer", $$robo$$android_os_storage_IMountService_Stub_Proxy$fixPermissionsSecureContainer(java.lang.String int java.lang.String ), 0, this, string2, n, string3);
            }

            @Override
            public int mkdirs(String string2, String string3) throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("mkdirs", $$robo$$android_os_storage_IMountService_Stub_Proxy$mkdirs(java.lang.String java.lang.String ), 0, this, string2, string3);
            }

            @Override
            public int resizeSecureContainer(String string2, int n, String string3) throws RemoteException {
                return (int)InvokeDynamicSupport.bootstrap("resizeSecureContainer", $$robo$$android_os_storage_IMountService_Stub_Proxy$resizeSecureContainer(java.lang.String int java.lang.String ), 0, this, string2, n, string3);
            }

            @Override
            public long lastMaintenance() throws RemoteException {
                return (long)InvokeDynamicSupport.bootstrap("lastMaintenance", $$robo$$android_os_storage_IMountService_Stub_Proxy$lastMaintenance(), 0, this);
            }

            @Override
            public void runMaintenance() throws RemoteException {
                InvokeDynamicSupport.bootstrap("runMaintenance", $$robo$$android_os_storage_IMountService_Stub_Proxy$runMaintenance(), 0, this);
            }

            public /* synthetic */ Proxy() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Proxy)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }
}

