/*
 * Decompiled with CFR 0.152.
 */
package android.os.storage;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.storage.IMountService;
import android.os.storage.IMountServiceListener;
import android.os.storage.IObbActionListener;
import android.os.storage.OnObbStateChangeListener;
import android.os.storage.StorageEventListener;
import android.os.storage.StorageVolume;
import android.provider.Settings;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.util.Preconditions;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class StorageManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "StorageManager";
    private ContentResolver mResolver;
    private IMountService mMountService;
    private Looper mTgtLooper;
    private MountServiceBinderListener mBinderListener;
    private List<ListenerDelegate> mListeners;
    private AtomicInteger mNextNonce;
    private ObbActionListener mObbActionListener;
    private static int DEFAULT_THRESHOLD_PERCENTAGE = 10;
    private static long DEFAULT_THRESHOLD_MAX_BYTES = 524288000L;
    private static long DEFAULT_FULL_THRESHOLD_BYTES = 0x100000L;
    public static int CRYPT_TYPE_PASSWORD = 0;
    public static int CRYPT_TYPE_DEFAULT = 1;
    public static int CRYPT_TYPE_PATTERN = 2;
    public static int CRYPT_TYPE_PIN = 3;
    public static String SYSTEM_LOCALE_KEY = "SystemLocale";
    public static String OWNER_INFO_KEY = "OwnerInfo";
    public static String PATTERN_VISIBLE_KEY = "PatternVisible";

    private final int $$robo$$android_os_storage_StorageManager$getNextNonce() {
        return this.mNextNonce.getAndIncrement();
    }

    private static final StorageManager $$robo$$android_os_storage_StorageManager$from(Context context) {
        return (StorageManager)context.getSystemService("storage");
    }

    private void $$robo$$android_os_storage_StorageManager$__constructor__(ContentResolver resolver, Looper tgtLooper) throws RemoteException {
        this.mListeners = new ArrayList<ListenerDelegate>();
        this.mNextNonce = new AtomicInteger(0);
        this.mObbActionListener = new ObbActionListener(this);
        this.mResolver = resolver;
        this.mTgtLooper = tgtLooper;
        this.mMountService = IMountService.Stub.asInterface(ServiceManager.getService("mount"));
        if (this.mMountService == null) {
            Log.e("StorageManager", "Unable to connect to mount service! - is it running yet?");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_os_storage_StorageManager$registerListener(StorageEventListener listener) {
        if (listener == null) {
            return;
        }
        List<ListenerDelegate> list = this.mListeners;
        synchronized (list) {
            if (this.mBinderListener == null) {
                try {
                    this.mBinderListener = new MountServiceBinderListener(this);
                    this.mMountService.registerListener(this.mBinderListener);
                }
                catch (RemoteException rex) {
                    Log.e("StorageManager", "Register mBinderListener failed");
                    return;
                }
            }
            this.mListeners.add(new ListenerDelegate(this, listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_os_storage_StorageManager$unregisterListener(StorageEventListener listener) {
        if (listener == null) {
            return;
        }
        List<ListenerDelegate> list = this.mListeners;
        synchronized (list) {
            int size = this.mListeners.size();
            for (int i = 0; i < size; ++i) {
                ListenerDelegate l = this.mListeners.get(i);
                if (l.getListener() != listener) continue;
                this.mListeners.remove(i);
                break;
            }
            if (this.mListeners.size() == 0 && this.mBinderListener != null) {
                try {
                    this.mMountService.unregisterListener(this.mBinderListener);
                }
                catch (RemoteException rex) {
                    Log.e("StorageManager", "Unregister mBinderListener failed");
                    return;
                }
            }
        }
    }

    private final void $$robo$$android_os_storage_StorageManager$enableUsbMassStorage() {
        try {
            this.mMountService.setUsbMassStorageEnabled(true);
        }
        catch (Exception ex) {
            Log.e("StorageManager", "Failed to enable UMS", ex);
        }
    }

    private final void $$robo$$android_os_storage_StorageManager$disableUsbMassStorage() {
        try {
            this.mMountService.setUsbMassStorageEnabled(false);
        }
        catch (Exception ex) {
            Log.e("StorageManager", "Failed to disable UMS", ex);
        }
    }

    private final boolean $$robo$$android_os_storage_StorageManager$isUsbMassStorageConnected() {
        try {
            return this.mMountService.isUsbMassStorageConnected();
        }
        catch (Exception ex) {
            Log.e("StorageManager", "Failed to get UMS connection state", ex);
            return false;
        }
    }

    private final boolean $$robo$$android_os_storage_StorageManager$isUsbMassStorageEnabled() {
        try {
            return this.mMountService.isUsbMassStorageEnabled();
        }
        catch (RemoteException rex) {
            Log.e("StorageManager", "Failed to get UMS enable state", rex);
            return false;
        }
    }

    private final boolean $$robo$$android_os_storage_StorageManager$mountObb(String rawPath, String key, OnObbStateChangeListener listener) {
        Preconditions.checkNotNull(rawPath, "rawPath cannot be null");
        Preconditions.checkNotNull(listener, "listener cannot be null");
        try {
            String canonicalPath = new File(rawPath).getCanonicalPath();
            int nonce = this.mObbActionListener.addListener(listener);
            this.mMountService.mountObb(rawPath, canonicalPath, key, this.mObbActionListener, nonce);
            return true;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to resolve path: " + rawPath, e);
        }
        catch (RemoteException e) {
            Log.e("StorageManager", "Failed to mount OBB", e);
            return false;
        }
    }

    private final boolean $$robo$$android_os_storage_StorageManager$unmountObb(String rawPath, boolean force, OnObbStateChangeListener listener) {
        Preconditions.checkNotNull(rawPath, "rawPath cannot be null");
        Preconditions.checkNotNull(listener, "listener cannot be null");
        try {
            int nonce = this.mObbActionListener.addListener(listener);
            this.mMountService.unmountObb(rawPath, force, this.mObbActionListener, nonce);
            return true;
        }
        catch (RemoteException e) {
            Log.e("StorageManager", "Failed to mount OBB", e);
            return false;
        }
    }

    private final boolean $$robo$$android_os_storage_StorageManager$isObbMounted(String rawPath) {
        Preconditions.checkNotNull(rawPath, "rawPath cannot be null");
        try {
            return this.mMountService.isObbMounted(rawPath);
        }
        catch (RemoteException e) {
            Log.e("StorageManager", "Failed to check if OBB is mounted", e);
            return false;
        }
    }

    private final String $$robo$$android_os_storage_StorageManager$getMountedObbPath(String rawPath) {
        Preconditions.checkNotNull(rawPath, "rawPath cannot be null");
        try {
            return this.mMountService.getMountedObbPath(rawPath);
        }
        catch (RemoteException e) {
            Log.e("StorageManager", "Failed to find mounted path for OBB", e);
            return null;
        }
    }

    private final String $$robo$$android_os_storage_StorageManager$getVolumeState(String mountPoint) {
        if (this.mMountService == null) {
            return "removed";
        }
        try {
            return this.mMountService.getVolumeState(mountPoint);
        }
        catch (RemoteException e) {
            Log.e("StorageManager", "Failed to get volume state", e);
            return null;
        }
    }

    private final StorageVolume[] $$robo$$android_os_storage_StorageManager$getVolumeList() {
        if (this.mMountService == null) {
            return new StorageVolume[0];
        }
        try {
            StorageVolume[] list = this.mMountService.getVolumeList();
            if (list == null) {
                return new StorageVolume[0];
            }
            int length = list.length;
            StorageVolume[] result = new StorageVolume[length];
            for (int i = 0; i < length; ++i) {
                result[i] = list[i];
            }
            return result;
        }
        catch (RemoteException e) {
            Log.e("StorageManager", "Failed to get volume list", e);
            return null;
        }
    }

    private final String[] $$robo$$android_os_storage_StorageManager$getVolumePaths() {
        StorageVolume[] volumes = this.getVolumeList();
        if (volumes == null) {
            return null;
        }
        int count = volumes.length;
        String[] paths = new String[count];
        for (int i = 0; i < count; ++i) {
            paths[i] = volumes[i].getPath();
        }
        return paths;
    }

    private final StorageVolume $$robo$$android_os_storage_StorageManager$getPrimaryVolume() {
        return StorageManager.getPrimaryVolume(this.getVolumeList());
    }

    private static final StorageVolume $$robo$$android_os_storage_StorageManager$getPrimaryVolume(StorageVolume[] volumes) {
        for (StorageVolume volume : volumes) {
            if (!volume.isPrimary()) continue;
            return volume;
        }
        Log.w("StorageManager", "No primary storage defined");
        return null;
    }

    private final long $$robo$$android_os_storage_StorageManager$getStorageBytesUntilLow(File path) {
        return path.getUsableSpace() - this.getStorageFullBytes(path);
    }

    private final long $$robo$$android_os_storage_StorageManager$getStorageLowBytes(File path) {
        long lowPercent = Settings.Global.getInt(this.mResolver, "sys_storage_threshold_percentage", 10);
        long lowBytes = path.getTotalSpace() * lowPercent / 100L;
        long maxLowBytes = Settings.Global.getLong(this.mResolver, "sys_storage_threshold_max_bytes", 524288000L);
        return Math.min(lowBytes, maxLowBytes);
    }

    private final long $$robo$$android_os_storage_StorageManager$getStorageFullBytes(File path) {
        return Settings.Global.getLong(this.mResolver, "sys_storage_full_threshold_bytes", 0x100000L);
    }

    private int getNextNonce() {
        return (int)InvokeDynamicSupport.bootstrap("getNextNonce", $$robo$$android_os_storage_StorageManager$getNextNonce(), 0, this);
    }

    public static StorageManager from(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("from", $$robo$$android_os_storage_StorageManager$from(android.content.Context ), 0, (Context)context);
    }

    private void __constructor__(ContentResolver contentResolver, Looper looper) throws RemoteException {
        this.$$robo$$android_os_storage_StorageManager$__constructor__(contentResolver, looper);
    }

    public StorageManager(ContentResolver contentResolver, Looper looper) throws RemoteException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_storage_StorageManager$__constructor__(android.content.ContentResolver android.os.Looper ), 0, this, contentResolver, looper);
    }

    public void registerListener(StorageEventListener storageEventListener) {
        InvokeDynamicSupport.bootstrap("registerListener", $$robo$$android_os_storage_StorageManager$registerListener(android.os.storage.StorageEventListener ), 0, this, storageEventListener);
    }

    public void unregisterListener(StorageEventListener storageEventListener) {
        InvokeDynamicSupport.bootstrap("unregisterListener", $$robo$$android_os_storage_StorageManager$unregisterListener(android.os.storage.StorageEventListener ), 0, this, storageEventListener);
    }

    public void enableUsbMassStorage() {
        InvokeDynamicSupport.bootstrap("enableUsbMassStorage", $$robo$$android_os_storage_StorageManager$enableUsbMassStorage(), 0, this);
    }

    public void disableUsbMassStorage() {
        InvokeDynamicSupport.bootstrap("disableUsbMassStorage", $$robo$$android_os_storage_StorageManager$disableUsbMassStorage(), 0, this);
    }

    public boolean isUsbMassStorageConnected() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUsbMassStorageConnected", $$robo$$android_os_storage_StorageManager$isUsbMassStorageConnected(), 0, this);
    }

    public boolean isUsbMassStorageEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUsbMassStorageEnabled", $$robo$$android_os_storage_StorageManager$isUsbMassStorageEnabled(), 0, this);
    }

    public boolean mountObb(String string2, String string3, OnObbStateChangeListener onObbStateChangeListener) {
        return (boolean)InvokeDynamicSupport.bootstrap("mountObb", $$robo$$android_os_storage_StorageManager$mountObb(java.lang.String java.lang.String android.os.storage.OnObbStateChangeListener ), 0, this, string2, string3, onObbStateChangeListener);
    }

    public boolean unmountObb(String string2, boolean bl, OnObbStateChangeListener onObbStateChangeListener) {
        return (boolean)InvokeDynamicSupport.bootstrap("unmountObb", $$robo$$android_os_storage_StorageManager$unmountObb(java.lang.String boolean android.os.storage.OnObbStateChangeListener ), 0, this, string2, bl, onObbStateChangeListener);
    }

    public boolean isObbMounted(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isObbMounted", $$robo$$android_os_storage_StorageManager$isObbMounted(java.lang.String ), 0, this, string2);
    }

    public String getMountedObbPath(String string2) {
        return InvokeDynamicSupport.bootstrap("getMountedObbPath", $$robo$$android_os_storage_StorageManager$getMountedObbPath(java.lang.String ), 0, this, string2);
    }

    public String getVolumeState(String string2) {
        return InvokeDynamicSupport.bootstrap("getVolumeState", $$robo$$android_os_storage_StorageManager$getVolumeState(java.lang.String ), 0, this, string2);
    }

    public StorageVolume[] getVolumeList() {
        return InvokeDynamicSupport.bootstrap("getVolumeList", $$robo$$android_os_storage_StorageManager$getVolumeList(), 0, this);
    }

    public String[] getVolumePaths() {
        return InvokeDynamicSupport.bootstrap("getVolumePaths", $$robo$$android_os_storage_StorageManager$getVolumePaths(), 0, this);
    }

    public StorageVolume getPrimaryVolume() {
        return InvokeDynamicSupport.bootstrap("getPrimaryVolume", $$robo$$android_os_storage_StorageManager$getPrimaryVolume(), 0, this);
    }

    public static StorageVolume getPrimaryVolume(StorageVolume[] storageVolumeArray) {
        return InvokeDynamicSupport.bootstrapStatic("getPrimaryVolume", $$robo$$android_os_storage_StorageManager$getPrimaryVolume(android.os.storage.StorageVolume[] ), 0, (StorageVolume[])storageVolumeArray);
    }

    public long getStorageBytesUntilLow(File file) {
        return (long)InvokeDynamicSupport.bootstrap("getStorageBytesUntilLow", $$robo$$android_os_storage_StorageManager$getStorageBytesUntilLow(java.io.File ), 0, this, file);
    }

    public long getStorageLowBytes(File file) {
        return (long)InvokeDynamicSupport.bootstrap("getStorageLowBytes", $$robo$$android_os_storage_StorageManager$getStorageLowBytes(java.io.File ), 0, this, file);
    }

    public long getStorageFullBytes(File file) {
        return (long)InvokeDynamicSupport.bootstrap("getStorageFullBytes", $$robo$$android_os_storage_StorageManager$getStorageFullBytes(java.io.File ), 0, this, file);
    }

    public /* synthetic */ StorageManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StorageManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class ListenerDelegate
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        StorageEventListener mStorageEventListener;
        private Handler mHandler;
        /* synthetic */ StorageManager this$0;

        private void $$robo$$android_os_storage_StorageManager_ListenerDelegate$__constructor__(StorageManager storageManager, StorageEventListener listener) {
            this.mStorageEventListener = listener;
            this.mHandler = new ShadowedObject(this, storageManager.mTgtLooper, storageManager){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ StorageManager val$this$0;
                /* synthetic */ ListenerDelegate this$1;

                private void $$robo$$android_os_storage_StorageManager_ListenerDelegate_1$__constructor__(ListenerDelegate listenerDelegate, Looper x0, StorageManager storageManager) {
                }

                private final void $$robo$$android_os_storage_StorageManager_ListenerDelegate_1$handleMessage(Message msg) {
                    StorageEvent e = (StorageEvent)msg.obj;
                    if (msg.what == 1) {
                        UmsConnectionChangedStorageEvent ev = (UmsConnectionChangedStorageEvent)e;
                        this.this$1.mStorageEventListener.onUsbMassStorageConnectionChanged(ev.available);
                    } else if (msg.what == 2) {
                        StorageStateChangedStorageEvent ev = (StorageStateChangedStorageEvent)e;
                        this.this$1.mStorageEventListener.onStorageStateChanged(ev.path, ev.oldState, ev.newState);
                    } else {
                        Log.e("StorageManager", "Unsupported event " + msg.what);
                    }
                }

                private void __constructor__(ListenerDelegate listenerDelegate, Looper looper, StorageManager storageManager) {
                    this.$$robo$$android_os_storage_StorageManager_ListenerDelegate_1$__constructor__(listenerDelegate, looper, storageManager);
                }
                {
                    this.this$1 = listenerDelegate;
                    this.val$this$0 = storageManager;
                    super(looper);
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_storage_StorageManager_ListenerDelegate_1$__constructor__(android.os.storage.StorageManager$ListenerDelegate android.os.Looper android.os.storage.StorageManager ), 0, this, listenerDelegate, looper, storageManager);
                }

                @Override
                public void handleMessage(Message message) {
                    InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_os_storage_StorageManager_ListenerDelegate_1$handleMessage(android.os.Message ), 0, this, message);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private final StorageEventListener $$robo$$android_os_storage_StorageManager_ListenerDelegate$getListener() {
            return this.mStorageEventListener;
        }

        private final void $$robo$$android_os_storage_StorageManager_ListenerDelegate$sendShareAvailabilityChanged(boolean available) {
            UmsConnectionChangedStorageEvent e = new UmsConnectionChangedStorageEvent(this.this$0, available);
            this.mHandler.sendMessage(e.getMessage());
        }

        private final void $$robo$$android_os_storage_StorageManager_ListenerDelegate$sendStorageStateChanged(String path, String oldState, String newState) {
            StorageStateChangedStorageEvent e = new StorageStateChangedStorageEvent(this.this$0, path, oldState, newState);
            this.mHandler.sendMessage(e.getMessage());
        }

        private void __constructor__(StorageManager storageManager, StorageEventListener storageEventListener) {
            this.$$robo$$android_os_storage_StorageManager_ListenerDelegate$__constructor__(storageManager, storageEventListener);
        }

        ListenerDelegate(StorageManager storageManager, StorageEventListener storageEventListener) {
            this.this$0 = storageManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_storage_StorageManager_ListenerDelegate$__constructor__(android.os.storage.StorageManager android.os.storage.StorageEventListener ), 0, this, storageManager, storageEventListener);
        }

        StorageEventListener getListener() {
            return InvokeDynamicSupport.bootstrap("getListener", $$robo$$android_os_storage_StorageManager_ListenerDelegate$getListener(), 0, this);
        }

        void sendShareAvailabilityChanged(boolean bl) {
            InvokeDynamicSupport.bootstrap("sendShareAvailabilityChanged", $$robo$$android_os_storage_StorageManager_ListenerDelegate$sendShareAvailabilityChanged(boolean ), 0, this, bl);
        }

        void sendStorageStateChanged(String string2, String string3, String string4) {
            InvokeDynamicSupport.bootstrap("sendStorageStateChanged", $$robo$$android_os_storage_StorageManager_ListenerDelegate$sendStorageStateChanged(java.lang.String java.lang.String java.lang.String ), 0, this, string2, string3, string4);
        }

        public /* synthetic */ ListenerDelegate() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ListenerDelegate)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class StorageStateChangedStorageEvent
    extends StorageEvent
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String path;
        public String oldState;
        public String newState;
        /* synthetic */ StorageManager this$0;

        private void $$robo$$android_os_storage_StorageManager_StorageStateChangedStorageEvent$__constructor__(StorageManager storageManager, String p, String oldS, String newS) {
            this.path = p;
            this.oldState = oldS;
            this.newState = newS;
        }

        private void __constructor__(StorageManager storageManager, String string2, String string3, String string4) {
            this.$$robo$$android_os_storage_StorageManager_StorageStateChangedStorageEvent$__constructor__(storageManager, string2, string3, string4);
        }

        public StorageStateChangedStorageEvent(StorageManager storageManager, String string2, String string3, String string4) {
            this.this$0 = storageManager;
            super(storageManager, 2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_storage_StorageManager_StorageStateChangedStorageEvent$__constructor__(android.os.storage.StorageManager java.lang.String java.lang.String java.lang.String ), 0, this, storageManager, string2, string3, string4);
        }

        public /* synthetic */ StorageStateChangedStorageEvent() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StorageStateChangedStorageEvent)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class UmsConnectionChangedStorageEvent
    extends StorageEvent
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public boolean available;
        /* synthetic */ StorageManager this$0;

        private void $$robo$$android_os_storage_StorageManager_UmsConnectionChangedStorageEvent$__constructor__(StorageManager storageManager, boolean a) {
            this.available = a;
        }

        private void __constructor__(StorageManager storageManager, boolean bl) {
            this.$$robo$$android_os_storage_StorageManager_UmsConnectionChangedStorageEvent$__constructor__(storageManager, bl);
        }

        public UmsConnectionChangedStorageEvent(StorageManager storageManager, boolean bl) {
            this.this$0 = storageManager;
            super(storageManager, 1);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_storage_StorageManager_UmsConnectionChangedStorageEvent$__constructor__(android.os.storage.StorageManager boolean ), 0, this, storageManager, bl);
        }

        public /* synthetic */ UmsConnectionChangedStorageEvent() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UmsConnectionChangedStorageEvent)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class StorageEvent
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static int EVENT_UMS_CONNECTION_CHANGED = 1;
        static int EVENT_STORAGE_STATE_CHANGED = 2;
        static int EVENT_OBB_STATE_CHANGED = 3;
        private Message mMessage;
        /* synthetic */ StorageManager this$0;

        private void $$robo$$android_os_storage_StorageManager_StorageEvent$__constructor__(StorageManager storageManager, int what) {
            this.mMessage = Message.obtain();
            this.mMessage.what = what;
            this.mMessage.obj = this;
        }

        private final Message $$robo$$android_os_storage_StorageManager_StorageEvent$getMessage() {
            return this.mMessage;
        }

        private void __constructor__(StorageManager storageManager, int n) {
            this.$$robo$$android_os_storage_StorageManager_StorageEvent$__constructor__(storageManager, n);
        }

        public StorageEvent(StorageManager storageManager, int n) {
            this.this$0 = storageManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_storage_StorageManager_StorageEvent$__constructor__(android.os.storage.StorageManager int ), 0, this, storageManager, n);
        }

        public Message getMessage() {
            return InvokeDynamicSupport.bootstrap("getMessage", $$robo$$android_os_storage_StorageManager_StorageEvent$getMessage(), 0, this);
        }

        public /* synthetic */ StorageEvent() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StorageEvent)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ObbStateChangedStorageEvent
    extends StorageEvent
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String path;
        public int state;
        /* synthetic */ StorageManager this$0;

        private void $$robo$$android_os_storage_StorageManager_ObbStateChangedStorageEvent$__constructor__(StorageManager storageManager, String path, int state) {
            this.path = path;
            this.state = state;
        }

        private void __constructor__(StorageManager storageManager, String string2, int n) {
            this.$$robo$$android_os_storage_StorageManager_ObbStateChangedStorageEvent$__constructor__(storageManager, string2, n);
        }

        public ObbStateChangedStorageEvent(StorageManager storageManager, String string2, int n) {
            this.this$0 = storageManager;
            super(storageManager, 3);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_storage_StorageManager_ObbStateChangedStorageEvent$__constructor__(android.os.storage.StorageManager java.lang.String int ), 0, this, storageManager, string2, n);
        }

        public /* synthetic */ ObbStateChangedStorageEvent() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ObbStateChangedStorageEvent)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ObbListenerDelegate
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private WeakReference<OnObbStateChangeListener> mObbEventListenerRef;
        private Handler mHandler;
        private int nonce;
        /* synthetic */ StorageManager this$0;

        private void $$robo$$android_os_storage_StorageManager_ObbListenerDelegate$__constructor__(StorageManager storageManager, OnObbStateChangeListener listener) {
            this.nonce = storageManager.getNextNonce();
            this.mObbEventListenerRef = new WeakReference<OnObbStateChangeListener>(listener);
            this.mHandler = new ShadowedObject(this, storageManager.mTgtLooper, storageManager){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ StorageManager val$this$0;
                /* synthetic */ ObbListenerDelegate this$1;

                private void $$robo$$android_os_storage_StorageManager_ObbListenerDelegate_1$__constructor__(ObbListenerDelegate obbListenerDelegate, Looper x0, StorageManager storageManager) {
                }

                private final void $$robo$$android_os_storage_StorageManager_ObbListenerDelegate_1$handleMessage(Message msg) {
                    OnObbStateChangeListener changeListener = this.this$1.getListener();
                    if (changeListener == null) {
                        return;
                    }
                    StorageEvent e = (StorageEvent)msg.obj;
                    if (msg.what == 3) {
                        ObbStateChangedStorageEvent ev = (ObbStateChangedStorageEvent)e;
                        changeListener.onObbStateChange(ev.path, ev.state);
                    } else {
                        Log.e("StorageManager", "Unsupported event " + msg.what);
                    }
                }

                private void __constructor__(ObbListenerDelegate obbListenerDelegate, Looper looper, StorageManager storageManager) {
                    this.$$robo$$android_os_storage_StorageManager_ObbListenerDelegate_1$__constructor__(obbListenerDelegate, looper, storageManager);
                }
                {
                    this.this$1 = obbListenerDelegate;
                    this.val$this$0 = storageManager;
                    super(looper);
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_storage_StorageManager_ObbListenerDelegate_1$__constructor__(android.os.storage.StorageManager$ObbListenerDelegate android.os.Looper android.os.storage.StorageManager ), 0, this, obbListenerDelegate, looper, storageManager);
                }

                @Override
                public void handleMessage(Message message) {
                    InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_os_storage_StorageManager_ObbListenerDelegate_1$handleMessage(android.os.Message ), 0, this, message);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private final OnObbStateChangeListener $$robo$$android_os_storage_StorageManager_ObbListenerDelegate$getListener() {
            if (this.mObbEventListenerRef == null) {
                return null;
            }
            return (OnObbStateChangeListener)this.mObbEventListenerRef.get();
        }

        private final void $$robo$$android_os_storage_StorageManager_ObbListenerDelegate$sendObbStateChanged(String path, int state) {
            ObbStateChangedStorageEvent e = new ObbStateChangedStorageEvent(this.this$0, path, state);
            this.mHandler.sendMessage(e.getMessage());
        }

        private void __constructor__(StorageManager storageManager, OnObbStateChangeListener onObbStateChangeListener) {
            this.$$robo$$android_os_storage_StorageManager_ObbListenerDelegate$__constructor__(storageManager, onObbStateChangeListener);
        }

        ObbListenerDelegate(StorageManager storageManager, OnObbStateChangeListener onObbStateChangeListener) {
            this.this$0 = storageManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_storage_StorageManager_ObbListenerDelegate$__constructor__(android.os.storage.StorageManager android.os.storage.OnObbStateChangeListener ), 0, this, storageManager, onObbStateChangeListener);
        }

        OnObbStateChangeListener getListener() {
            return InvokeDynamicSupport.bootstrap("getListener", $$robo$$android_os_storage_StorageManager_ObbListenerDelegate$getListener(), 0, this);
        }

        void sendObbStateChanged(String string2, int n) {
            InvokeDynamicSupport.bootstrap("sendObbStateChanged", $$robo$$android_os_storage_StorageManager_ObbListenerDelegate$sendObbStateChanged(java.lang.String int ), 0, this, string2, n);
        }

        public /* synthetic */ ObbListenerDelegate() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ObbListenerDelegate)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ObbActionListener
    extends IObbActionListener.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private SparseArray<ObbListenerDelegate> mListeners;
        /* synthetic */ StorageManager this$0;

        private void $$robo$$android_os_storage_StorageManager_ObbActionListener$__constructor__(StorageManager storageManager) {
            this.mListeners = new SparseArray();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_os_storage_StorageManager_ObbActionListener$onObbResult(String filename, int nonce, int status) {
            ObbListenerDelegate delegate;
            SparseArray<ObbListenerDelegate> sparseArray = this.mListeners;
            synchronized (sparseArray) {
                delegate = this.mListeners.get(nonce);
                if (delegate != null) {
                    this.mListeners.remove(nonce);
                }
            }
            if (delegate != null) {
                delegate.sendObbStateChanged(filename, status);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final int $$robo$$android_os_storage_StorageManager_ObbActionListener$addListener(OnObbStateChangeListener listener) {
            ObbListenerDelegate delegate = new ObbListenerDelegate(this.this$0, listener);
            SparseArray<ObbListenerDelegate> sparseArray = this.mListeners;
            synchronized (sparseArray) {
                this.mListeners.put(delegate.nonce, delegate);
            }
            return delegate.nonce;
        }

        private /* synthetic */ void $$robo$$android_os_storage_StorageManager_ObbActionListener$__constructor__(StorageManager x0, 1 x1) {
        }

        private void __constructor__(StorageManager storageManager) {
            this.$$robo$$android_os_storage_StorageManager_ObbActionListener$__constructor__(storageManager);
        }

        private ObbActionListener(StorageManager storageManager) {
            this.this$0 = storageManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_storage_StorageManager_ObbActionListener$__constructor__(android.os.storage.StorageManager ), 0, this, storageManager);
        }

        @Override
        public void onObbResult(String string2, int n, int n2) {
            InvokeDynamicSupport.bootstrap("onObbResult", $$robo$$android_os_storage_StorageManager_ObbActionListener$onObbResult(java.lang.String int int ), 0, this, string2, n, n2);
        }

        public int addListener(OnObbStateChangeListener onObbStateChangeListener) {
            return (int)InvokeDynamicSupport.bootstrap("addListener", $$robo$$android_os_storage_StorageManager_ObbActionListener$addListener(android.os.storage.OnObbStateChangeListener ), 0, this, onObbStateChangeListener);
        }

        private /* synthetic */ void __constructor__(StorageManager storageManager, 1 var2_2) {
            this.$$robo$$android_os_storage_StorageManager_ObbActionListener$__constructor__(storageManager, var2_2);
        }

        public /* synthetic */ ObbActionListener() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ObbActionListener)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class MountServiceBinderListener
    extends IMountServiceListener.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ StorageManager this$0;

        private void $$robo$$android_os_storage_StorageManager_MountServiceBinderListener$__constructor__(StorageManager storageManager) {
        }

        private final void $$robo$$android_os_storage_StorageManager_MountServiceBinderListener$onUsbMassStorageConnectionChanged(boolean available) {
            int size = this.this$0.mListeners.size();
            for (int i = 0; i < size; ++i) {
                ((ListenerDelegate)this.this$0.mListeners.get(i)).sendShareAvailabilityChanged(available);
            }
        }

        private final void $$robo$$android_os_storage_StorageManager_MountServiceBinderListener$onStorageStateChanged(String path, String oldState, String newState) {
            int size = this.this$0.mListeners.size();
            for (int i = 0; i < size; ++i) {
                ((ListenerDelegate)this.this$0.mListeners.get(i)).sendStorageStateChanged(path, oldState, newState);
            }
        }

        private /* synthetic */ void $$robo$$android_os_storage_StorageManager_MountServiceBinderListener$__constructor__(StorageManager x0, 1 x1) {
        }

        private void __constructor__(StorageManager storageManager) {
            this.$$robo$$android_os_storage_StorageManager_MountServiceBinderListener$__constructor__(storageManager);
        }

        private MountServiceBinderListener(StorageManager storageManager) {
            this.this$0 = storageManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_storage_StorageManager_MountServiceBinderListener$__constructor__(android.os.storage.StorageManager ), 0, this, storageManager);
        }

        @Override
        public void onUsbMassStorageConnectionChanged(boolean bl) {
            InvokeDynamicSupport.bootstrap("onUsbMassStorageConnectionChanged", $$robo$$android_os_storage_StorageManager_MountServiceBinderListener$onUsbMassStorageConnectionChanged(boolean ), 0, this, bl);
        }

        @Override
        public void onStorageStateChanged(String string2, String string3, String string4) {
            InvokeDynamicSupport.bootstrap("onStorageStateChanged", $$robo$$android_os_storage_StorageManager_MountServiceBinderListener$onStorageStateChanged(java.lang.String java.lang.String java.lang.String ), 0, this, string2, string3, string4);
        }

        private /* synthetic */ void __constructor__(StorageManager storageManager, 1 var2_2) {
            this.$$robo$$android_os_storage_StorageManager_MountServiceBinderListener$__constructor__(storageManager, var2_2);
        }

        public /* synthetic */ MountServiceBinderListener() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MountServiceBinderListener)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

