/*
 * Decompiled with CFR 0.152.
 */
package android.os.storage;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import com.android.internal.util.IndentingPrintWriter;
import java.io.CharArrayWriter;
import java.io.File;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class StorageVolume
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private int mStorageId;
    private File mPath;
    private int mDescriptionId;
    private boolean mPrimary;
    private boolean mRemovable;
    private boolean mEmulated;
    private int mMtpReserveSpace;
    private boolean mAllowMassStorage;
    private long mMaxFileSize;
    private UserHandle mOwner;
    private String mUuid;
    private String mUserLabel;
    private String mState;
    public static String EXTRA_STORAGE_VOLUME = "storage_volume";
    public static Parcelable.Creator<StorageVolume> CREATOR;

    private void $$robo$$android_os_storage_StorageVolume$__constructor__(File path, int descriptionId, boolean primary, boolean removable, boolean emulated, int mtpReserveSpace, boolean allowMassStorage, long maxFileSize, UserHandle owner) {
        this.mPath = path;
        this.mDescriptionId = descriptionId;
        this.mPrimary = primary;
        this.mRemovable = removable;
        this.mEmulated = emulated;
        this.mMtpReserveSpace = mtpReserveSpace;
        this.mAllowMassStorage = allowMassStorage;
        this.mMaxFileSize = maxFileSize;
        this.mOwner = owner;
    }

    private void $$robo$$android_os_storage_StorageVolume$__constructor__(Parcel in) {
        this.mStorageId = in.readInt();
        this.mPath = new File(in.readString());
        this.mDescriptionId = in.readInt();
        this.mPrimary = in.readInt() != 0;
        this.mRemovable = in.readInt() != 0;
        this.mEmulated = in.readInt() != 0;
        this.mMtpReserveSpace = in.readInt();
        this.mAllowMassStorage = in.readInt() != 0;
        this.mMaxFileSize = in.readLong();
        this.mOwner = (UserHandle)in.readParcelable(null);
        this.mUuid = in.readString();
        this.mUserLabel = in.readString();
        this.mState = in.readString();
    }

    private static final StorageVolume $$robo$$android_os_storage_StorageVolume$fromTemplate(StorageVolume template, File path, UserHandle owner) {
        return new StorageVolume(path, template.mDescriptionId, template.mPrimary, template.mRemovable, template.mEmulated, template.mMtpReserveSpace, template.mAllowMassStorage, template.mMaxFileSize, owner);
    }

    private final String $$robo$$android_os_storage_StorageVolume$getPath() {
        return this.mPath.toString();
    }

    private final File $$robo$$android_os_storage_StorageVolume$getPathFile() {
        return this.mPath;
    }

    private final String $$robo$$android_os_storage_StorageVolume$getDescription(Context context) {
        return context.getResources().getString(this.mDescriptionId);
    }

    private final int $$robo$$android_os_storage_StorageVolume$getDescriptionId() {
        return this.mDescriptionId;
    }

    private final boolean $$robo$$android_os_storage_StorageVolume$isPrimary() {
        return this.mPrimary;
    }

    private final boolean $$robo$$android_os_storage_StorageVolume$isRemovable() {
        return this.mRemovable;
    }

    private final boolean $$robo$$android_os_storage_StorageVolume$isEmulated() {
        return this.mEmulated;
    }

    private final int $$robo$$android_os_storage_StorageVolume$getStorageId() {
        return this.mStorageId;
    }

    private final void $$robo$$android_os_storage_StorageVolume$setStorageId(int index) {
        this.mStorageId = (index + 1 << 16) + 1;
    }

    private final int $$robo$$android_os_storage_StorageVolume$getMtpReserveSpace() {
        return this.mMtpReserveSpace;
    }

    private final boolean $$robo$$android_os_storage_StorageVolume$allowMassStorage() {
        return this.mAllowMassStorage;
    }

    private final long $$robo$$android_os_storage_StorageVolume$getMaxFileSize() {
        return this.mMaxFileSize;
    }

    private final UserHandle $$robo$$android_os_storage_StorageVolume$getOwner() {
        return this.mOwner;
    }

    private final void $$robo$$android_os_storage_StorageVolume$setUuid(String uuid) {
        this.mUuid = uuid;
    }

    private final String $$robo$$android_os_storage_StorageVolume$getUuid() {
        return this.mUuid;
    }

    private final int $$robo$$android_os_storage_StorageVolume$getFatVolumeId() {
        if (this.mUuid == null || this.mUuid.length() != 9) {
            return -1;
        }
        try {
            return (int)Long.parseLong(this.mUuid.replace("-", ""), 16);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private final void $$robo$$android_os_storage_StorageVolume$setUserLabel(String userLabel) {
        this.mUserLabel = userLabel;
    }

    private final String $$robo$$android_os_storage_StorageVolume$getUserLabel() {
        return this.mUserLabel;
    }

    private final void $$robo$$android_os_storage_StorageVolume$setState(String state) {
        this.mState = state;
    }

    private final String $$robo$$android_os_storage_StorageVolume$getState() {
        return this.mState;
    }

    private final boolean $$robo$$android_os_storage_StorageVolume$equals(Object obj) {
        if (obj instanceof StorageVolume && this.mPath != null) {
            StorageVolume volume = (StorageVolume)obj;
            return this.mPath.equals(volume.mPath);
        }
        return false;
    }

    private final int $$robo$$android_os_storage_StorageVolume$hashCode() {
        return this.mPath.hashCode();
    }

    private final String $$robo$$android_os_storage_StorageVolume$toString() {
        CharArrayWriter writer = new CharArrayWriter();
        this.dump(new IndentingPrintWriter(writer, "    ", 80));
        return writer.toString();
    }

    private final void $$robo$$android_os_storage_StorageVolume$dump(IndentingPrintWriter pw) {
        pw.println("StorageVolume:");
        pw.increaseIndent();
        pw.printPair("mStorageId", this.mStorageId);
        pw.printPair("mPath", this.mPath);
        pw.printPair("mDescriptionId", this.mDescriptionId);
        pw.printPair("mPrimary", this.mPrimary);
        pw.printPair("mRemovable", this.mRemovable);
        pw.printPair("mEmulated", this.mEmulated);
        pw.printPair("mMtpReserveSpace", this.mMtpReserveSpace);
        pw.printPair("mAllowMassStorage", this.mAllowMassStorage);
        pw.printPair("mMaxFileSize", this.mMaxFileSize);
        pw.printPair("mOwner", this.mOwner);
        pw.printPair("mUuid", this.mUuid);
        pw.printPair("mUserLabel", this.mUserLabel);
        pw.printPair("mState", this.mState);
        pw.decreaseIndent();
    }

    private final int $$robo$$android_os_storage_StorageVolume$describeContents() {
        return 0;
    }

    private final void $$robo$$android_os_storage_StorageVolume$writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mStorageId);
        parcel.writeString(this.mPath.toString());
        parcel.writeInt(this.mDescriptionId);
        parcel.writeInt(this.mPrimary ? 1 : 0);
        parcel.writeInt(this.mRemovable ? 1 : 0);
        parcel.writeInt(this.mEmulated ? 1 : 0);
        parcel.writeInt(this.mMtpReserveSpace);
        parcel.writeInt(this.mAllowMassStorage ? 1 : 0);
        parcel.writeLong(this.mMaxFileSize);
        parcel.writeParcelable(this.mOwner, flags);
        parcel.writeString(this.mUuid);
        parcel.writeString(this.mUserLabel);
        parcel.writeString(this.mState);
    }

    private /* synthetic */ void $$robo$$android_os_storage_StorageVolume$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<StorageVolume>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_os_storage_StorageVolume_1$__constructor__() {
            }

            private final StorageVolume $$robo$$android_os_storage_StorageVolume_1$createFromParcel(Parcel in) {
                return new StorageVolume(in);
            }

            private final StorageVolume[] $$robo$$android_os_storage_StorageVolume_1$newArray(int size) {
                return new StorageVolume[size];
            }

            private void __constructor__() {
                this.$$robo$$android_os_storage_StorageVolume_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_storage_StorageVolume_1$__constructor__(), 0, this);
            }

            @Override
            public StorageVolume createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_os_storage_StorageVolume_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public StorageVolume[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_os_storage_StorageVolume_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(File file, int n, boolean bl, boolean bl2, boolean bl3, int n2, boolean bl4, long l, UserHandle userHandle) {
        this.$$robo$$android_os_storage_StorageVolume$__constructor__(file, n, bl, bl2, bl3, n2, bl4, l, userHandle);
    }

    public StorageVolume(File file, int n, boolean bl, boolean bl2, boolean bl3, int n2, boolean bl4, long l, UserHandle userHandle) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_storage_StorageVolume$__constructor__(java.io.File int boolean boolean boolean int boolean long android.os.UserHandle ), 0, this, file, n, bl, bl2, bl3, n2, bl4, l, userHandle);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_os_storage_StorageVolume$__constructor__(parcel);
    }

    private StorageVolume(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_storage_StorageVolume$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    public static StorageVolume fromTemplate(StorageVolume storageVolume, File file, UserHandle userHandle) {
        return InvokeDynamicSupport.bootstrapStatic("fromTemplate", $$robo$$android_os_storage_StorageVolume$fromTemplate(android.os.storage.StorageVolume java.io.File android.os.UserHandle ), 0, (StorageVolume)storageVolume, (File)file, (UserHandle)userHandle);
    }

    public String getPath() {
        return InvokeDynamicSupport.bootstrap("getPath", $$robo$$android_os_storage_StorageVolume$getPath(), 0, this);
    }

    public File getPathFile() {
        return InvokeDynamicSupport.bootstrap("getPathFile", $$robo$$android_os_storage_StorageVolume$getPathFile(), 0, this);
    }

    public String getDescription(Context context) {
        return InvokeDynamicSupport.bootstrap("getDescription", $$robo$$android_os_storage_StorageVolume$getDescription(android.content.Context ), 0, this, context);
    }

    public int getDescriptionId() {
        return (int)InvokeDynamicSupport.bootstrap("getDescriptionId", $$robo$$android_os_storage_StorageVolume$getDescriptionId(), 0, this);
    }

    public boolean isPrimary() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPrimary", $$robo$$android_os_storage_StorageVolume$isPrimary(), 0, this);
    }

    public boolean isRemovable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRemovable", $$robo$$android_os_storage_StorageVolume$isRemovable(), 0, this);
    }

    public boolean isEmulated() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmulated", $$robo$$android_os_storage_StorageVolume$isEmulated(), 0, this);
    }

    public int getStorageId() {
        return (int)InvokeDynamicSupport.bootstrap("getStorageId", $$robo$$android_os_storage_StorageVolume$getStorageId(), 0, this);
    }

    public void setStorageId(int n) {
        InvokeDynamicSupport.bootstrap("setStorageId", $$robo$$android_os_storage_StorageVolume$setStorageId(int ), 0, this, n);
    }

    public int getMtpReserveSpace() {
        return (int)InvokeDynamicSupport.bootstrap("getMtpReserveSpace", $$robo$$android_os_storage_StorageVolume$getMtpReserveSpace(), 0, this);
    }

    public boolean allowMassStorage() {
        return (boolean)InvokeDynamicSupport.bootstrap("allowMassStorage", $$robo$$android_os_storage_StorageVolume$allowMassStorage(), 0, this);
    }

    public long getMaxFileSize() {
        return (long)InvokeDynamicSupport.bootstrap("getMaxFileSize", $$robo$$android_os_storage_StorageVolume$getMaxFileSize(), 0, this);
    }

    public UserHandle getOwner() {
        return InvokeDynamicSupport.bootstrap("getOwner", $$robo$$android_os_storage_StorageVolume$getOwner(), 0, this);
    }

    public void setUuid(String string2) {
        InvokeDynamicSupport.bootstrap("setUuid", $$robo$$android_os_storage_StorageVolume$setUuid(java.lang.String ), 0, this, string2);
    }

    public String getUuid() {
        return InvokeDynamicSupport.bootstrap("getUuid", $$robo$$android_os_storage_StorageVolume$getUuid(), 0, this);
    }

    public int getFatVolumeId() {
        return (int)InvokeDynamicSupport.bootstrap("getFatVolumeId", $$robo$$android_os_storage_StorageVolume$getFatVolumeId(), 0, this);
    }

    public void setUserLabel(String string2) {
        InvokeDynamicSupport.bootstrap("setUserLabel", $$robo$$android_os_storage_StorageVolume$setUserLabel(java.lang.String ), 0, this, string2);
    }

    public String getUserLabel() {
        return InvokeDynamicSupport.bootstrap("getUserLabel", $$robo$$android_os_storage_StorageVolume$getUserLabel(), 0, this);
    }

    public void setState(String string2) {
        InvokeDynamicSupport.bootstrap("setState", $$robo$$android_os_storage_StorageVolume$setState(java.lang.String ), 0, this, string2);
    }

    public String getState() {
        return InvokeDynamicSupport.bootstrap("getState", $$robo$$android_os_storage_StorageVolume$getState(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_os_storage_StorageVolume$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_os_storage_StorageVolume$hashCode(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_os_storage_StorageVolume$toString(), 0, this);
    }

    public void dump(IndentingPrintWriter indentingPrintWriter) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_os_storage_StorageVolume$dump(com.android.internal.util.IndentingPrintWriter ), 0, this, indentingPrintWriter);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_os_storage_StorageVolume$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_os_storage_StorageVolume$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_os_storage_StorageVolume$__constructor__(parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(StorageVolume.class);
    }

    public /* synthetic */ StorageVolume() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StorageVolume)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

