/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.media.RingtoneManager;
import android.net.Uri;
import android.preference.Preference;
import android.preference.PreferenceFragment;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.AttributeSet;
import com.android.internal.R;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RingtonePreference
extends Preference
implements PreferenceManager.OnActivityResultListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "RingtonePreference";
    private int mRingtoneType;
    private boolean mShowDefault;
    private boolean mShowSilent;
    private int mRequestCode;

    private void $$robo$$android_preference_RingtonePreference$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RingtonePreference, defStyleAttr, defStyleRes);
        this.mRingtoneType = a.getInt(0, 1);
        this.mShowDefault = a.getBoolean(1, true);
        this.mShowSilent = a.getBoolean(2, true);
        a.recycle();
    }

    private void $$robo$$android_preference_RingtonePreference$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_preference_RingtonePreference$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_preference_RingtonePreference$__constructor__(Context context) {
    }

    private final int $$robo$$android_preference_RingtonePreference$getRingtoneType() {
        return this.mRingtoneType;
    }

    private final void $$robo$$android_preference_RingtonePreference$setRingtoneType(int type) {
        this.mRingtoneType = type;
    }

    private final boolean $$robo$$android_preference_RingtonePreference$getShowDefault() {
        return this.mShowDefault;
    }

    private final void $$robo$$android_preference_RingtonePreference$setShowDefault(boolean showDefault) {
        this.mShowDefault = showDefault;
    }

    private final boolean $$robo$$android_preference_RingtonePreference$getShowSilent() {
        return this.mShowSilent;
    }

    private final void $$robo$$android_preference_RingtonePreference$setShowSilent(boolean showSilent) {
        this.mShowSilent = showSilent;
    }

    private final void $$robo$$android_preference_RingtonePreference$onClick() {
        Intent intent = new Intent("android.intent.action.RINGTONE_PICKER");
        this.onPrepareRingtonePickerIntent(intent);
        PreferenceFragment owningFragment = this.getPreferenceManager().getFragment();
        if (owningFragment != null) {
            owningFragment.startActivityForResult(intent, this.mRequestCode);
        } else {
            this.getPreferenceManager().getActivity().startActivityForResult(intent, this.mRequestCode);
        }
    }

    private final void $$robo$$android_preference_RingtonePreference$onPrepareRingtonePickerIntent(Intent ringtonePickerIntent) {
        ringtonePickerIntent.putExtra("android.intent.extra.ringtone.EXISTING_URI", this.onRestoreRingtone());
        ringtonePickerIntent.putExtra("android.intent.extra.ringtone.SHOW_DEFAULT", this.mShowDefault);
        if (this.mShowDefault) {
            ringtonePickerIntent.putExtra("android.intent.extra.ringtone.DEFAULT_URI", RingtoneManager.getDefaultUri(this.getRingtoneType()));
        }
        ringtonePickerIntent.putExtra("android.intent.extra.ringtone.SHOW_SILENT", this.mShowSilent);
        ringtonePickerIntent.putExtra("android.intent.extra.ringtone.TYPE", this.mRingtoneType);
        ringtonePickerIntent.putExtra("android.intent.extra.ringtone.TITLE", this.getTitle());
    }

    private final void $$robo$$android_preference_RingtonePreference$onSaveRingtone(Uri ringtoneUri) {
        this.persistString(ringtoneUri != null ? ringtoneUri.toString() : "");
    }

    private final Uri $$robo$$android_preference_RingtonePreference$onRestoreRingtone() {
        String uriString = this.getPersistedString(null);
        return !TextUtils.isEmpty(uriString) ? Uri.parse(uriString) : null;
    }

    private final Object $$robo$$android_preference_RingtonePreference$onGetDefaultValue(TypedArray a, int index) {
        return a.getString(index);
    }

    private final void $$robo$$android_preference_RingtonePreference$onSetInitialValue(boolean restorePersistedValue, Object defaultValueObj) {
        String defaultValue = (String)defaultValueObj;
        if (restorePersistedValue) {
            return;
        }
        if (!TextUtils.isEmpty(defaultValue)) {
            this.onSaveRingtone(Uri.parse(defaultValue));
        }
    }

    private final void $$robo$$android_preference_RingtonePreference$onAttachedToHierarchy(PreferenceManager preferenceManager) {
        super.onAttachedToHierarchy(preferenceManager);
        preferenceManager.registerOnActivityResultListener(this);
        this.mRequestCode = preferenceManager.getNextRequestCode();
    }

    private final boolean $$robo$$android_preference_RingtonePreference$onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == this.mRequestCode) {
            Uri uri;
            if (data != null && this.callChangeListener((uri = (Uri)data.getParcelableExtra("android.intent.extra.ringtone.PICKED_URI")) != null ? uri.toString() : "")) {
                this.onSaveRingtone(uri);
            }
            return true;
        }
        return false;
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_preference_RingtonePreference$__constructor__(context, attributeSet, n, n2);
    }

    public RingtonePreference(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_preference_RingtonePreference$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_preference_RingtonePreference$__constructor__(context, attributeSet, n);
    }

    public RingtonePreference(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_preference_RingtonePreference$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_preference_RingtonePreference$__constructor__(context, attributeSet);
    }

    public RingtonePreference(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842899);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_preference_RingtonePreference$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_preference_RingtonePreference$__constructor__(context);
    }

    public RingtonePreference(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_preference_RingtonePreference$__constructor__(android.content.Context ), 0, this, context);
    }

    public int getRingtoneType() {
        return (int)InvokeDynamicSupport.bootstrap("getRingtoneType", $$robo$$android_preference_RingtonePreference$getRingtoneType(), 0, this);
    }

    public void setRingtoneType(int n) {
        InvokeDynamicSupport.bootstrap("setRingtoneType", $$robo$$android_preference_RingtonePreference$setRingtoneType(int ), 0, this, n);
    }

    public boolean getShowDefault() {
        return (boolean)InvokeDynamicSupport.bootstrap("getShowDefault", $$robo$$android_preference_RingtonePreference$getShowDefault(), 0, this);
    }

    public void setShowDefault(boolean bl) {
        InvokeDynamicSupport.bootstrap("setShowDefault", $$robo$$android_preference_RingtonePreference$setShowDefault(boolean ), 0, this, bl);
    }

    public boolean getShowSilent() {
        return (boolean)InvokeDynamicSupport.bootstrap("getShowSilent", $$robo$$android_preference_RingtonePreference$getShowSilent(), 0, this);
    }

    public void setShowSilent(boolean bl) {
        InvokeDynamicSupport.bootstrap("setShowSilent", $$robo$$android_preference_RingtonePreference$setShowSilent(boolean ), 0, this, bl);
    }

    @Override
    protected void onClick() {
        InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_preference_RingtonePreference$onClick(), 0, this);
    }

    protected void onPrepareRingtonePickerIntent(Intent intent) {
        InvokeDynamicSupport.bootstrap("onPrepareRingtonePickerIntent", $$robo$$android_preference_RingtonePreference$onPrepareRingtonePickerIntent(android.content.Intent ), 0, this, intent);
    }

    protected void onSaveRingtone(Uri uri) {
        InvokeDynamicSupport.bootstrap("onSaveRingtone", $$robo$$android_preference_RingtonePreference$onSaveRingtone(android.net.Uri ), 0, this, uri);
    }

    protected Uri onRestoreRingtone() {
        return InvokeDynamicSupport.bootstrap("onRestoreRingtone", $$robo$$android_preference_RingtonePreference$onRestoreRingtone(), 0, this);
    }

    @Override
    protected Object onGetDefaultValue(TypedArray typedArray, int n) {
        return InvokeDynamicSupport.bootstrap("onGetDefaultValue", $$robo$$android_preference_RingtonePreference$onGetDefaultValue(android.content.res.TypedArray int ), 0, this, typedArray, n);
    }

    @Override
    protected void onSetInitialValue(boolean bl, Object object) {
        InvokeDynamicSupport.bootstrap("onSetInitialValue", $$robo$$android_preference_RingtonePreference$onSetInitialValue(boolean java.lang.Object ), 0, this, bl, object);
    }

    @Override
    protected void onAttachedToHierarchy(PreferenceManager preferenceManager) {
        InvokeDynamicSupport.bootstrap("onAttachedToHierarchy", $$robo$$android_preference_RingtonePreference$onAttachedToHierarchy(android.preference.PreferenceManager ), 0, this, preferenceManager);
    }

    @Override
    public boolean onActivityResult(int n, int n2, Intent intent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onActivityResult", $$robo$$android_preference_RingtonePreference$onActivityResult(int int android.content.Intent ), 0, this, n, n2, intent);
    }

    public /* synthetic */ RingtonePreference() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RingtonePreference)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

