/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.media.AudioManager;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.preference.VolumePreference;
import android.provider.Settings;
import android.util.Log;
import android.widget.SeekBar;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SeekBarVolumizer
implements SeekBar.OnSeekBarChangeListener,
Handler.Callback,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "SeekBarVolumizer";
    private Context mContext;
    private Handler mHandler;
    private H mUiHandler;
    private Callback mCallback;
    private Uri mDefaultUri;
    private AudioManager mAudioManager;
    private int mStreamType;
    private int mMaxStreamVolume;
    private Receiver mReceiver;
    private Observer mVolumeObserver;
    private int mOriginalStreamVolume;
    private Ringtone mRingtone;
    private int mLastProgress;
    private SeekBar mSeekBar;
    private int mVolumeBeforeMute;
    private static int MSG_SET_STREAM_VOLUME = 0;
    private static int MSG_START_SAMPLE = 1;
    private static int MSG_STOP_SAMPLE = 2;
    private static int MSG_INIT_SAMPLE = 3;
    private static int CHECK_RINGTONE_PLAYBACK_DELAY_MS = 1000;

    private void $$robo$$android_preference_SeekBarVolumizer$__constructor__(Context context, int streamType, Uri defaultUri, Callback callback) {
        this.mUiHandler = new H(this);
        this.mReceiver = new Receiver(this);
        this.mLastProgress = -1;
        this.mVolumeBeforeMute = -1;
        this.mContext = context;
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
        this.mStreamType = streamType;
        this.mMaxStreamVolume = this.mAudioManager.getStreamMaxVolume(this.mStreamType);
        HandlerThread thread = new HandlerThread("SeekBarVolumizer.CallbackHandler");
        thread.start();
        this.mHandler = new Handler(thread.getLooper(), this);
        this.mCallback = callback;
        this.mOriginalStreamVolume = this.mAudioManager.getStreamVolume(this.mStreamType);
        this.mVolumeObserver = new Observer(this, this.mHandler);
        this.mContext.getContentResolver().registerContentObserver(Settings.System.getUriFor(Settings.System.VOLUME_SETTINGS[this.mStreamType]), false, this.mVolumeObserver);
        this.mReceiver.setListening(true);
        if (defaultUri == null) {
            defaultUri = this.mStreamType == 2 ? Settings.System.DEFAULT_RINGTONE_URI : (this.mStreamType == 5 ? Settings.System.DEFAULT_NOTIFICATION_URI : Settings.System.DEFAULT_ALARM_ALERT_URI);
        }
        this.mDefaultUri = defaultUri;
        this.mHandler.sendEmptyMessage(3);
    }

    private final void $$robo$$android_preference_SeekBarVolumizer$setSeekBar(SeekBar seekBar) {
        if (this.mSeekBar != null) {
            this.mSeekBar.setOnSeekBarChangeListener(null);
        }
        this.mSeekBar = seekBar;
        this.mSeekBar.setOnSeekBarChangeListener(null);
        this.mSeekBar.setMax(this.mMaxStreamVolume);
        this.mSeekBar.setProgress(this.mLastProgress > -1 ? this.mLastProgress : this.mOriginalStreamVolume);
        this.mSeekBar.setOnSeekBarChangeListener(this);
    }

    private final boolean $$robo$$android_preference_SeekBarVolumizer$handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                this.mAudioManager.setStreamVolume(this.mStreamType, this.mLastProgress, 1024);
                break;
            }
            case 1: {
                this.onStartSample();
                break;
            }
            case 2: {
                this.onStopSample();
                break;
            }
            case 3: {
                this.onInitSample();
                break;
            }
            default: {
                Log.e("SeekBarVolumizer", "invalid SeekBarVolumizer message: " + msg.what);
            }
        }
        return true;
    }

    private final void $$robo$$android_preference_SeekBarVolumizer$onInitSample() {
        this.mRingtone = RingtoneManager.getRingtone(this.mContext, this.mDefaultUri);
        if (this.mRingtone != null) {
            this.mRingtone.setStreamType(this.mStreamType);
        }
    }

    private final void $$robo$$android_preference_SeekBarVolumizer$postStartSample() {
        this.mHandler.removeMessages(1);
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(1), this.isSamplePlaying() ? 1000L : 0L);
    }

    private final void $$robo$$android_preference_SeekBarVolumizer$onStartSample() {
        if (!this.isSamplePlaying()) {
            if (this.mCallback != null) {
                this.mCallback.onSampleStarting(this);
            }
            if (this.mRingtone != null) {
                try {
                    this.mRingtone.play();
                }
                catch (Throwable e) {
                    Log.w("SeekBarVolumizer", "Error playing ringtone, stream " + this.mStreamType, e);
                }
            }
        }
    }

    private final void $$robo$$android_preference_SeekBarVolumizer$postStopSample() {
        this.mHandler.removeMessages(1);
        this.mHandler.removeMessages(2);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2));
    }

    private final void $$robo$$android_preference_SeekBarVolumizer$onStopSample() {
        if (this.mRingtone != null) {
            this.mRingtone.stop();
        }
    }

    private final void $$robo$$android_preference_SeekBarVolumizer$stop() {
        this.postStopSample();
        this.mContext.getContentResolver().unregisterContentObserver(this.mVolumeObserver);
        this.mSeekBar.setOnSeekBarChangeListener(null);
        this.mReceiver.setListening(false);
        this.mHandler.getLooper().quitSafely();
    }

    private final void $$robo$$android_preference_SeekBarVolumizer$revertVolume() {
        this.mAudioManager.setStreamVolume(this.mStreamType, this.mOriginalStreamVolume, 0);
    }

    private final void $$robo$$android_preference_SeekBarVolumizer$onProgressChanged(SeekBar seekBar, int progress, boolean fromTouch) {
        if (!fromTouch) {
            return;
        }
        this.postSetVolume(progress);
    }

    private final void $$robo$$android_preference_SeekBarVolumizer$postSetVolume(int progress) {
        this.mLastProgress = progress;
        this.mHandler.removeMessages(0);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(0));
    }

    private final void $$robo$$android_preference_SeekBarVolumizer$onStartTrackingTouch(SeekBar seekBar) {
    }

    private final void $$robo$$android_preference_SeekBarVolumizer$onStopTrackingTouch(SeekBar seekBar) {
        this.postStartSample();
    }

    private final boolean $$robo$$android_preference_SeekBarVolumizer$isSamplePlaying() {
        return this.mRingtone != null && this.mRingtone.isPlaying();
    }

    private final void $$robo$$android_preference_SeekBarVolumizer$startSample() {
        this.postStartSample();
    }

    private final void $$robo$$android_preference_SeekBarVolumizer$stopSample() {
        this.postStopSample();
    }

    private final SeekBar $$robo$$android_preference_SeekBarVolumizer$getSeekBar() {
        return this.mSeekBar;
    }

    private final void $$robo$$android_preference_SeekBarVolumizer$changeVolumeBy(int amount) {
        this.mSeekBar.incrementProgressBy(amount);
        this.postSetVolume(this.mSeekBar.getProgress());
        this.postStartSample();
        this.mVolumeBeforeMute = -1;
    }

    private final void $$robo$$android_preference_SeekBarVolumizer$muteVolume() {
        if (this.mVolumeBeforeMute != -1) {
            this.mSeekBar.setProgress(this.mVolumeBeforeMute);
            this.postSetVolume(this.mVolumeBeforeMute);
            this.postStartSample();
            this.mVolumeBeforeMute = -1;
        } else {
            this.mVolumeBeforeMute = this.mSeekBar.getProgress();
            this.mSeekBar.setProgress(0);
            this.postStopSample();
            this.postSetVolume(0);
        }
    }

    private final void $$robo$$android_preference_SeekBarVolumizer$onSaveInstanceState(VolumePreference.VolumeStore volumeStore) {
        if (this.mLastProgress >= 0) {
            volumeStore.volume = this.mLastProgress;
            volumeStore.originalVolume = this.mOriginalStreamVolume;
        }
    }

    private final void $$robo$$android_preference_SeekBarVolumizer$onRestoreInstanceState(VolumePreference.VolumeStore volumeStore) {
        if (volumeStore.volume != -1) {
            this.mOriginalStreamVolume = volumeStore.originalVolume;
            this.mLastProgress = volumeStore.volume;
            this.postSetVolume(this.mLastProgress);
        }
    }

    private void __constructor__(Context context, int n, Uri uri, Callback callback) {
        this.$$robo$$android_preference_SeekBarVolumizer$__constructor__(context, n, uri, callback);
    }

    public SeekBarVolumizer(Context context, int n, Uri uri, Callback callback) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_preference_SeekBarVolumizer$__constructor__(android.content.Context int android.net.Uri android.preference.SeekBarVolumizer$Callback ), 0, this, context, n, uri, callback);
    }

    public void setSeekBar(SeekBar seekBar) {
        InvokeDynamicSupport.bootstrap("setSeekBar", $$robo$$android_preference_SeekBarVolumizer$setSeekBar(android.widget.SeekBar ), 0, this, seekBar);
    }

    @Override
    public boolean handleMessage(Message message) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_preference_SeekBarVolumizer$handleMessage(android.os.Message ), 0, this, message);
    }

    private void onInitSample() {
        InvokeDynamicSupport.bootstrap("onInitSample", $$robo$$android_preference_SeekBarVolumizer$onInitSample(), 0, this);
    }

    private void postStartSample() {
        InvokeDynamicSupport.bootstrap("postStartSample", $$robo$$android_preference_SeekBarVolumizer$postStartSample(), 0, this);
    }

    private void onStartSample() {
        InvokeDynamicSupport.bootstrap("onStartSample", $$robo$$android_preference_SeekBarVolumizer$onStartSample(), 0, this);
    }

    void postStopSample() {
        InvokeDynamicSupport.bootstrap("postStopSample", $$robo$$android_preference_SeekBarVolumizer$postStopSample(), 0, this);
    }

    private void onStopSample() {
        InvokeDynamicSupport.bootstrap("onStopSample", $$robo$$android_preference_SeekBarVolumizer$onStopSample(), 0, this);
    }

    public void stop() {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_preference_SeekBarVolumizer$stop(), 0, this);
    }

    public void revertVolume() {
        InvokeDynamicSupport.bootstrap("revertVolume", $$robo$$android_preference_SeekBarVolumizer$revertVolume(), 0, this);
    }

    @Override
    public void onProgressChanged(SeekBar seekBar, int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("onProgressChanged", $$robo$$android_preference_SeekBarVolumizer$onProgressChanged(android.widget.SeekBar int boolean ), 0, this, seekBar, n, bl);
    }

    void postSetVolume(int n) {
        InvokeDynamicSupport.bootstrap("postSetVolume", $$robo$$android_preference_SeekBarVolumizer$postSetVolume(int ), 0, this, n);
    }

    @Override
    public void onStartTrackingTouch(SeekBar seekBar) {
        InvokeDynamicSupport.bootstrap("onStartTrackingTouch", $$robo$$android_preference_SeekBarVolumizer$onStartTrackingTouch(android.widget.SeekBar ), 0, this, seekBar);
    }

    @Override
    public void onStopTrackingTouch(SeekBar seekBar) {
        InvokeDynamicSupport.bootstrap("onStopTrackingTouch", $$robo$$android_preference_SeekBarVolumizer$onStopTrackingTouch(android.widget.SeekBar ), 0, this, seekBar);
    }

    public boolean isSamplePlaying() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSamplePlaying", $$robo$$android_preference_SeekBarVolumizer$isSamplePlaying(), 0, this);
    }

    public void startSample() {
        InvokeDynamicSupport.bootstrap("startSample", $$robo$$android_preference_SeekBarVolumizer$startSample(), 0, this);
    }

    public void stopSample() {
        InvokeDynamicSupport.bootstrap("stopSample", $$robo$$android_preference_SeekBarVolumizer$stopSample(), 0, this);
    }

    public SeekBar getSeekBar() {
        return InvokeDynamicSupport.bootstrap("getSeekBar", $$robo$$android_preference_SeekBarVolumizer$getSeekBar(), 0, this);
    }

    public void changeVolumeBy(int n) {
        InvokeDynamicSupport.bootstrap("changeVolumeBy", $$robo$$android_preference_SeekBarVolumizer$changeVolumeBy(int ), 0, this, n);
    }

    public void muteVolume() {
        InvokeDynamicSupport.bootstrap("muteVolume", $$robo$$android_preference_SeekBarVolumizer$muteVolume(), 0, this);
    }

    public void onSaveInstanceState(VolumePreference.VolumeStore volumeStore) {
        InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$android_preference_SeekBarVolumizer$onSaveInstanceState(android.preference.VolumePreference$VolumeStore ), 0, this, volumeStore);
    }

    public void onRestoreInstanceState(VolumePreference.VolumeStore volumeStore) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$android_preference_SeekBarVolumizer$onRestoreInstanceState(android.preference.VolumePreference$VolumeStore ), 0, this, volumeStore);
    }

    public /* synthetic */ SeekBarVolumizer() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SeekBarVolumizer)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class Receiver
    extends BroadcastReceiver
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private boolean mListening;
        /* synthetic */ SeekBarVolumizer this$0;

        private void $$robo$$android_preference_SeekBarVolumizer_Receiver$__constructor__(SeekBarVolumizer seekBarVolumizer) {
        }

        private final void $$robo$$android_preference_SeekBarVolumizer_Receiver$setListening(boolean listening) {
            if (this.mListening == listening) {
                return;
            }
            this.mListening = listening;
            if (listening) {
                IntentFilter filter = new IntentFilter("android.media.VOLUME_CHANGED_ACTION");
                this.this$0.mContext.registerReceiver(this, filter);
            } else {
                this.this$0.mContext.unregisterReceiver(this);
            }
        }

        private final void $$robo$$android_preference_SeekBarVolumizer_Receiver$onReceive(Context context, Intent intent) {
            if (!"android.media.VOLUME_CHANGED_ACTION".equals(intent.getAction())) {
                return;
            }
            int streamType = intent.getIntExtra("android.media.EXTRA_VOLUME_STREAM_TYPE", -1);
            int streamValue = intent.getIntExtra("android.media.EXTRA_VOLUME_STREAM_VALUE", -1);
            if (this.this$0.mSeekBar != null && streamType == this.this$0.mStreamType && streamValue != -1) {
                this.this$0.mUiHandler.postUpdateSlider(streamValue);
            }
        }

        private /* synthetic */ void $$robo$$android_preference_SeekBarVolumizer_Receiver$__constructor__(SeekBarVolumizer x0, 1 x1) {
        }

        private void __constructor__(SeekBarVolumizer seekBarVolumizer) {
            this.$$robo$$android_preference_SeekBarVolumizer_Receiver$__constructor__(seekBarVolumizer);
        }

        private Receiver(SeekBarVolumizer seekBarVolumizer) {
            this.this$0 = seekBarVolumizer;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_preference_SeekBarVolumizer_Receiver$__constructor__(android.preference.SeekBarVolumizer ), 0, this, seekBarVolumizer);
        }

        public void setListening(boolean bl) {
            InvokeDynamicSupport.bootstrap("setListening", $$robo$$android_preference_SeekBarVolumizer_Receiver$setListening(boolean ), 0, this, bl);
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            InvokeDynamicSupport.bootstrap("onReceive", $$robo$$android_preference_SeekBarVolumizer_Receiver$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
        }

        private /* synthetic */ void __constructor__(SeekBarVolumizer seekBarVolumizer, 1 var2_2) {
            this.$$robo$$android_preference_SeekBarVolumizer_Receiver$__constructor__(seekBarVolumizer, var2_2);
        }

        public /* synthetic */ Receiver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Receiver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class Observer
    extends ContentObserver
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ SeekBarVolumizer this$0;

        private void $$robo$$android_preference_SeekBarVolumizer_Observer$__constructor__(SeekBarVolumizer seekBarVolumizer, Handler handler) {
        }

        private final void $$robo$$android_preference_SeekBarVolumizer_Observer$onChange(boolean selfChange) {
            super.onChange(selfChange);
            if (this.this$0.mSeekBar != null && this.this$0.mAudioManager != null) {
                int volume = this.this$0.mAudioManager.getStreamVolume(this.this$0.mStreamType);
                this.this$0.mUiHandler.postUpdateSlider(volume);
            }
        }

        private void __constructor__(SeekBarVolumizer seekBarVolumizer, Handler handler) {
            this.$$robo$$android_preference_SeekBarVolumizer_Observer$__constructor__(seekBarVolumizer, handler);
        }

        public Observer(SeekBarVolumizer seekBarVolumizer, Handler handler) {
            this.this$0 = seekBarVolumizer;
            super(handler);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_preference_SeekBarVolumizer_Observer$__constructor__(android.preference.SeekBarVolumizer android.os.Handler ), 0, this, seekBarVolumizer, handler);
        }

        @Override
        public void onChange(boolean bl) {
            InvokeDynamicSupport.bootstrap("onChange", $$robo$$android_preference_SeekBarVolumizer_Observer$onChange(boolean ), 0, this, bl);
        }

        public /* synthetic */ Observer() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Observer)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class H
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int UPDATE_SLIDER = 1;
        /* synthetic */ SeekBarVolumizer this$0;

        private void $$robo$$android_preference_SeekBarVolumizer_H$__constructor__(SeekBarVolumizer seekBarVolumizer) {
        }

        private final void $$robo$$android_preference_SeekBarVolumizer_H$handleMessage(Message msg) {
            if (msg.what == 1 && this.this$0.mSeekBar != null) {
                this.this$0.mSeekBar.setProgress(msg.arg1);
                this.this$0.mLastProgress = this.this$0.mSeekBar.getProgress();
            }
        }

        private final void $$robo$$android_preference_SeekBarVolumizer_H$postUpdateSlider(int volume) {
            this.obtainMessage(1, volume, 0).sendToTarget();
        }

        private /* synthetic */ void $$robo$$android_preference_SeekBarVolumizer_H$__constructor__(SeekBarVolumizer x0, 1 x1) {
        }

        private void __constructor__(SeekBarVolumizer seekBarVolumizer) {
            this.$$robo$$android_preference_SeekBarVolumizer_H$__constructor__(seekBarVolumizer);
        }

        private H(SeekBarVolumizer seekBarVolumizer) {
            this.this$0 = seekBarVolumizer;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_preference_SeekBarVolumizer_H$__constructor__(android.preference.SeekBarVolumizer ), 0, this, seekBarVolumizer);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_preference_SeekBarVolumizer_H$handleMessage(android.os.Message ), 0, this, message);
        }

        public void postUpdateSlider(int n) {
            InvokeDynamicSupport.bootstrap("postUpdateSlider", $$robo$$android_preference_SeekBarVolumizer_H$postUpdateSlider(int ), 0, this, n);
        }

        private /* synthetic */ void __constructor__(SeekBarVolumizer seekBarVolumizer, 1 var2_2) {
            this.$$robo$$android_preference_SeekBarVolumizer_H$__constructor__(seekBarVolumizer, var2_2);
        }

        public /* synthetic */ H() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (H)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface Callback
    extends InstrumentedInterface {
        public void onSampleStarting(SeekBarVolumizer var1);
    }
}

