/*
 * Decompiled with CFR 0.152.
 */
package android.print;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.print.PageRange;
import android.print.PrintAttributes;
import android.print.PrintDocumentInfo;
import android.print.PrintJobId;
import android.print.PrinterId;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class PrintJobInfo
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int STATE_ANY = -1;
    public static int STATE_ANY_VISIBLE_TO_CLIENTS = -2;
    public static int STATE_ANY_ACTIVE = -3;
    public static int STATE_ANY_SCHEDULED = -4;
    public static int STATE_CREATED = 1;
    public static int STATE_QUEUED = 2;
    public static int STATE_STARTED = 3;
    public static int STATE_BLOCKED = 4;
    public static int STATE_COMPLETED = 5;
    public static int STATE_FAILED = 6;
    public static int STATE_CANCELED = 7;
    private PrintJobId mId;
    private String mLabel;
    private PrinterId mPrinterId;
    private String mPrinterName;
    private int mState;
    private int mAppId;
    private String mTag;
    private long mCreationTime;
    private int mCopies;
    private String mStateReason;
    private PageRange[] mPageRanges;
    private PrintAttributes mAttributes;
    private PrintDocumentInfo mDocumentInfo;
    private Bundle mAdvancedOptions;
    private boolean mCanceling;
    public static Parcelable.Creator<PrintJobInfo> CREATOR;

    private void $$robo$$android_print_PrintJobInfo$__constructor__() {
    }

    private void $$robo$$android_print_PrintJobInfo$__constructor__(PrintJobInfo other) {
        this.mId = other.mId;
        this.mLabel = other.mLabel;
        this.mPrinterId = other.mPrinterId;
        this.mPrinterName = other.mPrinterName;
        this.mState = other.mState;
        this.mAppId = other.mAppId;
        this.mTag = other.mTag;
        this.mCreationTime = other.mCreationTime;
        this.mCopies = other.mCopies;
        this.mStateReason = other.mStateReason;
        this.mPageRanges = other.mPageRanges;
        this.mAttributes = other.mAttributes;
        this.mDocumentInfo = other.mDocumentInfo;
        this.mCanceling = other.mCanceling;
        this.mAdvancedOptions = other.mAdvancedOptions;
    }

    private void $$robo$$android_print_PrintJobInfo$__constructor__(Parcel parcel) {
        this.mId = (PrintJobId)parcel.readParcelable(null);
        this.mLabel = parcel.readString();
        this.mPrinterId = (PrinterId)parcel.readParcelable(null);
        this.mPrinterName = parcel.readString();
        this.mState = parcel.readInt();
        this.mAppId = parcel.readInt();
        this.mTag = parcel.readString();
        this.mCreationTime = parcel.readLong();
        this.mCopies = parcel.readInt();
        this.mStateReason = parcel.readString();
        Parcelable[] parcelables = parcel.readParcelableArray(null);
        if (parcelables != null) {
            this.mPageRanges = new PageRange[parcelables.length];
            for (int i = 0; i < parcelables.length; ++i) {
                this.mPageRanges[i] = (PageRange)parcelables[i];
            }
        }
        this.mAttributes = (PrintAttributes)parcel.readParcelable(null);
        this.mDocumentInfo = (PrintDocumentInfo)parcel.readParcelable(null);
        this.mCanceling = parcel.readInt() == 1;
        this.mAdvancedOptions = parcel.readBundle();
    }

    private final PrintJobId $$robo$$android_print_PrintJobInfo$getId() {
        return this.mId;
    }

    private final void $$robo$$android_print_PrintJobInfo$setId(PrintJobId id2) {
        this.mId = id2;
    }

    private final String $$robo$$android_print_PrintJobInfo$getLabel() {
        return this.mLabel;
    }

    private final void $$robo$$android_print_PrintJobInfo$setLabel(String label) {
        this.mLabel = label;
    }

    private final PrinterId $$robo$$android_print_PrintJobInfo$getPrinterId() {
        return this.mPrinterId;
    }

    private final void $$robo$$android_print_PrintJobInfo$setPrinterId(PrinterId printerId) {
        this.mPrinterId = printerId;
    }

    private final String $$robo$$android_print_PrintJobInfo$getPrinterName() {
        return this.mPrinterName;
    }

    private final void $$robo$$android_print_PrintJobInfo$setPrinterName(String printerName) {
        this.mPrinterName = printerName;
    }

    private final int $$robo$$android_print_PrintJobInfo$getState() {
        return this.mState;
    }

    private final void $$robo$$android_print_PrintJobInfo$setState(int state) {
        this.mState = state;
    }

    private final int $$robo$$android_print_PrintJobInfo$getAppId() {
        return this.mAppId;
    }

    private final void $$robo$$android_print_PrintJobInfo$setAppId(int appId) {
        this.mAppId = appId;
    }

    private final String $$robo$$android_print_PrintJobInfo$getTag() {
        return this.mTag;
    }

    private final void $$robo$$android_print_PrintJobInfo$setTag(String tag) {
        this.mTag = tag;
    }

    private final long $$robo$$android_print_PrintJobInfo$getCreationTime() {
        return this.mCreationTime;
    }

    private final void $$robo$$android_print_PrintJobInfo$setCreationTime(long creationTime) {
        if (creationTime < 0L) {
            throw new IllegalArgumentException("creationTime must be non-negative.");
        }
        this.mCreationTime = creationTime;
    }

    private final int $$robo$$android_print_PrintJobInfo$getCopies() {
        return this.mCopies;
    }

    private final void $$robo$$android_print_PrintJobInfo$setCopies(int copyCount) {
        if (copyCount < 1) {
            throw new IllegalArgumentException("Copies must be more than one.");
        }
        this.mCopies = copyCount;
    }

    private final String $$robo$$android_print_PrintJobInfo$getStateReason() {
        return this.mStateReason;
    }

    private final void $$robo$$android_print_PrintJobInfo$setStateReason(String stateReason) {
        this.mStateReason = stateReason;
    }

    private final PageRange[] $$robo$$android_print_PrintJobInfo$getPages() {
        return this.mPageRanges;
    }

    private final void $$robo$$android_print_PrintJobInfo$setPages(PageRange[] pageRanges) {
        this.mPageRanges = pageRanges;
    }

    private final PrintAttributes $$robo$$android_print_PrintJobInfo$getAttributes() {
        return this.mAttributes;
    }

    private final void $$robo$$android_print_PrintJobInfo$setAttributes(PrintAttributes attributes) {
        this.mAttributes = attributes;
    }

    private final PrintDocumentInfo $$robo$$android_print_PrintJobInfo$getDocumentInfo() {
        return this.mDocumentInfo;
    }

    private final void $$robo$$android_print_PrintJobInfo$setDocumentInfo(PrintDocumentInfo info) {
        this.mDocumentInfo = info;
    }

    private final boolean $$robo$$android_print_PrintJobInfo$isCancelling() {
        return this.mCanceling;
    }

    private final void $$robo$$android_print_PrintJobInfo$setCancelling(boolean cancelling) {
        this.mCanceling = cancelling;
    }

    private final boolean $$robo$$android_print_PrintJobInfo$hasAdvancedOption(String key) {
        return this.mAdvancedOptions != null && this.mAdvancedOptions.containsKey(key);
    }

    private final String $$robo$$android_print_PrintJobInfo$getAdvancedStringOption(String key) {
        if (this.mAdvancedOptions != null) {
            return this.mAdvancedOptions.getString(key);
        }
        return null;
    }

    private final int $$robo$$android_print_PrintJobInfo$getAdvancedIntOption(String key) {
        if (this.mAdvancedOptions != null) {
            return this.mAdvancedOptions.getInt(key);
        }
        return 0;
    }

    private final Bundle $$robo$$android_print_PrintJobInfo$getAdvancedOptions() {
        return this.mAdvancedOptions;
    }

    private final void $$robo$$android_print_PrintJobInfo$setAdvancedOptions(Bundle options) {
        this.mAdvancedOptions = options;
    }

    private final int $$robo$$android_print_PrintJobInfo$describeContents() {
        return 0;
    }

    private final void $$robo$$android_print_PrintJobInfo$writeToParcel(Parcel parcel, int flags) {
        parcel.writeParcelable(this.mId, flags);
        parcel.writeString(this.mLabel);
        parcel.writeParcelable(this.mPrinterId, flags);
        parcel.writeString(this.mPrinterName);
        parcel.writeInt(this.mState);
        parcel.writeInt(this.mAppId);
        parcel.writeString(this.mTag);
        parcel.writeLong(this.mCreationTime);
        parcel.writeInt(this.mCopies);
        parcel.writeString(this.mStateReason);
        parcel.writeParcelableArray(this.mPageRanges, flags);
        parcel.writeParcelable(this.mAttributes, flags);
        parcel.writeParcelable(this.mDocumentInfo, 0);
        parcel.writeInt(this.mCanceling ? 1 : 0);
        parcel.writeBundle(this.mAdvancedOptions);
    }

    private final String $$robo$$android_print_PrintJobInfo$toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PrintJobInfo{");
        builder.append("label: ").append(this.mLabel);
        builder.append(", id: ").append(this.mId);
        builder.append(", state: ").append(PrintJobInfo.stateToString(this.mState));
        builder.append(", printer: " + this.mPrinterId);
        builder.append(", tag: ").append(this.mTag);
        builder.append(", creationTime: " + this.mCreationTime);
        builder.append(", copies: ").append(this.mCopies);
        builder.append(", attributes: " + (this.mAttributes != null ? this.mAttributes.toString() : null));
        builder.append(", documentInfo: " + (this.mDocumentInfo != null ? this.mDocumentInfo.toString() : null));
        builder.append(", cancelling: " + this.mCanceling);
        builder.append(", pages: " + (this.mPageRanges != null ? Arrays.toString(this.mPageRanges) : null));
        builder.append(", hasAdvancedOptions: " + (this.mAdvancedOptions != null));
        builder.append("}");
        return builder.toString();
    }

    private static final String $$robo$$android_print_PrintJobInfo$stateToString(int state) {
        switch (state) {
            case 1: {
                return "STATE_CREATED";
            }
            case 2: {
                return "STATE_QUEUED";
            }
            case 3: {
                return "STATE_STARTED";
            }
            case 4: {
                return "STATE_BLOCKED";
            }
            case 6: {
                return "STATE_FAILED";
            }
            case 5: {
                return "STATE_COMPLETED";
            }
            case 7: {
                return "STATE_CANCELED";
            }
        }
        return "STATE_UNKNOWN";
    }

    static /* synthetic */ PageRange[] access$202(PrintJobInfo x0, PageRange[] x1) {
        x0.mPageRanges = x1;
        return x1;
    }

    private /* synthetic */ void $$robo$$android_print_PrintJobInfo$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<PrintJobInfo>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_print_PrintJobInfo_1$__constructor__() {
            }

            private final PrintJobInfo $$robo$$android_print_PrintJobInfo_1$createFromParcel(Parcel parcel) {
                return new PrintJobInfo(parcel);
            }

            private final PrintJobInfo[] $$robo$$android_print_PrintJobInfo_1$newArray(int size) {
                return new PrintJobInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_print_PrintJobInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_print_PrintJobInfo_1$__constructor__(), 0, this);
            }

            @Override
            public PrintJobInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_print_PrintJobInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public PrintJobInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_print_PrintJobInfo_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_print_PrintJobInfo$__constructor__();
    }

    public PrintJobInfo() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_print_PrintJobInfo$__constructor__(), 0, this);
    }

    private void __constructor__(PrintJobInfo printJobInfo) {
        this.$$robo$$android_print_PrintJobInfo$__constructor__(printJobInfo);
    }

    public PrintJobInfo(PrintJobInfo printJobInfo) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_print_PrintJobInfo$__constructor__(android.print.PrintJobInfo ), 0, this, printJobInfo);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_print_PrintJobInfo$__constructor__(parcel);
    }

    private PrintJobInfo(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_print_PrintJobInfo$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    public PrintJobId getId() {
        return InvokeDynamicSupport.bootstrap("getId", $$robo$$android_print_PrintJobInfo$getId(), 0, this);
    }

    public void setId(PrintJobId printJobId) {
        InvokeDynamicSupport.bootstrap("setId", $$robo$$android_print_PrintJobInfo$setId(android.print.PrintJobId ), 0, this, printJobId);
    }

    public String getLabel() {
        return InvokeDynamicSupport.bootstrap("getLabel", $$robo$$android_print_PrintJobInfo$getLabel(), 0, this);
    }

    public void setLabel(String string2) {
        InvokeDynamicSupport.bootstrap("setLabel", $$robo$$android_print_PrintJobInfo$setLabel(java.lang.String ), 0, this, string2);
    }

    public PrinterId getPrinterId() {
        return InvokeDynamicSupport.bootstrap("getPrinterId", $$robo$$android_print_PrintJobInfo$getPrinterId(), 0, this);
    }

    public void setPrinterId(PrinterId printerId) {
        InvokeDynamicSupport.bootstrap("setPrinterId", $$robo$$android_print_PrintJobInfo$setPrinterId(android.print.PrinterId ), 0, this, printerId);
    }

    public String getPrinterName() {
        return InvokeDynamicSupport.bootstrap("getPrinterName", $$robo$$android_print_PrintJobInfo$getPrinterName(), 0, this);
    }

    public void setPrinterName(String string2) {
        InvokeDynamicSupport.bootstrap("setPrinterName", $$robo$$android_print_PrintJobInfo$setPrinterName(java.lang.String ), 0, this, string2);
    }

    public int getState() {
        return (int)InvokeDynamicSupport.bootstrap("getState", $$robo$$android_print_PrintJobInfo$getState(), 0, this);
    }

    public void setState(int n) {
        InvokeDynamicSupport.bootstrap("setState", $$robo$$android_print_PrintJobInfo$setState(int ), 0, this, n);
    }

    public int getAppId() {
        return (int)InvokeDynamicSupport.bootstrap("getAppId", $$robo$$android_print_PrintJobInfo$getAppId(), 0, this);
    }

    public void setAppId(int n) {
        InvokeDynamicSupport.bootstrap("setAppId", $$robo$$android_print_PrintJobInfo$setAppId(int ), 0, this, n);
    }

    public String getTag() {
        return InvokeDynamicSupport.bootstrap("getTag", $$robo$$android_print_PrintJobInfo$getTag(), 0, this);
    }

    public void setTag(String string2) {
        InvokeDynamicSupport.bootstrap("setTag", $$robo$$android_print_PrintJobInfo$setTag(java.lang.String ), 0, this, string2);
    }

    public long getCreationTime() {
        return (long)InvokeDynamicSupport.bootstrap("getCreationTime", $$robo$$android_print_PrintJobInfo$getCreationTime(), 0, this);
    }

    public void setCreationTime(long l) {
        InvokeDynamicSupport.bootstrap("setCreationTime", $$robo$$android_print_PrintJobInfo$setCreationTime(long ), 0, this, l);
    }

    public int getCopies() {
        return (int)InvokeDynamicSupport.bootstrap("getCopies", $$robo$$android_print_PrintJobInfo$getCopies(), 0, this);
    }

    public void setCopies(int n) {
        InvokeDynamicSupport.bootstrap("setCopies", $$robo$$android_print_PrintJobInfo$setCopies(int ), 0, this, n);
    }

    public String getStateReason() {
        return InvokeDynamicSupport.bootstrap("getStateReason", $$robo$$android_print_PrintJobInfo$getStateReason(), 0, this);
    }

    public void setStateReason(String string2) {
        InvokeDynamicSupport.bootstrap("setStateReason", $$robo$$android_print_PrintJobInfo$setStateReason(java.lang.String ), 0, this, string2);
    }

    public PageRange[] getPages() {
        return InvokeDynamicSupport.bootstrap("getPages", $$robo$$android_print_PrintJobInfo$getPages(), 0, this);
    }

    public void setPages(PageRange[] pageRangeArray) {
        InvokeDynamicSupport.bootstrap("setPages", $$robo$$android_print_PrintJobInfo$setPages(android.print.PageRange[] ), 0, this, pageRangeArray);
    }

    public PrintAttributes getAttributes() {
        return InvokeDynamicSupport.bootstrap("getAttributes", $$robo$$android_print_PrintJobInfo$getAttributes(), 0, this);
    }

    public void setAttributes(PrintAttributes printAttributes) {
        InvokeDynamicSupport.bootstrap("setAttributes", $$robo$$android_print_PrintJobInfo$setAttributes(android.print.PrintAttributes ), 0, this, printAttributes);
    }

    public PrintDocumentInfo getDocumentInfo() {
        return InvokeDynamicSupport.bootstrap("getDocumentInfo", $$robo$$android_print_PrintJobInfo$getDocumentInfo(), 0, this);
    }

    public void setDocumentInfo(PrintDocumentInfo printDocumentInfo) {
        InvokeDynamicSupport.bootstrap("setDocumentInfo", $$robo$$android_print_PrintJobInfo$setDocumentInfo(android.print.PrintDocumentInfo ), 0, this, printDocumentInfo);
    }

    public boolean isCancelling() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCancelling", $$robo$$android_print_PrintJobInfo$isCancelling(), 0, this);
    }

    public void setCancelling(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCancelling", $$robo$$android_print_PrintJobInfo$setCancelling(boolean ), 0, this, bl);
    }

    public boolean hasAdvancedOption(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasAdvancedOption", $$robo$$android_print_PrintJobInfo$hasAdvancedOption(java.lang.String ), 0, this, string2);
    }

    public String getAdvancedStringOption(String string2) {
        return InvokeDynamicSupport.bootstrap("getAdvancedStringOption", $$robo$$android_print_PrintJobInfo$getAdvancedStringOption(java.lang.String ), 0, this, string2);
    }

    public int getAdvancedIntOption(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getAdvancedIntOption", $$robo$$android_print_PrintJobInfo$getAdvancedIntOption(java.lang.String ), 0, this, string2);
    }

    public Bundle getAdvancedOptions() {
        return InvokeDynamicSupport.bootstrap("getAdvancedOptions", $$robo$$android_print_PrintJobInfo$getAdvancedOptions(), 0, this);
    }

    public void setAdvancedOptions(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("setAdvancedOptions", $$robo$$android_print_PrintJobInfo$setAdvancedOptions(android.os.Bundle ), 0, this, bundle);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_print_PrintJobInfo$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_print_PrintJobInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_print_PrintJobInfo$toString(), 0, this);
    }

    public static String stateToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("stateToString", $$robo$$android_print_PrintJobInfo$stateToString(int ), 0, (int)n);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_print_PrintJobInfo$__constructor__(parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(PrintJobInfo.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PrintJobInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private PrintJobInfo mPrototype;

        private void $$robo$$android_print_PrintJobInfo_Builder$__constructor__(PrintJobInfo prototype) {
            this.mPrototype = prototype != null ? new PrintJobInfo(prototype) : new PrintJobInfo();
        }

        private final void $$robo$$android_print_PrintJobInfo_Builder$setCopies(int copies) {
            this.mPrototype.mCopies = copies;
        }

        private final void $$robo$$android_print_PrintJobInfo_Builder$setAttributes(PrintAttributes attributes) {
            this.mPrototype.mAttributes = attributes;
        }

        private final void $$robo$$android_print_PrintJobInfo_Builder$setPages(PageRange[] pages) {
            PrintJobInfo.access$202(this.mPrototype, pages);
        }

        private final void $$robo$$android_print_PrintJobInfo_Builder$putAdvancedOption(String key, String value) {
            if (this.mPrototype.mAdvancedOptions == null) {
                this.mPrototype.mAdvancedOptions = new Bundle();
            }
            this.mPrototype.mAdvancedOptions.putString(key, value);
        }

        private final void $$robo$$android_print_PrintJobInfo_Builder$putAdvancedOption(String key, int value) {
            if (this.mPrototype.mAdvancedOptions == null) {
                this.mPrototype.mAdvancedOptions = new Bundle();
            }
            this.mPrototype.mAdvancedOptions.putInt(key, value);
        }

        private final PrintJobInfo $$robo$$android_print_PrintJobInfo_Builder$build() {
            return this.mPrototype;
        }

        private void __constructor__(PrintJobInfo printJobInfo) {
            this.$$robo$$android_print_PrintJobInfo_Builder$__constructor__(printJobInfo);
        }

        public Builder(PrintJobInfo printJobInfo) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_print_PrintJobInfo_Builder$__constructor__(android.print.PrintJobInfo ), 0, this, printJobInfo);
        }

        public void setCopies(int n) {
            InvokeDynamicSupport.bootstrap("setCopies", $$robo$$android_print_PrintJobInfo_Builder$setCopies(int ), 0, this, n);
        }

        public void setAttributes(PrintAttributes printAttributes) {
            InvokeDynamicSupport.bootstrap("setAttributes", $$robo$$android_print_PrintJobInfo_Builder$setAttributes(android.print.PrintAttributes ), 0, this, printAttributes);
        }

        public void setPages(PageRange[] pageRangeArray) {
            InvokeDynamicSupport.bootstrap("setPages", $$robo$$android_print_PrintJobInfo_Builder$setPages(android.print.PageRange[] ), 0, this, pageRangeArray);
        }

        public void putAdvancedOption(String string2, String string3) {
            InvokeDynamicSupport.bootstrap("putAdvancedOption", $$robo$$android_print_PrintJobInfo_Builder$putAdvancedOption(java.lang.String java.lang.String ), 0, this, string2, string3);
        }

        public void putAdvancedOption(String string2, int n) {
            InvokeDynamicSupport.bootstrap("putAdvancedOption", $$robo$$android_print_PrintJobInfo_Builder$putAdvancedOption(java.lang.String int ), 0, this, string2, n);
        }

        public PrintJobInfo build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_print_PrintJobInfo_Builder$build(), 0, this);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

