/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.content.ActivityNotFoundException;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.net.Uri;
import android.provider.BaseColumns;
import android.provider.BrowserContract;
import android.util.Log;
import android.webkit.WebIconDatabase;
import java.lang.invoke.CallSite;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Browser
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOGTAG = "browser";
    public static Uri BOOKMARKS_URI;
    public static String INITIAL_ZOOM_LEVEL = "browser.initialZoomLevel";
    public static String EXTRA_APPLICATION_ID = "com.android.browser.application_id";
    public static String EXTRA_HEADERS = "com.android.browser.headers";
    public static String[] HISTORY_PROJECTION;
    public static int HISTORY_PROJECTION_ID_INDEX = 0;
    public static int HISTORY_PROJECTION_URL_INDEX = 1;
    public static int HISTORY_PROJECTION_VISITS_INDEX = 2;
    public static int HISTORY_PROJECTION_DATE_INDEX = 3;
    public static int HISTORY_PROJECTION_BOOKMARK_INDEX = 4;
    public static int HISTORY_PROJECTION_TITLE_INDEX = 5;
    public static int HISTORY_PROJECTION_FAVICON_INDEX = 6;
    public static int HISTORY_PROJECTION_THUMBNAIL_INDEX = 7;
    public static int HISTORY_PROJECTION_TOUCH_ICON_INDEX = 8;
    public static String[] TRUNCATE_HISTORY_PROJECTION;
    public static int TRUNCATE_HISTORY_PROJECTION_ID_INDEX = 0;
    public static int TRUNCATE_N_OLDEST = 5;
    public static Uri SEARCHES_URI;
    public static String[] SEARCHES_PROJECTION;
    public static int SEARCHES_PROJECTION_SEARCH_INDEX = 1;
    public static int SEARCHES_PROJECTION_DATE_INDEX = 2;
    private static int MAX_HISTORY_COUNT = 250;
    public static String EXTRA_CREATE_NEW_TAB = "create_new_tab";
    public static String EXTRA_SHARE_SCREENSHOT = "share_screenshot";
    public static String EXTRA_SHARE_FAVICON = "share_favicon";

    private void $$robo$$android_provider_Browser$__constructor__() {
    }

    private static final void $$robo$$android_provider_Browser$saveBookmark(Context c, String title, String url) {
        Intent i = new Intent("android.intent.action.INSERT", BOOKMARKS_URI);
        i.putExtra("title", title);
        i.putExtra("url", url);
        c.startActivity(i);
    }

    private static final void $$robo$$android_provider_Browser$sendString(Context context, String string2) {
        Browser.sendString(context, string2, context.getString(17040529));
    }

    private static final void $$robo$$android_provider_Browser$sendString(Context c, String stringToSend, String chooserDialogTitle) {
        Intent send = new Intent("android.intent.action.SEND");
        send.setType("text/plain");
        send.putExtra("android.intent.extra.TEXT", stringToSend);
        try {
            Intent i = Intent.createChooser(send, chooserDialogTitle);
            i.setFlags(0x10000000);
            c.startActivity(i);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            // empty catch block
        }
    }

    private static final Cursor $$robo$$android_provider_Browser$getAllBookmarks(ContentResolver cr) throws IllegalStateException {
        return cr.query(BrowserContract.Bookmarks.CONTENT_URI, new String[]{"url"}, "folder = 0", null, null);
    }

    private static final Cursor $$robo$$android_provider_Browser$getAllVisitedUrls(ContentResolver cr) throws IllegalStateException {
        return cr.query(BrowserContract.Combined.CONTENT_URI, new String[]{"url"}, null, null, "created ASC");
    }

    private static final void $$robo$$android_provider_Browser$addOrUrlEquals(StringBuilder sb) {
        sb.append(" OR url = ");
    }

    private static final Cursor $$robo$$android_provider_Browser$getVisitedLike(ContentResolver cr, String url) {
        boolean secure = false;
        String compareString = url;
        if (compareString.startsWith("http://")) {
            compareString = compareString.substring(7);
        } else if (compareString.startsWith("https://")) {
            compareString = compareString.substring(8);
            secure = true;
        }
        if (compareString.startsWith("www.")) {
            compareString = compareString.substring(4);
        }
        StringBuilder whereClause = null;
        if (secure) {
            whereClause = new StringBuilder("url = ");
            DatabaseUtils.appendEscapedSQLString(whereClause, "https://" + compareString);
            Browser.addOrUrlEquals(whereClause);
            DatabaseUtils.appendEscapedSQLString(whereClause, "https://www." + compareString);
        } else {
            whereClause = new StringBuilder("url = ");
            DatabaseUtils.appendEscapedSQLString(whereClause, compareString);
            Browser.addOrUrlEquals(whereClause);
            String wwwString = "www." + compareString;
            DatabaseUtils.appendEscapedSQLString(whereClause, wwwString);
            Browser.addOrUrlEquals(whereClause);
            DatabaseUtils.appendEscapedSQLString(whereClause, "http://" + compareString);
            Browser.addOrUrlEquals(whereClause);
            DatabaseUtils.appendEscapedSQLString(whereClause, "http://" + wwwString);
        }
        return cr.query(BrowserContract.History.CONTENT_URI, new String[]{"_id", "visits"}, whereClause.toString(), null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_provider_Browser$updateVisitedHistory(ContentResolver cr, String url, boolean real) {
        CallSite now = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        try (Cursor c = null;){
            c = Browser.getVisitedLike(cr, url);
            if (c.moveToFirst()) {
                ContentValues values = new ContentValues();
                if (real) {
                    values.put("visits", c.getInt(1) + 1);
                } else {
                    values.put("user_entered", 1);
                }
                values.put("date", (long)now);
                cr.update(ContentUris.withAppendedId(BrowserContract.History.CONTENT_URI, c.getLong(0)), values, null, null);
            } else {
                int user_entered;
                int visits;
                Browser.truncateHistory(cr);
                ContentValues values = new ContentValues();
                if (real) {
                    visits = 1;
                    user_entered = 0;
                } else {
                    visits = 0;
                    user_entered = 1;
                }
                values.put("url", url);
                values.put("visits", visits);
                values.put("date", (long)now);
                values.put("title", url);
                values.put("created", 0);
                values.put("user_entered", user_entered);
                cr.insert(BrowserContract.History.CONTENT_URI, values);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String[] $$robo$$android_provider_Browser$getVisitedHistory(ContentResolver cr) {
        String[] str = null;
        try (Cursor c = null;){
            String[] projection = new String[]{"url"};
            c = cr.query(BrowserContract.History.CONTENT_URI, projection, "visits > 0", null, null);
            if (c == null) {
                String[] stringArray = new String[]{};
                return stringArray;
            }
            str = new String[c.getCount()];
            int i = 0;
            while (c.moveToNext()) {
                str[i] = c.getString(0);
                ++i;
            }
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_provider_Browser$truncateHistory(ContentResolver cr) {
        block7: {
            try (Cursor cursor = null;){
                cursor = cr.query(BrowserContract.History.CONTENT_URI, new String[]{"_id", "url", "date"}, null, null, "date ASC");
                if (!cursor.moveToFirst() || cursor.getCount() < 250) break block7;
                for (int i = 0; i < 5; ++i) {
                    cr.delete(ContentUris.withAppendedId(BrowserContract.History.CONTENT_URI, cursor.getLong(0)), null, null);
                    if (cursor.moveToNext()) continue;
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean $$robo$$android_provider_Browser$canClearHistory(ContentResolver cr) {
        boolean ret = false;
        try (Cursor cursor = null;){
            cursor = cr.query(BrowserContract.History.CONTENT_URI, new String[]{"_id", "visits"}, null, null, null);
            ret = cursor.getCount() > 0;
        }
        return ret;
    }

    private static final void $$robo$$android_provider_Browser$clearHistory(ContentResolver cr) {
        Browser.deleteHistoryWhere(cr, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_provider_Browser$deleteHistoryWhere(ContentResolver cr, String whereClause) {
        try (Cursor cursor = null;){
            cursor = cr.query(BrowserContract.History.CONTENT_URI, new String[]{"url"}, whereClause, null, null);
            if (cursor.moveToFirst()) {
                cr.delete(BrowserContract.History.CONTENT_URI, whereClause, null);
            }
        }
    }

    private static final void $$robo$$android_provider_Browser$deleteHistoryTimeFrame(ContentResolver cr, long begin, long end) {
        String whereClause;
        String date = "date";
        if (-1L == begin) {
            if (-1L == end) {
                Browser.clearHistory(cr);
                return;
            }
            whereClause = date + " < " + Long.toString(end);
        } else {
            whereClause = -1L == end ? date + " >= " + Long.toString(begin) : date + " >= " + Long.toString(begin) + " AND " + date + " < " + Long.toString(end);
        }
        Browser.deleteHistoryWhere(cr, whereClause);
    }

    private static final void $$robo$$android_provider_Browser$deleteFromHistory(ContentResolver cr, String url) {
        cr.delete(BrowserContract.History.CONTENT_URI, "url=?", new String[]{url});
    }

    private static final void $$robo$$android_provider_Browser$addSearchUrl(ContentResolver cr, String search) {
        ContentValues values = new ContentValues();
        values.put("search", search);
        values.put("date", (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"));
        cr.insert(BrowserContract.Searches.CONTENT_URI, values);
    }

    private static final void $$robo$$android_provider_Browser$clearSearches(ContentResolver cr) {
        try {
            cr.delete(BrowserContract.Searches.CONTENT_URI, null, null);
        }
        catch (IllegalStateException e) {
            Log.e("browser", "clearSearches", e);
        }
    }

    private static final void $$robo$$android_provider_Browser$requestAllIcons(ContentResolver cr, String where, WebIconDatabase.IconListener listener) {
    }

    static void __staticInitializer__() {
        BOOKMARKS_URI = Uri.parse("content://browser/bookmarks");
        HISTORY_PROJECTION = new String[]{"_id", "url", "visits", "date", "bookmark", "title", "favicon", "thumbnail", "touch_icon", "user_entered"};
        TRUNCATE_HISTORY_PROJECTION = new String[]{"_id", "date"};
        SEARCHES_URI = Uri.parse("content://browser/searches");
        SEARCHES_PROJECTION = new String[]{"_id", "search", "date"};
    }

    private void __constructor__() {
        this.$$robo$$android_provider_Browser$__constructor__();
    }

    public Browser() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_Browser$__constructor__(), 0, this);
    }

    public static void saveBookmark(Context context, String string2, String string3) {
        InvokeDynamicSupport.bootstrapStatic("saveBookmark", $$robo$$android_provider_Browser$saveBookmark(android.content.Context java.lang.String java.lang.String ), 0, (Context)context, (String)string2, (String)string3);
    }

    public static void sendString(Context context, String string2) {
        InvokeDynamicSupport.bootstrapStatic("sendString", $$robo$$android_provider_Browser$sendString(android.content.Context java.lang.String ), 0, (Context)context, (String)string2);
    }

    public static void sendString(Context context, String string2, String string3) {
        InvokeDynamicSupport.bootstrapStatic("sendString", $$robo$$android_provider_Browser$sendString(android.content.Context java.lang.String java.lang.String ), 0, (Context)context, (String)string2, (String)string3);
    }

    public static Cursor getAllBookmarks(ContentResolver contentResolver) throws IllegalStateException {
        return InvokeDynamicSupport.bootstrapStatic("getAllBookmarks", $$robo$$android_provider_Browser$getAllBookmarks(android.content.ContentResolver ), 0, (ContentResolver)contentResolver);
    }

    public static Cursor getAllVisitedUrls(ContentResolver contentResolver) throws IllegalStateException {
        return InvokeDynamicSupport.bootstrapStatic("getAllVisitedUrls", $$robo$$android_provider_Browser$getAllVisitedUrls(android.content.ContentResolver ), 0, (ContentResolver)contentResolver);
    }

    private static void addOrUrlEquals(StringBuilder stringBuilder) {
        InvokeDynamicSupport.bootstrapStatic("addOrUrlEquals", $$robo$$android_provider_Browser$addOrUrlEquals(java.lang.StringBuilder ), 0, (StringBuilder)stringBuilder);
    }

    private static Cursor getVisitedLike(ContentResolver contentResolver, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getVisitedLike", $$robo$$android_provider_Browser$getVisitedLike(android.content.ContentResolver java.lang.String ), 0, (ContentResolver)contentResolver, (String)string2);
    }

    public static void updateVisitedHistory(ContentResolver contentResolver, String string2, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("updateVisitedHistory", $$robo$$android_provider_Browser$updateVisitedHistory(android.content.ContentResolver java.lang.String boolean ), 0, (ContentResolver)contentResolver, (String)string2, (boolean)bl);
    }

    public static String[] getVisitedHistory(ContentResolver contentResolver) {
        return InvokeDynamicSupport.bootstrapStatic("getVisitedHistory", $$robo$$android_provider_Browser$getVisitedHistory(android.content.ContentResolver ), 0, (ContentResolver)contentResolver);
    }

    public static void truncateHistory(ContentResolver contentResolver) {
        InvokeDynamicSupport.bootstrapStatic("truncateHistory", $$robo$$android_provider_Browser$truncateHistory(android.content.ContentResolver ), 0, (ContentResolver)contentResolver);
    }

    public static boolean canClearHistory(ContentResolver contentResolver) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("canClearHistory", $$robo$$android_provider_Browser$canClearHistory(android.content.ContentResolver ), 0, (ContentResolver)contentResolver);
    }

    public static void clearHistory(ContentResolver contentResolver) {
        InvokeDynamicSupport.bootstrapStatic("clearHistory", $$robo$$android_provider_Browser$clearHistory(android.content.ContentResolver ), 0, (ContentResolver)contentResolver);
    }

    private static void deleteHistoryWhere(ContentResolver contentResolver, String string2) {
        InvokeDynamicSupport.bootstrapStatic("deleteHistoryWhere", $$robo$$android_provider_Browser$deleteHistoryWhere(android.content.ContentResolver java.lang.String ), 0, (ContentResolver)contentResolver, (String)string2);
    }

    public static void deleteHistoryTimeFrame(ContentResolver contentResolver, long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("deleteHistoryTimeFrame", $$robo$$android_provider_Browser$deleteHistoryTimeFrame(android.content.ContentResolver long long ), 0, (ContentResolver)contentResolver, (long)l, (long)l2);
    }

    public static void deleteFromHistory(ContentResolver contentResolver, String string2) {
        InvokeDynamicSupport.bootstrapStatic("deleteFromHistory", $$robo$$android_provider_Browser$deleteFromHistory(android.content.ContentResolver java.lang.String ), 0, (ContentResolver)contentResolver, (String)string2);
    }

    public static void addSearchUrl(ContentResolver contentResolver, String string2) {
        InvokeDynamicSupport.bootstrapStatic("addSearchUrl", $$robo$$android_provider_Browser$addSearchUrl(android.content.ContentResolver java.lang.String ), 0, (ContentResolver)contentResolver, (String)string2);
    }

    public static void clearSearches(ContentResolver contentResolver) {
        InvokeDynamicSupport.bootstrapStatic("clearSearches", $$robo$$android_provider_Browser$clearSearches(android.content.ContentResolver ), 0, (ContentResolver)contentResolver);
    }

    public static void requestAllIcons(ContentResolver contentResolver, String string2, WebIconDatabase.IconListener iconListener) {
        InvokeDynamicSupport.bootstrapStatic("requestAllIcons", $$robo$$android_provider_Browser$requestAllIcons(android.content.ContentResolver java.lang.String android.webkit.WebIconDatabase$IconListener ), 0, (ContentResolver)contentResolver, (String)string2, (WebIconDatabase.IconListener)iconListener);
    }

    static {
        RobolectricInternals.classInitializing(Browser.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Browser)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class SearchColumns
    implements BaseColumns,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        @Deprecated
        public static String URL = "url";
        public static String SEARCH = "search";
        public static String DATE = "date";

        private void $$robo$$android_provider_Browser_SearchColumns$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_provider_Browser_SearchColumns$__constructor__();
        }

        public SearchColumns() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_Browser_SearchColumns$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SearchColumns)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class BookmarkColumns
    implements BaseColumns,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static String URL = "url";
        public static String VISITS = "visits";
        public static String DATE = "date";
        public static String BOOKMARK = "bookmark";
        public static String TITLE = "title";
        public static String CREATED = "created";
        public static String FAVICON = "favicon";
        public static String THUMBNAIL = "thumbnail";
        public static String TOUCH_ICON = "touch_icon";
        public static String USER_ENTERED = "user_entered";

        private void $$robo$$android_provider_Browser_BookmarkColumns$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_provider_Browser_BookmarkColumns$__constructor__();
        }

        public BookmarkColumns() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_Browser_BookmarkColumns$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BookmarkColumns)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

