/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.content.ContentProvider;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.pm.UserInfo;
import android.database.Cursor;
import android.location.Country;
import android.location.CountryDetector;
import android.net.Uri;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.BaseColumns;
import android.provider.ContactsContract;
import android.telecom.PhoneAccountHandle;
import android.telephony.PhoneNumberUtils;
import android.text.TextUtils;
import com.android.internal.telephony.CallerInfo;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CallLog
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String AUTHORITY = "call_log";
    public static Uri CONTENT_URI;

    private void $$robo$$android_provider_CallLog$__constructor__() {
    }

    static void __staticInitializer__() {
        CONTENT_URI = Uri.parse("content://call_log");
    }

    private void __constructor__() {
        this.$$robo$$android_provider_CallLog$__constructor__();
    }

    public CallLog() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_CallLog$__constructor__(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(CallLog.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CallLog)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Calls
    implements BaseColumns,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static Uri CONTENT_URI;
        public static Uri CONTENT_FILTER_URI;
        public static String LIMIT_PARAM_KEY = "limit";
        public static String OFFSET_PARAM_KEY = "offset";
        public static String ALLOW_VOICEMAILS_PARAM_KEY = "allow_voicemails";
        public static String EXTRA_CALL_TYPE_FILTER = "android.provider.extra.CALL_TYPE_FILTER";
        public static Uri CONTENT_URI_WITH_VOICEMAIL;
        public static String DEFAULT_SORT_ORDER = "date DESC";
        public static String CONTENT_TYPE = "vnd.android.cursor.dir/calls";
        public static String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/calls";
        public static String TYPE = "type";
        public static int INCOMING_TYPE = 1;
        public static int OUTGOING_TYPE = 2;
        public static int MISSED_TYPE = 3;
        public static int VOICEMAIL_TYPE = 4;
        public static String FEATURES = "features";
        public static int FEATURES_VIDEO = 1;
        public static String NUMBER = "number";
        public static String NUMBER_PRESENTATION = "presentation";
        public static int PRESENTATION_ALLOWED = 1;
        public static int PRESENTATION_RESTRICTED = 2;
        public static int PRESENTATION_UNKNOWN = 3;
        public static int PRESENTATION_PAYPHONE = 4;
        public static String COUNTRY_ISO = "countryiso";
        public static String DATE = "date";
        public static String DURATION = "duration";
        public static String DATA_USAGE = "data_usage";
        public static String NEW = "new";
        public static String CACHED_NAME = "name";
        public static String CACHED_NUMBER_TYPE = "numbertype";
        public static String CACHED_NUMBER_LABEL = "numberlabel";
        public static String VOICEMAIL_URI = "voicemail_uri";
        public static String TRANSCRIPTION = "transcription";
        public static String IS_READ = "is_read";
        public static String GEOCODED_LOCATION = "geocoded_location";
        public static String CACHED_LOOKUP_URI = "lookup_uri";
        public static String CACHED_MATCHED_NUMBER = "matched_number";
        public static String CACHED_NORMALIZED_NUMBER = "normalized_number";
        public static String CACHED_PHOTO_ID = "photo_id";
        public static String CACHED_FORMATTED_NUMBER = "formatted_number";
        public static String PHONE_ACCOUNT_COMPONENT_NAME = "subscription_component_name";
        public static String PHONE_ACCOUNT_ID = "subscription_id";
        public static String SUB_ID = "sub_id";
        private static int MIN_DURATION_FOR_NORMALIZED_NUMBER_UPDATE_MS = 10000;

        private void $$robo$$android_provider_CallLog_Calls$__constructor__() {
        }

        private static final Uri $$robo$$android_provider_CallLog_Calls$addCall(CallerInfo ci, Context context, String number, int presentation, int callType, int features, PhoneAccountHandle accountHandle, long start, int duration, Long dataUsage) {
            return Calls.addCall(ci, context, number, presentation, callType, features, accountHandle, start, duration, dataUsage, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final Uri $$robo$$android_provider_CallLog_Calls$addCall(CallerInfo ci, Context context, String number, int presentation, int callType, int features, PhoneAccountHandle accountHandle, long start, int duration, Long dataUsage, boolean addForAllUsers) {
            ContentResolver resolver = context.getContentResolver();
            int numberPresentation = 1;
            if (presentation == 2) {
                numberPresentation = 2;
            } else if (presentation == 4) {
                numberPresentation = 4;
            } else if (TextUtils.isEmpty(number) || presentation == 3) {
                numberPresentation = 3;
            }
            if (numberPresentation != 1) {
                number = "";
                if (ci != null) {
                    ci.name = "";
                }
            }
            String accountComponentString = null;
            String accountId = null;
            if (accountHandle != null) {
                accountComponentString = accountHandle.getComponentName().flattenToString();
                accountId = accountHandle.getId();
            }
            ContentValues values = new ContentValues(6);
            values.put("number", number);
            values.put("presentation", numberPresentation);
            values.put("type", callType);
            values.put("features", features);
            values.put("date", start);
            values.put("duration", Long.valueOf(duration));
            if (dataUsage != null) {
                values.put("data_usage", dataUsage);
            }
            values.put("subscription_component_name", accountComponentString);
            values.put("subscription_id", accountId);
            values.put("new", 1);
            if (callType == 3) {
                values.put("is_read", 0);
            }
            if (ci != null) {
                values.put("name", ci.name);
                values.put("numbertype", ci.numberType);
                values.put("numberlabel", ci.numberLabel);
            }
            if (ci != null && ci.contactIdOrZero > 0L) {
                Cursor cursor;
                if (ci.normalizedNumber != null) {
                    String normalizedPhoneNumber = ci.normalizedNumber;
                    cursor = resolver.query(ContactsContract.CommonDataKinds.Phone.CONTENT_URI, new String[]{"_id"}, "contact_id =? AND data4 =?", new String[]{String.valueOf(ci.contactIdOrZero), normalizedPhoneNumber}, null);
                } else {
                    String phoneNumber = ci.phoneNumber != null ? ci.phoneNumber : number;
                    cursor = resolver.query(Uri.withAppendedPath(ContactsContract.CommonDataKinds.Callable.CONTENT_FILTER_URI, Uri.encode(phoneNumber)), new String[]{"_id"}, "contact_id =?", new String[]{String.valueOf(ci.contactIdOrZero)}, null);
                }
                if (cursor != null) {
                    try {
                        if (cursor.getCount() > 0 && cursor.moveToFirst()) {
                            String dataId = cursor.getString(0);
                            Calls.updateDataUsageStatForData(resolver, dataId);
                            if (duration >= 10000 && callType == 2 && TextUtils.isEmpty(ci.normalizedNumber)) {
                                Calls.updateNormalizedNumber(context, resolver, dataId, number);
                            }
                        }
                    }
                    finally {
                        cursor.close();
                    }
                }
            }
            Uri result = null;
            if (addForAllUsers) {
                UserManager userManager = (UserManager)context.getSystemService("user");
                List<UserInfo> users = userManager.getUsers(true);
                int currentUserId = userManager.getUserHandle();
                int count = users.size();
                for (int i = 0; i < count; ++i) {
                    UserInfo user = users.get(i);
                    UserHandle userHandle = user.getUserHandle();
                    if (!userManager.isUserRunning(userHandle) || userManager.hasUserRestriction("no_outgoing_calls", userHandle) || user.isManagedProfile()) continue;
                    Uri uri = Calls.addEntryAndRemoveExpiredEntries(context, ContentProvider.maybeAddUserId(CONTENT_URI, user.id), values);
                    if (user.id != currentUserId) continue;
                    result = uri;
                }
            } else {
                result = Calls.addEntryAndRemoveExpiredEntries(context, CONTENT_URI, values);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final String $$robo$$android_provider_CallLog_Calls$getLastOutgoingCall(Context context) {
            ContentResolver resolver = context.getContentResolver();
            try (Cursor c = null;){
                c = resolver.query(CONTENT_URI, new String[]{"number"}, "type = 2", null, "date DESC LIMIT 1");
                if (c == null || !c.moveToFirst()) {
                    String string2 = "";
                    return string2;
                }
                String string3 = c.getString(0);
                return string3;
            }
        }

        private static final Uri $$robo$$android_provider_CallLog_Calls$addEntryAndRemoveExpiredEntries(Context context, Uri uri, ContentValues values) {
            ContentResolver resolver = context.getContentResolver();
            Uri result = resolver.insert(uri, values);
            resolver.delete(uri, "_id IN (SELECT _id FROM calls ORDER BY date DESC LIMIT -1 OFFSET 500)", null);
            return result;
        }

        private static final void $$robo$$android_provider_CallLog_Calls$updateDataUsageStatForData(ContentResolver resolver, String dataId) {
            Uri feedbackUri = ContactsContract.DataUsageFeedback.FEEDBACK_URI.buildUpon().appendPath(dataId).appendQueryParameter("type", "call").build();
            resolver.update(feedbackUri, new ContentValues(), null, null);
        }

        private static final void $$robo$$android_provider_CallLog_Calls$updateNormalizedNumber(Context context, ContentResolver resolver, String dataId, String number) {
            if (TextUtils.isEmpty(number) || TextUtils.isEmpty(dataId)) {
                return;
            }
            String countryIso = Calls.getCurrentCountryIso(context);
            if (TextUtils.isEmpty(countryIso)) {
                return;
            }
            String normalizedNumber = PhoneNumberUtils.formatNumberToE164(number, Calls.getCurrentCountryIso(context));
            if (TextUtils.isEmpty(normalizedNumber)) {
                return;
            }
            ContentValues values = new ContentValues();
            values.put("data4", normalizedNumber);
            resolver.update(ContactsContract.Data.CONTENT_URI, values, "_id=?", new String[]{dataId});
        }

        private static final String $$robo$$android_provider_CallLog_Calls$getCurrentCountryIso(Context context) {
            Country country;
            String countryIso = null;
            CountryDetector detector = (CountryDetector)context.getSystemService("country_detector");
            if (detector != null && (country = detector.detectCountry()) != null) {
                countryIso = country.getCountryIso();
            }
            return countryIso;
        }

        static void __staticInitializer__() {
            CONTENT_URI = Uri.parse("content://call_log/calls");
            CONTENT_FILTER_URI = Uri.parse("content://call_log/calls/filter");
            CONTENT_URI_WITH_VOICEMAIL = CONTENT_URI.buildUpon().appendQueryParameter("allow_voicemails", "true").build();
        }

        private void __constructor__() {
            this.$$robo$$android_provider_CallLog_Calls$__constructor__();
        }

        public Calls() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_CallLog_Calls$__constructor__(), 0, this);
        }

        public static Uri addCall(CallerInfo callerInfo, Context context, String string2, int n, int n2, int n3, PhoneAccountHandle phoneAccountHandle, long l, int n4, Long l2) {
            return InvokeDynamicSupport.bootstrapStatic("addCall", $$robo$$android_provider_CallLog_Calls$addCall(com.android.internal.telephony.CallerInfo android.content.Context java.lang.String int int int android.telecom.PhoneAccountHandle long int java.lang.Long ), 0, (CallerInfo)callerInfo, (Context)context, (String)string2, (int)n, (int)n2, (int)n3, (PhoneAccountHandle)phoneAccountHandle, (long)l, (int)n4, (Long)l2);
        }

        public static Uri addCall(CallerInfo callerInfo, Context context, String string2, int n, int n2, int n3, PhoneAccountHandle phoneAccountHandle, long l, int n4, Long l2, boolean bl) {
            return InvokeDynamicSupport.bootstrapStatic("addCall", $$robo$$android_provider_CallLog_Calls$addCall(com.android.internal.telephony.CallerInfo android.content.Context java.lang.String int int int android.telecom.PhoneAccountHandle long int java.lang.Long boolean ), 0, (CallerInfo)callerInfo, (Context)context, (String)string2, (int)n, (int)n2, (int)n3, (PhoneAccountHandle)phoneAccountHandle, (long)l, (int)n4, (Long)l2, (boolean)bl);
        }

        public static String getLastOutgoingCall(Context context) {
            return InvokeDynamicSupport.bootstrapStatic("getLastOutgoingCall", $$robo$$android_provider_CallLog_Calls$getLastOutgoingCall(android.content.Context ), 0, (Context)context);
        }

        private static Uri addEntryAndRemoveExpiredEntries(Context context, Uri uri, ContentValues contentValues) {
            return InvokeDynamicSupport.bootstrapStatic("addEntryAndRemoveExpiredEntries", $$robo$$android_provider_CallLog_Calls$addEntryAndRemoveExpiredEntries(android.content.Context android.net.Uri android.content.ContentValues ), 0, (Context)context, (Uri)uri, (ContentValues)contentValues);
        }

        private static void updateDataUsageStatForData(ContentResolver contentResolver, String string2) {
            InvokeDynamicSupport.bootstrapStatic("updateDataUsageStatForData", $$robo$$android_provider_CallLog_Calls$updateDataUsageStatForData(android.content.ContentResolver java.lang.String ), 0, (ContentResolver)contentResolver, (String)string2);
        }

        private static void updateNormalizedNumber(Context context, ContentResolver contentResolver, String string2, String string3) {
            InvokeDynamicSupport.bootstrapStatic("updateNormalizedNumber", $$robo$$android_provider_CallLog_Calls$updateNormalizedNumber(android.content.Context android.content.ContentResolver java.lang.String java.lang.String ), 0, (Context)context, (ContentResolver)contentResolver, (String)string2, (String)string3);
        }

        private static String getCurrentCountryIso(Context context) {
            return InvokeDynamicSupport.bootstrapStatic("getCurrentCountryIso", $$robo$$android_provider_CallLog_Calls$getCurrentCountryIso(android.content.Context ), 0, (Context)context);
        }

        static {
            RobolectricInternals.classInitializing(Calls.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Calls)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

