/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Point;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.OperationCanceledException;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class DocumentsContract
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "Documents";
    public static String PROVIDER_INTERFACE = "android.content.action.DOCUMENTS_PROVIDER";
    public static String EXTRA_PACKAGE_NAME = "android.content.extra.PACKAGE_NAME";
    public static String EXTRA_SHOW_ADVANCED = "android.content.extra.SHOW_ADVANCED";
    public static String EXTRA_ORIENTATION = "android.content.extra.ORIENTATION";
    public static String ACTION_MANAGE_ROOT = "android.provider.action.MANAGE_ROOT";
    public static String ACTION_MANAGE_DOCUMENT = "android.provider.action.MANAGE_DOCUMENT";
    private static int THUMBNAIL_BUFFER_SIZE = 131072;
    public static String EXTRA_LOADING = "loading";
    public static String EXTRA_INFO = "info";
    public static String EXTRA_ERROR = "error";
    public static String METHOD_CREATE_DOCUMENT = "android:createDocument";
    public static String METHOD_RENAME_DOCUMENT = "android:renameDocument";
    public static String METHOD_DELETE_DOCUMENT = "android:deleteDocument";
    public static String EXTRA_URI = "uri";
    private static String PATH_ROOT = "root";
    private static String PATH_RECENT = "recent";
    private static String PATH_DOCUMENT = "document";
    private static String PATH_CHILDREN = "children";
    private static String PATH_SEARCH = "search";
    private static String PATH_TREE = "tree";
    private static String PARAM_QUERY = "query";
    private static String PARAM_MANAGE = "manage";

    private void $$robo$$android_provider_DocumentsContract$__constructor__() {
    }

    private static final Uri $$robo$$android_provider_DocumentsContract$buildRootsUri(String authority) {
        return new Uri.Builder().scheme("content").authority(authority).appendPath("root").build();
    }

    private static final Uri $$robo$$android_provider_DocumentsContract$buildRootUri(String authority, String rootId) {
        return new Uri.Builder().scheme("content").authority(authority).appendPath("root").appendPath(rootId).build();
    }

    private static final Uri $$robo$$android_provider_DocumentsContract$buildRecentDocumentsUri(String authority, String rootId) {
        return new Uri.Builder().scheme("content").authority(authority).appendPath("root").appendPath(rootId).appendPath("recent").build();
    }

    private static final Uri $$robo$$android_provider_DocumentsContract$buildTreeDocumentUri(String authority, String documentId) {
        return new Uri.Builder().scheme("content").authority(authority).appendPath("tree").appendPath(documentId).build();
    }

    private static final Uri $$robo$$android_provider_DocumentsContract$buildDocumentUri(String authority, String documentId) {
        return new Uri.Builder().scheme("content").authority(authority).appendPath("document").appendPath(documentId).build();
    }

    private static final Uri $$robo$$android_provider_DocumentsContract$buildDocumentUriUsingTree(Uri treeUri, String documentId) {
        return new Uri.Builder().scheme("content").authority(treeUri.getAuthority()).appendPath("tree").appendPath(DocumentsContract.getTreeDocumentId(treeUri)).appendPath("document").appendPath(documentId).build();
    }

    private static final Uri $$robo$$android_provider_DocumentsContract$buildDocumentUriMaybeUsingTree(Uri baseUri, String documentId) {
        if (DocumentsContract.isTreeUri(baseUri)) {
            return DocumentsContract.buildDocumentUriUsingTree(baseUri, documentId);
        }
        return DocumentsContract.buildDocumentUri(baseUri.getAuthority(), documentId);
    }

    private static final Uri $$robo$$android_provider_DocumentsContract$buildChildDocumentsUri(String authority, String parentDocumentId) {
        return new Uri.Builder().scheme("content").authority(authority).appendPath("document").appendPath(parentDocumentId).appendPath("children").build();
    }

    private static final Uri $$robo$$android_provider_DocumentsContract$buildChildDocumentsUriUsingTree(Uri treeUri, String parentDocumentId) {
        return new Uri.Builder().scheme("content").authority(treeUri.getAuthority()).appendPath("tree").appendPath(DocumentsContract.getTreeDocumentId(treeUri)).appendPath("document").appendPath(parentDocumentId).appendPath("children").build();
    }

    private static final Uri $$robo$$android_provider_DocumentsContract$buildSearchDocumentsUri(String authority, String rootId, String query) {
        return new Uri.Builder().scheme("content").authority(authority).appendPath("root").appendPath(rootId).appendPath("search").appendQueryParameter("query", query).build();
    }

    private static final boolean $$robo$$android_provider_DocumentsContract$isDocumentUri(Context context, Uri uri) {
        List<String> paths = uri.getPathSegments();
        if (paths.size() == 2 && "document".equals(paths.get(0))) {
            return DocumentsContract.isDocumentsProvider(context, uri.getAuthority());
        }
        if (paths.size() == 4 && "tree".equals(paths.get(0)) && "document".equals(paths.get(2))) {
            return DocumentsContract.isDocumentsProvider(context, uri.getAuthority());
        }
        return false;
    }

    private static final boolean $$robo$$android_provider_DocumentsContract$isTreeUri(Uri uri) {
        List<String> paths = uri.getPathSegments();
        return paths.size() >= 2 && "tree".equals(paths.get(0));
    }

    private static final boolean $$robo$$android_provider_DocumentsContract$isDocumentsProvider(Context context, String authority) {
        Intent intent = new Intent("android.content.action.DOCUMENTS_PROVIDER");
        List<ResolveInfo> infos = context.getPackageManager().queryIntentContentProviders(intent, 0);
        for (ResolveInfo info : infos) {
            if (!authority.equals(info.providerInfo.authority)) continue;
            return true;
        }
        return false;
    }

    private static final String $$robo$$android_provider_DocumentsContract$getRootId(Uri rootUri) {
        List<String> paths = rootUri.getPathSegments();
        if (paths.size() >= 2 && "root".equals(paths.get(0))) {
            return paths.get(1);
        }
        throw new IllegalArgumentException("Invalid URI: " + rootUri);
    }

    private static final String $$robo$$android_provider_DocumentsContract$getDocumentId(Uri documentUri) {
        List<String> paths = documentUri.getPathSegments();
        if (paths.size() >= 2 && "document".equals(paths.get(0))) {
            return paths.get(1);
        }
        if (paths.size() >= 4 && "tree".equals(paths.get(0)) && "document".equals(paths.get(2))) {
            return paths.get(3);
        }
        throw new IllegalArgumentException("Invalid URI: " + documentUri);
    }

    private static final String $$robo$$android_provider_DocumentsContract$getTreeDocumentId(Uri documentUri) {
        List<String> paths = documentUri.getPathSegments();
        if (paths.size() >= 2 && "tree".equals(paths.get(0))) {
            return paths.get(1);
        }
        throw new IllegalArgumentException("Invalid URI: " + documentUri);
    }

    private static final String $$robo$$android_provider_DocumentsContract$getSearchDocumentsQuery(Uri searchDocumentsUri) {
        return searchDocumentsUri.getQueryParameter("query");
    }

    private static final Uri $$robo$$android_provider_DocumentsContract$setManageMode(Uri uri) {
        return uri.buildUpon().appendQueryParameter("manage", "true").build();
    }

    private static final boolean $$robo$$android_provider_DocumentsContract$isManageMode(Uri uri) {
        return uri.getBooleanQueryParameter("manage", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Bitmap $$robo$$android_provider_DocumentsContract$getDocumentThumbnail(ContentResolver resolver, Uri documentUri, Point size, CancellationSignal signal) {
        ContentProviderClient client = resolver.acquireUnstableContentProviderClient(documentUri.getAuthority());
        try {
            Bitmap bitmap = DocumentsContract.getDocumentThumbnail(client, documentUri, size, signal);
            return bitmap;
        }
        catch (Exception e) {
            if (!(e instanceof OperationCanceledException)) {
                Log.w("Documents", "Failed to load thumbnail for " + documentUri + ": " + e);
            }
            Bitmap bitmap = null;
            return bitmap;
        }
        finally {
            ContentProviderClient.releaseQuietly(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Bitmap $$robo$$android_provider_DocumentsContract$getDocumentThumbnail(ContentProviderClient client, Uri documentUri, Point size, CancellationSignal signal) throws RemoteException, IOException {
        Bundle openOpts = new Bundle();
        openOpts.putParcelable("android.content.extra.SIZE", size);
        AssetFileDescriptor afd = null;
        Bitmap bitmap = null;
        try {
            int orientation;
            afd = client.openTypedAssetFileDescriptor(documentUri, "image/*", openOpts, signal);
            FileDescriptor fd = afd.getFileDescriptor();
            long offset = afd.getStartOffset();
            BufferedInputStream is = null;
            try {
                Os.lseek(fd, offset, OsConstants.SEEK_SET);
            }
            catch (ErrnoException e) {
                is = new BufferedInputStream(new FileInputStream(fd), 131072);
                is.mark(131072);
            }
            BitmapFactory.Options opts = new BitmapFactory.Options();
            opts.inJustDecodeBounds = true;
            if (is != null) {
                BitmapFactory.decodeStream(is, null, opts);
            } else {
                BitmapFactory.decodeFileDescriptor(fd, null, opts);
            }
            int widthSample = opts.outWidth / size.x;
            int heightSample = opts.outHeight / size.y;
            opts.inJustDecodeBounds = false;
            opts.inSampleSize = Math.min(widthSample, heightSample);
            if (is != null) {
                is.reset();
                bitmap = BitmapFactory.decodeStream(is, null, opts);
            } else {
                try {
                    Os.lseek(fd, offset, OsConstants.SEEK_SET);
                }
                catch (ErrnoException e) {
                    e.rethrowAsIOException();
                }
                bitmap = BitmapFactory.decodeFileDescriptor(fd, null, opts);
            }
            Bundle extras = afd.getExtras();
            int n = orientation = extras != null ? extras.getInt("android.content.extra.ORIENTATION", 0) : 0;
            if (orientation != 0) {
                int width = bitmap.getWidth();
                int height = bitmap.getHeight();
                Matrix m = new Matrix();
                m.setRotate(orientation, width / 2, height / 2);
                bitmap = Bitmap.createBitmap(bitmap, 0, 0, width, height, m, false);
            }
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly(afd);
            throw throwable;
        }
        IoUtils.closeQuietly(afd);
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Uri $$robo$$android_provider_DocumentsContract$createDocument(ContentResolver resolver, Uri parentDocumentUri, String mimeType, String displayName) {
        ContentProviderClient client = resolver.acquireUnstableContentProviderClient(parentDocumentUri.getAuthority());
        try {
            Uri uri = DocumentsContract.createDocument(client, parentDocumentUri, mimeType, displayName);
            return uri;
        }
        catch (Exception e) {
            Log.w("Documents", "Failed to create document", e);
            Uri uri = null;
            return uri;
        }
        finally {
            ContentProviderClient.releaseQuietly(client);
        }
    }

    private static final Uri $$robo$$android_provider_DocumentsContract$createDocument(ContentProviderClient client, Uri parentDocumentUri, String mimeType, String displayName) throws RemoteException {
        Bundle in = new Bundle();
        in.putParcelable("uri", parentDocumentUri);
        in.putString("mime_type", mimeType);
        in.putString("_display_name", displayName);
        Bundle out = client.call("android:createDocument", null, in);
        return (Uri)out.getParcelable("uri");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Uri $$robo$$android_provider_DocumentsContract$renameDocument(ContentResolver resolver, Uri documentUri, String displayName) {
        ContentProviderClient client = resolver.acquireUnstableContentProviderClient(documentUri.getAuthority());
        try {
            Uri uri = DocumentsContract.renameDocument(client, documentUri, displayName);
            return uri;
        }
        catch (Exception e) {
            Log.w("Documents", "Failed to rename document", e);
            Uri uri = null;
            return uri;
        }
        finally {
            ContentProviderClient.releaseQuietly(client);
        }
    }

    private static final Uri $$robo$$android_provider_DocumentsContract$renameDocument(ContentProviderClient client, Uri documentUri, String displayName) throws RemoteException {
        Bundle in = new Bundle();
        in.putParcelable("uri", documentUri);
        in.putString("_display_name", displayName);
        Bundle out = client.call("android:renameDocument", null, in);
        Uri outUri = (Uri)out.getParcelable("uri");
        return outUri != null ? outUri : documentUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean $$robo$$android_provider_DocumentsContract$deleteDocument(ContentResolver resolver, Uri documentUri) {
        ContentProviderClient client = resolver.acquireUnstableContentProviderClient(documentUri.getAuthority());
        try {
            DocumentsContract.deleteDocument(client, documentUri);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Log.w("Documents", "Failed to delete document", e);
            boolean bl = false;
            return bl;
        }
        finally {
            ContentProviderClient.releaseQuietly(client);
        }
    }

    private static final void $$robo$$android_provider_DocumentsContract$deleteDocument(ContentProviderClient client, Uri documentUri) throws RemoteException {
        Bundle in = new Bundle();
        in.putParcelable("uri", documentUri);
        client.call("android:deleteDocument", null, in);
    }

    private static final AssetFileDescriptor $$robo$$android_provider_DocumentsContract$openImageThumbnail(File file) throws FileNotFoundException {
        ParcelFileDescriptor pfd = ParcelFileDescriptor.open(file, 0x10000000);
        Bundle extras = null;
        try {
            ExifInterface exif = new ExifInterface(file.getAbsolutePath());
            switch (exif.getAttributeInt("Orientation", -1)) {
                case 6: {
                    extras = new Bundle(1);
                    extras.putInt("android.content.extra.ORIENTATION", 90);
                    break;
                }
                case 3: {
                    extras = new Bundle(1);
                    extras.putInt("android.content.extra.ORIENTATION", 180);
                    break;
                }
                case 8: {
                    extras = new Bundle(1);
                    extras.putInt("android.content.extra.ORIENTATION", 270);
                }
            }
            long[] thumb = exif.getThumbnailRange();
            if (thumb != null) {
                return new AssetFileDescriptor(pfd, thumb[0], thumb[1], extras);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new AssetFileDescriptor(pfd, 0L, -1L, extras);
    }

    private void __constructor__() {
        this.$$robo$$android_provider_DocumentsContract$__constructor__();
    }

    private DocumentsContract() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_DocumentsContract$__constructor__(), 0, this);
    }

    public static Uri buildRootsUri(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("buildRootsUri", $$robo$$android_provider_DocumentsContract$buildRootsUri(java.lang.String ), 0, (String)string2);
    }

    public static Uri buildRootUri(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("buildRootUri", $$robo$$android_provider_DocumentsContract$buildRootUri(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static Uri buildRecentDocumentsUri(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("buildRecentDocumentsUri", $$robo$$android_provider_DocumentsContract$buildRecentDocumentsUri(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static Uri buildTreeDocumentUri(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("buildTreeDocumentUri", $$robo$$android_provider_DocumentsContract$buildTreeDocumentUri(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static Uri buildDocumentUri(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("buildDocumentUri", $$robo$$android_provider_DocumentsContract$buildDocumentUri(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static Uri buildDocumentUriUsingTree(Uri uri, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("buildDocumentUriUsingTree", $$robo$$android_provider_DocumentsContract$buildDocumentUriUsingTree(android.net.Uri java.lang.String ), 0, (Uri)uri, (String)string2);
    }

    public static Uri buildDocumentUriMaybeUsingTree(Uri uri, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("buildDocumentUriMaybeUsingTree", $$robo$$android_provider_DocumentsContract$buildDocumentUriMaybeUsingTree(android.net.Uri java.lang.String ), 0, (Uri)uri, (String)string2);
    }

    public static Uri buildChildDocumentsUri(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("buildChildDocumentsUri", $$robo$$android_provider_DocumentsContract$buildChildDocumentsUri(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static Uri buildChildDocumentsUriUsingTree(Uri uri, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("buildChildDocumentsUriUsingTree", $$robo$$android_provider_DocumentsContract$buildChildDocumentsUriUsingTree(android.net.Uri java.lang.String ), 0, (Uri)uri, (String)string2);
    }

    public static Uri buildSearchDocumentsUri(String string2, String string3, String string4) {
        return InvokeDynamicSupport.bootstrapStatic("buildSearchDocumentsUri", $$robo$$android_provider_DocumentsContract$buildSearchDocumentsUri(java.lang.String java.lang.String java.lang.String ), 0, (String)string2, (String)string3, (String)string4);
    }

    public static boolean isDocumentUri(Context context, Uri uri) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isDocumentUri", $$robo$$android_provider_DocumentsContract$isDocumentUri(android.content.Context android.net.Uri ), 0, (Context)context, (Uri)uri);
    }

    public static boolean isTreeUri(Uri uri) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isTreeUri", $$robo$$android_provider_DocumentsContract$isTreeUri(android.net.Uri ), 0, (Uri)uri);
    }

    private static boolean isDocumentsProvider(Context context, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isDocumentsProvider", $$robo$$android_provider_DocumentsContract$isDocumentsProvider(android.content.Context java.lang.String ), 0, (Context)context, (String)string2);
    }

    public static String getRootId(Uri uri) {
        return InvokeDynamicSupport.bootstrapStatic("getRootId", $$robo$$android_provider_DocumentsContract$getRootId(android.net.Uri ), 0, (Uri)uri);
    }

    public static String getDocumentId(Uri uri) {
        return InvokeDynamicSupport.bootstrapStatic("getDocumentId", $$robo$$android_provider_DocumentsContract$getDocumentId(android.net.Uri ), 0, (Uri)uri);
    }

    public static String getTreeDocumentId(Uri uri) {
        return InvokeDynamicSupport.bootstrapStatic("getTreeDocumentId", $$robo$$android_provider_DocumentsContract$getTreeDocumentId(android.net.Uri ), 0, (Uri)uri);
    }

    public static String getSearchDocumentsQuery(Uri uri) {
        return InvokeDynamicSupport.bootstrapStatic("getSearchDocumentsQuery", $$robo$$android_provider_DocumentsContract$getSearchDocumentsQuery(android.net.Uri ), 0, (Uri)uri);
    }

    public static Uri setManageMode(Uri uri) {
        return InvokeDynamicSupport.bootstrapStatic("setManageMode", $$robo$$android_provider_DocumentsContract$setManageMode(android.net.Uri ), 0, (Uri)uri);
    }

    public static boolean isManageMode(Uri uri) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isManageMode", $$robo$$android_provider_DocumentsContract$isManageMode(android.net.Uri ), 0, (Uri)uri);
    }

    public static Bitmap getDocumentThumbnail(ContentResolver contentResolver, Uri uri, Point point, CancellationSignal cancellationSignal) {
        return InvokeDynamicSupport.bootstrapStatic("getDocumentThumbnail", $$robo$$android_provider_DocumentsContract$getDocumentThumbnail(android.content.ContentResolver android.net.Uri android.graphics.Point android.os.CancellationSignal ), 0, (ContentResolver)contentResolver, (Uri)uri, (Point)point, (CancellationSignal)cancellationSignal);
    }

    public static Bitmap getDocumentThumbnail(ContentProviderClient contentProviderClient, Uri uri, Point point, CancellationSignal cancellationSignal) throws RemoteException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("getDocumentThumbnail", $$robo$$android_provider_DocumentsContract$getDocumentThumbnail(android.content.ContentProviderClient android.net.Uri android.graphics.Point android.os.CancellationSignal ), 0, (ContentProviderClient)contentProviderClient, (Uri)uri, (Point)point, (CancellationSignal)cancellationSignal);
    }

    public static Uri createDocument(ContentResolver contentResolver, Uri uri, String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("createDocument", $$robo$$android_provider_DocumentsContract$createDocument(android.content.ContentResolver android.net.Uri java.lang.String java.lang.String ), 0, (ContentResolver)contentResolver, (Uri)uri, (String)string2, (String)string3);
    }

    public static Uri createDocument(ContentProviderClient contentProviderClient, Uri uri, String string2, String string3) throws RemoteException {
        return InvokeDynamicSupport.bootstrapStatic("createDocument", $$robo$$android_provider_DocumentsContract$createDocument(android.content.ContentProviderClient android.net.Uri java.lang.String java.lang.String ), 0, (ContentProviderClient)contentProviderClient, (Uri)uri, (String)string2, (String)string3);
    }

    public static Uri renameDocument(ContentResolver contentResolver, Uri uri, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("renameDocument", $$robo$$android_provider_DocumentsContract$renameDocument(android.content.ContentResolver android.net.Uri java.lang.String ), 0, (ContentResolver)contentResolver, (Uri)uri, (String)string2);
    }

    public static Uri renameDocument(ContentProviderClient contentProviderClient, Uri uri, String string2) throws RemoteException {
        return InvokeDynamicSupport.bootstrapStatic("renameDocument", $$robo$$android_provider_DocumentsContract$renameDocument(android.content.ContentProviderClient android.net.Uri java.lang.String ), 0, (ContentProviderClient)contentProviderClient, (Uri)uri, (String)string2);
    }

    public static boolean deleteDocument(ContentResolver contentResolver, Uri uri) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("deleteDocument", $$robo$$android_provider_DocumentsContract$deleteDocument(android.content.ContentResolver android.net.Uri ), 0, (ContentResolver)contentResolver, (Uri)uri);
    }

    public static void deleteDocument(ContentProviderClient contentProviderClient, Uri uri) throws RemoteException {
        InvokeDynamicSupport.bootstrapStatic("deleteDocument", $$robo$$android_provider_DocumentsContract$deleteDocument(android.content.ContentProviderClient android.net.Uri ), 0, (ContentProviderClient)contentProviderClient, (Uri)uri);
    }

    public static AssetFileDescriptor openImageThumbnail(File file) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("openImageThumbnail", $$robo$$android_provider_DocumentsContract$openImageThumbnail(java.io.File ), 0, (File)file);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DocumentsContract)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Root
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static String COLUMN_ROOT_ID = "root_id";
        public static String COLUMN_FLAGS = "flags";
        public static String COLUMN_ICON = "icon";
        public static String COLUMN_TITLE = "title";
        public static String COLUMN_SUMMARY = "summary";
        public static String COLUMN_DOCUMENT_ID = "document_id";
        public static String COLUMN_AVAILABLE_BYTES = "available_bytes";
        public static String COLUMN_MIME_TYPES = "mime_types";
        public static String MIME_TYPE_ITEM = "vnd.android.document/root";
        public static int FLAG_SUPPORTS_CREATE = 1;
        public static int FLAG_LOCAL_ONLY = 2;
        public static int FLAG_SUPPORTS_RECENTS = 4;
        public static int FLAG_SUPPORTS_SEARCH = 8;
        public static int FLAG_SUPPORTS_IS_CHILD = 16;
        public static int FLAG_EMPTY = 65536;
        public static int FLAG_ADVANCED = 131072;

        private void $$robo$$android_provider_DocumentsContract_Root$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_provider_DocumentsContract_Root$__constructor__();
        }

        private Root() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_DocumentsContract_Root$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Root)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Document
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static String COLUMN_DOCUMENT_ID = "document_id";
        public static String COLUMN_MIME_TYPE = "mime_type";
        public static String COLUMN_DISPLAY_NAME = "_display_name";
        public static String COLUMN_SUMMARY = "summary";
        public static String COLUMN_LAST_MODIFIED = "last_modified";
        public static String COLUMN_ICON = "icon";
        public static String COLUMN_FLAGS = "flags";
        public static String COLUMN_SIZE = "_size";
        public static String MIME_TYPE_DIR = "vnd.android.document/directory";
        public static int FLAG_SUPPORTS_THUMBNAIL = 1;
        public static int FLAG_SUPPORTS_WRITE = 2;
        public static int FLAG_SUPPORTS_DELETE = 4;
        public static int FLAG_DIR_SUPPORTS_CREATE = 8;
        public static int FLAG_DIR_PREFERS_GRID = 16;
        public static int FLAG_DIR_PREFERS_LAST_MODIFIED = 32;
        public static int FLAG_SUPPORTS_RENAME = 64;
        public static int FLAG_DIR_HIDE_GRID_TITLES = 65536;

        private void $$robo$$android_provider_DocumentsContract_Document$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_provider_DocumentsContract_Document$__constructor__();
        }

        private Document() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_DocumentsContract_Document$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Document)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

