/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.content.pm.ProviderInfo;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.graphics.Point;
import android.net.Uri;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.ParcelFileDescriptor;
import android.provider.DocumentsContract;
import android.util.Log;
import java.io.FileNotFoundException;
import java.util.Objects;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class DocumentsProvider
extends ContentProvider
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "DocumentsProvider";
    private static int MATCH_ROOTS = 1;
    private static int MATCH_ROOT = 2;
    private static int MATCH_RECENT = 3;
    private static int MATCH_SEARCH = 4;
    private static int MATCH_DOCUMENT = 5;
    private static int MATCH_CHILDREN = 6;
    private static int MATCH_DOCUMENT_TREE = 7;
    private static int MATCH_CHILDREN_TREE = 8;
    private String mAuthority;
    private UriMatcher mMatcher;

    private void $$robo$$android_provider_DocumentsProvider$__constructor__() {
    }

    private final void $$robo$$android_provider_DocumentsProvider$attachInfo(Context context, ProviderInfo info) {
        this.mAuthority = info.authority;
        this.mMatcher = new UriMatcher(-1);
        this.mMatcher.addURI(this.mAuthority, "root", 1);
        this.mMatcher.addURI(this.mAuthority, "root/*", 2);
        this.mMatcher.addURI(this.mAuthority, "root/*/recent", 3);
        this.mMatcher.addURI(this.mAuthority, "root/*/search", 4);
        this.mMatcher.addURI(this.mAuthority, "document/*", 5);
        this.mMatcher.addURI(this.mAuthority, "document/*/children", 6);
        this.mMatcher.addURI(this.mAuthority, "tree/*/document/*", 7);
        this.mMatcher.addURI(this.mAuthority, "tree/*/document/*/children", 8);
        if (!info.exported) {
            throw new SecurityException("Provider must be exported");
        }
        if (!info.grantUriPermissions) {
            throw new SecurityException("Provider must grantUriPermissions");
        }
        if (!"android.permission.MANAGE_DOCUMENTS".equals(info.readPermission) || !"android.permission.MANAGE_DOCUMENTS".equals(info.writePermission)) {
            throw new SecurityException("Provider must be protected by MANAGE_DOCUMENTS");
        }
        super.attachInfo(context, info);
    }

    private final boolean $$robo$$android_provider_DocumentsProvider$isChildDocument(String parentDocumentId, String documentId) {
        return false;
    }

    private final void $$robo$$android_provider_DocumentsProvider$enforceTree(Uri documentUri) {
        if (DocumentsContract.isTreeUri(documentUri)) {
            String child;
            String parent = DocumentsContract.getTreeDocumentId(documentUri);
            if (Objects.equals(parent, child = DocumentsContract.getDocumentId(documentUri))) {
                return;
            }
            if (!this.isChildDocument(parent, child)) {
                throw new SecurityException("Document " + child + " is not a descendant of " + parent);
            }
        }
    }

    private final String $$robo$$android_provider_DocumentsProvider$createDocument(String parentDocumentId, String mimeType, String displayName) throws FileNotFoundException {
        throw new UnsupportedOperationException("Create not supported");
    }

    private final String $$robo$$android_provider_DocumentsProvider$renameDocument(String documentId, String displayName) throws FileNotFoundException {
        throw new UnsupportedOperationException("Rename not supported");
    }

    private final void $$robo$$android_provider_DocumentsProvider$deleteDocument(String documentId) throws FileNotFoundException {
        throw new UnsupportedOperationException("Delete not supported");
    }

    public abstract Cursor queryRoots(String[] var1) throws FileNotFoundException;

    private final Cursor $$robo$$android_provider_DocumentsProvider$queryRecentDocuments(String rootId, String[] projection) throws FileNotFoundException {
        throw new UnsupportedOperationException("Recent not supported");
    }

    public abstract Cursor queryDocument(String var1, String[] var2) throws FileNotFoundException;

    public abstract Cursor queryChildDocuments(String var1, String[] var2, String var3) throws FileNotFoundException;

    private final Cursor $$robo$$android_provider_DocumentsProvider$queryChildDocumentsForManage(String parentDocumentId, String[] projection, String sortOrder) throws FileNotFoundException {
        throw new UnsupportedOperationException("Manage not supported");
    }

    private final Cursor $$robo$$android_provider_DocumentsProvider$querySearchDocuments(String rootId, String query, String[] projection) throws FileNotFoundException {
        throw new UnsupportedOperationException("Search not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_provider_DocumentsProvider$getDocumentType(String documentId) throws FileNotFoundException {
        Cursor cursor = this.queryDocument(documentId, null);
        try {
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(cursor.getColumnIndexOrThrow("mime_type"));
                return string2;
            }
            String string3 = null;
            return string3;
        }
        finally {
            IoUtils.closeQuietly(cursor);
        }
    }

    public abstract ParcelFileDescriptor openDocument(String var1, String var2, CancellationSignal var3) throws FileNotFoundException;

    private final AssetFileDescriptor $$robo$$android_provider_DocumentsProvider$openDocumentThumbnail(String documentId, Point sizeHint, CancellationSignal signal) throws FileNotFoundException {
        throw new UnsupportedOperationException("Thumbnails not supported");
    }

    private final Cursor $$robo$$android_provider_DocumentsProvider$query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        try {
            switch (this.mMatcher.match(uri)) {
                case 1: {
                    return this.queryRoots(projection);
                }
                case 3: {
                    return this.queryRecentDocuments(DocumentsContract.getRootId(uri), projection);
                }
                case 4: {
                    return this.querySearchDocuments(DocumentsContract.getRootId(uri), DocumentsContract.getSearchDocumentsQuery(uri), projection);
                }
                case 5: 
                case 7: {
                    this.enforceTree(uri);
                    return this.queryDocument(DocumentsContract.getDocumentId(uri), projection);
                }
                case 6: 
                case 8: {
                    this.enforceTree(uri);
                    if (DocumentsContract.isManageMode(uri)) {
                        return this.queryChildDocumentsForManage(DocumentsContract.getDocumentId(uri), projection, sortOrder);
                    }
                    return this.queryChildDocuments(DocumentsContract.getDocumentId(uri), projection, sortOrder);
                }
            }
            throw new UnsupportedOperationException("Unsupported Uri " + uri);
        }
        catch (FileNotFoundException e) {
            Log.w("DocumentsProvider", "Failed during query", e);
            return null;
        }
    }

    private final String $$robo$$android_provider_DocumentsProvider$getType(Uri uri) {
        try {
            switch (this.mMatcher.match(uri)) {
                case 2: {
                    return "vnd.android.document/root";
                }
                case 5: 
                case 7: {
                    this.enforceTree(uri);
                    return this.getDocumentType(DocumentsContract.getDocumentId(uri));
                }
            }
            return null;
        }
        catch (FileNotFoundException e) {
            Log.w("DocumentsProvider", "Failed during getType", e);
            return null;
        }
    }

    private final Uri $$robo$$android_provider_DocumentsProvider$canonicalize(Uri uri) {
        Context context = this.getContext();
        switch (this.mMatcher.match(uri)) {
            case 7: {
                this.enforceTree(uri);
                Uri narrowUri = DocumentsContract.buildDocumentUri(uri.getAuthority(), DocumentsContract.getDocumentId(uri));
                int modeFlags = DocumentsProvider.getCallingOrSelfUriPermissionModeFlags(context, uri);
                context.grantUriPermission(this.getCallingPackage(), narrowUri, modeFlags);
                return narrowUri;
            }
        }
        return null;
    }

    private static final int $$robo$$android_provider_DocumentsProvider$getCallingOrSelfUriPermissionModeFlags(Context context, Uri uri) {
        int modeFlags = 0;
        if (context.checkCallingOrSelfUriPermission(uri, 1) == 0) {
            modeFlags |= 1;
        }
        if (context.checkCallingOrSelfUriPermission(uri, 2) == 0) {
            modeFlags |= 2;
        }
        if (context.checkCallingOrSelfUriPermission(uri, 65) == 0) {
            modeFlags |= 0x40;
        }
        return modeFlags;
    }

    private final Uri $$robo$$android_provider_DocumentsProvider$insert(Uri uri, ContentValues values) {
        throw new UnsupportedOperationException("Insert not supported");
    }

    private final int $$robo$$android_provider_DocumentsProvider$delete(Uri uri, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException("Delete not supported");
    }

    private final int $$robo$$android_provider_DocumentsProvider$update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException("Update not supported");
    }

    private final Bundle $$robo$$android_provider_DocumentsProvider$call(String method, String arg, Bundle extras) {
        Bundle out;
        block9: {
            if (!method.startsWith("android:")) {
                return super.call(method, arg, extras);
            }
            Context context = this.getContext();
            Uri documentUri = (Uri)extras.getParcelable("uri");
            String authority = documentUri.getAuthority();
            String documentId = DocumentsContract.getDocumentId(documentUri);
            if (!this.mAuthority.equals(authority)) {
                throw new SecurityException("Requested authority " + authority + " doesn't match provider " + this.mAuthority);
            }
            this.enforceTree(documentUri);
            out = new Bundle();
            try {
                if ("android:createDocument".equals(method)) {
                    this.enforceWritePermissionInner(documentUri);
                    String mimeType = extras.getString("mime_type");
                    String displayName = extras.getString("_display_name");
                    String newDocumentId = this.createDocument(documentId, mimeType, displayName);
                    Uri newDocumentUri = DocumentsContract.buildDocumentUriMaybeUsingTree(documentUri, newDocumentId);
                    out.putParcelable("uri", newDocumentUri);
                    break block9;
                }
                if ("android:renameDocument".equals(method)) {
                    this.enforceWritePermissionInner(documentUri);
                    String displayName = extras.getString("_display_name");
                    String newDocumentId = this.renameDocument(documentId, displayName);
                    if (newDocumentId != null) {
                        Uri newDocumentUri = DocumentsContract.buildDocumentUriMaybeUsingTree(documentUri, newDocumentId);
                        if (!DocumentsContract.isTreeUri(newDocumentUri)) {
                            int modeFlags = DocumentsProvider.getCallingOrSelfUriPermissionModeFlags(context, documentUri);
                            context.grantUriPermission(this.getCallingPackage(), newDocumentUri, modeFlags);
                        }
                        out.putParcelable("uri", newDocumentUri);
                        this.revokeDocumentPermission(documentId);
                    }
                    break block9;
                }
                if ("android:deleteDocument".equals(method)) {
                    this.enforceWritePermissionInner(documentUri);
                    this.deleteDocument(documentId);
                    this.revokeDocumentPermission(documentId);
                    break block9;
                }
                throw new UnsupportedOperationException("Method not supported " + method);
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("Failed call " + method, e);
            }
        }
        return out;
    }

    private final void $$robo$$android_provider_DocumentsProvider$revokeDocumentPermission(String documentId) {
        Context context = this.getContext();
        context.revokeUriPermission(DocumentsContract.buildDocumentUri(this.mAuthority, documentId), -1);
        context.revokeUriPermission(DocumentsContract.buildTreeDocumentUri(this.mAuthority, documentId), -1);
    }

    private final ParcelFileDescriptor $$robo$$android_provider_DocumentsProvider$openFile(Uri uri, String mode) throws FileNotFoundException {
        this.enforceTree(uri);
        return this.openDocument(DocumentsContract.getDocumentId(uri), mode, null);
    }

    private final ParcelFileDescriptor $$robo$$android_provider_DocumentsProvider$openFile(Uri uri, String mode, CancellationSignal signal) throws FileNotFoundException {
        this.enforceTree(uri);
        return this.openDocument(DocumentsContract.getDocumentId(uri), mode, signal);
    }

    private final AssetFileDescriptor $$robo$$android_provider_DocumentsProvider$openAssetFile(Uri uri, String mode) throws FileNotFoundException {
        this.enforceTree(uri);
        ParcelFileDescriptor fd = this.openDocument(DocumentsContract.getDocumentId(uri), mode, null);
        return fd != null ? new AssetFileDescriptor(fd, 0L, -1L) : null;
    }

    private final AssetFileDescriptor $$robo$$android_provider_DocumentsProvider$openAssetFile(Uri uri, String mode, CancellationSignal signal) throws FileNotFoundException {
        this.enforceTree(uri);
        ParcelFileDescriptor fd = this.openDocument(DocumentsContract.getDocumentId(uri), mode, signal);
        return fd != null ? new AssetFileDescriptor(fd, 0L, -1L) : null;
    }

    private final AssetFileDescriptor $$robo$$android_provider_DocumentsProvider$openTypedAssetFile(Uri uri, String mimeTypeFilter, Bundle opts) throws FileNotFoundException {
        this.enforceTree(uri);
        if (opts != null && opts.containsKey("android.content.extra.SIZE")) {
            Point sizeHint = (Point)opts.getParcelable("android.content.extra.SIZE");
            return this.openDocumentThumbnail(DocumentsContract.getDocumentId(uri), sizeHint, null);
        }
        return super.openTypedAssetFile(uri, mimeTypeFilter, opts);
    }

    private final AssetFileDescriptor $$robo$$android_provider_DocumentsProvider$openTypedAssetFile(Uri uri, String mimeTypeFilter, Bundle opts, CancellationSignal signal) throws FileNotFoundException {
        this.enforceTree(uri);
        if (opts != null && opts.containsKey("android.content.extra.SIZE")) {
            Point sizeHint = (Point)opts.getParcelable("android.content.extra.SIZE");
            return this.openDocumentThumbnail(DocumentsContract.getDocumentId(uri), sizeHint, signal);
        }
        return super.openTypedAssetFile(uri, mimeTypeFilter, opts, signal);
    }

    private void __constructor__() {
        this.$$robo$$android_provider_DocumentsProvider$__constructor__();
    }

    public DocumentsProvider() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_DocumentsProvider$__constructor__(), 0, this);
    }

    @Override
    public void attachInfo(Context context, ProviderInfo providerInfo) {
        InvokeDynamicSupport.bootstrap("attachInfo", $$robo$$android_provider_DocumentsProvider$attachInfo(android.content.Context android.content.pm.ProviderInfo ), 0, this, context, providerInfo);
    }

    public boolean isChildDocument(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrap("isChildDocument", $$robo$$android_provider_DocumentsProvider$isChildDocument(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    private void enforceTree(Uri uri) {
        InvokeDynamicSupport.bootstrap("enforceTree", $$robo$$android_provider_DocumentsProvider$enforceTree(android.net.Uri ), 0, this, uri);
    }

    public String createDocument(String string2, String string3, String string4) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("createDocument", $$robo$$android_provider_DocumentsProvider$createDocument(java.lang.String java.lang.String java.lang.String ), 0, this, string2, string3, string4);
    }

    public String renameDocument(String string2, String string3) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("renameDocument", $$robo$$android_provider_DocumentsProvider$renameDocument(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public void deleteDocument(String string2) throws FileNotFoundException {
        InvokeDynamicSupport.bootstrap("deleteDocument", $$robo$$android_provider_DocumentsProvider$deleteDocument(java.lang.String ), 0, this, string2);
    }

    public Cursor queryRecentDocuments(String string2, String[] stringArray) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("queryRecentDocuments", $$robo$$android_provider_DocumentsProvider$queryRecentDocuments(java.lang.String java.lang.String[] ), 0, this, string2, stringArray);
    }

    public Cursor queryChildDocumentsForManage(String string2, String[] stringArray, String string3) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("queryChildDocumentsForManage", $$robo$$android_provider_DocumentsProvider$queryChildDocumentsForManage(java.lang.String java.lang.String[] java.lang.String ), 0, this, string2, stringArray, string3);
    }

    public Cursor querySearchDocuments(String string2, String string3, String[] stringArray) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("querySearchDocuments", $$robo$$android_provider_DocumentsProvider$querySearchDocuments(java.lang.String java.lang.String java.lang.String[] ), 0, this, string2, string3, stringArray);
    }

    public String getDocumentType(String string2) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("getDocumentType", $$robo$$android_provider_DocumentsProvider$getDocumentType(java.lang.String ), 0, this, string2);
    }

    public AssetFileDescriptor openDocumentThumbnail(String string2, Point point, CancellationSignal cancellationSignal) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openDocumentThumbnail", $$robo$$android_provider_DocumentsProvider$openDocumentThumbnail(java.lang.String android.graphics.Point android.os.CancellationSignal ), 0, this, string2, point, cancellationSignal);
    }

    @Override
    public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        return InvokeDynamicSupport.bootstrap("query", $$robo$$android_provider_DocumentsProvider$query(android.net.Uri java.lang.String[] java.lang.String java.lang.String[] java.lang.String ), 0, this, uri, stringArray, string2, stringArray2, string3);
    }

    @Override
    public String getType(Uri uri) {
        return InvokeDynamicSupport.bootstrap("getType", $$robo$$android_provider_DocumentsProvider$getType(android.net.Uri ), 0, this, uri);
    }

    @Override
    public Uri canonicalize(Uri uri) {
        return InvokeDynamicSupport.bootstrap("canonicalize", $$robo$$android_provider_DocumentsProvider$canonicalize(android.net.Uri ), 0, this, uri);
    }

    private static int getCallingOrSelfUriPermissionModeFlags(Context context, Uri uri) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getCallingOrSelfUriPermissionModeFlags", $$robo$$android_provider_DocumentsProvider$getCallingOrSelfUriPermissionModeFlags(android.content.Context android.net.Uri ), 0, (Context)context, (Uri)uri);
    }

    @Override
    public Uri insert(Uri uri, ContentValues contentValues) {
        return InvokeDynamicSupport.bootstrap("insert", $$robo$$android_provider_DocumentsProvider$insert(android.net.Uri android.content.ContentValues ), 0, this, uri, contentValues);
    }

    @Override
    public int delete(Uri uri, String string2, String[] stringArray) {
        return (int)InvokeDynamicSupport.bootstrap("delete", $$robo$$android_provider_DocumentsProvider$delete(android.net.Uri java.lang.String java.lang.String[] ), 0, this, uri, string2, stringArray);
    }

    @Override
    public int update(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        return (int)InvokeDynamicSupport.bootstrap("update", $$robo$$android_provider_DocumentsProvider$update(android.net.Uri android.content.ContentValues java.lang.String java.lang.String[] ), 0, this, uri, contentValues, string2, stringArray);
    }

    @Override
    public Bundle call(String string2, String string3, Bundle bundle) {
        return InvokeDynamicSupport.bootstrap("call", $$robo$$android_provider_DocumentsProvider$call(java.lang.String java.lang.String android.os.Bundle ), 0, this, string2, string3, bundle);
    }

    public void revokeDocumentPermission(String string2) {
        InvokeDynamicSupport.bootstrap("revokeDocumentPermission", $$robo$$android_provider_DocumentsProvider$revokeDocumentPermission(java.lang.String ), 0, this, string2);
    }

    @Override
    public ParcelFileDescriptor openFile(Uri uri, String string2) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openFile", $$robo$$android_provider_DocumentsProvider$openFile(android.net.Uri java.lang.String ), 0, this, uri, string2);
    }

    @Override
    public ParcelFileDescriptor openFile(Uri uri, String string2, CancellationSignal cancellationSignal) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openFile", $$robo$$android_provider_DocumentsProvider$openFile(android.net.Uri java.lang.String android.os.CancellationSignal ), 0, this, uri, string2, cancellationSignal);
    }

    @Override
    public AssetFileDescriptor openAssetFile(Uri uri, String string2) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openAssetFile", $$robo$$android_provider_DocumentsProvider$openAssetFile(android.net.Uri java.lang.String ), 0, this, uri, string2);
    }

    @Override
    public AssetFileDescriptor openAssetFile(Uri uri, String string2, CancellationSignal cancellationSignal) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openAssetFile", $$robo$$android_provider_DocumentsProvider$openAssetFile(android.net.Uri java.lang.String android.os.CancellationSignal ), 0, this, uri, string2, cancellationSignal);
    }

    @Override
    public AssetFileDescriptor openTypedAssetFile(Uri uri, String string2, Bundle bundle) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openTypedAssetFile", $$robo$$android_provider_DocumentsProvider$openTypedAssetFile(android.net.Uri java.lang.String android.os.Bundle ), 0, this, uri, string2, bundle);
    }

    @Override
    public AssetFileDescriptor openTypedAssetFile(Uri uri, String string2, Bundle bundle, CancellationSignal cancellationSignal) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openTypedAssetFile", $$robo$$android_provider_DocumentsProvider$openTypedAssetFile(android.net.Uri java.lang.String android.os.Bundle android.os.CancellationSignal ), 0, this, uri, string2, bundle, cancellationSignal);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DocumentsProvider)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

