/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.os.Trace;
import android.renderscript.AllocationAdapter;
import android.renderscript.BaseObj;
import android.renderscript.Element;
import android.renderscript.FieldPacker;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RSInvalidStateException;
import android.renderscript.RSRuntimeException;
import android.renderscript.RenderScript;
import android.renderscript.Type;
import android.util.Log;
import android.view.Surface;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.reflect.Array;
import java.util.HashMap;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Allocation
extends BaseObj
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    Type mType;
    Bitmap mBitmap;
    int mUsage;
    Allocation mAdaptedAllocation;
    int mSize;
    boolean mConstrainedLOD;
    boolean mConstrainedFace;
    boolean mConstrainedY;
    boolean mConstrainedZ;
    boolean mReadAllowed;
    boolean mWriteAllowed;
    int mSelectedY;
    int mSelectedZ;
    int mSelectedLOD;
    Type.CubemapFace mSelectedFace;
    int mCurrentDimX;
    int mCurrentDimY;
    int mCurrentDimZ;
    int mCurrentCount;
    static HashMap<Long, Allocation> mAllocationMap;
    OnBufferAvailableListener mBufferNotifier;
    public static int USAGE_SCRIPT = 1;
    public static int USAGE_GRAPHICS_TEXTURE = 2;
    public static int USAGE_GRAPHICS_VERTEX = 4;
    public static int USAGE_GRAPHICS_CONSTANTS = 8;
    public static int USAGE_GRAPHICS_RENDER_TARGET = 16;
    public static int USAGE_IO_INPUT = 32;
    public static int USAGE_IO_OUTPUT = 64;
    public static int USAGE_SHARED = 128;
    static BitmapFactory.Options mBitmapOptions;

    private final Element.DataType $$robo$$android_renderscript_Allocation$validateObjectIsPrimitiveArray(Object d, boolean checkType) {
        Class<?> c = d.getClass();
        if (!c.isArray()) {
            throw new RSIllegalArgumentException("Object passed is not an array of primitives.");
        }
        Class<?> cmp = c.getComponentType();
        if (!cmp.isPrimitive()) {
            throw new RSIllegalArgumentException("Object passed is not an Array of primitives.");
        }
        if (cmp == Long.TYPE) {
            if (checkType) {
                this.validateIsInt64();
                return this.mType.mElement.mType;
            }
            return Element.DataType.SIGNED_64;
        }
        if (cmp == Integer.TYPE) {
            if (checkType) {
                this.validateIsInt32();
                return this.mType.mElement.mType;
            }
            return Element.DataType.SIGNED_32;
        }
        if (cmp == Short.TYPE) {
            if (checkType) {
                this.validateIsInt16();
                return this.mType.mElement.mType;
            }
            return Element.DataType.SIGNED_16;
        }
        if (cmp == Byte.TYPE) {
            if (checkType) {
                this.validateIsInt8();
                return this.mType.mElement.mType;
            }
            return Element.DataType.SIGNED_8;
        }
        if (cmp == Float.TYPE) {
            if (checkType) {
                this.validateIsFloat32();
            }
            return Element.DataType.FLOAT_32;
        }
        if (cmp == Double.TYPE) {
            if (checkType) {
                this.validateIsFloat64();
            }
            return Element.DataType.FLOAT_64;
        }
        return null;
    }

    private final long $$robo$$android_renderscript_Allocation$getIDSafe() {
        if (this.mAdaptedAllocation != null) {
            return this.mAdaptedAllocation.getID(this.mRS);
        }
        return this.getID(this.mRS);
    }

    private final Element $$robo$$android_renderscript_Allocation$getElement() {
        return this.mType.getElement();
    }

    private final int $$robo$$android_renderscript_Allocation$getUsage() {
        return this.mUsage;
    }

    private final int $$robo$$android_renderscript_Allocation$getBytesSize() {
        if (this.mType.mDimYuv != 0) {
            return (int)Math.ceil((double)(this.mType.getCount() * this.mType.getElement().getBytesSize()) * 1.5);
        }
        return this.mType.getCount() * this.mType.getElement().getBytesSize();
    }

    private final void $$robo$$android_renderscript_Allocation$updateCacheInfo(Type t) {
        this.mCurrentDimX = t.getX();
        this.mCurrentDimY = t.getY();
        this.mCurrentDimZ = t.getZ();
        this.mCurrentCount = this.mCurrentDimX;
        if (this.mCurrentDimY > 1) {
            this.mCurrentCount *= this.mCurrentDimY;
        }
        if (this.mCurrentDimZ > 1) {
            this.mCurrentCount *= this.mCurrentDimZ;
        }
    }

    private final void $$robo$$android_renderscript_Allocation$setBitmap(Bitmap b) {
        this.mBitmap = b;
    }

    private void $$robo$$android_renderscript_Allocation$__constructor__(long id2, RenderScript rs, Type t, int usage) {
        this.mReadAllowed = true;
        this.mWriteAllowed = true;
        this.mSelectedFace = Type.CubemapFace.POSITIVE_X;
        if ((usage & 0xFFFFFF00) != 0) {
            throw new RSIllegalArgumentException("Unknown usage specified.");
        }
        if ((usage & 0x20) != 0) {
            this.mWriteAllowed = false;
            if ((usage & 0xFFFFFFDC) != 0) {
                throw new RSIllegalArgumentException("Invalid usage combination.");
            }
        }
        this.mType = t;
        this.mUsage = usage;
        if (t != null) {
            this.mSize = this.mType.getCount() * this.mType.getElement().getBytesSize();
            this.updateCacheInfo(t);
        }
        try {
            RenderScript.registerNativeAllocation.invoke(RenderScript.sRuntime, this.mSize);
        }
        catch (Exception e) {
            Log.e("RenderScript_jni", "Couldn't invoke registerNativeAllocation:" + e);
            throw new RSRuntimeException("Couldn't invoke registerNativeAllocation:" + e);
        }
    }

    private final void $$robo$$android_renderscript_Allocation$finalize() throws Throwable {
        RenderScript.registerNativeFree.invoke(RenderScript.sRuntime, this.mSize);
        super.finalize();
    }

    private final void $$robo$$android_renderscript_Allocation$validateIsInt64() {
        if (this.mType.mElement.mType == Element.DataType.SIGNED_64 || this.mType.mElement.mType == Element.DataType.UNSIGNED_64) {
            return;
        }
        throw new RSIllegalArgumentException("64 bit integer source does not match allocation type " + (Object)((Object)this.mType.mElement.mType));
    }

    private final void $$robo$$android_renderscript_Allocation$validateIsInt32() {
        if (this.mType.mElement.mType == Element.DataType.SIGNED_32 || this.mType.mElement.mType == Element.DataType.UNSIGNED_32) {
            return;
        }
        throw new RSIllegalArgumentException("32 bit integer source does not match allocation type " + (Object)((Object)this.mType.mElement.mType));
    }

    private final void $$robo$$android_renderscript_Allocation$validateIsInt16() {
        if (this.mType.mElement.mType == Element.DataType.SIGNED_16 || this.mType.mElement.mType == Element.DataType.UNSIGNED_16) {
            return;
        }
        throw new RSIllegalArgumentException("16 bit integer source does not match allocation type " + (Object)((Object)this.mType.mElement.mType));
    }

    private final void $$robo$$android_renderscript_Allocation$validateIsInt8() {
        if (this.mType.mElement.mType == Element.DataType.SIGNED_8 || this.mType.mElement.mType == Element.DataType.UNSIGNED_8) {
            return;
        }
        throw new RSIllegalArgumentException("8 bit integer source does not match allocation type " + (Object)((Object)this.mType.mElement.mType));
    }

    private final void $$robo$$android_renderscript_Allocation$validateIsFloat32() {
        if (this.mType.mElement.mType == Element.DataType.FLOAT_32) {
            return;
        }
        throw new RSIllegalArgumentException("32 bit float source does not match allocation type " + (Object)((Object)this.mType.mElement.mType));
    }

    private final void $$robo$$android_renderscript_Allocation$validateIsFloat64() {
        if (this.mType.mElement.mType == Element.DataType.FLOAT_64) {
            return;
        }
        throw new RSIllegalArgumentException("64 bit float source does not match allocation type " + (Object)((Object)this.mType.mElement.mType));
    }

    private final void $$robo$$android_renderscript_Allocation$validateIsObject() {
        if (this.mType.mElement.mType == Element.DataType.RS_ELEMENT || this.mType.mElement.mType == Element.DataType.RS_TYPE || this.mType.mElement.mType == Element.DataType.RS_ALLOCATION || this.mType.mElement.mType == Element.DataType.RS_SAMPLER || this.mType.mElement.mType == Element.DataType.RS_SCRIPT || this.mType.mElement.mType == Element.DataType.RS_MESH || this.mType.mElement.mType == Element.DataType.RS_PROGRAM_FRAGMENT || this.mType.mElement.mType == Element.DataType.RS_PROGRAM_VERTEX || this.mType.mElement.mType == Element.DataType.RS_PROGRAM_RASTER || this.mType.mElement.mType == Element.DataType.RS_PROGRAM_STORE) {
            return;
        }
        throw new RSIllegalArgumentException("Object source does not match allocation type " + (Object)((Object)this.mType.mElement.mType));
    }

    private final void $$robo$$android_renderscript_Allocation$updateFromNative() {
        super.updateFromNative();
        long typeID = this.mRS.nAllocationGetType(this.getID(this.mRS));
        if (typeID != 0L) {
            this.mType = new Type(typeID, this.mRS);
            this.mType.updateFromNative();
            this.updateCacheInfo(this.mType);
        }
    }

    private final Type $$robo$$android_renderscript_Allocation$getType() {
        return this.mType;
    }

    private final void $$robo$$android_renderscript_Allocation$syncAll(int srcLocation) {
        Trace.traceBegin(32768L, "syncAll");
        switch (srcLocation) {
            case 1: 
            case 2: {
                if ((this.mUsage & 0x80) == 0) break;
                this.copyFrom(this.mBitmap);
                break;
            }
            case 4: 
            case 8: {
                break;
            }
            case 128: {
                if ((this.mUsage & 0x80) == 0) break;
                this.copyTo(this.mBitmap);
                break;
            }
            default: {
                throw new RSIllegalArgumentException("Source must be exactly one usage type.");
            }
        }
        this.mRS.validate();
        this.mRS.nAllocationSyncAll(this.getIDSafe(), srcLocation);
        Trace.traceEnd(32768L);
    }

    private final void $$robo$$android_renderscript_Allocation$ioSend() {
        Trace.traceBegin(32768L, "ioSend");
        if ((this.mUsage & 0x40) == 0) {
            throw new RSIllegalArgumentException("Can only send buffer if IO_OUTPUT usage specified.");
        }
        this.mRS.validate();
        this.mRS.nAllocationIoSend(this.getID(this.mRS));
        Trace.traceEnd(32768L);
    }

    private final void $$robo$$android_renderscript_Allocation$ioReceive() {
        Trace.traceBegin(32768L, "ioReceive");
        if ((this.mUsage & 0x20) == 0) {
            throw new RSIllegalArgumentException("Can only receive if IO_INPUT usage specified.");
        }
        this.mRS.validate();
        this.mRS.nAllocationIoReceive(this.getID(this.mRS));
        Trace.traceEnd(32768L);
    }

    private final void $$robo$$android_renderscript_Allocation$copyFrom(BaseObj[] d) {
        Trace.traceBegin(32768L, "copyFrom");
        this.mRS.validate();
        this.validateIsObject();
        if (d.length != this.mCurrentCount) {
            throw new RSIllegalArgumentException("Array size mismatch, allocation sizeX = " + this.mCurrentCount + ", array length = " + d.length);
        }
        if (RenderScript.sPointerSize == 8) {
            long[] i = new long[d.length * 4];
            for (int ct = 0; ct < d.length; ++ct) {
                i[ct * 4] = d[ct].getID(this.mRS);
            }
            this.copy1DRangeFromUnchecked(0, this.mCurrentCount, (Object)i);
        } else {
            int[] i = new int[d.length];
            for (int ct = 0; ct < d.length; ++ct) {
                i[ct] = (int)d[ct].getID(this.mRS);
            }
            this.copy1DRangeFromUnchecked(0, this.mCurrentCount, i);
        }
        Trace.traceEnd(32768L);
    }

    private final void $$robo$$android_renderscript_Allocation$validateBitmapFormat(Bitmap b) {
        Bitmap.Config bc = b.getConfig();
        if (bc == null) {
            throw new RSIllegalArgumentException("Bitmap has an unsupported format for this operation");
        }
        switch (1.$SwitchMap$android$graphics$Bitmap$Config[bc.ordinal()]) {
            case 1: {
                if (this.mType.getElement().mKind == Element.DataKind.PIXEL_A) break;
                throw new RSIllegalArgumentException("Allocation kind is " + (Object)((Object)this.mType.getElement().mKind) + ", type " + (Object)((Object)this.mType.getElement().mType) + " of " + this.mType.getElement().getBytesSize() + " bytes, passed bitmap was " + (Object)((Object)bc));
            }
            case 2: {
                if (this.mType.getElement().mKind == Element.DataKind.PIXEL_RGBA && this.mType.getElement().getBytesSize() == 4) break;
                throw new RSIllegalArgumentException("Allocation kind is " + (Object)((Object)this.mType.getElement().mKind) + ", type " + (Object)((Object)this.mType.getElement().mType) + " of " + this.mType.getElement().getBytesSize() + " bytes, passed bitmap was " + (Object)((Object)bc));
            }
            case 3: {
                if (this.mType.getElement().mKind == Element.DataKind.PIXEL_RGB && this.mType.getElement().getBytesSize() == 2) break;
                throw new RSIllegalArgumentException("Allocation kind is " + (Object)((Object)this.mType.getElement().mKind) + ", type " + (Object)((Object)this.mType.getElement().mType) + " of " + this.mType.getElement().getBytesSize() + " bytes, passed bitmap was " + (Object)((Object)bc));
            }
            case 4: {
                if (this.mType.getElement().mKind == Element.DataKind.PIXEL_RGBA && this.mType.getElement().getBytesSize() == 2) break;
                throw new RSIllegalArgumentException("Allocation kind is " + (Object)((Object)this.mType.getElement().mKind) + ", type " + (Object)((Object)this.mType.getElement().mType) + " of " + this.mType.getElement().getBytesSize() + " bytes, passed bitmap was " + (Object)((Object)bc));
            }
        }
    }

    private final void $$robo$$android_renderscript_Allocation$validateBitmapSize(Bitmap b) {
        if (this.mCurrentDimX != b.getWidth() || this.mCurrentDimY != b.getHeight()) {
            throw new RSIllegalArgumentException("Cannot update allocation from bitmap, sizes mismatch");
        }
    }

    private final void $$robo$$android_renderscript_Allocation$copyFromUnchecked(Object array2, Element.DataType dt, int arrayLen) {
        Trace.traceBegin(32768L, "copyFromUnchecked");
        this.mRS.validate();
        if (this.mCurrentDimZ > 0) {
            this.copy3DRangeFromUnchecked(0, 0, 0, this.mCurrentDimX, this.mCurrentDimY, this.mCurrentDimZ, array2, dt, arrayLen);
        } else if (this.mCurrentDimY > 0) {
            this.copy2DRangeFromUnchecked(0, 0, this.mCurrentDimX, this.mCurrentDimY, array2, dt, arrayLen);
        } else {
            this.copy1DRangeFromUnchecked(0, this.mCurrentCount, array2, dt, arrayLen);
        }
        Trace.traceEnd(32768L);
    }

    private final void $$robo$$android_renderscript_Allocation$copyFromUnchecked(Object array2) {
        Trace.traceBegin(32768L, "copyFromUnchecked");
        this.copyFromUnchecked(array2, this.validateObjectIsPrimitiveArray(array2, false), Array.getLength(array2));
        Trace.traceEnd(32768L);
    }

    private final void $$robo$$android_renderscript_Allocation$copyFromUnchecked(int[] d) {
        this.copyFromUnchecked(d, Element.DataType.SIGNED_32, d.length);
    }

    private final void $$robo$$android_renderscript_Allocation$copyFromUnchecked(short[] d) {
        this.copyFromUnchecked(d, Element.DataType.SIGNED_16, d.length);
    }

    private final void $$robo$$android_renderscript_Allocation$copyFromUnchecked(byte[] d) {
        this.copyFromUnchecked(d, Element.DataType.SIGNED_8, d.length);
    }

    private final void $$robo$$android_renderscript_Allocation$copyFromUnchecked(float[] d) {
        this.copyFromUnchecked(d, Element.DataType.FLOAT_32, d.length);
    }

    private final void $$robo$$android_renderscript_Allocation$copyFrom(Object array2) {
        Trace.traceBegin(32768L, "copyFrom");
        this.copyFromUnchecked(array2, this.validateObjectIsPrimitiveArray(array2, true), Array.getLength(array2));
        Trace.traceEnd(32768L);
    }

    private final void $$robo$$android_renderscript_Allocation$copyFrom(int[] d) {
        this.validateIsInt32();
        this.copyFromUnchecked(d, Element.DataType.SIGNED_32, d.length);
    }

    private final void $$robo$$android_renderscript_Allocation$copyFrom(short[] d) {
        this.validateIsInt16();
        this.copyFromUnchecked(d, Element.DataType.SIGNED_16, d.length);
    }

    private final void $$robo$$android_renderscript_Allocation$copyFrom(byte[] d) {
        this.validateIsInt8();
        this.copyFromUnchecked(d, Element.DataType.SIGNED_8, d.length);
    }

    private final void $$robo$$android_renderscript_Allocation$copyFrom(float[] d) {
        this.validateIsFloat32();
        this.copyFromUnchecked(d, Element.DataType.FLOAT_32, d.length);
    }

    private final void $$robo$$android_renderscript_Allocation$copyFrom(Bitmap b) {
        Trace.traceBegin(32768L, "copyFrom");
        this.mRS.validate();
        if (b.getConfig() == null) {
            Bitmap newBitmap = Bitmap.createBitmap(b.getWidth(), b.getHeight(), Bitmap.Config.ARGB_8888);
            Canvas c = new Canvas(newBitmap);
            c.drawBitmap(b, 0.0f, 0.0f, null);
            this.copyFrom(newBitmap);
            return;
        }
        this.validateBitmapSize(b);
        this.validateBitmapFormat(b);
        this.mRS.nAllocationCopyFromBitmap(this.getID(this.mRS), b);
        Trace.traceEnd(32768L);
    }

    private final void $$robo$$android_renderscript_Allocation$copyFrom(Allocation a) {
        Trace.traceBegin(32768L, "copyFrom");
        this.mRS.validate();
        if (!this.mType.equals(a.getType())) {
            throw new RSIllegalArgumentException("Types of allocations must match.");
        }
        this.copy2DRangeFrom(0, 0, this.mCurrentDimX, this.mCurrentDimY, a, 0, 0);
        Trace.traceEnd(32768L);
    }

    private final void $$robo$$android_renderscript_Allocation$setFromFieldPacker(int xoff, FieldPacker fp) {
        this.mRS.validate();
        int eSize = this.mType.mElement.getBytesSize();
        byte[] data = fp.getData();
        int data_length = fp.getPos();
        int count = data_length / eSize;
        if (eSize * count != data_length) {
            throw new RSIllegalArgumentException("Field packer length " + data_length + " not divisible by element size " + eSize + ".");
        }
        this.copy1DRangeFromUnchecked(xoff, count, data);
    }

    private final void $$robo$$android_renderscript_Allocation$setFromFieldPacker(int xoff, int component_number, FieldPacker fp) {
        this.mRS.validate();
        if (component_number >= this.mType.mElement.mElements.length) {
            throw new RSIllegalArgumentException("Component_number " + component_number + " out of range.");
        }
        if (xoff < 0) {
            throw new RSIllegalArgumentException("Offset must be >= 0.");
        }
        byte[] data = fp.getData();
        int data_length = fp.getPos();
        int eSize = this.mType.mElement.mElements[component_number].getBytesSize();
        if (data_length != (eSize *= this.mType.mElement.mArraySizes[component_number])) {
            throw new RSIllegalArgumentException("Field packer sizelength " + data_length + " does not match component size " + eSize + ".");
        }
        this.mRS.nAllocationElementData1D(this.getIDSafe(), xoff, this.mSelectedLOD, component_number, data, data_length);
    }

    private final void $$robo$$android_renderscript_Allocation$data1DChecks(int off, int count, int len, int dataSize) {
        this.mRS.validate();
        if (off < 0) {
            throw new RSIllegalArgumentException("Offset must be >= 0.");
        }
        if (count < 1) {
            throw new RSIllegalArgumentException("Count must be >= 1.");
        }
        if (off + count > this.mCurrentCount) {
            throw new RSIllegalArgumentException("Overflow, Available count " + this.mCurrentCount + ", got " + count + " at offset " + off + ".");
        }
        if (len < dataSize) {
            throw new RSIllegalArgumentException("Array too small for allocation type.");
        }
    }

    private final void $$robo$$android_renderscript_Allocation$generateMipmaps() {
        this.mRS.nAllocationGenerateMipmaps(this.getID(this.mRS));
    }

    private final void $$robo$$android_renderscript_Allocation$copy1DRangeFromUnchecked(int off, int count, Object array2, Element.DataType dt, int arrayLen) {
        Trace.traceBegin(32768L, "copy1DRangeFromUnchecked");
        int dataSize = this.mType.mElement.getBytesSize() * count;
        this.data1DChecks(off, count, arrayLen * dt.mSize, dataSize);
        this.mRS.nAllocationData1D(this.getIDSafe(), off, this.mSelectedLOD, count, array2, dataSize, dt);
        Trace.traceEnd(32768L);
    }

    private final void $$robo$$android_renderscript_Allocation$copy1DRangeFromUnchecked(int off, int count, Object array2) {
        this.copy1DRangeFromUnchecked(off, count, array2, this.validateObjectIsPrimitiveArray(array2, false), Array.getLength(array2));
    }

    private final void $$robo$$android_renderscript_Allocation$copy1DRangeFromUnchecked(int off, int count, int[] d) {
        this.copy1DRangeFromUnchecked(off, count, d, Element.DataType.SIGNED_32, d.length);
    }

    private final void $$robo$$android_renderscript_Allocation$copy1DRangeFromUnchecked(int off, int count, short[] d) {
        this.copy1DRangeFromUnchecked(off, count, d, Element.DataType.SIGNED_16, d.length);
    }

    private final void $$robo$$android_renderscript_Allocation$copy1DRangeFromUnchecked(int off, int count, byte[] d) {
        this.copy1DRangeFromUnchecked(off, count, d, Element.DataType.SIGNED_8, d.length);
    }

    private final void $$robo$$android_renderscript_Allocation$copy1DRangeFromUnchecked(int off, int count, float[] d) {
        this.copy1DRangeFromUnchecked(off, count, d, Element.DataType.FLOAT_32, d.length);
    }

    private final void $$robo$$android_renderscript_Allocation$copy1DRangeFrom(int off, int count, Object array2) {
        this.copy1DRangeFromUnchecked(off, count, array2, this.validateObjectIsPrimitiveArray(array2, true), Array.getLength(array2));
    }

    private final void $$robo$$android_renderscript_Allocation$copy1DRangeFrom(int off, int count, int[] d) {
        this.validateIsInt32();
        this.copy1DRangeFromUnchecked(off, count, d, Element.DataType.SIGNED_32, d.length);
    }

    private final void $$robo$$android_renderscript_Allocation$copy1DRangeFrom(int off, int count, short[] d) {
        this.validateIsInt16();
        this.copy1DRangeFromUnchecked(off, count, d, Element.DataType.SIGNED_16, d.length);
    }

    private final void $$robo$$android_renderscript_Allocation$copy1DRangeFrom(int off, int count, byte[] d) {
        this.validateIsInt8();
        this.copy1DRangeFromUnchecked(off, count, d, Element.DataType.SIGNED_8, d.length);
    }

    private final void $$robo$$android_renderscript_Allocation$copy1DRangeFrom(int off, int count, float[] d) {
        this.validateIsFloat32();
        this.copy1DRangeFromUnchecked(off, count, d, Element.DataType.FLOAT_32, d.length);
    }

    private final void $$robo$$android_renderscript_Allocation$copy1DRangeFrom(int off, int count, Allocation data, int dataOff) {
        Trace.traceBegin(32768L, "copy1DRangeFrom");
        this.mRS.nAllocationData2D(this.getIDSafe(), off, 0, this.mSelectedLOD, this.mSelectedFace.mID, count, 1, data.getID(this.mRS), dataOff, 0, data.mSelectedLOD, data.mSelectedFace.mID);
    }

    private final void $$robo$$android_renderscript_Allocation$validate2DRange(int xoff, int yoff, int w, int h) {
        if (this.mAdaptedAllocation == null) {
            if (xoff < 0 || yoff < 0) {
                throw new RSIllegalArgumentException("Offset cannot be negative.");
            }
            if (h < 0 || w < 0) {
                throw new RSIllegalArgumentException("Height or width cannot be negative.");
            }
            if (xoff + w > this.mCurrentDimX || yoff + h > this.mCurrentDimY) {
                throw new RSIllegalArgumentException("Updated region larger than allocation.");
            }
        }
    }

    private final void $$robo$$android_renderscript_Allocation$copy2DRangeFromUnchecked(int xoff, int yoff, int w, int h, Object array2, Element.DataType dt, int arrayLen) {
        Trace.traceBegin(32768L, "copy2DRangeFromUnchecked");
        this.mRS.validate();
        this.validate2DRange(xoff, yoff, w, h);
        this.mRS.nAllocationData2D(this.getIDSafe(), xoff, yoff, this.mSelectedLOD, this.mSelectedFace.mID, w, h, array2, arrayLen * dt.mSize, dt);
        Trace.traceEnd(32768L);
    }

    private final void $$robo$$android_renderscript_Allocation$copy2DRangeFrom(int xoff, int yoff, int w, int h, Object array2) {
        Trace.traceBegin(32768L, "copy2DRangeFrom");
        this.copy2DRangeFromUnchecked(xoff, yoff, w, h, array2, this.validateObjectIsPrimitiveArray(array2, true), Array.getLength(array2));
        Trace.traceEnd(32768L);
    }

    private final void $$robo$$android_renderscript_Allocation$copy2DRangeFrom(int xoff, int yoff, int w, int h, byte[] data) {
        this.validateIsInt8();
        this.copy2DRangeFromUnchecked(xoff, yoff, w, h, data, Element.DataType.SIGNED_8, data.length);
    }

    private final void $$robo$$android_renderscript_Allocation$copy2DRangeFrom(int xoff, int yoff, int w, int h, short[] data) {
        this.validateIsInt16();
        this.copy2DRangeFromUnchecked(xoff, yoff, w, h, data, Element.DataType.SIGNED_16, data.length);
    }

    private final void $$robo$$android_renderscript_Allocation$copy2DRangeFrom(int xoff, int yoff, int w, int h, int[] data) {
        this.validateIsInt32();
        this.copy2DRangeFromUnchecked(xoff, yoff, w, h, data, Element.DataType.SIGNED_32, data.length);
    }

    private final void $$robo$$android_renderscript_Allocation$copy2DRangeFrom(int xoff, int yoff, int w, int h, float[] data) {
        this.validateIsFloat32();
        this.copy2DRangeFromUnchecked(xoff, yoff, w, h, data, Element.DataType.FLOAT_32, data.length);
    }

    private final void $$robo$$android_renderscript_Allocation$copy2DRangeFrom(int xoff, int yoff, int w, int h, Allocation data, int dataXoff, int dataYoff) {
        Trace.traceBegin(32768L, "copy2DRangeFrom");
        this.mRS.validate();
        this.validate2DRange(xoff, yoff, w, h);
        this.mRS.nAllocationData2D(this.getIDSafe(), xoff, yoff, this.mSelectedLOD, this.mSelectedFace.mID, w, h, data.getID(this.mRS), dataXoff, dataYoff, data.mSelectedLOD, data.mSelectedFace.mID);
        Trace.traceEnd(32768L);
    }

    private final void $$robo$$android_renderscript_Allocation$copy2DRangeFrom(int xoff, int yoff, Bitmap data) {
        Trace.traceBegin(32768L, "copy2DRangeFrom");
        this.mRS.validate();
        if (data.getConfig() == null) {
            Bitmap newBitmap = Bitmap.createBitmap(data.getWidth(), data.getHeight(), Bitmap.Config.ARGB_8888);
            Canvas c = new Canvas(newBitmap);
            c.drawBitmap(data, 0.0f, 0.0f, null);
            this.copy2DRangeFrom(xoff, yoff, newBitmap);
            return;
        }
        this.validateBitmapFormat(data);
        this.validate2DRange(xoff, yoff, data.getWidth(), data.getHeight());
        this.mRS.nAllocationData2D(this.getIDSafe(), xoff, yoff, this.mSelectedLOD, this.mSelectedFace.mID, data);
        Trace.traceEnd(32768L);
    }

    private final void $$robo$$android_renderscript_Allocation$validate3DRange(int xoff, int yoff, int zoff, int w, int h, int d) {
        if (this.mAdaptedAllocation == null) {
            if (xoff < 0 || yoff < 0 || zoff < 0) {
                throw new RSIllegalArgumentException("Offset cannot be negative.");
            }
            if (h < 0 || w < 0 || d < 0) {
                throw new RSIllegalArgumentException("Height or width cannot be negative.");
            }
            if (xoff + w > this.mCurrentDimX || yoff + h > this.mCurrentDimY || zoff + d > this.mCurrentDimZ) {
                throw new RSIllegalArgumentException("Updated region larger than allocation.");
            }
        }
    }

    private final void $$robo$$android_renderscript_Allocation$copy3DRangeFromUnchecked(int xoff, int yoff, int zoff, int w, int h, int d, Object array2, Element.DataType dt, int arrayLen) {
        Trace.traceBegin(32768L, "copy3DRangeFromUnchecked");
        this.mRS.validate();
        this.validate3DRange(xoff, yoff, zoff, w, h, d);
        this.mRS.nAllocationData3D(this.getIDSafe(), xoff, yoff, zoff, this.mSelectedLOD, w, h, d, array2, arrayLen * dt.mSize, dt);
        Trace.traceEnd(32768L);
    }

    private final void $$robo$$android_renderscript_Allocation$copy3DRangeFrom(int xoff, int yoff, int zoff, int w, int h, int d, Object array2) {
        Trace.traceBegin(32768L, "copy3DRangeFrom");
        this.copy3DRangeFromUnchecked(xoff, yoff, zoff, w, h, d, array2, this.validateObjectIsPrimitiveArray(array2, true), Array.getLength(array2));
        Trace.traceEnd(32768L);
    }

    private final void $$robo$$android_renderscript_Allocation$copy3DRangeFrom(int xoff, int yoff, int zoff, int w, int h, int d, Allocation data, int dataXoff, int dataYoff, int dataZoff) {
        this.mRS.validate();
        this.validate3DRange(xoff, yoff, zoff, w, h, d);
        this.mRS.nAllocationData3D(this.getIDSafe(), xoff, yoff, zoff, this.mSelectedLOD, w, h, d, data.getID(this.mRS), dataXoff, dataYoff, dataZoff, data.mSelectedLOD);
    }

    private final void $$robo$$android_renderscript_Allocation$copyTo(Bitmap b) {
        Trace.traceBegin(32768L, "copyTo");
        this.mRS.validate();
        this.validateBitmapFormat(b);
        this.validateBitmapSize(b);
        this.mRS.nAllocationCopyToBitmap(this.getID(this.mRS), b);
        Trace.traceEnd(32768L);
    }

    private final void $$robo$$android_renderscript_Allocation$copyTo(Object array2, Element.DataType dt, int arrayLen) {
        Trace.traceBegin(32768L, "copyTo");
        this.mRS.validate();
        this.mRS.nAllocationRead(this.getID(this.mRS), array2, dt);
        Trace.traceEnd(32768L);
    }

    private final void $$robo$$android_renderscript_Allocation$copyTo(Object array2) {
        this.copyTo(array2, this.validateObjectIsPrimitiveArray(array2, true), Array.getLength(array2));
    }

    private final void $$robo$$android_renderscript_Allocation$copyTo(byte[] d) {
        this.validateIsInt8();
        this.copyTo(d, Element.DataType.SIGNED_8, d.length);
    }

    private final void $$robo$$android_renderscript_Allocation$copyTo(short[] d) {
        this.validateIsInt16();
        this.copyTo(d, Element.DataType.SIGNED_16, d.length);
    }

    private final void $$robo$$android_renderscript_Allocation$copyTo(int[] d) {
        this.validateIsInt32();
        this.copyTo(d, Element.DataType.SIGNED_32, d.length);
    }

    private final void $$robo$$android_renderscript_Allocation$copyTo(float[] d) {
        this.validateIsFloat32();
        this.copyTo(d, Element.DataType.FLOAT_32, d.length);
    }

    private final synchronized void $$robo$$android_renderscript_Allocation$resize(int dimX) {
        if (this.mRS.getApplicationContext().getApplicationInfo().targetSdkVersion >= 21) {
            throw new RSRuntimeException("Resize is not allowed in API 21+.");
        }
        if (this.mType.getY() > 0 || this.mType.getZ() > 0 || this.mType.hasFaces() || this.mType.hasMipmaps()) {
            throw new RSInvalidStateException("Resize only support for 1D allocations at this time.");
        }
        this.mRS.nAllocationResize1D(this.getID(this.mRS), dimX);
        this.mRS.finish();
        long typeID = this.mRS.nAllocationGetType(this.getID(this.mRS));
        this.mType = new Type(typeID, this.mRS);
        this.mType.updateFromNative();
        this.updateCacheInfo(this.mType);
    }

    private static final Allocation $$robo$$android_renderscript_Allocation$createTyped(RenderScript rs, Type type, MipmapControl mips, int usage) {
        Trace.traceBegin(32768L, "createTyped");
        rs.validate();
        if (type.getID(rs) == 0L) {
            throw new RSInvalidStateException("Bad Type");
        }
        long id2 = rs.nAllocationCreateTyped(type.getID(rs), mips.mID, usage, 0L);
        if (id2 == 0L) {
            throw new RSRuntimeException("Allocation creation failed.");
        }
        Trace.traceEnd(32768L);
        return new Allocation(id2, rs, type, usage);
    }

    private static final Allocation $$robo$$android_renderscript_Allocation$createTyped(RenderScript rs, Type type, int usage) {
        return Allocation.createTyped(rs, type, MipmapControl.MIPMAP_NONE, usage);
    }

    private static final Allocation $$robo$$android_renderscript_Allocation$createTyped(RenderScript rs, Type type) {
        return Allocation.createTyped(rs, type, MipmapControl.MIPMAP_NONE, 1);
    }

    private static final Allocation $$robo$$android_renderscript_Allocation$createSized(RenderScript rs, Element e, int count, int usage) {
        Trace.traceBegin(32768L, "createSized");
        rs.validate();
        Type.Builder b = new Type.Builder(rs, e);
        b.setX(count);
        Type t = b.create();
        long id2 = rs.nAllocationCreateTyped(t.getID(rs), MipmapControl.MIPMAP_NONE.mID, usage, 0L);
        if (id2 == 0L) {
            throw new RSRuntimeException("Allocation creation failed.");
        }
        Trace.traceEnd(32768L);
        return new Allocation(id2, rs, t, usage);
    }

    private static final Allocation $$robo$$android_renderscript_Allocation$createSized(RenderScript rs, Element e, int count) {
        return Allocation.createSized(rs, e, count, 1);
    }

    private static final Element $$robo$$android_renderscript_Allocation$elementFromBitmap(RenderScript rs, Bitmap b) {
        Bitmap.Config bc = b.getConfig();
        if (bc == Bitmap.Config.ALPHA_8) {
            return Element.A_8(rs);
        }
        if (bc == Bitmap.Config.ARGB_4444) {
            return Element.RGBA_4444(rs);
        }
        if (bc == Bitmap.Config.ARGB_8888) {
            return Element.RGBA_8888(rs);
        }
        if (bc == Bitmap.Config.RGB_565) {
            return Element.RGB_565(rs);
        }
        throw new RSInvalidStateException("Bad bitmap type: " + (Object)((Object)bc));
    }

    private static final Type $$robo$$android_renderscript_Allocation$typeFromBitmap(RenderScript rs, Bitmap b, MipmapControl mip) {
        Element e = Allocation.elementFromBitmap(rs, b);
        Type.Builder tb = new Type.Builder(rs, e);
        tb.setX(b.getWidth());
        tb.setY(b.getHeight());
        tb.setMipmaps(mip == MipmapControl.MIPMAP_FULL);
        return tb.create();
    }

    private static final Allocation $$robo$$android_renderscript_Allocation$createFromBitmap(RenderScript rs, Bitmap b, MipmapControl mips, int usage) {
        Trace.traceBegin(32768L, "createFromBitmap");
        rs.validate();
        if (b.getConfig() == null) {
            if ((usage & 0x80) != 0) {
                throw new RSIllegalArgumentException("USAGE_SHARED cannot be used with a Bitmap that has a null config.");
            }
            Bitmap newBitmap = Bitmap.createBitmap(b.getWidth(), b.getHeight(), Bitmap.Config.ARGB_8888);
            Canvas c = new Canvas(newBitmap);
            c.drawBitmap(b, 0.0f, 0.0f, null);
            return Allocation.createFromBitmap(rs, newBitmap, mips, usage);
        }
        Type t = Allocation.typeFromBitmap(rs, b, mips);
        if (mips == MipmapControl.MIPMAP_NONE && t.getElement().isCompatible(Element.RGBA_8888(rs)) && usage == 131) {
            long id2 = rs.nAllocationCreateBitmapBackedAllocation(t.getID(rs), mips.mID, b, usage);
            if (id2 == 0L) {
                throw new RSRuntimeException("Load failed.");
            }
            Allocation alloc = new Allocation(id2, rs, t, usage);
            alloc.setBitmap(b);
            return alloc;
        }
        long id3 = rs.nAllocationCreateFromBitmap(t.getID(rs), mips.mID, b, usage);
        if (id3 == 0L) {
            throw new RSRuntimeException("Load failed.");
        }
        Trace.traceEnd(32768L);
        return new Allocation(id3, rs, t, usage);
    }

    private final Surface $$robo$$android_renderscript_Allocation$getSurface() {
        if ((this.mUsage & 0x20) == 0) {
            throw new RSInvalidStateException("Allocation is not a surface texture.");
        }
        return this.mRS.nAllocationGetSurface(this.getID(this.mRS));
    }

    private final void $$robo$$android_renderscript_Allocation$setSurface(Surface sur) {
        this.mRS.validate();
        if ((this.mUsage & 0x40) == 0) {
            throw new RSInvalidStateException("Allocation is not USAGE_IO_OUTPUT.");
        }
        this.mRS.nAllocationSetSurface(this.getID(this.mRS), sur);
    }

    private static final Allocation $$robo$$android_renderscript_Allocation$createFromBitmap(RenderScript rs, Bitmap b) {
        if (rs.getApplicationContext().getApplicationInfo().targetSdkVersion >= 18) {
            return Allocation.createFromBitmap(rs, b, MipmapControl.MIPMAP_NONE, 131);
        }
        return Allocation.createFromBitmap(rs, b, MipmapControl.MIPMAP_NONE, 2);
    }

    private static final Allocation $$robo$$android_renderscript_Allocation$createCubemapFromBitmap(RenderScript rs, Bitmap b, MipmapControl mips, int usage) {
        boolean isPow2;
        rs.validate();
        int height = b.getHeight();
        int width = b.getWidth();
        if (width % 6 != 0) {
            throw new RSIllegalArgumentException("Cubemap height must be multiple of 6");
        }
        if (width / 6 != height) {
            throw new RSIllegalArgumentException("Only square cube map faces supported");
        }
        boolean bl = isPow2 = (height & height - 1) == 0;
        if (!isPow2) {
            throw new RSIllegalArgumentException("Only power of 2 cube faces supported");
        }
        Element e = Allocation.elementFromBitmap(rs, b);
        Type.Builder tb = new Type.Builder(rs, e);
        tb.setX(height);
        tb.setY(height);
        tb.setFaces(true);
        tb.setMipmaps(mips == MipmapControl.MIPMAP_FULL);
        Type t = tb.create();
        long id2 = rs.nAllocationCubeCreateFromBitmap(t.getID(rs), mips.mID, b, usage);
        if (id2 == 0L) {
            throw new RSRuntimeException("Load failed for bitmap " + b + " element " + e);
        }
        return new Allocation(id2, rs, t, usage);
    }

    private static final Allocation $$robo$$android_renderscript_Allocation$createCubemapFromBitmap(RenderScript rs, Bitmap b) {
        return Allocation.createCubemapFromBitmap(rs, b, MipmapControl.MIPMAP_NONE, 2);
    }

    private static final Allocation $$robo$$android_renderscript_Allocation$createCubemapFromCubeFaces(RenderScript rs, Bitmap xpos, Bitmap xneg, Bitmap ypos, Bitmap yneg, Bitmap zpos, Bitmap zneg, MipmapControl mips, int usage) {
        boolean isPow2;
        int height = xpos.getHeight();
        if (xpos.getWidth() != height || xneg.getWidth() != height || xneg.getHeight() != height || ypos.getWidth() != height || ypos.getHeight() != height || yneg.getWidth() != height || yneg.getHeight() != height || zpos.getWidth() != height || zpos.getHeight() != height || zneg.getWidth() != height || zneg.getHeight() != height) {
            throw new RSIllegalArgumentException("Only square cube map faces supported");
        }
        boolean bl = isPow2 = (height & height - 1) == 0;
        if (!isPow2) {
            throw new RSIllegalArgumentException("Only power of 2 cube faces supported");
        }
        Element e = Allocation.elementFromBitmap(rs, xpos);
        Type.Builder tb = new Type.Builder(rs, e);
        tb.setX(height);
        tb.setY(height);
        tb.setFaces(true);
        tb.setMipmaps(mips == MipmapControl.MIPMAP_FULL);
        Type t = tb.create();
        Allocation cubemap = Allocation.createTyped(rs, t, mips, usage);
        AllocationAdapter adapter = AllocationAdapter.create2D(rs, cubemap);
        adapter.setFace(Type.CubemapFace.POSITIVE_X);
        adapter.copyFrom(xpos);
        adapter.setFace(Type.CubemapFace.NEGATIVE_X);
        adapter.copyFrom(xneg);
        adapter.setFace(Type.CubemapFace.POSITIVE_Y);
        adapter.copyFrom(ypos);
        adapter.setFace(Type.CubemapFace.NEGATIVE_Y);
        adapter.copyFrom(yneg);
        adapter.setFace(Type.CubemapFace.POSITIVE_Z);
        adapter.copyFrom(zpos);
        adapter.setFace(Type.CubemapFace.NEGATIVE_Z);
        adapter.copyFrom(zneg);
        return cubemap;
    }

    private static final Allocation $$robo$$android_renderscript_Allocation$createCubemapFromCubeFaces(RenderScript rs, Bitmap xpos, Bitmap xneg, Bitmap ypos, Bitmap yneg, Bitmap zpos, Bitmap zneg) {
        return Allocation.createCubemapFromCubeFaces(rs, xpos, xneg, ypos, yneg, zpos, zneg, MipmapControl.MIPMAP_NONE, 2);
    }

    private static final Allocation $$robo$$android_renderscript_Allocation$createFromBitmapResource(RenderScript rs, Resources res, int id2, MipmapControl mips, int usage) {
        rs.validate();
        if ((usage & 0xE0) != 0) {
            throw new RSIllegalArgumentException("Unsupported usage specified.");
        }
        Bitmap b = BitmapFactory.decodeResource(res, id2);
        Allocation alloc = Allocation.createFromBitmap(rs, b, mips, usage);
        b.recycle();
        return alloc;
    }

    private static final Allocation $$robo$$android_renderscript_Allocation$createFromBitmapResource(RenderScript rs, Resources res, int id2) {
        if (rs.getApplicationContext().getApplicationInfo().targetSdkVersion >= 18) {
            return Allocation.createFromBitmapResource(rs, res, id2, MipmapControl.MIPMAP_NONE, 3);
        }
        return Allocation.createFromBitmapResource(rs, res, id2, MipmapControl.MIPMAP_NONE, 2);
    }

    private static final Allocation $$robo$$android_renderscript_Allocation$createFromString(RenderScript rs, String str, int usage) {
        rs.validate();
        byte[] allocArray = null;
        try {
            allocArray = str.getBytes("UTF-8");
            Allocation alloc = Allocation.createSized(rs, Element.U8(rs), allocArray.length, usage);
            alloc.copyFrom(allocArray);
            return alloc;
        }
        catch (Exception e) {
            throw new RSRuntimeException("Could not convert string to utf-8.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_renderscript_Allocation$setOnBufferAvailableListener(OnBufferAvailableListener callback) {
        HashMap<Long, Allocation> hashMap = mAllocationMap;
        synchronized (hashMap) {
            mAllocationMap.put(new Long(this.getID(this.mRS)), this);
            this.mBufferNotifier = callback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_renderscript_Allocation$sendBufferNotification(long id2) {
        HashMap<Long, Allocation> hashMap = mAllocationMap;
        synchronized (hashMap) {
            Allocation a = mAllocationMap.get(new Long(id2));
            if (a != null && a.mBufferNotifier != null) {
                a.mBufferNotifier.onBufferAvailable(a);
            }
        }
    }

    static void __staticInitializer__() {
        mAllocationMap = new HashMap();
        mBitmapOptions = new BitmapFactory.Options();
        Allocation.mBitmapOptions.inScaled = false;
    }

    private Element.DataType validateObjectIsPrimitiveArray(Object object, boolean bl) {
        return InvokeDynamicSupport.bootstrap("validateObjectIsPrimitiveArray", $$robo$$android_renderscript_Allocation$validateObjectIsPrimitiveArray(java.lang.Object boolean ), 0, this, object, bl);
    }

    private long getIDSafe() {
        return (long)InvokeDynamicSupport.bootstrap("getIDSafe", $$robo$$android_renderscript_Allocation$getIDSafe(), 0, this);
    }

    public Element getElement() {
        return InvokeDynamicSupport.bootstrap("getElement", $$robo$$android_renderscript_Allocation$getElement(), 0, this);
    }

    public int getUsage() {
        return (int)InvokeDynamicSupport.bootstrap("getUsage", $$robo$$android_renderscript_Allocation$getUsage(), 0, this);
    }

    public int getBytesSize() {
        return (int)InvokeDynamicSupport.bootstrap("getBytesSize", $$robo$$android_renderscript_Allocation$getBytesSize(), 0, this);
    }

    private void updateCacheInfo(Type type) {
        InvokeDynamicSupport.bootstrap("updateCacheInfo", $$robo$$android_renderscript_Allocation$updateCacheInfo(android.renderscript.Type ), 0, this, type);
    }

    private void setBitmap(Bitmap bitmap) {
        InvokeDynamicSupport.bootstrap("setBitmap", $$robo$$android_renderscript_Allocation$setBitmap(android.graphics.Bitmap ), 0, this, bitmap);
    }

    private void __constructor__(long l, RenderScript renderScript, Type type, int n) {
        this.$$robo$$android_renderscript_Allocation$__constructor__(l, renderScript, type, n);
    }

    Allocation(long l, RenderScript renderScript, Type type, int n) {
        super(l, renderScript);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_renderscript_Allocation$__constructor__(long android.renderscript.RenderScript android.renderscript.Type int ), 0, this, l, renderScript, type, n);
    }

    @Override
    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_renderscript_Allocation$finalize(), 0, this);
    }

    private void validateIsInt64() {
        InvokeDynamicSupport.bootstrap("validateIsInt64", $$robo$$android_renderscript_Allocation$validateIsInt64(), 0, this);
    }

    private void validateIsInt32() {
        InvokeDynamicSupport.bootstrap("validateIsInt32", $$robo$$android_renderscript_Allocation$validateIsInt32(), 0, this);
    }

    private void validateIsInt16() {
        InvokeDynamicSupport.bootstrap("validateIsInt16", $$robo$$android_renderscript_Allocation$validateIsInt16(), 0, this);
    }

    private void validateIsInt8() {
        InvokeDynamicSupport.bootstrap("validateIsInt8", $$robo$$android_renderscript_Allocation$validateIsInt8(), 0, this);
    }

    private void validateIsFloat32() {
        InvokeDynamicSupport.bootstrap("validateIsFloat32", $$robo$$android_renderscript_Allocation$validateIsFloat32(), 0, this);
    }

    private void validateIsFloat64() {
        InvokeDynamicSupport.bootstrap("validateIsFloat64", $$robo$$android_renderscript_Allocation$validateIsFloat64(), 0, this);
    }

    private void validateIsObject() {
        InvokeDynamicSupport.bootstrap("validateIsObject", $$robo$$android_renderscript_Allocation$validateIsObject(), 0, this);
    }

    @Override
    void updateFromNative() {
        InvokeDynamicSupport.bootstrap("updateFromNative", $$robo$$android_renderscript_Allocation$updateFromNative(), 0, this);
    }

    public Type getType() {
        return InvokeDynamicSupport.bootstrap("getType", $$robo$$android_renderscript_Allocation$getType(), 0, this);
    }

    public void syncAll(int n) {
        InvokeDynamicSupport.bootstrap("syncAll", $$robo$$android_renderscript_Allocation$syncAll(int ), 0, this, n);
    }

    public void ioSend() {
        InvokeDynamicSupport.bootstrap("ioSend", $$robo$$android_renderscript_Allocation$ioSend(), 0, this);
    }

    public void ioReceive() {
        InvokeDynamicSupport.bootstrap("ioReceive", $$robo$$android_renderscript_Allocation$ioReceive(), 0, this);
    }

    public void copyFrom(BaseObj[] baseObjArray) {
        InvokeDynamicSupport.bootstrap("copyFrom", $$robo$$android_renderscript_Allocation$copyFrom(android.renderscript.BaseObj[] ), 0, this, baseObjArray);
    }

    private void validateBitmapFormat(Bitmap bitmap) {
        InvokeDynamicSupport.bootstrap("validateBitmapFormat", $$robo$$android_renderscript_Allocation$validateBitmapFormat(android.graphics.Bitmap ), 0, this, bitmap);
    }

    private void validateBitmapSize(Bitmap bitmap) {
        InvokeDynamicSupport.bootstrap("validateBitmapSize", $$robo$$android_renderscript_Allocation$validateBitmapSize(android.graphics.Bitmap ), 0, this, bitmap);
    }

    private void copyFromUnchecked(Object object, Element.DataType dataType, int n) {
        InvokeDynamicSupport.bootstrap("copyFromUnchecked", $$robo$$android_renderscript_Allocation$copyFromUnchecked(java.lang.Object android.renderscript.Element$DataType int ), 0, this, object, dataType, n);
    }

    public void copyFromUnchecked(Object object) {
        InvokeDynamicSupport.bootstrap("copyFromUnchecked", $$robo$$android_renderscript_Allocation$copyFromUnchecked(java.lang.Object ), 0, this, object);
    }

    public void copyFromUnchecked(int[] nArray) {
        InvokeDynamicSupport.bootstrap("copyFromUnchecked", $$robo$$android_renderscript_Allocation$copyFromUnchecked(int[] ), 0, this, nArray);
    }

    public void copyFromUnchecked(short[] sArray) {
        InvokeDynamicSupport.bootstrap("copyFromUnchecked", $$robo$$android_renderscript_Allocation$copyFromUnchecked(short[] ), 0, this, sArray);
    }

    public void copyFromUnchecked(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("copyFromUnchecked", $$robo$$android_renderscript_Allocation$copyFromUnchecked(byte[] ), 0, this, byArray);
    }

    public void copyFromUnchecked(float[] fArray) {
        InvokeDynamicSupport.bootstrap("copyFromUnchecked", $$robo$$android_renderscript_Allocation$copyFromUnchecked(float[] ), 0, this, fArray);
    }

    public void copyFrom(Object object) {
        InvokeDynamicSupport.bootstrap("copyFrom", $$robo$$android_renderscript_Allocation$copyFrom(java.lang.Object ), 0, this, object);
    }

    public void copyFrom(int[] nArray) {
        InvokeDynamicSupport.bootstrap("copyFrom", $$robo$$android_renderscript_Allocation$copyFrom(int[] ), 0, this, nArray);
    }

    public void copyFrom(short[] sArray) {
        InvokeDynamicSupport.bootstrap("copyFrom", $$robo$$android_renderscript_Allocation$copyFrom(short[] ), 0, this, sArray);
    }

    public void copyFrom(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("copyFrom", $$robo$$android_renderscript_Allocation$copyFrom(byte[] ), 0, this, byArray);
    }

    public void copyFrom(float[] fArray) {
        InvokeDynamicSupport.bootstrap("copyFrom", $$robo$$android_renderscript_Allocation$copyFrom(float[] ), 0, this, fArray);
    }

    public void copyFrom(Bitmap bitmap) {
        InvokeDynamicSupport.bootstrap("copyFrom", $$robo$$android_renderscript_Allocation$copyFrom(android.graphics.Bitmap ), 0, this, bitmap);
    }

    public void copyFrom(Allocation allocation) {
        InvokeDynamicSupport.bootstrap("copyFrom", $$robo$$android_renderscript_Allocation$copyFrom(android.renderscript.Allocation ), 0, this, allocation);
    }

    public void setFromFieldPacker(int n, FieldPacker fieldPacker) {
        InvokeDynamicSupport.bootstrap("setFromFieldPacker", $$robo$$android_renderscript_Allocation$setFromFieldPacker(int android.renderscript.FieldPacker ), 0, this, n, fieldPacker);
    }

    public void setFromFieldPacker(int n, int n2, FieldPacker fieldPacker) {
        InvokeDynamicSupport.bootstrap("setFromFieldPacker", $$robo$$android_renderscript_Allocation$setFromFieldPacker(int int android.renderscript.FieldPacker ), 0, this, n, n2, fieldPacker);
    }

    private void data1DChecks(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("data1DChecks", $$robo$$android_renderscript_Allocation$data1DChecks(int int int int ), 0, this, n, n2, n3, n4);
    }

    public void generateMipmaps() {
        InvokeDynamicSupport.bootstrap("generateMipmaps", $$robo$$android_renderscript_Allocation$generateMipmaps(), 0, this);
    }

    private void copy1DRangeFromUnchecked(int n, int n2, Object object, Element.DataType dataType, int n3) {
        InvokeDynamicSupport.bootstrap("copy1DRangeFromUnchecked", $$robo$$android_renderscript_Allocation$copy1DRangeFromUnchecked(int int java.lang.Object android.renderscript.Element$DataType int ), 0, this, n, n2, object, dataType, n3);
    }

    public void copy1DRangeFromUnchecked(int n, int n2, Object object) {
        InvokeDynamicSupport.bootstrap("copy1DRangeFromUnchecked", $$robo$$android_renderscript_Allocation$copy1DRangeFromUnchecked(int int java.lang.Object ), 0, this, n, n2, object);
    }

    public void copy1DRangeFromUnchecked(int n, int n2, int[] nArray) {
        InvokeDynamicSupport.bootstrap("copy1DRangeFromUnchecked", $$robo$$android_renderscript_Allocation$copy1DRangeFromUnchecked(int int int[] ), 0, this, n, n2, nArray);
    }

    public void copy1DRangeFromUnchecked(int n, int n2, short[] sArray) {
        InvokeDynamicSupport.bootstrap("copy1DRangeFromUnchecked", $$robo$$android_renderscript_Allocation$copy1DRangeFromUnchecked(int int short[] ), 0, this, n, n2, sArray);
    }

    public void copy1DRangeFromUnchecked(int n, int n2, byte[] byArray) {
        InvokeDynamicSupport.bootstrap("copy1DRangeFromUnchecked", $$robo$$android_renderscript_Allocation$copy1DRangeFromUnchecked(int int byte[] ), 0, this, n, n2, byArray);
    }

    public void copy1DRangeFromUnchecked(int n, int n2, float[] fArray) {
        InvokeDynamicSupport.bootstrap("copy1DRangeFromUnchecked", $$robo$$android_renderscript_Allocation$copy1DRangeFromUnchecked(int int float[] ), 0, this, n, n2, fArray);
    }

    public void copy1DRangeFrom(int n, int n2, Object object) {
        InvokeDynamicSupport.bootstrap("copy1DRangeFrom", $$robo$$android_renderscript_Allocation$copy1DRangeFrom(int int java.lang.Object ), 0, this, n, n2, object);
    }

    public void copy1DRangeFrom(int n, int n2, int[] nArray) {
        InvokeDynamicSupport.bootstrap("copy1DRangeFrom", $$robo$$android_renderscript_Allocation$copy1DRangeFrom(int int int[] ), 0, this, n, n2, nArray);
    }

    public void copy1DRangeFrom(int n, int n2, short[] sArray) {
        InvokeDynamicSupport.bootstrap("copy1DRangeFrom", $$robo$$android_renderscript_Allocation$copy1DRangeFrom(int int short[] ), 0, this, n, n2, sArray);
    }

    public void copy1DRangeFrom(int n, int n2, byte[] byArray) {
        InvokeDynamicSupport.bootstrap("copy1DRangeFrom", $$robo$$android_renderscript_Allocation$copy1DRangeFrom(int int byte[] ), 0, this, n, n2, byArray);
    }

    public void copy1DRangeFrom(int n, int n2, float[] fArray) {
        InvokeDynamicSupport.bootstrap("copy1DRangeFrom", $$robo$$android_renderscript_Allocation$copy1DRangeFrom(int int float[] ), 0, this, n, n2, fArray);
    }

    public void copy1DRangeFrom(int n, int n2, Allocation allocation, int n3) {
        InvokeDynamicSupport.bootstrap("copy1DRangeFrom", $$robo$$android_renderscript_Allocation$copy1DRangeFrom(int int android.renderscript.Allocation int ), 0, this, n, n2, allocation, n3);
    }

    private void validate2DRange(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("validate2DRange", $$robo$$android_renderscript_Allocation$validate2DRange(int int int int ), 0, this, n, n2, n3, n4);
    }

    void copy2DRangeFromUnchecked(int n, int n2, int n3, int n4, Object object, Element.DataType dataType, int n5) {
        InvokeDynamicSupport.bootstrap("copy2DRangeFromUnchecked", $$robo$$android_renderscript_Allocation$copy2DRangeFromUnchecked(int int int int java.lang.Object android.renderscript.Element$DataType int ), 0, this, n, n2, n3, n4, object, dataType, n5);
    }

    public void copy2DRangeFrom(int n, int n2, int n3, int n4, Object object) {
        InvokeDynamicSupport.bootstrap("copy2DRangeFrom", $$robo$$android_renderscript_Allocation$copy2DRangeFrom(int int int int java.lang.Object ), 0, this, n, n2, n3, n4, object);
    }

    public void copy2DRangeFrom(int n, int n2, int n3, int n4, byte[] byArray) {
        InvokeDynamicSupport.bootstrap("copy2DRangeFrom", $$robo$$android_renderscript_Allocation$copy2DRangeFrom(int int int int byte[] ), 0, this, n, n2, n3, n4, byArray);
    }

    public void copy2DRangeFrom(int n, int n2, int n3, int n4, short[] sArray) {
        InvokeDynamicSupport.bootstrap("copy2DRangeFrom", $$robo$$android_renderscript_Allocation$copy2DRangeFrom(int int int int short[] ), 0, this, n, n2, n3, n4, sArray);
    }

    public void copy2DRangeFrom(int n, int n2, int n3, int n4, int[] nArray) {
        InvokeDynamicSupport.bootstrap("copy2DRangeFrom", $$robo$$android_renderscript_Allocation$copy2DRangeFrom(int int int int int[] ), 0, this, n, n2, n3, n4, nArray);
    }

    public void copy2DRangeFrom(int n, int n2, int n3, int n4, float[] fArray) {
        InvokeDynamicSupport.bootstrap("copy2DRangeFrom", $$robo$$android_renderscript_Allocation$copy2DRangeFrom(int int int int float[] ), 0, this, n, n2, n3, n4, fArray);
    }

    public void copy2DRangeFrom(int n, int n2, int n3, int n4, Allocation allocation, int n5, int n6) {
        InvokeDynamicSupport.bootstrap("copy2DRangeFrom", $$robo$$android_renderscript_Allocation$copy2DRangeFrom(int int int int android.renderscript.Allocation int int ), 0, this, n, n2, n3, n4, allocation, n5, n6);
    }

    public void copy2DRangeFrom(int n, int n2, Bitmap bitmap) {
        InvokeDynamicSupport.bootstrap("copy2DRangeFrom", $$robo$$android_renderscript_Allocation$copy2DRangeFrom(int int android.graphics.Bitmap ), 0, this, n, n2, bitmap);
    }

    private void validate3DRange(int n, int n2, int n3, int n4, int n5, int n6) {
        InvokeDynamicSupport.bootstrap("validate3DRange", $$robo$$android_renderscript_Allocation$validate3DRange(int int int int int int ), 0, this, n, n2, n3, n4, n5, n6);
    }

    private void copy3DRangeFromUnchecked(int n, int n2, int n3, int n4, int n5, int n6, Object object, Element.DataType dataType, int n7) {
        InvokeDynamicSupport.bootstrap("copy3DRangeFromUnchecked", $$robo$$android_renderscript_Allocation$copy3DRangeFromUnchecked(int int int int int int java.lang.Object android.renderscript.Element$DataType int ), 0, this, n, n2, n3, n4, n5, n6, object, dataType, n7);
    }

    public void copy3DRangeFrom(int n, int n2, int n3, int n4, int n5, int n6, Object object) {
        InvokeDynamicSupport.bootstrap("copy3DRangeFrom", $$robo$$android_renderscript_Allocation$copy3DRangeFrom(int int int int int int java.lang.Object ), 0, this, n, n2, n3, n4, n5, n6, object);
    }

    public void copy3DRangeFrom(int n, int n2, int n3, int n4, int n5, int n6, Allocation allocation, int n7, int n8, int n9) {
        InvokeDynamicSupport.bootstrap("copy3DRangeFrom", $$robo$$android_renderscript_Allocation$copy3DRangeFrom(int int int int int int android.renderscript.Allocation int int int ), 0, this, n, n2, n3, n4, n5, n6, allocation, n7, n8, n9);
    }

    public void copyTo(Bitmap bitmap) {
        InvokeDynamicSupport.bootstrap("copyTo", $$robo$$android_renderscript_Allocation$copyTo(android.graphics.Bitmap ), 0, this, bitmap);
    }

    private void copyTo(Object object, Element.DataType dataType, int n) {
        InvokeDynamicSupport.bootstrap("copyTo", $$robo$$android_renderscript_Allocation$copyTo(java.lang.Object android.renderscript.Element$DataType int ), 0, this, object, dataType, n);
    }

    public void copyTo(Object object) {
        InvokeDynamicSupport.bootstrap("copyTo", $$robo$$android_renderscript_Allocation$copyTo(java.lang.Object ), 0, this, object);
    }

    public void copyTo(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("copyTo", $$robo$$android_renderscript_Allocation$copyTo(byte[] ), 0, this, byArray);
    }

    public void copyTo(short[] sArray) {
        InvokeDynamicSupport.bootstrap("copyTo", $$robo$$android_renderscript_Allocation$copyTo(short[] ), 0, this, sArray);
    }

    public void copyTo(int[] nArray) {
        InvokeDynamicSupport.bootstrap("copyTo", $$robo$$android_renderscript_Allocation$copyTo(int[] ), 0, this, nArray);
    }

    public void copyTo(float[] fArray) {
        InvokeDynamicSupport.bootstrap("copyTo", $$robo$$android_renderscript_Allocation$copyTo(float[] ), 0, this, fArray);
    }

    public synchronized void resize(int n) {
        InvokeDynamicSupport.bootstrap("resize", $$robo$$android_renderscript_Allocation$resize(int ), 0, this, n);
    }

    public static Allocation createTyped(RenderScript renderScript, Type type, MipmapControl mipmapControl, int n) {
        return InvokeDynamicSupport.bootstrapStatic("createTyped", $$robo$$android_renderscript_Allocation$createTyped(android.renderscript.RenderScript android.renderscript.Type android.renderscript.Allocation$MipmapControl int ), 0, (RenderScript)renderScript, (Type)type, (MipmapControl)mipmapControl, (int)n);
    }

    public static Allocation createTyped(RenderScript renderScript, Type type, int n) {
        return InvokeDynamicSupport.bootstrapStatic("createTyped", $$robo$$android_renderscript_Allocation$createTyped(android.renderscript.RenderScript android.renderscript.Type int ), 0, (RenderScript)renderScript, (Type)type, (int)n);
    }

    public static Allocation createTyped(RenderScript renderScript, Type type) {
        return InvokeDynamicSupport.bootstrapStatic("createTyped", $$robo$$android_renderscript_Allocation$createTyped(android.renderscript.RenderScript android.renderscript.Type ), 0, (RenderScript)renderScript, (Type)type);
    }

    public static Allocation createSized(RenderScript renderScript, Element element, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("createSized", $$robo$$android_renderscript_Allocation$createSized(android.renderscript.RenderScript android.renderscript.Element int int ), 0, (RenderScript)renderScript, (Element)element, (int)n, (int)n2);
    }

    public static Allocation createSized(RenderScript renderScript, Element element, int n) {
        return InvokeDynamicSupport.bootstrapStatic("createSized", $$robo$$android_renderscript_Allocation$createSized(android.renderscript.RenderScript android.renderscript.Element int ), 0, (RenderScript)renderScript, (Element)element, (int)n);
    }

    static Element elementFromBitmap(RenderScript renderScript, Bitmap bitmap) {
        return InvokeDynamicSupport.bootstrapStatic("elementFromBitmap", $$robo$$android_renderscript_Allocation$elementFromBitmap(android.renderscript.RenderScript android.graphics.Bitmap ), 0, (RenderScript)renderScript, (Bitmap)bitmap);
    }

    static Type typeFromBitmap(RenderScript renderScript, Bitmap bitmap, MipmapControl mipmapControl) {
        return InvokeDynamicSupport.bootstrapStatic("typeFromBitmap", $$robo$$android_renderscript_Allocation$typeFromBitmap(android.renderscript.RenderScript android.graphics.Bitmap android.renderscript.Allocation$MipmapControl ), 0, (RenderScript)renderScript, (Bitmap)bitmap, (MipmapControl)mipmapControl);
    }

    public static Allocation createFromBitmap(RenderScript renderScript, Bitmap bitmap, MipmapControl mipmapControl, int n) {
        return InvokeDynamicSupport.bootstrapStatic("createFromBitmap", $$robo$$android_renderscript_Allocation$createFromBitmap(android.renderscript.RenderScript android.graphics.Bitmap android.renderscript.Allocation$MipmapControl int ), 0, (RenderScript)renderScript, (Bitmap)bitmap, (MipmapControl)mipmapControl, (int)n);
    }

    public Surface getSurface() {
        return InvokeDynamicSupport.bootstrap("getSurface", $$robo$$android_renderscript_Allocation$getSurface(), 0, this);
    }

    public void setSurface(Surface surface) {
        InvokeDynamicSupport.bootstrap("setSurface", $$robo$$android_renderscript_Allocation$setSurface(android.view.Surface ), 0, this, surface);
    }

    public static Allocation createFromBitmap(RenderScript renderScript, Bitmap bitmap) {
        return InvokeDynamicSupport.bootstrapStatic("createFromBitmap", $$robo$$android_renderscript_Allocation$createFromBitmap(android.renderscript.RenderScript android.graphics.Bitmap ), 0, (RenderScript)renderScript, (Bitmap)bitmap);
    }

    public static Allocation createCubemapFromBitmap(RenderScript renderScript, Bitmap bitmap, MipmapControl mipmapControl, int n) {
        return InvokeDynamicSupport.bootstrapStatic("createCubemapFromBitmap", $$robo$$android_renderscript_Allocation$createCubemapFromBitmap(android.renderscript.RenderScript android.graphics.Bitmap android.renderscript.Allocation$MipmapControl int ), 0, (RenderScript)renderScript, (Bitmap)bitmap, (MipmapControl)mipmapControl, (int)n);
    }

    public static Allocation createCubemapFromBitmap(RenderScript renderScript, Bitmap bitmap) {
        return InvokeDynamicSupport.bootstrapStatic("createCubemapFromBitmap", $$robo$$android_renderscript_Allocation$createCubemapFromBitmap(android.renderscript.RenderScript android.graphics.Bitmap ), 0, (RenderScript)renderScript, (Bitmap)bitmap);
    }

    public static Allocation createCubemapFromCubeFaces(RenderScript renderScript, Bitmap bitmap, Bitmap bitmap2, Bitmap bitmap3, Bitmap bitmap4, Bitmap bitmap5, Bitmap bitmap6, MipmapControl mipmapControl, int n) {
        return InvokeDynamicSupport.bootstrapStatic("createCubemapFromCubeFaces", $$robo$$android_renderscript_Allocation$createCubemapFromCubeFaces(android.renderscript.RenderScript android.graphics.Bitmap android.graphics.Bitmap android.graphics.Bitmap android.graphics.Bitmap android.graphics.Bitmap android.graphics.Bitmap android.renderscript.Allocation$MipmapControl int ), 0, (RenderScript)renderScript, (Bitmap)bitmap, (Bitmap)bitmap2, (Bitmap)bitmap3, (Bitmap)bitmap4, (Bitmap)bitmap5, (Bitmap)bitmap6, (MipmapControl)mipmapControl, (int)n);
    }

    public static Allocation createCubemapFromCubeFaces(RenderScript renderScript, Bitmap bitmap, Bitmap bitmap2, Bitmap bitmap3, Bitmap bitmap4, Bitmap bitmap5, Bitmap bitmap6) {
        return InvokeDynamicSupport.bootstrapStatic("createCubemapFromCubeFaces", $$robo$$android_renderscript_Allocation$createCubemapFromCubeFaces(android.renderscript.RenderScript android.graphics.Bitmap android.graphics.Bitmap android.graphics.Bitmap android.graphics.Bitmap android.graphics.Bitmap android.graphics.Bitmap ), 0, (RenderScript)renderScript, (Bitmap)bitmap, (Bitmap)bitmap2, (Bitmap)bitmap3, (Bitmap)bitmap4, (Bitmap)bitmap5, (Bitmap)bitmap6);
    }

    public static Allocation createFromBitmapResource(RenderScript renderScript, Resources resources, int n, MipmapControl mipmapControl, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("createFromBitmapResource", $$robo$$android_renderscript_Allocation$createFromBitmapResource(android.renderscript.RenderScript android.content.res.Resources int android.renderscript.Allocation$MipmapControl int ), 0, (RenderScript)renderScript, (Resources)resources, (int)n, (MipmapControl)mipmapControl, (int)n2);
    }

    public static Allocation createFromBitmapResource(RenderScript renderScript, Resources resources, int n) {
        return InvokeDynamicSupport.bootstrapStatic("createFromBitmapResource", $$robo$$android_renderscript_Allocation$createFromBitmapResource(android.renderscript.RenderScript android.content.res.Resources int ), 0, (RenderScript)renderScript, (Resources)resources, (int)n);
    }

    public static Allocation createFromString(RenderScript renderScript, String string2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("createFromString", $$robo$$android_renderscript_Allocation$createFromString(android.renderscript.RenderScript java.lang.String int ), 0, (RenderScript)renderScript, (String)string2, (int)n);
    }

    public void setOnBufferAvailableListener(OnBufferAvailableListener onBufferAvailableListener) {
        InvokeDynamicSupport.bootstrap("setOnBufferAvailableListener", $$robo$$android_renderscript_Allocation$setOnBufferAvailableListener(android.renderscript.Allocation$OnBufferAvailableListener ), 0, this, onBufferAvailableListener);
    }

    static void sendBufferNotification(long l) {
        InvokeDynamicSupport.bootstrapStatic("sendBufferNotification", $$robo$$android_renderscript_Allocation$sendBufferNotification(long ), 0, (long)l);
    }

    static {
        RobolectricInternals.classInitializing(Allocation.class);
    }

    public /* synthetic */ Allocation() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Allocation)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class 1
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static /* synthetic */ int[] $SwitchMap$android$graphics$Bitmap$Config;

        static void __staticInitializer__() {
            $SwitchMap$android$graphics$Bitmap$Config = new int[Bitmap.Config.values().length];
            try {
                1.$SwitchMap$android$graphics$Bitmap$Config[Bitmap.Config.ALPHA_8.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$android$graphics$Bitmap$Config[Bitmap.Config.ARGB_8888.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$android$graphics$Bitmap$Config[Bitmap.Config.RGB_565.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$android$graphics$Bitmap$Config[Bitmap.Config.ARGB_4444.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }

        static {
            RobolectricInternals.classInitializing(1.class);
        }

        public /* synthetic */ 1() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (1)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnBufferAvailableListener
    extends InstrumentedInterface {
        public void onBufferAvailable(Allocation var1);
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class MipmapControl
    extends Enum<MipmapControl> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ MipmapControl MIPMAP_NONE;
        public static /* enum */ MipmapControl MIPMAP_FULL;
        public static /* enum */ MipmapControl MIPMAP_ON_SYNC_TO_TEXTURE;
        int mID;
        private static /* synthetic */ MipmapControl[] $VALUES;

        private static final MipmapControl[] $$robo$$android_renderscript_Allocation_MipmapControl$values() {
            return (MipmapControl[])$VALUES.clone();
        }

        private static final MipmapControl $$robo$$android_renderscript_Allocation_MipmapControl$valueOf(String name) {
            return Enum.valueOf(MipmapControl.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_renderscript_Allocation_MipmapControl$__constructor__(String string2, int n, int id2) {
            this.mID = id2;
        }

        static void __staticInitializer__() {
            MIPMAP_NONE = new MipmapControl(0);
            MIPMAP_FULL = new MipmapControl(1);
            MIPMAP_ON_SYNC_TO_TEXTURE = new MipmapControl(2);
            $VALUES = new MipmapControl[]{MIPMAP_NONE, MIPMAP_FULL, MIPMAP_ON_SYNC_TO_TEXTURE};
        }

        public static MipmapControl[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_renderscript_Allocation_MipmapControl$values(), 0);
        }

        public static MipmapControl valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_renderscript_Allocation_MipmapControl$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_renderscript_Allocation_MipmapControl$__constructor__(string2, n, n2);
        }

        private MipmapControl(int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_renderscript_Allocation_MipmapControl$__constructor__(java.lang.String int int ), 0, this, string2, n, n2);
        }

        static {
            RobolectricInternals.classInitializing(MipmapControl.class);
        }

        public /* synthetic */ MipmapControl() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MipmapControl)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

