/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.content.res.AssetManager;
import android.content.res.Resources;
import android.os.Environment;
import android.renderscript.BaseObj;
import android.renderscript.RSRuntimeException;
import android.renderscript.RenderScript;
import com.google.errorprone.annotations.DoNotMock;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Font
extends BaseObj
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String[] sSansNames;
    private static String[] sSerifNames;
    private static String[] sMonoNames;
    private static Map<String, FontFamily> sFontFamilyMap;

    private static final void $$robo$$android_renderscript_Font$addFamilyToMap(FontFamily family) {
        for (int i = 0; i < family.mNames.length; ++i) {
            sFontFamilyMap.put(family.mNames[i], family);
        }
    }

    private static final void $$robo$$android_renderscript_Font$initFontFamilyMap() {
        sFontFamilyMap = new HashMap<String, FontFamily>();
        FontFamily sansFamily = new FontFamily();
        sansFamily.mNames = sSansNames;
        sansFamily.mNormalFileName = "Roboto-Regular.ttf";
        sansFamily.mBoldFileName = "Roboto-Bold.ttf";
        sansFamily.mItalicFileName = "Roboto-Italic.ttf";
        sansFamily.mBoldItalicFileName = "Roboto-BoldItalic.ttf";
        Font.addFamilyToMap(sansFamily);
        FontFamily serifFamily = new FontFamily();
        serifFamily.mNames = sSerifNames;
        serifFamily.mNormalFileName = "NotoSerif-Regular.ttf";
        serifFamily.mBoldFileName = "NotoSerif-Bold.ttf";
        serifFamily.mItalicFileName = "NotoSerif-Italic.ttf";
        serifFamily.mBoldItalicFileName = "NotoSerif-BoldItalic.ttf";
        Font.addFamilyToMap(serifFamily);
        FontFamily monoFamily = new FontFamily();
        monoFamily.mNames = sMonoNames;
        monoFamily.mNormalFileName = "DroidSansMono.ttf";
        monoFamily.mBoldFileName = "DroidSansMono.ttf";
        monoFamily.mItalicFileName = "DroidSansMono.ttf";
        monoFamily.mBoldItalicFileName = "DroidSansMono.ttf";
        Font.addFamilyToMap(monoFamily);
    }

    private static final String $$robo$$android_renderscript_Font$getFontFileName(String familyName, Style style2) {
        FontFamily family = sFontFamilyMap.get(familyName);
        if (family != null) {
            switch (1.$SwitchMap$android$renderscript$Font$Style[style2.ordinal()]) {
                case 1: {
                    return family.mNormalFileName;
                }
                case 2: {
                    return family.mBoldFileName;
                }
                case 3: {
                    return family.mItalicFileName;
                }
                case 4: {
                    return family.mBoldItalicFileName;
                }
            }
        }
        return "DroidSans.ttf";
    }

    private void $$robo$$android_renderscript_Font$__constructor__(long id2, RenderScript rs) {
    }

    private static final Font $$robo$$android_renderscript_Font$createFromFile(RenderScript rs, Resources res, String path, float pointSize) {
        rs.validate();
        int dpi = res.getDisplayMetrics().densityDpi;
        long fontId = rs.nFontCreateFromFile(path, pointSize, dpi);
        if (fontId == 0L) {
            throw new RSRuntimeException("Unable to create font from file " + path);
        }
        Font rsFont = new Font(fontId, rs);
        return rsFont;
    }

    private static final Font $$robo$$android_renderscript_Font$createFromFile(RenderScript rs, Resources res, File path, float pointSize) {
        return Font.createFromFile(rs, res, path.getAbsolutePath(), pointSize);
    }

    private static final Font $$robo$$android_renderscript_Font$createFromAsset(RenderScript rs, Resources res, String path, float pointSize) {
        rs.validate();
        AssetManager mgr = res.getAssets();
        int dpi = res.getDisplayMetrics().densityDpi;
        long fontId = rs.nFontCreateFromAsset(mgr, path, pointSize, dpi);
        if (fontId == 0L) {
            throw new RSRuntimeException("Unable to create font from asset " + path);
        }
        Font rsFont = new Font(fontId, rs);
        return rsFont;
    }

    private static final Font $$robo$$android_renderscript_Font$createFromResource(RenderScript rs, Resources res, int id2, float pointSize) {
        String name = "R." + Integer.toString(id2);
        rs.validate();
        InputStream is = null;
        try {
            is = res.openRawResource(id2);
        }
        catch (Exception e) {
            throw new RSRuntimeException("Unable to open resource " + id2);
        }
        int dpi = res.getDisplayMetrics().densityDpi;
        long fontId = 0L;
        if (!(is instanceof AssetManager.AssetInputStream)) {
            throw new RSRuntimeException("Unsupported asset stream created");
        }
        long asset = ((AssetManager.AssetInputStream)is).getNativeAsset();
        fontId = rs.nFontCreateFromAssetStream(name, pointSize, dpi, asset);
        if (fontId == 0L) {
            throw new RSRuntimeException("Unable to create font from resource " + id2);
        }
        Font rsFont = new Font(fontId, rs);
        return rsFont;
    }

    private static final Font $$robo$$android_renderscript_Font$create(RenderScript rs, Resources res, String familyName, Style fontStyle, float pointSize) {
        String fileName = Font.getFontFileName(familyName, fontStyle);
        String fontPath = Environment.getRootDirectory().getAbsolutePath();
        fontPath = fontPath + "/fonts/" + fileName;
        return Font.createFromFile(rs, res, fontPath, pointSize);
    }

    static void __staticInitializer__() {
        sSansNames = new String[]{"sans-serif", "arial", "helvetica", "tahoma", "verdana"};
        sSerifNames = new String[]{"serif", "times", "times new roman", "palatino", "georgia", "baskerville", "goudy", "fantasy", "cursive", "ITC Stone Serif"};
        sMonoNames = new String[]{"monospace", "courier", "courier new", "monaco"};
        Font.initFontFamilyMap();
    }

    private static void addFamilyToMap(FontFamily fontFamily) {
        InvokeDynamicSupport.bootstrapStatic("addFamilyToMap", $$robo$$android_renderscript_Font$addFamilyToMap(android.renderscript.Font$FontFamily ), 0, (FontFamily)fontFamily);
    }

    private static void initFontFamilyMap() {
        InvokeDynamicSupport.bootstrapStatic("initFontFamilyMap", $$robo$$android_renderscript_Font$initFontFamilyMap(), 0);
    }

    static String getFontFileName(String string2, Style style2) {
        return InvokeDynamicSupport.bootstrapStatic("getFontFileName", $$robo$$android_renderscript_Font$getFontFileName(java.lang.String android.renderscript.Font$Style ), 0, (String)string2, (Style)style2);
    }

    private void __constructor__(long l, RenderScript renderScript) {
        this.$$robo$$android_renderscript_Font$__constructor__(l, renderScript);
    }

    Font(long l, RenderScript renderScript) {
        super(l, renderScript);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_renderscript_Font$__constructor__(long android.renderscript.RenderScript ), 0, this, l, renderScript);
    }

    public static Font createFromFile(RenderScript renderScript, Resources resources, String string2, float f) {
        return InvokeDynamicSupport.bootstrapStatic("createFromFile", $$robo$$android_renderscript_Font$createFromFile(android.renderscript.RenderScript android.content.res.Resources java.lang.String float ), 0, (RenderScript)renderScript, (Resources)resources, (String)string2, (float)f);
    }

    public static Font createFromFile(RenderScript renderScript, Resources resources, File file, float f) {
        return InvokeDynamicSupport.bootstrapStatic("createFromFile", $$robo$$android_renderscript_Font$createFromFile(android.renderscript.RenderScript android.content.res.Resources java.io.File float ), 0, (RenderScript)renderScript, (Resources)resources, (File)file, (float)f);
    }

    public static Font createFromAsset(RenderScript renderScript, Resources resources, String string2, float f) {
        return InvokeDynamicSupport.bootstrapStatic("createFromAsset", $$robo$$android_renderscript_Font$createFromAsset(android.renderscript.RenderScript android.content.res.Resources java.lang.String float ), 0, (RenderScript)renderScript, (Resources)resources, (String)string2, (float)f);
    }

    public static Font createFromResource(RenderScript renderScript, Resources resources, int n, float f) {
        return InvokeDynamicSupport.bootstrapStatic("createFromResource", $$robo$$android_renderscript_Font$createFromResource(android.renderscript.RenderScript android.content.res.Resources int float ), 0, (RenderScript)renderScript, (Resources)resources, (int)n, (float)f);
    }

    public static Font create(RenderScript renderScript, Resources resources, String string2, Style style2, float f) {
        return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_renderscript_Font$create(android.renderscript.RenderScript android.content.res.Resources java.lang.String android.renderscript.Font$Style float ), 0, (RenderScript)renderScript, (Resources)resources, (String)string2, (Style)style2, (float)f);
    }

    static {
        RobolectricInternals.classInitializing(Font.class);
    }

    public /* synthetic */ Font() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Font)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Style
    extends Enum<Style> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ Style NORMAL;
        public static /* enum */ Style BOLD;
        public static /* enum */ Style ITALIC;
        public static /* enum */ Style BOLD_ITALIC;
        private static /* synthetic */ Style[] $VALUES;

        private static final Style[] $$robo$$android_renderscript_Font_Style$values() {
            return (Style[])$VALUES.clone();
        }

        private static final Style $$robo$$android_renderscript_Font_Style$valueOf(String name) {
            return Enum.valueOf(Style.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_renderscript_Font_Style$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            NORMAL = new Style();
            BOLD = new Style();
            ITALIC = new Style();
            BOLD_ITALIC = new Style();
            $VALUES = new Style[]{NORMAL, BOLD, ITALIC, BOLD_ITALIC};
        }

        public static Style[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_renderscript_Font_Style$values(), 0);
        }

        public static Style valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_renderscript_Font_Style$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_renderscript_Font_Style$__constructor__(string2, n);
        }

        private Style() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_renderscript_Font_Style$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(Style.class);
        }

        public /* synthetic */ Style() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Style)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class FontFamily
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        String[] mNames;
        String mNormalFileName;
        String mBoldFileName;
        String mItalicFileName;
        String mBoldItalicFileName;

        private void $$robo$$android_renderscript_Font_FontFamily$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_renderscript_Font_FontFamily$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_renderscript_Font_FontFamily$__constructor__();
        }

        private FontFamily() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_renderscript_Font_FontFamily$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_renderscript_Font_FontFamily$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FontFamily)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

