/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.os.RemoteException;
import android.os.ServiceManager;
import android.security.IKeystoreService;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class KeyStore
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "KeyStore";
    public static int NO_ERROR = 1;
    public static int LOCKED = 2;
    public static int UNINITIALIZED = 3;
    public static int SYSTEM_ERROR = 4;
    public static int PROTOCOL_ERROR = 5;
    public static int PERMISSION_DENIED = 6;
    public static int KEY_NOT_FOUND = 7;
    public static int VALUE_CORRUPTED = 8;
    public static int UNDEFINED_ACTION = 9;
    public static int WRONG_PASSWORD = 10;
    public static int UID_SELF = -1;
    public static int FLAG_NONE = 0;
    public static int FLAG_ENCRYPTED = 1;
    private int mError;
    private IKeystoreService mBinder;

    private void $$robo$$android_security_KeyStore$__constructor__(IKeystoreService binder) {
        this.mError = 1;
        this.mBinder = binder;
    }

    private static final KeyStore $$robo$$android_security_KeyStore$getInstance() {
        IKeystoreService keystore = IKeystoreService.Stub.asInterface(ServiceManager.getService("android.security.keystore"));
        return new KeyStore(keystore);
    }

    private static final int $$robo$$android_security_KeyStore$getKeyTypeForAlgorithm(String keyType) throws IllegalArgumentException {
        if ("RSA".equalsIgnoreCase(keyType)) {
            return 6;
        }
        if ("DSA".equalsIgnoreCase(keyType)) {
            return 116;
        }
        if ("EC".equalsIgnoreCase(keyType)) {
            return 408;
        }
        throw new IllegalArgumentException("Unsupported key type: " + keyType);
    }

    private final State $$robo$$android_security_KeyStore$state() {
        int ret;
        try {
            ret = this.mBinder.test();
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            throw new AssertionError((Object)e);
        }
        switch (ret) {
            case 1: {
                return State.UNLOCKED;
            }
            case 2: {
                return State.LOCKED;
            }
            case 3: {
                return State.UNINITIALIZED;
            }
        }
        throw new AssertionError(this.mError);
    }

    private final boolean $$robo$$android_security_KeyStore$isUnlocked() {
        return this.state() == State.UNLOCKED;
    }

    private final byte[] $$robo$$android_security_KeyStore$get(String key) {
        try {
            return this.mBinder.get(key);
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return null;
        }
    }

    private final boolean $$robo$$android_security_KeyStore$put(String key, byte[] value, int uid, int flags) {
        try {
            return this.mBinder.insert(key, value, uid, flags) == 1;
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return false;
        }
    }

    private final boolean $$robo$$android_security_KeyStore$delete(String key, int uid) {
        try {
            return this.mBinder.del(key, uid) == 1;
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return false;
        }
    }

    private final boolean $$robo$$android_security_KeyStore$delete(String key) {
        return this.delete(key, -1);
    }

    private final boolean $$robo$$android_security_KeyStore$contains(String key, int uid) {
        try {
            return this.mBinder.exist(key, uid) == 1;
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return false;
        }
    }

    private final boolean $$robo$$android_security_KeyStore$contains(String key) {
        return this.contains(key, -1);
    }

    private final String[] $$robo$$android_security_KeyStore$saw(String prefix, int uid) {
        try {
            return this.mBinder.saw(prefix, uid);
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return null;
        }
    }

    private final String[] $$robo$$android_security_KeyStore$saw(String prefix) {
        return this.saw(prefix, -1);
    }

    private final boolean $$robo$$android_security_KeyStore$reset() {
        try {
            return this.mBinder.reset() == 1;
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return false;
        }
    }

    private final boolean $$robo$$android_security_KeyStore$password(String password) {
        try {
            return this.mBinder.password(password) == 1;
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return false;
        }
    }

    private final boolean $$robo$$android_security_KeyStore$lock() {
        try {
            return this.mBinder.lock() == 1;
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return false;
        }
    }

    private final boolean $$robo$$android_security_KeyStore$unlock(String password) {
        try {
            this.mError = this.mBinder.unlock(password);
            return this.mError == 1;
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return false;
        }
    }

    private final boolean $$robo$$android_security_KeyStore$isEmpty() {
        try {
            return this.mBinder.zero() == 7;
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return false;
        }
    }

    private final boolean $$robo$$android_security_KeyStore$generate(String key, int uid, int keyType, int keySize, int flags, byte[][] args) {
        try {
            return this.mBinder.generate(key, uid, keyType, keySize, flags, args) == 1;
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return false;
        }
    }

    private final boolean $$robo$$android_security_KeyStore$importKey(String keyName, byte[] key, int uid, int flags) {
        try {
            return this.mBinder.import_key(keyName, key, uid, flags) == 1;
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return false;
        }
    }

    private final byte[] $$robo$$android_security_KeyStore$getPubkey(String key) {
        try {
            return this.mBinder.get_pubkey(key);
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return null;
        }
    }

    private final boolean $$robo$$android_security_KeyStore$delKey(String key, int uid) {
        try {
            return this.mBinder.del_key(key, uid) == 1;
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return false;
        }
    }

    private final boolean $$robo$$android_security_KeyStore$delKey(String key) {
        return this.delKey(key, -1);
    }

    private final byte[] $$robo$$android_security_KeyStore$sign(String key, byte[] data) {
        try {
            return this.mBinder.sign(key, data);
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return null;
        }
    }

    private final boolean $$robo$$android_security_KeyStore$verify(String key, byte[] data, byte[] signature) {
        try {
            return this.mBinder.verify(key, data, signature) == 1;
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return false;
        }
    }

    private final boolean $$robo$$android_security_KeyStore$grant(String key, int uid) {
        try {
            return this.mBinder.grant(key, uid) == 1;
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return false;
        }
    }

    private final boolean $$robo$$android_security_KeyStore$ungrant(String key, int uid) {
        try {
            return this.mBinder.ungrant(key, uid) == 1;
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return false;
        }
    }

    private final long $$robo$$android_security_KeyStore$getmtime(String key) {
        try {
            long millis = this.mBinder.getmtime(key);
            if (millis == -1L) {
                return -1L;
            }
            return millis * 1000L;
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return -1L;
        }
    }

    private final boolean $$robo$$android_security_KeyStore$duplicate(String srcKey, int srcUid, String destKey, int destUid) {
        try {
            return this.mBinder.duplicate(srcKey, srcUid, destKey, destUid) == 1;
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return false;
        }
    }

    private final boolean $$robo$$android_security_KeyStore$isHardwareBacked() {
        return this.isHardwareBacked("RSA");
    }

    private final boolean $$robo$$android_security_KeyStore$isHardwareBacked(String keyType) {
        try {
            return this.mBinder.is_hardware_backed(keyType.toUpperCase(Locale.US)) == 1;
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return false;
        }
    }

    private final boolean $$robo$$android_security_KeyStore$clearUid(int uid) {
        try {
            return this.mBinder.clear_uid(uid) == 1;
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return false;
        }
    }

    private final boolean $$robo$$android_security_KeyStore$resetUid(int uid) {
        try {
            this.mError = this.mBinder.reset_uid(uid);
            return this.mError == 1;
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return false;
        }
    }

    private final boolean $$robo$$android_security_KeyStore$syncUid(int sourceUid, int targetUid) {
        try {
            this.mError = this.mBinder.sync_uid(sourceUid, targetUid);
            return this.mError == 1;
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return false;
        }
    }

    private final boolean $$robo$$android_security_KeyStore$passwordUid(String password, int uid) {
        try {
            this.mError = this.mBinder.password_uid(password, uid);
            return this.mError == 1;
        }
        catch (RemoteException e) {
            Log.w("KeyStore", "Cannot connect to keystore", e);
            return false;
        }
    }

    private final int $$robo$$android_security_KeyStore$getLastError() {
        return this.mError;
    }

    private void __constructor__(IKeystoreService iKeystoreService) {
        this.$$robo$$android_security_KeyStore$__constructor__(iKeystoreService);
    }

    private KeyStore(IKeystoreService iKeystoreService) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_KeyStore$__constructor__(android.security.IKeystoreService ), 0, this, iKeystoreService);
    }

    public static KeyStore getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_security_KeyStore$getInstance(), 0);
    }

    static int getKeyTypeForAlgorithm(String string2) throws IllegalArgumentException {
        return (int)InvokeDynamicSupport.bootstrapStatic("getKeyTypeForAlgorithm", $$robo$$android_security_KeyStore$getKeyTypeForAlgorithm(java.lang.String ), 0, (String)string2);
    }

    public State state() {
        return InvokeDynamicSupport.bootstrap("state", $$robo$$android_security_KeyStore$state(), 0, this);
    }

    public boolean isUnlocked() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUnlocked", $$robo$$android_security_KeyStore$isUnlocked(), 0, this);
    }

    public byte[] get(String string2) {
        return InvokeDynamicSupport.bootstrap("get", $$robo$$android_security_KeyStore$get(java.lang.String ), 0, this, string2);
    }

    public boolean put(String string2, byte[] byArray, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("put", $$robo$$android_security_KeyStore$put(java.lang.String byte[] int int ), 0, this, string2, byArray, n, n2);
    }

    public boolean delete(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("delete", $$robo$$android_security_KeyStore$delete(java.lang.String int ), 0, this, string2, n);
    }

    public boolean delete(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("delete", $$robo$$android_security_KeyStore$delete(java.lang.String ), 0, this, string2);
    }

    public boolean contains(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("contains", $$robo$$android_security_KeyStore$contains(java.lang.String int ), 0, this, string2, n);
    }

    public boolean contains(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("contains", $$robo$$android_security_KeyStore$contains(java.lang.String ), 0, this, string2);
    }

    public String[] saw(String string2, int n) {
        return InvokeDynamicSupport.bootstrap("saw", $$robo$$android_security_KeyStore$saw(java.lang.String int ), 0, this, string2, n);
    }

    public String[] saw(String string2) {
        return InvokeDynamicSupport.bootstrap("saw", $$robo$$android_security_KeyStore$saw(java.lang.String ), 0, this, string2);
    }

    public boolean reset() {
        return (boolean)InvokeDynamicSupport.bootstrap("reset", $$robo$$android_security_KeyStore$reset(), 0, this);
    }

    public boolean password(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("password", $$robo$$android_security_KeyStore$password(java.lang.String ), 0, this, string2);
    }

    public boolean lock() {
        return (boolean)InvokeDynamicSupport.bootstrap("lock", $$robo$$android_security_KeyStore$lock(), 0, this);
    }

    public boolean unlock(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("unlock", $$robo$$android_security_KeyStore$unlock(java.lang.String ), 0, this, string2);
    }

    public boolean isEmpty() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$android_security_KeyStore$isEmpty(), 0, this);
    }

    public boolean generate(String string2, int n, int n2, int n3, int n4, byte[][] byArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("generate", $$robo$$android_security_KeyStore$generate(java.lang.String int int int int byte[][] ), 0, this, string2, n, n2, n3, n4, byArray);
    }

    public boolean importKey(String string2, byte[] byArray, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("importKey", $$robo$$android_security_KeyStore$importKey(java.lang.String byte[] int int ), 0, this, string2, byArray, n, n2);
    }

    public byte[] getPubkey(String string2) {
        return InvokeDynamicSupport.bootstrap("getPubkey", $$robo$$android_security_KeyStore$getPubkey(java.lang.String ), 0, this, string2);
    }

    public boolean delKey(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("delKey", $$robo$$android_security_KeyStore$delKey(java.lang.String int ), 0, this, string2, n);
    }

    public boolean delKey(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("delKey", $$robo$$android_security_KeyStore$delKey(java.lang.String ), 0, this, string2);
    }

    public byte[] sign(String string2, byte[] byArray) {
        return InvokeDynamicSupport.bootstrap("sign", $$robo$$android_security_KeyStore$sign(java.lang.String byte[] ), 0, this, string2, byArray);
    }

    public boolean verify(String string2, byte[] byArray, byte[] byArray2) {
        return (boolean)InvokeDynamicSupport.bootstrap("verify", $$robo$$android_security_KeyStore$verify(java.lang.String byte[] byte[] ), 0, this, string2, byArray, byArray2);
    }

    public boolean grant(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("grant", $$robo$$android_security_KeyStore$grant(java.lang.String int ), 0, this, string2, n);
    }

    public boolean ungrant(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("ungrant", $$robo$$android_security_KeyStore$ungrant(java.lang.String int ), 0, this, string2, n);
    }

    public long getmtime(String string2) {
        return (long)InvokeDynamicSupport.bootstrap("getmtime", $$robo$$android_security_KeyStore$getmtime(java.lang.String ), 0, this, string2);
    }

    public boolean duplicate(String string2, int n, String string3, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("duplicate", $$robo$$android_security_KeyStore$duplicate(java.lang.String int java.lang.String int ), 0, this, string2, n, string3, n2);
    }

    public boolean isHardwareBacked() {
        return (boolean)InvokeDynamicSupport.bootstrap("isHardwareBacked", $$robo$$android_security_KeyStore$isHardwareBacked(), 0, this);
    }

    public boolean isHardwareBacked(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isHardwareBacked", $$robo$$android_security_KeyStore$isHardwareBacked(java.lang.String ), 0, this, string2);
    }

    public boolean clearUid(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("clearUid", $$robo$$android_security_KeyStore$clearUid(int ), 0, this, n);
    }

    public boolean resetUid(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("resetUid", $$robo$$android_security_KeyStore$resetUid(int ), 0, this, n);
    }

    public boolean syncUid(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("syncUid", $$robo$$android_security_KeyStore$syncUid(int int ), 0, this, n, n2);
    }

    public boolean passwordUid(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("passwordUid", $$robo$$android_security_KeyStore$passwordUid(java.lang.String int ), 0, this, string2, n);
    }

    public int getLastError() {
        return (int)InvokeDynamicSupport.bootstrap("getLastError", $$robo$$android_security_KeyStore$getLastError(), 0, this);
    }

    public /* synthetic */ KeyStore() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeyStore)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class State
    extends Enum<State> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ State UNLOCKED;
        public static /* enum */ State LOCKED;
        public static /* enum */ State UNINITIALIZED;
        private static /* synthetic */ State[] $VALUES;

        private static final State[] $$robo$$android_security_KeyStore_State$values() {
            return (State[])$VALUES.clone();
        }

        private static final State $$robo$$android_security_KeyStore_State$valueOf(String name) {
            return Enum.valueOf(State.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_security_KeyStore_State$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            UNLOCKED = new State();
            LOCKED = new State();
            UNINITIALIZED = new State();
            $VALUES = new State[]{UNLOCKED, LOCKED, UNINITIALIZED};
        }

        public static State[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_security_KeyStore_State$values(), 0);
        }

        public static State valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_security_KeyStore_State$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_security_KeyStore_State$__constructor__(string2, n);
        }

        private State() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_KeyStore_State$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(State.class);
        }

        public /* synthetic */ State() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (State)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

