/*
 * Decompiled with CFR 0.152.
 */
package android.service.fingerprint;

import android.app.ActivityManagerNative;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.provider.Settings;
import android.service.fingerprint.FingerprintManagerReceiver;
import android.service.fingerprint.FingerprintUtils;
import android.service.fingerprint.IFingerprintService;
import android.service.fingerprint.IFingerprintServiceReceiver;
import android.util.Log;
import android.util.Slog;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class FingerprintManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "FingerprintManager";
    private static boolean DEBUG = true;
    private static int MSG_ENROLL_RESULT = 100;
    private static int MSG_ACQUIRED = 101;
    private static int MSG_PROCESSED = 102;
    private static int MSG_ERROR = 103;
    private static int MSG_REMOVED = 104;
    public static int FINGERPRINT_ERROR_NO_RECEIVER = -10;
    public static int FINGERPRINT_ERROR = -1;
    public static int FINGERPRINT_ACQUIRED = 1;
    public static int FINGERPRINT_PROCESSED = 2;
    public static int FINGERPRINT_TEMPLATE_ENROLLING = 3;
    public static int FINGERPRINT_TEMPLATE_REMOVED = 4;
    public static int FINGERPRINT_ERROR_HW_UNAVAILABLE = 1;
    public static int FINGERPRINT_ERROR_UNABLE_TO_PROCESS = 2;
    public static int FINGERPRINT_ERROR_TIMEOUT = 3;
    public static int FINGERPRINT_ERROR_NO_SPACE = 4;
    public static int FINGERPRINT_ACQUIRED_GOOD = 0;
    public static int FINGERPRINT_ACQUIRED_PARTIAL = 1;
    public static int FINGERPRINT_ACQUIRED_INSUFFICIENT = 2;
    public static int FINGERPRINT_ACQUIRED_IMAGER_DIRTY = 4;
    public static int FINGERPRINT_ACQUIRED_TOO_SLOW = 8;
    public static int FINGERPRINT_ACQUIRED_TOO_FAST = 16;
    private IFingerprintService mService;
    private FingerprintManagerReceiver mClientReceiver;
    private Context mContext;
    private IBinder mToken;
    private Handler mHandler;
    private IFingerprintServiceReceiver mServiceReceiver;

    private void $$robo$$android_service_fingerprint_FingerprintManager$__constructor__(Context context, IFingerprintService service) {
        this.mToken = new Binder();
        this.mHandler = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ FingerprintManager this$0;

            private void $$robo$$android_service_fingerprint_FingerprintManager_1$__constructor__(FingerprintManager fingerprintManager) {
            }

            private final void $$robo$$android_service_fingerprint_FingerprintManager_1$handleMessage(Message msg) {
                if (this.this$0.mClientReceiver != null) {
                    switch (msg.what) {
                        case 100: {
                            this.this$0.mClientReceiver.onEnrollResult(msg.arg1, msg.arg2);
                            break;
                        }
                        case 101: {
                            this.this$0.mClientReceiver.onAcquired(msg.arg1);
                            break;
                        }
                        case 102: {
                            this.this$0.mClientReceiver.onProcessed(msg.arg1);
                            break;
                        }
                        case 103: {
                            this.this$0.mClientReceiver.onError(msg.arg1);
                            break;
                        }
                        case 104: {
                            this.this$0.mClientReceiver.onRemoved(msg.arg1);
                        }
                    }
                }
            }

            private void __constructor__(FingerprintManager fingerprintManager) {
                this.$$robo$$android_service_fingerprint_FingerprintManager_1$__constructor__(fingerprintManager);
            }
            {
                this.this$0 = fingerprintManager;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_fingerprint_FingerprintManager_1$__constructor__(android.service.fingerprint.FingerprintManager ), 0, this, fingerprintManager);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_service_fingerprint_FingerprintManager_1$handleMessage(android.os.Message ), 0, this, message);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mServiceReceiver = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ FingerprintManager this$0;

            private void $$robo$$android_service_fingerprint_FingerprintManager_2$__constructor__(FingerprintManager fingerprintManager) {
            }

            private final void $$robo$$android_service_fingerprint_FingerprintManager_2$onEnrollResult(int fingerprintId, int remaining) {
                this.this$0.mHandler.obtainMessage(100, fingerprintId, remaining).sendToTarget();
            }

            private final void $$robo$$android_service_fingerprint_FingerprintManager_2$onAcquired(int acquireInfo) {
                this.this$0.mHandler.obtainMessage(101, acquireInfo, 0).sendToTarget();
            }

            private final void $$robo$$android_service_fingerprint_FingerprintManager_2$onProcessed(int fingerprintId) {
                this.this$0.mHandler.obtainMessage(102, fingerprintId, 0).sendToTarget();
            }

            private final void $$robo$$android_service_fingerprint_FingerprintManager_2$onError(int error) {
                this.this$0.mHandler.obtainMessage(103, error, 0).sendToTarget();
            }

            private final void $$robo$$android_service_fingerprint_FingerprintManager_2$onRemoved(int fingerprintId) {
                this.this$0.mHandler.obtainMessage(104, fingerprintId, 0).sendToTarget();
            }

            private void __constructor__(FingerprintManager fingerprintManager) {
                this.$$robo$$android_service_fingerprint_FingerprintManager_2$__constructor__(fingerprintManager);
            }
            {
                this.this$0 = fingerprintManager;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_fingerprint_FingerprintManager_2$__constructor__(android.service.fingerprint.FingerprintManager ), 0, this, fingerprintManager);
            }

            @Override
            public void onEnrollResult(int n, int n2) {
                InvokeDynamicSupport.bootstrap("onEnrollResult", $$robo$$android_service_fingerprint_FingerprintManager_2$onEnrollResult(int int ), 0, this, n, n2);
            }

            @Override
            public void onAcquired(int n) {
                InvokeDynamicSupport.bootstrap("onAcquired", $$robo$$android_service_fingerprint_FingerprintManager_2$onAcquired(int ), 0, this, n);
            }

            @Override
            public void onProcessed(int n) {
                InvokeDynamicSupport.bootstrap("onProcessed", $$robo$$android_service_fingerprint_FingerprintManager_2$onProcessed(int ), 0, this, n);
            }

            @Override
            public void onError(int n) {
                InvokeDynamicSupport.bootstrap("onError", $$robo$$android_service_fingerprint_FingerprintManager_2$onError(int ), 0, this, n);
            }

            @Override
            public void onRemoved(int n) {
                InvokeDynamicSupport.bootstrap("onRemoved", $$robo$$android_service_fingerprint_FingerprintManager_2$onRemoved(int ), 0, this, n);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mService = service;
        if (this.mService == null) {
            Slog.v("FingerprintManager", "FingerprintManagerService was null");
        }
    }

    private final boolean $$robo$$android_service_fingerprint_FingerprintManager$enrolledAndEnabled() {
        ContentResolver res = this.mContext.getContentResolver();
        return Settings.Secure.getInt(res, "fingerprint_enabled", 0) != 0 && FingerprintUtils.getFingerprintIdsForUser(res, this.getCurrentUserId()).length > 0;
    }

    private final void $$robo$$android_service_fingerprint_FingerprintManager$enroll(long timeout) {
        if (this.mServiceReceiver == null) {
            this.sendError(-10, 0, 0);
            return;
        }
        if (this.mService != null) {
            try {
                this.mService.enroll(this.mToken, timeout, this.getCurrentUserId());
            }
            catch (RemoteException e) {
                Log.v("FingerprintManager", "Remote exception while enrolling: ", e);
                this.sendError(1, 0, 0);
            }
        }
    }

    private final void $$robo$$android_service_fingerprint_FingerprintManager$remove(int fingerprintId) {
        if (this.mServiceReceiver == null) {
            this.sendError(-10, 0, 0);
            return;
        }
        if (this.mService != null) {
            try {
                this.mService.remove(this.mToken, fingerprintId, this.getCurrentUserId());
            }
            catch (RemoteException e) {
                Log.v("FingerprintManager", "Remote exception during remove of fingerprintId: " + fingerprintId, e);
            }
        } else {
            Log.w("FingerprintManager", "remove(): Service not connected!");
            this.sendError(1, 0, 0);
        }
    }

    private final void $$robo$$android_service_fingerprint_FingerprintManager$startListening(FingerprintManagerReceiver receiver) {
        this.mClientReceiver = receiver;
        if (this.mService != null) {
            try {
                this.mService.startListening(this.mToken, this.mServiceReceiver, this.getCurrentUserId());
            }
            catch (RemoteException e) {
                Log.v("FingerprintManager", "Remote exception in startListening(): ", e);
            }
        } else {
            Log.w("FingerprintManager", "startListening(): Service not connected!");
            this.sendError(1, 0, 0);
        }
    }

    private final int $$robo$$android_service_fingerprint_FingerprintManager$getCurrentUserId() {
        try {
            return ActivityManagerNative.getDefault().getCurrentUser().id;
        }
        catch (RemoteException e) {
            Log.w("FingerprintManager", "Failed to get current user id\n");
            return -10000;
        }
    }

    private final void $$robo$$android_service_fingerprint_FingerprintManager$stopListening() {
        if (this.mService != null) {
            try {
                this.mService.stopListening(this.mToken, this.getCurrentUserId());
                this.mClientReceiver = null;
            }
            catch (RemoteException e) {
                Log.v("FingerprintManager", "Remote exception in stopListening(): ", e);
            }
        } else {
            Log.w("FingerprintManager", "stopListening(): Service not connected!");
            this.sendError(1, 0, 0);
        }
    }

    private final void $$robo$$android_service_fingerprint_FingerprintManager$enrollCancel() {
        if (this.mServiceReceiver == null) {
            this.sendError(-10, 0, 0);
            return;
        }
        if (this.mService != null) {
            try {
                this.mService.enrollCancel(this.mToken, this.getCurrentUserId());
                this.mClientReceiver = null;
            }
            catch (RemoteException e) {
                Log.v("FingerprintManager", "Remote exception in enrollCancel(): ", e);
                this.sendError(1, 0, 0);
            }
        } else {
            Log.w("FingerprintManager", "enrollCancel(): Service not connected!");
        }
    }

    private final void $$robo$$android_service_fingerprint_FingerprintManager$sendError(int msg, int arg1, int arg2) {
        this.mHandler.obtainMessage(msg, arg1, arg2);
    }

    private void __constructor__(Context context, IFingerprintService iFingerprintService) {
        this.$$robo$$android_service_fingerprint_FingerprintManager$__constructor__(context, iFingerprintService);
    }

    public FingerprintManager(Context context, IFingerprintService iFingerprintService) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_fingerprint_FingerprintManager$__constructor__(android.content.Context android.service.fingerprint.IFingerprintService ), 0, this, context, iFingerprintService);
    }

    public boolean enrolledAndEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("enrolledAndEnabled", $$robo$$android_service_fingerprint_FingerprintManager$enrolledAndEnabled(), 0, this);
    }

    public void enroll(long l) {
        InvokeDynamicSupport.bootstrap("enroll", $$robo$$android_service_fingerprint_FingerprintManager$enroll(long ), 0, this, l);
    }

    public void remove(int n) {
        InvokeDynamicSupport.bootstrap("remove", $$robo$$android_service_fingerprint_FingerprintManager$remove(int ), 0, this, n);
    }

    public void startListening(FingerprintManagerReceiver fingerprintManagerReceiver) {
        InvokeDynamicSupport.bootstrap("startListening", $$robo$$android_service_fingerprint_FingerprintManager$startListening(android.service.fingerprint.FingerprintManagerReceiver ), 0, this, fingerprintManagerReceiver);
    }

    private int getCurrentUserId() {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentUserId", $$robo$$android_service_fingerprint_FingerprintManager$getCurrentUserId(), 0, this);
    }

    public void stopListening() {
        InvokeDynamicSupport.bootstrap("stopListening", $$robo$$android_service_fingerprint_FingerprintManager$stopListening(), 0, this);
    }

    public void enrollCancel() {
        InvokeDynamicSupport.bootstrap("enrollCancel", $$robo$$android_service_fingerprint_FingerprintManager$enrollCancel(), 0, this);
    }

    private void sendError(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("sendError", $$robo$$android_service_fingerprint_FingerprintManager$sendError(int int int ), 0, this, n, n2, n3);
    }

    public /* synthetic */ FingerprintManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FingerprintManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

