/*
 * Decompiled with CFR 0.152.
 */
package android.service.fingerprint;

import android.content.ContentResolver;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class FingerprintUtils
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DEBUG = true;
    private static String TAG = "FingerprintUtils";

    private void $$robo$$android_service_fingerprint_FingerprintUtils$__constructor__() {
    }

    private static final int[] $$robo$$android_service_fingerprint_FingerprintUtils$getFingerprintIdsForUser(ContentResolver res, int userId) {
        String fingerIdsRaw = Settings.Secure.getStringForUser(res, "user_fingerprint_ids", userId);
        int[] result = new int[]{};
        if (!TextUtils.isEmpty(fingerIdsRaw)) {
            String[] fingerStringIds = fingerIdsRaw.replace("[", "").replace("]", "").split(", ");
            result = new int[fingerStringIds.length];
            for (int i = 0; i < result.length; ++i) {
                try {
                    result[i] = Integer.decode(fingerStringIds[i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    Log.d("FingerprintUtils", "Error when parsing finger id " + fingerStringIds[i]);
                }
            }
        }
        return result;
    }

    private static final void $$robo$$android_service_fingerprint_FingerprintUtils$addFingerprintIdForUser(int fingerId, ContentResolver res, int userId) {
        int[] fingerIds = FingerprintUtils.getFingerprintIdsForUser(res, userId);
        if (fingerId == 0) {
            return;
        }
        for (int i = 0; i < fingerIds.length; ++i) {
            if (fingerIds[i] != fingerId) continue;
            return;
        }
        int[] newList = Arrays.copyOf(fingerIds, fingerIds.length + 1);
        newList[fingerIds.length] = fingerId;
        Settings.Secure.putStringForUser(res, "user_fingerprint_ids", Arrays.toString(newList), userId);
    }

    private static final boolean $$robo$$android_service_fingerprint_FingerprintUtils$removeFingerprintIdForUser(int fingerId, ContentResolver res, int userId) {
        if (fingerId == 0) {
            throw new IllegalStateException("Bad fingerId");
        }
        int[] fingerIds = FingerprintUtils.getFingerprintIdsForUser(res, userId);
        int[] resultIds = Arrays.copyOf(fingerIds, fingerIds.length);
        int resultCount = 0;
        for (int i = 0; i < fingerIds.length; ++i) {
            if (fingerId == fingerIds[i]) continue;
            resultIds[resultCount++] = fingerIds[i];
        }
        if (resultCount > 0) {
            Settings.Secure.putStringForUser(res, "user_fingerprint_ids", Arrays.toString(Arrays.copyOf(resultIds, resultCount)), userId);
            return true;
        }
        return false;
    }

    private void __constructor__() {
        this.$$robo$$android_service_fingerprint_FingerprintUtils$__constructor__();
    }

    public FingerprintUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_fingerprint_FingerprintUtils$__constructor__(), 0, this);
    }

    public static int[] getFingerprintIdsForUser(ContentResolver contentResolver, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getFingerprintIdsForUser", $$robo$$android_service_fingerprint_FingerprintUtils$getFingerprintIdsForUser(android.content.ContentResolver int ), 0, (ContentResolver)contentResolver, (int)n);
    }

    public static void addFingerprintIdForUser(int n, ContentResolver contentResolver, int n2) {
        InvokeDynamicSupport.bootstrapStatic("addFingerprintIdForUser", $$robo$$android_service_fingerprint_FingerprintUtils$addFingerprintIdForUser(int android.content.ContentResolver int ), 0, (int)n, (ContentResolver)contentResolver, (int)n2);
    }

    public static boolean removeFingerprintIdForUser(int n, ContentResolver contentResolver, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("removeFingerprintIdForUser", $$robo$$android_service_fingerprint_FingerprintUtils$removeFingerprintIdForUser(int android.content.ContentResolver int ), 0, (int)n, (ContentResolver)contentResolver, (int)n2);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FingerprintUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

