/*
 * Decompiled with CFR 0.152.
 */
package android.service.media;

import android.app.Service;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ParceledListSlice;
import android.media.browse.MediaBrowser;
import android.media.session.MediaSession;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.service.media.IMediaBrowserService;
import android.service.media.IMediaBrowserServiceCallbacks;
import android.util.ArrayMap;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class MediaBrowserService
extends Service
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "MediaBrowserService";
    private static boolean DBG = false;
    public static String SERVICE_INTERFACE = "android.media.browse.MediaBrowserService";
    private ArrayMap<IBinder, ConnectionRecord> mConnections;
    private Handler mHandler;
    private ServiceBinder mBinder;
    MediaSession.Token mSession;

    private void $$robo$$android_service_media_MediaBrowserService$__constructor__() {
        this.mConnections = new ArrayMap();
        this.mHandler = new Handler();
    }

    private final void $$robo$$android_service_media_MediaBrowserService$onCreate() {
        super.onCreate();
        this.mBinder = new ServiceBinder(this);
    }

    private final IBinder $$robo$$android_service_media_MediaBrowserService$onBind(Intent intent) {
        if ("android.media.browse.MediaBrowserService".equals(intent.getAction())) {
            return this.mBinder;
        }
        return null;
    }

    private final void $$robo$$android_service_media_MediaBrowserService$dump(FileDescriptor fd, PrintWriter writer, String[] args) {
    }

    public abstract BrowserRoot onGetRoot(String var1, int var2, Bundle var3);

    public abstract void onLoadChildren(String var1, Result<List<MediaBrowser.MediaItem>> var2);

    private final void $$robo$$android_service_media_MediaBrowserService$setSessionToken(MediaSession.Token token) {
        if (token == null) {
            throw new IllegalStateException(this.getClass().getName() + ".onCreateSession() set invalid MediaSession.Token");
        }
        this.mSession = token;
    }

    private final MediaSession.Token $$robo$$android_service_media_MediaBrowserService$getSessionToken() {
        return this.mSession;
    }

    private final void $$robo$$android_service_media_MediaBrowserService$notifyChildrenChanged(String parentId) {
        if (parentId == null) {
            throw new IllegalArgumentException("parentId cannot be null in notifyChildrenChanged");
        }
        this.mHandler.post(new Runnable(this, parentId){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ String val$parentId;
            /* synthetic */ MediaBrowserService this$0;

            private void $$robo$$android_service_media_MediaBrowserService_1$__constructor__(MediaBrowserService mediaBrowserService, String string2) {
            }

            private final void $$robo$$android_service_media_MediaBrowserService_1$run() {
                for (IBinder binder : this.this$0.mConnections.keySet()) {
                    ConnectionRecord connection = (ConnectionRecord)this.this$0.mConnections.get(binder);
                    if (!connection.subscriptions.contains(this.val$parentId)) continue;
                    this.this$0.performLoadChildren(this.val$parentId, connection);
                }
            }

            private void __constructor__(MediaBrowserService mediaBrowserService, String string2) {
                this.$$robo$$android_service_media_MediaBrowserService_1$__constructor__(mediaBrowserService, string2);
            }
            {
                this.this$0 = mediaBrowserService;
                this.val$parentId = string2;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_media_MediaBrowserService_1$__constructor__(android.service.media.MediaBrowserService java.lang.String ), 0, this, mediaBrowserService, string2);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_service_media_MediaBrowserService_1$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final boolean $$robo$$android_service_media_MediaBrowserService$isValidPackage(String pkg, int uid) {
        if (pkg == null) {
            return false;
        }
        PackageManager pm = this.getPackageManager();
        String[] packages = pm.getPackagesForUid(uid);
        int N = packages.length;
        for (int i = 0; i < N; ++i) {
            if (!packages[i].equals(pkg)) continue;
            return true;
        }
        return false;
    }

    private final void $$robo$$android_service_media_MediaBrowserService$addSubscription(String id2, ConnectionRecord connection) {
        boolean added = connection.subscriptions.add(id2);
        if (added) {
            this.performLoadChildren(id2, connection);
        }
    }

    private final void $$robo$$android_service_media_MediaBrowserService$performLoadChildren(String parentId, ConnectionRecord connection) {
        Result<List<MediaBrowser.MediaItem>> result = new Result<List<MediaBrowser.MediaItem>>(this, (Object)parentId, parentId, connection){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ String val$parentId;
            /* synthetic */ ConnectionRecord val$connection;
            /* synthetic */ MediaBrowserService this$0;

            private void $$robo$$android_service_media_MediaBrowserService_2$__constructor__(MediaBrowserService mediaBrowserService, Object x0, String string2, ConnectionRecord connectionRecord) {
            }

            private final void $$robo$$android_service_media_MediaBrowserService_2$onResultSent(List<MediaBrowser.MediaItem> list) {
                if (list == null) {
                    throw new IllegalStateException("onLoadChildren sent null list for id " + this.val$parentId);
                }
                if (this.this$0.mConnections.get(this.val$connection.callbacks.asBinder()) != this.val$connection) {
                    return;
                }
                ParceledListSlice<MediaBrowser.MediaItem> pls = new ParceledListSlice<MediaBrowser.MediaItem>(list);
                try {
                    this.val$connection.callbacks.onLoadChildren(this.val$parentId, pls);
                }
                catch (RemoteException ex) {
                    Log.w("MediaBrowserService", "Calling onLoadChildren() failed for id=" + this.val$parentId + " package=" + this.val$connection.pkg);
                }
            }

            private void __constructor__(MediaBrowserService mediaBrowserService, Object object, String string2, ConnectionRecord connectionRecord) {
                this.$$robo$$android_service_media_MediaBrowserService_2$__constructor__(mediaBrowserService, object, string2, connectionRecord);
            }
            {
                this.this$0 = mediaBrowserService;
                this.val$parentId = string2;
                this.val$connection = connectionRecord;
                super(mediaBrowserService, object);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_media_MediaBrowserService_2$__constructor__(android.service.media.MediaBrowserService java.lang.Object java.lang.String android.service.media.MediaBrowserService$ConnectionRecord ), 0, this, mediaBrowserService, object, string2, connectionRecord);
            }

            @Override
            void onResultSent(List<MediaBrowser.MediaItem> list) {
                InvokeDynamicSupport.bootstrap("onResultSent", $$robo$$android_service_media_MediaBrowserService_2$onResultSent(java.util.List<android.media.browse.MediaBrowser$MediaItem> ), 0, this, list);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.onLoadChildren(parentId, result);
        if (!result.isDone()) {
            throw new IllegalStateException("onLoadChildren must call detach() or sendResult() before returning for package=" + connection.pkg + " id=" + parentId);
        }
    }

    private void __constructor__() {
        this.$$robo$$android_service_media_MediaBrowserService$__constructor__();
    }

    public MediaBrowserService() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_media_MediaBrowserService$__constructor__(), 0, this);
    }

    @Override
    public void onCreate() {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$android_service_media_MediaBrowserService$onCreate(), 0, this);
    }

    @Override
    public IBinder onBind(Intent intent) {
        return InvokeDynamicSupport.bootstrap("onBind", $$robo$$android_service_media_MediaBrowserService$onBind(android.content.Intent ), 0, this, intent);
    }

    @Override
    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_service_media_MediaBrowserService$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    public void setSessionToken(MediaSession.Token token) {
        InvokeDynamicSupport.bootstrap("setSessionToken", $$robo$$android_service_media_MediaBrowserService$setSessionToken(android.media.session.MediaSession$Token ), 0, this, token);
    }

    public MediaSession.Token getSessionToken() {
        return InvokeDynamicSupport.bootstrap("getSessionToken", $$robo$$android_service_media_MediaBrowserService$getSessionToken(), 0, this);
    }

    public void notifyChildrenChanged(String string2) {
        InvokeDynamicSupport.bootstrap("notifyChildrenChanged", $$robo$$android_service_media_MediaBrowserService$notifyChildrenChanged(java.lang.String ), 0, this, string2);
    }

    private boolean isValidPackage(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isValidPackage", $$robo$$android_service_media_MediaBrowserService$isValidPackage(java.lang.String int ), 0, this, string2, n);
    }

    private void addSubscription(String string2, ConnectionRecord connectionRecord) {
        InvokeDynamicSupport.bootstrap("addSubscription", $$robo$$android_service_media_MediaBrowserService$addSubscription(java.lang.String android.service.media.MediaBrowserService$ConnectionRecord ), 0, this, string2, connectionRecord);
    }

    private void performLoadChildren(String string2, ConnectionRecord connectionRecord) {
        InvokeDynamicSupport.bootstrap("performLoadChildren", $$robo$$android_service_media_MediaBrowserService$performLoadChildren(java.lang.String android.service.media.MediaBrowserService$ConnectionRecord ), 0, this, string2, connectionRecord);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaBrowserService)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class BrowserRoot
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String mRootId;
        private Bundle mExtras;

        private void $$robo$$android_service_media_MediaBrowserService_BrowserRoot$__constructor__(String rootId, Bundle extras) {
            if (rootId == null) {
                throw new IllegalArgumentException("The root id in BrowserRoot cannot be null. Use null for BrowserRoot instead.");
            }
            this.mRootId = rootId;
            this.mExtras = extras;
        }

        private final String $$robo$$android_service_media_MediaBrowserService_BrowserRoot$getRootId() {
            return this.mRootId;
        }

        private final Bundle $$robo$$android_service_media_MediaBrowserService_BrowserRoot$getExtras() {
            return this.mExtras;
        }

        private void __constructor__(String string2, Bundle bundle) {
            this.$$robo$$android_service_media_MediaBrowserService_BrowserRoot$__constructor__(string2, bundle);
        }

        public BrowserRoot(String string2, Bundle bundle) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_media_MediaBrowserService_BrowserRoot$__constructor__(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
        }

        public String getRootId() {
            return InvokeDynamicSupport.bootstrap("getRootId", $$robo$$android_service_media_MediaBrowserService_BrowserRoot$getRootId(), 0, this);
        }

        public Bundle getExtras() {
            return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_service_media_MediaBrowserService_BrowserRoot$getExtras(), 0, this);
        }

        public /* synthetic */ BrowserRoot() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BrowserRoot)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ServiceBinder
    extends IMediaBrowserService.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ MediaBrowserService this$0;

        private void $$robo$$android_service_media_MediaBrowserService_ServiceBinder$__constructor__(MediaBrowserService mediaBrowserService) {
        }

        private final void $$robo$$android_service_media_MediaBrowserService_ServiceBinder$connect(String pkg, Bundle rootHints, IMediaBrowserServiceCallbacks callbacks) {
            int uid = Binder.getCallingUid();
            if (!this.this$0.isValidPackage(pkg, uid)) {
                throw new IllegalArgumentException("Package/uid mismatch: uid=" + uid + " package=" + pkg);
            }
            this.this$0.mHandler.post(new Runnable(this, callbacks, pkg, rootHints, uid){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ IMediaBrowserServiceCallbacks val$callbacks;
                /* synthetic */ String val$pkg;
                /* synthetic */ Bundle val$rootHints;
                /* synthetic */ int val$uid;
                /* synthetic */ ServiceBinder this$1;

                private void $$robo$$android_service_media_MediaBrowserService_ServiceBinder_1$__constructor__(ServiceBinder serviceBinder, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks, String string2, Bundle bundle, int n) {
                }

                private final void $$robo$$android_service_media_MediaBrowserService_ServiceBinder_1$run() {
                    IBinder b = this.val$callbacks.asBinder();
                    this.this$1.this$0.mConnections.remove(b);
                    ConnectionRecord connection = new ConnectionRecord(this.this$1.this$0);
                    connection.pkg = this.val$pkg;
                    connection.rootHints = this.val$rootHints;
                    connection.callbacks = this.val$callbacks;
                    connection.root = this.this$1.this$0.onGetRoot(this.val$pkg, this.val$uid, this.val$rootHints);
                    if (connection.root == null) {
                        Log.i("MediaBrowserService", "No root for client " + this.val$pkg + " from service " + this.getClass().getName());
                        try {
                            this.val$callbacks.onConnectFailed();
                        }
                        catch (RemoteException ex) {
                            Log.w("MediaBrowserService", "Calling onConnectFailed() failed. Ignoring. pkg=" + this.val$pkg);
                        }
                    } else {
                        try {
                            this.this$1.this$0.mConnections.put(b, connection);
                            this.val$callbacks.onConnect(connection.root.getRootId(), this.this$1.this$0.mSession, connection.root.getExtras());
                        }
                        catch (RemoteException ex) {
                            Log.w("MediaBrowserService", "Calling onConnect() failed. Dropping client. pkg=" + this.val$pkg);
                            this.this$1.this$0.mConnections.remove(b);
                        }
                    }
                }

                private void __constructor__(ServiceBinder serviceBinder, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks, String string2, Bundle bundle, int n) {
                    this.$$robo$$android_service_media_MediaBrowserService_ServiceBinder_1$__constructor__(serviceBinder, iMediaBrowserServiceCallbacks, string2, bundle, n);
                }
                {
                    this.this$1 = serviceBinder;
                    this.val$callbacks = iMediaBrowserServiceCallbacks;
                    this.val$pkg = string2;
                    this.val$rootHints = bundle;
                    this.val$uid = n;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_media_MediaBrowserService_ServiceBinder_1$__constructor__(android.service.media.MediaBrowserService$ServiceBinder android.service.media.IMediaBrowserServiceCallbacks java.lang.String android.os.Bundle int ), 0, this, serviceBinder, iMediaBrowserServiceCallbacks, string2, bundle, n);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_service_media_MediaBrowserService_ServiceBinder_1$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_service_media_MediaBrowserService_ServiceBinder$disconnect(IMediaBrowserServiceCallbacks callbacks) {
            this.this$0.mHandler.post(new Runnable(this, callbacks){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ IMediaBrowserServiceCallbacks val$callbacks;
                /* synthetic */ ServiceBinder this$1;

                private void $$robo$$android_service_media_MediaBrowserService_ServiceBinder_2$__constructor__(ServiceBinder serviceBinder, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks) {
                }

                private final void $$robo$$android_service_media_MediaBrowserService_ServiceBinder_2$run() {
                    IBinder b = this.val$callbacks.asBinder();
                    ConnectionRecord old = (ConnectionRecord)this.this$1.this$0.mConnections.remove(b);
                    if (old != null) {
                        // empty if block
                    }
                }

                private void __constructor__(ServiceBinder serviceBinder, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks) {
                    this.$$robo$$android_service_media_MediaBrowserService_ServiceBinder_2$__constructor__(serviceBinder, iMediaBrowserServiceCallbacks);
                }
                {
                    this.this$1 = serviceBinder;
                    this.val$callbacks = iMediaBrowserServiceCallbacks;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_media_MediaBrowserService_ServiceBinder_2$__constructor__(android.service.media.MediaBrowserService$ServiceBinder android.service.media.IMediaBrowserServiceCallbacks ), 0, this, serviceBinder, iMediaBrowserServiceCallbacks);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_service_media_MediaBrowserService_ServiceBinder_2$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_service_media_MediaBrowserService_ServiceBinder$addSubscription(String id2, IMediaBrowserServiceCallbacks callbacks) {
            this.this$0.mHandler.post(new Runnable(this, callbacks, id2){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ IMediaBrowserServiceCallbacks val$callbacks;
                /* synthetic */ String val$id;
                /* synthetic */ ServiceBinder this$1;

                private void $$robo$$android_service_media_MediaBrowserService_ServiceBinder_3$__constructor__(ServiceBinder serviceBinder, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks, String string2) {
                }

                private final void $$robo$$android_service_media_MediaBrowserService_ServiceBinder_3$run() {
                    IBinder b = this.val$callbacks.asBinder();
                    ConnectionRecord connection = (ConnectionRecord)this.this$1.this$0.mConnections.get(b);
                    if (connection == null) {
                        Log.w("MediaBrowserService", "addSubscription for callback that isn't registered id=" + this.val$id);
                        return;
                    }
                    this.this$1.this$0.addSubscription(this.val$id, connection);
                }

                private void __constructor__(ServiceBinder serviceBinder, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks, String string2) {
                    this.$$robo$$android_service_media_MediaBrowserService_ServiceBinder_3$__constructor__(serviceBinder, iMediaBrowserServiceCallbacks, string2);
                }
                {
                    this.this$1 = serviceBinder;
                    this.val$callbacks = iMediaBrowserServiceCallbacks;
                    this.val$id = string2;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_media_MediaBrowserService_ServiceBinder_3$__constructor__(android.service.media.MediaBrowserService$ServiceBinder android.service.media.IMediaBrowserServiceCallbacks java.lang.String ), 0, this, serviceBinder, iMediaBrowserServiceCallbacks, string2);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_service_media_MediaBrowserService_ServiceBinder_3$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_service_media_MediaBrowserService_ServiceBinder$removeSubscription(String id2, IMediaBrowserServiceCallbacks callbacks) {
            this.this$0.mHandler.post(new Runnable(this, callbacks, id2){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ IMediaBrowserServiceCallbacks val$callbacks;
                /* synthetic */ String val$id;
                /* synthetic */ ServiceBinder this$1;

                private void $$robo$$android_service_media_MediaBrowserService_ServiceBinder_4$__constructor__(ServiceBinder serviceBinder, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks, String string2) {
                }

                private final void $$robo$$android_service_media_MediaBrowserService_ServiceBinder_4$run() {
                    IBinder b = this.val$callbacks.asBinder();
                    ConnectionRecord connection = (ConnectionRecord)this.this$1.this$0.mConnections.get(b);
                    if (connection == null) {
                        Log.w("MediaBrowserService", "removeSubscription for callback that isn't registered id=" + this.val$id);
                        return;
                    }
                    if (!connection.subscriptions.remove(this.val$id)) {
                        Log.w("MediaBrowserService", "removeSubscription called for " + this.val$id + " which is not subscribed");
                    }
                }

                private void __constructor__(ServiceBinder serviceBinder, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks, String string2) {
                    this.$$robo$$android_service_media_MediaBrowserService_ServiceBinder_4$__constructor__(serviceBinder, iMediaBrowserServiceCallbacks, string2);
                }
                {
                    this.this$1 = serviceBinder;
                    this.val$callbacks = iMediaBrowserServiceCallbacks;
                    this.val$id = string2;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_media_MediaBrowserService_ServiceBinder_4$__constructor__(android.service.media.MediaBrowserService$ServiceBinder android.service.media.IMediaBrowserServiceCallbacks java.lang.String ), 0, this, serviceBinder, iMediaBrowserServiceCallbacks, string2);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_service_media_MediaBrowserService_ServiceBinder_4$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private /* synthetic */ void $$robo$$android_service_media_MediaBrowserService_ServiceBinder$__constructor__(MediaBrowserService x0, 1 x1) {
        }

        private void __constructor__(MediaBrowserService mediaBrowserService) {
            this.$$robo$$android_service_media_MediaBrowserService_ServiceBinder$__constructor__(mediaBrowserService);
        }

        private ServiceBinder(MediaBrowserService mediaBrowserService) {
            this.this$0 = mediaBrowserService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_media_MediaBrowserService_ServiceBinder$__constructor__(android.service.media.MediaBrowserService ), 0, this, mediaBrowserService);
        }

        @Override
        public void connect(String string2, Bundle bundle, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks) {
            InvokeDynamicSupport.bootstrap("connect", $$robo$$android_service_media_MediaBrowserService_ServiceBinder$connect(java.lang.String android.os.Bundle android.service.media.IMediaBrowserServiceCallbacks ), 0, this, string2, bundle, iMediaBrowserServiceCallbacks);
        }

        @Override
        public void disconnect(IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks) {
            InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_service_media_MediaBrowserService_ServiceBinder$disconnect(android.service.media.IMediaBrowserServiceCallbacks ), 0, this, iMediaBrowserServiceCallbacks);
        }

        @Override
        public void addSubscription(String string2, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks) {
            InvokeDynamicSupport.bootstrap("addSubscription", $$robo$$android_service_media_MediaBrowserService_ServiceBinder$addSubscription(java.lang.String android.service.media.IMediaBrowserServiceCallbacks ), 0, this, string2, iMediaBrowserServiceCallbacks);
        }

        @Override
        public void removeSubscription(String string2, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks) {
            InvokeDynamicSupport.bootstrap("removeSubscription", $$robo$$android_service_media_MediaBrowserService_ServiceBinder$removeSubscription(java.lang.String android.service.media.IMediaBrowserServiceCallbacks ), 0, this, string2, iMediaBrowserServiceCallbacks);
        }

        private /* synthetic */ void __constructor__(MediaBrowserService mediaBrowserService, 1 var2_2) {
            this.$$robo$$android_service_media_MediaBrowserService_ServiceBinder$__constructor__(mediaBrowserService, var2_2);
        }

        public /* synthetic */ ServiceBinder() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ServiceBinder)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class Result<T> {
        public transient /* synthetic */ Object __robo_data__;
        private Object mDebug;
        private boolean mDetachCalled;
        private boolean mSendResultCalled;
        /* synthetic */ MediaBrowserService this$0;

        private void $$robo$$android_service_media_MediaBrowserService_Result$__constructor__(MediaBrowserService mediaBrowserService, Object debug) {
            this.mDebug = debug;
        }

        private final void $$robo$$android_service_media_MediaBrowserService_Result$sendResult(T result) {
            if (this.mSendResultCalled) {
                throw new IllegalStateException("sendResult() called twice for: " + this.mDebug);
            }
            this.mSendResultCalled = true;
            this.onResultSent(result);
        }

        private final void $$robo$$android_service_media_MediaBrowserService_Result$detach() {
            if (this.mDetachCalled) {
                throw new IllegalStateException("detach() called when detach() had already been called for: " + this.mDebug);
            }
            if (this.mSendResultCalled) {
                throw new IllegalStateException("detach() called when sendResult() had already been called for: " + this.mDebug);
            }
            this.mDetachCalled = true;
        }

        private final boolean $$robo$$android_service_media_MediaBrowserService_Result$isDone() {
            return this.mDetachCalled || this.mSendResultCalled;
        }

        private final void $$robo$$android_service_media_MediaBrowserService_Result$onResultSent(T result) {
        }

        private void __constructor__(MediaBrowserService mediaBrowserService, Object object) {
            this.$$robo$$android_service_media_MediaBrowserService_Result$__constructor__(mediaBrowserService, object);
        }

        Result(MediaBrowserService mediaBrowserService, Object object) {
            this.this$0 = mediaBrowserService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_media_MediaBrowserService_Result$__constructor__(android.service.media.MediaBrowserService java.lang.Object ), 0, this, mediaBrowserService, object);
        }

        public void sendResult(T t) {
            InvokeDynamicSupport.bootstrap("sendResult", $$robo$$android_service_media_MediaBrowserService_Result$sendResult(T ), 0, this, t);
        }

        public void detach() {
            InvokeDynamicSupport.bootstrap("detach", $$robo$$android_service_media_MediaBrowserService_Result$detach(), 0, this);
        }

        boolean isDone() {
            return (boolean)InvokeDynamicSupport.bootstrap("isDone", $$robo$$android_service_media_MediaBrowserService_Result$isDone(), 0, this);
        }

        void onResultSent(T t) {
            InvokeDynamicSupport.bootstrap("onResultSent", $$robo$$android_service_media_MediaBrowserService_Result$onResultSent(T ), 0, this, t);
        }

        public /* synthetic */ Result() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Result)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ConnectionRecord
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        String pkg;
        Bundle rootHints;
        IMediaBrowserServiceCallbacks callbacks;
        BrowserRoot root;
        HashSet<String> subscriptions;
        /* synthetic */ MediaBrowserService this$0;

        private void $$robo$$android_service_media_MediaBrowserService_ConnectionRecord$__constructor__(MediaBrowserService mediaBrowserService) {
            this.subscriptions = new HashSet();
        }

        private /* synthetic */ void $$robo$$android_service_media_MediaBrowserService_ConnectionRecord$__constructor__(MediaBrowserService x0, 1 x1) {
        }

        private void __constructor__(MediaBrowserService mediaBrowserService) {
            this.$$robo$$android_service_media_MediaBrowserService_ConnectionRecord$__constructor__(mediaBrowserService);
        }

        private ConnectionRecord(MediaBrowserService mediaBrowserService) {
            this.this$0 = mediaBrowserService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_media_MediaBrowserService_ConnectionRecord$__constructor__(android.service.media.MediaBrowserService ), 0, this, mediaBrowserService);
        }

        private /* synthetic */ void __constructor__(MediaBrowserService mediaBrowserService, 1 var2_2) {
            this.$$robo$$android_service_media_MediaBrowserService_ConnectionRecord$__constructor__(mediaBrowserService, var2_2);
        }

        public /* synthetic */ ConnectionRecord() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConnectionRecord)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

