/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

import android.app.INotificationManager;
import android.app.Notification;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ParceledListSlice;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.service.notification.INotificationListener;
import android.service.notification.IStatusBarNotificationHolder;
import android.service.notification.NotificationRankingUpdate;
import android.service.notification.StatusBarNotification;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import java.util.Collections;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class NotificationListenerService
extends Service
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private String TAG;
    public static int INTERRUPTION_FILTER_ALL = 1;
    public static int INTERRUPTION_FILTER_PRIORITY = 2;
    public static int INTERRUPTION_FILTER_NONE = 3;
    public static int HINT_HOST_DISABLE_EFFECTS = 1;
    public static int TRIM_FULL = 0;
    public static int TRIM_LIGHT = 1;
    private INotificationListenerWrapper mWrapper;
    private RankingMap mRankingMap;
    private INotificationManager mNoMan;
    private int mCurrentUser;
    private Context mSystemContext;
    public static String SERVICE_INTERFACE = "android.service.notification.NotificationListenerService";

    private void $$robo$$android_service_notification_NotificationListenerService$__constructor__() {
        this.TAG = NotificationListenerService.class.getSimpleName() + "[" + this.getClass().getSimpleName() + "]";
        this.mWrapper = null;
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$onNotificationPosted(StatusBarNotification sbn) {
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$onNotificationPosted(StatusBarNotification sbn, RankingMap rankingMap) {
        this.onNotificationPosted(sbn);
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$onNotificationRemoved(StatusBarNotification sbn) {
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$onNotificationRemoved(StatusBarNotification sbn, RankingMap rankingMap) {
        this.onNotificationRemoved(sbn);
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$onListenerConnected() {
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$onNotificationRankingUpdate(RankingMap rankingMap) {
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$onListenerHintsChanged(int hints) {
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$onInterruptionFilterChanged(int interruptionFilter) {
    }

    private final INotificationManager $$robo$$android_service_notification_NotificationListenerService$getNotificationInterface() {
        if (this.mNoMan == null) {
            this.mNoMan = INotificationManager.Stub.asInterface(ServiceManager.getService("notification"));
        }
        return this.mNoMan;
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$cancelNotification(String pkg, String tag, int id2) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().cancelNotificationFromListener(this.mWrapper, pkg, tag, id2);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$cancelNotification(String key) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().cancelNotificationsFromListener(this.mWrapper, new String[]{key});
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$cancelAllNotifications() {
        this.cancelNotifications(null);
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$cancelNotifications(String[] keys) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().cancelNotificationsFromListener(this.mWrapper, keys);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$setOnNotificationPostedTrim(int trim) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().setOnNotificationPostedTrimFromListener(this.mWrapper, trim);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    private final StatusBarNotification[] $$robo$$android_service_notification_NotificationListenerService$getActiveNotifications() {
        return this.getActiveNotifications(null, 0);
    }

    private final StatusBarNotification[] $$robo$$android_service_notification_NotificationListenerService$getActiveNotifications(int trim) {
        return this.getActiveNotifications(null, trim);
    }

    private final StatusBarNotification[] $$robo$$android_service_notification_NotificationListenerService$getActiveNotifications(String[] keys) {
        return this.getActiveNotifications(keys, 0);
    }

    private final StatusBarNotification[] $$robo$$android_service_notification_NotificationListenerService$getActiveNotifications(String[] keys, int trim) {
        if (!this.isBound()) {
            return null;
        }
        try {
            ParceledListSlice parceledList = this.getNotificationInterface().getActiveNotificationsFromListener(this.mWrapper, keys, trim);
            List<StatusBarNotification> list = parceledList.getList();
            int N = list.size();
            for (int i = 0; i < N; ++i) {
                Notification notification = ((StatusBarNotification)list.get(i)).getNotification();
                Notification.Builder.rebuild(this.getContext(), notification);
            }
            return list.toArray(new StatusBarNotification[N]);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
            return null;
        }
    }

    private final int $$robo$$android_service_notification_NotificationListenerService$getCurrentListenerHints() {
        if (!this.isBound()) {
            return 0;
        }
        try {
            return this.getNotificationInterface().getHintsFromListener(this.mWrapper);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
            return 0;
        }
    }

    private final int $$robo$$android_service_notification_NotificationListenerService$getCurrentInterruptionFilter() {
        if (!this.isBound()) {
            return 0;
        }
        try {
            return this.getNotificationInterface().getInterruptionFilterFromListener(this.mWrapper);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
            return 0;
        }
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$requestListenerHints(int hints) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().requestHintsFromListener(this.mWrapper, hints);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$requestInterruptionFilter(int interruptionFilter) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().requestInterruptionFilterFromListener(this.mWrapper, interruptionFilter);
        }
        catch (RemoteException ex) {
            Log.v(this.TAG, "Unable to contact notification manager", ex);
        }
    }

    private final RankingMap $$robo$$android_service_notification_NotificationListenerService$getCurrentRanking() {
        return this.mRankingMap;
    }

    private final IBinder $$robo$$android_service_notification_NotificationListenerService$onBind(Intent intent) {
        if (this.mWrapper == null) {
            this.mWrapper = new INotificationListenerWrapper(this);
        }
        return this.mWrapper;
    }

    private final boolean $$robo$$android_service_notification_NotificationListenerService$isBound() {
        if (this.mWrapper == null) {
            Log.w(this.TAG, "Notification listener service not yet bound.");
            return false;
        }
        return true;
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$registerAsSystemService(Context context, ComponentName componentName, int currentUser) throws RemoteException {
        this.mSystemContext = context;
        if (this.mWrapper == null) {
            this.mWrapper = new INotificationListenerWrapper(this);
        }
        INotificationManager noMan = this.getNotificationInterface();
        noMan.registerListener(this.mWrapper, componentName, currentUser);
        this.mCurrentUser = currentUser;
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$unregisterAsSystemService() throws RemoteException {
        if (this.mWrapper != null) {
            INotificationManager noMan = this.getNotificationInterface();
            noMan.unregisterListener(this.mWrapper, this.mCurrentUser);
        }
    }

    private final void $$robo$$android_service_notification_NotificationListenerService$applyUpdate(NotificationRankingUpdate update) {
        this.mRankingMap = new RankingMap(update);
    }

    private final Context $$robo$$android_service_notification_NotificationListenerService$getContext() {
        if (this.mSystemContext != null) {
            return this.mSystemContext;
        }
        return this;
    }

    private void __constructor__() {
        this.$$robo$$android_service_notification_NotificationListenerService$__constructor__();
    }

    public NotificationListenerService() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_notification_NotificationListenerService$__constructor__(), 0, this);
    }

    public void onNotificationPosted(StatusBarNotification statusBarNotification) {
        InvokeDynamicSupport.bootstrap("onNotificationPosted", $$robo$$android_service_notification_NotificationListenerService$onNotificationPosted(android.service.notification.StatusBarNotification ), 0, this, statusBarNotification);
    }

    public void onNotificationPosted(StatusBarNotification statusBarNotification, RankingMap rankingMap) {
        InvokeDynamicSupport.bootstrap("onNotificationPosted", $$robo$$android_service_notification_NotificationListenerService$onNotificationPosted(android.service.notification.StatusBarNotification android.service.notification.NotificationListenerService$RankingMap ), 0, this, statusBarNotification, rankingMap);
    }

    public void onNotificationRemoved(StatusBarNotification statusBarNotification) {
        InvokeDynamicSupport.bootstrap("onNotificationRemoved", $$robo$$android_service_notification_NotificationListenerService$onNotificationRemoved(android.service.notification.StatusBarNotification ), 0, this, statusBarNotification);
    }

    public void onNotificationRemoved(StatusBarNotification statusBarNotification, RankingMap rankingMap) {
        InvokeDynamicSupport.bootstrap("onNotificationRemoved", $$robo$$android_service_notification_NotificationListenerService$onNotificationRemoved(android.service.notification.StatusBarNotification android.service.notification.NotificationListenerService$RankingMap ), 0, this, statusBarNotification, rankingMap);
    }

    public void onListenerConnected() {
        InvokeDynamicSupport.bootstrap("onListenerConnected", $$robo$$android_service_notification_NotificationListenerService$onListenerConnected(), 0, this);
    }

    public void onNotificationRankingUpdate(RankingMap rankingMap) {
        InvokeDynamicSupport.bootstrap("onNotificationRankingUpdate", $$robo$$android_service_notification_NotificationListenerService$onNotificationRankingUpdate(android.service.notification.NotificationListenerService$RankingMap ), 0, this, rankingMap);
    }

    public void onListenerHintsChanged(int n) {
        InvokeDynamicSupport.bootstrap("onListenerHintsChanged", $$robo$$android_service_notification_NotificationListenerService$onListenerHintsChanged(int ), 0, this, n);
    }

    public void onInterruptionFilterChanged(int n) {
        InvokeDynamicSupport.bootstrap("onInterruptionFilterChanged", $$robo$$android_service_notification_NotificationListenerService$onInterruptionFilterChanged(int ), 0, this, n);
    }

    private INotificationManager getNotificationInterface() {
        return InvokeDynamicSupport.bootstrap("getNotificationInterface", $$robo$$android_service_notification_NotificationListenerService$getNotificationInterface(), 0, this);
    }

    public void cancelNotification(String string2, String string3, int n) {
        InvokeDynamicSupport.bootstrap("cancelNotification", $$robo$$android_service_notification_NotificationListenerService$cancelNotification(java.lang.String java.lang.String int ), 0, this, string2, string3, n);
    }

    public void cancelNotification(String string2) {
        InvokeDynamicSupport.bootstrap("cancelNotification", $$robo$$android_service_notification_NotificationListenerService$cancelNotification(java.lang.String ), 0, this, string2);
    }

    public void cancelAllNotifications() {
        InvokeDynamicSupport.bootstrap("cancelAllNotifications", $$robo$$android_service_notification_NotificationListenerService$cancelAllNotifications(), 0, this);
    }

    public void cancelNotifications(String[] stringArray) {
        InvokeDynamicSupport.bootstrap("cancelNotifications", $$robo$$android_service_notification_NotificationListenerService$cancelNotifications(java.lang.String[] ), 0, this, stringArray);
    }

    public void setOnNotificationPostedTrim(int n) {
        InvokeDynamicSupport.bootstrap("setOnNotificationPostedTrim", $$robo$$android_service_notification_NotificationListenerService$setOnNotificationPostedTrim(int ), 0, this, n);
    }

    public StatusBarNotification[] getActiveNotifications() {
        return InvokeDynamicSupport.bootstrap("getActiveNotifications", $$robo$$android_service_notification_NotificationListenerService$getActiveNotifications(), 0, this);
    }

    public StatusBarNotification[] getActiveNotifications(int n) {
        return InvokeDynamicSupport.bootstrap("getActiveNotifications", $$robo$$android_service_notification_NotificationListenerService$getActiveNotifications(int ), 0, this, n);
    }

    public StatusBarNotification[] getActiveNotifications(String[] stringArray) {
        return InvokeDynamicSupport.bootstrap("getActiveNotifications", $$robo$$android_service_notification_NotificationListenerService$getActiveNotifications(java.lang.String[] ), 0, this, stringArray);
    }

    public StatusBarNotification[] getActiveNotifications(String[] stringArray, int n) {
        return InvokeDynamicSupport.bootstrap("getActiveNotifications", $$robo$$android_service_notification_NotificationListenerService$getActiveNotifications(java.lang.String[] int ), 0, this, stringArray, n);
    }

    public int getCurrentListenerHints() {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentListenerHints", $$robo$$android_service_notification_NotificationListenerService$getCurrentListenerHints(), 0, this);
    }

    public int getCurrentInterruptionFilter() {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentInterruptionFilter", $$robo$$android_service_notification_NotificationListenerService$getCurrentInterruptionFilter(), 0, this);
    }

    public void requestListenerHints(int n) {
        InvokeDynamicSupport.bootstrap("requestListenerHints", $$robo$$android_service_notification_NotificationListenerService$requestListenerHints(int ), 0, this, n);
    }

    public void requestInterruptionFilter(int n) {
        InvokeDynamicSupport.bootstrap("requestInterruptionFilter", $$robo$$android_service_notification_NotificationListenerService$requestInterruptionFilter(int ), 0, this, n);
    }

    public RankingMap getCurrentRanking() {
        return InvokeDynamicSupport.bootstrap("getCurrentRanking", $$robo$$android_service_notification_NotificationListenerService$getCurrentRanking(), 0, this);
    }

    @Override
    public IBinder onBind(Intent intent) {
        return InvokeDynamicSupport.bootstrap("onBind", $$robo$$android_service_notification_NotificationListenerService$onBind(android.content.Intent ), 0, this, intent);
    }

    private boolean isBound() {
        return (boolean)InvokeDynamicSupport.bootstrap("isBound", $$robo$$android_service_notification_NotificationListenerService$isBound(), 0, this);
    }

    public void registerAsSystemService(Context context, ComponentName componentName, int n) throws RemoteException {
        InvokeDynamicSupport.bootstrap("registerAsSystemService", $$robo$$android_service_notification_NotificationListenerService$registerAsSystemService(android.content.Context android.content.ComponentName int ), 0, this, context, componentName, n);
    }

    public void unregisterAsSystemService() throws RemoteException {
        InvokeDynamicSupport.bootstrap("unregisterAsSystemService", $$robo$$android_service_notification_NotificationListenerService$unregisterAsSystemService(), 0, this);
    }

    private void applyUpdate(NotificationRankingUpdate notificationRankingUpdate) {
        InvokeDynamicSupport.bootstrap("applyUpdate", $$robo$$android_service_notification_NotificationListenerService$applyUpdate(android.service.notification.NotificationRankingUpdate ), 0, this, notificationRankingUpdate);
    }

    private Context getContext() {
        return InvokeDynamicSupport.bootstrap("getContext", $$robo$$android_service_notification_NotificationListenerService$getContext(), 0, this);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NotificationListenerService)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class RankingMap
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private NotificationRankingUpdate mRankingUpdate;
        private ArrayMap<String, Integer> mRanks;
        private ArraySet<Object> mIntercepted;
        private ArrayMap<String, Integer> mVisibilityOverrides;
        public static Parcelable.Creator<RankingMap> CREATOR;

        private void $$robo$$android_service_notification_NotificationListenerService_RankingMap$__constructor__(NotificationRankingUpdate rankingUpdate) {
            this.mRankingUpdate = rankingUpdate;
        }

        private final String[] $$robo$$android_service_notification_NotificationListenerService_RankingMap$getOrderedKeys() {
            return this.mRankingUpdate.getOrderedKeys();
        }

        private final boolean $$robo$$android_service_notification_NotificationListenerService_RankingMap$getRanking(String key, Ranking outRanking) {
            int rank = this.getRank(key);
            outRanking.populate(key, rank, this.isAmbient(key), !this.isIntercepted(key), this.getVisibilityOverride(key));
            return rank >= 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final int $$robo$$android_service_notification_NotificationListenerService_RankingMap$getRank(String key) {
            RankingMap rankingMap = this;
            synchronized (rankingMap) {
                if (this.mRanks == null) {
                    this.buildRanksLocked();
                }
            }
            Integer rank = this.mRanks.get(key);
            return rank != null ? rank : -1;
        }

        private final boolean $$robo$$android_service_notification_NotificationListenerService_RankingMap$isAmbient(String key) {
            int firstAmbientIndex = this.mRankingUpdate.getFirstAmbientIndex();
            if (firstAmbientIndex < 0) {
                return false;
            }
            int rank = this.getRank(key);
            return rank >= 0 && rank >= firstAmbientIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean $$robo$$android_service_notification_NotificationListenerService_RankingMap$isIntercepted(String key) {
            RankingMap rankingMap = this;
            synchronized (rankingMap) {
                if (this.mIntercepted == null) {
                    this.buildInterceptedSetLocked();
                }
            }
            return this.mIntercepted.contains(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final int $$robo$$android_service_notification_NotificationListenerService_RankingMap$getVisibilityOverride(String key) {
            RankingMap rankingMap = this;
            synchronized (rankingMap) {
                if (this.mVisibilityOverrides == null) {
                    this.buildVisibilityOverridesLocked();
                }
            }
            Integer overide = this.mVisibilityOverrides.get(key);
            if (overide == null) {
                return -1000;
            }
            return overide;
        }

        private final void $$robo$$android_service_notification_NotificationListenerService_RankingMap$buildRanksLocked() {
            String[] orderedKeys = this.mRankingUpdate.getOrderedKeys();
            this.mRanks = new ArrayMap(orderedKeys.length);
            for (int i = 0; i < orderedKeys.length; ++i) {
                String key = orderedKeys[i];
                this.mRanks.put(key, i);
            }
        }

        private final void $$robo$$android_service_notification_NotificationListenerService_RankingMap$buildInterceptedSetLocked() {
            String[] dndInterceptedKeys = this.mRankingUpdate.getInterceptedKeys();
            this.mIntercepted = new ArraySet(dndInterceptedKeys.length);
            Collections.addAll(this.mIntercepted, dndInterceptedKeys);
        }

        private final void $$robo$$android_service_notification_NotificationListenerService_RankingMap$buildVisibilityOverridesLocked() {
            Bundle visibilityBundle = this.mRankingUpdate.getVisibilityOverrides();
            this.mVisibilityOverrides = new ArrayMap(visibilityBundle.size());
            for (String key : visibilityBundle.keySet()) {
                this.mVisibilityOverrides.put(key, visibilityBundle.getInt(key));
            }
        }

        private final int $$robo$$android_service_notification_NotificationListenerService_RankingMap$describeContents() {
            return 0;
        }

        private final void $$robo$$android_service_notification_NotificationListenerService_RankingMap$writeToParcel(Parcel dest, int flags) {
            dest.writeParcelable(this.mRankingUpdate, flags);
        }

        private /* synthetic */ void $$robo$$android_service_notification_NotificationListenerService_RankingMap$__constructor__(NotificationRankingUpdate x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<RankingMap>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_service_notification_NotificationListenerService_RankingMap_1$__constructor__() {
                }

                private final RankingMap $$robo$$android_service_notification_NotificationListenerService_RankingMap_1$createFromParcel(Parcel source) {
                    NotificationRankingUpdate rankingUpdate = (NotificationRankingUpdate)source.readParcelable(null);
                    return new RankingMap(rankingUpdate);
                }

                private final RankingMap[] $$robo$$android_service_notification_NotificationListenerService_RankingMap_1$newArray(int size) {
                    return new RankingMap[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_service_notification_NotificationListenerService_RankingMap_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_notification_NotificationListenerService_RankingMap_1$__constructor__(), 0, this);
                }

                @Override
                public RankingMap createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_service_notification_NotificationListenerService_RankingMap_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public RankingMap[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_service_notification_NotificationListenerService_RankingMap_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(NotificationRankingUpdate notificationRankingUpdate) {
            this.$$robo$$android_service_notification_NotificationListenerService_RankingMap$__constructor__(notificationRankingUpdate);
        }

        private RankingMap(NotificationRankingUpdate notificationRankingUpdate) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_notification_NotificationListenerService_RankingMap$__constructor__(android.service.notification.NotificationRankingUpdate ), 0, this, notificationRankingUpdate);
        }

        public String[] getOrderedKeys() {
            return InvokeDynamicSupport.bootstrap("getOrderedKeys", $$robo$$android_service_notification_NotificationListenerService_RankingMap$getOrderedKeys(), 0, this);
        }

        public boolean getRanking(String string2, Ranking ranking) {
            return (boolean)InvokeDynamicSupport.bootstrap("getRanking", $$robo$$android_service_notification_NotificationListenerService_RankingMap$getRanking(java.lang.String android.service.notification.NotificationListenerService$Ranking ), 0, this, string2, ranking);
        }

        private int getRank(String string2) {
            return (int)InvokeDynamicSupport.bootstrap("getRank", $$robo$$android_service_notification_NotificationListenerService_RankingMap$getRank(java.lang.String ), 0, this, string2);
        }

        private boolean isAmbient(String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("isAmbient", $$robo$$android_service_notification_NotificationListenerService_RankingMap$isAmbient(java.lang.String ), 0, this, string2);
        }

        private boolean isIntercepted(String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("isIntercepted", $$robo$$android_service_notification_NotificationListenerService_RankingMap$isIntercepted(java.lang.String ), 0, this, string2);
        }

        private int getVisibilityOverride(String string2) {
            return (int)InvokeDynamicSupport.bootstrap("getVisibilityOverride", $$robo$$android_service_notification_NotificationListenerService_RankingMap$getVisibilityOverride(java.lang.String ), 0, this, string2);
        }

        private void buildRanksLocked() {
            InvokeDynamicSupport.bootstrap("buildRanksLocked", $$robo$$android_service_notification_NotificationListenerService_RankingMap$buildRanksLocked(), 0, this);
        }

        private void buildInterceptedSetLocked() {
            InvokeDynamicSupport.bootstrap("buildInterceptedSetLocked", $$robo$$android_service_notification_NotificationListenerService_RankingMap$buildInterceptedSetLocked(), 0, this);
        }

        private void buildVisibilityOverridesLocked() {
            InvokeDynamicSupport.bootstrap("buildVisibilityOverridesLocked", $$robo$$android_service_notification_NotificationListenerService_RankingMap$buildVisibilityOverridesLocked(), 0, this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_service_notification_NotificationListenerService_RankingMap$describeContents(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_service_notification_NotificationListenerService_RankingMap$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        private /* synthetic */ void __constructor__(NotificationRankingUpdate notificationRankingUpdate, 1 var2_2) {
            this.$$robo$$android_service_notification_NotificationListenerService_RankingMap$__constructor__(notificationRankingUpdate, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(RankingMap.class);
        }

        public /* synthetic */ RankingMap() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RankingMap)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Ranking
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int VISIBILITY_NO_OVERRIDE = -1000;
        private String mKey;
        private int mRank;
        private boolean mIsAmbient;
        private boolean mMatchesInterruptionFilter;
        private int mVisibilityOverride;

        private void $$robo$$android_service_notification_NotificationListenerService_Ranking$__constructor__() {
            this.mRank = -1;
        }

        private final String $$robo$$android_service_notification_NotificationListenerService_Ranking$getKey() {
            return this.mKey;
        }

        private final int $$robo$$android_service_notification_NotificationListenerService_Ranking$getRank() {
            return this.mRank;
        }

        private final boolean $$robo$$android_service_notification_NotificationListenerService_Ranking$isAmbient() {
            return this.mIsAmbient;
        }

        private final int $$robo$$android_service_notification_NotificationListenerService_Ranking$getVisibilityOverride() {
            return this.mVisibilityOverride;
        }

        private final boolean $$robo$$android_service_notification_NotificationListenerService_Ranking$matchesInterruptionFilter() {
            return this.mMatchesInterruptionFilter;
        }

        private final void $$robo$$android_service_notification_NotificationListenerService_Ranking$populate(String key, int rank, boolean isAmbient, boolean matchesInterruptionFilter, int visibilityOverride) {
            this.mKey = key;
            this.mRank = rank;
            this.mIsAmbient = isAmbient;
            this.mMatchesInterruptionFilter = matchesInterruptionFilter;
            this.mVisibilityOverride = visibilityOverride;
        }

        private void __constructor__() {
            this.$$robo$$android_service_notification_NotificationListenerService_Ranking$__constructor__();
        }

        public Ranking() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_notification_NotificationListenerService_Ranking$__constructor__(), 0, this);
        }

        public String getKey() {
            return InvokeDynamicSupport.bootstrap("getKey", $$robo$$android_service_notification_NotificationListenerService_Ranking$getKey(), 0, this);
        }

        public int getRank() {
            return (int)InvokeDynamicSupport.bootstrap("getRank", $$robo$$android_service_notification_NotificationListenerService_Ranking$getRank(), 0, this);
        }

        public boolean isAmbient() {
            return (boolean)InvokeDynamicSupport.bootstrap("isAmbient", $$robo$$android_service_notification_NotificationListenerService_Ranking$isAmbient(), 0, this);
        }

        public int getVisibilityOverride() {
            return (int)InvokeDynamicSupport.bootstrap("getVisibilityOverride", $$robo$$android_service_notification_NotificationListenerService_Ranking$getVisibilityOverride(), 0, this);
        }

        public boolean matchesInterruptionFilter() {
            return (boolean)InvokeDynamicSupport.bootstrap("matchesInterruptionFilter", $$robo$$android_service_notification_NotificationListenerService_Ranking$matchesInterruptionFilter(), 0, this);
        }

        private void populate(String string2, int n, boolean bl, boolean bl2, int n2) {
            InvokeDynamicSupport.bootstrap("populate", $$robo$$android_service_notification_NotificationListenerService_Ranking$populate(java.lang.String int boolean boolean int ), 0, this, string2, n, bl, bl2, n2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Ranking)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class INotificationListenerWrapper
    extends INotificationListener.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ NotificationListenerService this$0;

        private void $$robo$$android_service_notification_NotificationListenerService_INotificationListenerWrapper$__constructor__(NotificationListenerService notificationListenerService) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_service_notification_NotificationListenerService_INotificationListenerWrapper$onNotificationPosted(IStatusBarNotificationHolder sbnHolder, NotificationRankingUpdate update) {
            StatusBarNotification sbn;
            try {
                sbn = sbnHolder.get();
            }
            catch (RemoteException e) {
                Log.w(this.this$0.TAG, "onNotificationPosted: Error receiving StatusBarNotification", e);
                return;
            }
            Notification.Builder.rebuild(this.this$0.getContext(), sbn.getNotification());
            INotificationListenerWrapper iNotificationListenerWrapper = this.this$0.mWrapper;
            synchronized (iNotificationListenerWrapper) {
                this.this$0.applyUpdate(update);
                try {
                    this.this$0.onNotificationPosted(sbn, this.this$0.mRankingMap);
                }
                catch (Throwable t) {
                    Log.w(this.this$0.TAG, "Error running onNotificationPosted", t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_service_notification_NotificationListenerService_INotificationListenerWrapper$onNotificationRemoved(IStatusBarNotificationHolder sbnHolder, NotificationRankingUpdate update) {
            StatusBarNotification sbn;
            try {
                sbn = sbnHolder.get();
            }
            catch (RemoteException e) {
                Log.w(this.this$0.TAG, "onNotificationRemoved: Error receiving StatusBarNotification", e);
                return;
            }
            INotificationListenerWrapper iNotificationListenerWrapper = this.this$0.mWrapper;
            synchronized (iNotificationListenerWrapper) {
                this.this$0.applyUpdate(update);
                try {
                    this.this$0.onNotificationRemoved(sbn, this.this$0.mRankingMap);
                }
                catch (Throwable t) {
                    Log.w(this.this$0.TAG, "Error running onNotificationRemoved", t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_service_notification_NotificationListenerService_INotificationListenerWrapper$onListenerConnected(NotificationRankingUpdate update) {
            INotificationListenerWrapper iNotificationListenerWrapper = this.this$0.mWrapper;
            synchronized (iNotificationListenerWrapper) {
                this.this$0.applyUpdate(update);
                try {
                    this.this$0.onListenerConnected();
                }
                catch (Throwable t) {
                    Log.w(this.this$0.TAG, "Error running onListenerConnected", t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_service_notification_NotificationListenerService_INotificationListenerWrapper$onNotificationRankingUpdate(NotificationRankingUpdate update) throws RemoteException {
            INotificationListenerWrapper iNotificationListenerWrapper = this.this$0.mWrapper;
            synchronized (iNotificationListenerWrapper) {
                this.this$0.applyUpdate(update);
                try {
                    this.this$0.onNotificationRankingUpdate(this.this$0.mRankingMap);
                }
                catch (Throwable t) {
                    Log.w(this.this$0.TAG, "Error running onNotificationRankingUpdate", t);
                }
            }
        }

        private final void $$robo$$android_service_notification_NotificationListenerService_INotificationListenerWrapper$onListenerHintsChanged(int hints) throws RemoteException {
            try {
                this.this$0.onListenerHintsChanged(hints);
            }
            catch (Throwable t) {
                Log.w(this.this$0.TAG, "Error running onListenerHintsChanged", t);
            }
        }

        private final void $$robo$$android_service_notification_NotificationListenerService_INotificationListenerWrapper$onInterruptionFilterChanged(int interruptionFilter) throws RemoteException {
            try {
                this.this$0.onInterruptionFilterChanged(interruptionFilter);
            }
            catch (Throwable t) {
                Log.w(this.this$0.TAG, "Error running onInterruptionFilterChanged", t);
            }
        }

        private /* synthetic */ void $$robo$$android_service_notification_NotificationListenerService_INotificationListenerWrapper$__constructor__(NotificationListenerService x0, 1 x1) {
        }

        private void __constructor__(NotificationListenerService notificationListenerService) {
            this.$$robo$$android_service_notification_NotificationListenerService_INotificationListenerWrapper$__constructor__(notificationListenerService);
        }

        private INotificationListenerWrapper(NotificationListenerService notificationListenerService) {
            this.this$0 = notificationListenerService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_notification_NotificationListenerService_INotificationListenerWrapper$__constructor__(android.service.notification.NotificationListenerService ), 0, this, notificationListenerService);
        }

        @Override
        public void onNotificationPosted(IStatusBarNotificationHolder iStatusBarNotificationHolder, NotificationRankingUpdate notificationRankingUpdate) {
            InvokeDynamicSupport.bootstrap("onNotificationPosted", $$robo$$android_service_notification_NotificationListenerService_INotificationListenerWrapper$onNotificationPosted(android.service.notification.IStatusBarNotificationHolder android.service.notification.NotificationRankingUpdate ), 0, this, iStatusBarNotificationHolder, notificationRankingUpdate);
        }

        @Override
        public void onNotificationRemoved(IStatusBarNotificationHolder iStatusBarNotificationHolder, NotificationRankingUpdate notificationRankingUpdate) {
            InvokeDynamicSupport.bootstrap("onNotificationRemoved", $$robo$$android_service_notification_NotificationListenerService_INotificationListenerWrapper$onNotificationRemoved(android.service.notification.IStatusBarNotificationHolder android.service.notification.NotificationRankingUpdate ), 0, this, iStatusBarNotificationHolder, notificationRankingUpdate);
        }

        @Override
        public void onListenerConnected(NotificationRankingUpdate notificationRankingUpdate) {
            InvokeDynamicSupport.bootstrap("onListenerConnected", $$robo$$android_service_notification_NotificationListenerService_INotificationListenerWrapper$onListenerConnected(android.service.notification.NotificationRankingUpdate ), 0, this, notificationRankingUpdate);
        }

        @Override
        public void onNotificationRankingUpdate(NotificationRankingUpdate notificationRankingUpdate) throws RemoteException {
            InvokeDynamicSupport.bootstrap("onNotificationRankingUpdate", $$robo$$android_service_notification_NotificationListenerService_INotificationListenerWrapper$onNotificationRankingUpdate(android.service.notification.NotificationRankingUpdate ), 0, this, notificationRankingUpdate);
        }

        @Override
        public void onListenerHintsChanged(int n) throws RemoteException {
            InvokeDynamicSupport.bootstrap("onListenerHintsChanged", $$robo$$android_service_notification_NotificationListenerService_INotificationListenerWrapper$onListenerHintsChanged(int ), 0, this, n);
        }

        @Override
        public void onInterruptionFilterChanged(int n) throws RemoteException {
            InvokeDynamicSupport.bootstrap("onInterruptionFilterChanged", $$robo$$android_service_notification_NotificationListenerService_INotificationListenerWrapper$onInterruptionFilterChanged(int ), 0, this, n);
        }

        private /* synthetic */ void __constructor__(NotificationListenerService notificationListenerService, 1 var2_2) {
            this.$$robo$$android_service_notification_NotificationListenerService_INotificationListenerWrapper$__constructor__(notificationListenerService, var2_2);
        }

        public /* synthetic */ INotificationListenerWrapper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (INotificationListenerWrapper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

