/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

import android.content.ComponentName;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.service.notification.Condition;
import android.text.TextUtils;
import android.util.Slog;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class ZenModeConfig
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    public static String SLEEP_MODE_NIGHTS = "nights";
    public static String SLEEP_MODE_WEEKNIGHTS = "weeknights";
    public static String SLEEP_MODE_DAYS_PREFIX = "days:";
    public static int SOURCE_ANYONE = 0;
    public static int SOURCE_CONTACT = 1;
    public static int SOURCE_STAR = 2;
    public static int MAX_SOURCE = 2;
    public static int[] ALL_DAYS;
    public static int[] WEEKNIGHT_DAYS;
    public static int[] MINUTE_BUCKETS;
    private static int SECONDS_MS = 1000;
    private static int MINUTES_MS = 60000;
    private static int ZERO_VALUE_MS = 20000;
    private static boolean DEFAULT_ALLOW_EVENTS = true;
    private static int XML_VERSION = 1;
    private static String ZEN_TAG = "zen";
    private static String ZEN_ATT_VERSION = "version";
    private static String ALLOW_TAG = "allow";
    private static String ALLOW_ATT_CALLS = "calls";
    private static String ALLOW_ATT_MESSAGES = "messages";
    private static String ALLOW_ATT_FROM = "from";
    private static String ALLOW_ATT_EVENTS = "events";
    private static String SLEEP_TAG = "sleep";
    private static String SLEEP_ATT_MODE = "mode";
    private static String SLEEP_ATT_START_HR = "startHour";
    private static String SLEEP_ATT_START_MIN = "startMin";
    private static String SLEEP_ATT_END_HR = "endHour";
    private static String SLEEP_ATT_END_MIN = "endMin";
    private static String CONDITION_TAG = "condition";
    private static String CONDITION_ATT_COMPONENT = "component";
    private static String CONDITION_ATT_ID = "id";
    private static String CONDITION_ATT_SUMMARY = "summary";
    private static String CONDITION_ATT_LINE1 = "line1";
    private static String CONDITION_ATT_LINE2 = "line2";
    private static String CONDITION_ATT_ICON = "icon";
    private static String CONDITION_ATT_STATE = "state";
    private static String CONDITION_ATT_FLAGS = "flags";
    private static String EXIT_CONDITION_TAG = "exitCondition";
    private static String EXIT_CONDITION_ATT_COMPONENT = "component";
    public boolean allowCalls;
    public boolean allowMessages;
    public boolean allowEvents;
    public int allowFrom;
    public String sleepMode;
    public int sleepStartHour;
    public int sleepStartMinute;
    public int sleepEndHour;
    public int sleepEndMinute;
    public ComponentName[] conditionComponents;
    public Uri[] conditionIds;
    public Condition exitCondition;
    public ComponentName exitConditionComponent;
    public static Parcelable.Creator<ZenModeConfig> CREATOR;
    private static String SYSTEM_AUTHORITY = "android";
    private static String COUNTDOWN_PATH = "countdown";
    private static String DOWNTIME_PATH = "downtime";

    private void $$robo$$android_service_notification_ZenModeConfig$__constructor__() {
        this.allowEvents = true;
        this.allowFrom = 0;
    }

    private void $$robo$$android_service_notification_ZenModeConfig$__constructor__(Parcel source) {
        this.allowEvents = true;
        this.allowFrom = 0;
        this.allowCalls = source.readInt() == 1;
        this.allowMessages = source.readInt() == 1;
        boolean bl = this.allowEvents = source.readInt() == 1;
        if (source.readInt() == 1) {
            this.sleepMode = source.readString();
        }
        this.sleepStartHour = source.readInt();
        this.sleepStartMinute = source.readInt();
        this.sleepEndHour = source.readInt();
        this.sleepEndMinute = source.readInt();
        int len = source.readInt();
        if (len > 0) {
            this.conditionComponents = new ComponentName[len];
            source.readTypedArray(this.conditionComponents, ComponentName.CREATOR);
        }
        if ((len = source.readInt()) > 0) {
            this.conditionIds = new Uri[len];
            source.readTypedArray(this.conditionIds, Uri.CREATOR);
        }
        this.allowFrom = source.readInt();
        this.exitCondition = (Condition)source.readParcelable(null);
        this.exitConditionComponent = (ComponentName)source.readParcelable(null);
    }

    private final void $$robo$$android_service_notification_ZenModeConfig$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.allowCalls ? 1 : 0);
        dest.writeInt(this.allowMessages ? 1 : 0);
        dest.writeInt(this.allowEvents ? 1 : 0);
        if (this.sleepMode != null) {
            dest.writeInt(1);
            dest.writeString(this.sleepMode);
        } else {
            dest.writeInt(0);
        }
        dest.writeInt(this.sleepStartHour);
        dest.writeInt(this.sleepStartMinute);
        dest.writeInt(this.sleepEndHour);
        dest.writeInt(this.sleepEndMinute);
        if (this.conditionComponents != null && this.conditionComponents.length > 0) {
            dest.writeInt(this.conditionComponents.length);
            dest.writeTypedArray(this.conditionComponents, 0);
        } else {
            dest.writeInt(0);
        }
        if (this.conditionIds != null && this.conditionIds.length > 0) {
            dest.writeInt(this.conditionIds.length);
            dest.writeTypedArray(this.conditionIds, 0);
        } else {
            dest.writeInt(0);
        }
        dest.writeInt(this.allowFrom);
        dest.writeParcelable(this.exitCondition, 0);
        dest.writeParcelable(this.exitConditionComponent, 0);
    }

    private final String $$robo$$android_service_notification_ZenModeConfig$toString() {
        return ZenModeConfig.class.getSimpleName() + '[' + "allowCalls=" + this.allowCalls + ",allowMessages=" + this.allowMessages + ",allowFrom=" + ZenModeConfig.sourceToString(this.allowFrom) + ",allowEvents=" + this.allowEvents + ",sleepMode=" + this.sleepMode + ",sleepStart=" + this.sleepStartHour + '.' + this.sleepStartMinute + ",sleepEnd=" + this.sleepEndHour + '.' + this.sleepEndMinute + ",conditionComponents=" + (this.conditionComponents == null ? null : TextUtils.join((CharSequence)",", this.conditionComponents)) + ",conditionIds=" + (this.conditionIds == null ? null : TextUtils.join((CharSequence)",", this.conditionIds)) + ",exitCondition=" + this.exitCondition + ",exitConditionComponent=" + this.exitConditionComponent + ']';
    }

    private static final String $$robo$$android_service_notification_ZenModeConfig$sourceToString(int source) {
        switch (source) {
            case 0: {
                return "anyone";
            }
            case 1: {
                return "contacts";
            }
            case 2: {
                return "stars";
            }
        }
        return "UNKNOWN";
    }

    private final boolean $$robo$$android_service_notification_ZenModeConfig$equals(Object o) {
        if (!(o instanceof ZenModeConfig)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        ZenModeConfig other = (ZenModeConfig)o;
        return other.allowCalls == this.allowCalls && other.allowMessages == this.allowMessages && other.allowFrom == this.allowFrom && other.allowEvents == this.allowEvents && Objects.equals(other.sleepMode, this.sleepMode) && other.sleepStartHour == this.sleepStartHour && other.sleepStartMinute == this.sleepStartMinute && other.sleepEndHour == this.sleepEndHour && other.sleepEndMinute == this.sleepEndMinute && Objects.deepEquals(other.conditionComponents, this.conditionComponents) && Objects.deepEquals(other.conditionIds, this.conditionIds) && Objects.equals(other.exitCondition, this.exitCondition) && Objects.equals(other.exitConditionComponent, this.exitConditionComponent);
    }

    private final int $$robo$$android_service_notification_ZenModeConfig$hashCode() {
        return Objects.hash(this.allowCalls, this.allowMessages, this.allowFrom, this.allowEvents, this.sleepMode, this.sleepStartHour, this.sleepStartMinute, this.sleepEndHour, this.sleepEndMinute, Arrays.hashCode(this.conditionComponents), Arrays.hashCode(this.conditionIds), this.exitCondition, this.exitConditionComponent);
    }

    private final boolean $$robo$$android_service_notification_ZenModeConfig$isValid() {
        return ZenModeConfig.isValidHour(this.sleepStartHour) && ZenModeConfig.isValidMinute(this.sleepStartMinute) && ZenModeConfig.isValidHour(this.sleepEndHour) && ZenModeConfig.isValidMinute(this.sleepEndMinute) && ZenModeConfig.isValidSleepMode(this.sleepMode);
    }

    private static final boolean $$robo$$android_service_notification_ZenModeConfig$isValidSleepMode(String sleepMode) {
        return sleepMode == null || sleepMode.equals("nights") || sleepMode.equals("weeknights") || ZenModeConfig.tryParseDays(sleepMode) != null;
    }

    private static final int[] $$robo$$android_service_notification_ZenModeConfig$tryParseDays(String sleepMode) {
        if (sleepMode == null) {
            return null;
        }
        if ("nights".equals(sleepMode = sleepMode.trim())) {
            return ALL_DAYS;
        }
        if ("weeknights".equals(sleepMode)) {
            return WEEKNIGHT_DAYS;
        }
        if (!sleepMode.startsWith("days:")) {
            return null;
        }
        if (sleepMode.equals("days:")) {
            return null;
        }
        String[] tokens = sleepMode.substring("days:".length()).split(",");
        if (tokens.length == 0) {
            return null;
        }
        int[] rt = new int[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            int day = ZenModeConfig.tryParseInt(tokens[i], -1);
            if (day == -1) {
                return null;
            }
            rt[i] = day;
        }
        return rt;
    }

    private static final int $$robo$$android_service_notification_ZenModeConfig$tryParseInt(String value, int defValue) {
        if (TextUtils.isEmpty(value)) {
            return defValue;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    private static final ZenModeConfig $$robo$$android_service_notification_ZenModeConfig$readXml(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type = parser.getEventType();
        if (type != 2) {
            return null;
        }
        String tag = parser.getName();
        if (!"zen".equals(tag)) {
            return null;
        }
        ZenModeConfig rt = new ZenModeConfig();
        int version = ZenModeConfig.safeInt(parser, "version", 1);
        ArrayList<ComponentName> conditionComponents = new ArrayList<ComponentName>();
        ArrayList<Uri> conditionIds = new ArrayList<Uri>();
        while ((type = parser.next()) != 1) {
            tag = parser.getName();
            if (type == 3 && "zen".equals(tag)) {
                if (!conditionComponents.isEmpty()) {
                    rt.conditionComponents = conditionComponents.toArray(new ComponentName[conditionComponents.size()]);
                    rt.conditionIds = conditionIds.toArray(new Uri[conditionIds.size()]);
                }
                return rt;
            }
            if (type != 2) continue;
            if ("allow".equals(tag)) {
                rt.allowCalls = ZenModeConfig.safeBoolean(parser, "calls", false);
                rt.allowMessages = ZenModeConfig.safeBoolean(parser, "messages", false);
                rt.allowEvents = ZenModeConfig.safeBoolean(parser, "events", true);
                rt.allowFrom = ZenModeConfig.safeInt(parser, "from", 0);
                if (rt.allowFrom >= 0 && rt.allowFrom <= 2) continue;
                throw new IndexOutOfBoundsException("bad source in config:" + rt.allowFrom);
            }
            if ("sleep".equals(tag)) {
                String mode = parser.getAttributeValue(null, "mode");
                rt.sleepMode = ZenModeConfig.isValidSleepMode(mode) ? mode : null;
                int startHour = ZenModeConfig.safeInt(parser, "startHour", 0);
                int startMinute = ZenModeConfig.safeInt(parser, "startMin", 0);
                int endHour = ZenModeConfig.safeInt(parser, "endHour", 0);
                int endMinute = ZenModeConfig.safeInt(parser, "endMin", 0);
                rt.sleepStartHour = ZenModeConfig.isValidHour(startHour) ? startHour : 0;
                rt.sleepStartMinute = ZenModeConfig.isValidMinute(startMinute) ? startMinute : 0;
                rt.sleepEndHour = ZenModeConfig.isValidHour(endHour) ? endHour : 0;
                rt.sleepEndMinute = ZenModeConfig.isValidMinute(endMinute) ? endMinute : 0;
                continue;
            }
            if ("condition".equals(tag)) {
                ComponentName component = ZenModeConfig.safeComponentName(parser, "component");
                Uri conditionId = ZenModeConfig.safeUri(parser, "id");
                if (component == null || conditionId == null) continue;
                conditionComponents.add(component);
                conditionIds.add(conditionId);
                continue;
            }
            if (!"exitCondition".equals(tag)) continue;
            rt.exitCondition = ZenModeConfig.readConditionXml(parser);
            if (rt.exitCondition == null) continue;
            rt.exitConditionComponent = ZenModeConfig.safeComponentName(parser, "component");
        }
        throw new IllegalStateException("Failed to reach END_DOCUMENT");
    }

    private final void $$robo$$android_service_notification_ZenModeConfig$writeXml(XmlSerializer out) throws IOException {
        out.startTag(null, "zen");
        out.attribute(null, "version", Integer.toString(1));
        out.startTag(null, "allow");
        out.attribute(null, "calls", Boolean.toString(this.allowCalls));
        out.attribute(null, "messages", Boolean.toString(this.allowMessages));
        out.attribute(null, "events", Boolean.toString(this.allowEvents));
        out.attribute(null, "from", Integer.toString(this.allowFrom));
        out.endTag(null, "allow");
        out.startTag(null, "sleep");
        if (this.sleepMode != null) {
            out.attribute(null, "mode", this.sleepMode);
        }
        out.attribute(null, "startHour", Integer.toString(this.sleepStartHour));
        out.attribute(null, "startMin", Integer.toString(this.sleepStartMinute));
        out.attribute(null, "endHour", Integer.toString(this.sleepEndHour));
        out.attribute(null, "endMin", Integer.toString(this.sleepEndMinute));
        out.endTag(null, "sleep");
        if (this.conditionComponents != null && this.conditionIds != null && this.conditionComponents.length == this.conditionIds.length) {
            for (int i = 0; i < this.conditionComponents.length; ++i) {
                out.startTag(null, "condition");
                out.attribute(null, "component", this.conditionComponents[i].flattenToString());
                out.attribute(null, "id", this.conditionIds[i].toString());
                out.endTag(null, "condition");
            }
        }
        if (this.exitCondition != null && this.exitConditionComponent != null) {
            out.startTag(null, "exitCondition");
            out.attribute(null, "component", this.exitConditionComponent.flattenToString());
            ZenModeConfig.writeConditionXml(this.exitCondition, out);
            out.endTag(null, "exitCondition");
        }
        out.endTag(null, "zen");
    }

    private static final Condition $$robo$$android_service_notification_ZenModeConfig$readConditionXml(XmlPullParser parser) {
        Uri id2 = ZenModeConfig.safeUri(parser, "id");
        String summary = parser.getAttributeValue(null, "summary");
        String line1 = parser.getAttributeValue(null, "line1");
        String line2 = parser.getAttributeValue(null, "line2");
        int icon = ZenModeConfig.safeInt(parser, "icon", -1);
        int state = ZenModeConfig.safeInt(parser, "state", -1);
        int flags = ZenModeConfig.safeInt(parser, "flags", -1);
        try {
            return new Condition(id2, summary, line1, line2, icon, state, flags);
        }
        catch (IllegalArgumentException e) {
            Slog.w(TAG, "Unable to read condition xml", e);
            return null;
        }
    }

    private static final void $$robo$$android_service_notification_ZenModeConfig$writeConditionXml(Condition c, XmlSerializer out) throws IOException {
        out.attribute(null, "id", c.id.toString());
        out.attribute(null, "summary", c.summary);
        out.attribute(null, "line1", c.line1);
        out.attribute(null, "line2", c.line2);
        out.attribute(null, "icon", Integer.toString(c.icon));
        out.attribute(null, "state", Integer.toString(c.state));
        out.attribute(null, "flags", Integer.toString(c.flags));
    }

    private static final boolean $$robo$$android_service_notification_ZenModeConfig$isValidHour(int val) {
        return val >= 0 && val < 24;
    }

    private static final boolean $$robo$$android_service_notification_ZenModeConfig$isValidMinute(int val) {
        return val >= 0 && val < 60;
    }

    private static final boolean $$robo$$android_service_notification_ZenModeConfig$safeBoolean(XmlPullParser parser, String att, boolean defValue) {
        String val = parser.getAttributeValue(null, att);
        if (TextUtils.isEmpty(val)) {
            return defValue;
        }
        return Boolean.valueOf(val);
    }

    private static final int $$robo$$android_service_notification_ZenModeConfig$safeInt(XmlPullParser parser, String att, int defValue) {
        String val = parser.getAttributeValue(null, att);
        return ZenModeConfig.tryParseInt(val, defValue);
    }

    private static final ComponentName $$robo$$android_service_notification_ZenModeConfig$safeComponentName(XmlPullParser parser, String att) {
        String val = parser.getAttributeValue(null, att);
        if (TextUtils.isEmpty(val)) {
            return null;
        }
        return ComponentName.unflattenFromString(val);
    }

    private static final Uri $$robo$$android_service_notification_ZenModeConfig$safeUri(XmlPullParser parser, String att) {
        String val = parser.getAttributeValue(null, att);
        if (TextUtils.isEmpty(val)) {
            return null;
        }
        return Uri.parse(val);
    }

    private final int $$robo$$android_service_notification_ZenModeConfig$describeContents() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ZenModeConfig $$robo$$android_service_notification_ZenModeConfig$copy() {
        Parcel parcel = Parcel.obtain();
        try {
            this.writeToParcel(parcel, 0);
            parcel.setDataPosition(0);
            ZenModeConfig zenModeConfig = new ZenModeConfig(parcel);
            return zenModeConfig;
        }
        finally {
            parcel.recycle();
        }
    }

    private final DowntimeInfo $$robo$$android_service_notification_ZenModeConfig$toDowntimeInfo() {
        DowntimeInfo downtime = new DowntimeInfo();
        downtime.startHour = this.sleepStartHour;
        downtime.startMinute = this.sleepStartMinute;
        downtime.endHour = this.sleepEndHour;
        downtime.endMinute = this.sleepEndMinute;
        return downtime;
    }

    private static final Condition $$robo$$android_service_notification_ZenModeConfig$toTimeCondition(int minutesFromNow) {
        CallSite now = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        long millis = minutesFromNow == 0 ? 20000L : (long)(minutesFromNow * 60000);
        return ZenModeConfig.toTimeCondition((long)(now + millis), minutesFromNow);
    }

    private static final Condition $$robo$$android_service_notification_ZenModeConfig$toTimeCondition(long time, int minutes) {
        int num = minutes < 60 ? minutes : Math.round((float)minutes / 60.0f);
        int resId = minutes < 60 ? 18087961 : 18087962;
        String caption = Resources.getSystem().getQuantityString(resId, num, num);
        Uri id2 = ZenModeConfig.toCountdownConditionId(time);
        return new Condition(id2, caption, "", "", 0, 1, 1);
    }

    private static final Uri $$robo$$android_service_notification_ZenModeConfig$toCountdownConditionId(long time) {
        return new Uri.Builder().scheme("condition").authority("android").appendPath("countdown").appendPath(Long.toString(time)).build();
    }

    private static final long $$robo$$android_service_notification_ZenModeConfig$tryParseCountdownConditionId(Uri conditionId) {
        if (!Condition.isValidId(conditionId, "android")) {
            return 0L;
        }
        if (conditionId.getPathSegments().size() != 2 || !"countdown".equals(conditionId.getPathSegments().get(0))) {
            return 0L;
        }
        try {
            return Long.parseLong(conditionId.getPathSegments().get(1));
        }
        catch (RuntimeException e) {
            Slog.w(TAG, "Error parsing countdown condition: " + conditionId, e);
            return 0L;
        }
    }

    private static final boolean $$robo$$android_service_notification_ZenModeConfig$isValidCountdownConditionId(Uri conditionId) {
        return ZenModeConfig.tryParseCountdownConditionId(conditionId) != 0L;
    }

    private static final Uri $$robo$$android_service_notification_ZenModeConfig$toDowntimeConditionId(DowntimeInfo downtime) {
        return new Uri.Builder().scheme("condition").authority("android").appendPath("downtime").appendQueryParameter("start", downtime.startHour + "." + downtime.startMinute).appendQueryParameter("end", downtime.endHour + "." + downtime.endMinute).build();
    }

    private static final DowntimeInfo $$robo$$android_service_notification_ZenModeConfig$tryParseDowntimeConditionId(Uri conditionId) {
        if (!Condition.isValidId(conditionId, "android") || conditionId.getPathSegments().size() != 1 || !"downtime".equals(conditionId.getPathSegments().get(0))) {
            return null;
        }
        int[] start = ZenModeConfig.tryParseHourAndMinute(conditionId.getQueryParameter("start"));
        int[] end = ZenModeConfig.tryParseHourAndMinute(conditionId.getQueryParameter("end"));
        if (start == null || end == null) {
            return null;
        }
        DowntimeInfo downtime = new DowntimeInfo();
        downtime.startHour = start[0];
        downtime.startMinute = start[1];
        downtime.endHour = end[0];
        downtime.endMinute = end[1];
        return downtime;
    }

    private static final int[] $$robo$$android_service_notification_ZenModeConfig$tryParseHourAndMinute(String value) {
        int[] nArray;
        if (TextUtils.isEmpty(value)) {
            return null;
        }
        int i = value.indexOf(46);
        if (i < 1 || i >= value.length() - 1) {
            return null;
        }
        int hour = ZenModeConfig.tryParseInt(value.substring(0, i), -1);
        int minute = ZenModeConfig.tryParseInt(value.substring(i + 1), -1);
        if (ZenModeConfig.isValidHour(hour) && ZenModeConfig.isValidMinute(minute)) {
            int[] nArray2 = new int[2];
            nArray2[0] = hour;
            nArray = nArray2;
            nArray2[1] = minute;
        } else {
            nArray = null;
        }
        return nArray;
    }

    private static final boolean $$robo$$android_service_notification_ZenModeConfig$isValidDowntimeConditionId(Uri conditionId) {
        return ZenModeConfig.tryParseDowntimeConditionId(conditionId) != null;
    }

    static void __staticInitializer__() {
        TAG = "ZenModeConfig";
        ALL_DAYS = new int[]{1, 2, 3, 4, 5, 6, 7};
        WEEKNIGHT_DAYS = new int[]{1, 2, 3, 4, 5};
        MINUTE_BUCKETS = new int[]{15, 30, 45, 60, 120, 180, 240, 480};
        CREATOR = new Parcelable.Creator<ZenModeConfig>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_service_notification_ZenModeConfig_1$__constructor__() {
            }

            private final ZenModeConfig $$robo$$android_service_notification_ZenModeConfig_1$createFromParcel(Parcel source) {
                return new ZenModeConfig(source);
            }

            private final ZenModeConfig[] $$robo$$android_service_notification_ZenModeConfig_1$newArray(int size) {
                return new ZenModeConfig[size];
            }

            private void __constructor__() {
                this.$$robo$$android_service_notification_ZenModeConfig_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_notification_ZenModeConfig_1$__constructor__(), 0, this);
            }

            @Override
            public ZenModeConfig createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_service_notification_ZenModeConfig_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public ZenModeConfig[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_service_notification_ZenModeConfig_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_service_notification_ZenModeConfig$__constructor__();
    }

    public ZenModeConfig() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_notification_ZenModeConfig$__constructor__(), 0, this);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_service_notification_ZenModeConfig$__constructor__(parcel);
    }

    public ZenModeConfig(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_notification_ZenModeConfig$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_service_notification_ZenModeConfig$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_service_notification_ZenModeConfig$toString(), 0, this);
    }

    public static String sourceToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("sourceToString", $$robo$$android_service_notification_ZenModeConfig$sourceToString(int ), 0, (int)n);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_service_notification_ZenModeConfig$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_service_notification_ZenModeConfig$hashCode(), 0, this);
    }

    public boolean isValid() {
        return (boolean)InvokeDynamicSupport.bootstrap("isValid", $$robo$$android_service_notification_ZenModeConfig$isValid(), 0, this);
    }

    public static boolean isValidSleepMode(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidSleepMode", $$robo$$android_service_notification_ZenModeConfig$isValidSleepMode(java.lang.String ), 0, (String)string2);
    }

    public static int[] tryParseDays(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("tryParseDays", $$robo$$android_service_notification_ZenModeConfig$tryParseDays(java.lang.String ), 0, (String)string2);
    }

    private static int tryParseInt(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("tryParseInt", $$robo$$android_service_notification_ZenModeConfig$tryParseInt(java.lang.String int ), 0, (String)string2, (int)n);
    }

    public static ZenModeConfig readXml(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("readXml", $$robo$$android_service_notification_ZenModeConfig$readXml(org.xmlpull.v1.XmlPullParser ), 0, (XmlPullParser)xmlPullParser);
    }

    public void writeXml(XmlSerializer xmlSerializer) throws IOException {
        InvokeDynamicSupport.bootstrap("writeXml", $$robo$$android_service_notification_ZenModeConfig$writeXml(org.xmlpull.v1.XmlSerializer ), 0, this, xmlSerializer);
    }

    public static Condition readConditionXml(XmlPullParser xmlPullParser) {
        return InvokeDynamicSupport.bootstrapStatic("readConditionXml", $$robo$$android_service_notification_ZenModeConfig$readConditionXml(org.xmlpull.v1.XmlPullParser ), 0, (XmlPullParser)xmlPullParser);
    }

    public static void writeConditionXml(Condition condition, XmlSerializer xmlSerializer) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("writeConditionXml", $$robo$$android_service_notification_ZenModeConfig$writeConditionXml(android.service.notification.Condition org.xmlpull.v1.XmlSerializer ), 0, (Condition)condition, (XmlSerializer)xmlSerializer);
    }

    public static boolean isValidHour(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidHour", $$robo$$android_service_notification_ZenModeConfig$isValidHour(int ), 0, (int)n);
    }

    public static boolean isValidMinute(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidMinute", $$robo$$android_service_notification_ZenModeConfig$isValidMinute(int ), 0, (int)n);
    }

    private static boolean safeBoolean(XmlPullParser xmlPullParser, String string2, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("safeBoolean", $$robo$$android_service_notification_ZenModeConfig$safeBoolean(org.xmlpull.v1.XmlPullParser java.lang.String boolean ), 0, (XmlPullParser)xmlPullParser, (String)string2, (boolean)bl);
    }

    private static int safeInt(XmlPullParser xmlPullParser, String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("safeInt", $$robo$$android_service_notification_ZenModeConfig$safeInt(org.xmlpull.v1.XmlPullParser java.lang.String int ), 0, (XmlPullParser)xmlPullParser, (String)string2, (int)n);
    }

    private static ComponentName safeComponentName(XmlPullParser xmlPullParser, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("safeComponentName", $$robo$$android_service_notification_ZenModeConfig$safeComponentName(org.xmlpull.v1.XmlPullParser java.lang.String ), 0, (XmlPullParser)xmlPullParser, (String)string2);
    }

    private static Uri safeUri(XmlPullParser xmlPullParser, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("safeUri", $$robo$$android_service_notification_ZenModeConfig$safeUri(org.xmlpull.v1.XmlPullParser java.lang.String ), 0, (XmlPullParser)xmlPullParser, (String)string2);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_service_notification_ZenModeConfig$describeContents(), 0, this);
    }

    public ZenModeConfig copy() {
        return InvokeDynamicSupport.bootstrap("copy", $$robo$$android_service_notification_ZenModeConfig$copy(), 0, this);
    }

    public DowntimeInfo toDowntimeInfo() {
        return InvokeDynamicSupport.bootstrap("toDowntimeInfo", $$robo$$android_service_notification_ZenModeConfig$toDowntimeInfo(), 0, this);
    }

    public static Condition toTimeCondition(int n) {
        return InvokeDynamicSupport.bootstrapStatic("toTimeCondition", $$robo$$android_service_notification_ZenModeConfig$toTimeCondition(int ), 0, (int)n);
    }

    public static Condition toTimeCondition(long l, int n) {
        return InvokeDynamicSupport.bootstrapStatic("toTimeCondition", $$robo$$android_service_notification_ZenModeConfig$toTimeCondition(long int ), 0, (long)l, (int)n);
    }

    public static Uri toCountdownConditionId(long l) {
        return InvokeDynamicSupport.bootstrapStatic("toCountdownConditionId", $$robo$$android_service_notification_ZenModeConfig$toCountdownConditionId(long ), 0, (long)l);
    }

    public static long tryParseCountdownConditionId(Uri uri) {
        return (long)InvokeDynamicSupport.bootstrapStatic("tryParseCountdownConditionId", $$robo$$android_service_notification_ZenModeConfig$tryParseCountdownConditionId(android.net.Uri ), 0, (Uri)uri);
    }

    public static boolean isValidCountdownConditionId(Uri uri) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidCountdownConditionId", $$robo$$android_service_notification_ZenModeConfig$isValidCountdownConditionId(android.net.Uri ), 0, (Uri)uri);
    }

    public static Uri toDowntimeConditionId(DowntimeInfo downtimeInfo) {
        return InvokeDynamicSupport.bootstrapStatic("toDowntimeConditionId", $$robo$$android_service_notification_ZenModeConfig$toDowntimeConditionId(android.service.notification.ZenModeConfig$DowntimeInfo ), 0, (DowntimeInfo)downtimeInfo);
    }

    public static DowntimeInfo tryParseDowntimeConditionId(Uri uri) {
        return InvokeDynamicSupport.bootstrapStatic("tryParseDowntimeConditionId", $$robo$$android_service_notification_ZenModeConfig$tryParseDowntimeConditionId(android.net.Uri ), 0, (Uri)uri);
    }

    private static int[] tryParseHourAndMinute(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("tryParseHourAndMinute", $$robo$$android_service_notification_ZenModeConfig$tryParseHourAndMinute(java.lang.String ), 0, (String)string2);
    }

    public static boolean isValidDowntimeConditionId(Uri uri) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidDowntimeConditionId", $$robo$$android_service_notification_ZenModeConfig$isValidDowntimeConditionId(android.net.Uri ), 0, (Uri)uri);
    }

    static {
        RobolectricInternals.classInitializing(ZenModeConfig.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ZenModeConfig)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class DowntimeInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int startHour;
        public int startMinute;
        public int endHour;
        public int endMinute;

        private void $$robo$$android_service_notification_ZenModeConfig_DowntimeInfo$__constructor__() {
        }

        private final int $$robo$$android_service_notification_ZenModeConfig_DowntimeInfo$hashCode() {
            return 0;
        }

        private final boolean $$robo$$android_service_notification_ZenModeConfig_DowntimeInfo$equals(Object o) {
            if (!(o instanceof DowntimeInfo)) {
                return false;
            }
            DowntimeInfo other = (DowntimeInfo)o;
            return this.startHour == other.startHour && this.startMinute == other.startMinute && this.endHour == other.endHour && this.endMinute == other.endMinute;
        }

        private void __constructor__() {
            this.$$robo$$android_service_notification_ZenModeConfig_DowntimeInfo$__constructor__();
        }

        public DowntimeInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_notification_ZenModeConfig_DowntimeInfo$__constructor__(), 0, this);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_service_notification_ZenModeConfig_DowntimeInfo$hashCode(), 0, this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_service_notification_ZenModeConfig_DowntimeInfo$equals(java.lang.Object ), 0, this, object);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DowntimeInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

