/*
 * Decompiled with CFR 0.152.
 */
package android.speech.srec;

import com.google.errorprone.annotations.DoNotMock;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Recognizer
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    public static String KEY_CONFIDENCE = "conf";
    public static String KEY_LITERAL = "literal";
    public static String KEY_MEANING = "meaning";
    private long mVocabulary;
    private long mRecognizer;
    private Grammar mActiveGrammar;
    private byte[] mPutAudioBuffer;
    public static int EVENT_INVALID = 0;
    public static int EVENT_NO_MATCH = 1;
    public static int EVENT_INCOMPLETE = 2;
    public static int EVENT_STARTED = 3;
    public static int EVENT_STOPPED = 4;
    public static int EVENT_START_OF_VOICING = 5;
    public static int EVENT_END_OF_VOICING = 6;
    public static int EVENT_SPOKE_TOO_SOON = 7;
    public static int EVENT_RECOGNITION_RESULT = 8;
    public static int EVENT_START_OF_UTTERANCE_TIMEOUT = 9;
    public static int EVENT_RECOGNITION_TIMEOUT = 10;
    public static int EVENT_NEED_MORE_AUDIO = 11;
    public static int EVENT_MAX_SPEECH = 12;

    private static final String $$robo$$android_speech_srec_Recognizer$getConfigDir(Locale locale) {
        String dir;
        if (locale == null) {
            locale = Locale.US;
        }
        if (new File(dir = "/system/usr/srec/config/" + locale.toString().replace('_', '.').toLowerCase(Locale.ROOT)).isDirectory()) {
            return dir;
        }
        return null;
    }

    private void $$robo$$android_speech_srec_Recognizer$__constructor__(String configFile) throws IOException {
        this.mVocabulary = 0L;
        this.mRecognizer = 0L;
        this.mActiveGrammar = null;
        this.mPutAudioBuffer = null;
        Recognizer.PMemInit();
        Recognizer.SR_SessionCreate(configFile);
        this.mRecognizer = Recognizer.SR_RecognizerCreate();
        Recognizer.SR_RecognizerSetup(this.mRecognizer);
        this.mVocabulary = Recognizer.SR_VocabularyLoad();
    }

    private final void $$robo$$android_speech_srec_Recognizer$start() {
        Recognizer.SR_RecognizerActivateRule(this.mRecognizer, this.mActiveGrammar.mGrammar, "trash", 1);
        Recognizer.SR_RecognizerStart(this.mRecognizer);
    }

    private final int $$robo$$android_speech_srec_Recognizer$advance() {
        return Recognizer.SR_RecognizerAdvance(this.mRecognizer);
    }

    private final int $$robo$$android_speech_srec_Recognizer$putAudio(byte[] buf, int offset, int length, boolean isLast) {
        return Recognizer.SR_RecognizerPutAudio(this.mRecognizer, buf, offset, length, isLast);
    }

    private final void $$robo$$android_speech_srec_Recognizer$putAudio(InputStream audio) throws IOException {
        int nbytes;
        if (this.mPutAudioBuffer == null) {
            this.mPutAudioBuffer = new byte[512];
        }
        if ((nbytes = audio.read(this.mPutAudioBuffer)) == -1) {
            Recognizer.SR_RecognizerPutAudio(this.mRecognizer, this.mPutAudioBuffer, 0, 0, true);
        } else if (nbytes != Recognizer.SR_RecognizerPutAudio(this.mRecognizer, this.mPutAudioBuffer, 0, nbytes, false)) {
            throw new IOException("SR_RecognizerPutAudio failed nbytes=" + nbytes);
        }
    }

    private final int $$robo$$android_speech_srec_Recognizer$getResultCount() {
        return Recognizer.SR_RecognizerResultGetSize(this.mRecognizer);
    }

    private final String[] $$robo$$android_speech_srec_Recognizer$getResultKeys(int index) {
        return Recognizer.SR_RecognizerResultGetKeyList(this.mRecognizer, index);
    }

    private final String $$robo$$android_speech_srec_Recognizer$getResult(int index, String key) {
        return Recognizer.SR_RecognizerResultGetValue(this.mRecognizer, index, key);
    }

    private final void $$robo$$android_speech_srec_Recognizer$stop() {
        Recognizer.SR_RecognizerStop(this.mRecognizer);
        Recognizer.SR_RecognizerDeactivateRule(this.mRecognizer, this.mActiveGrammar.mGrammar, "trash");
    }

    private final void $$robo$$android_speech_srec_Recognizer$resetAcousticState() {
        Recognizer.SR_AcousticStateReset(this.mRecognizer);
    }

    private final void $$robo$$android_speech_srec_Recognizer$setAcousticState(String state) {
        Recognizer.SR_AcousticStateSet(this.mRecognizer, state);
    }

    private final String $$robo$$android_speech_srec_Recognizer$getAcousticState() {
        return Recognizer.SR_AcousticStateGet(this.mRecognizer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_speech_srec_Recognizer$destroy() {
        try {
            if (this.mVocabulary != 0L) {
                Recognizer.SR_VocabularyDestroy(this.mVocabulary);
            }
        }
        finally {
            this.mVocabulary = 0L;
            try {
                if (this.mRecognizer != 0L) {
                    Recognizer.SR_RecognizerUnsetup(this.mRecognizer);
                }
            }
            finally {
                try {
                    if (this.mRecognizer != 0L) {
                        Recognizer.SR_RecognizerDestroy(this.mRecognizer);
                    }
                }
                finally {
                    this.mRecognizer = 0L;
                    try {
                        Recognizer.SR_SessionDestroy();
                    }
                    finally {
                        Recognizer.PMemShutdown();
                    }
                }
            }
        }
    }

    private final void $$robo$$android_speech_srec_Recognizer$finalize() throws Throwable {
        if (this.mVocabulary != 0L || this.mRecognizer != 0L) {
            this.destroy();
            throw new IllegalStateException("someone forgot to destroy Recognizer");
        }
    }

    private static final void $$robo$$android_speech_srec_Recognizer$PMemInit() {
    }

    private static final void $$robo$$android_speech_srec_Recognizer$PMemShutdown() {
    }

    private static final void $$robo$$android_speech_srec_Recognizer$SR_SessionCreate(String string2) {
    }

    private static final void $$robo$$android_speech_srec_Recognizer$SR_SessionDestroy() {
    }

    private static final String $$robo$$android_speech_srec_Recognizer$eventToString(int event) {
        switch (event) {
            case 0: {
                return "EVENT_INVALID";
            }
            case 1: {
                return "EVENT_NO_MATCH";
            }
            case 2: {
                return "EVENT_INCOMPLETE";
            }
            case 3: {
                return "EVENT_STARTED";
            }
            case 4: {
                return "EVENT_STOPPED";
            }
            case 5: {
                return "EVENT_START_OF_VOICING";
            }
            case 6: {
                return "EVENT_END_OF_VOICING";
            }
            case 7: {
                return "EVENT_SPOKE_TOO_SOON";
            }
            case 8: {
                return "EVENT_RECOGNITION_RESULT";
            }
            case 9: {
                return "EVENT_START_OF_UTTERANCE_TIMEOUT";
            }
            case 10: {
                return "EVENT_RECOGNITION_TIMEOUT";
            }
            case 11: {
                return "EVENT_NEED_MORE_AUDIO";
            }
            case 12: {
                return "EVENT_MAX_SPEECH";
            }
        }
        return "EVENT_" + event;
    }

    private static final void $$robo$$android_speech_srec_Recognizer$SR_RecognizerStart(long l) {
    }

    private static final void $$robo$$android_speech_srec_Recognizer$SR_RecognizerStop(long l) {
    }

    private static final long $$robo$$android_speech_srec_Recognizer$SR_RecognizerCreate() {
        return 0L;
    }

    private static final void $$robo$$android_speech_srec_Recognizer$SR_RecognizerDestroy(long l) {
    }

    private static final void $$robo$$android_speech_srec_Recognizer$SR_RecognizerSetup(long l) {
    }

    private static final void $$robo$$android_speech_srec_Recognizer$SR_RecognizerUnsetup(long l) {
    }

    private static final boolean $$robo$$android_speech_srec_Recognizer$SR_RecognizerIsSetup(long l) {
        return false;
    }

    private static final String $$robo$$android_speech_srec_Recognizer$SR_RecognizerGetParameter(long l, String string2) {
        return null;
    }

    private static final int $$robo$$android_speech_srec_Recognizer$SR_RecognizerGetSize_tParameter(long l, String string2) {
        return 0;
    }

    private static final boolean $$robo$$android_speech_srec_Recognizer$SR_RecognizerGetBoolParameter(long l, String string2) {
        return false;
    }

    private static final void $$robo$$android_speech_srec_Recognizer$SR_RecognizerSetParameter(long l, String string2, String string3) {
    }

    private static final void $$robo$$android_speech_srec_Recognizer$SR_RecognizerSetSize_tParameter(long l, String string2, int n) {
    }

    private static final void $$robo$$android_speech_srec_Recognizer$SR_RecognizerSetBoolParameter(long l, String string2, boolean bl) {
    }

    private static final void $$robo$$android_speech_srec_Recognizer$SR_RecognizerSetupRule(long l, long l2, String string2) {
    }

    private static final boolean $$robo$$android_speech_srec_Recognizer$SR_RecognizerHasSetupRules(long l) {
        return false;
    }

    private static final void $$robo$$android_speech_srec_Recognizer$SR_RecognizerActivateRule(long l, long l2, String string2, int n) {
    }

    private static final void $$robo$$android_speech_srec_Recognizer$SR_RecognizerDeactivateRule(long l, long l2, String string2) {
    }

    private static final void $$robo$$android_speech_srec_Recognizer$SR_RecognizerDeactivateAllRules(long l) {
    }

    private static final boolean $$robo$$android_speech_srec_Recognizer$SR_RecognizerIsActiveRule(long l, long l2, String string2) {
        return false;
    }

    private static final boolean $$robo$$android_speech_srec_Recognizer$SR_RecognizerCheckGrammarConsistency(long l, long l2) {
        return false;
    }

    private static final int $$robo$$android_speech_srec_Recognizer$SR_RecognizerPutAudio(long l, byte[] byArray, int n, int n2, boolean bl) {
        return 0;
    }

    private static final int $$robo$$android_speech_srec_Recognizer$SR_RecognizerAdvance(long l) {
        return 0;
    }

    private static final boolean $$robo$$android_speech_srec_Recognizer$SR_RecognizerIsSignalClipping(long l) {
        return false;
    }

    private static final boolean $$robo$$android_speech_srec_Recognizer$SR_RecognizerIsSignalDCOffset(long l) {
        return false;
    }

    private static final boolean $$robo$$android_speech_srec_Recognizer$SR_RecognizerIsSignalNoisy(long l) {
        return false;
    }

    private static final boolean $$robo$$android_speech_srec_Recognizer$SR_RecognizerIsSignalTooQuiet(long l) {
        return false;
    }

    private static final boolean $$robo$$android_speech_srec_Recognizer$SR_RecognizerIsSignalTooFewSamples(long l) {
        return false;
    }

    private static final boolean $$robo$$android_speech_srec_Recognizer$SR_RecognizerIsSignalTooManySamples(long l) {
        return false;
    }

    private static final void $$robo$$android_speech_srec_Recognizer$SR_AcousticStateReset(long l) {
    }

    private static final void $$robo$$android_speech_srec_Recognizer$SR_AcousticStateSet(long l, String string2) {
    }

    private static final String $$robo$$android_speech_srec_Recognizer$SR_AcousticStateGet(long l) {
        return null;
    }

    private static final void $$robo$$android_speech_srec_Recognizer$SR_GrammarCompile(long l) {
    }

    private static final void $$robo$$android_speech_srec_Recognizer$SR_GrammarAddWordToSlot(long l, String string2, String string3, String string4, int n, String string5) {
    }

    private static final void $$robo$$android_speech_srec_Recognizer$SR_GrammarResetAllSlots(long l) {
    }

    private static final void $$robo$$android_speech_srec_Recognizer$SR_GrammarSetupVocabulary(long l, long l2) {
    }

    private static final void $$robo$$android_speech_srec_Recognizer$SR_GrammarSetupRecognizer(long l, long l2) {
    }

    private static final void $$robo$$android_speech_srec_Recognizer$SR_GrammarUnsetupRecognizer(long l) {
    }

    private static final long $$robo$$android_speech_srec_Recognizer$SR_GrammarCreate() {
        return 0L;
    }

    private static final void $$robo$$android_speech_srec_Recognizer$SR_GrammarDestroy(long l) {
    }

    private static final long $$robo$$android_speech_srec_Recognizer$SR_GrammarLoad(String string2) {
        return 0L;
    }

    private static final void $$robo$$android_speech_srec_Recognizer$SR_GrammarSave(long l, String string2) {
    }

    private static final void $$robo$$android_speech_srec_Recognizer$SR_GrammarAllowOnly(long l, String string2) {
    }

    private static final void $$robo$$android_speech_srec_Recognizer$SR_GrammarAllowAll(long l) {
    }

    private static final long $$robo$$android_speech_srec_Recognizer$SR_VocabularyLoad() {
        return 0L;
    }

    private static final void $$robo$$android_speech_srec_Recognizer$SR_VocabularyDestroy(long l) {
    }

    private static final String $$robo$$android_speech_srec_Recognizer$SR_VocabularyGetPronunciation(long l, String string2) {
        return null;
    }

    private static final byte[] $$robo$$android_speech_srec_Recognizer$SR_RecognizerResultGetWaveform(long l) {
        return null;
    }

    private static final int $$robo$$android_speech_srec_Recognizer$SR_RecognizerResultGetSize(long l) {
        return 0;
    }

    private static final int $$robo$$android_speech_srec_Recognizer$SR_RecognizerResultGetKeyCount(long l, int n) {
        return 0;
    }

    private static final String[] $$robo$$android_speech_srec_Recognizer$SR_RecognizerResultGetKeyList(long l, int n) {
        return null;
    }

    private static final String $$robo$$android_speech_srec_Recognizer$SR_RecognizerResultGetValue(long l, int n, String string2) {
        return null;
    }

    static void __staticInitializer__() {
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"srec_jni");
        TAG = "Recognizer";
    }

    public static String getConfigDir(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("getConfigDir", $$robo$$android_speech_srec_Recognizer$getConfigDir(java.util.Locale ), 0, (Locale)locale);
    }

    private void __constructor__(String string2) throws IOException {
        this.$$robo$$android_speech_srec_Recognizer$__constructor__(string2);
    }

    public Recognizer(String string2) throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_srec_Recognizer$__constructor__(java.lang.String ), 0, this, string2);
    }

    public void start() {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_speech_srec_Recognizer$start(), 0, this);
    }

    public int advance() {
        return (int)InvokeDynamicSupport.bootstrap("advance", $$robo$$android_speech_srec_Recognizer$advance(), 0, this);
    }

    public int putAudio(byte[] byArray, int n, int n2, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("putAudio", $$robo$$android_speech_srec_Recognizer$putAudio(byte[] int int boolean ), 0, this, byArray, n, n2, bl);
    }

    public void putAudio(InputStream inputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("putAudio", $$robo$$android_speech_srec_Recognizer$putAudio(java.io.InputStream ), 0, this, inputStream);
    }

    public int getResultCount() {
        return (int)InvokeDynamicSupport.bootstrap("getResultCount", $$robo$$android_speech_srec_Recognizer$getResultCount(), 0, this);
    }

    public String[] getResultKeys(int n) {
        return InvokeDynamicSupport.bootstrap("getResultKeys", $$robo$$android_speech_srec_Recognizer$getResultKeys(int ), 0, this, n);
    }

    public String getResult(int n, String string2) {
        return InvokeDynamicSupport.bootstrap("getResult", $$robo$$android_speech_srec_Recognizer$getResult(int java.lang.String ), 0, this, n, string2);
    }

    public void stop() {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_speech_srec_Recognizer$stop(), 0, this);
    }

    public void resetAcousticState() {
        InvokeDynamicSupport.bootstrap("resetAcousticState", $$robo$$android_speech_srec_Recognizer$resetAcousticState(), 0, this);
    }

    public void setAcousticState(String string2) {
        InvokeDynamicSupport.bootstrap("setAcousticState", $$robo$$android_speech_srec_Recognizer$setAcousticState(java.lang.String ), 0, this, string2);
    }

    public String getAcousticState() {
        return InvokeDynamicSupport.bootstrap("getAcousticState", $$robo$$android_speech_srec_Recognizer$getAcousticState(), 0, this);
    }

    public void destroy() {
        InvokeDynamicSupport.bootstrap("destroy", $$robo$$android_speech_srec_Recognizer$destroy(), 0, this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_speech_srec_Recognizer$finalize(), 0, this);
    }

    private static final native /* synthetic */ void $$robo$$PMemInit$nativeBinding();

    private static void PMemInit() {
        InvokeDynamicSupport.bootstrapStatic("PMemInit", $$robo$$android_speech_srec_Recognizer$PMemInit(), 1);
    }

    private static final native /* synthetic */ void $$robo$$PMemShutdown$nativeBinding();

    private static void PMemShutdown() {
        InvokeDynamicSupport.bootstrapStatic("PMemShutdown", $$robo$$android_speech_srec_Recognizer$PMemShutdown(), 1);
    }

    private static final native /* synthetic */ void $$robo$$SR_SessionCreate$nativeBinding(String var0);

    private static void SR_SessionCreate(String string2) {
        InvokeDynamicSupport.bootstrapStatic("SR_SessionCreate", $$robo$$android_speech_srec_Recognizer$SR_SessionCreate(java.lang.String ), 1, (String)string2);
    }

    private static final native /* synthetic */ void $$robo$$SR_SessionDestroy$nativeBinding();

    private static void SR_SessionDestroy() {
        InvokeDynamicSupport.bootstrapStatic("SR_SessionDestroy", $$robo$$android_speech_srec_Recognizer$SR_SessionDestroy(), 1);
    }

    public static String eventToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("eventToString", $$robo$$android_speech_srec_Recognizer$eventToString(int ), 0, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$SR_RecognizerStart$nativeBinding(long var0);

    private static void SR_RecognizerStart(long l) {
        InvokeDynamicSupport.bootstrapStatic("SR_RecognizerStart", $$robo$$android_speech_srec_Recognizer$SR_RecognizerStart(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$SR_RecognizerStop$nativeBinding(long var0);

    private static void SR_RecognizerStop(long l) {
        InvokeDynamicSupport.bootstrapStatic("SR_RecognizerStop", $$robo$$android_speech_srec_Recognizer$SR_RecognizerStop(long ), 1, (long)l);
    }

    private static final native /* synthetic */ long $$robo$$SR_RecognizerCreate$nativeBinding();

    private static long SR_RecognizerCreate() {
        return (long)InvokeDynamicSupport.bootstrapStatic("SR_RecognizerCreate", $$robo$$android_speech_srec_Recognizer$SR_RecognizerCreate(), 1);
    }

    private static final native /* synthetic */ void $$robo$$SR_RecognizerDestroy$nativeBinding(long var0);

    private static void SR_RecognizerDestroy(long l) {
        InvokeDynamicSupport.bootstrapStatic("SR_RecognizerDestroy", $$robo$$android_speech_srec_Recognizer$SR_RecognizerDestroy(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$SR_RecognizerSetup$nativeBinding(long var0);

    private static void SR_RecognizerSetup(long l) {
        InvokeDynamicSupport.bootstrapStatic("SR_RecognizerSetup", $$robo$$android_speech_srec_Recognizer$SR_RecognizerSetup(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$SR_RecognizerUnsetup$nativeBinding(long var0);

    private static void SR_RecognizerUnsetup(long l) {
        InvokeDynamicSupport.bootstrapStatic("SR_RecognizerUnsetup", $$robo$$android_speech_srec_Recognizer$SR_RecognizerUnsetup(long ), 1, (long)l);
    }

    private static final native /* synthetic */ boolean $$robo$$SR_RecognizerIsSetup$nativeBinding(long var0);

    private static boolean SR_RecognizerIsSetup(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("SR_RecognizerIsSetup", $$robo$$android_speech_srec_Recognizer$SR_RecognizerIsSetup(long ), 1, (long)l);
    }

    private static final native /* synthetic */ String $$robo$$SR_RecognizerGetParameter$nativeBinding(long var0, String var2);

    private static String SR_RecognizerGetParameter(long l, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("SR_RecognizerGetParameter", $$robo$$android_speech_srec_Recognizer$SR_RecognizerGetParameter(long java.lang.String ), 1, (long)l, (String)string2);
    }

    private static final native /* synthetic */ int $$robo$$SR_RecognizerGetSize_tParameter$nativeBinding(long var0, String var2);

    private static int SR_RecognizerGetSize_tParameter(long l, String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("SR_RecognizerGetSize_tParameter", $$robo$$android_speech_srec_Recognizer$SR_RecognizerGetSize_tParameter(long java.lang.String ), 1, (long)l, (String)string2);
    }

    private static final native /* synthetic */ boolean $$robo$$SR_RecognizerGetBoolParameter$nativeBinding(long var0, String var2);

    private static boolean SR_RecognizerGetBoolParameter(long l, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("SR_RecognizerGetBoolParameter", $$robo$$android_speech_srec_Recognizer$SR_RecognizerGetBoolParameter(long java.lang.String ), 1, (long)l, (String)string2);
    }

    private static final native /* synthetic */ void $$robo$$SR_RecognizerSetParameter$nativeBinding(long var0, String var2, String var3);

    private static void SR_RecognizerSetParameter(long l, String string2, String string3) {
        InvokeDynamicSupport.bootstrapStatic("SR_RecognizerSetParameter", $$robo$$android_speech_srec_Recognizer$SR_RecognizerSetParameter(long java.lang.String java.lang.String ), 1, (long)l, (String)string2, (String)string3);
    }

    private static final native /* synthetic */ void $$robo$$SR_RecognizerSetSize_tParameter$nativeBinding(long var0, String var2, int var3);

    private static void SR_RecognizerSetSize_tParameter(long l, String string2, int n) {
        InvokeDynamicSupport.bootstrapStatic("SR_RecognizerSetSize_tParameter", $$robo$$android_speech_srec_Recognizer$SR_RecognizerSetSize_tParameter(long java.lang.String int ), 1, (long)l, (String)string2, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$SR_RecognizerSetBoolParameter$nativeBinding(long var0, String var2, boolean var3);

    private static void SR_RecognizerSetBoolParameter(long l, String string2, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("SR_RecognizerSetBoolParameter", $$robo$$android_speech_srec_Recognizer$SR_RecognizerSetBoolParameter(long java.lang.String boolean ), 1, (long)l, (String)string2, (boolean)bl);
    }

    private static final native /* synthetic */ void $$robo$$SR_RecognizerSetupRule$nativeBinding(long var0, long var2, String var4);

    private static void SR_RecognizerSetupRule(long l, long l2, String string2) {
        InvokeDynamicSupport.bootstrapStatic("SR_RecognizerSetupRule", $$robo$$android_speech_srec_Recognizer$SR_RecognizerSetupRule(long long java.lang.String ), 1, (long)l, (long)l2, (String)string2);
    }

    private static final native /* synthetic */ boolean $$robo$$SR_RecognizerHasSetupRules$nativeBinding(long var0);

    private static boolean SR_RecognizerHasSetupRules(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("SR_RecognizerHasSetupRules", $$robo$$android_speech_srec_Recognizer$SR_RecognizerHasSetupRules(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$SR_RecognizerActivateRule$nativeBinding(long var0, long var2, String var4, int var5);

    private static void SR_RecognizerActivateRule(long l, long l2, String string2, int n) {
        InvokeDynamicSupport.bootstrapStatic("SR_RecognizerActivateRule", $$robo$$android_speech_srec_Recognizer$SR_RecognizerActivateRule(long long java.lang.String int ), 1, (long)l, (long)l2, (String)string2, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$SR_RecognizerDeactivateRule$nativeBinding(long var0, long var2, String var4);

    private static void SR_RecognizerDeactivateRule(long l, long l2, String string2) {
        InvokeDynamicSupport.bootstrapStatic("SR_RecognizerDeactivateRule", $$robo$$android_speech_srec_Recognizer$SR_RecognizerDeactivateRule(long long java.lang.String ), 1, (long)l, (long)l2, (String)string2);
    }

    private static final native /* synthetic */ void $$robo$$SR_RecognizerDeactivateAllRules$nativeBinding(long var0);

    private static void SR_RecognizerDeactivateAllRules(long l) {
        InvokeDynamicSupport.bootstrapStatic("SR_RecognizerDeactivateAllRules", $$robo$$android_speech_srec_Recognizer$SR_RecognizerDeactivateAllRules(long ), 1, (long)l);
    }

    private static final native /* synthetic */ boolean $$robo$$SR_RecognizerIsActiveRule$nativeBinding(long var0, long var2, String var4);

    private static boolean SR_RecognizerIsActiveRule(long l, long l2, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("SR_RecognizerIsActiveRule", $$robo$$android_speech_srec_Recognizer$SR_RecognizerIsActiveRule(long long java.lang.String ), 1, (long)l, (long)l2, (String)string2);
    }

    private static final native /* synthetic */ boolean $$robo$$SR_RecognizerCheckGrammarConsistency$nativeBinding(long var0, long var2);

    private static boolean SR_RecognizerCheckGrammarConsistency(long l, long l2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("SR_RecognizerCheckGrammarConsistency", $$robo$$android_speech_srec_Recognizer$SR_RecognizerCheckGrammarConsistency(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ int $$robo$$SR_RecognizerPutAudio$nativeBinding(long var0, byte[] var2, int var3, int var4, boolean var5);

    private static int SR_RecognizerPutAudio(long l, byte[] byArray, int n, int n2, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrapStatic("SR_RecognizerPutAudio", $$robo$$android_speech_srec_Recognizer$SR_RecognizerPutAudio(long byte[] int int boolean ), 1, (long)l, (byte[])byArray, (int)n, (int)n2, (boolean)bl);
    }

    private static final native /* synthetic */ int $$robo$$SR_RecognizerAdvance$nativeBinding(long var0);

    private static int SR_RecognizerAdvance(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("SR_RecognizerAdvance", $$robo$$android_speech_srec_Recognizer$SR_RecognizerAdvance(long ), 1, (long)l);
    }

    private static final native /* synthetic */ boolean $$robo$$SR_RecognizerIsSignalClipping$nativeBinding(long var0);

    private static boolean SR_RecognizerIsSignalClipping(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("SR_RecognizerIsSignalClipping", $$robo$$android_speech_srec_Recognizer$SR_RecognizerIsSignalClipping(long ), 1, (long)l);
    }

    private static final native /* synthetic */ boolean $$robo$$SR_RecognizerIsSignalDCOffset$nativeBinding(long var0);

    private static boolean SR_RecognizerIsSignalDCOffset(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("SR_RecognizerIsSignalDCOffset", $$robo$$android_speech_srec_Recognizer$SR_RecognizerIsSignalDCOffset(long ), 1, (long)l);
    }

    private static final native /* synthetic */ boolean $$robo$$SR_RecognizerIsSignalNoisy$nativeBinding(long var0);

    private static boolean SR_RecognizerIsSignalNoisy(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("SR_RecognizerIsSignalNoisy", $$robo$$android_speech_srec_Recognizer$SR_RecognizerIsSignalNoisy(long ), 1, (long)l);
    }

    private static final native /* synthetic */ boolean $$robo$$SR_RecognizerIsSignalTooQuiet$nativeBinding(long var0);

    private static boolean SR_RecognizerIsSignalTooQuiet(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("SR_RecognizerIsSignalTooQuiet", $$robo$$android_speech_srec_Recognizer$SR_RecognizerIsSignalTooQuiet(long ), 1, (long)l);
    }

    private static final native /* synthetic */ boolean $$robo$$SR_RecognizerIsSignalTooFewSamples$nativeBinding(long var0);

    private static boolean SR_RecognizerIsSignalTooFewSamples(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("SR_RecognizerIsSignalTooFewSamples", $$robo$$android_speech_srec_Recognizer$SR_RecognizerIsSignalTooFewSamples(long ), 1, (long)l);
    }

    private static final native /* synthetic */ boolean $$robo$$SR_RecognizerIsSignalTooManySamples$nativeBinding(long var0);

    private static boolean SR_RecognizerIsSignalTooManySamples(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("SR_RecognizerIsSignalTooManySamples", $$robo$$android_speech_srec_Recognizer$SR_RecognizerIsSignalTooManySamples(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$SR_AcousticStateReset$nativeBinding(long var0);

    private static void SR_AcousticStateReset(long l) {
        InvokeDynamicSupport.bootstrapStatic("SR_AcousticStateReset", $$robo$$android_speech_srec_Recognizer$SR_AcousticStateReset(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$SR_AcousticStateSet$nativeBinding(long var0, String var2);

    private static void SR_AcousticStateSet(long l, String string2) {
        InvokeDynamicSupport.bootstrapStatic("SR_AcousticStateSet", $$robo$$android_speech_srec_Recognizer$SR_AcousticStateSet(long java.lang.String ), 1, (long)l, (String)string2);
    }

    private static final native /* synthetic */ String $$robo$$SR_AcousticStateGet$nativeBinding(long var0);

    private static String SR_AcousticStateGet(long l) {
        return InvokeDynamicSupport.bootstrapStatic("SR_AcousticStateGet", $$robo$$android_speech_srec_Recognizer$SR_AcousticStateGet(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$SR_GrammarCompile$nativeBinding(long var0);

    private static void SR_GrammarCompile(long l) {
        InvokeDynamicSupport.bootstrapStatic("SR_GrammarCompile", $$robo$$android_speech_srec_Recognizer$SR_GrammarCompile(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$SR_GrammarAddWordToSlot$nativeBinding(long var0, String var2, String var3, String var4, int var5, String var6);

    private static void SR_GrammarAddWordToSlot(long l, String string2, String string3, String string4, int n, String string5) {
        InvokeDynamicSupport.bootstrapStatic("SR_GrammarAddWordToSlot", $$robo$$android_speech_srec_Recognizer$SR_GrammarAddWordToSlot(long java.lang.String java.lang.String java.lang.String int java.lang.String ), 1, (long)l, (String)string2, (String)string3, (String)string4, (int)n, (String)string5);
    }

    private static final native /* synthetic */ void $$robo$$SR_GrammarResetAllSlots$nativeBinding(long var0);

    private static void SR_GrammarResetAllSlots(long l) {
        InvokeDynamicSupport.bootstrapStatic("SR_GrammarResetAllSlots", $$robo$$android_speech_srec_Recognizer$SR_GrammarResetAllSlots(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$SR_GrammarSetupVocabulary$nativeBinding(long var0, long var2);

    private static void SR_GrammarSetupVocabulary(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("SR_GrammarSetupVocabulary", $$robo$$android_speech_srec_Recognizer$SR_GrammarSetupVocabulary(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$SR_GrammarSetupRecognizer$nativeBinding(long var0, long var2);

    private static void SR_GrammarSetupRecognizer(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("SR_GrammarSetupRecognizer", $$robo$$android_speech_srec_Recognizer$SR_GrammarSetupRecognizer(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$SR_GrammarUnsetupRecognizer$nativeBinding(long var0);

    private static void SR_GrammarUnsetupRecognizer(long l) {
        InvokeDynamicSupport.bootstrapStatic("SR_GrammarUnsetupRecognizer", $$robo$$android_speech_srec_Recognizer$SR_GrammarUnsetupRecognizer(long ), 1, (long)l);
    }

    private static final native /* synthetic */ long $$robo$$SR_GrammarCreate$nativeBinding();

    private static long SR_GrammarCreate() {
        return (long)InvokeDynamicSupport.bootstrapStatic("SR_GrammarCreate", $$robo$$android_speech_srec_Recognizer$SR_GrammarCreate(), 1);
    }

    private static final native /* synthetic */ void $$robo$$SR_GrammarDestroy$nativeBinding(long var0);

    private static void SR_GrammarDestroy(long l) {
        InvokeDynamicSupport.bootstrapStatic("SR_GrammarDestroy", $$robo$$android_speech_srec_Recognizer$SR_GrammarDestroy(long ), 1, (long)l);
    }

    private static final native /* synthetic */ long $$robo$$SR_GrammarLoad$nativeBinding(String var0);

    private static long SR_GrammarLoad(String string2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("SR_GrammarLoad", $$robo$$android_speech_srec_Recognizer$SR_GrammarLoad(java.lang.String ), 1, (String)string2);
    }

    private static final native /* synthetic */ void $$robo$$SR_GrammarSave$nativeBinding(long var0, String var2);

    private static void SR_GrammarSave(long l, String string2) {
        InvokeDynamicSupport.bootstrapStatic("SR_GrammarSave", $$robo$$android_speech_srec_Recognizer$SR_GrammarSave(long java.lang.String ), 1, (long)l, (String)string2);
    }

    private static final native /* synthetic */ void $$robo$$SR_GrammarAllowOnly$nativeBinding(long var0, String var2);

    private static void SR_GrammarAllowOnly(long l, String string2) {
        InvokeDynamicSupport.bootstrapStatic("SR_GrammarAllowOnly", $$robo$$android_speech_srec_Recognizer$SR_GrammarAllowOnly(long java.lang.String ), 1, (long)l, (String)string2);
    }

    private static final native /* synthetic */ void $$robo$$SR_GrammarAllowAll$nativeBinding(long var0);

    private static void SR_GrammarAllowAll(long l) {
        InvokeDynamicSupport.bootstrapStatic("SR_GrammarAllowAll", $$robo$$android_speech_srec_Recognizer$SR_GrammarAllowAll(long ), 1, (long)l);
    }

    private static final native /* synthetic */ long $$robo$$SR_VocabularyLoad$nativeBinding();

    private static long SR_VocabularyLoad() {
        return (long)InvokeDynamicSupport.bootstrapStatic("SR_VocabularyLoad", $$robo$$android_speech_srec_Recognizer$SR_VocabularyLoad(), 1);
    }

    private static final native /* synthetic */ void $$robo$$SR_VocabularyDestroy$nativeBinding(long var0);

    private static void SR_VocabularyDestroy(long l) {
        InvokeDynamicSupport.bootstrapStatic("SR_VocabularyDestroy", $$robo$$android_speech_srec_Recognizer$SR_VocabularyDestroy(long ), 1, (long)l);
    }

    private static final native /* synthetic */ String $$robo$$SR_VocabularyGetPronunciation$nativeBinding(long var0, String var2);

    private static String SR_VocabularyGetPronunciation(long l, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("SR_VocabularyGetPronunciation", $$robo$$android_speech_srec_Recognizer$SR_VocabularyGetPronunciation(long java.lang.String ), 1, (long)l, (String)string2);
    }

    private static final native /* synthetic */ byte[] $$robo$$SR_RecognizerResultGetWaveform$nativeBinding(long var0);

    private static byte[] SR_RecognizerResultGetWaveform(long l) {
        return InvokeDynamicSupport.bootstrapStatic("SR_RecognizerResultGetWaveform", $$robo$$android_speech_srec_Recognizer$SR_RecognizerResultGetWaveform(long ), 1, (long)l);
    }

    private static final native /* synthetic */ int $$robo$$SR_RecognizerResultGetSize$nativeBinding(long var0);

    private static int SR_RecognizerResultGetSize(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("SR_RecognizerResultGetSize", $$robo$$android_speech_srec_Recognizer$SR_RecognizerResultGetSize(long ), 1, (long)l);
    }

    private static final native /* synthetic */ int $$robo$$SR_RecognizerResultGetKeyCount$nativeBinding(long var0, int var2);

    private static int SR_RecognizerResultGetKeyCount(long l, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("SR_RecognizerResultGetKeyCount", $$robo$$android_speech_srec_Recognizer$SR_RecognizerResultGetKeyCount(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ String[] $$robo$$SR_RecognizerResultGetKeyList$nativeBinding(long var0, int var2);

    private static String[] SR_RecognizerResultGetKeyList(long l, int n) {
        return InvokeDynamicSupport.bootstrapStatic("SR_RecognizerResultGetKeyList", $$robo$$android_speech_srec_Recognizer$SR_RecognizerResultGetKeyList(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ String $$robo$$SR_RecognizerResultGetValue$nativeBinding(long var0, int var2, String var3);

    private static String SR_RecognizerResultGetValue(long l, int n, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("SR_RecognizerResultGetValue", $$robo$$android_speech_srec_Recognizer$SR_RecognizerResultGetValue(long int java.lang.String ), 1, (long)l, (int)n, (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(Recognizer.class);
    }

    public /* synthetic */ Recognizer() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Recognizer)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class Grammar
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private long mGrammar;
        /* synthetic */ Recognizer this$0;

        private void $$robo$$android_speech_srec_Recognizer_Grammar$__constructor__(Recognizer recognizer, String g2gFileName) throws IOException {
            this.mGrammar = 0L;
            this.mGrammar = Recognizer.SR_GrammarLoad(g2gFileName);
            Recognizer.SR_GrammarSetupVocabulary(this.mGrammar, recognizer.mVocabulary);
        }

        private final void $$robo$$android_speech_srec_Recognizer_Grammar$resetAllSlots() {
            Recognizer.SR_GrammarResetAllSlots(this.mGrammar);
        }

        private final void $$robo$$android_speech_srec_Recognizer_Grammar$addWordToSlot(String slot, String word, String pron, int weight, String tag) {
            Recognizer.SR_GrammarAddWordToSlot(this.mGrammar, slot, word, pron, weight, tag);
        }

        private final void $$robo$$android_speech_srec_Recognizer_Grammar$compile() {
            Recognizer.SR_GrammarCompile(this.mGrammar);
        }

        private final void $$robo$$android_speech_srec_Recognizer_Grammar$setupRecognizer() {
            Recognizer.SR_GrammarSetupRecognizer(this.mGrammar, this.this$0.mRecognizer);
            this.this$0.mActiveGrammar = this;
        }

        private final void $$robo$$android_speech_srec_Recognizer_Grammar$save(String g2gFileName) throws IOException {
            Recognizer.SR_GrammarSave(this.mGrammar, g2gFileName);
        }

        private final void $$robo$$android_speech_srec_Recognizer_Grammar$destroy() {
            if (this.mGrammar != 0L) {
                Recognizer.SR_GrammarDestroy(this.mGrammar);
                this.mGrammar = 0L;
            }
        }

        private final void $$robo$$android_speech_srec_Recognizer_Grammar$finalize() {
            if (this.mGrammar != 0L) {
                this.destroy();
                throw new IllegalStateException("someone forgot to destroy Grammar");
            }
        }

        private void __constructor__(Recognizer recognizer, String string2) throws IOException {
            this.$$robo$$android_speech_srec_Recognizer_Grammar$__constructor__(recognizer, string2);
        }

        public Grammar(Recognizer recognizer, String string2) throws IOException {
            this.this$0 = recognizer;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_srec_Recognizer_Grammar$__constructor__(android.speech.srec.Recognizer java.lang.String ), 0, this, recognizer, string2);
        }

        public void resetAllSlots() {
            InvokeDynamicSupport.bootstrap("resetAllSlots", $$robo$$android_speech_srec_Recognizer_Grammar$resetAllSlots(), 0, this);
        }

        public void addWordToSlot(String string2, String string3, String string4, int n, String string5) {
            InvokeDynamicSupport.bootstrap("addWordToSlot", $$robo$$android_speech_srec_Recognizer_Grammar$addWordToSlot(java.lang.String java.lang.String java.lang.String int java.lang.String ), 0, this, string2, string3, string4, n, string5);
        }

        public void compile() {
            InvokeDynamicSupport.bootstrap("compile", $$robo$$android_speech_srec_Recognizer_Grammar$compile(), 0, this);
        }

        public void setupRecognizer() {
            InvokeDynamicSupport.bootstrap("setupRecognizer", $$robo$$android_speech_srec_Recognizer_Grammar$setupRecognizer(), 0, this);
        }

        public void save(String string2) throws IOException {
            InvokeDynamicSupport.bootstrap("save", $$robo$$android_speech_srec_Recognizer_Grammar$save(java.lang.String ), 0, this, string2);
        }

        public void destroy() {
            InvokeDynamicSupport.bootstrap("destroy", $$robo$$android_speech_srec_Recognizer_Grammar$destroy(), 0, this);
        }

        protected void finalize() {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_speech_srec_Recognizer_Grammar$finalize(), 0, this);
        }

        public /* synthetic */ Grammar() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Grammar)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

