/*
 * Decompiled with CFR 0.152.
 */
package android.speech.srec;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WaveHeader
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "WaveHeader";
    private static int HEADER_LENGTH = 44;
    public static short FORMAT_PCM = 1;
    public static short FORMAT_ALAW = 6;
    public static short FORMAT_ULAW = 7;
    private short mFormat;
    private short mNumChannels;
    private int mSampleRate;
    private short mBitsPerSample;
    private int mNumBytes;

    private void $$robo$$android_speech_srec_WaveHeader$__constructor__() {
    }

    private void $$robo$$android_speech_srec_WaveHeader$__constructor__(short format, short numChannels, int sampleRate, short bitsPerSample, int numBytes) {
        this.mFormat = format;
        this.mSampleRate = sampleRate;
        this.mNumChannels = numChannels;
        this.mBitsPerSample = bitsPerSample;
        this.mNumBytes = numBytes;
    }

    private final short $$robo$$android_speech_srec_WaveHeader$getFormat() {
        return this.mFormat;
    }

    private final WaveHeader $$robo$$android_speech_srec_WaveHeader$setFormat(short format) {
        this.mFormat = format;
        return this;
    }

    private final short $$robo$$android_speech_srec_WaveHeader$getNumChannels() {
        return this.mNumChannels;
    }

    private final WaveHeader $$robo$$android_speech_srec_WaveHeader$setNumChannels(short numChannels) {
        this.mNumChannels = numChannels;
        return this;
    }

    private final int $$robo$$android_speech_srec_WaveHeader$getSampleRate() {
        return this.mSampleRate;
    }

    private final WaveHeader $$robo$$android_speech_srec_WaveHeader$setSampleRate(int sampleRate) {
        this.mSampleRate = sampleRate;
        return this;
    }

    private final short $$robo$$android_speech_srec_WaveHeader$getBitsPerSample() {
        return this.mBitsPerSample;
    }

    private final WaveHeader $$robo$$android_speech_srec_WaveHeader$setBitsPerSample(short bitsPerSample) {
        this.mBitsPerSample = bitsPerSample;
        return this;
    }

    private final int $$robo$$android_speech_srec_WaveHeader$getNumBytes() {
        return this.mNumBytes;
    }

    private final WaveHeader $$robo$$android_speech_srec_WaveHeader$setNumBytes(int numBytes) {
        this.mNumBytes = numBytes;
        return this;
    }

    private final int $$robo$$android_speech_srec_WaveHeader$read(InputStream in) throws IOException {
        WaveHeader.readId(in, "RIFF");
        int numBytes = WaveHeader.readInt(in) - 36;
        WaveHeader.readId(in, "WAVE");
        WaveHeader.readId(in, "fmt ");
        if (16 != WaveHeader.readInt(in)) {
            throw new IOException("fmt chunk length not 16");
        }
        this.mFormat = WaveHeader.readShort(in);
        this.mNumChannels = WaveHeader.readShort(in);
        this.mSampleRate = WaveHeader.readInt(in);
        int byteRate = WaveHeader.readInt(in);
        short blockAlign = WaveHeader.readShort(in);
        this.mBitsPerSample = WaveHeader.readShort(in);
        if (byteRate != this.mNumChannels * this.mSampleRate * this.mBitsPerSample / 8) {
            throw new IOException("fmt.ByteRate field inconsistent");
        }
        if (blockAlign != this.mNumChannels * this.mBitsPerSample / 8) {
            throw new IOException("fmt.BlockAlign field inconsistent");
        }
        WaveHeader.readId(in, "data");
        this.mNumBytes = WaveHeader.readInt(in);
        return 44;
    }

    private static final void $$robo$$android_speech_srec_WaveHeader$readId(InputStream in, String id2) throws IOException {
        for (int i = 0; i < id2.length(); ++i) {
            if (id2.charAt(i) == in.read()) continue;
            throw new IOException(id2 + " tag not present");
        }
    }

    private static final int $$robo$$android_speech_srec_WaveHeader$readInt(InputStream in) throws IOException {
        return in.read() | in.read() << 8 | in.read() << 16 | in.read() << 24;
    }

    private static final short $$robo$$android_speech_srec_WaveHeader$readShort(InputStream in) throws IOException {
        return (short)(in.read() | in.read() << 8);
    }

    private final int $$robo$$android_speech_srec_WaveHeader$write(OutputStream out) throws IOException {
        WaveHeader.writeId(out, "RIFF");
        WaveHeader.writeInt(out, 36 + this.mNumBytes);
        WaveHeader.writeId(out, "WAVE");
        WaveHeader.writeId(out, "fmt ");
        WaveHeader.writeInt(out, 16);
        WaveHeader.writeShort(out, this.mFormat);
        WaveHeader.writeShort(out, this.mNumChannels);
        WaveHeader.writeInt(out, this.mSampleRate);
        WaveHeader.writeInt(out, this.mNumChannels * this.mSampleRate * this.mBitsPerSample / 8);
        WaveHeader.writeShort(out, (short)(this.mNumChannels * this.mBitsPerSample / 8));
        WaveHeader.writeShort(out, this.mBitsPerSample);
        WaveHeader.writeId(out, "data");
        WaveHeader.writeInt(out, this.mNumBytes);
        return 44;
    }

    private static final void $$robo$$android_speech_srec_WaveHeader$writeId(OutputStream out, String id2) throws IOException {
        for (int i = 0; i < id2.length(); ++i) {
            out.write(id2.charAt(i));
        }
    }

    private static final void $$robo$$android_speech_srec_WaveHeader$writeInt(OutputStream out, int val) throws IOException {
        out.write(val >> 0);
        out.write(val >> 8);
        out.write(val >> 16);
        out.write(val >> 24);
    }

    private static final void $$robo$$android_speech_srec_WaveHeader$writeShort(OutputStream out, short val) throws IOException {
        out.write(val >> 0);
        out.write(val >> 8);
    }

    private final String $$robo$$android_speech_srec_WaveHeader$toString() {
        return String.format("WaveHeader format=%d numChannels=%d sampleRate=%d bitsPerSample=%d numBytes=%d", this.mFormat, this.mNumChannels, this.mSampleRate, this.mBitsPerSample, this.mNumBytes);
    }

    private void __constructor__() {
        this.$$robo$$android_speech_srec_WaveHeader$__constructor__();
    }

    public WaveHeader() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_srec_WaveHeader$__constructor__(), 0, this);
    }

    private void __constructor__(short s, short s2, int n, short s3, int n2) {
        this.$$robo$$android_speech_srec_WaveHeader$__constructor__(s, s2, n, s3, n2);
    }

    public WaveHeader(short s, short s2, int n, short s3, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_srec_WaveHeader$__constructor__(short short int short int ), 0, this, s, s2, n, s3, n2);
    }

    public short getFormat() {
        return (short)InvokeDynamicSupport.bootstrap("getFormat", $$robo$$android_speech_srec_WaveHeader$getFormat(), 0, this);
    }

    public WaveHeader setFormat(short s) {
        return InvokeDynamicSupport.bootstrap("setFormat", $$robo$$android_speech_srec_WaveHeader$setFormat(short ), 0, this, s);
    }

    public short getNumChannels() {
        return (short)InvokeDynamicSupport.bootstrap("getNumChannels", $$robo$$android_speech_srec_WaveHeader$getNumChannels(), 0, this);
    }

    public WaveHeader setNumChannels(short s) {
        return InvokeDynamicSupport.bootstrap("setNumChannels", $$robo$$android_speech_srec_WaveHeader$setNumChannels(short ), 0, this, s);
    }

    public int getSampleRate() {
        return (int)InvokeDynamicSupport.bootstrap("getSampleRate", $$robo$$android_speech_srec_WaveHeader$getSampleRate(), 0, this);
    }

    public WaveHeader setSampleRate(int n) {
        return InvokeDynamicSupport.bootstrap("setSampleRate", $$robo$$android_speech_srec_WaveHeader$setSampleRate(int ), 0, this, n);
    }

    public short getBitsPerSample() {
        return (short)InvokeDynamicSupport.bootstrap("getBitsPerSample", $$robo$$android_speech_srec_WaveHeader$getBitsPerSample(), 0, this);
    }

    public WaveHeader setBitsPerSample(short s) {
        return InvokeDynamicSupport.bootstrap("setBitsPerSample", $$robo$$android_speech_srec_WaveHeader$setBitsPerSample(short ), 0, this, s);
    }

    public int getNumBytes() {
        return (int)InvokeDynamicSupport.bootstrap("getNumBytes", $$robo$$android_speech_srec_WaveHeader$getNumBytes(), 0, this);
    }

    public WaveHeader setNumBytes(int n) {
        return InvokeDynamicSupport.bootstrap("setNumBytes", $$robo$$android_speech_srec_WaveHeader$setNumBytes(int ), 0, this, n);
    }

    public int read(InputStream inputStream) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_speech_srec_WaveHeader$read(java.io.InputStream ), 0, this, inputStream);
    }

    private static void readId(InputStream inputStream, String string2) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("readId", $$robo$$android_speech_srec_WaveHeader$readId(java.io.InputStream java.lang.String ), 0, (InputStream)inputStream, (String)string2);
    }

    private static int readInt(InputStream inputStream) throws IOException {
        return (int)InvokeDynamicSupport.bootstrapStatic("readInt", $$robo$$android_speech_srec_WaveHeader$readInt(java.io.InputStream ), 0, (InputStream)inputStream);
    }

    private static short readShort(InputStream inputStream) throws IOException {
        return (short)InvokeDynamicSupport.bootstrapStatic("readShort", $$robo$$android_speech_srec_WaveHeader$readShort(java.io.InputStream ), 0, (InputStream)inputStream);
    }

    public int write(OutputStream outputStream) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("write", $$robo$$android_speech_srec_WaveHeader$write(java.io.OutputStream ), 0, this, outputStream);
    }

    private static void writeId(OutputStream outputStream, String string2) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("writeId", $$robo$$android_speech_srec_WaveHeader$writeId(java.io.OutputStream java.lang.String ), 0, (OutputStream)outputStream, (String)string2);
    }

    private static void writeInt(OutputStream outputStream, int n) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("writeInt", $$robo$$android_speech_srec_WaveHeader$writeInt(java.io.OutputStream int ), 0, (OutputStream)outputStream, (int)n);
    }

    private static void writeShort(OutputStream outputStream, short s) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("writeShort", $$robo$$android_speech_srec_WaveHeader$writeShort(java.io.OutputStream short ), 0, (OutputStream)outputStream, (short)s);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_speech_srec_WaveHeader$toString(), 0, this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WaveHeader)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

