/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.net.Uri;
import android.os.Bundle;
import android.telecom.DisconnectCause;
import android.telecom.GatewayInfo;
import android.telecom.InCallAdapter;
import android.telecom.InCallService;
import android.telecom.Log;
import android.telecom.ParcelableCall;
import android.telecom.Phone;
import android.telecom.PhoneAccountHandle;
import android.telecom.StatusHints;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Call
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int STATE_NEW = 0;
    public static int STATE_DIALING = 1;
    public static int STATE_RINGING = 2;
    public static int STATE_HOLDING = 3;
    public static int STATE_ACTIVE = 4;
    public static int STATE_DISCONNECTED = 7;
    public static int STATE_PRE_DIAL_WAIT = 8;
    public static int STATE_CONNECTING = 9;
    public static int STATE_DISCONNECTING = 10;
    public static String AVAILABLE_PHONE_ACCOUNTS = "selectPhoneAccountAccounts";
    private Phone mPhone;
    private String mTelecomCallId;
    private InCallAdapter mInCallAdapter;
    private List<String> mChildrenIds;
    private List<Call> mChildren;
    private List<Call> mUnmodifiableChildren;
    private List<Listener> mListeners;
    private List<Call> mConferenceableCalls;
    private List<Call> mUnmodifiableConferenceableCalls;
    private boolean mChildrenCached;
    private String mParentId;
    private int mState;
    private List<String> mCannedTextResponses;
    private String mRemainingPostDialSequence;
    private InCallService.VideoCall mVideoCall;
    private Details mDetails;

    private final String $$robo$$android_telecom_Call$getRemainingPostDialSequence() {
        return this.mRemainingPostDialSequence;
    }

    private final void $$robo$$android_telecom_Call$answer(int videoState) {
        this.mInCallAdapter.answerCall(this.mTelecomCallId, videoState);
    }

    private final void $$robo$$android_telecom_Call$reject(boolean rejectWithMessage, String textMessage) {
        this.mInCallAdapter.rejectCall(this.mTelecomCallId, rejectWithMessage, textMessage);
    }

    private final void $$robo$$android_telecom_Call$disconnect() {
        this.mInCallAdapter.disconnectCall(this.mTelecomCallId);
    }

    private final void $$robo$$android_telecom_Call$hold() {
        this.mInCallAdapter.holdCall(this.mTelecomCallId);
    }

    private final void $$robo$$android_telecom_Call$unhold() {
        this.mInCallAdapter.unholdCall(this.mTelecomCallId);
    }

    private final void $$robo$$android_telecom_Call$playDtmfTone(char digit) {
        this.mInCallAdapter.playDtmfTone(this.mTelecomCallId, digit);
    }

    private final void $$robo$$android_telecom_Call$stopDtmfTone() {
        this.mInCallAdapter.stopDtmfTone(this.mTelecomCallId);
    }

    private final void $$robo$$android_telecom_Call$postDialContinue(boolean proceed) {
        this.mInCallAdapter.postDialContinue(this.mTelecomCallId, proceed);
    }

    private final void $$robo$$android_telecom_Call$phoneAccountSelected(PhoneAccountHandle accountHandle) {
        this.mInCallAdapter.phoneAccountSelected(this.mTelecomCallId, accountHandle);
    }

    private final void $$robo$$android_telecom_Call$conference(Call callToConferenceWith) {
        if (callToConferenceWith != null) {
            this.mInCallAdapter.conference(this.mTelecomCallId, callToConferenceWith.mTelecomCallId);
        }
    }

    private final void $$robo$$android_telecom_Call$splitFromConference() {
        this.mInCallAdapter.splitFromConference(this.mTelecomCallId);
    }

    private final void $$robo$$android_telecom_Call$mergeConference() {
        this.mInCallAdapter.mergeConference(this.mTelecomCallId);
    }

    private final void $$robo$$android_telecom_Call$swapConference() {
        this.mInCallAdapter.swapConference(this.mTelecomCallId);
    }

    private final Call $$robo$$android_telecom_Call$getParent() {
        if (this.mParentId != null) {
            return this.mPhone.internalGetCallByTelecomId(this.mParentId);
        }
        return null;
    }

    private final List<Call> $$robo$$android_telecom_Call$getChildren() {
        if (!this.mChildrenCached) {
            this.mChildrenCached = true;
            this.mChildren.clear();
            for (String id2 : this.mChildrenIds) {
                Call call = this.mPhone.internalGetCallByTelecomId(id2);
                if (call == null) {
                    this.mChildrenCached = false;
                    continue;
                }
                this.mChildren.add(call);
            }
        }
        return this.mUnmodifiableChildren;
    }

    private final List<Call> $$robo$$android_telecom_Call$getConferenceableCalls() {
        return this.mUnmodifiableConferenceableCalls;
    }

    private final int $$robo$$android_telecom_Call$getState() {
        return this.mState;
    }

    private final List<String> $$robo$$android_telecom_Call$getCannedTextResponses() {
        return this.mCannedTextResponses;
    }

    private final InCallService.VideoCall $$robo$$android_telecom_Call$getVideoCall() {
        return this.mVideoCall;
    }

    private final Details $$robo$$android_telecom_Call$getDetails() {
        return this.mDetails;
    }

    private final void $$robo$$android_telecom_Call$addListener(Listener listener) {
        this.mListeners.add(listener);
    }

    private final void $$robo$$android_telecom_Call$removeListener(Listener listener) {
        if (listener != null) {
            this.mListeners.remove(listener);
        }
    }

    private void $$robo$$android_telecom_Call$__constructor__(Phone phone, String telecomCallId, InCallAdapter inCallAdapter) {
        this.mChildrenIds = new ArrayList<String>();
        this.mChildren = new ArrayList<Call>();
        this.mUnmodifiableChildren = Collections.unmodifiableList(this.mChildren);
        this.mListeners = new CopyOnWriteArrayList<Listener>();
        this.mConferenceableCalls = new ArrayList<Call>();
        this.mUnmodifiableConferenceableCalls = Collections.unmodifiableList(this.mConferenceableCalls);
        this.mParentId = null;
        this.mCannedTextResponses = null;
        this.mPhone = phone;
        this.mTelecomCallId = telecomCallId;
        this.mInCallAdapter = inCallAdapter;
        this.mState = 0;
    }

    private final String $$robo$$android_telecom_Call$internalGetCallId() {
        return this.mTelecomCallId;
    }

    private final void $$robo$$android_telecom_Call$internalUpdate(ParcelableCall parcelableCall, Map<String, Call> callIdMap) {
        List<String> childCallIds;
        boolean childrenChanged;
        String parentId;
        boolean parentChanged;
        int state;
        boolean stateChanged;
        boolean videoCallChanged;
        boolean detailsChanged;
        Details details = new Details(parcelableCall.getHandle(), parcelableCall.getHandlePresentation(), parcelableCall.getCallerDisplayName(), parcelableCall.getCallerDisplayNamePresentation(), parcelableCall.getAccountHandle(), parcelableCall.getCapabilities(), parcelableCall.getProperties(), parcelableCall.getDisconnectCause(), parcelableCall.getConnectTimeMillis(), parcelableCall.getGatewayInfo(), parcelableCall.getVideoState(), parcelableCall.getStatusHints(), parcelableCall.getExtras());
        boolean bl = detailsChanged = !Objects.equals(this.mDetails, details);
        if (detailsChanged) {
            this.mDetails = details;
        }
        boolean cannedTextResponsesChanged = false;
        if (this.mCannedTextResponses == null && parcelableCall.getCannedSmsResponses() != null && !parcelableCall.getCannedSmsResponses().isEmpty()) {
            this.mCannedTextResponses = Collections.unmodifiableList(parcelableCall.getCannedSmsResponses());
        }
        boolean bl2 = videoCallChanged = !Objects.equals(this.mVideoCall, parcelableCall.getVideoCall());
        if (videoCallChanged) {
            this.mVideoCall = parcelableCall.getVideoCall();
        }
        boolean bl3 = stateChanged = this.mState != (state = this.stateFromParcelableCallState(parcelableCall.getState()));
        if (stateChanged) {
            this.mState = state;
        }
        boolean bl4 = parentChanged = !Objects.equals(this.mParentId, parentId = parcelableCall.getParentCallId());
        if (parentChanged) {
            this.mParentId = parentId;
        }
        boolean bl5 = childrenChanged = !Objects.equals(childCallIds = parcelableCall.getChildCallIds(), this.mChildrenIds);
        if (childrenChanged) {
            this.mChildrenIds.clear();
            this.mChildrenIds.addAll(parcelableCall.getChildCallIds());
            this.mChildrenCached = false;
        }
        List<String> conferenceableCallIds = parcelableCall.getConferenceableCallIds();
        ArrayList<Call> conferenceableCalls = new ArrayList<Call>(conferenceableCallIds.size());
        for (String otherId : conferenceableCallIds) {
            if (!callIdMap.containsKey(otherId)) continue;
            conferenceableCalls.add(callIdMap.get(otherId));
        }
        if (!Objects.equals(this.mConferenceableCalls, conferenceableCalls)) {
            this.mConferenceableCalls.clear();
            this.mConferenceableCalls.addAll(conferenceableCalls);
            this.fireConferenceableCallsChanged();
        }
        if (stateChanged) {
            this.fireStateChanged(this.mState);
        }
        if (detailsChanged) {
            this.fireDetailsChanged(this.mDetails);
        }
        if (cannedTextResponsesChanged) {
            this.fireCannedTextResponsesLoaded(this.mCannedTextResponses);
        }
        if (videoCallChanged) {
            this.fireVideoCallChanged(this.mVideoCall);
        }
        if (parentChanged) {
            this.fireParentChanged(this.getParent());
        }
        if (childrenChanged) {
            this.fireChildrenChanged(this.getChildren());
        }
        if (this.mState == 7) {
            this.fireCallDestroyed();
            this.mPhone.internalRemoveCall(this);
        }
    }

    private final void $$robo$$android_telecom_Call$internalSetPostDialWait(String remaining) {
        this.mRemainingPostDialSequence = remaining;
        this.firePostDialWait(this.mRemainingPostDialSequence);
    }

    private final void $$robo$$android_telecom_Call$internalSetDisconnected() {
        if (this.mState != 7) {
            this.mState = 7;
            this.fireStateChanged(this.mState);
            this.fireCallDestroyed();
            this.mPhone.internalRemoveCall(this);
        }
    }

    private final void $$robo$$android_telecom_Call$fireStateChanged(int newState) {
        for (Listener listener : this.mListeners) {
            listener.onStateChanged(this, newState);
        }
    }

    private final void $$robo$$android_telecom_Call$fireParentChanged(Call newParent) {
        for (Listener listener : this.mListeners) {
            listener.onParentChanged(this, newParent);
        }
    }

    private final void $$robo$$android_telecom_Call$fireChildrenChanged(List<Call> children) {
        for (Listener listener : this.mListeners) {
            listener.onChildrenChanged(this, children);
        }
    }

    private final void $$robo$$android_telecom_Call$fireDetailsChanged(Details details) {
        for (Listener listener : this.mListeners) {
            listener.onDetailsChanged(this, details);
        }
    }

    private final void $$robo$$android_telecom_Call$fireCannedTextResponsesLoaded(List<String> cannedTextResponses) {
        for (Listener listener : this.mListeners) {
            listener.onCannedTextResponsesLoaded(this, cannedTextResponses);
        }
    }

    private final void $$robo$$android_telecom_Call$fireVideoCallChanged(InCallService.VideoCall videoCall) {
        for (Listener listener : this.mListeners) {
            listener.onVideoCallChanged(this, videoCall);
        }
    }

    private final void $$robo$$android_telecom_Call$firePostDialWait(String remainingPostDialSequence) {
        for (Listener listener : this.mListeners) {
            listener.onPostDialWait(this, remainingPostDialSequence);
        }
    }

    private final void $$robo$$android_telecom_Call$fireCallDestroyed() {
        for (Listener listener : this.mListeners) {
            listener.onCallDestroyed(this);
        }
    }

    private final void $$robo$$android_telecom_Call$fireConferenceableCallsChanged() {
        for (Listener listener : this.mListeners) {
            listener.onConferenceableCallsChanged(this, this.mUnmodifiableConferenceableCalls);
        }
    }

    private final int $$robo$$android_telecom_Call$stateFromParcelableCallState(int parcelableCallState) {
        switch (parcelableCallState) {
            case 0: {
                return 0;
            }
            case 1: {
                return 9;
            }
            case 2: {
                return 8;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 3;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 7;
            }
            case 9: {
                return 10;
            }
        }
        Log.wtf((Object)this, "Unrecognized CallState %s", parcelableCallState);
        return 0;
    }

    public String getRemainingPostDialSequence() {
        return InvokeDynamicSupport.bootstrap("getRemainingPostDialSequence", $$robo$$android_telecom_Call$getRemainingPostDialSequence(), 0, this);
    }

    public void answer(int n) {
        InvokeDynamicSupport.bootstrap("answer", $$robo$$android_telecom_Call$answer(int ), 0, this, n);
    }

    public void reject(boolean bl, String string2) {
        InvokeDynamicSupport.bootstrap("reject", $$robo$$android_telecom_Call$reject(boolean java.lang.String ), 0, this, bl, string2);
    }

    public void disconnect() {
        InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_telecom_Call$disconnect(), 0, this);
    }

    public void hold() {
        InvokeDynamicSupport.bootstrap("hold", $$robo$$android_telecom_Call$hold(), 0, this);
    }

    public void unhold() {
        InvokeDynamicSupport.bootstrap("unhold", $$robo$$android_telecom_Call$unhold(), 0, this);
    }

    public void playDtmfTone(char c) {
        InvokeDynamicSupport.bootstrap("playDtmfTone", $$robo$$android_telecom_Call$playDtmfTone(char ), 0, this, c);
    }

    public void stopDtmfTone() {
        InvokeDynamicSupport.bootstrap("stopDtmfTone", $$robo$$android_telecom_Call$stopDtmfTone(), 0, this);
    }

    public void postDialContinue(boolean bl) {
        InvokeDynamicSupport.bootstrap("postDialContinue", $$robo$$android_telecom_Call$postDialContinue(boolean ), 0, this, bl);
    }

    public void phoneAccountSelected(PhoneAccountHandle phoneAccountHandle) {
        InvokeDynamicSupport.bootstrap("phoneAccountSelected", $$robo$$android_telecom_Call$phoneAccountSelected(android.telecom.PhoneAccountHandle ), 0, this, phoneAccountHandle);
    }

    public void conference(Call call) {
        InvokeDynamicSupport.bootstrap("conference", $$robo$$android_telecom_Call$conference(android.telecom.Call ), 0, this, call);
    }

    public void splitFromConference() {
        InvokeDynamicSupport.bootstrap("splitFromConference", $$robo$$android_telecom_Call$splitFromConference(), 0, this);
    }

    public void mergeConference() {
        InvokeDynamicSupport.bootstrap("mergeConference", $$robo$$android_telecom_Call$mergeConference(), 0, this);
    }

    public void swapConference() {
        InvokeDynamicSupport.bootstrap("swapConference", $$robo$$android_telecom_Call$swapConference(), 0, this);
    }

    public Call getParent() {
        return InvokeDynamicSupport.bootstrap("getParent", $$robo$$android_telecom_Call$getParent(), 0, this);
    }

    public List<Call> getChildren() {
        return InvokeDynamicSupport.bootstrap("getChildren", $$robo$$android_telecom_Call$getChildren(), 0, this);
    }

    public List<Call> getConferenceableCalls() {
        return InvokeDynamicSupport.bootstrap("getConferenceableCalls", $$robo$$android_telecom_Call$getConferenceableCalls(), 0, this);
    }

    public int getState() {
        return (int)InvokeDynamicSupport.bootstrap("getState", $$robo$$android_telecom_Call$getState(), 0, this);
    }

    public List<String> getCannedTextResponses() {
        return InvokeDynamicSupport.bootstrap("getCannedTextResponses", $$robo$$android_telecom_Call$getCannedTextResponses(), 0, this);
    }

    public InCallService.VideoCall getVideoCall() {
        return InvokeDynamicSupport.bootstrap("getVideoCall", $$robo$$android_telecom_Call$getVideoCall(), 0, this);
    }

    public Details getDetails() {
        return InvokeDynamicSupport.bootstrap("getDetails", $$robo$$android_telecom_Call$getDetails(), 0, this);
    }

    public void addListener(Listener listener) {
        InvokeDynamicSupport.bootstrap("addListener", $$robo$$android_telecom_Call$addListener(android.telecom.Call$Listener ), 0, this, listener);
    }

    public void removeListener(Listener listener) {
        InvokeDynamicSupport.bootstrap("removeListener", $$robo$$android_telecom_Call$removeListener(android.telecom.Call$Listener ), 0, this, listener);
    }

    private void __constructor__(Phone phone, String string2, InCallAdapter inCallAdapter) {
        this.$$robo$$android_telecom_Call$__constructor__(phone, string2, inCallAdapter);
    }

    Call(Phone phone, String string2, InCallAdapter inCallAdapter) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Call$__constructor__(android.telecom.Phone java.lang.String android.telecom.InCallAdapter ), 0, this, phone, string2, inCallAdapter);
    }

    String internalGetCallId() {
        return InvokeDynamicSupport.bootstrap("internalGetCallId", $$robo$$android_telecom_Call$internalGetCallId(), 0, this);
    }

    void internalUpdate(ParcelableCall parcelableCall, Map<String, Call> map) {
        InvokeDynamicSupport.bootstrap("internalUpdate", $$robo$$android_telecom_Call$internalUpdate(android.telecom.ParcelableCall java.util.Map<java.lang.String, android.telecom.Call> ), 0, this, parcelableCall, map);
    }

    void internalSetPostDialWait(String string2) {
        InvokeDynamicSupport.bootstrap("internalSetPostDialWait", $$robo$$android_telecom_Call$internalSetPostDialWait(java.lang.String ), 0, this, string2);
    }

    void internalSetDisconnected() {
        InvokeDynamicSupport.bootstrap("internalSetDisconnected", $$robo$$android_telecom_Call$internalSetDisconnected(), 0, this);
    }

    private void fireStateChanged(int n) {
        InvokeDynamicSupport.bootstrap("fireStateChanged", $$robo$$android_telecom_Call$fireStateChanged(int ), 0, this, n);
    }

    private void fireParentChanged(Call call) {
        InvokeDynamicSupport.bootstrap("fireParentChanged", $$robo$$android_telecom_Call$fireParentChanged(android.telecom.Call ), 0, this, call);
    }

    private void fireChildrenChanged(List<Call> list) {
        InvokeDynamicSupport.bootstrap("fireChildrenChanged", $$robo$$android_telecom_Call$fireChildrenChanged(java.util.List<android.telecom.Call> ), 0, this, list);
    }

    private void fireDetailsChanged(Details details) {
        InvokeDynamicSupport.bootstrap("fireDetailsChanged", $$robo$$android_telecom_Call$fireDetailsChanged(android.telecom.Call$Details ), 0, this, details);
    }

    private void fireCannedTextResponsesLoaded(List<String> list) {
        InvokeDynamicSupport.bootstrap("fireCannedTextResponsesLoaded", $$robo$$android_telecom_Call$fireCannedTextResponsesLoaded(java.util.List<java.lang.String> ), 0, this, list);
    }

    private void fireVideoCallChanged(InCallService.VideoCall videoCall) {
        InvokeDynamicSupport.bootstrap("fireVideoCallChanged", $$robo$$android_telecom_Call$fireVideoCallChanged(android.telecom.InCallService$VideoCall ), 0, this, videoCall);
    }

    private void firePostDialWait(String string2) {
        InvokeDynamicSupport.bootstrap("firePostDialWait", $$robo$$android_telecom_Call$firePostDialWait(java.lang.String ), 0, this, string2);
    }

    private void fireCallDestroyed() {
        InvokeDynamicSupport.bootstrap("fireCallDestroyed", $$robo$$android_telecom_Call$fireCallDestroyed(), 0, this);
    }

    private void fireConferenceableCallsChanged() {
        InvokeDynamicSupport.bootstrap("fireConferenceableCallsChanged", $$robo$$android_telecom_Call$fireConferenceableCallsChanged(), 0, this);
    }

    private int stateFromParcelableCallState(int n) {
        return (int)InvokeDynamicSupport.bootstrap("stateFromParcelableCallState", $$robo$$android_telecom_Call$stateFromParcelableCallState(int ), 0, this, n);
    }

    public /* synthetic */ Call() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Call)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static abstract class Listener
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_telecom_Call_Listener$__constructor__() {
        }

        private final void $$robo$$android_telecom_Call_Listener$onStateChanged(Call call, int state) {
        }

        private final void $$robo$$android_telecom_Call_Listener$onParentChanged(Call call, Call parent) {
        }

        private final void $$robo$$android_telecom_Call_Listener$onChildrenChanged(Call call, List<Call> children) {
        }

        private final void $$robo$$android_telecom_Call_Listener$onDetailsChanged(Call call, Details details) {
        }

        private final void $$robo$$android_telecom_Call_Listener$onCannedTextResponsesLoaded(Call call, List<String> cannedTextResponses) {
        }

        private final void $$robo$$android_telecom_Call_Listener$onPostDialWait(Call call, String remainingPostDialSequence) {
        }

        private final void $$robo$$android_telecom_Call_Listener$onVideoCallChanged(Call call, InCallService.VideoCall videoCall) {
        }

        private final void $$robo$$android_telecom_Call_Listener$onCallDestroyed(Call call) {
        }

        private final void $$robo$$android_telecom_Call_Listener$onConferenceableCallsChanged(Call call, List<Call> conferenceableCalls) {
        }

        private void __constructor__() {
            this.$$robo$$android_telecom_Call_Listener$__constructor__();
        }

        public Listener() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Call_Listener$__constructor__(), 0, this);
        }

        public void onStateChanged(Call call, int n) {
            InvokeDynamicSupport.bootstrap("onStateChanged", $$robo$$android_telecom_Call_Listener$onStateChanged(android.telecom.Call int ), 0, this, call, n);
        }

        public void onParentChanged(Call call, Call call2) {
            InvokeDynamicSupport.bootstrap("onParentChanged", $$robo$$android_telecom_Call_Listener$onParentChanged(android.telecom.Call android.telecom.Call ), 0, this, call, call2);
        }

        public void onChildrenChanged(Call call, List<Call> list) {
            InvokeDynamicSupport.bootstrap("onChildrenChanged", $$robo$$android_telecom_Call_Listener$onChildrenChanged(android.telecom.Call java.util.List<android.telecom.Call> ), 0, this, call, list);
        }

        public void onDetailsChanged(Call call, Details details) {
            InvokeDynamicSupport.bootstrap("onDetailsChanged", $$robo$$android_telecom_Call_Listener$onDetailsChanged(android.telecom.Call android.telecom.Call$Details ), 0, this, call, details);
        }

        public void onCannedTextResponsesLoaded(Call call, List<String> list) {
            InvokeDynamicSupport.bootstrap("onCannedTextResponsesLoaded", $$robo$$android_telecom_Call_Listener$onCannedTextResponsesLoaded(android.telecom.Call java.util.List<java.lang.String> ), 0, this, call, list);
        }

        public void onPostDialWait(Call call, String string2) {
            InvokeDynamicSupport.bootstrap("onPostDialWait", $$robo$$android_telecom_Call_Listener$onPostDialWait(android.telecom.Call java.lang.String ), 0, this, call, string2);
        }

        public void onVideoCallChanged(Call call, InCallService.VideoCall videoCall) {
            InvokeDynamicSupport.bootstrap("onVideoCallChanged", $$robo$$android_telecom_Call_Listener$onVideoCallChanged(android.telecom.Call android.telecom.InCallService$VideoCall ), 0, this, call, videoCall);
        }

        public void onCallDestroyed(Call call) {
            InvokeDynamicSupport.bootstrap("onCallDestroyed", $$robo$$android_telecom_Call_Listener$onCallDestroyed(android.telecom.Call ), 0, this, call);
        }

        public void onConferenceableCallsChanged(Call call, List<Call> list) {
            InvokeDynamicSupport.bootstrap("onConferenceableCallsChanged", $$robo$$android_telecom_Call_Listener$onConferenceableCallsChanged(android.telecom.Call java.util.List<android.telecom.Call> ), 0, this, call, list);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Listener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Details
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Uri mHandle;
        private int mHandlePresentation;
        private String mCallerDisplayName;
        private int mCallerDisplayNamePresentation;
        private PhoneAccountHandle mAccountHandle;
        private int mCallCapabilities;
        private int mCallProperties;
        private DisconnectCause mDisconnectCause;
        private long mConnectTimeMillis;
        private GatewayInfo mGatewayInfo;
        private int mVideoState;
        private StatusHints mStatusHints;
        private Bundle mExtras;

        private final Uri $$robo$$android_telecom_Call_Details$getHandle() {
            return this.mHandle;
        }

        private final int $$robo$$android_telecom_Call_Details$getHandlePresentation() {
            return this.mHandlePresentation;
        }

        private final String $$robo$$android_telecom_Call_Details$getCallerDisplayName() {
            return this.mCallerDisplayName;
        }

        private final int $$robo$$android_telecom_Call_Details$getCallerDisplayNamePresentation() {
            return this.mCallerDisplayNamePresentation;
        }

        private final PhoneAccountHandle $$robo$$android_telecom_Call_Details$getAccountHandle() {
            return this.mAccountHandle;
        }

        private final int $$robo$$android_telecom_Call_Details$getCallCapabilities() {
            return this.mCallCapabilities;
        }

        private final int $$robo$$android_telecom_Call_Details$getCallProperties() {
            return this.mCallProperties;
        }

        private final DisconnectCause $$robo$$android_telecom_Call_Details$getDisconnectCause() {
            return this.mDisconnectCause;
        }

        private final long $$robo$$android_telecom_Call_Details$getConnectTimeMillis() {
            return this.mConnectTimeMillis;
        }

        private final GatewayInfo $$robo$$android_telecom_Call_Details$getGatewayInfo() {
            return this.mGatewayInfo;
        }

        private final int $$robo$$android_telecom_Call_Details$getVideoState() {
            return this.mVideoState;
        }

        private final StatusHints $$robo$$android_telecom_Call_Details$getStatusHints() {
            return this.mStatusHints;
        }

        private final Bundle $$robo$$android_telecom_Call_Details$getExtras() {
            return this.mExtras;
        }

        private final boolean $$robo$$android_telecom_Call_Details$equals(Object o) {
            if (o instanceof Details) {
                Details d = (Details)o;
                return Objects.equals(this.mHandle, d.mHandle) && Objects.equals(this.mHandlePresentation, d.mHandlePresentation) && Objects.equals(this.mCallerDisplayName, d.mCallerDisplayName) && Objects.equals(this.mCallerDisplayNamePresentation, d.mCallerDisplayNamePresentation) && Objects.equals(this.mAccountHandle, d.mAccountHandle) && Objects.equals(this.mCallCapabilities, d.mCallCapabilities) && Objects.equals(this.mCallProperties, d.mCallProperties) && Objects.equals(this.mDisconnectCause, d.mDisconnectCause) && Objects.equals(this.mConnectTimeMillis, d.mConnectTimeMillis) && Objects.equals(this.mGatewayInfo, d.mGatewayInfo) && Objects.equals(this.mVideoState, d.mVideoState) && Objects.equals(this.mStatusHints, d.mStatusHints) && Objects.equals(this.mExtras, d.mExtras);
            }
            return false;
        }

        private final int $$robo$$android_telecom_Call_Details$hashCode() {
            return Objects.hashCode(this.mHandle) + Objects.hashCode(this.mHandlePresentation) + Objects.hashCode(this.mCallerDisplayName) + Objects.hashCode(this.mCallerDisplayNamePresentation) + Objects.hashCode(this.mAccountHandle) + Objects.hashCode(this.mCallCapabilities) + Objects.hashCode(this.mCallProperties) + Objects.hashCode(this.mDisconnectCause) + Objects.hashCode(this.mConnectTimeMillis) + Objects.hashCode(this.mGatewayInfo) + Objects.hashCode(this.mVideoState) + Objects.hashCode(this.mStatusHints) + Objects.hashCode(this.mExtras);
        }

        private void $$robo$$android_telecom_Call_Details$__constructor__(Uri handle, int handlePresentation, String callerDisplayName, int callerDisplayNamePresentation, PhoneAccountHandle accountHandle, int capabilities, int properties, DisconnectCause disconnectCause, long connectTimeMillis, GatewayInfo gatewayInfo, int videoState, StatusHints statusHints, Bundle extras) {
            this.mHandle = handle;
            this.mHandlePresentation = handlePresentation;
            this.mCallerDisplayName = callerDisplayName;
            this.mCallerDisplayNamePresentation = callerDisplayNamePresentation;
            this.mAccountHandle = accountHandle;
            this.mCallCapabilities = capabilities;
            this.mCallProperties = properties;
            this.mDisconnectCause = disconnectCause;
            this.mConnectTimeMillis = connectTimeMillis;
            this.mGatewayInfo = gatewayInfo;
            this.mVideoState = videoState;
            this.mStatusHints = statusHints;
            this.mExtras = extras;
        }

        public Uri getHandle() {
            return InvokeDynamicSupport.bootstrap("getHandle", $$robo$$android_telecom_Call_Details$getHandle(), 0, this);
        }

        public int getHandlePresentation() {
            return (int)InvokeDynamicSupport.bootstrap("getHandlePresentation", $$robo$$android_telecom_Call_Details$getHandlePresentation(), 0, this);
        }

        public String getCallerDisplayName() {
            return InvokeDynamicSupport.bootstrap("getCallerDisplayName", $$robo$$android_telecom_Call_Details$getCallerDisplayName(), 0, this);
        }

        public int getCallerDisplayNamePresentation() {
            return (int)InvokeDynamicSupport.bootstrap("getCallerDisplayNamePresentation", $$robo$$android_telecom_Call_Details$getCallerDisplayNamePresentation(), 0, this);
        }

        public PhoneAccountHandle getAccountHandle() {
            return InvokeDynamicSupport.bootstrap("getAccountHandle", $$robo$$android_telecom_Call_Details$getAccountHandle(), 0, this);
        }

        public int getCallCapabilities() {
            return (int)InvokeDynamicSupport.bootstrap("getCallCapabilities", $$robo$$android_telecom_Call_Details$getCallCapabilities(), 0, this);
        }

        public int getCallProperties() {
            return (int)InvokeDynamicSupport.bootstrap("getCallProperties", $$robo$$android_telecom_Call_Details$getCallProperties(), 0, this);
        }

        public DisconnectCause getDisconnectCause() {
            return InvokeDynamicSupport.bootstrap("getDisconnectCause", $$robo$$android_telecom_Call_Details$getDisconnectCause(), 0, this);
        }

        public long getConnectTimeMillis() {
            return (long)InvokeDynamicSupport.bootstrap("getConnectTimeMillis", $$robo$$android_telecom_Call_Details$getConnectTimeMillis(), 0, this);
        }

        public GatewayInfo getGatewayInfo() {
            return InvokeDynamicSupport.bootstrap("getGatewayInfo", $$robo$$android_telecom_Call_Details$getGatewayInfo(), 0, this);
        }

        public int getVideoState() {
            return (int)InvokeDynamicSupport.bootstrap("getVideoState", $$robo$$android_telecom_Call_Details$getVideoState(), 0, this);
        }

        public StatusHints getStatusHints() {
            return InvokeDynamicSupport.bootstrap("getStatusHints", $$robo$$android_telecom_Call_Details$getStatusHints(), 0, this);
        }

        public Bundle getExtras() {
            return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_telecom_Call_Details$getExtras(), 0, this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_telecom_Call_Details$equals(java.lang.Object ), 0, this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_telecom_Call_Details$hashCode(), 0, this);
        }

        private void __constructor__(Uri uri, int n, String string2, int n2, PhoneAccountHandle phoneAccountHandle, int n3, int n4, DisconnectCause disconnectCause, long l, GatewayInfo gatewayInfo, int n5, StatusHints statusHints, Bundle bundle) {
            this.$$robo$$android_telecom_Call_Details$__constructor__(uri, n, string2, n2, phoneAccountHandle, n3, n4, disconnectCause, l, gatewayInfo, n5, statusHints, bundle);
        }

        public Details(Uri uri, int n, String string2, int n2, PhoneAccountHandle phoneAccountHandle, int n3, int n4, DisconnectCause disconnectCause, long l, GatewayInfo gatewayInfo, int n5, StatusHints statusHints, Bundle bundle) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Call_Details$__constructor__(android.net.Uri int java.lang.String int android.telecom.PhoneAccountHandle int int android.telecom.DisconnectCause long android.telecom.GatewayInfo int android.telecom.StatusHints android.os.Bundle ), 0, this, uri, n, string2, n2, phoneAccountHandle, n3, n4, disconnectCause, l, gatewayInfo, n5, statusHints, bundle);
        }

        public /* synthetic */ Details() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Details)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

