/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.telecom.AudioState;
import android.telecom.Connection;
import android.telecom.DisconnectCause;
import android.telecom.Log;
import android.telecom.PhoneAccountHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class Conference
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Set<Listener> mListeners;
    private List<Connection> mChildConnections;
    private List<Connection> mUnmodifiableChildConnections;
    private List<Connection> mConferenceableConnections;
    private List<Connection> mUnmodifiableConferenceableConnections;
    private PhoneAccountHandle mPhoneAccount;
    private AudioState mAudioState;
    private int mState;
    private DisconnectCause mDisconnectCause;
    private int mCapabilities;
    private String mDisconnectMessage;
    private Connection.Listener mConnectionDeathListener;

    private void $$robo$$android_telecom_Conference$__constructor__(PhoneAccountHandle phoneAccount) {
        this.mListeners = new CopyOnWriteArraySet<Listener>();
        this.mChildConnections = new CopyOnWriteArrayList<Connection>();
        this.mUnmodifiableChildConnections = Collections.unmodifiableList(this.mChildConnections);
        this.mConferenceableConnections = new ArrayList<Connection>();
        this.mUnmodifiableConferenceableConnections = Collections.unmodifiableList(this.mConferenceableConnections);
        this.mState = 1;
        this.mConnectionDeathListener = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ Conference this$0;

            private void $$robo$$android_telecom_Conference_1$__constructor__(Conference conference) {
            }

            private final void $$robo$$android_telecom_Conference_1$onDestroyed(Connection c) {
                if (this.this$0.mConferenceableConnections.remove(c)) {
                    this.this$0.fireOnConferenceableConnectionsChanged();
                }
            }

            private void __constructor__(Conference conference) {
                this.$$robo$$android_telecom_Conference_1$__constructor__(conference);
            }
            {
                this.this$0 = conference;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Conference_1$__constructor__(android.telecom.Conference ), 0, this, conference);
            }

            @Override
            public void onDestroyed(Connection connection) {
                InvokeDynamicSupport.bootstrap("onDestroyed", $$robo$$android_telecom_Conference_1$onDestroyed(android.telecom.Connection ), 0, this, connection);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mPhoneAccount = phoneAccount;
    }

    private final PhoneAccountHandle $$robo$$android_telecom_Conference$getPhoneAccountHandle() {
        return this.mPhoneAccount;
    }

    private final List<Connection> $$robo$$android_telecom_Conference$getConnections() {
        return this.mUnmodifiableChildConnections;
    }

    private final int $$robo$$android_telecom_Conference$getState() {
        return this.mState;
    }

    private final int $$robo$$android_telecom_Conference$getCapabilities() {
        return this.mCapabilities;
    }

    private final AudioState $$robo$$android_telecom_Conference$getAudioState() {
        return this.mAudioState;
    }

    private final void $$robo$$android_telecom_Conference$onDisconnect() {
    }

    private final void $$robo$$android_telecom_Conference$onSeparate(Connection connection) {
    }

    private final void $$robo$$android_telecom_Conference$onMerge(Connection connection) {
    }

    private final void $$robo$$android_telecom_Conference$onHold() {
    }

    private final void $$robo$$android_telecom_Conference$onUnhold() {
    }

    private final void $$robo$$android_telecom_Conference$onMerge() {
    }

    private final void $$robo$$android_telecom_Conference$onSwap() {
    }

    private final void $$robo$$android_telecom_Conference$onPlayDtmfTone(char c) {
    }

    private final void $$robo$$android_telecom_Conference$onStopDtmfTone() {
    }

    private final void $$robo$$android_telecom_Conference$onAudioStateChanged(AudioState state) {
    }

    private final void $$robo$$android_telecom_Conference$setOnHold() {
        this.setState(5);
    }

    private final void $$robo$$android_telecom_Conference$setActive() {
        this.setState(4);
    }

    private final void $$robo$$android_telecom_Conference$setDisconnected(DisconnectCause disconnectCause) {
        this.mDisconnectCause = disconnectCause;
        this.setState(6);
        for (Listener l : this.mListeners) {
            l.onDisconnected(this, this.mDisconnectCause);
        }
    }

    private final void $$robo$$android_telecom_Conference$setCapabilities(int capabilities) {
        if (capabilities != this.mCapabilities) {
            this.mCapabilities = capabilities;
            for (Listener l : this.mListeners) {
                l.onCapabilitiesChanged(this, this.mCapabilities);
            }
        }
    }

    private final boolean $$robo$$android_telecom_Conference$addConnection(Connection connection) {
        if (connection != null && !this.mChildConnections.contains(connection) && connection.setConference(this)) {
            this.mChildConnections.add(connection);
            for (Listener l : this.mListeners) {
                l.onConnectionAdded(this, connection);
            }
            return true;
        }
        return false;
    }

    private final void $$robo$$android_telecom_Conference$removeConnection(Connection connection) {
        Log.d(this, "removing %s from %s", connection, this.mChildConnections);
        if (connection != null && this.mChildConnections.remove(connection)) {
            connection.resetConference();
            for (Listener l : this.mListeners) {
                l.onConnectionRemoved(this, connection);
            }
        }
    }

    private final void $$robo$$android_telecom_Conference$setConferenceableConnections(List<Connection> conferenceableConnections) {
        this.clearConferenceableList();
        for (Connection c : conferenceableConnections) {
            if (this.mConferenceableConnections.contains(c)) continue;
            c.addConnectionListener(this.mConnectionDeathListener);
            this.mConferenceableConnections.add(c);
        }
        this.fireOnConferenceableConnectionsChanged();
    }

    private final void $$robo$$android_telecom_Conference$fireOnConferenceableConnectionsChanged() {
        for (Listener l : this.mListeners) {
            l.onConferenceableConnectionsChanged(this, this.getConferenceableConnections());
        }
    }

    private final List<Connection> $$robo$$android_telecom_Conference$getConferenceableConnections() {
        return this.mUnmodifiableConferenceableConnections;
    }

    private final void $$robo$$android_telecom_Conference$destroy() {
        Log.d(this, "destroying conference : %s", this);
        for (Connection connection : this.mChildConnections) {
            Log.d(this, "removing connection %s", connection);
            this.removeConnection(connection);
        }
        if (this.mState != 6) {
            Log.d(this, "setting to disconnected", new Object[0]);
            this.setDisconnected(new DisconnectCause(2));
        }
        for (Listener l : this.mListeners) {
            l.onDestroyed(this);
        }
    }

    private final Conference $$robo$$android_telecom_Conference$addListener(Listener listener) {
        this.mListeners.add(listener);
        return this;
    }

    private final Conference $$robo$$android_telecom_Conference$removeListener(Listener listener) {
        this.mListeners.remove(listener);
        return this;
    }

    private final void $$robo$$android_telecom_Conference$setAudioState(AudioState state) {
        Log.d(this, "setAudioState %s", state);
        this.mAudioState = state;
        this.onAudioStateChanged(state);
    }

    private final void $$robo$$android_telecom_Conference$setState(int newState) {
        if (newState != 4 && newState != 5 && newState != 6) {
            Log.w(this, "Unsupported state transition for Conference call.", Connection.stateToString(newState));
            return;
        }
        if (this.mState != newState) {
            int oldState = this.mState;
            this.mState = newState;
            for (Listener l : this.mListeners) {
                l.onStateChanged(this, oldState, newState);
            }
        }
    }

    private final void $$robo$$android_telecom_Conference$clearConferenceableList() {
        for (Connection c : this.mConferenceableConnections) {
            c.removeConnectionListener(this.mConnectionDeathListener);
        }
        this.mConferenceableConnections.clear();
    }

    private void __constructor__(PhoneAccountHandle phoneAccountHandle) {
        this.$$robo$$android_telecom_Conference$__constructor__(phoneAccountHandle);
    }

    public Conference(PhoneAccountHandle phoneAccountHandle) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Conference$__constructor__(android.telecom.PhoneAccountHandle ), 0, this, phoneAccountHandle);
    }

    public PhoneAccountHandle getPhoneAccountHandle() {
        return InvokeDynamicSupport.bootstrap("getPhoneAccountHandle", $$robo$$android_telecom_Conference$getPhoneAccountHandle(), 0, this);
    }

    public List<Connection> getConnections() {
        return InvokeDynamicSupport.bootstrap("getConnections", $$robo$$android_telecom_Conference$getConnections(), 0, this);
    }

    public int getState() {
        return (int)InvokeDynamicSupport.bootstrap("getState", $$robo$$android_telecom_Conference$getState(), 0, this);
    }

    public int getCapabilities() {
        return (int)InvokeDynamicSupport.bootstrap("getCapabilities", $$robo$$android_telecom_Conference$getCapabilities(), 0, this);
    }

    public AudioState getAudioState() {
        return InvokeDynamicSupport.bootstrap("getAudioState", $$robo$$android_telecom_Conference$getAudioState(), 0, this);
    }

    public void onDisconnect() {
        InvokeDynamicSupport.bootstrap("onDisconnect", $$robo$$android_telecom_Conference$onDisconnect(), 0, this);
    }

    public void onSeparate(Connection connection) {
        InvokeDynamicSupport.bootstrap("onSeparate", $$robo$$android_telecom_Conference$onSeparate(android.telecom.Connection ), 0, this, connection);
    }

    public void onMerge(Connection connection) {
        InvokeDynamicSupport.bootstrap("onMerge", $$robo$$android_telecom_Conference$onMerge(android.telecom.Connection ), 0, this, connection);
    }

    public void onHold() {
        InvokeDynamicSupport.bootstrap("onHold", $$robo$$android_telecom_Conference$onHold(), 0, this);
    }

    public void onUnhold() {
        InvokeDynamicSupport.bootstrap("onUnhold", $$robo$$android_telecom_Conference$onUnhold(), 0, this);
    }

    public void onMerge() {
        InvokeDynamicSupport.bootstrap("onMerge", $$robo$$android_telecom_Conference$onMerge(), 0, this);
    }

    public void onSwap() {
        InvokeDynamicSupport.bootstrap("onSwap", $$robo$$android_telecom_Conference$onSwap(), 0, this);
    }

    public void onPlayDtmfTone(char c) {
        InvokeDynamicSupport.bootstrap("onPlayDtmfTone", $$robo$$android_telecom_Conference$onPlayDtmfTone(char ), 0, this, c);
    }

    public void onStopDtmfTone() {
        InvokeDynamicSupport.bootstrap("onStopDtmfTone", $$robo$$android_telecom_Conference$onStopDtmfTone(), 0, this);
    }

    public void onAudioStateChanged(AudioState audioState) {
        InvokeDynamicSupport.bootstrap("onAudioStateChanged", $$robo$$android_telecom_Conference$onAudioStateChanged(android.telecom.AudioState ), 0, this, audioState);
    }

    public void setOnHold() {
        InvokeDynamicSupport.bootstrap("setOnHold", $$robo$$android_telecom_Conference$setOnHold(), 0, this);
    }

    public void setActive() {
        InvokeDynamicSupport.bootstrap("setActive", $$robo$$android_telecom_Conference$setActive(), 0, this);
    }

    public void setDisconnected(DisconnectCause disconnectCause) {
        InvokeDynamicSupport.bootstrap("setDisconnected", $$robo$$android_telecom_Conference$setDisconnected(android.telecom.DisconnectCause ), 0, this, disconnectCause);
    }

    public void setCapabilities(int n) {
        InvokeDynamicSupport.bootstrap("setCapabilities", $$robo$$android_telecom_Conference$setCapabilities(int ), 0, this, n);
    }

    public boolean addConnection(Connection connection) {
        return (boolean)InvokeDynamicSupport.bootstrap("addConnection", $$robo$$android_telecom_Conference$addConnection(android.telecom.Connection ), 0, this, connection);
    }

    public void removeConnection(Connection connection) {
        InvokeDynamicSupport.bootstrap("removeConnection", $$robo$$android_telecom_Conference$removeConnection(android.telecom.Connection ), 0, this, connection);
    }

    public void setConferenceableConnections(List<Connection> list) {
        InvokeDynamicSupport.bootstrap("setConferenceableConnections", $$robo$$android_telecom_Conference$setConferenceableConnections(java.util.List<android.telecom.Connection> ), 0, this, list);
    }

    private void fireOnConferenceableConnectionsChanged() {
        InvokeDynamicSupport.bootstrap("fireOnConferenceableConnectionsChanged", $$robo$$android_telecom_Conference$fireOnConferenceableConnectionsChanged(), 0, this);
    }

    public List<Connection> getConferenceableConnections() {
        return InvokeDynamicSupport.bootstrap("getConferenceableConnections", $$robo$$android_telecom_Conference$getConferenceableConnections(), 0, this);
    }

    public void destroy() {
        InvokeDynamicSupport.bootstrap("destroy", $$robo$$android_telecom_Conference$destroy(), 0, this);
    }

    public Conference addListener(Listener listener) {
        return InvokeDynamicSupport.bootstrap("addListener", $$robo$$android_telecom_Conference$addListener(android.telecom.Conference$Listener ), 0, this, listener);
    }

    public Conference removeListener(Listener listener) {
        return InvokeDynamicSupport.bootstrap("removeListener", $$robo$$android_telecom_Conference$removeListener(android.telecom.Conference$Listener ), 0, this, listener);
    }

    void setAudioState(AudioState audioState) {
        InvokeDynamicSupport.bootstrap("setAudioState", $$robo$$android_telecom_Conference$setAudioState(android.telecom.AudioState ), 0, this, audioState);
    }

    private void setState(int n) {
        InvokeDynamicSupport.bootstrap("setState", $$robo$$android_telecom_Conference$setState(int ), 0, this, n);
    }

    private void clearConferenceableList() {
        InvokeDynamicSupport.bootstrap("clearConferenceableList", $$robo$$android_telecom_Conference$clearConferenceableList(), 0, this);
    }

    public /* synthetic */ Conference() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Conference)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static abstract class Listener
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_telecom_Conference_Listener$__constructor__() {
        }

        private final void $$robo$$android_telecom_Conference_Listener$onStateChanged(Conference conference, int oldState, int newState) {
        }

        private final void $$robo$$android_telecom_Conference_Listener$onDisconnected(Conference conference, DisconnectCause disconnectCause) {
        }

        private final void $$robo$$android_telecom_Conference_Listener$onConnectionAdded(Conference conference, Connection connection) {
        }

        private final void $$robo$$android_telecom_Conference_Listener$onConnectionRemoved(Conference conference, Connection connection) {
        }

        private final void $$robo$$android_telecom_Conference_Listener$onConferenceableConnectionsChanged(Conference conference, List<Connection> conferenceableConnections) {
        }

        private final void $$robo$$android_telecom_Conference_Listener$onDestroyed(Conference conference) {
        }

        private final void $$robo$$android_telecom_Conference_Listener$onCapabilitiesChanged(Conference conference, int capabilities) {
        }

        private void __constructor__() {
            this.$$robo$$android_telecom_Conference_Listener$__constructor__();
        }

        public Listener() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Conference_Listener$__constructor__(), 0, this);
        }

        public void onStateChanged(Conference conference, int n, int n2) {
            InvokeDynamicSupport.bootstrap("onStateChanged", $$robo$$android_telecom_Conference_Listener$onStateChanged(android.telecom.Conference int int ), 0, this, conference, n, n2);
        }

        public void onDisconnected(Conference conference, DisconnectCause disconnectCause) {
            InvokeDynamicSupport.bootstrap("onDisconnected", $$robo$$android_telecom_Conference_Listener$onDisconnected(android.telecom.Conference android.telecom.DisconnectCause ), 0, this, conference, disconnectCause);
        }

        public void onConnectionAdded(Conference conference, Connection connection) {
            InvokeDynamicSupport.bootstrap("onConnectionAdded", $$robo$$android_telecom_Conference_Listener$onConnectionAdded(android.telecom.Conference android.telecom.Connection ), 0, this, conference, connection);
        }

        public void onConnectionRemoved(Conference conference, Connection connection) {
            InvokeDynamicSupport.bootstrap("onConnectionRemoved", $$robo$$android_telecom_Conference_Listener$onConnectionRemoved(android.telecom.Conference android.telecom.Connection ), 0, this, conference, connection);
        }

        public void onConferenceableConnectionsChanged(Conference conference, List<Connection> list) {
            InvokeDynamicSupport.bootstrap("onConferenceableConnectionsChanged", $$robo$$android_telecom_Conference_Listener$onConferenceableConnectionsChanged(android.telecom.Conference java.util.List<android.telecom.Connection> ), 0, this, conference, list);
        }

        public void onDestroyed(Conference conference) {
            InvokeDynamicSupport.bootstrap("onDestroyed", $$robo$$android_telecom_Conference_Listener$onDestroyed(android.telecom.Conference ), 0, this, conference);
        }

        public void onCapabilitiesChanged(Conference conference, int n) {
            InvokeDynamicSupport.bootstrap("onCapabilitiesChanged", $$robo$$android_telecom_Conference_Listener$onCapabilitiesChanged(android.telecom.Conference int ), 0, this, conference, n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Listener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

