/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.net.Uri;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.telecom.AudioState;
import android.telecom.CameraCapabilities;
import android.telecom.Conference;
import android.telecom.ConnectionService;
import android.telecom.DisconnectCause;
import android.telecom.Log;
import android.telecom.StatusHints;
import android.telecom.VideoProfile;
import android.view.Surface;
import com.android.internal.telecom.IVideoCallback;
import com.android.internal.telecom.IVideoProvider;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class Connection
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int STATE_INITIALIZING = 0;
    public static int STATE_NEW = 1;
    public static int STATE_RINGING = 2;
    public static int STATE_DIALING = 3;
    public static int STATE_ACTIVE = 4;
    public static int STATE_HOLDING = 5;
    public static int STATE_DISCONNECTED = 6;
    private static boolean PII_DEBUG;
    private Listener mConnectionDeathListener;
    private Set<Listener> mListeners;
    private List<Connection> mConferenceableConnections;
    private List<Connection> mUnmodifiableConferenceableConnections;
    private int mState;
    private AudioState mAudioState;
    private Uri mAddress;
    private int mAddressPresentation;
    private String mCallerDisplayName;
    private int mCallerDisplayNamePresentation;
    private boolean mRingbackRequested;
    private int mCallCapabilities;
    private VideoProvider mVideoProvider;
    private boolean mAudioModeIsVoip;
    private StatusHints mStatusHints;
    private int mVideoState;
    private DisconnectCause mDisconnectCause;
    private Conference mConference;
    private ConnectionService mConnectionService;

    private void $$robo$$android_telecom_Connection$__constructor__() {
        this.mConnectionDeathListener = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ Connection this$0;

            private void $$robo$$android_telecom_Connection_1$__constructor__(Connection connection) {
            }

            private final void $$robo$$android_telecom_Connection_1$onDestroyed(Connection c) {
                if (this.this$0.mConferenceableConnections.remove(c)) {
                    this.this$0.fireOnConferenceableConnectionsChanged();
                }
            }

            private void __constructor__(Connection connection) {
                this.$$robo$$android_telecom_Connection_1$__constructor__(connection);
            }
            {
                this.this$0 = connection;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Connection_1$__constructor__(android.telecom.Connection ), 0, this, connection);
            }

            @Override
            public void onDestroyed(Connection connection) {
                InvokeDynamicSupport.bootstrap("onDestroyed", $$robo$$android_telecom_Connection_1$onDestroyed(android.telecom.Connection ), 0, this, connection);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mListeners = Collections.newSetFromMap(new ConcurrentHashMap(8, 0.9f, 1));
        this.mConferenceableConnections = new ArrayList<Connection>();
        this.mUnmodifiableConferenceableConnections = Collections.unmodifiableList(this.mConferenceableConnections);
        this.mState = 1;
        this.mRingbackRequested = false;
    }

    private final Uri $$robo$$android_telecom_Connection$getAddress() {
        return this.mAddress;
    }

    private final int $$robo$$android_telecom_Connection$getAddressPresentation() {
        return this.mAddressPresentation;
    }

    private final String $$robo$$android_telecom_Connection$getCallerDisplayName() {
        return this.mCallerDisplayName;
    }

    private final int $$robo$$android_telecom_Connection$getCallerDisplayNamePresentation() {
        return this.mCallerDisplayNamePresentation;
    }

    private final int $$robo$$android_telecom_Connection$getState() {
        return this.mState;
    }

    private final int $$robo$$android_telecom_Connection$getVideoState() {
        return this.mVideoState;
    }

    private final AudioState $$robo$$android_telecom_Connection$getAudioState() {
        return this.mAudioState;
    }

    private final Conference $$robo$$android_telecom_Connection$getConference() {
        return this.mConference;
    }

    private final boolean $$robo$$android_telecom_Connection$isRingbackRequested() {
        return this.mRingbackRequested;
    }

    private final boolean $$robo$$android_telecom_Connection$getAudioModeIsVoip() {
        return this.mAudioModeIsVoip;
    }

    private final StatusHints $$robo$$android_telecom_Connection$getStatusHints() {
        return this.mStatusHints;
    }

    private final Connection $$robo$$android_telecom_Connection$addConnectionListener(Listener l) {
        this.mListeners.add(l);
        return this;
    }

    private final Connection $$robo$$android_telecom_Connection$removeConnectionListener(Listener l) {
        if (l != null) {
            this.mListeners.remove(l);
        }
        return this;
    }

    private final DisconnectCause $$robo$$android_telecom_Connection$getDisconnectCause() {
        return this.mDisconnectCause;
    }

    private final void $$robo$$android_telecom_Connection$setAudioState(AudioState state) {
        Log.d(this, "setAudioState %s", state);
        this.mAudioState = state;
        this.onAudioStateChanged(state);
    }

    private static final String $$robo$$android_telecom_Connection$stateToString(int state) {
        switch (state) {
            case 0: {
                return "STATE_INITIALIZING";
            }
            case 1: {
                return "STATE_NEW";
            }
            case 2: {
                return "STATE_RINGING";
            }
            case 3: {
                return "STATE_DIALING";
            }
            case 4: {
                return "STATE_ACTIVE";
            }
            case 5: {
                return "STATE_HOLDING";
            }
            case 6: {
                return "DISCONNECTED";
            }
        }
        Log.wtf(Connection.class, "Unknown state %d", state);
        return "UNKNOWN";
    }

    private final int $$robo$$android_telecom_Connection$getCallCapabilities() {
        return this.mCallCapabilities;
    }

    private final void $$robo$$android_telecom_Connection$setAddress(Uri address, int presentation) {
        Log.d(this, "setAddress %s", address);
        this.mAddress = address;
        this.mAddressPresentation = presentation;
        for (Listener l : this.mListeners) {
            l.onAddressChanged(this, address, presentation);
        }
    }

    private final void $$robo$$android_telecom_Connection$setCallerDisplayName(String callerDisplayName, int presentation) {
        Log.d(this, "setCallerDisplayName %s", callerDisplayName);
        this.mCallerDisplayName = callerDisplayName;
        this.mCallerDisplayNamePresentation = presentation;
        for (Listener l : this.mListeners) {
            l.onCallerDisplayNameChanged(this, callerDisplayName, presentation);
        }
    }

    private final void $$robo$$android_telecom_Connection$setVideoState(int videoState) {
        Log.d(this, "setVideoState %d", videoState);
        this.mVideoState = videoState;
        for (Listener l : this.mListeners) {
            l.onVideoStateChanged(this, this.mVideoState);
        }
    }

    private final void $$robo$$android_telecom_Connection$setActive() {
        this.setRingbackRequested(false);
        this.setState(4);
    }

    private final void $$robo$$android_telecom_Connection$setRinging() {
        this.setState(2);
    }

    private final void $$robo$$android_telecom_Connection$setInitializing() {
        this.setState(0);
    }

    private final void $$robo$$android_telecom_Connection$setInitialized() {
        this.setState(1);
    }

    private final void $$robo$$android_telecom_Connection$setDialing() {
        this.setState(3);
    }

    private final void $$robo$$android_telecom_Connection$setOnHold() {
        this.setState(5);
    }

    private final void $$robo$$android_telecom_Connection$setVideoProvider(VideoProvider videoProvider) {
        this.mVideoProvider = videoProvider;
        for (Listener l : this.mListeners) {
            l.onVideoProviderChanged(this, videoProvider);
        }
    }

    private final VideoProvider $$robo$$android_telecom_Connection$getVideoProvider() {
        return this.mVideoProvider;
    }

    private final void $$robo$$android_telecom_Connection$setDisconnected(DisconnectCause disconnectCause) {
        this.mDisconnectCause = disconnectCause;
        this.setState(6);
        Log.d(this, "Disconnected with cause %s", disconnectCause);
        for (Listener l : this.mListeners) {
            l.onDisconnected(this, disconnectCause);
        }
    }

    private final void $$robo$$android_telecom_Connection$setPostDialWait(String remaining) {
        for (Listener l : this.mListeners) {
            l.onPostDialWait(this, remaining);
        }
    }

    private final void $$robo$$android_telecom_Connection$setRingbackRequested(boolean ringback) {
        if (this.mRingbackRequested != ringback) {
            this.mRingbackRequested = ringback;
            for (Listener l : this.mListeners) {
                l.onRingbackRequested(this, ringback);
            }
        }
    }

    private final void $$robo$$android_telecom_Connection$setCallCapabilities(int callCapabilities) {
        if (this.mCallCapabilities != callCapabilities) {
            this.mCallCapabilities = callCapabilities;
            for (Listener l : this.mListeners) {
                l.onCallCapabilitiesChanged(this, this.mCallCapabilities);
            }
        }
    }

    private final void $$robo$$android_telecom_Connection$destroy() {
        for (Listener l : this.mListeners) {
            l.onDestroyed(this);
        }
    }

    private final void $$robo$$android_telecom_Connection$setAudioModeIsVoip(boolean isVoip) {
        this.mAudioModeIsVoip = isVoip;
        for (Listener l : this.mListeners) {
            l.onAudioModeIsVoipChanged(this, isVoip);
        }
    }

    private final void $$robo$$android_telecom_Connection$setStatusHints(StatusHints statusHints) {
        this.mStatusHints = statusHints;
        for (Listener l : this.mListeners) {
            l.onStatusHintsChanged(this, statusHints);
        }
    }

    private final void $$robo$$android_telecom_Connection$setConferenceableConnections(List<Connection> conferenceableConnections) {
        this.clearConferenceableList();
        for (Connection c : conferenceableConnections) {
            if (this.mConferenceableConnections.contains(c)) continue;
            c.addConnectionListener(this.mConnectionDeathListener);
            this.mConferenceableConnections.add(c);
        }
        this.fireOnConferenceableConnectionsChanged();
    }

    private final List<Connection> $$robo$$android_telecom_Connection$getConferenceableConnections() {
        return this.mUnmodifiableConferenceableConnections;
    }

    private final void $$robo$$android_telecom_Connection$setConnectionService(ConnectionService connectionService) {
        if (this.mConnectionService != null) {
            Log.e(this, (Throwable)new Exception(), "Trying to set ConnectionService on a connection which is already associated with another ConnectionService.", new Object[0]);
        } else {
            this.mConnectionService = connectionService;
        }
    }

    private final void $$robo$$android_telecom_Connection$unsetConnectionService(ConnectionService connectionService) {
        if (this.mConnectionService != connectionService) {
            Log.e(this, (Throwable)new Exception(), "Trying to remove ConnectionService from a Connection that does not belong to the ConnectionService.", new Object[0]);
        } else {
            this.mConnectionService = null;
        }
    }

    private final ConnectionService $$robo$$android_telecom_Connection$getConnectionService() {
        return this.mConnectionService;
    }

    private final boolean $$robo$$android_telecom_Connection$setConference(Conference conference) {
        if (this.mConference == null) {
            this.mConference = conference;
            if (this.mConnectionService != null && this.mConnectionService.containsConference(conference)) {
                this.fireConferenceChanged();
            }
            return true;
        }
        return false;
    }

    private final void $$robo$$android_telecom_Connection$resetConference() {
        if (this.mConference != null) {
            Log.d(this, "Conference reset", new Object[0]);
            this.mConference = null;
            this.fireConferenceChanged();
        }
    }

    private final void $$robo$$android_telecom_Connection$onAudioStateChanged(AudioState state) {
    }

    private final void $$robo$$android_telecom_Connection$onStateChanged(int state) {
    }

    private final void $$robo$$android_telecom_Connection$onPlayDtmfTone(char c) {
    }

    private final void $$robo$$android_telecom_Connection$onStopDtmfTone() {
    }

    private final void $$robo$$android_telecom_Connection$onDisconnect() {
    }

    private final void $$robo$$android_telecom_Connection$onSeparate() {
    }

    private final void $$robo$$android_telecom_Connection$onAbort() {
    }

    private final void $$robo$$android_telecom_Connection$onHold() {
    }

    private final void $$robo$$android_telecom_Connection$onUnhold() {
    }

    private final void $$robo$$android_telecom_Connection$onAnswer(int videoState) {
    }

    private final void $$robo$$android_telecom_Connection$onAnswer() {
        this.onAnswer(0);
    }

    private final void $$robo$$android_telecom_Connection$onReject() {
    }

    private final void $$robo$$android_telecom_Connection$onPostDialContinue(boolean proceed) {
    }

    private final void $$robo$$android_telecom_Connection$onConferenceWith(Connection otherConnection) {
    }

    private static final String $$robo$$android_telecom_Connection$toLogSafePhoneNumber(String number) {
        if (number == null) {
            return "";
        }
        if (PII_DEBUG) {
            return number;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < number.length(); ++i) {
            char c = number.charAt(i);
            if (c == '-' || c == '@' || c == '.') {
                builder.append(c);
                continue;
            }
            builder.append('x');
        }
        return builder.toString();
    }

    private final void $$robo$$android_telecom_Connection$setState(int state) {
        if (this.mState == 6 && this.mState != state) {
            Log.d(this, "Connection already DISCONNECTED; cannot transition out of this state.", new Object[0]);
            return;
        }
        if (this.mState != state) {
            Log.d(this, "setState: %s", Connection.stateToString(state));
            this.mState = state;
            this.onStateChanged(state);
            for (Listener l : this.mListeners) {
                l.onStateChanged(this, state);
            }
        }
    }

    private static final Connection $$robo$$android_telecom_Connection$createFailedConnection(DisconnectCause disconnectCause) {
        return new FailureSignalingConnection(disconnectCause);
    }

    private static final Connection $$robo$$android_telecom_Connection$createCanceledConnection() {
        return new FailureSignalingConnection(new DisconnectCause(4));
    }

    private final void $$robo$$android_telecom_Connection$fireOnConferenceableConnectionsChanged() {
        for (Listener l : this.mListeners) {
            l.onConferenceableConnectionsChanged(this, this.getConferenceableConnections());
        }
    }

    private final void $$robo$$android_telecom_Connection$fireConferenceChanged() {
        for (Listener l : this.mListeners) {
            l.onConferenceChanged(this, this.mConference);
        }
    }

    private final void $$robo$$android_telecom_Connection$clearConferenceableList() {
        for (Connection c : this.mConferenceableConnections) {
            c.removeConnectionListener(this.mConnectionDeathListener);
        }
        this.mConferenceableConnections.clear();
    }

    static void __staticInitializer__() {
        PII_DEBUG = Log.isLoggable(3);
    }

    private void __constructor__() {
        this.$$robo$$android_telecom_Connection$__constructor__();
    }

    public Connection() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Connection$__constructor__(), 0, this);
    }

    public Uri getAddress() {
        return InvokeDynamicSupport.bootstrap("getAddress", $$robo$$android_telecom_Connection$getAddress(), 0, this);
    }

    public int getAddressPresentation() {
        return (int)InvokeDynamicSupport.bootstrap("getAddressPresentation", $$robo$$android_telecom_Connection$getAddressPresentation(), 0, this);
    }

    public String getCallerDisplayName() {
        return InvokeDynamicSupport.bootstrap("getCallerDisplayName", $$robo$$android_telecom_Connection$getCallerDisplayName(), 0, this);
    }

    public int getCallerDisplayNamePresentation() {
        return (int)InvokeDynamicSupport.bootstrap("getCallerDisplayNamePresentation", $$robo$$android_telecom_Connection$getCallerDisplayNamePresentation(), 0, this);
    }

    public int getState() {
        return (int)InvokeDynamicSupport.bootstrap("getState", $$robo$$android_telecom_Connection$getState(), 0, this);
    }

    public int getVideoState() {
        return (int)InvokeDynamicSupport.bootstrap("getVideoState", $$robo$$android_telecom_Connection$getVideoState(), 0, this);
    }

    public AudioState getAudioState() {
        return InvokeDynamicSupport.bootstrap("getAudioState", $$robo$$android_telecom_Connection$getAudioState(), 0, this);
    }

    public Conference getConference() {
        return InvokeDynamicSupport.bootstrap("getConference", $$robo$$android_telecom_Connection$getConference(), 0, this);
    }

    public boolean isRingbackRequested() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRingbackRequested", $$robo$$android_telecom_Connection$isRingbackRequested(), 0, this);
    }

    public boolean getAudioModeIsVoip() {
        return (boolean)InvokeDynamicSupport.bootstrap("getAudioModeIsVoip", $$robo$$android_telecom_Connection$getAudioModeIsVoip(), 0, this);
    }

    public StatusHints getStatusHints() {
        return InvokeDynamicSupport.bootstrap("getStatusHints", $$robo$$android_telecom_Connection$getStatusHints(), 0, this);
    }

    public Connection addConnectionListener(Listener listener) {
        return InvokeDynamicSupport.bootstrap("addConnectionListener", $$robo$$android_telecom_Connection$addConnectionListener(android.telecom.Connection$Listener ), 0, this, listener);
    }

    public Connection removeConnectionListener(Listener listener) {
        return InvokeDynamicSupport.bootstrap("removeConnectionListener", $$robo$$android_telecom_Connection$removeConnectionListener(android.telecom.Connection$Listener ), 0, this, listener);
    }

    public DisconnectCause getDisconnectCause() {
        return InvokeDynamicSupport.bootstrap("getDisconnectCause", $$robo$$android_telecom_Connection$getDisconnectCause(), 0, this);
    }

    void setAudioState(AudioState audioState) {
        InvokeDynamicSupport.bootstrap("setAudioState", $$robo$$android_telecom_Connection$setAudioState(android.telecom.AudioState ), 0, this, audioState);
    }

    public static String stateToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("stateToString", $$robo$$android_telecom_Connection$stateToString(int ), 0, (int)n);
    }

    public int getCallCapabilities() {
        return (int)InvokeDynamicSupport.bootstrap("getCallCapabilities", $$robo$$android_telecom_Connection$getCallCapabilities(), 0, this);
    }

    public void setAddress(Uri uri, int n) {
        InvokeDynamicSupport.bootstrap("setAddress", $$robo$$android_telecom_Connection$setAddress(android.net.Uri int ), 0, this, uri, n);
    }

    public void setCallerDisplayName(String string2, int n) {
        InvokeDynamicSupport.bootstrap("setCallerDisplayName", $$robo$$android_telecom_Connection$setCallerDisplayName(java.lang.String int ), 0, this, string2, n);
    }

    public void setVideoState(int n) {
        InvokeDynamicSupport.bootstrap("setVideoState", $$robo$$android_telecom_Connection$setVideoState(int ), 0, this, n);
    }

    public void setActive() {
        InvokeDynamicSupport.bootstrap("setActive", $$robo$$android_telecom_Connection$setActive(), 0, this);
    }

    public void setRinging() {
        InvokeDynamicSupport.bootstrap("setRinging", $$robo$$android_telecom_Connection$setRinging(), 0, this);
    }

    public void setInitializing() {
        InvokeDynamicSupport.bootstrap("setInitializing", $$robo$$android_telecom_Connection$setInitializing(), 0, this);
    }

    public void setInitialized() {
        InvokeDynamicSupport.bootstrap("setInitialized", $$robo$$android_telecom_Connection$setInitialized(), 0, this);
    }

    public void setDialing() {
        InvokeDynamicSupport.bootstrap("setDialing", $$robo$$android_telecom_Connection$setDialing(), 0, this);
    }

    public void setOnHold() {
        InvokeDynamicSupport.bootstrap("setOnHold", $$robo$$android_telecom_Connection$setOnHold(), 0, this);
    }

    public void setVideoProvider(VideoProvider videoProvider) {
        InvokeDynamicSupport.bootstrap("setVideoProvider", $$robo$$android_telecom_Connection$setVideoProvider(android.telecom.Connection$VideoProvider ), 0, this, videoProvider);
    }

    public VideoProvider getVideoProvider() {
        return InvokeDynamicSupport.bootstrap("getVideoProvider", $$robo$$android_telecom_Connection$getVideoProvider(), 0, this);
    }

    public void setDisconnected(DisconnectCause disconnectCause) {
        InvokeDynamicSupport.bootstrap("setDisconnected", $$robo$$android_telecom_Connection$setDisconnected(android.telecom.DisconnectCause ), 0, this, disconnectCause);
    }

    public void setPostDialWait(String string2) {
        InvokeDynamicSupport.bootstrap("setPostDialWait", $$robo$$android_telecom_Connection$setPostDialWait(java.lang.String ), 0, this, string2);
    }

    public void setRingbackRequested(boolean bl) {
        InvokeDynamicSupport.bootstrap("setRingbackRequested", $$robo$$android_telecom_Connection$setRingbackRequested(boolean ), 0, this, bl);
    }

    public void setCallCapabilities(int n) {
        InvokeDynamicSupport.bootstrap("setCallCapabilities", $$robo$$android_telecom_Connection$setCallCapabilities(int ), 0, this, n);
    }

    public void destroy() {
        InvokeDynamicSupport.bootstrap("destroy", $$robo$$android_telecom_Connection$destroy(), 0, this);
    }

    public void setAudioModeIsVoip(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAudioModeIsVoip", $$robo$$android_telecom_Connection$setAudioModeIsVoip(boolean ), 0, this, bl);
    }

    public void setStatusHints(StatusHints statusHints) {
        InvokeDynamicSupport.bootstrap("setStatusHints", $$robo$$android_telecom_Connection$setStatusHints(android.telecom.StatusHints ), 0, this, statusHints);
    }

    public void setConferenceableConnections(List<Connection> list) {
        InvokeDynamicSupport.bootstrap("setConferenceableConnections", $$robo$$android_telecom_Connection$setConferenceableConnections(java.util.List<android.telecom.Connection> ), 0, this, list);
    }

    public List<Connection> getConferenceableConnections() {
        return InvokeDynamicSupport.bootstrap("getConferenceableConnections", $$robo$$android_telecom_Connection$getConferenceableConnections(), 0, this);
    }

    public void setConnectionService(ConnectionService connectionService) {
        InvokeDynamicSupport.bootstrap("setConnectionService", $$robo$$android_telecom_Connection$setConnectionService(android.telecom.ConnectionService ), 0, this, connectionService);
    }

    public void unsetConnectionService(ConnectionService connectionService) {
        InvokeDynamicSupport.bootstrap("unsetConnectionService", $$robo$$android_telecom_Connection$unsetConnectionService(android.telecom.ConnectionService ), 0, this, connectionService);
    }

    public ConnectionService getConnectionService() {
        return InvokeDynamicSupport.bootstrap("getConnectionService", $$robo$$android_telecom_Connection$getConnectionService(), 0, this);
    }

    public boolean setConference(Conference conference) {
        return (boolean)InvokeDynamicSupport.bootstrap("setConference", $$robo$$android_telecom_Connection$setConference(android.telecom.Conference ), 0, this, conference);
    }

    public void resetConference() {
        InvokeDynamicSupport.bootstrap("resetConference", $$robo$$android_telecom_Connection$resetConference(), 0, this);
    }

    public void onAudioStateChanged(AudioState audioState) {
        InvokeDynamicSupport.bootstrap("onAudioStateChanged", $$robo$$android_telecom_Connection$onAudioStateChanged(android.telecom.AudioState ), 0, this, audioState);
    }

    public void onStateChanged(int n) {
        InvokeDynamicSupport.bootstrap("onStateChanged", $$robo$$android_telecom_Connection$onStateChanged(int ), 0, this, n);
    }

    public void onPlayDtmfTone(char c) {
        InvokeDynamicSupport.bootstrap("onPlayDtmfTone", $$robo$$android_telecom_Connection$onPlayDtmfTone(char ), 0, this, c);
    }

    public void onStopDtmfTone() {
        InvokeDynamicSupport.bootstrap("onStopDtmfTone", $$robo$$android_telecom_Connection$onStopDtmfTone(), 0, this);
    }

    public void onDisconnect() {
        InvokeDynamicSupport.bootstrap("onDisconnect", $$robo$$android_telecom_Connection$onDisconnect(), 0, this);
    }

    public void onSeparate() {
        InvokeDynamicSupport.bootstrap("onSeparate", $$robo$$android_telecom_Connection$onSeparate(), 0, this);
    }

    public void onAbort() {
        InvokeDynamicSupport.bootstrap("onAbort", $$robo$$android_telecom_Connection$onAbort(), 0, this);
    }

    public void onHold() {
        InvokeDynamicSupport.bootstrap("onHold", $$robo$$android_telecom_Connection$onHold(), 0, this);
    }

    public void onUnhold() {
        InvokeDynamicSupport.bootstrap("onUnhold", $$robo$$android_telecom_Connection$onUnhold(), 0, this);
    }

    public void onAnswer(int n) {
        InvokeDynamicSupport.bootstrap("onAnswer", $$robo$$android_telecom_Connection$onAnswer(int ), 0, this, n);
    }

    public void onAnswer() {
        InvokeDynamicSupport.bootstrap("onAnswer", $$robo$$android_telecom_Connection$onAnswer(), 0, this);
    }

    public void onReject() {
        InvokeDynamicSupport.bootstrap("onReject", $$robo$$android_telecom_Connection$onReject(), 0, this);
    }

    public void onPostDialContinue(boolean bl) {
        InvokeDynamicSupport.bootstrap("onPostDialContinue", $$robo$$android_telecom_Connection$onPostDialContinue(boolean ), 0, this, bl);
    }

    public void onConferenceWith(Connection connection) {
        InvokeDynamicSupport.bootstrap("onConferenceWith", $$robo$$android_telecom_Connection$onConferenceWith(android.telecom.Connection ), 0, this, connection);
    }

    static String toLogSafePhoneNumber(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("toLogSafePhoneNumber", $$robo$$android_telecom_Connection$toLogSafePhoneNumber(java.lang.String ), 0, (String)string2);
    }

    private void setState(int n) {
        InvokeDynamicSupport.bootstrap("setState", $$robo$$android_telecom_Connection$setState(int ), 0, this, n);
    }

    public static Connection createFailedConnection(DisconnectCause disconnectCause) {
        return InvokeDynamicSupport.bootstrapStatic("createFailedConnection", $$robo$$android_telecom_Connection$createFailedConnection(android.telecom.DisconnectCause ), 0, (DisconnectCause)disconnectCause);
    }

    public static Connection createCanceledConnection() {
        return InvokeDynamicSupport.bootstrapStatic("createCanceledConnection", $$robo$$android_telecom_Connection$createCanceledConnection(), 0);
    }

    private void fireOnConferenceableConnectionsChanged() {
        InvokeDynamicSupport.bootstrap("fireOnConferenceableConnectionsChanged", $$robo$$android_telecom_Connection$fireOnConferenceableConnectionsChanged(), 0, this);
    }

    private void fireConferenceChanged() {
        InvokeDynamicSupport.bootstrap("fireConferenceChanged", $$robo$$android_telecom_Connection$fireConferenceChanged(), 0, this);
    }

    private void clearConferenceableList() {
        InvokeDynamicSupport.bootstrap("clearConferenceableList", $$robo$$android_telecom_Connection$clearConferenceableList(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(Connection.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Connection)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class FailureSignalingConnection
    extends Connection
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_telecom_Connection_FailureSignalingConnection$__constructor__(DisconnectCause disconnectCause) {
            this.setDisconnected(disconnectCause);
        }

        private void __constructor__(DisconnectCause disconnectCause) {
            this.$$robo$$android_telecom_Connection_FailureSignalingConnection$__constructor__(disconnectCause);
        }

        public FailureSignalingConnection(DisconnectCause disconnectCause) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Connection_FailureSignalingConnection$__constructor__(android.telecom.DisconnectCause ), 0, this, disconnectCause);
        }

        public /* synthetic */ FailureSignalingConnection() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FailureSignalingConnection)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class VideoProvider
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int SESSION_EVENT_RX_PAUSE = 1;
        public static int SESSION_EVENT_RX_RESUME = 2;
        public static int SESSION_EVENT_TX_START = 3;
        public static int SESSION_EVENT_TX_STOP = 4;
        public static int SESSION_EVENT_CAMERA_FAILURE = 5;
        public static int SESSION_EVENT_CAMERA_READY = 6;
        public static int SESSION_MODIFY_REQUEST_SUCCESS = 1;
        public static int SESSION_MODIFY_REQUEST_FAIL = 2;
        public static int SESSION_MODIFY_REQUEST_INVALID = 3;
        private static int MSG_SET_VIDEO_CALLBACK = 1;
        private static int MSG_SET_CAMERA = 2;
        private static int MSG_SET_PREVIEW_SURFACE = 3;
        private static int MSG_SET_DISPLAY_SURFACE = 4;
        private static int MSG_SET_DEVICE_ORIENTATION = 5;
        private static int MSG_SET_ZOOM = 6;
        private static int MSG_SEND_SESSION_MODIFY_REQUEST = 7;
        private static int MSG_SEND_SESSION_MODIFY_RESPONSE = 8;
        private static int MSG_REQUEST_CAMERA_CAPABILITIES = 9;
        private static int MSG_REQUEST_CALL_DATA_USAGE = 10;
        private static int MSG_SET_PAUSE_IMAGE = 11;
        private VideoProviderHandler mMessageHandler;
        private VideoProviderBinder mBinder;
        private IVideoCallback mVideoCallback;

        private void $$robo$$android_telecom_Connection_VideoProvider$__constructor__() {
            this.mMessageHandler = new VideoProviderHandler(this);
            this.mBinder = new VideoProviderBinder(this);
        }

        private final IVideoProvider $$robo$$android_telecom_Connection_VideoProvider$getInterface() {
            return this.mBinder;
        }

        public abstract void onSetCamera(String var1);

        public abstract void onSetPreviewSurface(Surface var1);

        public abstract void onSetDisplaySurface(Surface var1);

        public abstract void onSetDeviceOrientation(int var1);

        public abstract void onSetZoom(float var1);

        public abstract void onSendSessionModifyRequest(VideoProfile var1);

        public abstract void onSendSessionModifyResponse(VideoProfile var1);

        public abstract void onRequestCameraCapabilities();

        public abstract void onRequestCallDataUsage();

        public abstract void onSetPauseImage(String var1);

        private final void $$robo$$android_telecom_Connection_VideoProvider$receiveSessionModifyRequest(VideoProfile videoProfile) {
            if (this.mVideoCallback != null) {
                try {
                    this.mVideoCallback.receiveSessionModifyRequest(videoProfile);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        private final void $$robo$$android_telecom_Connection_VideoProvider$receiveSessionModifyResponse(int status, VideoProfile requestedProfile, VideoProfile responseProfile) {
            if (this.mVideoCallback != null) {
                try {
                    this.mVideoCallback.receiveSessionModifyResponse(status, requestedProfile, responseProfile);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        private final void $$robo$$android_telecom_Connection_VideoProvider$handleCallSessionEvent(int event) {
            if (this.mVideoCallback != null) {
                try {
                    this.mVideoCallback.handleCallSessionEvent(event);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        private final void $$robo$$android_telecom_Connection_VideoProvider$changePeerDimensions(int width, int height) {
            if (this.mVideoCallback != null) {
                try {
                    this.mVideoCallback.changePeerDimensions(width, height);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        private final void $$robo$$android_telecom_Connection_VideoProvider$changeCallDataUsage(int dataUsage) {
            if (this.mVideoCallback != null) {
                try {
                    this.mVideoCallback.changeCallDataUsage(dataUsage);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        private final void $$robo$$android_telecom_Connection_VideoProvider$changeCameraCapabilities(CameraCapabilities cameraCapabilities) {
            if (this.mVideoCallback != null) {
                try {
                    this.mVideoCallback.changeCameraCapabilities(cameraCapabilities);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        private void __constructor__() {
            this.$$robo$$android_telecom_Connection_VideoProvider$__constructor__();
        }

        public VideoProvider() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Connection_VideoProvider$__constructor__(), 0, this);
        }

        public IVideoProvider getInterface() {
            return InvokeDynamicSupport.bootstrap("getInterface", $$robo$$android_telecom_Connection_VideoProvider$getInterface(), 0, this);
        }

        public void receiveSessionModifyRequest(VideoProfile videoProfile) {
            InvokeDynamicSupport.bootstrap("receiveSessionModifyRequest", $$robo$$android_telecom_Connection_VideoProvider$receiveSessionModifyRequest(android.telecom.VideoProfile ), 0, this, videoProfile);
        }

        public void receiveSessionModifyResponse(int n, VideoProfile videoProfile, VideoProfile videoProfile2) {
            InvokeDynamicSupport.bootstrap("receiveSessionModifyResponse", $$robo$$android_telecom_Connection_VideoProvider$receiveSessionModifyResponse(int android.telecom.VideoProfile android.telecom.VideoProfile ), 0, this, n, videoProfile, videoProfile2);
        }

        public void handleCallSessionEvent(int n) {
            InvokeDynamicSupport.bootstrap("handleCallSessionEvent", $$robo$$android_telecom_Connection_VideoProvider$handleCallSessionEvent(int ), 0, this, n);
        }

        public void changePeerDimensions(int n, int n2) {
            InvokeDynamicSupport.bootstrap("changePeerDimensions", $$robo$$android_telecom_Connection_VideoProvider$changePeerDimensions(int int ), 0, this, n, n2);
        }

        public void changeCallDataUsage(int n) {
            InvokeDynamicSupport.bootstrap("changeCallDataUsage", $$robo$$android_telecom_Connection_VideoProvider$changeCallDataUsage(int ), 0, this, n);
        }

        public void changeCameraCapabilities(CameraCapabilities cameraCapabilities) {
            InvokeDynamicSupport.bootstrap("changeCameraCapabilities", $$robo$$android_telecom_Connection_VideoProvider$changeCameraCapabilities(android.telecom.CameraCapabilities ), 0, this, cameraCapabilities);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VideoProvider)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        private final class VideoProviderBinder
        extends IVideoProvider.Stub
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ VideoProvider this$0;

            private void $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$__constructor__(VideoProvider videoProvider) {
            }

            private final void $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$setVideoCallback(IBinder videoCallbackBinder) {
                this.this$0.mMessageHandler.obtainMessage(1, videoCallbackBinder).sendToTarget();
            }

            private final void $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$setCamera(String cameraId) {
                this.this$0.mMessageHandler.obtainMessage(2, cameraId).sendToTarget();
            }

            private final void $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$setPreviewSurface(Surface surface) {
                this.this$0.mMessageHandler.obtainMessage(3, surface).sendToTarget();
            }

            private final void $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$setDisplaySurface(Surface surface) {
                this.this$0.mMessageHandler.obtainMessage(4, surface).sendToTarget();
            }

            private final void $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$setDeviceOrientation(int rotation) {
                this.this$0.mMessageHandler.obtainMessage(5, rotation).sendToTarget();
            }

            private final void $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$setZoom(float value) {
                this.this$0.mMessageHandler.obtainMessage(6, Float.valueOf(value)).sendToTarget();
            }

            private final void $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$sendSessionModifyRequest(VideoProfile requestProfile) {
                this.this$0.mMessageHandler.obtainMessage(7, requestProfile).sendToTarget();
            }

            private final void $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$sendSessionModifyResponse(VideoProfile responseProfile) {
                this.this$0.mMessageHandler.obtainMessage(8, responseProfile).sendToTarget();
            }

            private final void $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$requestCameraCapabilities() {
                this.this$0.mMessageHandler.obtainMessage(9).sendToTarget();
            }

            private final void $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$requestCallDataUsage() {
                this.this$0.mMessageHandler.obtainMessage(10).sendToTarget();
            }

            private final void $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$setPauseImage(String uri) {
                this.this$0.mMessageHandler.obtainMessage(11, uri).sendToTarget();
            }

            private /* synthetic */ void $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$__constructor__(VideoProvider x0, 1 x1) {
            }

            private void __constructor__(VideoProvider videoProvider) {
                this.$$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$__constructor__(videoProvider);
            }

            private VideoProviderBinder(VideoProvider videoProvider) {
                this.this$0 = videoProvider;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$__constructor__(android.telecom.Connection$VideoProvider ), 0, this, videoProvider);
            }

            @Override
            public void setVideoCallback(IBinder iBinder) {
                InvokeDynamicSupport.bootstrap("setVideoCallback", $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$setVideoCallback(android.os.IBinder ), 0, this, iBinder);
            }

            @Override
            public void setCamera(String string2) {
                InvokeDynamicSupport.bootstrap("setCamera", $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$setCamera(java.lang.String ), 0, this, string2);
            }

            @Override
            public void setPreviewSurface(Surface surface) {
                InvokeDynamicSupport.bootstrap("setPreviewSurface", $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$setPreviewSurface(android.view.Surface ), 0, this, surface);
            }

            @Override
            public void setDisplaySurface(Surface surface) {
                InvokeDynamicSupport.bootstrap("setDisplaySurface", $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$setDisplaySurface(android.view.Surface ), 0, this, surface);
            }

            @Override
            public void setDeviceOrientation(int n) {
                InvokeDynamicSupport.bootstrap("setDeviceOrientation", $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$setDeviceOrientation(int ), 0, this, n);
            }

            @Override
            public void setZoom(float f) {
                InvokeDynamicSupport.bootstrap("setZoom", $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$setZoom(float ), 0, this, f);
            }

            @Override
            public void sendSessionModifyRequest(VideoProfile videoProfile) {
                InvokeDynamicSupport.bootstrap("sendSessionModifyRequest", $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$sendSessionModifyRequest(android.telecom.VideoProfile ), 0, this, videoProfile);
            }

            @Override
            public void sendSessionModifyResponse(VideoProfile videoProfile) {
                InvokeDynamicSupport.bootstrap("sendSessionModifyResponse", $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$sendSessionModifyResponse(android.telecom.VideoProfile ), 0, this, videoProfile);
            }

            @Override
            public void requestCameraCapabilities() {
                InvokeDynamicSupport.bootstrap("requestCameraCapabilities", $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$requestCameraCapabilities(), 0, this);
            }

            @Override
            public void requestCallDataUsage() {
                InvokeDynamicSupport.bootstrap("requestCallDataUsage", $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$requestCallDataUsage(), 0, this);
            }

            @Override
            public void setPauseImage(String string2) {
                InvokeDynamicSupport.bootstrap("setPauseImage", $$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$setPauseImage(java.lang.String ), 0, this, string2);
            }

            private /* synthetic */ void __constructor__(VideoProvider videoProvider, 1 var2_2) {
                this.$$robo$$android_telecom_Connection_VideoProvider_VideoProviderBinder$__constructor__(videoProvider, var2_2);
            }

            public /* synthetic */ VideoProviderBinder() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VideoProviderBinder)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        private final class VideoProviderHandler
        extends Handler
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ VideoProvider this$0;

            private void $$robo$$android_telecom_Connection_VideoProvider_VideoProviderHandler$__constructor__(VideoProvider videoProvider) {
            }

            private final void $$robo$$android_telecom_Connection_VideoProvider_VideoProviderHandler$handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        this.this$0.mVideoCallback = IVideoCallback.Stub.asInterface((IBinder)msg.obj);
                        break;
                    }
                    case 2: {
                        this.this$0.onSetCamera((String)msg.obj);
                        break;
                    }
                    case 3: {
                        this.this$0.onSetPreviewSurface((Surface)msg.obj);
                        break;
                    }
                    case 4: {
                        this.this$0.onSetDisplaySurface((Surface)msg.obj);
                        break;
                    }
                    case 5: {
                        this.this$0.onSetDeviceOrientation(msg.arg1);
                        break;
                    }
                    case 6: {
                        this.this$0.onSetZoom(((Float)msg.obj).floatValue());
                        break;
                    }
                    case 7: {
                        this.this$0.onSendSessionModifyRequest((VideoProfile)msg.obj);
                        break;
                    }
                    case 8: {
                        this.this$0.onSendSessionModifyResponse((VideoProfile)msg.obj);
                        break;
                    }
                    case 9: {
                        this.this$0.onRequestCameraCapabilities();
                        break;
                    }
                    case 10: {
                        this.this$0.onRequestCallDataUsage();
                        break;
                    }
                    case 11: {
                        this.this$0.onSetPauseImage((String)msg.obj);
                        break;
                    }
                }
            }

            private /* synthetic */ void $$robo$$android_telecom_Connection_VideoProvider_VideoProviderHandler$__constructor__(VideoProvider x0, 1 x1) {
            }

            private void __constructor__(VideoProvider videoProvider) {
                this.$$robo$$android_telecom_Connection_VideoProvider_VideoProviderHandler$__constructor__(videoProvider);
            }

            private VideoProviderHandler(VideoProvider videoProvider) {
                this.this$0 = videoProvider;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Connection_VideoProvider_VideoProviderHandler$__constructor__(android.telecom.Connection$VideoProvider ), 0, this, videoProvider);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_telecom_Connection_VideoProvider_VideoProviderHandler$handleMessage(android.os.Message ), 0, this, message);
            }

            private /* synthetic */ void __constructor__(VideoProvider videoProvider, 1 var2_2) {
                this.$$robo$$android_telecom_Connection_VideoProvider_VideoProviderHandler$__constructor__(videoProvider, var2_2);
            }

            public /* synthetic */ VideoProviderHandler() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VideoProviderHandler)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static abstract class Listener
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_telecom_Connection_Listener$__constructor__() {
        }

        private final void $$robo$$android_telecom_Connection_Listener$onStateChanged(Connection c, int state) {
        }

        private final void $$robo$$android_telecom_Connection_Listener$onAddressChanged(Connection c, Uri newAddress, int presentation) {
        }

        private final void $$robo$$android_telecom_Connection_Listener$onCallerDisplayNameChanged(Connection c, String callerDisplayName, int presentation) {
        }

        private final void $$robo$$android_telecom_Connection_Listener$onVideoStateChanged(Connection c, int videoState) {
        }

        private final void $$robo$$android_telecom_Connection_Listener$onDisconnected(Connection c, DisconnectCause disconnectCause) {
        }

        private final void $$robo$$android_telecom_Connection_Listener$onPostDialWait(Connection c, String remaining) {
        }

        private final void $$robo$$android_telecom_Connection_Listener$onRingbackRequested(Connection c, boolean ringback) {
        }

        private final void $$robo$$android_telecom_Connection_Listener$onDestroyed(Connection c) {
        }

        private final void $$robo$$android_telecom_Connection_Listener$onCallCapabilitiesChanged(Connection c, int callCapabilities) {
        }

        private final void $$robo$$android_telecom_Connection_Listener$onVideoProviderChanged(Connection c, VideoProvider videoProvider) {
        }

        private final void $$robo$$android_telecom_Connection_Listener$onAudioModeIsVoipChanged(Connection c, boolean isVoip) {
        }

        private final void $$robo$$android_telecom_Connection_Listener$onStatusHintsChanged(Connection c, StatusHints statusHints) {
        }

        private final void $$robo$$android_telecom_Connection_Listener$onConferenceableConnectionsChanged(Connection c, List<Connection> conferenceableConnections) {
        }

        private final void $$robo$$android_telecom_Connection_Listener$onConferenceChanged(Connection c, Conference conference) {
        }

        private void __constructor__() {
            this.$$robo$$android_telecom_Connection_Listener$__constructor__();
        }

        public Listener() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Connection_Listener$__constructor__(), 0, this);
        }

        public void onStateChanged(Connection connection, int n) {
            InvokeDynamicSupport.bootstrap("onStateChanged", $$robo$$android_telecom_Connection_Listener$onStateChanged(android.telecom.Connection int ), 0, this, connection, n);
        }

        public void onAddressChanged(Connection connection, Uri uri, int n) {
            InvokeDynamicSupport.bootstrap("onAddressChanged", $$robo$$android_telecom_Connection_Listener$onAddressChanged(android.telecom.Connection android.net.Uri int ), 0, this, connection, uri, n);
        }

        public void onCallerDisplayNameChanged(Connection connection, String string2, int n) {
            InvokeDynamicSupport.bootstrap("onCallerDisplayNameChanged", $$robo$$android_telecom_Connection_Listener$onCallerDisplayNameChanged(android.telecom.Connection java.lang.String int ), 0, this, connection, string2, n);
        }

        public void onVideoStateChanged(Connection connection, int n) {
            InvokeDynamicSupport.bootstrap("onVideoStateChanged", $$robo$$android_telecom_Connection_Listener$onVideoStateChanged(android.telecom.Connection int ), 0, this, connection, n);
        }

        public void onDisconnected(Connection connection, DisconnectCause disconnectCause) {
            InvokeDynamicSupport.bootstrap("onDisconnected", $$robo$$android_telecom_Connection_Listener$onDisconnected(android.telecom.Connection android.telecom.DisconnectCause ), 0, this, connection, disconnectCause);
        }

        public void onPostDialWait(Connection connection, String string2) {
            InvokeDynamicSupport.bootstrap("onPostDialWait", $$robo$$android_telecom_Connection_Listener$onPostDialWait(android.telecom.Connection java.lang.String ), 0, this, connection, string2);
        }

        public void onRingbackRequested(Connection connection, boolean bl) {
            InvokeDynamicSupport.bootstrap("onRingbackRequested", $$robo$$android_telecom_Connection_Listener$onRingbackRequested(android.telecom.Connection boolean ), 0, this, connection, bl);
        }

        public void onDestroyed(Connection connection) {
            InvokeDynamicSupport.bootstrap("onDestroyed", $$robo$$android_telecom_Connection_Listener$onDestroyed(android.telecom.Connection ), 0, this, connection);
        }

        public void onCallCapabilitiesChanged(Connection connection, int n) {
            InvokeDynamicSupport.bootstrap("onCallCapabilitiesChanged", $$robo$$android_telecom_Connection_Listener$onCallCapabilitiesChanged(android.telecom.Connection int ), 0, this, connection, n);
        }

        public void onVideoProviderChanged(Connection connection, VideoProvider videoProvider) {
            InvokeDynamicSupport.bootstrap("onVideoProviderChanged", $$robo$$android_telecom_Connection_Listener$onVideoProviderChanged(android.telecom.Connection android.telecom.Connection$VideoProvider ), 0, this, connection, videoProvider);
        }

        public void onAudioModeIsVoipChanged(Connection connection, boolean bl) {
            InvokeDynamicSupport.bootstrap("onAudioModeIsVoipChanged", $$robo$$android_telecom_Connection_Listener$onAudioModeIsVoipChanged(android.telecom.Connection boolean ), 0, this, connection, bl);
        }

        public void onStatusHintsChanged(Connection connection, StatusHints statusHints) {
            InvokeDynamicSupport.bootstrap("onStatusHintsChanged", $$robo$$android_telecom_Connection_Listener$onStatusHintsChanged(android.telecom.Connection android.telecom.StatusHints ), 0, this, connection, statusHints);
        }

        public void onConferenceableConnectionsChanged(Connection connection, List<Connection> list) {
            InvokeDynamicSupport.bootstrap("onConferenceableConnectionsChanged", $$robo$$android_telecom_Connection_Listener$onConferenceableConnectionsChanged(android.telecom.Connection java.util.List<android.telecom.Connection> ), 0, this, connection, list);
        }

        public void onConferenceChanged(Connection connection, Conference conference) {
            InvokeDynamicSupport.bootstrap("onConferenceChanged", $$robo$$android_telecom_Connection_Listener$onConferenceChanged(android.telecom.Connection android.telecom.Conference ), 0, this, connection, conference);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Listener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

