/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.app.Service;
import android.content.ComponentName;
import android.content.Intent;
import android.net.Uri;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.telecom.AudioState;
import android.telecom.Conference;
import android.telecom.Connection;
import android.telecom.ConnectionRequest;
import android.telecom.ConnectionServiceAdapter;
import android.telecom.DisconnectCause;
import android.telecom.Log;
import android.telecom.ParcelableConference;
import android.telecom.ParcelableConnection;
import android.telecom.PhoneAccountHandle;
import android.telecom.PhoneCapabilities;
import android.telecom.RemoteConference;
import android.telecom.RemoteConnection;
import android.telecom.RemoteConnectionManager;
import android.telecom.StatusHints;
import com.android.internal.os.SomeArgs;
import com.android.internal.telecom.IConnectionService;
import com.android.internal.telecom.IConnectionServiceAdapter;
import com.android.internal.telecom.RemoteServiceCallback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class ConnectionService
extends Service
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String SERVICE_INTERFACE = "android.telecom.ConnectionService";
    private static boolean PII_DEBUG;
    private static int MSG_ADD_CONNECTION_SERVICE_ADAPTER = 1;
    private static int MSG_CREATE_CONNECTION = 2;
    private static int MSG_ABORT = 3;
    private static int MSG_ANSWER = 4;
    private static int MSG_REJECT = 5;
    private static int MSG_DISCONNECT = 6;
    private static int MSG_HOLD = 7;
    private static int MSG_UNHOLD = 8;
    private static int MSG_ON_AUDIO_STATE_CHANGED = 9;
    private static int MSG_PLAY_DTMF_TONE = 10;
    private static int MSG_STOP_DTMF_TONE = 11;
    private static int MSG_CONFERENCE = 12;
    private static int MSG_SPLIT_FROM_CONFERENCE = 13;
    private static int MSG_ON_POST_DIAL_CONTINUE = 14;
    private static int MSG_REMOVE_CONNECTION_SERVICE_ADAPTER = 16;
    private static int MSG_ANSWER_VIDEO = 17;
    private static int MSG_MERGE_CONFERENCE = 18;
    private static int MSG_SWAP_CONFERENCE = 19;
    private static Connection sNullConnection;
    private Map<String, Connection> mConnectionById;
    private Map<Connection, String> mIdByConnection;
    private Map<String, Conference> mConferenceById;
    private Map<Conference, String> mIdByConference;
    private RemoteConnectionManager mRemoteConnectionManager;
    private List<Runnable> mPreInitializationConnectionRequests;
    private ConnectionServiceAdapter mAdapter;
    private boolean mAreAccountsInitialized;
    private Conference sNullConference;
    private IBinder mBinder;
    private Handler mHandler;
    private Conference.Listener mConferenceListener;
    private Connection.Listener mConnectionListener;

    private void $$robo$$android_telecom_ConnectionService$__constructor__() {
        this.mConnectionById = new ConcurrentHashMap<String, Connection>();
        this.mIdByConnection = new ConcurrentHashMap<Connection, String>();
        this.mConferenceById = new ConcurrentHashMap<String, Conference>();
        this.mIdByConference = new ConcurrentHashMap<Conference, String>();
        this.mRemoteConnectionManager = new RemoteConnectionManager(this);
        this.mPreInitializationConnectionRequests = new ArrayList<Runnable>();
        this.mAdapter = new ConnectionServiceAdapter();
        this.mAreAccountsInitialized = false;
        this.mBinder = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ConnectionService this$0;

            private void $$robo$$android_telecom_ConnectionService_1$__constructor__(ConnectionService connectionService) {
            }

            private final void $$robo$$android_telecom_ConnectionService_1$addConnectionServiceAdapter(IConnectionServiceAdapter adapter) {
                this.this$0.mHandler.obtainMessage(1, adapter).sendToTarget();
            }

            private final void $$robo$$android_telecom_ConnectionService_1$removeConnectionServiceAdapter(IConnectionServiceAdapter adapter) {
                this.this$0.mHandler.obtainMessage(16, adapter).sendToTarget();
            }

            private final void $$robo$$android_telecom_ConnectionService_1$createConnection(PhoneAccountHandle connectionManagerPhoneAccount, String id2, ConnectionRequest request, boolean isIncoming, boolean isUnknown) {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = connectionManagerPhoneAccount;
                args.arg2 = id2;
                args.arg3 = request;
                args.argi1 = isIncoming ? 1 : 0;
                args.argi2 = isUnknown ? 1 : 0;
                this.this$0.mHandler.obtainMessage(2, args).sendToTarget();
            }

            private final void $$robo$$android_telecom_ConnectionService_1$abort(String callId) {
                this.this$0.mHandler.obtainMessage(3, callId).sendToTarget();
            }

            private final void $$robo$$android_telecom_ConnectionService_1$answerVideo(String callId, int videoState) {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = callId;
                args.argi1 = videoState;
                this.this$0.mHandler.obtainMessage(17, args).sendToTarget();
            }

            private final void $$robo$$android_telecom_ConnectionService_1$answer(String callId) {
                this.this$0.mHandler.obtainMessage(4, callId).sendToTarget();
            }

            private final void $$robo$$android_telecom_ConnectionService_1$reject(String callId) {
                this.this$0.mHandler.obtainMessage(5, callId).sendToTarget();
            }

            private final void $$robo$$android_telecom_ConnectionService_1$disconnect(String callId) {
                this.this$0.mHandler.obtainMessage(6, callId).sendToTarget();
            }

            private final void $$robo$$android_telecom_ConnectionService_1$hold(String callId) {
                this.this$0.mHandler.obtainMessage(7, callId).sendToTarget();
            }

            private final void $$robo$$android_telecom_ConnectionService_1$unhold(String callId) {
                this.this$0.mHandler.obtainMessage(8, callId).sendToTarget();
            }

            private final void $$robo$$android_telecom_ConnectionService_1$onAudioStateChanged(String callId, AudioState audioState) {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = callId;
                args.arg2 = audioState;
                this.this$0.mHandler.obtainMessage(9, args).sendToTarget();
            }

            private final void $$robo$$android_telecom_ConnectionService_1$playDtmfTone(String callId, char digit) {
                this.this$0.mHandler.obtainMessage(10, digit, 0, callId).sendToTarget();
            }

            private final void $$robo$$android_telecom_ConnectionService_1$stopDtmfTone(String callId) {
                this.this$0.mHandler.obtainMessage(11, callId).sendToTarget();
            }

            private final void $$robo$$android_telecom_ConnectionService_1$conference(String callId1, String callId2) {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = callId1;
                args.arg2 = callId2;
                this.this$0.mHandler.obtainMessage(12, args).sendToTarget();
            }

            private final void $$robo$$android_telecom_ConnectionService_1$splitFromConference(String callId) {
                this.this$0.mHandler.obtainMessage(13, callId).sendToTarget();
            }

            private final void $$robo$$android_telecom_ConnectionService_1$mergeConference(String callId) {
                this.this$0.mHandler.obtainMessage(18, callId).sendToTarget();
            }

            private final void $$robo$$android_telecom_ConnectionService_1$swapConference(String callId) {
                this.this$0.mHandler.obtainMessage(19, callId).sendToTarget();
            }

            private final void $$robo$$android_telecom_ConnectionService_1$onPostDialContinue(String callId, boolean proceed) {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = callId;
                args.argi1 = proceed ? 1 : 0;
                this.this$0.mHandler.obtainMessage(14, args).sendToTarget();
            }

            private void __constructor__(ConnectionService connectionService) {
                this.$$robo$$android_telecom_ConnectionService_1$__constructor__(connectionService);
            }
            {
                this.this$0 = connectionService;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_ConnectionService_1$__constructor__(android.telecom.ConnectionService ), 0, this, connectionService);
            }

            @Override
            public void addConnectionServiceAdapter(IConnectionServiceAdapter iConnectionServiceAdapter) {
                InvokeDynamicSupport.bootstrap("addConnectionServiceAdapter", $$robo$$android_telecom_ConnectionService_1$addConnectionServiceAdapter(com.android.internal.telecom.IConnectionServiceAdapter ), 0, this, iConnectionServiceAdapter);
            }

            @Override
            public void removeConnectionServiceAdapter(IConnectionServiceAdapter iConnectionServiceAdapter) {
                InvokeDynamicSupport.bootstrap("removeConnectionServiceAdapter", $$robo$$android_telecom_ConnectionService_1$removeConnectionServiceAdapter(com.android.internal.telecom.IConnectionServiceAdapter ), 0, this, iConnectionServiceAdapter);
            }

            @Override
            public void createConnection(PhoneAccountHandle phoneAccountHandle, String string2, ConnectionRequest connectionRequest, boolean bl, boolean bl2) {
                InvokeDynamicSupport.bootstrap("createConnection", $$robo$$android_telecom_ConnectionService_1$createConnection(android.telecom.PhoneAccountHandle java.lang.String android.telecom.ConnectionRequest boolean boolean ), 0, this, phoneAccountHandle, string2, connectionRequest, bl, bl2);
            }

            @Override
            public void abort(String string2) {
                InvokeDynamicSupport.bootstrap("abort", $$robo$$android_telecom_ConnectionService_1$abort(java.lang.String ), 0, this, string2);
            }

            @Override
            public void answerVideo(String string2, int n) {
                InvokeDynamicSupport.bootstrap("answerVideo", $$robo$$android_telecom_ConnectionService_1$answerVideo(java.lang.String int ), 0, this, string2, n);
            }

            @Override
            public void answer(String string2) {
                InvokeDynamicSupport.bootstrap("answer", $$robo$$android_telecom_ConnectionService_1$answer(java.lang.String ), 0, this, string2);
            }

            @Override
            public void reject(String string2) {
                InvokeDynamicSupport.bootstrap("reject", $$robo$$android_telecom_ConnectionService_1$reject(java.lang.String ), 0, this, string2);
            }

            @Override
            public void disconnect(String string2) {
                InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_telecom_ConnectionService_1$disconnect(java.lang.String ), 0, this, string2);
            }

            @Override
            public void hold(String string2) {
                InvokeDynamicSupport.bootstrap("hold", $$robo$$android_telecom_ConnectionService_1$hold(java.lang.String ), 0, this, string2);
            }

            @Override
            public void unhold(String string2) {
                InvokeDynamicSupport.bootstrap("unhold", $$robo$$android_telecom_ConnectionService_1$unhold(java.lang.String ), 0, this, string2);
            }

            @Override
            public void onAudioStateChanged(String string2, AudioState audioState) {
                InvokeDynamicSupport.bootstrap("onAudioStateChanged", $$robo$$android_telecom_ConnectionService_1$onAudioStateChanged(java.lang.String android.telecom.AudioState ), 0, this, string2, audioState);
            }

            @Override
            public void playDtmfTone(String string2, char c) {
                InvokeDynamicSupport.bootstrap("playDtmfTone", $$robo$$android_telecom_ConnectionService_1$playDtmfTone(java.lang.String char ), 0, this, string2, c);
            }

            @Override
            public void stopDtmfTone(String string2) {
                InvokeDynamicSupport.bootstrap("stopDtmfTone", $$robo$$android_telecom_ConnectionService_1$stopDtmfTone(java.lang.String ), 0, this, string2);
            }

            @Override
            public void conference(String string2, String string3) {
                InvokeDynamicSupport.bootstrap("conference", $$robo$$android_telecom_ConnectionService_1$conference(java.lang.String java.lang.String ), 0, this, string2, string3);
            }

            @Override
            public void splitFromConference(String string2) {
                InvokeDynamicSupport.bootstrap("splitFromConference", $$robo$$android_telecom_ConnectionService_1$splitFromConference(java.lang.String ), 0, this, string2);
            }

            @Override
            public void mergeConference(String string2) {
                InvokeDynamicSupport.bootstrap("mergeConference", $$robo$$android_telecom_ConnectionService_1$mergeConference(java.lang.String ), 0, this, string2);
            }

            @Override
            public void swapConference(String string2) {
                InvokeDynamicSupport.bootstrap("swapConference", $$robo$$android_telecom_ConnectionService_1$swapConference(java.lang.String ), 0, this, string2);
            }

            @Override
            public void onPostDialContinue(String string2, boolean bl) {
                InvokeDynamicSupport.bootstrap("onPostDialContinue", $$robo$$android_telecom_ConnectionService_1$onPostDialContinue(java.lang.String boolean ), 0, this, string2, bl);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mHandler = new ShadowedObject(this, Looper.getMainLooper()){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ConnectionService this$0;

            private void $$robo$$android_telecom_ConnectionService_2$__constructor__(ConnectionService connectionService, Looper x0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_telecom_ConnectionService_2$handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        this.this$0.mAdapter.addAdapter((IConnectionServiceAdapter)msg.obj);
                        this.this$0.onAdapterAttached();
                        break;
                    }
                    case 16: {
                        this.this$0.mAdapter.removeAdapter((IConnectionServiceAdapter)msg.obj);
                        break;
                    }
                    case 2: {
                        SomeArgs args = (SomeArgs)msg.obj;
                        try {
                            boolean isUnknown;
                            PhoneAccountHandle connectionManagerPhoneAccount = (PhoneAccountHandle)args.arg1;
                            String id2 = (String)args.arg2;
                            ConnectionRequest request = (ConnectionRequest)args.arg3;
                            boolean isIncoming = args.argi1 == 1;
                            boolean bl = isUnknown = args.argi2 == 1;
                            if (!this.this$0.mAreAccountsInitialized) {
                                Log.d(this, "Enqueueing pre-init request %s", id2);
                                this.this$0.mPreInitializationConnectionRequests.add(new Runnable(this, connectionManagerPhoneAccount, id2, request, isIncoming, isUnknown){
                                    public transient /* synthetic */ Object __robo_data__;
                                    /* synthetic */ PhoneAccountHandle val$connectionManagerPhoneAccount;
                                    /* synthetic */ String val$id;
                                    /* synthetic */ ConnectionRequest val$request;
                                    /* synthetic */ boolean val$isIncoming;
                                    /* synthetic */ boolean val$isUnknown;
                                    /* synthetic */ 2 this$1;

                                    private void $$robo$$android_telecom_ConnectionService_2_1$__constructor__(2 var1_1, PhoneAccountHandle phoneAccountHandle, String string2, ConnectionRequest connectionRequest, boolean bl, boolean bl2) {
                                    }

                                    private final void $$robo$$android_telecom_ConnectionService_2_1$run() {
                                        this.this$1.this$0.createConnection(this.val$connectionManagerPhoneAccount, this.val$id, this.val$request, this.val$isIncoming, this.val$isUnknown);
                                    }

                                    private void __constructor__(2 var1_1, PhoneAccountHandle phoneAccountHandle, String string2, ConnectionRequest connectionRequest, boolean bl, boolean bl2) {
                                        this.$$robo$$android_telecom_ConnectionService_2_1$__constructor__(var1_1, phoneAccountHandle, string2, connectionRequest, bl, bl2);
                                    }
                                    {
                                        this.this$1 = var1_1;
                                        this.val$connectionManagerPhoneAccount = phoneAccountHandle;
                                        this.val$id = string2;
                                        this.val$request = connectionRequest;
                                        this.val$isIncoming = bl;
                                        this.val$isUnknown = bl2;
                                        this.$$robo$init();
                                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_ConnectionService_2_1$__constructor__(android.telecom.ConnectionService$2 android.telecom.PhoneAccountHandle java.lang.String android.telecom.ConnectionRequest boolean boolean ), 0, this, var1_1, phoneAccountHandle, string2, connectionRequest, bl, bl2);
                                    }

                                    @Override
                                    public void run() {
                                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_ConnectionService_2_1$run(), 0, this);
                                    }
                                    {
                                        this.$$robo$init();
                                    }

                                    protected /* synthetic */ void $$robo$init() {
                                        if (this.__robo_data__ == null) {
                                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                        }
                                    }

                                    public /* synthetic */ Object $$robo$getData() {
                                        return this.__robo_data__;
                                    }
                                });
                                break;
                            }
                            this.this$0.createConnection(connectionManagerPhoneAccount, id2, request, isIncoming, isUnknown);
                            break;
                        }
                        finally {
                            args.recycle();
                        }
                    }
                    case 3: {
                        this.this$0.abort((String)msg.obj);
                        break;
                    }
                    case 4: {
                        this.this$0.answer((String)msg.obj);
                        break;
                    }
                    case 17: {
                        SomeArgs args = (SomeArgs)msg.obj;
                        try {
                            String callId = (String)args.arg1;
                            int videoState = args.argi1;
                            this.this$0.answerVideo(callId, videoState);
                            break;
                        }
                        finally {
                            args.recycle();
                        }
                    }
                    case 5: {
                        this.this$0.reject((String)msg.obj);
                        break;
                    }
                    case 6: {
                        this.this$0.disconnect((String)msg.obj);
                        break;
                    }
                    case 7: {
                        this.this$0.hold((String)msg.obj);
                        break;
                    }
                    case 8: {
                        this.this$0.unhold((String)msg.obj);
                        break;
                    }
                    case 9: {
                        SomeArgs args = (SomeArgs)msg.obj;
                        try {
                            String callId = (String)args.arg1;
                            AudioState audioState = (AudioState)args.arg2;
                            this.this$0.onAudioStateChanged(callId, audioState);
                            break;
                        }
                        finally {
                            args.recycle();
                        }
                    }
                    case 10: {
                        this.this$0.playDtmfTone((String)msg.obj, (char)msg.arg1);
                        break;
                    }
                    case 11: {
                        this.this$0.stopDtmfTone((String)msg.obj);
                        break;
                    }
                    case 12: {
                        SomeArgs args = (SomeArgs)msg.obj;
                        try {
                            String callId1 = (String)args.arg1;
                            String callId2 = (String)args.arg2;
                            this.this$0.conference(callId1, callId2);
                            break;
                        }
                        finally {
                            args.recycle();
                        }
                    }
                    case 13: {
                        this.this$0.splitFromConference((String)msg.obj);
                        break;
                    }
                    case 18: {
                        this.this$0.mergeConference((String)msg.obj);
                        break;
                    }
                    case 19: {
                        this.this$0.swapConference((String)msg.obj);
                        break;
                    }
                    case 14: {
                        SomeArgs args = (SomeArgs)msg.obj;
                        try {
                            String callId = (String)args.arg1;
                            boolean proceed = args.argi1 == 1;
                            this.this$0.onPostDialContinue(callId, proceed);
                            break;
                        }
                        finally {
                            args.recycle();
                        }
                    }
                }
            }

            private void __constructor__(ConnectionService connectionService, Looper looper) {
                this.$$robo$$android_telecom_ConnectionService_2$__constructor__(connectionService, looper);
            }
            {
                this.this$0 = connectionService;
                super(looper);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_ConnectionService_2$__constructor__(android.telecom.ConnectionService android.os.Looper ), 0, this, connectionService, looper);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_telecom_ConnectionService_2$handleMessage(android.os.Message ), 0, this, message);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mConferenceListener = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ConnectionService this$0;

            private void $$robo$$android_telecom_ConnectionService_3$__constructor__(ConnectionService connectionService) {
            }

            private final void $$robo$$android_telecom_ConnectionService_3$onStateChanged(Conference conference, int oldState, int newState) {
                String id2 = (String)this.this$0.mIdByConference.get(conference);
                switch (newState) {
                    case 4: {
                        this.this$0.mAdapter.setActive(id2);
                        break;
                    }
                    case 5: {
                        this.this$0.mAdapter.setOnHold(id2);
                        break;
                    }
                }
            }

            private final void $$robo$$android_telecom_ConnectionService_3$onDisconnected(Conference conference, DisconnectCause disconnectCause) {
                String id2 = (String)this.this$0.mIdByConference.get(conference);
                this.this$0.mAdapter.setDisconnected(id2, disconnectCause);
            }

            private final void $$robo$$android_telecom_ConnectionService_3$onConnectionAdded(Conference conference, Connection connection) {
            }

            private final void $$robo$$android_telecom_ConnectionService_3$onConnectionRemoved(Conference conference, Connection connection) {
            }

            private final void $$robo$$android_telecom_ConnectionService_3$onConferenceableConnectionsChanged(Conference conference, List<Connection> conferenceableConnections) {
                this.this$0.mAdapter.setConferenceableConnections((String)this.this$0.mIdByConference.get(conference), this.this$0.createConnectionIdList(conferenceableConnections));
            }

            private final void $$robo$$android_telecom_ConnectionService_3$onDestroyed(Conference conference) {
                this.this$0.removeConference(conference);
            }

            private final void $$robo$$android_telecom_ConnectionService_3$onCapabilitiesChanged(Conference conference, int capabilities) {
                String id2 = (String)this.this$0.mIdByConference.get(conference);
                Log.d(this, "call capabilities: conference: %s", PhoneCapabilities.toString(capabilities));
                this.this$0.mAdapter.setCallCapabilities(id2, capabilities);
            }

            private void __constructor__(ConnectionService connectionService) {
                this.$$robo$$android_telecom_ConnectionService_3$__constructor__(connectionService);
            }
            {
                this.this$0 = connectionService;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_ConnectionService_3$__constructor__(android.telecom.ConnectionService ), 0, this, connectionService);
            }

            @Override
            public void onStateChanged(Conference conference, int n, int n2) {
                InvokeDynamicSupport.bootstrap("onStateChanged", $$robo$$android_telecom_ConnectionService_3$onStateChanged(android.telecom.Conference int int ), 0, this, conference, n, n2);
            }

            @Override
            public void onDisconnected(Conference conference, DisconnectCause disconnectCause) {
                InvokeDynamicSupport.bootstrap("onDisconnected", $$robo$$android_telecom_ConnectionService_3$onDisconnected(android.telecom.Conference android.telecom.DisconnectCause ), 0, this, conference, disconnectCause);
            }

            @Override
            public void onConnectionAdded(Conference conference, Connection connection) {
                InvokeDynamicSupport.bootstrap("onConnectionAdded", $$robo$$android_telecom_ConnectionService_3$onConnectionAdded(android.telecom.Conference android.telecom.Connection ), 0, this, conference, connection);
            }

            @Override
            public void onConnectionRemoved(Conference conference, Connection connection) {
                InvokeDynamicSupport.bootstrap("onConnectionRemoved", $$robo$$android_telecom_ConnectionService_3$onConnectionRemoved(android.telecom.Conference android.telecom.Connection ), 0, this, conference, connection);
            }

            @Override
            public void onConferenceableConnectionsChanged(Conference conference, List<Connection> list) {
                InvokeDynamicSupport.bootstrap("onConferenceableConnectionsChanged", $$robo$$android_telecom_ConnectionService_3$onConferenceableConnectionsChanged(android.telecom.Conference java.util.List<android.telecom.Connection> ), 0, this, conference, list);
            }

            @Override
            public void onDestroyed(Conference conference) {
                InvokeDynamicSupport.bootstrap("onDestroyed", $$robo$$android_telecom_ConnectionService_3$onDestroyed(android.telecom.Conference ), 0, this, conference);
            }

            @Override
            public void onCapabilitiesChanged(Conference conference, int n) {
                InvokeDynamicSupport.bootstrap("onCapabilitiesChanged", $$robo$$android_telecom_ConnectionService_3$onCapabilitiesChanged(android.telecom.Conference int ), 0, this, conference, n);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mConnectionListener = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ConnectionService this$0;

            private void $$robo$$android_telecom_ConnectionService_4$__constructor__(ConnectionService connectionService) {
            }

            private final void $$robo$$android_telecom_ConnectionService_4$onStateChanged(Connection c, int state) {
                String id2 = (String)this.this$0.mIdByConnection.get(c);
                Log.d(this, "Adapter set state %s %s", id2, Connection.stateToString(state));
                switch (state) {
                    case 4: {
                        this.this$0.mAdapter.setActive(id2);
                        break;
                    }
                    case 3: {
                        this.this$0.mAdapter.setDialing(id2);
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 5: {
                        this.this$0.mAdapter.setOnHold(id2);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        this.this$0.mAdapter.setRinging(id2);
                    }
                }
            }

            private final void $$robo$$android_telecom_ConnectionService_4$onDisconnected(Connection c, DisconnectCause disconnectCause) {
                String id2 = (String)this.this$0.mIdByConnection.get(c);
                Log.d(this, "Adapter set disconnected %s", disconnectCause);
                this.this$0.mAdapter.setDisconnected(id2, disconnectCause);
            }

            private final void $$robo$$android_telecom_ConnectionService_4$onVideoStateChanged(Connection c, int videoState) {
                String id2 = (String)this.this$0.mIdByConnection.get(c);
                Log.d(this, "Adapter set video state %d", videoState);
                this.this$0.mAdapter.setVideoState(id2, videoState);
            }

            private final void $$robo$$android_telecom_ConnectionService_4$onAddressChanged(Connection c, Uri address, int presentation) {
                String id2 = (String)this.this$0.mIdByConnection.get(c);
                this.this$0.mAdapter.setAddress(id2, address, presentation);
            }

            private final void $$robo$$android_telecom_ConnectionService_4$onCallerDisplayNameChanged(Connection c, String callerDisplayName, int presentation) {
                String id2 = (String)this.this$0.mIdByConnection.get(c);
                this.this$0.mAdapter.setCallerDisplayName(id2, callerDisplayName, presentation);
            }

            private final void $$robo$$android_telecom_ConnectionService_4$onDestroyed(Connection c) {
                this.this$0.removeConnection(c);
            }

            private final void $$robo$$android_telecom_ConnectionService_4$onPostDialWait(Connection c, String remaining) {
                String id2 = (String)this.this$0.mIdByConnection.get(c);
                Log.d(this, "Adapter onPostDialWait %s, %s", c, remaining);
                this.this$0.mAdapter.onPostDialWait(id2, remaining);
            }

            private final void $$robo$$android_telecom_ConnectionService_4$onRingbackRequested(Connection c, boolean ringback) {
                String id2 = (String)this.this$0.mIdByConnection.get(c);
                Log.d(this, "Adapter onRingback %b", ringback);
                this.this$0.mAdapter.setRingbackRequested(id2, ringback);
            }

            private final void $$robo$$android_telecom_ConnectionService_4$onCallCapabilitiesChanged(Connection c, int capabilities) {
                String id2 = (String)this.this$0.mIdByConnection.get(c);
                Log.d(this, "capabilities: parcelableconnection: %s", PhoneCapabilities.toString(capabilities));
                this.this$0.mAdapter.setCallCapabilities(id2, capabilities);
            }

            private final void $$robo$$android_telecom_ConnectionService_4$onVideoProviderChanged(Connection c, Connection.VideoProvider videoProvider) {
                String id2 = (String)this.this$0.mIdByConnection.get(c);
                this.this$0.mAdapter.setVideoProvider(id2, videoProvider);
            }

            private final void $$robo$$android_telecom_ConnectionService_4$onAudioModeIsVoipChanged(Connection c, boolean isVoip) {
                String id2 = (String)this.this$0.mIdByConnection.get(c);
                this.this$0.mAdapter.setIsVoipAudioMode(id2, isVoip);
            }

            private final void $$robo$$android_telecom_ConnectionService_4$onStatusHintsChanged(Connection c, StatusHints statusHints) {
                String id2 = (String)this.this$0.mIdByConnection.get(c);
                this.this$0.mAdapter.setStatusHints(id2, statusHints);
            }

            private final void $$robo$$android_telecom_ConnectionService_4$onConferenceableConnectionsChanged(Connection connection, List<Connection> conferenceableConnections) {
                this.this$0.mAdapter.setConferenceableConnections((String)this.this$0.mIdByConnection.get(connection), this.this$0.createConnectionIdList(conferenceableConnections));
            }

            private final void $$robo$$android_telecom_ConnectionService_4$onConferenceChanged(Connection connection, Conference conference) {
                String id2 = (String)this.this$0.mIdByConnection.get(connection);
                if (id2 != null) {
                    String conferenceId = null;
                    if (conference != null) {
                        conferenceId = (String)this.this$0.mIdByConference.get(conference);
                    }
                    this.this$0.mAdapter.setIsConferenced(id2, conferenceId);
                }
            }

            private void __constructor__(ConnectionService connectionService) {
                this.$$robo$$android_telecom_ConnectionService_4$__constructor__(connectionService);
            }
            {
                this.this$0 = connectionService;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_ConnectionService_4$__constructor__(android.telecom.ConnectionService ), 0, this, connectionService);
            }

            @Override
            public void onStateChanged(Connection connection, int n) {
                InvokeDynamicSupport.bootstrap("onStateChanged", $$robo$$android_telecom_ConnectionService_4$onStateChanged(android.telecom.Connection int ), 0, this, connection, n);
            }

            @Override
            public void onDisconnected(Connection connection, DisconnectCause disconnectCause) {
                InvokeDynamicSupport.bootstrap("onDisconnected", $$robo$$android_telecom_ConnectionService_4$onDisconnected(android.telecom.Connection android.telecom.DisconnectCause ), 0, this, connection, disconnectCause);
            }

            @Override
            public void onVideoStateChanged(Connection connection, int n) {
                InvokeDynamicSupport.bootstrap("onVideoStateChanged", $$robo$$android_telecom_ConnectionService_4$onVideoStateChanged(android.telecom.Connection int ), 0, this, connection, n);
            }

            @Override
            public void onAddressChanged(Connection connection, Uri uri, int n) {
                InvokeDynamicSupport.bootstrap("onAddressChanged", $$robo$$android_telecom_ConnectionService_4$onAddressChanged(android.telecom.Connection android.net.Uri int ), 0, this, connection, uri, n);
            }

            @Override
            public void onCallerDisplayNameChanged(Connection connection, String string2, int n) {
                InvokeDynamicSupport.bootstrap("onCallerDisplayNameChanged", $$robo$$android_telecom_ConnectionService_4$onCallerDisplayNameChanged(android.telecom.Connection java.lang.String int ), 0, this, connection, string2, n);
            }

            @Override
            public void onDestroyed(Connection connection) {
                InvokeDynamicSupport.bootstrap("onDestroyed", $$robo$$android_telecom_ConnectionService_4$onDestroyed(android.telecom.Connection ), 0, this, connection);
            }

            @Override
            public void onPostDialWait(Connection connection, String string2) {
                InvokeDynamicSupport.bootstrap("onPostDialWait", $$robo$$android_telecom_ConnectionService_4$onPostDialWait(android.telecom.Connection java.lang.String ), 0, this, connection, string2);
            }

            @Override
            public void onRingbackRequested(Connection connection, boolean bl) {
                InvokeDynamicSupport.bootstrap("onRingbackRequested", $$robo$$android_telecom_ConnectionService_4$onRingbackRequested(android.telecom.Connection boolean ), 0, this, connection, bl);
            }

            @Override
            public void onCallCapabilitiesChanged(Connection connection, int n) {
                InvokeDynamicSupport.bootstrap("onCallCapabilitiesChanged", $$robo$$android_telecom_ConnectionService_4$onCallCapabilitiesChanged(android.telecom.Connection int ), 0, this, connection, n);
            }

            @Override
            public void onVideoProviderChanged(Connection connection, Connection.VideoProvider videoProvider) {
                InvokeDynamicSupport.bootstrap("onVideoProviderChanged", $$robo$$android_telecom_ConnectionService_4$onVideoProviderChanged(android.telecom.Connection android.telecom.Connection$VideoProvider ), 0, this, connection, videoProvider);
            }

            @Override
            public void onAudioModeIsVoipChanged(Connection connection, boolean bl) {
                InvokeDynamicSupport.bootstrap("onAudioModeIsVoipChanged", $$robo$$android_telecom_ConnectionService_4$onAudioModeIsVoipChanged(android.telecom.Connection boolean ), 0, this, connection, bl);
            }

            @Override
            public void onStatusHintsChanged(Connection connection, StatusHints statusHints) {
                InvokeDynamicSupport.bootstrap("onStatusHintsChanged", $$robo$$android_telecom_ConnectionService_4$onStatusHintsChanged(android.telecom.Connection android.telecom.StatusHints ), 0, this, connection, statusHints);
            }

            @Override
            public void onConferenceableConnectionsChanged(Connection connection, List<Connection> list) {
                InvokeDynamicSupport.bootstrap("onConferenceableConnectionsChanged", $$robo$$android_telecom_ConnectionService_4$onConferenceableConnectionsChanged(android.telecom.Connection java.util.List<android.telecom.Connection> ), 0, this, connection, list);
            }

            @Override
            public void onConferenceChanged(Connection connection, Conference conference) {
                InvokeDynamicSupport.bootstrap("onConferenceChanged", $$robo$$android_telecom_ConnectionService_4$onConferenceChanged(android.telecom.Connection android.telecom.Conference ), 0, this, connection, conference);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final IBinder $$robo$$android_telecom_ConnectionService$onBind(Intent intent) {
        return this.mBinder;
    }

    private final boolean $$robo$$android_telecom_ConnectionService$onUnbind(Intent intent) {
        this.endAllConnections();
        return super.onUnbind(intent);
    }

    private final void $$robo$$android_telecom_ConnectionService$createConnection(PhoneAccountHandle callManagerAccount, String callId, ConnectionRequest request, boolean isIncoming, boolean isUnknown) {
        Uri address;
        Log.d(this, "createConnection, callManagerAccount: %s, callId: %s, request: %s, isIncoming: %b, isUnknown: %b", callManagerAccount, callId, request, isIncoming, isUnknown);
        Connection connection = isUnknown ? this.onCreateUnknownConnection(callManagerAccount, request) : (isIncoming ? this.onCreateIncomingConnection(callManagerAccount, request) : this.onCreateOutgoingConnection(callManagerAccount, request));
        Log.d(this, "createConnection, connection: %s", connection);
        if (connection == null) {
            connection = Connection.createFailedConnection(new DisconnectCause(1));
        }
        if (connection.getState() != 6) {
            this.addConnection(callId, connection);
        }
        String number = (address = connection.getAddress()) == null ? "null" : address.getSchemeSpecificPart();
        Log.v(this, "createConnection, number: %s, state: %s, capabilities: %s", Connection.toLogSafePhoneNumber(number), Connection.stateToString(connection.getState()), PhoneCapabilities.toString(connection.getCallCapabilities()));
        Log.d(this, "createConnection, calling handleCreateConnectionSuccessful %s", callId);
        this.mAdapter.handleCreateConnectionComplete(callId, request, new ParcelableConnection(request.getAccountHandle(), connection.getState(), connection.getCallCapabilities(), connection.getAddress(), connection.getAddressPresentation(), connection.getCallerDisplayName(), connection.getCallerDisplayNamePresentation(), connection.getVideoProvider() == null ? null : connection.getVideoProvider().getInterface(), connection.getVideoState(), connection.isRingbackRequested(), connection.getAudioModeIsVoip(), connection.getStatusHints(), connection.getDisconnectCause(), this.createConnectionIdList(connection.getConferenceableConnections())));
    }

    private final void $$robo$$android_telecom_ConnectionService$abort(String callId) {
        Log.d(this, "abort %s", callId);
        this.findConnectionForAction(callId, "abort").onAbort();
    }

    private final void $$robo$$android_telecom_ConnectionService$answerVideo(String callId, int videoState) {
        Log.d(this, "answerVideo %s", callId);
        this.findConnectionForAction(callId, "answer").onAnswer(videoState);
    }

    private final void $$robo$$android_telecom_ConnectionService$answer(String callId) {
        Log.d(this, "answer %s", callId);
        this.findConnectionForAction(callId, "answer").onAnswer();
    }

    private final void $$robo$$android_telecom_ConnectionService$reject(String callId) {
        Log.d(this, "reject %s", callId);
        this.findConnectionForAction(callId, "reject").onReject();
    }

    private final void $$robo$$android_telecom_ConnectionService$disconnect(String callId) {
        Log.d(this, "disconnect %s", callId);
        if (this.mConnectionById.containsKey(callId)) {
            this.findConnectionForAction(callId, "disconnect").onDisconnect();
        } else {
            this.findConferenceForAction(callId, "disconnect").onDisconnect();
        }
    }

    private final void $$robo$$android_telecom_ConnectionService$hold(String callId) {
        Log.d(this, "hold %s", callId);
        if (this.mConnectionById.containsKey(callId)) {
            this.findConnectionForAction(callId, "hold").onHold();
        } else {
            this.findConferenceForAction(callId, "hold").onHold();
        }
    }

    private final void $$robo$$android_telecom_ConnectionService$unhold(String callId) {
        Log.d(this, "unhold %s", callId);
        if (this.mConnectionById.containsKey(callId)) {
            this.findConnectionForAction(callId, "unhold").onUnhold();
        } else {
            this.findConferenceForAction(callId, "unhold").onUnhold();
        }
    }

    private final void $$robo$$android_telecom_ConnectionService$onAudioStateChanged(String callId, AudioState audioState) {
        Log.d(this, "onAudioStateChanged %s %s", callId, audioState);
        if (this.mConnectionById.containsKey(callId)) {
            this.findConnectionForAction(callId, "onAudioStateChanged").setAudioState(audioState);
        } else {
            this.findConferenceForAction(callId, "onAudioStateChanged").setAudioState(audioState);
        }
    }

    private final void $$robo$$android_telecom_ConnectionService$playDtmfTone(String callId, char digit) {
        Log.d(this, "playDtmfTone %s %c", callId, Character.valueOf(digit));
        if (this.mConnectionById.containsKey(callId)) {
            this.findConnectionForAction(callId, "playDtmfTone").onPlayDtmfTone(digit);
        } else {
            this.findConferenceForAction(callId, "playDtmfTone").onPlayDtmfTone(digit);
        }
    }

    private final void $$robo$$android_telecom_ConnectionService$stopDtmfTone(String callId) {
        Log.d(this, "stopDtmfTone %s", callId);
        if (this.mConnectionById.containsKey(callId)) {
            this.findConnectionForAction(callId, "stopDtmfTone").onStopDtmfTone();
        } else {
            this.findConferenceForAction(callId, "stopDtmfTone").onStopDtmfTone();
        }
    }

    private final void $$robo$$android_telecom_ConnectionService$conference(String callId1, String callId2) {
        Log.d(this, "conference %s, %s", callId1, callId2);
        Connection connection2 = this.findConnectionForAction(callId2, "conference");
        if (connection2 == ConnectionService.getNullConnection()) {
            Log.w(this, "Connection2 missing in conference request %s.", callId2);
            return;
        }
        Connection connection1 = this.findConnectionForAction(callId1, "conference");
        if (connection1 == ConnectionService.getNullConnection()) {
            Conference conference1 = this.findConferenceForAction(callId1, "addConnection");
            if (conference1 == this.getNullConference()) {
                Log.w(this, "Connection1 or Conference1 missing in conference request %s.", callId1);
            } else {
                conference1.onMerge(connection2);
            }
        } else {
            this.onConference(connection1, connection2);
        }
    }

    private final void $$robo$$android_telecom_ConnectionService$splitFromConference(String callId) {
        Log.d(this, "splitFromConference(%s)", callId);
        Connection connection = this.findConnectionForAction(callId, "splitFromConference");
        if (connection == ConnectionService.getNullConnection()) {
            Log.w(this, "Connection missing in conference request %s.", callId);
            return;
        }
        Conference conference = connection.getConference();
        if (conference != null) {
            conference.onSeparate(connection);
        }
    }

    private final void $$robo$$android_telecom_ConnectionService$mergeConference(String callId) {
        Log.d(this, "mergeConference(%s)", callId);
        Conference conference = this.findConferenceForAction(callId, "mergeConference");
        if (conference != null) {
            conference.onMerge();
        }
    }

    private final void $$robo$$android_telecom_ConnectionService$swapConference(String callId) {
        Log.d(this, "swapConference(%s)", callId);
        Conference conference = this.findConferenceForAction(callId, "swapConference");
        if (conference != null) {
            conference.onSwap();
        }
    }

    private final void $$robo$$android_telecom_ConnectionService$onPostDialContinue(String callId, boolean proceed) {
        Log.d(this, "onPostDialContinue(%s)", callId);
        this.findConnectionForAction(callId, "stopDtmfTone").onPostDialContinue(proceed);
    }

    private final void $$robo$$android_telecom_ConnectionService$onAdapterAttached() {
        if (this.mAreAccountsInitialized) {
            return;
        }
        this.mAdapter.queryRemoteConnectionServices((RemoteServiceCallback)new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ConnectionService this$0;

            private void $$robo$$android_telecom_ConnectionService_5$__constructor__(ConnectionService connectionService) {
            }

            private final void $$robo$$android_telecom_ConnectionService_5$onResult(List<ComponentName> componentNames, List<IBinder> services) {
                this.this$0.mHandler.post(new Runnable(this, componentNames, services){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ List val$componentNames;
                    /* synthetic */ List val$services;
                    /* synthetic */ 5 this$1;

                    private void $$robo$$android_telecom_ConnectionService_5_1$__constructor__(5 var1_1, List list, List list2) {
                    }

                    private final void $$robo$$android_telecom_ConnectionService_5_1$run() {
                        for (int i = 0; i < this.val$componentNames.size() && i < this.val$services.size(); ++i) {
                            this.this$1.this$0.mRemoteConnectionManager.addConnectionService((ComponentName)this.val$componentNames.get(i), IConnectionService.Stub.asInterface((IBinder)this.val$services.get(i)));
                        }
                        this.this$1.this$0.onAccountsInitialized();
                        Log.d(this, "remote connection services found: " + this.val$services, new Object[0]);
                    }

                    private void __constructor__(5 var1_1, List list, List list2) {
                        this.$$robo$$android_telecom_ConnectionService_5_1$__constructor__(var1_1, list, list2);
                    }
                    {
                        this.this$1 = var1_1;
                        this.val$componentNames = list;
                        this.val$services = list2;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_ConnectionService_5_1$__constructor__(android.telecom.ConnectionService$5 java.util.List java.util.List ), 0, this, var1_1, list, list2);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_ConnectionService_5_1$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            private final void $$robo$$android_telecom_ConnectionService_5$onError() {
                this.this$0.mHandler.post(new Runnable(this){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ 5 this$1;

                    private void $$robo$$android_telecom_ConnectionService_5_2$__constructor__(5 var1_1) {
                    }

                    private final void $$robo$$android_telecom_ConnectionService_5_2$run() {
                        this.this$1.this$0.mAreAccountsInitialized = true;
                    }

                    private void __constructor__(5 var1_1) {
                        this.$$robo$$android_telecom_ConnectionService_5_2$__constructor__(var1_1);
                    }
                    {
                        this.this$1 = var1_1;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_ConnectionService_5_2$__constructor__(android.telecom.ConnectionService$5 ), 0, this, var1_1);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_ConnectionService_5_2$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }

            private void __constructor__(ConnectionService connectionService) {
                this.$$robo$$android_telecom_ConnectionService_5$__constructor__(connectionService);
            }
            {
                this.this$0 = connectionService;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_ConnectionService_5$__constructor__(android.telecom.ConnectionService ), 0, this, connectionService);
            }

            @Override
            public void onResult(List<ComponentName> list, List<IBinder> list2) {
                InvokeDynamicSupport.bootstrap("onResult", $$robo$$android_telecom_ConnectionService_5$onResult(java.util.List<android.content.ComponentName> java.util.List<android.os.IBinder> ), 0, this, list, list2);
            }

            @Override
            public void onError() {
                InvokeDynamicSupport.bootstrap("onError", $$robo$$android_telecom_ConnectionService_5$onError(), 0, this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final RemoteConnection $$robo$$android_telecom_ConnectionService$createRemoteIncomingConnection(PhoneAccountHandle connectionManagerPhoneAccount, ConnectionRequest request) {
        return this.mRemoteConnectionManager.createRemoteConnection(connectionManagerPhoneAccount, request, true);
    }

    private final RemoteConnection $$robo$$android_telecom_ConnectionService$createRemoteOutgoingConnection(PhoneAccountHandle connectionManagerPhoneAccount, ConnectionRequest request) {
        return this.mRemoteConnectionManager.createRemoteConnection(connectionManagerPhoneAccount, request, false);
    }

    private final void $$robo$$android_telecom_ConnectionService$conferenceRemoteConnections(RemoteConnection a, RemoteConnection b) {
        this.mRemoteConnectionManager.conferenceRemoteConnections(a, b);
    }

    private final void $$robo$$android_telecom_ConnectionService$addConference(Conference conference) {
        String id2 = this.addConferenceInternal(conference);
        if (id2 != null) {
            ArrayList<String> connectionIds = new ArrayList<String>(2);
            for (Connection connection : conference.getConnections()) {
                if (!this.mIdByConnection.containsKey(connection)) continue;
                connectionIds.add(this.mIdByConnection.get(connection));
            }
            ParcelableConference parcelableConference = new ParcelableConference(conference.getPhoneAccountHandle(), conference.getState(), conference.getCapabilities(), connectionIds);
            this.mAdapter.addConferenceCall(id2, parcelableConference);
            for (Connection connection : conference.getConnections()) {
                String connectionId = this.mIdByConnection.get(connection);
                if (connectionId == null) continue;
                this.mAdapter.setIsConferenced(connectionId, id2);
            }
        }
    }

    private final Collection<Connection> $$robo$$android_telecom_ConnectionService$getAllConnections() {
        return this.mConnectionById.values();
    }

    private final Connection $$robo$$android_telecom_ConnectionService$onCreateIncomingConnection(PhoneAccountHandle connectionManagerPhoneAccount, ConnectionRequest request) {
        return null;
    }

    private final Connection $$robo$$android_telecom_ConnectionService$onCreateOutgoingConnection(PhoneAccountHandle connectionManagerPhoneAccount, ConnectionRequest request) {
        return null;
    }

    private final Connection $$robo$$android_telecom_ConnectionService$onCreateUnknownConnection(PhoneAccountHandle connectionManagerPhoneAccount, ConnectionRequest request) {
        return null;
    }

    private final void $$robo$$android_telecom_ConnectionService$onConference(Connection connection1, Connection connection2) {
    }

    private final void $$robo$$android_telecom_ConnectionService$onRemoteConferenceAdded(RemoteConference conference) {
    }

    private final boolean $$robo$$android_telecom_ConnectionService$containsConference(Conference conference) {
        return this.mIdByConference.containsKey(conference);
    }

    private final void $$robo$$android_telecom_ConnectionService$addRemoteConference(RemoteConference remoteConference) {
        this.onRemoteConferenceAdded(remoteConference);
    }

    private final void $$robo$$android_telecom_ConnectionService$onAccountsInitialized() {
        this.mAreAccountsInitialized = true;
        for (Runnable r : this.mPreInitializationConnectionRequests) {
            r.run();
        }
        this.mPreInitializationConnectionRequests.clear();
    }

    private final void $$robo$$android_telecom_ConnectionService$addConnection(String callId, Connection connection) {
        this.mConnectionById.put(callId, connection);
        this.mIdByConnection.put(connection, callId);
        connection.addConnectionListener(this.mConnectionListener);
        connection.setConnectionService(this);
    }

    private final void $$robo$$android_telecom_ConnectionService$removeConnection(Connection connection) {
        String id2 = this.mIdByConnection.get(connection);
        connection.unsetConnectionService(this);
        connection.removeConnectionListener(this.mConnectionListener);
        this.mConnectionById.remove(this.mIdByConnection.get(connection));
        this.mIdByConnection.remove(connection);
        this.mAdapter.removeCall(id2);
    }

    private final String $$robo$$android_telecom_ConnectionService$addConferenceInternal(Conference conference) {
        if (this.mIdByConference.containsKey(conference)) {
            Log.w(this, "Re-adding an existing conference: %s.", conference);
        } else if (conference != null) {
            String id2 = UUID.randomUUID().toString();
            this.mConferenceById.put(id2, conference);
            this.mIdByConference.put(conference, id2);
            conference.addListener(this.mConferenceListener);
            return id2;
        }
        return null;
    }

    private final void $$robo$$android_telecom_ConnectionService$removeConference(Conference conference) {
        if (this.mIdByConference.containsKey(conference)) {
            conference.removeListener(this.mConferenceListener);
            String id2 = this.mIdByConference.get(conference);
            this.mConferenceById.remove(id2);
            this.mIdByConference.remove(conference);
            this.mAdapter.removeCall(id2);
        }
    }

    private final Connection $$robo$$android_telecom_ConnectionService$findConnectionForAction(String callId, String action) {
        if (this.mConnectionById.containsKey(callId)) {
            return this.mConnectionById.get(callId);
        }
        Log.w(this, "%s - Cannot find Connection %s", action, callId);
        return ConnectionService.getNullConnection();
    }

    private static final synchronized Connection $$robo$$android_telecom_ConnectionService$getNullConnection() {
        if (sNullConnection == null) {
            sNullConnection = new ShadowedObject(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_telecom_ConnectionService_6$__constructor__() {
                }

                private void __constructor__() {
                    this.$$robo$$android_telecom_ConnectionService_6$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_ConnectionService_6$__constructor__(), 0, this);
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }
        return sNullConnection;
    }

    private final Conference $$robo$$android_telecom_ConnectionService$findConferenceForAction(String conferenceId, String action) {
        if (this.mConferenceById.containsKey(conferenceId)) {
            return this.mConferenceById.get(conferenceId);
        }
        Log.w(this, "%s - Cannot find conference %s", action, conferenceId);
        return this.getNullConference();
    }

    private final List<String> $$robo$$android_telecom_ConnectionService$createConnectionIdList(List<Connection> connections) {
        ArrayList<String> ids = new ArrayList<String>();
        for (Connection c : connections) {
            if (!this.mIdByConnection.containsKey(c)) continue;
            ids.add(this.mIdByConnection.get(c));
        }
        Collections.sort(ids);
        return ids;
    }

    private final Conference $$robo$$android_telecom_ConnectionService$getNullConference() {
        if (this.sNullConference == null) {
            this.sNullConference = new ShadowedObject(this, null){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ ConnectionService this$0;

                private void $$robo$$android_telecom_ConnectionService_7$__constructor__(ConnectionService connectionService, PhoneAccountHandle x0) {
                }

                private void __constructor__(ConnectionService connectionService, PhoneAccountHandle phoneAccountHandle) {
                    this.$$robo$$android_telecom_ConnectionService_7$__constructor__(connectionService, phoneAccountHandle);
                }
                {
                    this.this$0 = connectionService;
                    super(phoneAccountHandle);
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_ConnectionService_7$__constructor__(android.telecom.ConnectionService android.telecom.PhoneAccountHandle ), 0, this, connectionService, phoneAccountHandle);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }
        return this.sNullConference;
    }

    private final void $$robo$$android_telecom_ConnectionService$endAllConnections() {
        for (Connection connection : this.mIdByConnection.keySet()) {
            if (connection.getConference() != null) continue;
            connection.onDisconnect();
        }
        for (Conference conference : this.mIdByConference.keySet()) {
            conference.onDisconnect();
        }
    }

    static void __staticInitializer__() {
        PII_DEBUG = Log.isLoggable(3);
    }

    private void __constructor__() {
        this.$$robo$$android_telecom_ConnectionService$__constructor__();
    }

    public ConnectionService() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_ConnectionService$__constructor__(), 0, this);
    }

    @Override
    public IBinder onBind(Intent intent) {
        return InvokeDynamicSupport.bootstrap("onBind", $$robo$$android_telecom_ConnectionService$onBind(android.content.Intent ), 0, this, intent);
    }

    @Override
    public boolean onUnbind(Intent intent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onUnbind", $$robo$$android_telecom_ConnectionService$onUnbind(android.content.Intent ), 0, this, intent);
    }

    private void createConnection(PhoneAccountHandle phoneAccountHandle, String string2, ConnectionRequest connectionRequest, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("createConnection", $$robo$$android_telecom_ConnectionService$createConnection(android.telecom.PhoneAccountHandle java.lang.String android.telecom.ConnectionRequest boolean boolean ), 0, this, phoneAccountHandle, string2, connectionRequest, bl, bl2);
    }

    private void abort(String string2) {
        InvokeDynamicSupport.bootstrap("abort", $$robo$$android_telecom_ConnectionService$abort(java.lang.String ), 0, this, string2);
    }

    private void answerVideo(String string2, int n) {
        InvokeDynamicSupport.bootstrap("answerVideo", $$robo$$android_telecom_ConnectionService$answerVideo(java.lang.String int ), 0, this, string2, n);
    }

    private void answer(String string2) {
        InvokeDynamicSupport.bootstrap("answer", $$robo$$android_telecom_ConnectionService$answer(java.lang.String ), 0, this, string2);
    }

    private void reject(String string2) {
        InvokeDynamicSupport.bootstrap("reject", $$robo$$android_telecom_ConnectionService$reject(java.lang.String ), 0, this, string2);
    }

    private void disconnect(String string2) {
        InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_telecom_ConnectionService$disconnect(java.lang.String ), 0, this, string2);
    }

    private void hold(String string2) {
        InvokeDynamicSupport.bootstrap("hold", $$robo$$android_telecom_ConnectionService$hold(java.lang.String ), 0, this, string2);
    }

    private void unhold(String string2) {
        InvokeDynamicSupport.bootstrap("unhold", $$robo$$android_telecom_ConnectionService$unhold(java.lang.String ), 0, this, string2);
    }

    private void onAudioStateChanged(String string2, AudioState audioState) {
        InvokeDynamicSupport.bootstrap("onAudioStateChanged", $$robo$$android_telecom_ConnectionService$onAudioStateChanged(java.lang.String android.telecom.AudioState ), 0, this, string2, audioState);
    }

    private void playDtmfTone(String string2, char c) {
        InvokeDynamicSupport.bootstrap("playDtmfTone", $$robo$$android_telecom_ConnectionService$playDtmfTone(java.lang.String char ), 0, this, string2, c);
    }

    private void stopDtmfTone(String string2) {
        InvokeDynamicSupport.bootstrap("stopDtmfTone", $$robo$$android_telecom_ConnectionService$stopDtmfTone(java.lang.String ), 0, this, string2);
    }

    private void conference(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("conference", $$robo$$android_telecom_ConnectionService$conference(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    private void splitFromConference(String string2) {
        InvokeDynamicSupport.bootstrap("splitFromConference", $$robo$$android_telecom_ConnectionService$splitFromConference(java.lang.String ), 0, this, string2);
    }

    private void mergeConference(String string2) {
        InvokeDynamicSupport.bootstrap("mergeConference", $$robo$$android_telecom_ConnectionService$mergeConference(java.lang.String ), 0, this, string2);
    }

    private void swapConference(String string2) {
        InvokeDynamicSupport.bootstrap("swapConference", $$robo$$android_telecom_ConnectionService$swapConference(java.lang.String ), 0, this, string2);
    }

    private void onPostDialContinue(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("onPostDialContinue", $$robo$$android_telecom_ConnectionService$onPostDialContinue(java.lang.String boolean ), 0, this, string2, bl);
    }

    private void onAdapterAttached() {
        InvokeDynamicSupport.bootstrap("onAdapterAttached", $$robo$$android_telecom_ConnectionService$onAdapterAttached(), 0, this);
    }

    public RemoteConnection createRemoteIncomingConnection(PhoneAccountHandle phoneAccountHandle, ConnectionRequest connectionRequest) {
        return InvokeDynamicSupport.bootstrap("createRemoteIncomingConnection", $$robo$$android_telecom_ConnectionService$createRemoteIncomingConnection(android.telecom.PhoneAccountHandle android.telecom.ConnectionRequest ), 0, this, phoneAccountHandle, connectionRequest);
    }

    public RemoteConnection createRemoteOutgoingConnection(PhoneAccountHandle phoneAccountHandle, ConnectionRequest connectionRequest) {
        return InvokeDynamicSupport.bootstrap("createRemoteOutgoingConnection", $$robo$$android_telecom_ConnectionService$createRemoteOutgoingConnection(android.telecom.PhoneAccountHandle android.telecom.ConnectionRequest ), 0, this, phoneAccountHandle, connectionRequest);
    }

    public void conferenceRemoteConnections(RemoteConnection remoteConnection, RemoteConnection remoteConnection2) {
        InvokeDynamicSupport.bootstrap("conferenceRemoteConnections", $$robo$$android_telecom_ConnectionService$conferenceRemoteConnections(android.telecom.RemoteConnection android.telecom.RemoteConnection ), 0, this, remoteConnection, remoteConnection2);
    }

    public void addConference(Conference conference) {
        InvokeDynamicSupport.bootstrap("addConference", $$robo$$android_telecom_ConnectionService$addConference(android.telecom.Conference ), 0, this, conference);
    }

    public Collection<Connection> getAllConnections() {
        return InvokeDynamicSupport.bootstrap("getAllConnections", $$robo$$android_telecom_ConnectionService$getAllConnections(), 0, this);
    }

    public Connection onCreateIncomingConnection(PhoneAccountHandle phoneAccountHandle, ConnectionRequest connectionRequest) {
        return InvokeDynamicSupport.bootstrap("onCreateIncomingConnection", $$robo$$android_telecom_ConnectionService$onCreateIncomingConnection(android.telecom.PhoneAccountHandle android.telecom.ConnectionRequest ), 0, this, phoneAccountHandle, connectionRequest);
    }

    public Connection onCreateOutgoingConnection(PhoneAccountHandle phoneAccountHandle, ConnectionRequest connectionRequest) {
        return InvokeDynamicSupport.bootstrap("onCreateOutgoingConnection", $$robo$$android_telecom_ConnectionService$onCreateOutgoingConnection(android.telecom.PhoneAccountHandle android.telecom.ConnectionRequest ), 0, this, phoneAccountHandle, connectionRequest);
    }

    public Connection onCreateUnknownConnection(PhoneAccountHandle phoneAccountHandle, ConnectionRequest connectionRequest) {
        return InvokeDynamicSupport.bootstrap("onCreateUnknownConnection", $$robo$$android_telecom_ConnectionService$onCreateUnknownConnection(android.telecom.PhoneAccountHandle android.telecom.ConnectionRequest ), 0, this, phoneAccountHandle, connectionRequest);
    }

    public void onConference(Connection connection, Connection connection2) {
        InvokeDynamicSupport.bootstrap("onConference", $$robo$$android_telecom_ConnectionService$onConference(android.telecom.Connection android.telecom.Connection ), 0, this, connection, connection2);
    }

    public void onRemoteConferenceAdded(RemoteConference remoteConference) {
        InvokeDynamicSupport.bootstrap("onRemoteConferenceAdded", $$robo$$android_telecom_ConnectionService$onRemoteConferenceAdded(android.telecom.RemoteConference ), 0, this, remoteConference);
    }

    public boolean containsConference(Conference conference) {
        return (boolean)InvokeDynamicSupport.bootstrap("containsConference", $$robo$$android_telecom_ConnectionService$containsConference(android.telecom.Conference ), 0, this, conference);
    }

    void addRemoteConference(RemoteConference remoteConference) {
        InvokeDynamicSupport.bootstrap("addRemoteConference", $$robo$$android_telecom_ConnectionService$addRemoteConference(android.telecom.RemoteConference ), 0, this, remoteConference);
    }

    private void onAccountsInitialized() {
        InvokeDynamicSupport.bootstrap("onAccountsInitialized", $$robo$$android_telecom_ConnectionService$onAccountsInitialized(), 0, this);
    }

    private void addConnection(String string2, Connection connection) {
        InvokeDynamicSupport.bootstrap("addConnection", $$robo$$android_telecom_ConnectionService$addConnection(java.lang.String android.telecom.Connection ), 0, this, string2, connection);
    }

    private void removeConnection(Connection connection) {
        InvokeDynamicSupport.bootstrap("removeConnection", $$robo$$android_telecom_ConnectionService$removeConnection(android.telecom.Connection ), 0, this, connection);
    }

    private String addConferenceInternal(Conference conference) {
        return InvokeDynamicSupport.bootstrap("addConferenceInternal", $$robo$$android_telecom_ConnectionService$addConferenceInternal(android.telecom.Conference ), 0, this, conference);
    }

    private void removeConference(Conference conference) {
        InvokeDynamicSupport.bootstrap("removeConference", $$robo$$android_telecom_ConnectionService$removeConference(android.telecom.Conference ), 0, this, conference);
    }

    private Connection findConnectionForAction(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("findConnectionForAction", $$robo$$android_telecom_ConnectionService$findConnectionForAction(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    static synchronized Connection getNullConnection() {
        return InvokeDynamicSupport.bootstrapStatic("getNullConnection", $$robo$$android_telecom_ConnectionService$getNullConnection(), 0);
    }

    private Conference findConferenceForAction(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("findConferenceForAction", $$robo$$android_telecom_ConnectionService$findConferenceForAction(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    private List<String> createConnectionIdList(List<Connection> list) {
        return InvokeDynamicSupport.bootstrap("createConnectionIdList", $$robo$$android_telecom_ConnectionService$createConnectionIdList(java.util.List<android.telecom.Connection> ), 0, this, list);
    }

    private Conference getNullConference() {
        return InvokeDynamicSupport.bootstrap("getNullConference", $$robo$$android_telecom_ConnectionService$getNullConference(), 0, this);
    }

    private void endAllConnections() {
        InvokeDynamicSupport.bootstrap("endAllConnections", $$robo$$android_telecom_ConnectionService$endAllConnections(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(ConnectionService.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConnectionService)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

