/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.net.Uri;
import android.os.IBinder;
import android.os.RemoteException;
import android.telecom.Connection;
import android.telecom.ConnectionRequest;
import android.telecom.DisconnectCause;
import android.telecom.Log;
import android.telecom.ParcelableConference;
import android.telecom.ParcelableConnection;
import android.telecom.StatusHints;
import com.android.internal.telecom.IConnectionServiceAdapter;
import com.android.internal.telecom.RemoteServiceCallback;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class ConnectionServiceAdapter
implements IBinder.DeathRecipient,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Set<IConnectionServiceAdapter> mAdapters;

    private void $$robo$$android_telecom_ConnectionServiceAdapter$__constructor__() {
        this.mAdapters = Collections.newSetFromMap(new ConcurrentHashMap(8, 0.9f, 1));
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$addAdapter(IConnectionServiceAdapter adapter) {
        if (this.mAdapters.add(adapter)) {
            try {
                adapter.asBinder().linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                this.mAdapters.remove(adapter);
            }
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$removeAdapter(IConnectionServiceAdapter adapter) {
        if (adapter != null && this.mAdapters.remove(adapter)) {
            adapter.asBinder().unlinkToDeath(this, 0);
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$binderDied() {
        Iterator<IConnectionServiceAdapter> it = this.mAdapters.iterator();
        while (it.hasNext()) {
            IConnectionServiceAdapter adapter = it.next();
            if (adapter.asBinder().isBinderAlive()) continue;
            it.remove();
            adapter.asBinder().unlinkToDeath(this, 0);
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$handleCreateConnectionComplete(String id2, ConnectionRequest request, ParcelableConnection connection) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.handleCreateConnectionComplete(id2, request, connection);
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$setActive(String callId) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.setActive(callId);
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$setRinging(String callId) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.setRinging(callId);
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$setDialing(String callId) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.setDialing(callId);
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$setDisconnected(String callId, DisconnectCause disconnectCause) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.setDisconnected(callId, disconnectCause);
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$setOnHold(String callId) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.setOnHold(callId);
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$setRingbackRequested(String callId, boolean ringback) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.setRingbackRequested(callId, ringback);
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$setCallCapabilities(String callId, int capabilities) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.setCallCapabilities(callId, capabilities);
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$setIsConferenced(String callId, String conferenceCallId) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                Log.d(this, "sending connection %s with conference %s", callId, conferenceCallId);
                adapter.setIsConferenced(callId, conferenceCallId);
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$removeCall(String callId) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.removeCall(callId);
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$onPostDialWait(String callId, String remaining) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.onPostDialWait(callId, remaining);
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$addConferenceCall(String callId, ParcelableConference parcelableConference) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.addConferenceCall(callId, parcelableConference);
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$queryRemoteConnectionServices(RemoteServiceCallback callback) {
        if (this.mAdapters.size() == 1) {
            try {
                this.mAdapters.iterator().next().queryRemoteConnectionServices(callback);
            }
            catch (RemoteException e) {
                Log.e(this, (Throwable)e, "Exception trying to query for remote CSs", new Object[0]);
            }
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$setVideoProvider(String callId, Connection.VideoProvider videoProvider) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.setVideoProvider(callId, videoProvider == null ? null : videoProvider.getInterface());
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$setIsVoipAudioMode(String callId, boolean isVoip) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.setIsVoipAudioMode(callId, isVoip);
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$setStatusHints(String callId, StatusHints statusHints) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.setStatusHints(callId, statusHints);
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$setAddress(String callId, Uri address, int presentation) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.setAddress(callId, address, presentation);
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$setCallerDisplayName(String callId, String callerDisplayName, int presentation) {
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.setCallerDisplayName(callId, callerDisplayName, presentation);
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$setVideoState(String callId, int videoState) {
        Log.v(this, "setVideoState: %d", videoState);
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.setVideoState(callId, videoState);
            }
            catch (RemoteException remoteException) {}
        }
    }

    private final void $$robo$$android_telecom_ConnectionServiceAdapter$setConferenceableConnections(String callId, List<String> conferenceableCallIds) {
        Log.v(this, "setConferenceableConnections: %s, %s", callId, conferenceableCallIds);
        for (IConnectionServiceAdapter adapter : this.mAdapters) {
            try {
                adapter.setConferenceableConnections(callId, conferenceableCallIds);
            }
            catch (RemoteException remoteException) {}
        }
    }

    private void __constructor__() {
        this.$$robo$$android_telecom_ConnectionServiceAdapter$__constructor__();
    }

    ConnectionServiceAdapter() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_ConnectionServiceAdapter$__constructor__(), 0, this);
    }

    void addAdapter(IConnectionServiceAdapter iConnectionServiceAdapter) {
        InvokeDynamicSupport.bootstrap("addAdapter", $$robo$$android_telecom_ConnectionServiceAdapter$addAdapter(com.android.internal.telecom.IConnectionServiceAdapter ), 0, this, iConnectionServiceAdapter);
    }

    void removeAdapter(IConnectionServiceAdapter iConnectionServiceAdapter) {
        InvokeDynamicSupport.bootstrap("removeAdapter", $$robo$$android_telecom_ConnectionServiceAdapter$removeAdapter(com.android.internal.telecom.IConnectionServiceAdapter ), 0, this, iConnectionServiceAdapter);
    }

    @Override
    public void binderDied() {
        InvokeDynamicSupport.bootstrap("binderDied", $$robo$$android_telecom_ConnectionServiceAdapter$binderDied(), 0, this);
    }

    void handleCreateConnectionComplete(String string2, ConnectionRequest connectionRequest, ParcelableConnection parcelableConnection) {
        InvokeDynamicSupport.bootstrap("handleCreateConnectionComplete", $$robo$$android_telecom_ConnectionServiceAdapter$handleCreateConnectionComplete(java.lang.String android.telecom.ConnectionRequest android.telecom.ParcelableConnection ), 0, this, string2, connectionRequest, parcelableConnection);
    }

    void setActive(String string2) {
        InvokeDynamicSupport.bootstrap("setActive", $$robo$$android_telecom_ConnectionServiceAdapter$setActive(java.lang.String ), 0, this, string2);
    }

    void setRinging(String string2) {
        InvokeDynamicSupport.bootstrap("setRinging", $$robo$$android_telecom_ConnectionServiceAdapter$setRinging(java.lang.String ), 0, this, string2);
    }

    void setDialing(String string2) {
        InvokeDynamicSupport.bootstrap("setDialing", $$robo$$android_telecom_ConnectionServiceAdapter$setDialing(java.lang.String ), 0, this, string2);
    }

    void setDisconnected(String string2, DisconnectCause disconnectCause) {
        InvokeDynamicSupport.bootstrap("setDisconnected", $$robo$$android_telecom_ConnectionServiceAdapter$setDisconnected(java.lang.String android.telecom.DisconnectCause ), 0, this, string2, disconnectCause);
    }

    void setOnHold(String string2) {
        InvokeDynamicSupport.bootstrap("setOnHold", $$robo$$android_telecom_ConnectionServiceAdapter$setOnHold(java.lang.String ), 0, this, string2);
    }

    void setRingbackRequested(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("setRingbackRequested", $$robo$$android_telecom_ConnectionServiceAdapter$setRingbackRequested(java.lang.String boolean ), 0, this, string2, bl);
    }

    void setCallCapabilities(String string2, int n) {
        InvokeDynamicSupport.bootstrap("setCallCapabilities", $$robo$$android_telecom_ConnectionServiceAdapter$setCallCapabilities(java.lang.String int ), 0, this, string2, n);
    }

    void setIsConferenced(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setIsConferenced", $$robo$$android_telecom_ConnectionServiceAdapter$setIsConferenced(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    void removeCall(String string2) {
        InvokeDynamicSupport.bootstrap("removeCall", $$robo$$android_telecom_ConnectionServiceAdapter$removeCall(java.lang.String ), 0, this, string2);
    }

    void onPostDialWait(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("onPostDialWait", $$robo$$android_telecom_ConnectionServiceAdapter$onPostDialWait(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    void addConferenceCall(String string2, ParcelableConference parcelableConference) {
        InvokeDynamicSupport.bootstrap("addConferenceCall", $$robo$$android_telecom_ConnectionServiceAdapter$addConferenceCall(java.lang.String android.telecom.ParcelableConference ), 0, this, string2, parcelableConference);
    }

    void queryRemoteConnectionServices(RemoteServiceCallback remoteServiceCallback) {
        InvokeDynamicSupport.bootstrap("queryRemoteConnectionServices", $$robo$$android_telecom_ConnectionServiceAdapter$queryRemoteConnectionServices(com.android.internal.telecom.RemoteServiceCallback ), 0, this, remoteServiceCallback);
    }

    void setVideoProvider(String string2, Connection.VideoProvider videoProvider) {
        InvokeDynamicSupport.bootstrap("setVideoProvider", $$robo$$android_telecom_ConnectionServiceAdapter$setVideoProvider(java.lang.String android.telecom.Connection$VideoProvider ), 0, this, string2, videoProvider);
    }

    void setIsVoipAudioMode(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("setIsVoipAudioMode", $$robo$$android_telecom_ConnectionServiceAdapter$setIsVoipAudioMode(java.lang.String boolean ), 0, this, string2, bl);
    }

    void setStatusHints(String string2, StatusHints statusHints) {
        InvokeDynamicSupport.bootstrap("setStatusHints", $$robo$$android_telecom_ConnectionServiceAdapter$setStatusHints(java.lang.String android.telecom.StatusHints ), 0, this, string2, statusHints);
    }

    void setAddress(String string2, Uri uri, int n) {
        InvokeDynamicSupport.bootstrap("setAddress", $$robo$$android_telecom_ConnectionServiceAdapter$setAddress(java.lang.String android.net.Uri int ), 0, this, string2, uri, n);
    }

    void setCallerDisplayName(String string2, String string3, int n) {
        InvokeDynamicSupport.bootstrap("setCallerDisplayName", $$robo$$android_telecom_ConnectionServiceAdapter$setCallerDisplayName(java.lang.String java.lang.String int ), 0, this, string2, string3, n);
    }

    void setVideoState(String string2, int n) {
        InvokeDynamicSupport.bootstrap("setVideoState", $$robo$$android_telecom_ConnectionServiceAdapter$setVideoState(java.lang.String int ), 0, this, string2, n);
    }

    void setConferenceableConnections(String string2, List<String> list) {
        InvokeDynamicSupport.bootstrap("setConferenceableConnections", $$robo$$android_telecom_ConnectionServiceAdapter$setConferenceableConnections(java.lang.String java.util.List<java.lang.String> ), 0, this, string2, list);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConnectionServiceAdapter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

