/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.telecom.Log;
import android.telecom.PhoneAccountHandle;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.MissingResourceException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PhoneAccount
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int CAPABILITY_CONNECTION_MANAGER = 1;
    public static int CAPABILITY_CALL_PROVIDER = 2;
    public static int CAPABILITY_SIM_SUBSCRIPTION = 4;
    public static int CAPABILITY_VIDEO_CALLING = 8;
    public static int CAPABILITY_PLACE_EMERGENCY_CALLS = 16;
    public static String SCHEME_TEL = "tel";
    public static String SCHEME_VOICEMAIL = "voicemail";
    public static String SCHEME_SIP = "sip";
    private PhoneAccountHandle mAccountHandle;
    private Uri mAddress;
    private Uri mSubscriptionAddress;
    private int mCapabilities;
    private int mIconResId;
    private CharSequence mLabel;
    private CharSequence mShortDescription;
    private List<String> mSupportedUriSchemes;
    public static Parcelable.Creator<PhoneAccount> CREATOR;

    private void $$robo$$android_telecom_PhoneAccount$__constructor__(PhoneAccountHandle account, Uri address, Uri subscriptionAddress, int capabilities, int iconResId, CharSequence label, CharSequence shortDescription, List<String> supportedUriSchemes) {
        this.mAccountHandle = account;
        this.mAddress = address;
        this.mSubscriptionAddress = subscriptionAddress;
        this.mCapabilities = capabilities;
        this.mIconResId = iconResId;
        this.mLabel = label;
        this.mShortDescription = shortDescription;
        this.mSupportedUriSchemes = Collections.unmodifiableList(supportedUriSchemes);
    }

    private static final Builder $$robo$$android_telecom_PhoneAccount$builder(PhoneAccountHandle accountHandle, CharSequence label) {
        return new Builder(accountHandle, label);
    }

    private final Builder $$robo$$android_telecom_PhoneAccount$toBuilder() {
        return new Builder(this);
    }

    private final PhoneAccountHandle $$robo$$android_telecom_PhoneAccount$getAccountHandle() {
        return this.mAccountHandle;
    }

    private final Uri $$robo$$android_telecom_PhoneAccount$getAddress() {
        return this.mAddress;
    }

    private final Uri $$robo$$android_telecom_PhoneAccount$getSubscriptionAddress() {
        return this.mSubscriptionAddress;
    }

    private final int $$robo$$android_telecom_PhoneAccount$getCapabilities() {
        return this.mCapabilities;
    }

    private final boolean $$robo$$android_telecom_PhoneAccount$hasCapabilities(int capability) {
        return (this.mCapabilities & capability) == capability;
    }

    private final CharSequence $$robo$$android_telecom_PhoneAccount$getLabel() {
        return this.mLabel;
    }

    private final CharSequence $$robo$$android_telecom_PhoneAccount$getShortDescription() {
        return this.mShortDescription;
    }

    private final List<String> $$robo$$android_telecom_PhoneAccount$getSupportedUriSchemes() {
        return this.mSupportedUriSchemes;
    }

    private final boolean $$robo$$android_telecom_PhoneAccount$supportsUriScheme(String uriScheme) {
        if (this.mSupportedUriSchemes == null || uriScheme == null) {
            return false;
        }
        for (String scheme : this.mSupportedUriSchemes) {
            if (scheme == null || !scheme.equals(uriScheme)) continue;
            return true;
        }
        return false;
    }

    private final int $$robo$$android_telecom_PhoneAccount$getIconResId() {
        return this.mIconResId;
    }

    private final Drawable $$robo$$android_telecom_PhoneAccount$getIcon(Context context) {
        return this.getIcon(context, this.mIconResId);
    }

    private final Drawable $$robo$$android_telecom_PhoneAccount$getIcon(Context context, int resId) {
        Context packageContext;
        try {
            packageContext = context.createPackageContext(this.mAccountHandle.getComponentName().getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w(this, "Cannot find package %s", this.mAccountHandle.getComponentName().getPackageName());
            return null;
        }
        try {
            return packageContext.getDrawable(resId);
        }
        catch (Resources.NotFoundException | MissingResourceException e) {
            Log.e(this, (Throwable)e, "Cannot find icon %d in package %s", resId, this.mAccountHandle.getComponentName().getPackageName());
            return null;
        }
    }

    private final int $$robo$$android_telecom_PhoneAccount$describeContents() {
        return 0;
    }

    private final void $$robo$$android_telecom_PhoneAccount$writeToParcel(Parcel out, int flags) {
        out.writeParcelable(this.mAccountHandle, 0);
        out.writeParcelable(this.mAddress, 0);
        out.writeParcelable(this.mSubscriptionAddress, 0);
        out.writeInt(this.mCapabilities);
        out.writeInt(this.mIconResId);
        out.writeCharSequence(this.mLabel);
        out.writeCharSequence(this.mShortDescription);
        out.writeList(this.mSupportedUriSchemes);
    }

    private void $$robo$$android_telecom_PhoneAccount$__constructor__(Parcel in) {
        ClassLoader classLoader = PhoneAccount.class.getClassLoader();
        this.mAccountHandle = (PhoneAccountHandle)in.readParcelable(this.getClass().getClassLoader());
        this.mAddress = (Uri)in.readParcelable(this.getClass().getClassLoader());
        this.mSubscriptionAddress = (Uri)in.readParcelable(this.getClass().getClassLoader());
        this.mCapabilities = in.readInt();
        this.mIconResId = in.readInt();
        this.mLabel = in.readCharSequence();
        this.mShortDescription = in.readCharSequence();
        ArrayList supportedUriSchemes = new ArrayList();
        in.readList(supportedUriSchemes, classLoader);
        this.mSupportedUriSchemes = Collections.unmodifiableList(supportedUriSchemes);
    }

    private /* synthetic */ void $$robo$$android_telecom_PhoneAccount$__constructor__(PhoneAccountHandle x0, Uri x1, Uri x2, int x3, int x4, CharSequence x5, CharSequence x6, List x7, 1 x8) {
    }

    private /* synthetic */ void $$robo$$android_telecom_PhoneAccount$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<PhoneAccount>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_telecom_PhoneAccount_1$__constructor__() {
            }

            private final PhoneAccount $$robo$$android_telecom_PhoneAccount_1$createFromParcel(Parcel in) {
                return new PhoneAccount(in);
            }

            private final PhoneAccount[] $$robo$$android_telecom_PhoneAccount_1$newArray(int size) {
                return new PhoneAccount[size];
            }

            private void __constructor__() {
                this.$$robo$$android_telecom_PhoneAccount_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_PhoneAccount_1$__constructor__(), 0, this);
            }

            @Override
            public PhoneAccount createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_telecom_PhoneAccount_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public PhoneAccount[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_telecom_PhoneAccount_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(PhoneAccountHandle phoneAccountHandle, Uri uri, Uri uri2, int n, int n2, CharSequence charSequence, CharSequence charSequence2, List<String> list) {
        this.$$robo$$android_telecom_PhoneAccount$__constructor__(phoneAccountHandle, uri, uri2, n, n2, charSequence, charSequence2, list);
    }

    private PhoneAccount(PhoneAccountHandle phoneAccountHandle, Uri uri, Uri uri2, int n, int n2, CharSequence charSequence, CharSequence charSequence2, List<String> list) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_PhoneAccount$__constructor__(android.telecom.PhoneAccountHandle android.net.Uri android.net.Uri int int java.lang.CharSequence java.lang.CharSequence java.util.List<java.lang.String> ), 0, this, phoneAccountHandle, uri, uri2, n, n2, charSequence, charSequence2, list);
    }

    public static Builder builder(PhoneAccountHandle phoneAccountHandle, CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrapStatic("builder", $$robo$$android_telecom_PhoneAccount$builder(android.telecom.PhoneAccountHandle java.lang.CharSequence ), 0, (PhoneAccountHandle)phoneAccountHandle, (CharSequence)charSequence);
    }

    public Builder toBuilder() {
        return InvokeDynamicSupport.bootstrap("toBuilder", $$robo$$android_telecom_PhoneAccount$toBuilder(), 0, this);
    }

    public PhoneAccountHandle getAccountHandle() {
        return InvokeDynamicSupport.bootstrap("getAccountHandle", $$robo$$android_telecom_PhoneAccount$getAccountHandle(), 0, this);
    }

    public Uri getAddress() {
        return InvokeDynamicSupport.bootstrap("getAddress", $$robo$$android_telecom_PhoneAccount$getAddress(), 0, this);
    }

    public Uri getSubscriptionAddress() {
        return InvokeDynamicSupport.bootstrap("getSubscriptionAddress", $$robo$$android_telecom_PhoneAccount$getSubscriptionAddress(), 0, this);
    }

    public int getCapabilities() {
        return (int)InvokeDynamicSupport.bootstrap("getCapabilities", $$robo$$android_telecom_PhoneAccount$getCapabilities(), 0, this);
    }

    public boolean hasCapabilities(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCapabilities", $$robo$$android_telecom_PhoneAccount$hasCapabilities(int ), 0, this, n);
    }

    public CharSequence getLabel() {
        return InvokeDynamicSupport.bootstrap("getLabel", $$robo$$android_telecom_PhoneAccount$getLabel(), 0, this);
    }

    public CharSequence getShortDescription() {
        return InvokeDynamicSupport.bootstrap("getShortDescription", $$robo$$android_telecom_PhoneAccount$getShortDescription(), 0, this);
    }

    public List<String> getSupportedUriSchemes() {
        return InvokeDynamicSupport.bootstrap("getSupportedUriSchemes", $$robo$$android_telecom_PhoneAccount$getSupportedUriSchemes(), 0, this);
    }

    public boolean supportsUriScheme(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("supportsUriScheme", $$robo$$android_telecom_PhoneAccount$supportsUriScheme(java.lang.String ), 0, this, string2);
    }

    public int getIconResId() {
        return (int)InvokeDynamicSupport.bootstrap("getIconResId", $$robo$$android_telecom_PhoneAccount$getIconResId(), 0, this);
    }

    public Drawable getIcon(Context context) {
        return InvokeDynamicSupport.bootstrap("getIcon", $$robo$$android_telecom_PhoneAccount$getIcon(android.content.Context ), 0, this, context);
    }

    private Drawable getIcon(Context context, int n) {
        return InvokeDynamicSupport.bootstrap("getIcon", $$robo$$android_telecom_PhoneAccount$getIcon(android.content.Context int ), 0, this, context, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_telecom_PhoneAccount$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_telecom_PhoneAccount$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_telecom_PhoneAccount$__constructor__(parcel);
    }

    private PhoneAccount(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_PhoneAccount$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    private /* synthetic */ void __constructor__(PhoneAccountHandle phoneAccountHandle, Uri uri, Uri uri2, int n, int n2, CharSequence charSequence, CharSequence charSequence2, List list, 1 var9_9) {
        this.$$robo$$android_telecom_PhoneAccount$__constructor__(phoneAccountHandle, uri, uri2, n, n2, charSequence, charSequence2, list, var9_9);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_telecom_PhoneAccount$__constructor__(parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(PhoneAccount.class);
    }

    public /* synthetic */ PhoneAccount() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PhoneAccount)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private PhoneAccountHandle mAccountHandle;
        private Uri mAddress;
        private Uri mSubscriptionAddress;
        private int mCapabilities;
        private int mIconResId;
        private CharSequence mLabel;
        private CharSequence mShortDescription;
        private List<String> mSupportedUriSchemes;

        private void $$robo$$android_telecom_PhoneAccount_Builder$__constructor__(PhoneAccountHandle accountHandle, CharSequence label) {
            this.mSupportedUriSchemes = new ArrayList<String>();
            this.mAccountHandle = accountHandle;
            this.mLabel = label;
        }

        private void $$robo$$android_telecom_PhoneAccount_Builder$__constructor__(PhoneAccount phoneAccount) {
            this.mSupportedUriSchemes = new ArrayList<String>();
            this.mAccountHandle = phoneAccount.getAccountHandle();
            this.mAddress = phoneAccount.getAddress();
            this.mSubscriptionAddress = phoneAccount.getSubscriptionAddress();
            this.mCapabilities = phoneAccount.getCapabilities();
            this.mIconResId = phoneAccount.getIconResId();
            this.mLabel = phoneAccount.getLabel();
            this.mShortDescription = phoneAccount.getShortDescription();
            this.mSupportedUriSchemes.addAll(phoneAccount.getSupportedUriSchemes());
        }

        private final Builder $$robo$$android_telecom_PhoneAccount_Builder$setAddress(Uri value) {
            this.mAddress = value;
            return this;
        }

        private final Builder $$robo$$android_telecom_PhoneAccount_Builder$setSubscriptionAddress(Uri value) {
            this.mSubscriptionAddress = value;
            return this;
        }

        private final Builder $$robo$$android_telecom_PhoneAccount_Builder$setCapabilities(int value) {
            this.mCapabilities = value;
            return this;
        }

        private final Builder $$robo$$android_telecom_PhoneAccount_Builder$setIconResId(int value) {
            this.mIconResId = value;
            return this;
        }

        private final Builder $$robo$$android_telecom_PhoneAccount_Builder$setShortDescription(CharSequence value) {
            this.mShortDescription = value;
            return this;
        }

        private final Builder $$robo$$android_telecom_PhoneAccount_Builder$addSupportedUriScheme(String uriScheme) {
            if (!TextUtils.isEmpty(uriScheme) && !this.mSupportedUriSchemes.contains(uriScheme)) {
                this.mSupportedUriSchemes.add(uriScheme);
            }
            return this;
        }

        private final Builder $$robo$$android_telecom_PhoneAccount_Builder$setSupportedUriSchemes(List<String> uriSchemes) {
            this.mSupportedUriSchemes.clear();
            if (uriSchemes != null && !uriSchemes.isEmpty()) {
                for (String uriScheme : uriSchemes) {
                    this.addSupportedUriScheme(uriScheme);
                }
            }
            return this;
        }

        private final PhoneAccount $$robo$$android_telecom_PhoneAccount_Builder$build() {
            if (this.mSupportedUriSchemes.isEmpty()) {
                this.addSupportedUriScheme("tel");
            }
            return new PhoneAccount(this.mAccountHandle, this.mAddress, this.mSubscriptionAddress, this.mCapabilities, this.mIconResId, this.mLabel, this.mShortDescription, this.mSupportedUriSchemes);
        }

        private void __constructor__(PhoneAccountHandle phoneAccountHandle, CharSequence charSequence) {
            this.$$robo$$android_telecom_PhoneAccount_Builder$__constructor__(phoneAccountHandle, charSequence);
        }

        public Builder(PhoneAccountHandle phoneAccountHandle, CharSequence charSequence) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_PhoneAccount_Builder$__constructor__(android.telecom.PhoneAccountHandle java.lang.CharSequence ), 0, this, phoneAccountHandle, charSequence);
        }

        private void __constructor__(PhoneAccount phoneAccount) {
            this.$$robo$$android_telecom_PhoneAccount_Builder$__constructor__(phoneAccount);
        }

        public Builder(PhoneAccount phoneAccount) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_PhoneAccount_Builder$__constructor__(android.telecom.PhoneAccount ), 0, this, phoneAccount);
        }

        public Builder setAddress(Uri uri) {
            return InvokeDynamicSupport.bootstrap("setAddress", $$robo$$android_telecom_PhoneAccount_Builder$setAddress(android.net.Uri ), 0, this, uri);
        }

        public Builder setSubscriptionAddress(Uri uri) {
            return InvokeDynamicSupport.bootstrap("setSubscriptionAddress", $$robo$$android_telecom_PhoneAccount_Builder$setSubscriptionAddress(android.net.Uri ), 0, this, uri);
        }

        public Builder setCapabilities(int n) {
            return InvokeDynamicSupport.bootstrap("setCapabilities", $$robo$$android_telecom_PhoneAccount_Builder$setCapabilities(int ), 0, this, n);
        }

        public Builder setIconResId(int n) {
            return InvokeDynamicSupport.bootstrap("setIconResId", $$robo$$android_telecom_PhoneAccount_Builder$setIconResId(int ), 0, this, n);
        }

        public Builder setShortDescription(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setShortDescription", $$robo$$android_telecom_PhoneAccount_Builder$setShortDescription(java.lang.CharSequence ), 0, this, charSequence);
        }

        public Builder addSupportedUriScheme(String string2) {
            return InvokeDynamicSupport.bootstrap("addSupportedUriScheme", $$robo$$android_telecom_PhoneAccount_Builder$addSupportedUriScheme(java.lang.String ), 0, this, string2);
        }

        public Builder setSupportedUriSchemes(List<String> list) {
            return InvokeDynamicSupport.bootstrap("setSupportedUriSchemes", $$robo$$android_telecom_PhoneAccount_Builder$setSupportedUriSchemes(java.util.List<java.lang.String> ), 0, this, list);
        }

        public PhoneAccount build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_telecom_PhoneAccount_Builder$build(), 0, this);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

